
#include <src/MainWindow.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <config.h>
#include "src/SettingsDialog.h"
#include "src/Settings.h"
#include "src/Preferences.h"
#include "src/DefaultPaths.h"
#include "src/SendProgressDialog.h"
#include "src/SendChooserDialog.h"
#include "src/ReceiveProgressDialog.h"
#include "src/ReceiveChooserDialog.h"
#include "src/PreferencesDialog.h"
#include "src/SerialConnection.h"
#include "src/HexTextBuffer.h"
#include "src/XmodemFilenameDialog.h"
#include "src/Rzwrapper.h"
#include "src/Szwrapper.h"
#include "src/Profile.h"
#include "src/InputParser.h"
#include "src/MoUtils.h"
#include "src/AutoScroll.h"




static glong string_get_length (const char* self);
struct _moserialMainWindowPrivate {
	GtkBuilder* _builder;
	GtkWindow* gtkWindow;
	moserialSettingsDialog* settingsDialog;
	GtkToolButton* settingsButton;
	GtkToggleToolButton* recordButton;
	Settings* currentSettings;
	Preferences* currentPreferences;
	DefaultPaths* currentPaths;
	GtkStatusbar* statusbar;
	GtkStatusbar* bytecountbar;
	guint statusbarContext;
	guint bytecountbarContext;
	GtkToolButton* send;
	moserialSendProgressDialog* sendProgressDialog;
	moserialSendChooserDialog* sendChooserDialog;
	GtkToolButton* receive;
	moserialReceiveProgressDialog* receiveProgressDialog;
	moserialReceiveChooserDialog* receiveChooserDialog;
	moserialRecordDialog* recordDialog;
	moserialPreferencesDialog* preferencesDialog;
	moserialSerialConnection* serialConnection;
	GtkTextView* incomingHexTextView;
	GtkTextView* incomingAsciiTextView;
	GtkTextView* outgoingHexTextView;
	GtkTextView* outgoingAsciiTextView;
	GtkComboBox* inputMode;
	GtkComboBox* terminationMode;
	GtkToggleToolButton* connectButton;
	GtkLabel* disconnectLabel;
	GtkLabel* connectLabel;
	GtkLabel* recordLabel;
	GtkLabel* stopRecordingLabel;
	GtkPaned* paned;
	GtkNotebook* incoming_notebook;
	GtkNotebook* outgoing_notebook;
	moserialHexTextBuffer* incomingHexTextBuffer;
	moserialHexTextBuffer* outgoingHexTextBuffer;
	GtkTextBuffer* incomingAsciiTextBuffer;
	GtkTextTag* echoTag;
	GtkTextBuffer* outgoingAsciiTextBuffer;
	GtkTextMark* echoStartMark;
	moserialXmodemFilenameDialog* xmodemFilenameDialog;
	GtkEntry* entry;
	GtkButton* sendButton;
	moserialSerialStreamRecorder* streamRecorder;
	gboolean recordDataReceived;
	guint recordTimeoutID;
	moserialRzwrapper* rz;
	moserialSzwrapper* sz;
	Profile* profile;
	char* _startupProfileFilename;
	char* profileFilename;
	gboolean profileChanged;
	GtkAction* cutMenuItem;
	GtkAction* copyMenuItem;
};

#define MOSERIAL_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_MAIN_WINDOW, moserialMainWindowPrivate))
enum  {
	MOSERIAL_MAIN_WINDOW_DUMMY_PROPERTY,
	MOSERIAL_MAIN_WINDOW_BUILDER,
	MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME
};
#define MOSERIAL_MAIN_WINDOW_translators N_ ("translator-credits")
static void moserial_main_window_insertBufferEnd (moserialMainWindow* self, GtkTextBuffer* buf, const char* s);
static void moserial_main_window_doSendChooser (moserialMainWindow* self, GtkToolButton* button);
static void _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status (moserialSzwrapper* _sender, const char* newStatus, gpointer self);
static void _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled (moserialSendProgressDialog* _sender, gpointer self);
static void _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete (moserialSzwrapper* _sender, gpointer self);
static void moserial_main_window_doSend (moserialMainWindow* self, moserialSendChooserDialog* dialog);
static void moserial_main_window_doReceiveChooser (moserialMainWindow* self, GtkToolButton* button);
static void _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status (moserialRzwrapper* _sender, const char* newStatus, gpointer self);
static void _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled (moserialReceiveProgressDialog* _sender, gpointer self);
static void _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete (moserialRzwrapper* _sender, gpointer self);
static void moserial_main_window_doReceive (moserialMainWindow* self, moserialReceiveChooserDialog* dialog);
static void moserial_main_window_updateSettings (moserialMainWindow* self, moserialSettingsDialog* d, Settings* newSettings);
static void moserial_main_window_updatePreferences (moserialMainWindow* self, moserialPreferencesDialog* d, Preferences* newPreferences);
static void moserial_main_window_showSettingsDialog (moserialMainWindow* self, GObject* o);
static void moserial_main_window_showPreferencesDialog (moserialMainWindow* self, GObject* o);
static void _moserial_main_window_updateIncoming_moserial_serial_connection_new_data (moserialSerialConnection* _sender, guchar* data, int data_length1, gint size, gpointer self);
static gboolean moserial_main_window_startConnection (moserialMainWindow* self);
static void moserial_main_window_doConnect (moserialMainWindow* self, GtkToggleToolButton* button);
static gboolean _moserial_main_window_recordTimeout_gsource_func (gpointer self);
static void moserial_main_window_updateIncoming (moserialMainWindow* self, moserialSerialConnection* sc, guchar* data, int data_length1, gint size);
static void moserial_main_window_inputModeChanged (moserialMainWindow* self, GtkComboBox* inputMode);
static void moserial_main_window_showHelpButton (moserialMainWindow* self, GtkToolButton* button);
static void moserial_main_window_showHelpAction (moserialMainWindow* self, GtkAction* a);
static void moserial_main_window_showHelp (moserialMainWindow* self);
static void _moserial_main_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void moserial_main_window_showAboutDialog (moserialMainWindow* self);
static void moserial_main_window_url_hook (moserialMainWindow* self, GtkAboutDialog* about, const char* link);
static void moserial_main_window_quitSizeSave (moserialMainWindow* self);
static gboolean moserial_main_window_deleteSaveSize (moserialMainWindow* self, GtkWidget* widget, const GdkEvent* event);
static void moserial_main_window_windowSizeSave (moserialMainWindow* self);
static void moserial_main_window_quitSave (moserialMainWindow* self);
static void moserial_main_window_saveProfile (moserialMainWindow* self);
static void moserial_main_window_saveProfileAs (moserialMainWindow* self);
static void moserial_main_window_loadProfileOnStartup (moserialMainWindow* self, const char* profileFilename);
static void moserial_main_window_loadProfile (moserialMainWindow* self);
static void moserial_main_window_copy (moserialMainWindow* self);
static void moserial_main_window_cut (moserialMainWindow* self);
static void moserial_main_window_editMenu (moserialMainWindow* self, GtkAction* a);
static void moserial_main_window_paste (moserialMainWindow* self);
static void moserial_main_window_clear (moserialMainWindow* self);
static void moserial_main_window_set_builder (moserialMainWindow* self, GtkBuilder* value);
static void moserial_main_window_set_startupProfileFilename (moserialMainWindow* self, const char* value);
static void _moserial_main_window_quitSave_gtk_object_destroy (GtkWindow* _sender, gpointer self);
static gboolean _moserial_main_window_deleteSaveSize_gtk_widget_delete_event (GtkWindow* _sender, const GdkEvent* event, gpointer self);
static void _moserial_main_window_quitSizeSave_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_saveProfileAs_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_saveProfile_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_loadProfile_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_copy_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_editMenu_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_cut_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_paste_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_clear_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings (moserialSettingsDialog* _sender, Settings* settings, gpointer self);
static void _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_showHelpButton_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_showAboutDialog_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_doSendChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer (moserialSendChooserDialog* _sender, gpointer self);
static void _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer (moserialReceiveChooserDialog* _sender, gpointer self);
static void _moserial_main_window_record_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self);
static void _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording (moserialRecordDialog* _sender, gpointer self);
static void _moserial_main_window_startRecording_moserial_record_dialog_start_recording (moserialRecordDialog* _sender, const char* fileName, moserialSerialStreamRecorderDirection direction, gpointer self);
static void _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences (moserialPreferencesDialog* _sender, Preferences* preferences, gpointer self);
static void _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _moserial_main_window_doConnect_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self);
static void _moserial_main_window_showHelpAction_gtk_action_activate (GtkAction* _sender, gpointer self);
static void _moserial_main_window_sendString_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_main_window_sendString_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _moserial_main_window_inputModeChanged_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static GObject * moserial_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_main_window_parent_class = NULL;
static void moserial_main_window_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const char* MOSERIAL_MAIN_WINDOW_authors[] = {"Michael J. Chudobiak <mjc@svn.gnome.org>", "marlodavampire", NULL};
static const char* MOSERIAL_MAIN_WINDOW_license[] = {N_ ("moserial is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n"), N_ ("moserial is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n"), N_ ("You should have received a copy of the GNU General Public License along with this program.  If not, see <http://www.gnu.org/licenses/>.")};


static glong string_get_length (const char* self) {
	g_return_val_if_fail (self != NULL, 0L);
	return g_utf8_strlen (self, -1);
}


moserialMainWindow* moserial_main_window_construct (GType object_type, GtkBuilder* builder, const char* profileFilename) {
	GParameter * __params;
	GParameter * __params_it;
	moserialMainWindow * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	__params_it->name = "startupProfileFilename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, profileFilename);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialMainWindow* moserial_main_window_new (GtkBuilder* builder, const char* profileFilename) {
	return moserial_main_window_construct (MOSERIAL_TYPE_MAIN_WINDOW, builder, profileFilename);
}


static void moserial_main_window_insertBufferEnd (moserialMainWindow* self, GtkTextBuffer* buf, const char* s) {
	GtkTextIter iter = {0};
	gint i;
	GString* builder;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buf != NULL);
	g_return_if_fail (s != NULL);
	i = 0;
	builder = g_string_new ("");
	for (i = 0; i < string_get_length (s); i++) {
		gunichar c;
		gboolean _tmp0;
		c = g_utf8_get_char (s);
		_tmp0 = FALSE;
		if (g_unichar_isprint (c)) {
			_tmp0 = TRUE;
		} else {
			_tmp0 = g_unichar_isspace (c);
		}
		if (_tmp0) {
			g_string_append_unichar (builder, c);
		}
		s = g_utf8_next_char (s);
	}
	gtk_text_buffer_get_end_iter (buf, &iter);
	gtk_text_buffer_insert (buf, &iter, builder->str, (gint) string_get_length (builder->str));
	(builder == NULL) ? NULL : (builder = (g_string_free (builder, TRUE), NULL));
}


void moserial_main_window_sendString (moserialMainWindow* self, GtkWidget* w) {
	GError * inner_error;
	char* s;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	glong len;
	char* _tmp13;
	char* _tmp14;
	GtkTextIter echoStartIter = {0};
	GtkTextMark* _tmp16;
	GtkTextMark* _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	inner_error = NULL;
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	s = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	s = (_tmp1 = (_tmp0 = gtk_entry_get_text (self->priv->entry), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), s = (g_free (s), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->serialConnection->echoReference = (_tmp3 = (_tmp2 = s, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->priv->serialConnection->echoReference = (g_free (self->priv->serialConnection->echoReference), NULL), _tmp3);
	len = 0L;
	if (gtk_combo_box_get_active (self->priv->inputMode) == 0) {
		char* t;
		len = string_get_length (s);
		{
			gint x;
			x = 0;
			for (; x < len; x++) {
				char* _tmp4;
				char* _tmp6;
				const char* _tmp5;
				moserial_serial_connection_sendByte (self->priv->serialConnection, (guchar) g_utf8_get_char (s));
				moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, (guchar) g_utf8_get_char (s));
				moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, (guchar) g_utf8_get_char (s));
				_tmp4 = NULL;
				moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp4 = g_strdup_printf ("%c", (gint) ((guchar) g_utf8_get_char (s))));
				_tmp4 = (g_free (_tmp4), NULL);
				_tmp6 = NULL;
				_tmp5 = NULL;
				s = (_tmp6 = (_tmp5 = g_utf8_next_char (s), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), s = (g_free (s), NULL), _tmp6);
			}
		}
		t = moserial_serial_connection_getLineEnd (self->priv->serialConnection, gtk_combo_box_get_active (self->priv->terminationMode));
		len = string_get_length (t);
		{
			gint x;
			x = 0;
			for (; x < len; x++) {
				char* _tmp9;
				const char* _tmp8;
				moserial_serial_connection_sendByte (self->priv->serialConnection, (guchar) g_utf8_get_char (t));
				moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, (guchar) g_utf8_get_char (t));
				moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, (guchar) g_utf8_get_char (t));
				/* Just display the first byte of the terminator in the ASCII window,
				                                   so that CRLF doesn't cause two line advances. */
				if (x == 0) {
					char* _tmp7;
					_tmp7 = NULL;
					moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp7 = g_strdup_printf ("%c", (gint) ((guchar) g_utf8_get_char (t))));
					_tmp7 = (g_free (_tmp7), NULL);
				}
				_tmp9 = NULL;
				_tmp8 = NULL;
				t = (_tmp9 = (_tmp8 = g_utf8_next_char (t), (_tmp8 == NULL) ? NULL : g_strdup (_tmp8)), t = (g_free (t), NULL), _tmp9);
			}
		}
		t = (g_free (t), NULL);
	} else {
		{
			guchar* _tmp11;
			gint h_size;
			gint h_length1;
			gint _tmp10;
			guchar* h;
			_tmp11 = NULL;
			h = (_tmp11 = input_parser_parseHex (s, &_tmp10, &inner_error), h_length1 = _tmp10, h_size = h_length1, _tmp11);
			if (inner_error != NULL) {
				if (inner_error->domain == HEX_PARSE_ERROR) {
					goto __catch0_hex_parse_error;
				}
				goto __finally0;
			}
			len = (glong) h_length1;
			{
				gint x;
				x = 0;
				for (; x < len; x++) {
					char* _tmp12;
					moserial_serial_connection_sendByte (self->priv->serialConnection, h[x]);
					moserial_serial_stream_recorder_writeOutgoing (self->priv->streamRecorder, h[x]);
					moserial_hex_text_buffer_add (self->priv->outgoingHexTextBuffer, h[x]);
					_tmp12 = NULL;
					moserial_main_window_insertBufferEnd (self, self->priv->outgoingAsciiTextBuffer, _tmp12 = g_strdup_printf ("%c", (gint) h[x]));
					_tmp12 = (g_free (_tmp12), NULL);
				}
			}
			h = (g_free (h), NULL);
		}
		goto __finally0;
		__catch0_hex_parse_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				GtkMessageDialog* errorDialog;
				errorDialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, e->message, NULL));
				gtk_dialog_run ((GtkDialog*) errorDialog);
				gtk_object_destroy ((GtkObject*) errorDialog);
				(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
				(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
			}
		}
		__finally0:
		if (inner_error != NULL) {
			s = (g_free (s), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
			g_clear_error (&inner_error);
			return;
		}
	}
	gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
	_tmp13 = NULL;
	gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp13 = moserial_serial_connection_getBytecountbarString (self->priv->serialConnection));
	_tmp13 = (g_free (_tmp13), NULL);
	gtk_entry_set_text (self->priv->entry, "");
	/* Start listening for an echo */
	_tmp14 = NULL;
	self->priv->serialConnection->echoCompare = (_tmp14 = g_strdup (""), self->priv->serialConnection->echoCompare = (g_free (self->priv->serialConnection->echoCompare), NULL), _tmp14);
	gtk_text_buffer_get_end_iter (self->priv->incomingAsciiTextBuffer, &echoStartIter);
	_tmp16 = NULL;
	_tmp15 = NULL;
	self->priv->echoStartMark = (_tmp16 = (_tmp15 = gtk_text_buffer_create_mark (self->priv->incomingAsciiTextBuffer, "echo", &echoStartIter, TRUE), (_tmp15 == NULL) ? NULL : g_object_ref (_tmp15)), (self->priv->echoStartMark == NULL) ? NULL : (self->priv->echoStartMark = (g_object_unref (self->priv->echoStartMark), NULL)), _tmp16);
	s = (g_free (s), NULL);
}


static void moserial_main_window_doSendChooser (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	moserial_send_chooser_dialog_show (self->priv->sendChooserDialog, default_paths_get_sendFrom (self->priv->currentPaths));
}


static void _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status (moserialSzwrapper* _sender, const char* newStatus, gpointer self) {
	moserial_send_progress_dialog_updateStatus (self, _sender, newStatus);
}


static void _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled (moserialSendProgressDialog* _sender, gpointer self) {
	moserial_szwrapper_transferCanceled (self, _sender);
}


static void _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete (moserialSzwrapper* _sender, gpointer self) {
	moserial_main_window_sendComplete (self, _sender);
}


static void moserial_main_window_doSend (moserialMainWindow* self, moserialSendChooserDialog* dialog) {
	moserialSzwrapperProtocol protocol;
	char* filename;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp2;
	moserialSzwrapper* _tmp3;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	protocol = 0;
	filename = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	filename = (_tmp1 = (_tmp0 = dialog->filename, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), filename = (g_free (filename), NULL), _tmp1);
	_tmp2 = NULL;
	default_paths_set_sendFrom (self->priv->currentPaths, _tmp2 = mo_utils_getParentFolder (filename));
	_tmp2 = (g_free (_tmp2), NULL);
	switch (gtk_combo_box_get_active (dialog->protocolCombo)) {
		case 0:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM;
			break;
		}
		case 1:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
			break;
		}
		default:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
			break;
		}
		case 3:
		{
			protocol = MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
			break;
		}
	}
	_tmp3 = NULL;
	self->priv->sz = (_tmp3 = moserial_szwrapper_new (&protocol, self->priv->serialConnection, filename), (self->priv->sz == NULL) ? NULL : (self->priv->sz = (g_object_unref (self->priv->sz), NULL)), _tmp3);
	if (self->priv->sz->running) {
		moserial_send_progress_dialog_show (self->priv->sendProgressDialog);
		g_signal_connect_object (self->priv->sz, "update-status", (GCallback) _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status, self->priv->sendProgressDialog, 0);
		g_signal_connect_object (self->priv->sendProgressDialog, "transfer-canceled", (GCallback) _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled, self->priv->sz, 0);
		g_signal_connect_object (self->priv->sz, "transfer-complete", (GCallback) _moserial_main_window_sendComplete_moserial_szwrapper_transfer_complete, self, 0);
	}
	filename = (g_free (filename), NULL);
}


void moserial_main_window_sendComplete (moserialMainWindow* self, GObject* o) {
	guint _tmp0;
	guint _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_signal_handlers_disconnect_matched (self->priv->sz, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("update-status", MOSERIAL_TYPE_SZWRAPPER, &_tmp0, NULL, FALSE), _tmp0), 0, NULL, (GCallback) _moserial_send_progress_dialog_updateStatus_moserial_szwrapper_update_status, self->priv->sendProgressDialog);
	g_signal_handlers_disconnect_matched (self->priv->sendProgressDialog, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("transfer-canceled", MOSERIAL_TYPE_SEND_PROGRESS_DIALOG, &_tmp1, NULL, FALSE), _tmp1), 0, NULL, (GCallback) _moserial_szwrapper_transferCanceled_moserial_send_progress_dialog_transfer_canceled, self->priv->sz);
	moserial_send_progress_dialog_hide (self->priv->sendProgressDialog, (GObject*) self->priv->sendProgressDialog);
}


static void moserial_main_window_doReceiveChooser (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (!moserial_main_window_ensureConnected (self)) {
		return;
	}
	moserial_receive_chooser_dialog_show (self->priv->receiveChooserDialog, default_paths_get_receiveTo (self->priv->currentPaths));
}


static void _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status (moserialRzwrapper* _sender, const char* newStatus, gpointer self) {
	moserial_receive_progress_dialog_updateStatus (self, _sender, newStatus);
}


static void _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled (moserialReceiveProgressDialog* _sender, gpointer self) {
	moserial_rzwrapper_transferCanceled (self, _sender);
}


static void _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete (moserialRzwrapper* _sender, gpointer self) {
	moserial_main_window_receiveComplete (self, _sender);
}


static void moserial_main_window_doReceive (moserialMainWindow* self, moserialReceiveChooserDialog* dialog) {
	char* filename;
	moserialRzwrapperProtocol protocol;
	moserialRzwrapper* _tmp2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	filename = g_strdup ("");
	default_paths_set_receiveTo (self->priv->currentPaths, dialog->path);
	if (gtk_combo_box_get_active (dialog->protocolCombo) == 0) {
		char* _tmp1;
		const char* _tmp0;
		/*get the filename for xmodem*/
		moserial_xmodem_filename_dialog_show (self->priv->xmodemFilenameDialog);
		_tmp1 = NULL;
		_tmp0 = NULL;
		filename = (_tmp1 = (_tmp0 = self->priv->xmodemFilenameDialog->filename, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), filename = (g_free (filename), NULL), _tmp1);
	}
	protocol = 0;
	switch (gtk_combo_box_get_active (dialog->protocolCombo)) {
		case 0:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM;
			break;
		}
		case 1:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM;
			break;
		}
		default:
		{
			protocol = MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM;
			break;
		}
	}
	_tmp2 = NULL;
	self->priv->rz = (_tmp2 = moserial_rzwrapper_new (&protocol, self->priv->serialConnection, dialog->path, filename), (self->priv->rz == NULL) ? NULL : (self->priv->rz = (g_object_unref (self->priv->rz), NULL)), _tmp2);
	if (self->priv->rz->running) {
		moserial_receive_progress_dialog_show (self->priv->receiveProgressDialog);
		g_signal_connect_object (self->priv->rz, "update-status", (GCallback) _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status, self->priv->receiveProgressDialog, 0);
		g_signal_connect_object (self->priv->receiveProgressDialog, "transfer-canceled", (GCallback) _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled, self->priv->rz, 0);
		g_signal_connect_object (self->priv->rz, "transfer-complete", (GCallback) _moserial_main_window_receiveComplete_moserial_rzwrapper_transfer_complete, self, 0);
	}
	filename = (g_free (filename), NULL);
}


void moserial_main_window_receiveComplete (moserialMainWindow* self, GObject* o) {
	guint _tmp0;
	guint _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_signal_handlers_disconnect_matched (self->priv->rz, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("update-status", MOSERIAL_TYPE_RZWRAPPER, &_tmp0, NULL, FALSE), _tmp0), 0, NULL, (GCallback) _moserial_receive_progress_dialog_updateStatus_moserial_rzwrapper_update_status, self->priv->receiveProgressDialog);
	g_signal_handlers_disconnect_matched (self->priv->receiveProgressDialog, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("transfer-canceled", MOSERIAL_TYPE_RECEIVE_PROGRESS_DIALOG, &_tmp1, NULL, FALSE), _tmp1), 0, NULL, (GCallback) _moserial_rzwrapper_transferCanceled_moserial_receive_progress_dialog_transfer_canceled, self->priv->rz);
	moserial_receive_progress_dialog_hide (self->priv->receiveProgressDialog, (GObject*) self->priv->receiveProgressDialog);
}


void moserial_main_window_record (moserialMainWindow* self, GtkToggleToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_tool_button_get_active (button)) {
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->stopRecordingLabel);
		moserial_record_dialog_show (self->priv->recordDialog, default_paths_get_recordTo (self->priv->currentPaths));
	} else {
		moserial_serial_stream_recorder_close (self->priv->streamRecorder, preferences_get_recordLaunch (self->priv->currentPreferences));
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->recordLabel);
		if (self->priv->recordTimeoutID > 0) {
			g_source_remove (self->priv->recordTimeoutID);
			self->priv->recordTimeoutID = (guint) 0;
		}
	}
}


void moserial_main_window_stopRecording (moserialMainWindow* self, moserialRecordDialog* dialog) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
}


/*this generates recordButton.clicked signal*/
void moserial_main_window_startRecording (moserialMainWindow* self, moserialRecordDialog* dialog, const char* filename, moserialSerialStreamRecorderDirection direction) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (filename != NULL);
	inner_error = NULL;
	{
		char* _tmp0;
		moserial_serial_stream_recorder_open (self->priv->streamRecorder, filename, direction, &inner_error);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		_tmp0 = NULL;
		default_paths_set_recordTo (self->priv->currentPaths, _tmp0 = mo_utils_getParentFolder (filename));
		_tmp0 = (g_free (_tmp0), NULL);
		if (!moserial_main_window_ensureConnected (self)) {
			moserial_main_window_stopRecording (self, dialog);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char* _tmp1;
			GtkMessageDialog* _tmp2;
			GtkMessageDialog* errorDialog;
			g_warning (_ ("Error: Could not open %s\n"), filename);
			_tmp1 = NULL;
			_tmp2 = NULL;
			errorDialog = (_tmp2 = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp1 = g_strdup_printf ("%s: %s\n%s", _ ("Error: Could not open file"), filename, e->message), NULL)), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
			gtk_dialog_run ((GtkDialog*) errorDialog);
			gtk_object_destroy ((GtkObject*) errorDialog);
			moserial_main_window_stopRecording (self, dialog);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(errorDialog == NULL) ? NULL : (errorDialog = (g_object_unref (errorDialog), NULL));
		}
	}
	__finally1:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


gboolean moserial_main_window_recordTimeout (moserialMainWindow* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
	return FALSE;
}


void moserial_main_window_showWindow (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->gtkWindow);
}


static void moserial_main_window_updateSettings (moserialMainWindow* self, moserialSettingsDialog* d, Settings* newSettings) {
	Settings* _tmp1;
	Settings* _tmp0;
	char* _tmp2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (newSettings != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->currentSettings = (_tmp1 = (_tmp0 = newSettings, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp1);
	gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
	_tmp2 = NULL;
	gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp2 = settings_getStatusbarString (self->priv->currentSettings, FALSE));
	_tmp2 = (g_free (_tmp2), NULL);
	self->priv->profileChanged = TRUE;
}


static void moserial_main_window_updatePreferences (moserialMainWindow* self, moserialPreferencesDialog* d, Preferences* newPreferences) {
	Preferences* _tmp1;
	Preferences* _tmp0;
	char* font;
	PangoFontDescription* _tmp5;
	GdkColor _tmp6 = {0};
	GdkColor _tmp7 = {0};
	PangoFontDescription* _tmp8;
	GdkColor _tmp9 = {0};
	GdkColor _tmp10 = {0};
	PangoFontDescription* _tmp11;
	GdkColor _tmp12 = {0};
	GdkColor _tmp13 = {0};
	PangoFontDescription* _tmp14;
	GdkColor _tmp15 = {0};
	GdkColor _tmp16 = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (newPreferences != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->currentPreferences = (_tmp1 = (_tmp0 = newPreferences, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL)), _tmp1);
	font = NULL;
	if (preferences_get_useSystemMonospaceFont (self->priv->currentPreferences)) {
		char* _tmp2;
		_tmp2 = NULL;
		font = (_tmp2 = preferences_getSystemDefaultMonospaceFont (), font = (g_free (font), NULL), _tmp2);
	} else {
		char* _tmp4;
		const char* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		font = (_tmp4 = (_tmp3 = preferences_get_font (self->priv->currentPreferences), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), font = (g_free (font), NULL), _tmp4);
	}
	_tmp5 = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->incomingAsciiTextView, _tmp5 = pango_font_description_from_string (font));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (pango_font_description_free (_tmp5), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->incomingAsciiTextView, GTK_STATE_NORMAL, (_tmp6 = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp6));
	gtk_widget_modify_base ((GtkWidget*) self->priv->incomingAsciiTextView, GTK_STATE_NORMAL, (_tmp7 = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp7));
	g_object_set (self->priv->echoTag, "foreground", preferences_get_highlightColor (self->priv->currentPreferences), NULL);
	_tmp8 = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->incomingHexTextView, _tmp8 = pango_font_description_from_string (font));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (pango_font_description_free (_tmp8), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->incomingHexTextView, GTK_STATE_NORMAL, (_tmp9 = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp9));
	gtk_widget_modify_base ((GtkWidget*) self->priv->incomingHexTextView, GTK_STATE_NORMAL, (_tmp10 = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp10));
	moserial_hex_text_buffer_applyPreferences (self->priv->incomingHexTextBuffer, self->priv->currentPreferences);
	_tmp11 = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingAsciiTextView, _tmp11 = pango_font_description_from_string (font));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (pango_font_description_free (_tmp11), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->outgoingAsciiTextView, GTK_STATE_NORMAL, (_tmp12 = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp12));
	gtk_widget_modify_base ((GtkWidget*) self->priv->outgoingAsciiTextView, GTK_STATE_NORMAL, (_tmp13 = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp13));
	_tmp14 = NULL;
	gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingHexTextView, _tmp14 = pango_font_description_from_string (font));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (pango_font_description_free (_tmp14), NULL));
	gtk_widget_modify_text ((GtkWidget*) self->priv->outgoingHexTextView, GTK_STATE_NORMAL, (_tmp15 = preferences_getGdkColor (preferences_get_fontColor (self->priv->currentPreferences)), &_tmp15));
	gtk_widget_modify_base ((GtkWidget*) self->priv->outgoingHexTextView, GTK_STATE_NORMAL, (_tmp16 = preferences_getGdkColor (preferences_get_backgroundColor (self->priv->currentPreferences)), &_tmp16));
	moserial_hex_text_buffer_applyPreferences (self->priv->outgoingHexTextBuffer, self->priv->currentPreferences);
	self->priv->profileChanged = TRUE;
	font = (g_free (font), NULL);
}


static void moserial_main_window_showSettingsDialog (moserialMainWindow* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	moserial_settings_dialog_show (self->priv->settingsDialog, self->priv->currentSettings);
}


static void moserial_main_window_showPreferencesDialog (moserialMainWindow* self, GObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	moserial_preferences_dialog_show (self->priv->preferencesDialog, self->priv->currentPreferences, gtk_toggle_tool_button_get_active (self->priv->recordButton));
}


gboolean moserial_main_window_ensureConnected (moserialMainWindow* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	if (!gtk_toggle_tool_button_get_active (self->priv->connectButton)) {
		gtk_toggle_tool_button_set_active (self->priv->connectButton, TRUE);
	}
	/* Is this a race condition? We want to know if the
	                   set_active attempt was successful. */
	return gtk_toggle_tool_button_get_active (self->priv->connectButton);
}


void moserial_main_window_ensureDisconnected (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (gtk_toggle_tool_button_get_active (self->priv->connectButton)) {
		gtk_toggle_tool_button_set_active (self->priv->connectButton, FALSE);
	}
}


static void _moserial_main_window_updateIncoming_moserial_serial_connection_new_data (moserialSerialConnection* _sender, guchar* data, int data_length1, gint size, gpointer self) {
	moserial_main_window_updateIncoming (self, _sender, data, data_length1, size);
}


static gboolean moserial_main_window_startConnection (moserialMainWindow* self) {
	char* _tmp3;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!moserial_serial_connection_doConnect (self->priv->serialConnection, self->priv->currentSettings)) {
		char* _tmp0;
		GtkMessageDialog* _tmp1;
		GtkMessageDialog* dialog;
		gboolean _tmp2;
		gtk_toggle_tool_button_set_active (self->priv->connectButton, FALSE);
		g_warning (_ ("Error: Could not open %s\n"), settings_get_device (self->priv->currentSettings));
		_tmp0 = NULL;
		_tmp1 = NULL;
		dialog = (_tmp1 = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp0 = g_strdup_printf ("%s: %s", _ ("Error: Could not open device"), settings_get_device (self->priv->currentSettings)), NULL)), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		gtk_dialog_run ((GtkDialog*) dialog);
		gtk_object_destroy ((GtkObject*) dialog);
		return (_tmp2 = FALSE, (dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL)), _tmp2);
	}
	moserial_hex_text_buffer_clear (self->priv->incomingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->incomingAsciiTextBuffer, "", 0);
	moserial_hex_text_buffer_clear (self->priv->outgoingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->outgoingAsciiTextBuffer, "", 0);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->settingsButton, FALSE);
	gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
	_tmp3 = NULL;
	gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp3 = settings_getStatusbarString (self->priv->currentSettings, TRUE));
	_tmp3 = (g_free (_tmp3), NULL);
	g_signal_connect_object (self->priv->serialConnection, "new-data", (GCallback) _moserial_main_window_updateIncoming_moserial_serial_connection_new_data, self, 0);
	gtk_tool_button_set_label_widget ((GtkToolButton*) self->priv->connectButton, (GtkWidget*) self->priv->disconnectLabel);
	return TRUE;
}


static void moserial_main_window_doConnect (moserialMainWindow* self, GtkToggleToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_tool_button_get_active (button)) {
		moserial_main_window_startConnection (self);
	} else {
		guint _tmp0;
		char* _tmp1;
		char* _tmp2;
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->settingsButton, TRUE);
		moserial_serial_connection_doDisconnect (self->priv->serialConnection);
		g_signal_handlers_disconnect_matched (self->priv->serialConnection, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, (g_signal_parse_name ("new-data", MOSERIAL_TYPE_SERIAL_CONNECTION, &_tmp0, NULL, FALSE), _tmp0), 0, NULL, (GCallback) _moserial_main_window_updateIncoming_moserial_serial_connection_new_data, self);
		gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
		_tmp1 = NULL;
		gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp1 = moserial_serial_connection_getBytecountbarString (self->priv->serialConnection));
		_tmp1 = (g_free (_tmp1), NULL);
		/*serialConnection = new SerialConnection();*/
		gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
		_tmp2 = NULL;
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp2 = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_tmp2 = (g_free (_tmp2), NULL);
		gtk_tool_button_set_label_widget ((GtkToolButton*) button, (GtkWidget*) self->priv->connectLabel);
		if (gtk_toggle_tool_button_get_active (self->priv->recordButton)) {
			gtk_toggle_tool_button_set_active (self->priv->recordButton, FALSE);
		}
	}
}


static gboolean _moserial_main_window_recordTimeout_gsource_func (gpointer self) {
	return moserial_main_window_recordTimeout (self);
}


static void moserial_main_window_updateIncoming (moserialMainWindow* self, moserialSerialConnection* sc, guchar* data, int data_length1, gint size) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sc != NULL);
	if (self->priv->rz->running) {
		{
			gint x;
			x = 0;
			for (; x < size; x++) {
				moserial_rzwrapper_writeChar (self->priv->rz, data[x]);
			}
		}
		moserial_rzwrapper_flush (self->priv->rz);
	} else {
		if (self->priv->sz->running) {
			{
				gint x;
				x = 0;
				for (; x < size; x++) {
					moserial_szwrapper_writeChar (self->priv->sz, data[x]);
				}
			}
		} else {
			{
				gint x;
				x = 0;
				for (; x < size; x++) {
					char* _tmp0;
					gunichar _tmp1;
					gunichar c;
					char* s;
					gboolean _tmp3;
					gboolean _tmp6;
					gboolean _tmp9;
					gboolean _tmp10;
					gboolean _tmp11;
					gboolean _tmp12;
					char* _tmp13;
					moserial_hex_text_buffer_add (self->priv->incomingHexTextBuffer, data[x]);
					_tmp0 = NULL;
					c = (_tmp1 = g_utf8_get_char (_tmp0 = g_strdup_printf ("%c", (gint) data[x])), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
					s = g_strdup_printf ("%c", (gint) data[x]);
					/* Keep a record of any possible echo */
					if (string_get_length (sc->echoCompare) < string_get_length (sc->echoReference)) {
						char* _tmp2;
						_tmp2 = NULL;
						sc->echoCompare = (_tmp2 = g_strconcat (sc->echoCompare, s, NULL), sc->echoCompare = (g_free (sc->echoCompare), NULL), _tmp2);
					}
					_tmp3 = FALSE;
					if (g_utf8_validate (s, -1, NULL)) {
						gboolean _tmp4;
						_tmp4 = FALSE;
						if (g_unichar_isprint (c)) {
							_tmp4 = TRUE;
						} else {
							_tmp4 = g_unichar_isspace (c);
						}
						_tmp3 = _tmp4;
					} else {
						_tmp3 = FALSE;
					}
					if (_tmp3) {
						gboolean _tmp5;
						_tmp5 = FALSE;
						if (sc->lastRxCharWasCR) {
							_tmp5 = c == '\n';
						} else {
							_tmp5 = FALSE;
						}
						/* Ignore LF if last char was CR (CRLF terminator) */
						if (!_tmp5) {
							moserial_main_window_insertBufferEnd (self, self->priv->incomingAsciiTextBuffer, s);
						}
					} else {
						sc->nonprintable = sc->nonprintable + 1;
					}
					sc->lastRxCharWasCR = c == '\r';
					_tmp6 = FALSE;
					if (string_get_length (sc->echoCompare) > 0) {
						_tmp6 = string_get_length (sc->echoCompare) == string_get_length (sc->echoReference);
					} else {
						_tmp6 = FALSE;
					}
					/* Highlight any text that is an exact echo of the last transmission */
					if (_tmp6) {
						char* _tmp7;
						char* _tmp8;
						if (_vala_strcmp0 (sc->echoCompare, sc->echoReference) == 0) {
							GtkTextIter echoStartIter = {0};
							GtkTextIter echoStopIter = {0};
							gtk_text_buffer_get_iter_at_mark (self->priv->incomingAsciiTextBuffer, &echoStartIter, self->priv->echoStartMark);
							gtk_text_buffer_get_end_iter (self->priv->incomingAsciiTextBuffer, &echoStopIter);
							gtk_text_buffer_apply_tag_by_name (self->priv->incomingAsciiTextBuffer, "echo", &echoStartIter, &echoStopIter);
						}
						_tmp7 = NULL;
						sc->echoCompare = (_tmp7 = g_strdup (""), sc->echoCompare = (g_free (sc->echoCompare), NULL), _tmp7);
						_tmp8 = NULL;
						sc->echoReference = (_tmp8 = g_strdup (""), sc->echoReference = (g_free (sc->echoReference), NULL), _tmp8);
					}
					_tmp9 = FALSE;
					_tmp10 = FALSE;
					_tmp11 = FALSE;
					if (sc->rx > 32) {
						_tmp11 = sc->nonprintable > 0;
					} else {
						_tmp11 = FALSE;
					}
					if (_tmp11) {
						_tmp10 = (sc->rx / sc->nonprintable) < 4;
					} else {
						_tmp10 = FALSE;
					}
					if (_tmp10) {
						_tmp9 = !sc->forced_hex_view;
					} else {
						_tmp9 = FALSE;
					}
					/* Auto-select hex view for binary data */
					if (_tmp9) {
						sc->forced_hex_view = TRUE;
						gtk_notebook_set_current_page (self->priv->incoming_notebook, 1);
					}
					_tmp12 = FALSE;
					if (preferences_get_enableTimeout (self->priv->currentPreferences)) {
						_tmp12 = gtk_toggle_tool_button_get_active (self->priv->recordButton);
					} else {
						_tmp12 = FALSE;
					}
					if (_tmp12) {
						if (self->priv->recordTimeoutID > 0) {
							g_source_remove (self->priv->recordTimeoutID);
						}
						if (preferences_get_timeout (self->priv->currentPreferences) > 0) {
							self->priv->recordTimeoutID = g_timeout_add_seconds ((guint) preferences_get_timeout (self->priv->currentPreferences), _moserial_main_window_recordTimeout_gsource_func, self);
						}
					}
					moserial_serial_stream_recorder_writeIncoming (self->priv->streamRecorder, data[x]);
					self->priv->recordDataReceived = TRUE;
					gtk_statusbar_pop (self->priv->bytecountbar, self->priv->bytecountbarContext);
					_tmp13 = NULL;
					gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _tmp13 = moserial_serial_connection_getBytecountbarString (sc));
					_tmp13 = (g_free (_tmp13), NULL);
					s = (g_free (s), NULL);
				}
			}
		}
	}
}


static void moserial_main_window_inputModeChanged (moserialMainWindow* self, GtkComboBox* inputMode) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (inputMode != NULL);
	if (gtk_combo_box_get_active (inputMode) == 1) {
		gtk_notebook_set_current_page (self->priv->outgoing_notebook, 1);
	} else {
		gtk_notebook_set_current_page (self->priv->outgoing_notebook, 0);
	}
}


/* ASCII*/
static void moserial_main_window_showHelpButton (moserialMainWindow* self, GtkToolButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	moserial_main_window_showHelp (self);
}


static void moserial_main_window_showHelpAction (moserialMainWindow* self, GtkAction* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	moserial_main_window_showHelp (self);
}


static void moserial_main_window_showHelp (moserialMainWindow* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		gtk_show_uri (NULL, "ghelp:moserial", (guint32) GDK_CURRENT_TIME, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (_ ("Unable to display help file: %s"), e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void _moserial_main_window_url_hook_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	moserial_main_window_url_hook (self, about, link_);
}


static void moserial_main_window_showAboutDialog (moserialMainWindow* self) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	char* _tmp3;
	char* license_trans;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	license_trans = (_tmp3 = g_strconcat (_tmp2 = g_strconcat (_tmp1 = g_strconcat (_tmp0 = g_strconcat (MOSERIAL_MAIN_WINDOW_license[0], "\n", NULL), MOSERIAL_MAIN_WINDOW_license[1], NULL), "\n", NULL), MOSERIAL_MAIN_WINDOW_license[2], NULL), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp3);
	gtk_about_dialog_set_url_hook (_moserial_main_window_url_hook_gtk_about_dialog_activate_link_func, g_object_ref (self), g_object_unref);
	gtk_show_about_dialog (self->priv->gtkWindow, "version", VERSION, "copyright", "Copyright © 2009\nMichael J. Chudobiak\n<mjc@svn.gnome.org>", "comments", _ ("A serial terminal for the GNOME desktop, optimized for logging and file capture."), "authors", MOSERIAL_MAIN_WINDOW_authors, "translator-credits", MOSERIAL_MAIN_WINDOW_translators, "logo-icon-name", "moserial", "wrap-license", TRUE, "license", license_trans, "website", "http://live.gnome.org/moserial", NULL, NULL);
	license_trans = (g_free (license_trans), NULL);
}


static void moserial_main_window_url_hook (moserialMainWindow* self, GtkAboutDialog* about, const char* link) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	inner_error = NULL;
	{
		gtk_show_uri (NULL, link, (guint32) GDK_CURRENT_TIME, &inner_error);
		if (inner_error != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning (_ ("Can't display a clickable URL: %s"), e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally3:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void moserial_main_window_quitSizeSave (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	moserial_main_window_windowSizeSave (self);
	moserial_main_window_quitSave (self);
}


static gboolean moserial_main_window_deleteSaveSize (moserialMainWindow* self, GtkWidget* widget, const GdkEvent* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	moserial_main_window_windowSizeSave (self);
	moserial_main_window_quitSave (self);
	gtk_main_quit ();
	return TRUE;
}


static void moserial_main_window_windowSizeSave (moserialMainWindow* self) {
	gint width;
	gint height;
	gint pos;
	g_return_if_fail (self != NULL);
	width = 0;
	height = 0;
	pos = gtk_paned_get_position (self->priv->paned);
	gtk_window_get_size (self->priv->gtkWindow, &width, &height);
	profile_saveWindowSize (self->priv->profile, width, height);
	profile_saveWindowPanedPosition (self->priv->profile, pos);
}


static void moserial_main_window_quitSave (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	preferences_saveToProfile (self->priv->currentPreferences, self->priv->profile);
	settings_saveToProfile (self->priv->currentSettings, self->priv->profile);
	default_paths_saveToProfile (self->priv->currentPaths, self->priv->profile);
	if (self->priv->profileFilename != NULL) {
		if (self->priv->profileChanged) {
			GtkMessageDialog* dialog;
			gint response;
			dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->priv->gtkWindow, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _ ("You have changed your setting or preferences. Do you want to save these changes to the loaded profile?"), NULL));
			response = gtk_dialog_run ((GtkDialog*) dialog);
			if (response == GTK_RESPONSE_YES) {
				moserial_main_window_saveProfile (self);
			}
			gtk_object_destroy ((GtkObject*) dialog);
			(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
		} else {
			/* Save the profile even if settings or preferences have not
			                                   changed, to save the default file locations */
			moserial_main_window_saveProfile (self);
		}
	}
	profile_save (self->priv->profile, NULL, self->priv->gtkWindow);
	gtk_main_quit ();
}


static void moserial_main_window_saveProfile (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	preferences_saveToProfile (self->priv->currentPreferences, self->priv->profile);
	settings_saveToProfile (self->priv->currentSettings, self->priv->profile);
	default_paths_saveToProfile (self->priv->currentPaths, self->priv->profile);
	if (self->priv->profileFilename == NULL) {
		moserial_main_window_saveProfileAs (self);
	}
	if (self->priv->profileFilename == NULL) {
		return;
	}
	profile_save (self->priv->profile, self->priv->profileFilename, self->priv->gtkWindow);
	self->priv->profileChanged = FALSE;
}


static void moserial_main_window_saveProfileAs (moserialMainWindow* self) {
	GtkFileChooserDialog* dialog;
	gint response;
	g_return_if_fail (self != NULL);
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (NULL, self->priv->gtkWindow, GTK_FILE_CHOOSER_ACTION_SAVE, NULL));
	gtk_dialog_add_buttons ((GtkDialog*) dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) dialog, TRUE);
	gtk_file_chooser_set_local_only ((GtkFileChooser*) dialog, FALSE);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp1;
		const char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->profileFilename = (_tmp1 = (_tmp0 = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->priv->profileFilename = (g_free (self->priv->profileFilename), NULL), _tmp1);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		moserial_main_window_saveProfile (self);
	}
	(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
}


static void moserial_main_window_loadProfileOnStartup (moserialMainWindow* self, const char* profileFilename) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (profileFilename != NULL);
	if (profile_load (self->priv->profile, profileFilename, self->priv->gtkWindow)) {
		Settings* _tmp0;
		Preferences* _tmp1;
		DefaultPaths* _tmp2;
		char* _tmp3;
		char* _tmp5;
		char* _tmp4;
		char* _tmp7;
		const char* _tmp6;
		moserial_main_window_ensureDisconnected (self);
		_tmp0 = NULL;
		self->priv->currentSettings = (_tmp0 = settings_loadFromProfile (self->priv->profile), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp0);
		_tmp1 = NULL;
		self->priv->currentPreferences = (_tmp1 = preferences_loadFromProfile (self->priv->profile), (self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL)), _tmp1);
		_tmp2 = NULL;
		self->priv->currentPaths = (_tmp2 = default_paths_loadFromProfile (self->priv->profile), (self->priv->currentPaths == NULL) ? NULL : (self->priv->currentPaths = (g_object_unref (self->priv->currentPaths), NULL)), _tmp2);
		moserial_main_window_updatePreferences (self, NULL, self->priv->currentPreferences);
		gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
		_tmp3 = NULL;
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp3 = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		gtk_window_set_title (self->priv->gtkWindow, _tmp5 = g_strdup_printf ("moserial - %s", _tmp4 = g_path_get_basename (profileFilename)));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp4 = (g_free (_tmp4), NULL);
		self->priv->profileChanged = FALSE;
		_tmp7 = NULL;
		_tmp6 = NULL;
		self->priv->profileFilename = (_tmp7 = (_tmp6 = profileFilename, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)), self->priv->profileFilename = (g_free (self->priv->profileFilename), NULL), _tmp7);
	}
}


static void moserial_main_window_loadProfile (moserialMainWindow* self) {
	GtkFileChooserDialog* dialog;
	gint response;
	g_return_if_fail (self != NULL);
	dialog = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (NULL, self->priv->gtkWindow, GTK_FILE_CHOOSER_ACTION_OPEN, NULL));
	gtk_dialog_add_buttons ((GtkDialog*) dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL);
	gtk_file_chooser_set_local_only ((GtkFileChooser*) dialog, FALSE);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp1;
		const char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->profileFilename = (_tmp1 = (_tmp0 = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->priv->profileFilename = (g_free (self->priv->profileFilename), NULL), _tmp1);
		if (profile_load (self->priv->profile, self->priv->profileFilename, self->priv->gtkWindow)) {
			Settings* _tmp2;
			Preferences* _tmp3;
			DefaultPaths* _tmp4;
			char* _tmp5;
			char* _tmp7;
			char* _tmp6;
			moserial_main_window_ensureDisconnected (self);
			_tmp2 = NULL;
			self->priv->currentSettings = (_tmp2 = settings_loadFromProfile (self->priv->profile), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp2);
			_tmp3 = NULL;
			self->priv->currentPreferences = (_tmp3 = preferences_loadFromProfile (self->priv->profile), (self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL)), _tmp3);
			_tmp4 = NULL;
			self->priv->currentPaths = (_tmp4 = default_paths_loadFromProfile (self->priv->profile), (self->priv->currentPaths == NULL) ? NULL : (self->priv->currentPaths = (g_object_unref (self->priv->currentPaths), NULL)), _tmp4);
			moserial_main_window_updatePreferences (self, NULL, self->priv->currentPreferences);
			gtk_statusbar_pop (self->priv->statusbar, self->priv->statusbarContext);
			_tmp5 = NULL;
			gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp5 = settings_getStatusbarString (self->priv->currentSettings, FALSE));
			_tmp5 = (g_free (_tmp5), NULL);
			_tmp7 = NULL;
			_tmp6 = NULL;
			gtk_window_set_title (self->priv->gtkWindow, _tmp7 = g_strdup_printf ("moserial - %s", _tmp6 = g_path_get_basename (self->priv->profileFilename)));
			_tmp7 = (g_free (_tmp7), NULL);
			_tmp6 = (g_free (_tmp6), NULL);
			self->priv->profileChanged = FALSE;
		}
	}
	gtk_object_destroy ((GtkObject*) dialog);
	(dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL));
}


static void moserial_main_window_copy (moserialMainWindow* self) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	g_return_if_fail (self != NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingAsciiTextView)) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingAsciiTextView);
	}
	if (_tmp2) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingHexTextView);
	}
	if (_tmp1) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingHexTextView);
	}
	if (_tmp0) {
		GtkTextView* _tmp3;
		GtkTextView* tv;
		_tmp3 = NULL;
		tv = (_tmp3 = GTK_TEXT_VIEW (gtk_window_get_focus (self->priv->gtkWindow)), (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
		gtk_text_buffer_copy_clipboard (gtk_text_view_get_buffer (tv), gtk_clipboard_get (GDK_SELECTION_CLIPBOARD));
		(tv == NULL) ? NULL : (tv = (g_object_unref (tv), NULL));
	} else {
		if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
			g_signal_emit_by_name (self->priv->entry, "copy-clipboard");
		}
	}
}


static void moserial_main_window_cut (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
		g_signal_emit_by_name (self->priv->entry, "cut-clipboard");
	}
}


static void moserial_main_window_editMenu (moserialMainWindow* self, GtkAction* a) {
	gboolean _tmp0;
	gboolean _tmp1;
	gboolean _tmp2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	_tmp2 = FALSE;
	if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingAsciiTextView)) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingAsciiTextView);
	}
	if (_tmp2) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->outgoingHexTextView);
	}
	if (_tmp1) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->incomingHexTextView);
	}
	if (_tmp0) {
		GtkTextView* _tmp3;
		GtkTextView* tv;
		gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
		_tmp3 = NULL;
		tv = (_tmp3 = GTK_TEXT_VIEW (gtk_window_get_focus (self->priv->gtkWindow)), (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
		if (gtk_text_buffer_get_has_selection (gtk_text_view_get_buffer (tv))) {
			gtk_action_set_sensitive (self->priv->copyMenuItem, TRUE);
		} else {
			gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		}
		(tv == NULL) ? NULL : (tv = (g_object_unref (tv), NULL));
	} else {
		if (gtk_window_get_focus (self->priv->gtkWindow) == GTK_WIDGET (self->priv->entry)) {
			gint s;
			gint e;
			s = 0;
			e = 0;
			if (gtk_editable_get_selection_bounds ((GtkEditable*) self->priv->entry, s, e)) {
				gtk_action_set_sensitive (self->priv->cutMenuItem, TRUE);
				gtk_action_set_sensitive (self->priv->copyMenuItem, TRUE);
			} else {
				gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
				gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
			}
		} else {
			gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
			gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		}
	}
}


static void moserial_main_window_paste (moserialMainWindow* self) {
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self->priv->entry, "paste-clipboard");
	if (!(g_object_get ((GtkWidget*) self->priv->entry, "has-focus", &_tmp0, NULL), _tmp0)) {
		gtk_widget_grab_focus ((GtkWidget*) self->priv->entry);
		gtk_editable_set_position ((GtkEditable*) self->priv->entry, -1);
	}
}


static void moserial_main_window_clear (moserialMainWindow* self) {
	g_return_if_fail (self != NULL);
	moserial_hex_text_buffer_clear (self->priv->incomingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->incomingAsciiTextBuffer, "", 0);
	moserial_hex_text_buffer_clear (self->priv->outgoingHexTextBuffer);
	gtk_text_buffer_set_text (self->priv->outgoingAsciiTextBuffer, "", 0);
	gtk_entry_set_text (self->priv->entry, "");
}


GtkBuilder* moserial_main_window_get_builder (moserialMainWindow* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_builder;
}


static void moserial_main_window_set_builder (moserialMainWindow* self, GtkBuilder* value) {
	GtkBuilder* _tmp2;
	GtkBuilder* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_builder = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "builder");
}


const char* moserial_main_window_get_startupProfileFilename (moserialMainWindow* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_startupProfileFilename;
}


static void moserial_main_window_set_startupProfileFilename (moserialMainWindow* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_startupProfileFilename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_startupProfileFilename = (g_free (self->priv->_startupProfileFilename), NULL), _tmp2);
	g_object_notify ((GObject *) self, "startupProfileFilename");
}


static void _moserial_main_window_quitSave_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
	moserial_main_window_quitSave (self);
}


static gboolean _moserial_main_window_deleteSaveSize_gtk_widget_delete_event (GtkWindow* _sender, const GdkEvent* event, gpointer self) {
	return moserial_main_window_deleteSaveSize (self, _sender, event);
}


static void _moserial_main_window_quitSizeSave_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_quitSizeSave (self);
}


static void _moserial_main_window_saveProfileAs_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_saveProfileAs (self);
}


static void _moserial_main_window_saveProfile_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_saveProfile (self);
}


static void _moserial_main_window_loadProfile_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_loadProfile (self);
}


static void _moserial_main_window_copy_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_copy (self);
}


static void _moserial_main_window_editMenu_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_editMenu (self, _sender);
}


static void _moserial_main_window_cut_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_cut (self);
}


static void _moserial_main_window_paste_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_paste (self);
}


static void _moserial_main_window_clear_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_clear (self);
}


static void _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings (moserialSettingsDialog* _sender, Settings* settings, gpointer self) {
	moserial_main_window_updateSettings (self, _sender, settings);
}


static void _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showSettingsDialog (self, _sender);
}


static void _moserial_main_window_showHelpButton_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showHelpButton (self, _sender);
}


static void _moserial_main_window_showAboutDialog_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_showAboutDialog (self);
}


static void _moserial_main_window_doSendChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_doSendChooser (self, _sender);
}


static void _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer (moserialSendChooserDialog* _sender, gpointer self) {
	moserial_main_window_doSend (self, _sender);
}


static void _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_doReceiveChooser (self, _sender);
}


static void _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer (moserialReceiveChooserDialog* _sender, gpointer self) {
	moserial_main_window_doReceive (self, _sender);
}


static void _moserial_main_window_record_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self) {
	moserial_main_window_record (self, _sender);
}


static void _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording (moserialRecordDialog* _sender, gpointer self) {
	moserial_main_window_stopRecording (self, _sender);
}


static void _moserial_main_window_startRecording_moserial_record_dialog_start_recording (moserialRecordDialog* _sender, const char* fileName, moserialSerialStreamRecorderDirection direction, gpointer self) {
	moserial_main_window_startRecording (self, _sender, fileName, direction);
}


static void _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences (moserialPreferencesDialog* _sender, Preferences* preferences, gpointer self) {
	moserial_main_window_updatePreferences (self, _sender, preferences);
}


static void _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	moserial_main_window_showPreferencesDialog (self, _sender);
}


static void _moserial_main_window_doConnect_gtk_tool_button_clicked (GtkToggleToolButton* _sender, gpointer self) {
	moserial_main_window_doConnect (self, _sender);
}


static void _moserial_main_window_showHelpAction_gtk_action_activate (GtkAction* _sender, gpointer self) {
	moserial_main_window_showHelpAction (self, _sender);
}


static void _moserial_main_window_sendString_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_main_window_sendString (self, _sender);
}


static void _moserial_main_window_sendString_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	moserial_main_window_sendString (self, _sender);
}


static void _moserial_main_window_inputModeChanged_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	moserial_main_window_inputModeChanged (self, _sender);
}


static GObject * moserial_main_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialMainWindowClass * klass;
	GObjectClass * parent_class;
	moserialMainWindow * self;
	klass = MOSERIAL_MAIN_WINDOW_CLASS (g_type_class_peek (MOSERIAL_TYPE_MAIN_WINDOW));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_MAIN_WINDOW (obj);
	{
		GtkWindow* _tmp1;
		GtkWindow* _tmp0;
		Profile* _tmp2;
		Settings* _tmp3;
		gint width;
		gint height;
		gint panedPosition;
		gboolean _tmp4;
		GtkPaned* _tmp6;
		GtkPaned* _tmp5;
		GtkAction* _tmp7;
		GtkAction* quit;
		GtkAction* _tmp8;
		GtkAction* saveAs;
		GtkAction* _tmp9;
		GtkAction* save;
		GtkAction* _tmp10;
		GtkAction* open;
		GtkAction* _tmp12;
		GtkAction* _tmp11;
		GtkAction* _tmp13;
		GtkAction* editMenuItem;
		GtkAction* _tmp15;
		GtkAction* _tmp14;
		GtkAction* _tmp16;
		GtkAction* pasteMenuItem;
		GtkAction* _tmp17;
		GtkAction* clearMenuItem;
		moserialSettingsDialog* _tmp18;
		GtkToolButton* _tmp20;
		GtkToolButton* _tmp19;
		GtkToolButton* _tmp21;
		GtkToolButton* helpButton;
		GtkStatusbar* _tmp23;
		GtkStatusbar* _tmp22;
		char* _tmp24;
		GtkStatusbar* _tmp26;
		GtkStatusbar* _tmp25;
		GtkAction* _tmp27;
		GtkAction* about;
		moserialSendProgressDialog* _tmp28;
		moserialSendChooserDialog* _tmp29;
		GtkToolButton* _tmp31;
		GtkToolButton* _tmp30;
		moserialSzwrapper* _tmp33;
		moserialSzwrapperProtocol _tmp32;
		moserialReceiveProgressDialog* _tmp34;
		moserialReceiveChooserDialog* _tmp35;
		GtkToolButton* _tmp37;
		GtkToolButton* _tmp36;
		moserialXmodemFilenameDialog* _tmp38;
		moserialRzwrapper* _tmp40;
		moserialRzwrapperProtocol _tmp39;
		moserialRecordDialog* _tmp41;
		GtkToggleToolButton* _tmp43;
		GtkToggleToolButton* _tmp42;
		GtkLabel* _tmp45;
		GtkLabel* _tmp44;
		GtkLabel* _tmp47;
		GtkLabel* _tmp46;
		moserialPreferencesDialog* _tmp48;
		GtkToolButton* _tmp49;
		GtkToolButton* preferences;
		GtkToggleToolButton* _tmp51;
		GtkToggleToolButton* _tmp50;
		GtkLabel* _tmp53;
		GtkLabel* _tmp52;
		GtkLabel* _tmp55;
		GtkLabel* _tmp54;
		GtkAction* _tmp56;
		GtkAction* contents;
		GtkNotebook* _tmp58;
		GtkNotebook* _tmp57;
		GtkNotebook* _tmp60;
		GtkNotebook* _tmp59;
		moserialHexTextBuffer* _tmp61;
		GtkTextBuffer* _tmp63;
		GtkTextTagTable* _tmp62;
		moserialHexTextBuffer* _tmp64;
		GtkTextBuffer* _tmp66;
		GtkTextTagTable* _tmp65;
		GtkTextTag* _tmp68;
		GtkTextTag* _tmp67;
		GtkTextView* _tmp70;
		GtkTextView* _tmp69;
		PangoFontDescription* _tmp71;
		GtkTextView* _tmp73;
		GtkTextView* _tmp72;
		PangoFontDescription* _tmp74;
		GtkTextView* _tmp76;
		GtkTextView* _tmp75;
		PangoFontDescription* _tmp77;
		GtkTextView* _tmp79;
		GtkTextView* _tmp78;
		PangoFontDescription* _tmp80;
		GtkScrolledWindow* _tmp81;
		GtkScrolledWindow* incomingAsciiScrolledWindow;
		GtkAdjustment* _tmp82;
		GtkAdjustment* va1;
		GtkScrolledWindow* _tmp83;
		GtkScrolledWindow* incomingHexScrolledWindow;
		GtkAdjustment* _tmp84;
		GtkAdjustment* va2;
		GtkScrolledWindow* _tmp85;
		GtkScrolledWindow* outgoingAsciiScrolledWindow;
		GtkAdjustment* _tmp86;
		GtkAdjustment* va3;
		GtkScrolledWindow* _tmp87;
		GtkScrolledWindow* outgoingHexScrolledWindow;
		GtkAdjustment* _tmp88;
		GtkAdjustment* va4;
		GtkButton* _tmp90;
		GtkButton* _tmp89;
		GtkEntry* _tmp92;
		GtkEntry* _tmp91;
		GtkComboBox* _tmp94;
		GtkComboBox* _tmp93;
		GtkComboBox* _tmp96;
		GtkComboBox* _tmp95;
		Preferences* _tmp97;
		DefaultPaths* _tmp98;
		/*setup window*/
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->gtkWindow = (_tmp1 = (_tmp0 = GTK_WINDOW (gtk_builder_get_object (self->priv->_builder, "window")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->gtkWindow == NULL) ? NULL : (self->priv->gtkWindow = (g_object_unref (self->priv->gtkWindow), NULL)), _tmp1);
		g_signal_connect_object ((GtkObject*) self->priv->gtkWindow, "destroy", (GCallback) _moserial_main_window_quitSave_gtk_object_destroy, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->gtkWindow, "delete-event", (GCallback) _moserial_main_window_deleteSaveSize_gtk_widget_delete_event, self, 0);
		/*load defaults*/
		_tmp2 = NULL;
		self->priv->profile = (_tmp2 = profile_new (), (self->priv->profile == NULL) ? NULL : (self->priv->profile = (g_object_unref (self->priv->profile), NULL)), _tmp2);
		profile_load (self->priv->profile, NULL, self->priv->gtkWindow);
		_tmp3 = NULL;
		self->priv->currentSettings = (_tmp3 = settings_loadFromProfile (self->priv->profile), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp3);
		width = profile_getWindowWidth (self->priv->profile);
		height = profile_getWindowHeight (self->priv->profile);
		panedPosition = profile_getWindowPanedPosition (self->priv->profile);
		_tmp4 = FALSE;
		if (width > 0) {
			_tmp4 = height > 0;
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			gtk_window_resize (self->priv->gtkWindow, width, height);
		}
		/*setup paned*/
		_tmp6 = NULL;
		_tmp5 = NULL;
		self->priv->paned = (_tmp6 = (_tmp5 = GTK_PANED (gtk_builder_get_object (self->priv->_builder, "vpaned")), (_tmp5 == NULL) ? NULL : g_object_ref (_tmp5)), (self->priv->paned == NULL) ? NULL : (self->priv->paned = (g_object_unref (self->priv->paned), NULL)), _tmp6);
		if (panedPosition >= (-1)) {
			gtk_paned_set_position (self->priv->paned, panedPosition);
		} else {
			gtk_paned_set_position (self->priv->paned, -1);
		}
		/*setup menu items*/
		_tmp7 = NULL;
		quit = (_tmp7 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_quit")), (_tmp7 == NULL) ? NULL : g_object_ref (_tmp7));
		g_signal_connect_object (quit, "activate", (GCallback) _moserial_main_window_quitSizeSave_gtk_action_activate, self, 0);
		_tmp8 = NULL;
		saveAs = (_tmp8 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_save_settings_as")), (_tmp8 == NULL) ? NULL : g_object_ref (_tmp8));
		g_signal_connect_object (saveAs, "activate", (GCallback) _moserial_main_window_saveProfileAs_gtk_action_activate, self, 0);
		_tmp9 = NULL;
		save = (_tmp9 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_save_settings")), (_tmp9 == NULL) ? NULL : g_object_ref (_tmp9));
		g_signal_connect_object (save, "activate", (GCallback) _moserial_main_window_saveProfile_gtk_action_activate, self, 0);
		_tmp10 = NULL;
		open = (_tmp10 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_open_settings")), (_tmp10 == NULL) ? NULL : g_object_ref (_tmp10));
		g_signal_connect_object (open, "activate", (GCallback) _moserial_main_window_loadProfile_gtk_action_activate, self, 0);
		_tmp12 = NULL;
		_tmp11 = NULL;
		self->priv->copyMenuItem = (_tmp12 = (_tmp11 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_copy")), (_tmp11 == NULL) ? NULL : g_object_ref (_tmp11)), (self->priv->copyMenuItem == NULL) ? NULL : (self->priv->copyMenuItem = (g_object_unref (self->priv->copyMenuItem), NULL)), _tmp12);
		g_signal_connect_object (self->priv->copyMenuItem, "activate", (GCallback) _moserial_main_window_copy_gtk_action_activate, self, 0);
		_tmp13 = NULL;
		editMenuItem = (_tmp13 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_edit")), (_tmp13 == NULL) ? NULL : g_object_ref (_tmp13));
		g_signal_connect_object (editMenuItem, "activate", (GCallback) _moserial_main_window_editMenu_gtk_action_activate, self, 0);
		_tmp15 = NULL;
		_tmp14 = NULL;
		self->priv->cutMenuItem = (_tmp15 = (_tmp14 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_cut")), (_tmp14 == NULL) ? NULL : g_object_ref (_tmp14)), (self->priv->cutMenuItem == NULL) ? NULL : (self->priv->cutMenuItem = (g_object_unref (self->priv->cutMenuItem), NULL)), _tmp15);
		gtk_action_set_sensitive (self->priv->copyMenuItem, FALSE);
		gtk_action_set_sensitive (self->priv->cutMenuItem, FALSE);
		g_signal_connect_object (self->priv->cutMenuItem, "activate", (GCallback) _moserial_main_window_cut_gtk_action_activate, self, 0);
		_tmp16 = NULL;
		pasteMenuItem = (_tmp16 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_paste")), (_tmp16 == NULL) ? NULL : g_object_ref (_tmp16));
		g_signal_connect_object (pasteMenuItem, "activate", (GCallback) _moserial_main_window_paste_gtk_action_activate, self, 0);
		_tmp17 = NULL;
		clearMenuItem = (_tmp17 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_clear")), (_tmp17 == NULL) ? NULL : g_object_ref (_tmp17));
		g_signal_connect_object (clearMenuItem, "activate", (GCallback) _moserial_main_window_clear_gtk_action_activate, self, 0);
		/*setup the Port Settings Dialog*/
		_tmp18 = NULL;
		self->priv->settingsDialog = (_tmp18 = moserial_settings_dialog_new (self->priv->_builder), (self->priv->settingsDialog == NULL) ? NULL : (self->priv->settingsDialog = (g_object_unref (self->priv->settingsDialog), NULL)), _tmp18);
		g_signal_connect_object (self->priv->settingsDialog, "update-settings", (GCallback) _moserial_main_window_updateSettings_moserial_settings_dialog_update_settings, self, 0);
		_tmp20 = NULL;
		_tmp19 = NULL;
		self->priv->settingsButton = (_tmp20 = (_tmp19 = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_settings")), (_tmp19 == NULL) ? NULL : g_object_ref (_tmp19)), (self->priv->settingsButton == NULL) ? NULL : (self->priv->settingsButton = (g_object_unref (self->priv->settingsButton), NULL)), _tmp20);
		g_signal_connect_object (self->priv->settingsButton, "clicked", (GCallback) _moserial_main_window_showSettingsDialog_gtk_tool_button_clicked, self, 0);
		/*setup the Help button*/
		_tmp21 = NULL;
		helpButton = (_tmp21 = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_help")), (_tmp21 == NULL) ? NULL : g_object_ref (_tmp21));
		g_signal_connect_object (helpButton, "clicked", (GCallback) _moserial_main_window_showHelpButton_gtk_tool_button_clicked, self, 0);
		/*setup the statusbar*/
		_tmp23 = NULL;
		_tmp22 = NULL;
		self->priv->statusbar = (_tmp23 = (_tmp22 = GTK_STATUSBAR (gtk_builder_get_object (self->priv->_builder, "statusbar")), (_tmp22 == NULL) ? NULL : g_object_ref (_tmp22)), (self->priv->statusbar == NULL) ? NULL : (self->priv->statusbar = (g_object_unref (self->priv->statusbar), NULL)), _tmp23);
		self->priv->statusbarContext = gtk_statusbar_get_context_id (self->priv->statusbar, "moserial port status");
		_tmp24 = NULL;
		gtk_statusbar_push (self->priv->statusbar, self->priv->statusbarContext, _tmp24 = settings_getStatusbarString (self->priv->currentSettings, FALSE));
		_tmp24 = (g_free (_tmp24), NULL);
		/*setup the byte count bar*/
		_tmp26 = NULL;
		_tmp25 = NULL;
		self->priv->bytecountbar = (_tmp26 = (_tmp25 = GTK_STATUSBAR (gtk_builder_get_object (self->priv->_builder, "bytecountbar")), (_tmp25 == NULL) ? NULL : g_object_ref (_tmp25)), (self->priv->bytecountbar == NULL) ? NULL : (self->priv->bytecountbar = (g_object_unref (self->priv->bytecountbar), NULL)), _tmp26);
		self->priv->bytecountbarContext = gtk_statusbar_get_context_id (self->priv->statusbar, "moserial byte counts");
		gtk_statusbar_push (self->priv->bytecountbar, self->priv->bytecountbarContext, _ ("TX: 0, RX: 0"));
		/*setup the about dialog*/
		_tmp27 = NULL;
		about = (_tmp27 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_about")), (_tmp27 == NULL) ? NULL : g_object_ref (_tmp27));
		g_signal_connect_object (about, "activate", (GCallback) _moserial_main_window_showAboutDialog_gtk_action_activate, self, 0);
		/*setup send*/
		_tmp28 = NULL;
		self->priv->sendProgressDialog = (_tmp28 = moserial_send_progress_dialog_new (self->priv->_builder), (self->priv->sendProgressDialog == NULL) ? NULL : (self->priv->sendProgressDialog = (g_object_unref (self->priv->sendProgressDialog), NULL)), _tmp28);
		_tmp29 = NULL;
		self->priv->sendChooserDialog = (_tmp29 = moserial_send_chooser_dialog_new (self->priv->_builder), (self->priv->sendChooserDialog == NULL) ? NULL : (self->priv->sendChooserDialog = (g_object_unref (self->priv->sendChooserDialog), NULL)), _tmp29);
		_tmp31 = NULL;
		_tmp30 = NULL;
		self->priv->send = (_tmp31 = (_tmp30 = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_send")), (_tmp30 == NULL) ? NULL : g_object_ref (_tmp30)), (self->priv->send == NULL) ? NULL : (self->priv->send = (g_object_unref (self->priv->send), NULL)), _tmp31);
		g_signal_connect_object (self->priv->send, "clicked", (GCallback) _moserial_main_window_doSendChooser_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->sendChooserDialog, "start-transfer", (GCallback) _moserial_main_window_doSend_moserial_send_chooser_dialog_start_transfer, self, 0);
		_tmp33 = NULL;
		self->priv->sz = (_tmp33 = moserial_szwrapper_new ((_tmp32 = MOSERIAL_SZWRAPPER_PROTOCOL_NULL, &_tmp32), NULL, NULL), (self->priv->sz == NULL) ? NULL : (self->priv->sz = (g_object_unref (self->priv->sz), NULL)), _tmp33);
		/*setup receive*/
		_tmp34 = NULL;
		self->priv->receiveProgressDialog = (_tmp34 = moserial_receive_progress_dialog_new (self->priv->_builder), (self->priv->receiveProgressDialog == NULL) ? NULL : (self->priv->receiveProgressDialog = (g_object_unref (self->priv->receiveProgressDialog), NULL)), _tmp34);
		_tmp35 = NULL;
		self->priv->receiveChooserDialog = (_tmp35 = moserial_receive_chooser_dialog_new (self->priv->_builder), (self->priv->receiveChooserDialog == NULL) ? NULL : (self->priv->receiveChooserDialog = (g_object_unref (self->priv->receiveChooserDialog), NULL)), _tmp35);
		_tmp37 = NULL;
		_tmp36 = NULL;
		self->priv->receive = (_tmp37 = (_tmp36 = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_receive")), (_tmp36 == NULL) ? NULL : g_object_ref (_tmp36)), (self->priv->receive == NULL) ? NULL : (self->priv->receive = (g_object_unref (self->priv->receive), NULL)), _tmp37);
		g_signal_connect_object (self->priv->receive, "clicked", (GCallback) _moserial_main_window_doReceiveChooser_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->receiveChooserDialog, "start-transfer", (GCallback) _moserial_main_window_doReceive_moserial_receive_chooser_dialog_start_transfer, self, 0);
		_tmp38 = NULL;
		self->priv->xmodemFilenameDialog = (_tmp38 = moserial_xmodem_filename_dialog_new (self->priv->_builder), (self->priv->xmodemFilenameDialog == NULL) ? NULL : (self->priv->xmodemFilenameDialog = (g_object_unref (self->priv->xmodemFilenameDialog), NULL)), _tmp38);
		_tmp40 = NULL;
		self->priv->rz = (_tmp40 = moserial_rzwrapper_new ((_tmp39 = MOSERIAL_RZWRAPPER_PROTOCOL_NULL, &_tmp39), NULL, NULL, NULL), (self->priv->rz == NULL) ? NULL : (self->priv->rz = (g_object_unref (self->priv->rz), NULL)), _tmp40);
		/*setup recording*/
		_tmp41 = NULL;
		self->priv->recordDialog = (_tmp41 = moserial_record_dialog_new (self->priv->_builder), (self->priv->recordDialog == NULL) ? NULL : (self->priv->recordDialog = (g_object_unref (self->priv->recordDialog), NULL)), _tmp41);
		_tmp43 = NULL;
		_tmp42 = NULL;
		self->priv->recordButton = (_tmp43 = (_tmp42 = GTK_TOGGLE_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_logging")), (_tmp42 == NULL) ? NULL : g_object_ref (_tmp42)), (self->priv->recordButton == NULL) ? NULL : (self->priv->recordButton = (g_object_unref (self->priv->recordButton), NULL)), _tmp43);
		g_signal_connect_object ((GtkToolButton*) self->priv->recordButton, "clicked", (GCallback) _moserial_main_window_record_gtk_tool_button_clicked, self, 0);
		g_signal_connect_object (self->priv->recordDialog, "stop-recording", (GCallback) _moserial_main_window_stopRecording_moserial_record_dialog_stop_recording, self, 0);
		g_signal_connect_object (self->priv->recordDialog, "start-recording", (GCallback) _moserial_main_window_startRecording_moserial_record_dialog_start_recording, self, 0);
		_tmp45 = NULL;
		_tmp44 = NULL;
		self->priv->recordLabel = (_tmp45 = (_tmp44 = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "record_label")), (_tmp44 == NULL) ? NULL : g_object_ref (_tmp44)), (self->priv->recordLabel == NULL) ? NULL : (self->priv->recordLabel = (g_object_unref (self->priv->recordLabel), NULL)), _tmp45);
		_tmp47 = NULL;
		_tmp46 = NULL;
		self->priv->stopRecordingLabel = (_tmp47 = (_tmp46 = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "stop_recording_label")), (_tmp46 == NULL) ? NULL : g_object_ref (_tmp46)), (self->priv->stopRecordingLabel == NULL) ? NULL : (self->priv->stopRecordingLabel = (g_object_unref (self->priv->stopRecordingLabel), NULL)), _tmp47);
		/*setup preferences*/
		_tmp48 = NULL;
		self->priv->preferencesDialog = (_tmp48 = moserial_preferences_dialog_new (self->priv->_builder), (self->priv->preferencesDialog == NULL) ? NULL : (self->priv->preferencesDialog = (g_object_unref (self->priv->preferencesDialog), NULL)), _tmp48);
		g_signal_connect_object (self->priv->preferencesDialog, "update-preferences", (GCallback) _moserial_main_window_updatePreferences_moserial_preferences_dialog_update_preferences, self, 0);
		_tmp49 = NULL;
		preferences = (_tmp49 = GTK_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_preferences")), (_tmp49 == NULL) ? NULL : g_object_ref (_tmp49));
		g_signal_connect_object (preferences, "clicked", (GCallback) _moserial_main_window_showPreferencesDialog_gtk_tool_button_clicked, self, 0);
		/*setup connectbutton*/
		_tmp51 = NULL;
		_tmp50 = NULL;
		self->priv->connectButton = (_tmp51 = (_tmp50 = GTK_TOGGLE_TOOL_BUTTON (gtk_builder_get_object (self->priv->_builder, "toolbar_connect")), (_tmp50 == NULL) ? NULL : g_object_ref (_tmp50)), (self->priv->connectButton == NULL) ? NULL : (self->priv->connectButton = (g_object_unref (self->priv->connectButton), NULL)), _tmp51);
		g_signal_connect_object ((GtkToolButton*) self->priv->connectButton, "clicked", (GCallback) _moserial_main_window_doConnect_gtk_tool_button_clicked, self, 0);
		_tmp53 = NULL;
		_tmp52 = NULL;
		self->priv->disconnectLabel = (_tmp53 = (_tmp52 = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "disconnect_label")), (_tmp52 == NULL) ? NULL : g_object_ref (_tmp52)), (self->priv->disconnectLabel == NULL) ? NULL : (self->priv->disconnectLabel = (g_object_unref (self->priv->disconnectLabel), NULL)), _tmp53);
		_tmp55 = NULL;
		_tmp54 = NULL;
		self->priv->connectLabel = (_tmp55 = (_tmp54 = GTK_LABEL (gtk_builder_get_object (self->priv->_builder, "connect_label")), (_tmp54 == NULL) ? NULL : g_object_ref (_tmp54)), (self->priv->connectLabel == NULL) ? NULL : (self->priv->connectLabel = (g_object_unref (self->priv->connectLabel), NULL)), _tmp55);
		/*setup help*/
		_tmp56 = NULL;
		contents = (_tmp56 = GTK_ACTION (gtk_builder_get_object (self->priv->_builder, "menubar_contents")), (_tmp56 == NULL) ? NULL : g_object_ref (_tmp56));
		g_signal_connect_object (contents, "activate", (GCallback) _moserial_main_window_showHelpAction_gtk_action_activate, self, 0);
		/*setup incoming notebook*/
		_tmp58 = NULL;
		_tmp57 = NULL;
		self->priv->incoming_notebook = (_tmp58 = (_tmp57 = GTK_NOTEBOOK (gtk_builder_get_object (self->priv->_builder, "incoming_notebook")), (_tmp57 == NULL) ? NULL : g_object_ref (_tmp57)), (self->priv->incoming_notebook == NULL) ? NULL : (self->priv->incoming_notebook = (g_object_unref (self->priv->incoming_notebook), NULL)), _tmp58);
		/*setup outgoing notebook*/
		_tmp60 = NULL;
		_tmp59 = NULL;
		self->priv->outgoing_notebook = (_tmp60 = (_tmp59 = GTK_NOTEBOOK (gtk_builder_get_object (self->priv->_builder, "outgoing_notebook")), (_tmp59 == NULL) ? NULL : g_object_ref (_tmp59)), (self->priv->outgoing_notebook == NULL) ? NULL : (self->priv->outgoing_notebook = (g_object_unref (self->priv->outgoing_notebook), NULL)), _tmp60);
		/*setup textBuffers;*/
		_tmp61 = NULL;
		self->priv->incomingHexTextBuffer = (_tmp61 = moserial_hex_text_buffer_new (), (self->priv->incomingHexTextBuffer == NULL) ? NULL : (self->priv->incomingHexTextBuffer = (g_object_unref (self->priv->incomingHexTextBuffer), NULL)), _tmp61);
		_tmp63 = NULL;
		_tmp62 = NULL;
		self->priv->incomingAsciiTextBuffer = (_tmp63 = gtk_text_buffer_new (_tmp62 = gtk_text_tag_table_new ()), (self->priv->incomingAsciiTextBuffer == NULL) ? NULL : (self->priv->incomingAsciiTextBuffer = (g_object_unref (self->priv->incomingAsciiTextBuffer), NULL)), _tmp63);
		(_tmp62 == NULL) ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL));
		_tmp64 = NULL;
		self->priv->outgoingHexTextBuffer = (_tmp64 = moserial_hex_text_buffer_new (), (self->priv->outgoingHexTextBuffer == NULL) ? NULL : (self->priv->outgoingHexTextBuffer = (g_object_unref (self->priv->outgoingHexTextBuffer), NULL)), _tmp64);
		_tmp66 = NULL;
		_tmp65 = NULL;
		self->priv->outgoingAsciiTextBuffer = (_tmp66 = gtk_text_buffer_new (_tmp65 = gtk_text_tag_table_new ()), (self->priv->outgoingAsciiTextBuffer == NULL) ? NULL : (self->priv->outgoingAsciiTextBuffer = (g_object_unref (self->priv->outgoingAsciiTextBuffer), NULL)), _tmp66);
		(_tmp65 == NULL) ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL));
		_tmp68 = NULL;
		_tmp67 = NULL;
		self->priv->echoTag = (_tmp68 = (_tmp67 = gtk_text_buffer_create_tag (self->priv->incomingAsciiTextBuffer, "echo", NULL, NULL), (_tmp67 == NULL) ? NULL : g_object_ref (_tmp67)), (self->priv->echoTag == NULL) ? NULL : (self->priv->echoTag = (g_object_unref (self->priv->echoTag), NULL)), _tmp68);
		_tmp70 = NULL;
		_tmp69 = NULL;
		self->priv->incomingHexTextView = (_tmp70 = (_tmp69 = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "incoming_hex_textview")), (_tmp69 == NULL) ? NULL : g_object_ref (_tmp69)), (self->priv->incomingHexTextView == NULL) ? NULL : (self->priv->incomingHexTextView = (g_object_unref (self->priv->incomingHexTextView), NULL)), _tmp70);
		_tmp71 = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->incomingHexTextView, _tmp71 = pango_font_description_from_string ("Monospace 10"));
		(_tmp71 == NULL) ? NULL : (_tmp71 = (pango_font_description_free (_tmp71), NULL));
		gtk_text_view_set_buffer (self->priv->incomingHexTextView, (GtkTextBuffer*) self->priv->incomingHexTextBuffer);
		_tmp73 = NULL;
		_tmp72 = NULL;
		self->priv->incomingAsciiTextView = (_tmp73 = (_tmp72 = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "incoming_ascii_textview")), (_tmp72 == NULL) ? NULL : g_object_ref (_tmp72)), (self->priv->incomingAsciiTextView == NULL) ? NULL : (self->priv->incomingAsciiTextView = (g_object_unref (self->priv->incomingAsciiTextView), NULL)), _tmp73);
		_tmp74 = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->incomingAsciiTextView, _tmp74 = pango_font_description_from_string ("Monospace 10"));
		(_tmp74 == NULL) ? NULL : (_tmp74 = (pango_font_description_free (_tmp74), NULL));
		gtk_text_view_set_buffer (self->priv->incomingAsciiTextView, self->priv->incomingAsciiTextBuffer);
		_tmp76 = NULL;
		_tmp75 = NULL;
		self->priv->outgoingHexTextView = (_tmp76 = (_tmp75 = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "outgoing_hex_textview")), (_tmp75 == NULL) ? NULL : g_object_ref (_tmp75)), (self->priv->outgoingHexTextView == NULL) ? NULL : (self->priv->outgoingHexTextView = (g_object_unref (self->priv->outgoingHexTextView), NULL)), _tmp76);
		_tmp77 = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingHexTextView, _tmp77 = pango_font_description_from_string ("Monospace 10"));
		(_tmp77 == NULL) ? NULL : (_tmp77 = (pango_font_description_free (_tmp77), NULL));
		gtk_text_view_set_buffer (self->priv->outgoingHexTextView, (GtkTextBuffer*) self->priv->outgoingHexTextBuffer);
		_tmp79 = NULL;
		_tmp78 = NULL;
		self->priv->outgoingAsciiTextView = (_tmp79 = (_tmp78 = GTK_TEXT_VIEW (gtk_builder_get_object (self->priv->_builder, "outgoing_ascii_textview")), (_tmp78 == NULL) ? NULL : g_object_ref (_tmp78)), (self->priv->outgoingAsciiTextView == NULL) ? NULL : (self->priv->outgoingAsciiTextView = (g_object_unref (self->priv->outgoingAsciiTextView), NULL)), _tmp79);
		_tmp80 = NULL;
		gtk_widget_modify_font ((GtkWidget*) self->priv->outgoingAsciiTextView, _tmp80 = pango_font_description_from_string ("Monospace 10"));
		(_tmp80 == NULL) ? NULL : (_tmp80 = (pango_font_description_free (_tmp80), NULL));
		gtk_text_view_set_buffer (self->priv->outgoingAsciiTextView, self->priv->outgoingAsciiTextBuffer);
		/*setup scrolling*/
		_tmp81 = NULL;
		incomingAsciiScrolledWindow = (_tmp81 = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "incoming_ascii_scrolledwindow")), (_tmp81 == NULL) ? NULL : g_object_ref (_tmp81));
		_tmp82 = NULL;
		va1 = (_tmp82 = gtk_scrolled_window_get_vadjustment (incomingAsciiScrolledWindow), (_tmp82 == NULL) ? NULL : g_object_ref (_tmp82));
		_tmp83 = NULL;
		incomingHexScrolledWindow = (_tmp83 = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "incoming_hex_scrolledwindow")), (_tmp83 == NULL) ? NULL : g_object_ref (_tmp83));
		_tmp84 = NULL;
		va2 = (_tmp84 = gtk_scrolled_window_get_vadjustment (incomingHexScrolledWindow), (_tmp84 == NULL) ? NULL : g_object_ref (_tmp84));
		_tmp85 = NULL;
		outgoingAsciiScrolledWindow = (_tmp85 = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "outgoing_ascii_scrolledwindow")), (_tmp85 == NULL) ? NULL : g_object_ref (_tmp85));
		_tmp86 = NULL;
		va3 = (_tmp86 = gtk_scrolled_window_get_vadjustment (outgoingAsciiScrolledWindow), (_tmp86 == NULL) ? NULL : g_object_ref (_tmp86));
		_tmp87 = NULL;
		outgoingHexScrolledWindow = (_tmp87 = GTK_SCROLLED_WINDOW (gtk_builder_get_object (self->priv->_builder, "outgoing_hex_scrolledwindow")), (_tmp87 == NULL) ? NULL : g_object_ref (_tmp87));
		_tmp88 = NULL;
		va4 = (_tmp88 = gtk_scrolled_window_get_vadjustment (outgoingHexScrolledWindow), (_tmp88 == NULL) ? NULL : g_object_ref (_tmp88));
		moserial_auto_scroll_setup (va1, va2, va3, va4);
		/*setup entry*/
		_tmp90 = NULL;
		_tmp89 = NULL;
		self->priv->sendButton = (_tmp90 = (_tmp89 = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "send")), (_tmp89 == NULL) ? NULL : g_object_ref (_tmp89)), (self->priv->sendButton == NULL) ? NULL : (self->priv->sendButton = (g_object_unref (self->priv->sendButton), NULL)), _tmp90);
		g_signal_connect_object (self->priv->sendButton, "clicked", (GCallback) _moserial_main_window_sendString_gtk_button_clicked, self, 0);
		_tmp92 = NULL;
		_tmp91 = NULL;
		self->priv->entry = (_tmp92 = (_tmp91 = GTK_ENTRY (gtk_builder_get_object (self->priv->_builder, "entry")), (_tmp91 == NULL) ? NULL : g_object_ref (_tmp91)), (self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL)), _tmp92);
		g_signal_connect_object (self->priv->entry, "activate", (GCallback) _moserial_main_window_sendString_gtk_entry_activate, self, 0);
		_tmp94 = NULL;
		_tmp93 = NULL;
		self->priv->inputMode = (_tmp94 = (_tmp93 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "input_mode")), (_tmp93 == NULL) ? NULL : g_object_ref (_tmp93)), (self->priv->inputMode == NULL) ? NULL : (self->priv->inputMode = (g_object_unref (self->priv->inputMode), NULL)), _tmp94);
		gtk_combo_box_set_active (self->priv->inputMode, 0);
		g_signal_connect_object (self->priv->inputMode, "changed", (GCallback) _moserial_main_window_inputModeChanged_gtk_combo_box_changed, self, 0);
		_tmp96 = NULL;
		_tmp95 = NULL;
		self->priv->terminationMode = (_tmp96 = (_tmp95 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "termination_mode")), (_tmp95 == NULL) ? NULL : g_object_ref (_tmp95)), (self->priv->terminationMode == NULL) ? NULL : (self->priv->terminationMode = (g_object_unref (self->priv->terminationMode), NULL)), _tmp96);
		gtk_combo_box_set_active (self->priv->terminationMode, 0);
		/*load and apply preferences*/
		_tmp97 = NULL;
		self->priv->currentPreferences = (_tmp97 = preferences_loadFromProfile (self->priv->profile), (self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL)), _tmp97);
		moserial_main_window_updatePreferences (self, NULL, self->priv->currentPreferences);
		self->priv->profileChanged = FALSE;
		if (!(self->priv->_startupProfileFilename == NULL)) {
			moserial_main_window_loadProfileOnStartup (self, self->priv->_startupProfileFilename);
		}
		_tmp98 = NULL;
		self->priv->currentPaths = (_tmp98 = default_paths_loadFromProfile (self->priv->profile), (self->priv->currentPaths == NULL) ? NULL : (self->priv->currentPaths = (g_object_unref (self->priv->currentPaths), NULL)), _tmp98);
		(quit == NULL) ? NULL : (quit = (g_object_unref (quit), NULL));
		(saveAs == NULL) ? NULL : (saveAs = (g_object_unref (saveAs), NULL));
		(save == NULL) ? NULL : (save = (g_object_unref (save), NULL));
		(open == NULL) ? NULL : (open = (g_object_unref (open), NULL));
		(editMenuItem == NULL) ? NULL : (editMenuItem = (g_object_unref (editMenuItem), NULL));
		(pasteMenuItem == NULL) ? NULL : (pasteMenuItem = (g_object_unref (pasteMenuItem), NULL));
		(clearMenuItem == NULL) ? NULL : (clearMenuItem = (g_object_unref (clearMenuItem), NULL));
		(helpButton == NULL) ? NULL : (helpButton = (g_object_unref (helpButton), NULL));
		(about == NULL) ? NULL : (about = (g_object_unref (about), NULL));
		(preferences == NULL) ? NULL : (preferences = (g_object_unref (preferences), NULL));
		(contents == NULL) ? NULL : (contents = (g_object_unref (contents), NULL));
		(incomingAsciiScrolledWindow == NULL) ? NULL : (incomingAsciiScrolledWindow = (g_object_unref (incomingAsciiScrolledWindow), NULL));
		(va1 == NULL) ? NULL : (va1 = (g_object_unref (va1), NULL));
		(incomingHexScrolledWindow == NULL) ? NULL : (incomingHexScrolledWindow = (g_object_unref (incomingHexScrolledWindow), NULL));
		(va2 == NULL) ? NULL : (va2 = (g_object_unref (va2), NULL));
		(outgoingAsciiScrolledWindow == NULL) ? NULL : (outgoingAsciiScrolledWindow = (g_object_unref (outgoingAsciiScrolledWindow), NULL));
		(va3 == NULL) ? NULL : (va3 = (g_object_unref (va3), NULL));
		(outgoingHexScrolledWindow == NULL) ? NULL : (outgoingHexScrolledWindow = (g_object_unref (outgoingHexScrolledWindow), NULL));
		(va4 == NULL) ? NULL : (va4 = (g_object_unref (va4), NULL));
	}
	return obj;
}


static void moserial_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialMainWindow * self;
	gpointer boxed;
	self = MOSERIAL_MAIN_WINDOW (object);
	switch (property_id) {
		case MOSERIAL_MAIN_WINDOW_BUILDER:
		g_value_set_object (value, moserial_main_window_get_builder (self));
		break;
		case MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME:
		g_value_set_string (value, moserial_main_window_get_startupProfileFilename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialMainWindow * self;
	self = MOSERIAL_MAIN_WINDOW (object);
	switch (property_id) {
		case MOSERIAL_MAIN_WINDOW_BUILDER:
		moserial_main_window_set_builder (self, g_value_get_object (value));
		break;
		case MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME:
		moserial_main_window_set_startupProfileFilename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_main_window_class_init (moserialMainWindowClass * klass) {
	moserial_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialMainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_MAIN_WINDOW_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_MAIN_WINDOW_STARTUP_PROFILE_FILENAME, g_param_spec_string ("startupProfileFilename", "startupProfileFilename", "startupProfileFilename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void moserial_main_window_instance_init (moserialMainWindow * self) {
	self->priv = MOSERIAL_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->serialConnection = moserial_serial_connection_new ();
	self->priv->streamRecorder = moserial_serial_stream_recorder_new ();
	self->priv->recordDataReceived = FALSE;
	self->priv->recordTimeoutID = (guint) 0;
	self->priv->profileFilename = NULL;
	self->priv->profileChanged = FALSE;
}


static void moserial_main_window_finalize (GObject* obj) {
	moserialMainWindow * self;
	self = MOSERIAL_MAIN_WINDOW (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->gtkWindow == NULL) ? NULL : (self->priv->gtkWindow = (g_object_unref (self->priv->gtkWindow), NULL));
	(self->priv->settingsDialog == NULL) ? NULL : (self->priv->settingsDialog = (g_object_unref (self->priv->settingsDialog), NULL));
	(self->priv->settingsButton == NULL) ? NULL : (self->priv->settingsButton = (g_object_unref (self->priv->settingsButton), NULL));
	(self->priv->recordButton == NULL) ? NULL : (self->priv->recordButton = (g_object_unref (self->priv->recordButton), NULL));
	(self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL));
	(self->priv->currentPreferences == NULL) ? NULL : (self->priv->currentPreferences = (g_object_unref (self->priv->currentPreferences), NULL));
	(self->priv->currentPaths == NULL) ? NULL : (self->priv->currentPaths = (g_object_unref (self->priv->currentPaths), NULL));
	(self->priv->statusbar == NULL) ? NULL : (self->priv->statusbar = (g_object_unref (self->priv->statusbar), NULL));
	(self->priv->bytecountbar == NULL) ? NULL : (self->priv->bytecountbar = (g_object_unref (self->priv->bytecountbar), NULL));
	(self->priv->send == NULL) ? NULL : (self->priv->send = (g_object_unref (self->priv->send), NULL));
	(self->priv->sendProgressDialog == NULL) ? NULL : (self->priv->sendProgressDialog = (g_object_unref (self->priv->sendProgressDialog), NULL));
	(self->priv->sendChooserDialog == NULL) ? NULL : (self->priv->sendChooserDialog = (g_object_unref (self->priv->sendChooserDialog), NULL));
	(self->priv->receive == NULL) ? NULL : (self->priv->receive = (g_object_unref (self->priv->receive), NULL));
	(self->priv->receiveProgressDialog == NULL) ? NULL : (self->priv->receiveProgressDialog = (g_object_unref (self->priv->receiveProgressDialog), NULL));
	(self->priv->receiveChooserDialog == NULL) ? NULL : (self->priv->receiveChooserDialog = (g_object_unref (self->priv->receiveChooserDialog), NULL));
	(self->priv->recordDialog == NULL) ? NULL : (self->priv->recordDialog = (g_object_unref (self->priv->recordDialog), NULL));
	(self->priv->preferencesDialog == NULL) ? NULL : (self->priv->preferencesDialog = (g_object_unref (self->priv->preferencesDialog), NULL));
	(self->priv->serialConnection == NULL) ? NULL : (self->priv->serialConnection = (g_object_unref (self->priv->serialConnection), NULL));
	(self->priv->incomingHexTextView == NULL) ? NULL : (self->priv->incomingHexTextView = (g_object_unref (self->priv->incomingHexTextView), NULL));
	(self->priv->incomingAsciiTextView == NULL) ? NULL : (self->priv->incomingAsciiTextView = (g_object_unref (self->priv->incomingAsciiTextView), NULL));
	(self->priv->outgoingHexTextView == NULL) ? NULL : (self->priv->outgoingHexTextView = (g_object_unref (self->priv->outgoingHexTextView), NULL));
	(self->priv->outgoingAsciiTextView == NULL) ? NULL : (self->priv->outgoingAsciiTextView = (g_object_unref (self->priv->outgoingAsciiTextView), NULL));
	(self->priv->inputMode == NULL) ? NULL : (self->priv->inputMode = (g_object_unref (self->priv->inputMode), NULL));
	(self->priv->terminationMode == NULL) ? NULL : (self->priv->terminationMode = (g_object_unref (self->priv->terminationMode), NULL));
	(self->priv->connectButton == NULL) ? NULL : (self->priv->connectButton = (g_object_unref (self->priv->connectButton), NULL));
	(self->priv->disconnectLabel == NULL) ? NULL : (self->priv->disconnectLabel = (g_object_unref (self->priv->disconnectLabel), NULL));
	(self->priv->connectLabel == NULL) ? NULL : (self->priv->connectLabel = (g_object_unref (self->priv->connectLabel), NULL));
	(self->priv->recordLabel == NULL) ? NULL : (self->priv->recordLabel = (g_object_unref (self->priv->recordLabel), NULL));
	(self->priv->stopRecordingLabel == NULL) ? NULL : (self->priv->stopRecordingLabel = (g_object_unref (self->priv->stopRecordingLabel), NULL));
	(self->priv->paned == NULL) ? NULL : (self->priv->paned = (g_object_unref (self->priv->paned), NULL));
	(self->priv->incoming_notebook == NULL) ? NULL : (self->priv->incoming_notebook = (g_object_unref (self->priv->incoming_notebook), NULL));
	(self->priv->outgoing_notebook == NULL) ? NULL : (self->priv->outgoing_notebook = (g_object_unref (self->priv->outgoing_notebook), NULL));
	(self->priv->incomingHexTextBuffer == NULL) ? NULL : (self->priv->incomingHexTextBuffer = (g_object_unref (self->priv->incomingHexTextBuffer), NULL));
	(self->priv->outgoingHexTextBuffer == NULL) ? NULL : (self->priv->outgoingHexTextBuffer = (g_object_unref (self->priv->outgoingHexTextBuffer), NULL));
	(self->priv->incomingAsciiTextBuffer == NULL) ? NULL : (self->priv->incomingAsciiTextBuffer = (g_object_unref (self->priv->incomingAsciiTextBuffer), NULL));
	(self->priv->echoTag == NULL) ? NULL : (self->priv->echoTag = (g_object_unref (self->priv->echoTag), NULL));
	(self->priv->outgoingAsciiTextBuffer == NULL) ? NULL : (self->priv->outgoingAsciiTextBuffer = (g_object_unref (self->priv->outgoingAsciiTextBuffer), NULL));
	(self->priv->echoStartMark == NULL) ? NULL : (self->priv->echoStartMark = (g_object_unref (self->priv->echoStartMark), NULL));
	(self->priv->xmodemFilenameDialog == NULL) ? NULL : (self->priv->xmodemFilenameDialog = (g_object_unref (self->priv->xmodemFilenameDialog), NULL));
	(self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL));
	(self->priv->sendButton == NULL) ? NULL : (self->priv->sendButton = (g_object_unref (self->priv->sendButton), NULL));
	(self->priv->streamRecorder == NULL) ? NULL : (self->priv->streamRecorder = (moserial_serial_stream_recorder_unref (self->priv->streamRecorder), NULL));
	(self->priv->rz == NULL) ? NULL : (self->priv->rz = (g_object_unref (self->priv->rz), NULL));
	(self->priv->sz == NULL) ? NULL : (self->priv->sz = (g_object_unref (self->priv->sz), NULL));
	(self->priv->profile == NULL) ? NULL : (self->priv->profile = (g_object_unref (self->priv->profile), NULL));
	self->priv->_startupProfileFilename = (g_free (self->priv->_startupProfileFilename), NULL);
	self->priv->profileFilename = (g_free (self->priv->profileFilename), NULL);
	(self->priv->cutMenuItem == NULL) ? NULL : (self->priv->cutMenuItem = (g_object_unref (self->priv->cutMenuItem), NULL));
	(self->priv->copyMenuItem == NULL) ? NULL : (self->priv->copyMenuItem = (g_object_unref (self->priv->copyMenuItem), NULL));
	G_OBJECT_CLASS (moserial_main_window_parent_class)->finalize (obj);
}


GType moserial_main_window_get_type (void) {
	static GType moserial_main_window_type_id = 0;
	if (moserial_main_window_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialMainWindow), 0, (GInstanceInitFunc) moserial_main_window_instance_init, NULL };
		moserial_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "moserialMainWindow", &g_define_type_info, 0);
	}
	return moserial_main_window_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




