
#include <src/SettingsDialog.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>




struct _moserialSettingsDialogPrivate {
	GtkBuilder* _builder;
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBoxEntry* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
};

#define MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogPrivate))
enum  {
	MOSERIAL_SETTINGS_DIALOG_DUMMY_PROPERTY,
	MOSERIAL_SETTINGS_DIALOG_BUILDER
};
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, const GdkEvent* event, gpointer self);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer moserial_settings_dialog_parent_class = NULL;
static void moserial_settings_dialog_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type, GtkBuilder* builder) {
	GParameter * __params;
	GParameter * __params_it;
	moserialSettingsDialog * self;
	g_return_val_if_fail (builder != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "builder";
	g_value_init (&__params_it->value, GTK_TYPE_BUILDER);
	g_value_set_object (&__params_it->value, builder);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


moserialSettingsDialog* moserial_settings_dialog_new (GtkBuilder* builder) {
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG, builder);
}


static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self) {
	GtkListStore* ls;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	ls = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, NULL);
	gtk_combo_box_set_model ((GtkComboBox*) self->priv->deviceCombo, (GtkTreeModel*) ls);
	gtk_combo_box_entry_set_text_column (self->priv->deviceCombo, 1);
	{
		gint i;
		i = 0;
		for (; i < MOSERIAL_SETTINGS_DIALOG_max_devices; i++) {
			char* dev;
			dev = g_strdup_printf ("/dev/ttyS%d", i);
			if (g_file_test (dev, G_FILE_TEST_EXISTS)) {
				gtk_list_store_append (ls, &iter);
				gtk_list_store_set (ls, &iter, 0, "", 1, dev, -1, -1);
			}
			dev = (g_free (dev), NULL);
		}
	}
	{
		gint i;
		i = 0;
		for (; i < MOSERIAL_SETTINGS_DIALOG_max_devices; i++) {
			char* dev;
			dev = g_strdup_printf ("/dev/ttyUSB%d", i);
			if (g_file_test (dev, G_FILE_TEST_EXISTS)) {
				gtk_list_store_append (ls, &iter);
				gtk_list_store_set (ls, &iter, 0, "", 1, dev, -1, -1);
			}
			dev = (g_free (dev), NULL);
		}
	}
	(ls == NULL) ? NULL : (ls = (g_object_unref (ls), NULL));
}


void moserial_settings_dialog_show (moserialSettingsDialog* self, Settings* settings) {
	Settings* _tmp1;
	Settings* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->currentSettings = (_tmp1 = (_tmp0 = settings, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp1);
	moserial_settings_dialog_loadSettings (self);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
}


/* Load the current settings into the dialog*/
void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self) {
	GtkTreeModel* t;
	GtkTreeIter ti = {0};
	gboolean success;
	GtkTreeModel* _tmp1;
	GtkTreeModel* _tmp0;
	GtkTreeModel* _tmp5;
	GtkTreeModel* _tmp4;
	GtkTreeModel* _tmp11;
	GtkTreeModel* _tmp10;
	GtkTreeModel* _tmp17;
	GtkTreeModel* _tmp16;
	gboolean _tmp22;
	gboolean _tmp23;
	g_return_if_fail (self != NULL);
	t = NULL;
	success = FALSE;
	/*Device*/
	_tmp1 = NULL;
	_tmp0 = NULL;
	t = (_tmp1 = (_tmp0 = gtk_combo_box_get_model ((GtkComboBox*) self->priv->deviceCombo), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp1);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (success) {
		GValue str_data = {0};
		GValue _tmp3 = {0};
		GValue _tmp2 = {0};
		gtk_tree_model_get_value (t, &ti, 1, &_tmp2);
		str_data = (_tmp3 = _tmp2, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp3);
		if (_vala_strcmp0 (g_value_get_string (&str_data), settings_get_device (self->priv->currentSettings)) == 0) {
			gtk_combo_box_set_active_iter ((GtkComboBox*) self->priv->deviceCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	/*Baud Rate*/
	_tmp5 = NULL;
	_tmp4 = NULL;
	t = (_tmp5 = (_tmp4 = gtk_combo_box_get_model (self->priv->baudRateCombo), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp5);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (success) {
		GValue str_data = {0};
		GValue _tmp7 = {0};
		GValue _tmp6 = {0};
		char* _tmp8;
		gboolean _tmp9;
		gtk_tree_model_get_value (t, &ti, 0, &_tmp6);
		str_data = (_tmp7 = _tmp6, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp7);
		_tmp8 = NULL;
		if ((_tmp9 = _vala_strcmp0 (g_value_get_string (&str_data), _tmp8 = g_strdup_printf ("%i", settings_get_baudRate (self->priv->currentSettings))) == 0, _tmp8 = (g_free (_tmp8), NULL), _tmp9)) {
			gtk_combo_box_set_active_iter (self->priv->baudRateCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	/*Data Bits*/
	_tmp11 = NULL;
	_tmp10 = NULL;
	t = (_tmp11 = (_tmp10 = gtk_combo_box_get_model (self->priv->dataBitsCombo), (_tmp10 == NULL) ? NULL : g_object_ref (_tmp10)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp11);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (success) {
		GValue str_data = {0};
		GValue _tmp13 = {0};
		GValue _tmp12 = {0};
		char* _tmp14;
		gboolean _tmp15;
		gtk_tree_model_get_value (t, &ti, 0, &_tmp12);
		str_data = (_tmp13 = _tmp12, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp13);
		_tmp14 = NULL;
		if ((_tmp15 = _vala_strcmp0 (g_value_get_string (&str_data), _tmp14 = g_strdup_printf ("%i", settings_get_dataBits (self->priv->currentSettings))) == 0, _tmp14 = (g_free (_tmp14), NULL), _tmp15)) {
			gtk_combo_box_set_active_iter (self->priv->dataBitsCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	/*Stop Bits*/
	_tmp17 = NULL;
	_tmp16 = NULL;
	t = (_tmp17 = (_tmp16 = gtk_combo_box_get_model (self->priv->stopBitsCombo), (_tmp16 == NULL) ? NULL : g_object_ref (_tmp16)), (t == NULL) ? NULL : (t = (g_object_unref (t), NULL)), _tmp17);
	success = gtk_tree_model_get_iter_first (t, &ti);
	while (success) {
		GValue str_data = {0};
		GValue _tmp19 = {0};
		GValue _tmp18 = {0};
		char* _tmp20;
		gboolean _tmp21;
		gtk_tree_model_get_value (t, &ti, 0, &_tmp18);
		str_data = (_tmp19 = _tmp18, G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL, _tmp19);
		_tmp20 = NULL;
		if ((_tmp21 = _vala_strcmp0 (g_value_get_string (&str_data), _tmp20 = g_strdup_printf ("%i", settings_get_stopBits (self->priv->currentSettings))) == 0, _tmp20 = (g_free (_tmp20), NULL), _tmp21)) {
			gtk_combo_box_set_active_iter (self->priv->stopBitsCombo, &ti);
		}
		success = gtk_tree_model_iter_next (t, &ti);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	gtk_combo_box_set_active (self->priv->parityCombo, (gint) settings_get_parity (self->priv->currentSettings));
	gtk_combo_box_set_active (self->priv->accessModeCombo, (gint) settings_get_accessMode (self->priv->currentSettings));
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, FALSE);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, FALSE);
	_tmp22 = FALSE;
	if (settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_BOTH) {
		_tmp22 = TRUE;
	} else {
		_tmp22 = settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_HARDWARE;
	}
	if (_tmp22) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->hardwareHandshake, TRUE);
	}
	_tmp23 = FALSE;
	if (settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_BOTH) {
		_tmp23 = TRUE;
	} else {
		_tmp23 = settings_get_handshake (self->priv->currentSettings) == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	if (_tmp23) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->softwareHandshake, TRUE);
	}
	if (settings_get_localEcho (self->priv->currentSettings)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, TRUE);
	} else {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->localEcho, FALSE);
	}
	(t == NULL) ? NULL : (t = (g_object_unref (t), NULL));
}


gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self, GtkWidget* w) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	gtk_widget_hide_all ((GtkWidget*) self->priv->dialog);
	return TRUE;
}


void moserial_settings_dialog_cancel (moserialSettingsDialog* self, GtkWidget* w) {
	Settings* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0 = NULL;
	self->priv->currentSettings = (_tmp0 = NULL, (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp0);
	moserial_settings_dialog_hide (self, w);
}


void moserial_settings_dialog_ok (moserialSettingsDialog* self, GtkWidget* w) {
	char* device;
	gint baudRate;
	gint dataBits;
	gint stopBits;
	SettingsParity parity;
	SettingsHandshake handshake;
	SettingsAccessMode accessMode;
	gboolean pLocalEcho;
	char* _tmp1;
	const char* _tmp0;
	gboolean _tmp2;
	Settings* _tmp3;
	Settings* _tmp5;
	Settings* _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	device = NULL;
	baudRate = 0;
	dataBits = 0;
	stopBits = 0;
	parity = 0;
	handshake = 0;
	accessMode = 0;
	pLocalEcho = FALSE;
	_tmp1 = NULL;
	_tmp0 = NULL;
	device = (_tmp1 = (_tmp0 = gtk_combo_box_get_active_text ((GtkComboBox*) self->priv->deviceCombo), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), device = (g_free (device), NULL), _tmp1);
	baudRate = atoi (gtk_combo_box_get_active_text (self->priv->baudRateCombo));
	dataBits = atoi (gtk_combo_box_get_active_text (self->priv->dataBitsCombo));
	stopBits = atoi (gtk_combo_box_get_active_text (self->priv->stopBitsCombo));
	/* Glade choices must be in same order as Settings enums */
	parity = (SettingsParity) gtk_combo_box_get_active (self->priv->parityCombo);
	accessMode = (SettingsAccessMode) gtk_combo_box_get_active (self->priv->accessModeCombo);
	_tmp2 = FALSE;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake)) {
		_tmp2 = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake);
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hardwareHandshake)) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->softwareHandshake)) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	pLocalEcho = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->localEcho);
	_tmp3 = NULL;
	self->priv->settings = (_tmp3 = settings_new (device, baudRate, dataBits, stopBits, parity, handshake, accessMode, pLocalEcho), (self->priv->settings == NULL) ? NULL : (self->priv->settings = (g_object_unref (self->priv->settings), NULL)), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->currentSettings = (_tmp5 = (_tmp4 = self->priv->settings, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL)), _tmp5);
	g_signal_emit_by_name (self, "update-settings", self->priv->currentSettings);
	moserial_settings_dialog_hide (self, w);
	device = (g_free (device), NULL);
}


GtkBuilder* moserial_settings_dialog_get_builder (moserialSettingsDialog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_builder;
}


static void moserial_settings_dialog_set_builder (moserialSettingsDialog* self, GtkBuilder* value) {
	GtkBuilder* _tmp2;
	GtkBuilder* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_builder = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "builder");
}


static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkDialog* _sender, const GdkEvent* event, gpointer self) {
	return moserial_settings_dialog_hide (self, _sender);
}


static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_cancel (self, _sender);
}


static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	moserial_settings_dialog_ok (self, _sender);
}


static GObject * moserial_settings_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	moserialSettingsDialogClass * klass;
	GObjectClass * parent_class;
	moserialSettingsDialog * self;
	klass = MOSERIAL_SETTINGS_DIALOG_CLASS (g_type_class_peek (MOSERIAL_TYPE_SETTINGS_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	{
		GtkDialog* _tmp1;
		GtkDialog* _tmp0;
		GtkButton* _tmp3;
		GtkButton* _tmp2;
		GtkButton* _tmp5;
		GtkButton* _tmp4;
		GtkComboBoxEntry* _tmp7;
		GtkComboBoxEntry* _tmp6;
		GtkComboBox* _tmp9;
		GtkComboBox* _tmp8;
		GtkComboBox* _tmp11;
		GtkComboBox* _tmp10;
		GtkComboBox* _tmp13;
		GtkComboBox* _tmp12;
		GtkComboBox* _tmp15;
		GtkComboBox* _tmp14;
		GtkCheckButton* _tmp17;
		GtkCheckButton* _tmp16;
		GtkCheckButton* _tmp19;
		GtkCheckButton* _tmp18;
		GtkComboBox* _tmp21;
		GtkComboBox* _tmp20;
		GtkCheckButton* _tmp23;
		GtkCheckButton* _tmp22;
		_tmp1 = NULL;
		_tmp0 = NULL;
		self->priv->dialog = (_tmp1 = (_tmp0 = GTK_DIALOG (gtk_builder_get_object (self->priv->_builder, "settings_dialog")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL)), _tmp1);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->cancelButton = (_tmp3 = (_tmp2 = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_cancel_button")), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL)), _tmp3);
		_tmp5 = NULL;
		_tmp4 = NULL;
		self->priv->okButton = (_tmp5 = (_tmp4 = GTK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_ok_button")), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL)), _tmp5);
		_tmp7 = NULL;
		_tmp6 = NULL;
		self->priv->deviceCombo = (_tmp7 = (_tmp6 = GTK_COMBO_BOX_ENTRY (gtk_builder_get_object (self->priv->_builder, "settings_device")), (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6)), (self->priv->deviceCombo == NULL) ? NULL : (self->priv->deviceCombo = (g_object_unref (self->priv->deviceCombo), NULL)), _tmp7);
		_tmp9 = NULL;
		_tmp8 = NULL;
		self->priv->baudRateCombo = (_tmp9 = (_tmp8 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_baud_rate")), (_tmp8 == NULL) ? NULL : g_object_ref (_tmp8)), (self->priv->baudRateCombo == NULL) ? NULL : (self->priv->baudRateCombo = (g_object_unref (self->priv->baudRateCombo), NULL)), _tmp9);
		_tmp11 = NULL;
		_tmp10 = NULL;
		self->priv->dataBitsCombo = (_tmp11 = (_tmp10 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_data_bits")), (_tmp10 == NULL) ? NULL : g_object_ref (_tmp10)), (self->priv->dataBitsCombo == NULL) ? NULL : (self->priv->dataBitsCombo = (g_object_unref (self->priv->dataBitsCombo), NULL)), _tmp11);
		_tmp13 = NULL;
		_tmp12 = NULL;
		self->priv->stopBitsCombo = (_tmp13 = (_tmp12 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_stop_bits")), (_tmp12 == NULL) ? NULL : g_object_ref (_tmp12)), (self->priv->stopBitsCombo == NULL) ? NULL : (self->priv->stopBitsCombo = (g_object_unref (self->priv->stopBitsCombo), NULL)), _tmp13);
		_tmp15 = NULL;
		_tmp14 = NULL;
		self->priv->parityCombo = (_tmp15 = (_tmp14 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_parity")), (_tmp14 == NULL) ? NULL : g_object_ref (_tmp14)), (self->priv->parityCombo == NULL) ? NULL : (self->priv->parityCombo = (g_object_unref (self->priv->parityCombo), NULL)), _tmp15);
		_tmp17 = NULL;
		_tmp16 = NULL;
		self->priv->hardwareHandshake = (_tmp17 = (_tmp16 = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_hardware_handshake")), (_tmp16 == NULL) ? NULL : g_object_ref (_tmp16)), (self->priv->hardwareHandshake == NULL) ? NULL : (self->priv->hardwareHandshake = (g_object_unref (self->priv->hardwareHandshake), NULL)), _tmp17);
		_tmp19 = NULL;
		_tmp18 = NULL;
		self->priv->softwareHandshake = (_tmp19 = (_tmp18 = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_software_handshake")), (_tmp18 == NULL) ? NULL : g_object_ref (_tmp18)), (self->priv->softwareHandshake == NULL) ? NULL : (self->priv->softwareHandshake = (g_object_unref (self->priv->softwareHandshake), NULL)), _tmp19);
		_tmp21 = NULL;
		_tmp20 = NULL;
		self->priv->accessModeCombo = (_tmp21 = (_tmp20 = GTK_COMBO_BOX (gtk_builder_get_object (self->priv->_builder, "settings_open_for")), (_tmp20 == NULL) ? NULL : g_object_ref (_tmp20)), (self->priv->accessModeCombo == NULL) ? NULL : (self->priv->accessModeCombo = (g_object_unref (self->priv->accessModeCombo), NULL)), _tmp21);
		_tmp23 = NULL;
		_tmp22 = NULL;
		self->priv->localEcho = (_tmp23 = (_tmp22 = GTK_CHECK_BUTTON (gtk_builder_get_object (self->priv->_builder, "settings_local_echo")), (_tmp22 == NULL) ? NULL : g_object_ref (_tmp22)), (self->priv->localEcho == NULL) ? NULL : (self->priv->localEcho = (g_object_unref (self->priv->localEcho), NULL)), _tmp23);
		g_signal_connect_object ((GtkWidget*) self->priv->dialog, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
		g_signal_connect_object (self->priv->cancelButton, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
		g_signal_connect_object (self->priv->okButton, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
		moserial_settings_dialog_populateDevices (self);
	}
	return obj;
}


static void moserial_settings_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	gpointer boxed;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		g_value_set_object (value, moserial_settings_dialog_get_builder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_settings_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (object);
	switch (property_id) {
		case MOSERIAL_SETTINGS_DIALOG_BUILDER:
		moserial_settings_dialog_set_builder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass) {
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->get_property = moserial_settings_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = moserial_settings_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_settings_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SETTINGS_DIALOG_BUILDER, g_param_spec_object ("builder", "builder", "builder", GTK_TYPE_BUILDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("update_settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}


static void moserial_settings_dialog_instance_init (moserialSettingsDialog * self) {
	self->priv = MOSERIAL_SETTINGS_DIALOG_GET_PRIVATE (self);
}


static void moserial_settings_dialog_finalize (GObject* obj) {
	moserialSettingsDialog * self;
	self = MOSERIAL_SETTINGS_DIALOG (obj);
	(self->priv->_builder == NULL) ? NULL : (self->priv->_builder = (g_object_unref (self->priv->_builder), NULL));
	(self->priv->currentSettings == NULL) ? NULL : (self->priv->currentSettings = (g_object_unref (self->priv->currentSettings), NULL));
	(self->priv->dialog == NULL) ? NULL : (self->priv->dialog = (g_object_unref (self->priv->dialog), NULL));
	(self->priv->cancelButton == NULL) ? NULL : (self->priv->cancelButton = (g_object_unref (self->priv->cancelButton), NULL));
	(self->priv->okButton == NULL) ? NULL : (self->priv->okButton = (g_object_unref (self->priv->okButton), NULL));
	(self->priv->settings == NULL) ? NULL : (self->priv->settings = (g_object_unref (self->priv->settings), NULL));
	(self->priv->deviceCombo == NULL) ? NULL : (self->priv->deviceCombo = (g_object_unref (self->priv->deviceCombo), NULL));
	(self->priv->baudRateCombo == NULL) ? NULL : (self->priv->baudRateCombo = (g_object_unref (self->priv->baudRateCombo), NULL));
	(self->priv->dataBitsCombo == NULL) ? NULL : (self->priv->dataBitsCombo = (g_object_unref (self->priv->dataBitsCombo), NULL));
	(self->priv->stopBitsCombo == NULL) ? NULL : (self->priv->stopBitsCombo = (g_object_unref (self->priv->stopBitsCombo), NULL));
	(self->priv->parityCombo == NULL) ? NULL : (self->priv->parityCombo = (g_object_unref (self->priv->parityCombo), NULL));
	(self->priv->hardwareHandshake == NULL) ? NULL : (self->priv->hardwareHandshake = (g_object_unref (self->priv->hardwareHandshake), NULL));
	(self->priv->softwareHandshake == NULL) ? NULL : (self->priv->softwareHandshake = (g_object_unref (self->priv->softwareHandshake), NULL));
	(self->priv->accessModeCombo == NULL) ? NULL : (self->priv->accessModeCombo = (g_object_unref (self->priv->accessModeCombo), NULL));
	(self->priv->localEcho == NULL) ? NULL : (self->priv->localEcho = (g_object_unref (self->priv->localEcho), NULL));
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}


GType moserial_settings_dialog_get_type (void) {
	static GType moserial_settings_dialog_type_id = 0;
	if (moserial_settings_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
		moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
	}
	return moserial_settings_dialog_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




