
#ifndef __SRC_SERIALCONNECTION_H__
#define __SRC_SERIALCONNECTION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "src/Settings.h"

G_BEGIN_DECLS


#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;

#define MOSERIAL_SERIAL_CONNECTION_TYPE_LINE_END (moserial_serial_connection_line_end_get_type ())

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	char* echoReference;
	char* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CR,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_LF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE
} moserialSerialConnectionLineEnd;


GType moserial_serial_connection_line_end_get_type (void);
gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
char* moserial_serial_connection_getLineEnd (moserialSerialConnection* self, gint e);
void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
char* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
moserialSerialConnection* moserial_serial_connection_new (void);
GType moserial_serial_connection_get_type (void);


G_END_DECLS

#endif
