/*
 * Copyright (C) 2019 Red Hat
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#ifndef META_BACKEND_NATIVE_TYPES_H
#define META_BACKEND_NATIVE_TYPES_H

typedef struct _MetaBackendNative MetaBackendNative;
typedef struct _MetaSeatNative MetaSeatNative;
typedef struct _MetaSeatImpl MetaSeatImpl;
typedef struct _MetaKeymapNative MetaKeymapNative;
typedef struct _MetaRendererNative MetaRendererNative;
typedef struct _MetaGpuKms MetaGpuKms;
typedef struct _MetaCrtcVirtual MetaCrtcVirtual;
typedef struct _MetaCrtcModeVirtual MetaCrtcModeVirtual;
typedef struct _MetaDevicePool MetaDevicePool;
typedef struct _MetaDeviceFile MetaDeviceFile;
typedef struct _MetaDrmBuffer MetaDrmBuffer;

typedef enum _MetaSeatNativeFlag
{
  META_SEAT_NATIVE_FLAG_NONE = 0,
  META_SEAT_NATIVE_FLAG_NO_LIBINPUT = 1 << 0,
} MetaSeatNativeFlag;

#endif /* META_BACKEND_NATIVE_TYPES_H */
