///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "textmeta.h"

#include "streamdialog.h"
#include "textviewent.h"
#include "widget/wmisc.h"
#include "widget/spinner.h"
#include "widget/subpanel.h"
#include "document/textframe.h"
#include "document/document.h"

#include <gtkmm/separator.h>
#include <gtkmm/sizegroup.h>

Pagent* TextMeta::load(const xmlpp::Element& node, Group* parent) {
  return new TextFrame(parent, node);
}

Viewent::Ref TextMeta::create_viewent(View& view, Pagent& node) {
  Viewent::Ref result(new TextViewent
		      (view, &dynamic_cast<TextFrame&>(node), 2));
  result->reference();
  return result;
}

class PropText : public GenericProp<TextFrame> {
public:
  PropText()
    : GenericProp<TextFrame>("Te_xt"),
     e_columns(1, false), e_gutter(0, true, &length_units)
  {
    Glib::RefPtr<Gtk::SizeGroup>  sizegroup = 
      Gtk::SizeGroup::create(Gtk::SIZE_GROUP_HORIZONTAL);
    
    Gtk::Box *line = manage(new Gtk::HBox(false, single_space));
    Gtk::Label *label = manage(new Gtk::Label("_Stream:", 0.0, 0.5, true));
    line->pack_start(*label, Gtk::PACK_SHRINK);
    // sizegroup->add_widget(*label);
    label->set_mnemonic_widget(e_stream);
    
    line->pack_start(e_stream, Gtk::PACK_EXPAND_WIDGET);
    Gtk::Button *b_streams = manage(new Gtk::Button("E_dit streams", true));
    b_streams->signal_clicked().connect(slot(StreamDialog::instance(),
					     &StreamDialog::show_raise));
    line->pack_start(*b_streams, Gtk::PACK_SHRINK);
    pack_start(*line, Gtk::PACK_SHRINK);
    
    SubPanel *box = manage(new SubPanel("Columns"));
    line = manage(new Gtk::HBox(false, double_space));
    line->pack_start(*(label = manage(new Gtk::Label("Number of _columns:", 
						     0.0, 0.5, true))),
		     Gtk::PACK_SHRINK);
    sizegroup->add_widget(*label);
    label->set_mnemonic_widget(e_columns);
    e_columns.limits(1, 64);	// Note: The upper limit is rather arbitrary.
    line->pack_start(e_columns, Gtk::PACK_SHRINK);
    box->pack_start(*line);
    
    line = manage(new Gtk::HBox(false, double_space));
    line->pack_start(*(label = manage(new Gtk::Label("_Gutter width:",
						     0.0, 0.5, true))),
		     Gtk::PACK_SHRINK);
    sizegroup->add_widget(*label);
    label->set_mnemonic_widget(e_gutter);
    line->pack_start(e_gutter, Gtk::PACK_SHRINK);
    box->pack_start(*line);
    pack_start(*box, Gtk::PACK_SHRINK);
    
    set_sensitive(false);
    update();
  }
  
  void update() {
    if(object) {
      //The text stream of a text frame may be null.
      //This will happen, for instance, when the stream 
      //associated with the frame is deleted.
      if(object->get_stream()) 
	e_stream.update(Document::containing(*object).self(),
			object->get_stream()->get_name());
      else
	e_stream.update(Document::containing(*object).self());
      e_columns.set(object->get_num_columns());
      e_gutter.set(object->get_gutter());
    } else {
      e_stream.update(Document::null());
    }
  }
  void apply() {
    if(!object) return;
    object->set_num_columns(int(e_columns.get()));
    object->set_gutter(e_gutter.get());
    TextStream *stream=
      Document::containing(*object).get_text_stream(e_stream.get_stream());
    object->set_stream(stream);
  }
  
private:
  Gtk::HSeparator hsep;
  StreamMenu e_stream;
  Spinner e_columns, e_gutter;
};

PropBase* TextMeta::getProp() {
  return new PropText;
}

