/* Generated by GOB (v1.0.9) on Mon Jun  4 03:59:30 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "pong-color-picker.gob"

/* PonG: color picker
 * Author: George Lebl
 * (c) 2000 Eazel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 30 "pong-color-picker.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9


#line 26 "pong-color-picker.gob"

#include "config.h"
#include <gnome.h>

#include "pong-i18n.h"

#include "pongpane.h"
#include "pongutil.h"
#include "pongwidgetutil.h"

#include "pong-color-picker.h"
#include "pong-color-picker-private.h"


#line 51 "pong-color-picker.c"
/* self casting macros */
#define SELF(x) PONG_COLOR_PICKER(x)
#define SELF_CONST(x) PONG_COLOR_PICKER_CONST(x)
#define IS_SELF(x) PONG_IS_COLOR_PICKER(x)
#define TYPE_SELF PONG_TYPE_COLOR_PICKER
#define SELF_CLASS(x) PONG_COLOR_PICKER_CLASS(x)

#define SELF_GET_CLASS(x) PONG_COLOR_PICKER_GET_CLASS(x)

/* self typedefs */
typedef PongColorPicker Self;
typedef PongColorPickerClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void ___object_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void pong_color_picker_class_init (PongColorPickerClass * klass) G_GNUC_UNUSED;
static void pong_color_picker_init (PongColorPicker * self) G_GNUC_UNUSED;
static void pong_color_picker_changed (PongColorPicker * self) G_GNUC_UNUSED;
static gboolean pong_color_picker_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) G_GNUC_UNUSED;
static gboolean pong_color_picker_set_value (GtkWidget * w, const char * specifier, GConfValue * value) G_GNUC_UNUSED;
static void ___7_pong_color_picker_clicked (GtkButton * self) G_GNUC_UNUSED;

enum {
	CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	ARG_0,
	ARG_TITLE,
	ARG_USE_ALPHA,
	ARG_DITHER
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GnomeColorPickerClass *parent_class = NULL;

GtkType
pong_color_picker_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"PongColorPicker",
			sizeof (PongColorPicker),
			sizeof (PongColorPickerClass),
			(GtkClassInitFunc) pong_color_picker_class_init,
			(GtkObjectInitFunc) pong_color_picker_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gnome_color_picker_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define new() pong_color_picker_new()
#define changed(args...) pong_color_picker_changed(args)
#define get_value(args...) pong_color_picker_get_value(args)
#define set_value(args...) pong_color_picker_set_value(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkWidget * (* const new) (void) = pong_color_picker_new;
static void (* const changed) (PongColorPicker * self) = pong_color_picker_changed;
static gboolean (* const get_value) (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) = pong_color_picker_get_value;
static gboolean (* const set_value) (GtkWidget * w, const char * specifier, GConfValue * value) = pong_color_picker_set_value;

/* a macro for creating a new object of our type */
#define GET_NEW ((PongColorPicker *)gtk_type_new(pong_color_picker_get_type()))

#line 47 "pong-color-picker.gob"
static void 
pong_color_picker_class_init (PongColorPickerClass * klass)
#line 139 "pong-color-picker.c"
{
#define __GOB_FUNCTION__ "Pong:Color:Picker::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) klass;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) klass;
#endif /* G_OBJECT_CLASS */
	GtkButtonClass *gtk_button_class = (GtkButtonClass *)klass;

	parent_class = gtk_type_class (gnome_color_picker_get_type ());

	object_signals[CHANGED_SIGNAL] =
		gtk_signal_new ("changed",
			(GtkSignalRunType)(GTK_RUN_LAST),
			GTK_CLASS_TYPE(gtk_object_class),
			GTK_SIGNAL_OFFSET (PongColorPickerClass, changed),
			gtk_signal_default_marshaller,
			GTK_TYPE_NONE, 0);
	gtk_object_class_add_signals (gtk_object_class,
		object_signals, LAST_SIGNAL);


	klass->changed = NULL;
#line 420 "pong-color-picker.gob"
	gtk_button_class->clicked = ___7_pong_color_picker_clicked;
#line 164 "pong-color-picker.c"

	gtk_object_add_arg_type("PongColorPicker::title",
		GTK_TYPE_STRING,
		GTK_ARG_WRITABLE,
		ARG_TITLE);
	gtk_object_add_arg_type("PongColorPicker::use_alpha",
		GTK_TYPE_BOOL,
		GTK_ARG_WRITABLE,
		ARG_USE_ALPHA);
	gtk_object_add_arg_type("PongColorPicker::dither",
		GTK_TYPE_BOOL,
		GTK_ARG_WRITABLE,
		ARG_DITHER);

	gtk_object_class->set_arg = ___object_set_arg;
 {
#line 48 "pong-color-picker.gob"

		PongWidgetInterface *iface;

		iface = pong_widget_interface_add (GTK_OBJECT_CLASS (klass));
		iface->changed_signal = "changed";
		iface->get_value = get_value;
		iface->set_value = set_value;
	
#line 190 "pong-color-picker.c"
 }
	return;
	klass = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__
#line 57 "pong-color-picker.gob"
static void 
pong_color_picker_init (PongColorPicker * self)
#line 203 "pong-color-picker.c"
{
#define __GOB_FUNCTION__ "Pong:Color:Picker::init"
	self->_priv = NULL;
 {
#line 58 "pong-color-picker.gob"

		gtk_signal_connect_object_while_alive
			(GTK_OBJECT (self), "color_set",
			 GTK_SIGNAL_FUNC (changed),
			 GTK_OBJECT (self));
	
#line 215 "pong-color-picker.c"
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_set_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Pong:Color:Picker::set_arg"
{
	PongColorPicker *self;

	self = PONG_COLOR_PICKER (object);

	switch (arg_id) {
	case ARG_TITLE:
#define ARG (GTK_VALUE_STRING(*arg))
		{
#line 66 "pong-color-picker.gob"

			gnome_color_picker_set_title
				(GNOME_COLOR_PICKER (self), ARG);
		
#line 241 "pong-color-picker.c"
		}
		break;
#undef ARG
	case ARG_USE_ALPHA:
#define ARG (GTK_VALUE_BOOL(*arg))
		{
#line 72 "pong-color-picker.gob"

			gnome_color_picker_set_use_alpha
				(GNOME_COLOR_PICKER (self), ARG);
		
#line 253 "pong-color-picker.c"
		}
		break;
#undef ARG
	case ARG_DITHER:
#define ARG (GTK_VALUE_BOOL(*arg))
		{
#line 78 "pong-color-picker.gob"

			gnome_color_picker_set_dither
				(GNOME_COLOR_PICKER (self), ARG);
		
#line 265 "pong-color-picker.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__



/**
 * pong_color_picker_new:
 *
 * Description:  Create a new #PongColorPicker widget
 *
 * Returns:  A new #PongColorPicker widget
 **/
#line 90 "pong-color-picker.gob"
GtkWidget * 
pong_color_picker_new (void)
#line 290 "pong-color-picker.c"
{
#define __GOB_FUNCTION__ "Pong:Color:Picker::new"
{
#line 93 "pong-color-picker.gob"
	
		return (GtkWidget *) GET_NEW;
	}}
#line 298 "pong-color-picker.c"
#undef __GOB_FUNCTION__

#line 97 "pong-color-picker.gob"
static void 
pong_color_picker_changed (PongColorPicker * self)
#line 304 "pong-color-picker.c"
{
#line 97 "pong-color-picker.gob"
	g_return_if_fail (self != NULL);
#line 97 "pong-color-picker.gob"
	g_return_if_fail (PONG_IS_COLOR_PICKER (self));
#line 310 "pong-color-picker.c"
	gtk_signal_emit (GTK_OBJECT (self),
		object_signals[CHANGED_SIGNAL]);
}

#line 101 "pong-color-picker.gob"
static gboolean 
pong_color_picker_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value)
#line 318 "pong-color-picker.c"
{
#define __GOB_FUNCTION__ "Pong:Color:Picker::get_value"
#line 101 "pong-color-picker.gob"
	g_return_val_if_fail (w != NULL, (gboolean )0);
#line 101 "pong-color-picker.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )0);
#line 101 "pong-color-picker.gob"
	g_return_val_if_fail (value != NULL, (gboolean )0);
#line 327 "pong-color-picker.c"
{
#line 106 "pong-color-picker.gob"
	
		char *text;
		long i;
		GnomeColorPicker *picker = GNOME_COLOR_PICKER (w);

		*value = NULL;

		g_return_val_if_fail (type > PONG_TYPE_INVALID &&
				      type < PONG_TYPE_LAST, FALSE);

		if (type != PONG_TYPE_STRING &&
		    type != PONG_TYPE_FLOAT &&
		    type != PONG_TYPE_INT &&
		    type != PONG_TYPE_LIST_OF_INTS) {
			g_warning(_("Unsupported type on Pong:Color:Picker"));
			return FALSE;
		}


		switch(type) {
		case PONG_TYPE_STRING:
			text = pong_gnome_color_picker_get_text (picker);
			*value = gconf_value_new (GCONF_VALUE_STRING);
			gconf_value_set_string (*value, text);
			g_free (text);
			break;
		case PONG_TYPE_FLOAT:
			*value = gconf_value_new (GCONF_VALUE_FLOAT);
			if (specifier != NULL &&
			    pong_strcasecmp_no_locale (specifier, "red") == 0) {
				double r;
				gnome_color_picker_get_d (picker, &r,
							  NULL, NULL, NULL);
				gconf_value_set_int (*value, r);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "green") == 0) {
				double g;
				gnome_color_picker_get_d (picker, NULL,
							  &g, NULL, NULL);
				gconf_value_set_int (*value, g);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "blue") == 0) {
				double b;
				gnome_color_picker_get_d (picker, NULL,
							  NULL, &b, NULL);
				gconf_value_set_int (*value, b);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "alpha") == 0) {
				double a;
				gnome_color_picker_get_d (picker, NULL,
							  NULL, NULL, &a);
				gconf_value_set_int (*value, a);
			} else {
				i = pong_gnome_color_picker_get_long (picker);
				gconf_value_set_int (*value, i);
			}
			break;
		case PONG_TYPE_INT:
			if (specifier != NULL &&
			    pong_strcasecmp_no_locale (specifier, "red") == 0) {
				guint8 r;
				gnome_color_picker_get_i8 (picker, &r,
							   NULL, NULL, NULL);
				i = r;
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "green") == 0) {
				guint8 g;
				gnome_color_picker_get_i8 (picker, NULL,
							   &g, NULL, NULL);
				i = g;
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "blue") == 0) {
				guint8 b;
				gnome_color_picker_get_i8 (picker, NULL,
							   NULL, &b, NULL);
				i = b;
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "alpha") == 0) {
				guint8 a;
				gnome_color_picker_get_i8 (picker, NULL,
							   NULL, NULL, &a);
				i = a;
			} else {
				i = pong_gnome_color_picker_get_long (picker);
			}
			*value = gconf_value_new (GCONF_VALUE_INT);
			gconf_value_set_int (*value, i);
			break;
		case PONG_TYPE_LIST_OF_INTS:
			{
				guint8 r, g, b, a;
				GSList *list = NULL;
				GConfValue *val;

				gnome_color_picker_get_i8 (picker,
							   &r, &g, &b, &a);

				*value = gconf_value_new (GCONF_VALUE_LIST);
				gconf_value_set_list_type (*value,
							   GCONF_VALUE_INT);

				val = gconf_value_new (GCONF_VALUE_INT);
				gconf_value_set_int (val, r);
				list = g_slist_append (list, val);

				val = gconf_value_new (GCONF_VALUE_INT);
				gconf_value_set_int (val, g);
				list = g_slist_append (list, val);

				val = gconf_value_new (GCONF_VALUE_INT);
				gconf_value_set_int (val, b);
				list = g_slist_append (list, val);

				if (picker->use_alpha) {
					val = gconf_value_new (GCONF_VALUE_INT);
					gconf_value_set_int (val, a);
					list = g_slist_append (list, val);
				}

				gconf_value_set_list_nocopy (*value, list);
			}
			break;
		case PONG_TYPE_LIST_OF_FLOATS:
			{
				double r, g, b, a;
				GSList *list = NULL;
				GConfValue *val;

				gnome_color_picker_get_d (picker,
							  &r, &g, &b, &a);

				*value = gconf_value_new (GCONF_VALUE_LIST);
				gconf_value_set_list_type (*value,
							   GCONF_VALUE_FLOAT);

				val = gconf_value_new (GCONF_VALUE_FLOAT);
				gconf_value_set_float (val, r);
				list = g_slist_append (list, val);

				val = gconf_value_new (GCONF_VALUE_FLOAT);
				gconf_value_set_float (val, g);
				list = g_slist_append (list, val);

				val = gconf_value_new (GCONF_VALUE_FLOAT);
				gconf_value_set_float (val, b);
				list = g_slist_append (list, val);

				if (picker->use_alpha) {
					val = gconf_value_new
						(GCONF_VALUE_FLOAT);
					gconf_value_set_float (val, a);
					list = g_slist_append (list, val);
				}

				gconf_value_set_list_nocopy (*value, list);
			}
			break;
		default:
			g_assert_not_reached();
			break;
		}

		return TRUE;
	}}
#line 500 "pong-color-picker.c"
#undef __GOB_FUNCTION__

#line 277 "pong-color-picker.gob"
static gboolean 
pong_color_picker_set_value (GtkWidget * w, const char * specifier, GConfValue * value)
#line 506 "pong-color-picker.c"
{
#define __GOB_FUNCTION__ "Pong:Color:Picker::set_value"
#line 277 "pong-color-picker.gob"
	g_return_val_if_fail (w != NULL, (gboolean )0);
#line 277 "pong-color-picker.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )0);
#line 277 "pong-color-picker.gob"
	g_return_val_if_fail (value != NULL, (gboolean )0);
#line 515 "pong-color-picker.c"
{
#line 281 "pong-color-picker.gob"
	
		guint8 r, g, b, a;
		double dr, dg, db, da;
		gboolean color_set;
		GSList *li;
		GnomeColorPicker *picker = GNOME_COLOR_PICKER (w);
		PongType type;

		type = pong_type_from_gconf_value(value);

		if (type != PONG_TYPE_STRING &&
		    type != PONG_TYPE_INT &&
		    type != PONG_TYPE_FLOAT &&
		    type != PONG_TYPE_LIST_OF_INTS) {
			g_warning (_("Unsupported type on Pong:Color:Picker"));
			return FALSE;
		}

		switch (type) {
		case PONG_TYPE_STRING:
			pong_gnome_color_picker_set_text
				(picker, gconf_value_get_string (value));
			break;
		case PONG_TYPE_INT:
			color_set = TRUE;
			gnome_color_picker_get_i8 (picker, &r,
						   &g, &b, &a);
			if (specifier != NULL &&
			    pong_strcasecmp_no_locale (specifier, "red") == 0) {
				r = gconf_value_get_int (value);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "green") == 0) {
				g = gconf_value_get_int (value);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "blue") == 0) {
				b = gconf_value_get_int (value);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "alpha") == 0) {
				a = gconf_value_get_int (value);
			} else {
				int i = gconf_value_get_int (value);
				pong_gnome_color_picker_set_long (picker, i);
				color_set = TRUE;
			}
			if ( ! color_set)
				gnome_color_picker_set_i8 (picker, r,
							   g, b, a);
			break;
		case PONG_TYPE_FLOAT:
			color_set = TRUE;
			gnome_color_picker_get_d (picker, &dr,
						  &dg, &db, &da);
			if (specifier != NULL &&
			    pong_strcasecmp_no_locale (specifier, "red") == 0) {
				dr = gconf_value_get_float (value);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "green") == 0) {
				dg = gconf_value_get_float (value);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "blue") == 0) {
				db = gconf_value_get_float (value);
			} else if (specifier != NULL &&
				   pong_strcasecmp_no_locale (specifier,
							      "alpha") == 0) {
				da = gconf_value_get_float (value);
			} else {
				int i = gconf_value_get_float (value);
				pong_gnome_color_picker_set_long (picker, i);
				color_set = TRUE;
			}
			if ( ! color_set)
				gnome_color_picker_set_d (picker, dr,
							  dg, db, da);
			break;
		case PONG_TYPE_LIST_OF_INTS:
			gnome_color_picker_get_i8 (picker, &r,
						   &g, &b, &a);
			li = gconf_value_get_list (value);
			if (li != NULL) {
				GConfValue *val = li->data;
				r = gconf_value_get_int (val);
				li = li->next;
			}
			if (li != NULL) {
				GConfValue *val = li->data;
				g = gconf_value_get_int (val);
				li = li->next;
			}
			if (li != NULL) {
				GConfValue *val = li->data;
				b = gconf_value_get_int (val);
				li = li->next;
			}
			if (li != NULL) {
				GConfValue *val = li->data;
				a = gconf_value_get_int (val);
			}

			gnome_color_picker_set_i8 (picker, r, g, b, a);
			break;
		case PONG_TYPE_LIST_OF_FLOATS:
			gnome_color_picker_get_d (picker, &dr,
						  &dg, &db, &da);
			li = gconf_value_get_list (value);
			if (li != NULL) {
				GConfValue *val = li->data;
				dr = gconf_value_get_float (val);
				li = li->next;
			}
			if (li != NULL) {
				GConfValue *val = li->data;
				dg = gconf_value_get_float (val);
				li = li->next;
			}
			if (li != NULL) {
				GConfValue *val = li->data;
				db = gconf_value_get_float (val);
				li = li->next;
			}
			if (li != NULL) {
				GConfValue *val = li->data;
				da = gconf_value_get_float (val);
			}

			gnome_color_picker_set_d (picker, dr, dg, db, da);
			break;
		default:
			g_assert_not_reached ();
			break;
		}

		return TRUE;
	}}
#line 656 "pong-color-picker.c"
#undef __GOB_FUNCTION__

#line 420 "pong-color-picker.gob"
static void 
___7_pong_color_picker_clicked (GtkButton * self)
#line 662 "pong-color-picker.c"
#define PARENT_HANDLER(___self) \
	{ if(GTK_BUTTON_CLASS(parent_class)->clicked) \
		(* GTK_BUTTON_CLASS(parent_class)->clicked)(___self); }
{
#define __GOB_FUNCTION__ "Pong:Color:Picker::clicked"
#line 420 "pong-color-picker.gob"
	g_return_if_fail (self != NULL);
#line 420 "pong-color-picker.gob"
	g_return_if_fail (GTK_IS_BUTTON (self));
#line 672 "pong-color-picker.c"
{
#line 423 "pong-color-picker.gob"
	
		GtkWidget *toplevel;
		GnomeColorPicker *cp;

		PARENT_HANDLER (self);

		cp = GNOME_COLOR_PICKER (self);

		if (cp->cs_dialog == NULL)
			return;

		toplevel = gtk_widget_get_toplevel (GTK_WIDGET (self));

		/* sanity */
		if (toplevel == NULL)
			return;

		gtk_window_set_transient_for (GTK_WINDOW (cp->cs_dialog),
					      GTK_WINDOW (toplevel));
	}}
#line 695 "pong-color-picker.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___pong_color_picker_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
	((void (*)(void))changed)();
	((void (*)(void))get_value)();
	((void (*)(void))set_value)();
	___pong_color_picker_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

