# Note that this is NOT a relocatable package
%define ver		1.0.1
%define RELEASE		1
%define rel		%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Name:		pong
Summary:	pong
Version: 	%ver
Release: 	%rel
License: 	GPL
Group:		System Environment/Libraries
Source: 	%{name}-%{ver}.tar.gz
URL: 		http://www.gnome.org/
BuildRoot:	/var/tmp/%{name}-%{ver}-root
Packager:	Jan Van Buggenhout <Chipzz@ULYSSIS.Org>
# Is this (libxml) correct? Does it explicitely require libxml or does one of the libraries it depends on?
Requires:	libxml, libglade, gob >= 1.0.7
Requires:	oaf >= 0.6.0
# Is this correct? GConf API changed between 0.8.0 and 0.9.0 IIRC
Requires:	GConf >= 0.6.0
Requires:	gdk-pixbuf >= 0.7.0
Requires:	bonobo >= 0.36

%description

%package devel
Summary:	pong
Group:		Development/Libraries
Requires:	%name = %{PACKAGE_VERSION}

%description devel

%package edit
Summary:	pong
Group:		Development/Libraries
Requires:	%name = %{PACKAGE_VERSION}

%description edit

%changelog
* Wed May 02 2001 George Lebl <jirka@5z.com>
- Modified the original from Chipzz <chipzz@ULYSSIS.Org> a bit to update
  the filelists

%prep
%setup -q

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS --prefix=%{_prefix}

make -k

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{_prefix}/lib /etc/ld.so.conf > /dev/null ; then
	echo "%{_prefix}/lib" >> /etc/ld.so.conf
fi
  
/sbin/ldconfig
  
%postun -p /sbin/ldconfig

%files
%{_bindir}/pong-tool-1
%{_bindir}/pong-tool
%{_libdir}/*.so.*
%{_datadir}/idl/pong-interface.idl
%{_datadir}/locale/*/*/*
%{_datadir}/gnome/help/*
%{_datadir}/omf/*

%files devel
%{_bindir}/pong-gconf-schema-export-1
%{_bindir}/pong-gconf-schema-export
%{_libdir}/*.so
%{_libdir}/*.la
%{_libdir}/*.a
%{_libdir}/*.sh
%{_includedir}/pong-1/*

%files edit
%{_bindir}/pong-edit-1
%{_bindir}/pong-edit
%{_datadir}/gnome/apps/Development/pong-edit.desktop
%{_datadir}/pong-1/pong-edit.glade
