/* Generated by GOB (v1.0.9) on Mon Jun  4 04:01:02 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "pong-bonobo-entry.gob"

/* PonG: Bonobo Configuration Widget Framework
 * Author: George Lebl
 * (c) 2001 Eazel, Inc.
 * (c) 2001 George Lebl
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This is the "easy to use" library interface for writing pong bonobo
 * controls.  You must link right now to all the pong libraries including
 * bonobo pong.  This is likely ok since you may just want to set your app
 * up as a factory, and that already links to pong.
 */

#line 38 "pong-bonobo-entry.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#include <string.h> /* memset() */


#line 36 "pong-bonobo-entry.gob"

#include "config.h"
#include <gnome.h>
#include <bonobo.h>
#include <bonobo/bonobo-plug.h>

#include "../pong/pong-i18n.h"

#include "../pong/pongpane.h"
#include "../pong/pongutil.h"
#include "../pong/pong-widget-interface.h"

#include "pong-interface.h"

/* there are implementations of the bonobo<->gconf translations in
 * the bonobo widget private headers */
#include "pong-bonobo-widget.h"
#include "pong-bonobo-widget-private.h"

#include "pong-bonobo-entry-label.h"
#include "pong-bonobo-entry-arguments.h"

#include "pong-bonobo-entry.h"
#include "pong-bonobo-entry-private.h"


static PongType get_pong_type (const CORBA_any *any);


#line 76 "pong-bonobo-entry.c"
/* self casting macros */
#define SELF(x) PONG_BONOBO_ENTRY(x)
#define SELF_CONST(x) PONG_BONOBO_ENTRY_CONST(x)
#define IS_SELF(x) PONG_IS_BONOBO_ENTRY(x)
#define TYPE_SELF PONG_TYPE_BONOBO_ENTRY
#define SELF_CLASS(x) PONG_BONOBO_ENTRY_CLASS(x)

#define SELF_GET_CLASS(x) PONG_BONOBO_ENTRY_GET_CLASS(x)

/* self typedefs */
typedef PongBonoboEntry Self;
typedef PongBonoboEntryClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void pong_bonobo_entry_init (PongBonoboEntry * o) G_GNUC_UNUSED;
static void pong_bonobo_entry_class_init (PongBonoboEntryClass * c) G_GNUC_UNUSED;
static void pong_bonobo_entry_entry_changed (PongBonoboEntry * self) G_GNUC_UNUSED;
static void pong_bonobo_entry_setListener (PortableServer_Servant servant, const GNOME_PonG_ChangedValueListener listener, CORBA_Environment * ev) G_GNUC_UNUSED;
static GNOME_PonG_Value * pong_bonobo_entry_getValue (PortableServer_Servant servant, const CORBA_char * specifier, const GNOME_PonG_ValueType type, CORBA_Environment * ev) G_GNUC_UNUSED;
static void pong_bonobo_entry_setValue (PortableServer_Servant servant, const CORBA_char * specifier, const GNOME_PonG_Value * value, CORBA_Environment * ev) G_GNUC_UNUSED;
static void pong_bonobo_entry_addOptions (PortableServer_Servant servant, const GNOME_PonG_OptionSequence * options, CORBA_Environment * ev) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboXObjectClass *parent_class = NULL;

GtkType
pong_bonobo_entry_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"PongBonoboEntry",
			sizeof (PongBonoboEntry),
			sizeof (PongBonoboEntryClass),
			(GtkClassInitFunc) pong_bonobo_entry_class_init,
			(GtkObjectInitFunc) pong_bonobo_entry_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = bonobo_x_type_unique
			(bonobo_x_object_get_type (),
			POA_GNOME_PonG_ControlInterface__init, NULL,
			GTK_STRUCT_OFFSET (PongBonoboEntryClass, _epv),
			&info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define make_control(args...) pong_bonobo_entry_make_control(args)
#define entry_changed(args...) pong_bonobo_entry_entry_changed(args)
#define setListener(args...) pong_bonobo_entry_setListener(args)
#define getValue(args...) pong_bonobo_entry_getValue(args)
#define setValue(args...) pong_bonobo_entry_setValue(args)
#define addOptions(args...) pong_bonobo_entry_addOptions(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static BonoboControl * (* const make_control) (GtkWidget * native_widget) = pong_bonobo_entry_make_control;
static void (* const entry_changed) (PongBonoboEntry * self) = pong_bonobo_entry_entry_changed;
static void (* const setListener) (PortableServer_Servant servant, const GNOME_PonG_ChangedValueListener listener, CORBA_Environment * ev) = pong_bonobo_entry_setListener;
static GNOME_PonG_Value * (* const getValue) (PortableServer_Servant servant, const CORBA_char * specifier, const GNOME_PonG_ValueType type, CORBA_Environment * ev) = pong_bonobo_entry_getValue;
static void (* const setValue) (PortableServer_Servant servant, const CORBA_char * specifier, const GNOME_PonG_Value * value, CORBA_Environment * ev) = pong_bonobo_entry_setValue;
static void (* const addOptions) (PortableServer_Servant servant, const GNOME_PonG_OptionSequence * options, CORBA_Environment * ev) = pong_bonobo_entry_addOptions;

/* a macro for creating a new object of our type */
#define GET_NEW ((PongBonoboEntry *)gtk_type_new(pong_bonobo_entry_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::destroy"
	PongBonoboEntry *self = PONG_BONOBO_ENTRY (obj_self);
	if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(obj_self);
#define VAR (self->_priv->listener)
	{
#line 70 "pong-bonobo-entry.gob"
	
			if (VAR != CORBA_OBJECT_NIL) {
				CORBA_Environment ev;
				CORBA_exception_init (&ev);
				CORBA_Object_release (VAR, &ev);
				CORBA_exception_free (&ev);
			}
		}
#line 174 "pong-bonobo-entry.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
#line 80 "pong-bonobo-entry.gob"
	if(self->_priv->native_widget) { ((*(void (*)(void *))gtk_object_unref)) (self->_priv->native_widget); self->_priv->native_widget = NULL; }
#line 179 "pong-bonobo-entry.c"
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::finalize"
	PongBonoboEntry *self = PONG_BONOBO_ENTRY (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

static void 
pong_bonobo_entry_init (PongBonoboEntry * o)
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::init"
	o->_priv = g_new0 (PongBonoboEntryPrivate, 1);
#line 36 "pong-bonobo-entry.gob"
	o->_priv->listener = CORBA_OBJECT_NIL;
#line 215 "pong-bonobo-entry.c"
#line 70 "pong-bonobo-entry.gob"
	o->_priv->native_widget = NULL;
#line 218 "pong-bonobo-entry.c"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
pong_bonobo_entry_class_init (PongBonoboEntryClass * c)
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) c;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) c;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (bonobo_x_object_get_type ());

	gtk_object_class->destroy = ___destroy;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */
#line 154 "pong-bonobo-entry.gob"
	c->_epv.setListener = setListener;
#line 172 "pong-bonobo-entry.gob"
	c->_epv.getValue = getValue;
#line 204 "pong-bonobo-entry.gob"
	c->_epv.setValue = setValue;
#line 244 "pong-bonobo-entry.gob"
	c->_epv.addOptions = addOptions;
#line 248 "pong-bonobo-entry.c"
	return;
	c = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__



/**
 * pong_bonobo_entry_make_control:
 * @native_widget: a widget implementing the PongWidgetInterface
 *
 * Description:  This will make a new bonobo control that you can
 * return from your factory to make a pong bonobo widget.  Your
 * widget should implement the PongWidgetInterface.  In the oaf
 * file make sure you specify GNOME/PonG/ControlInterface:1.0 and
 * GNOME/PonG/ArgumentInterface:1.0 repo_ids.  If you implemented
 * the set_label method, make sure you also include
 * GNOME/PonG/LabelInterface:1.0.
 *
 * Returns: a new BonoboControl object
 **/
#line 96 "pong-bonobo-entry.gob"
BonoboControl * 
pong_bonobo_entry_make_control (GtkWidget * native_widget)
#line 277 "pong-bonobo-entry.c"
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::make_control"
#line 96 "pong-bonobo-entry.gob"
	g_return_val_if_fail (native_widget != NULL, (BonoboControl * )0);
#line 96 "pong-bonobo-entry.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (native_widget), (BonoboControl * )0);
#line 284 "pong-bonobo-entry.c"
{
#line 98 "pong-bonobo-entry.gob"
	
		PongBonoboEntry *pbe;
		BonoboControl *control;
		BonoboObject *extra;

		g_return_val_if_fail (pong_widget_interface_exists (native_widget), NULL);

		control = bonobo_control_new (native_widget);
		if (control == NULL)
			return NULL;

		pbe = GET_NEW;

		/* Show for good meassure */
		gtk_widget_show (native_widget);

		pbe->_priv->native_widget = native_widget;
		gtk_widget_ref (native_widget);

		gtk_signal_connect_object
		    (GTK_OBJECT (pbe->_priv->native_widget),
		     pong_widget_interface_peek_changed_signal (native_widget),
		     GTK_SIGNAL_FUNC (entry_changed),
		     GTK_OBJECT (pbe));

		bonobo_object_add_interface (BONOBO_OBJECT (control),
					     BONOBO_OBJECT (pbe));

		/* Add interface for the setArg implementation */
		extra = pong_bonobo_entry_arguments_new (native_widget);
		bonobo_object_add_interface (BONOBO_OBJECT (control),
					     BONOBO_OBJECT (extra));

		/* Add argument for setLabel if implemented */
		if (pong_widget_interface_implements_set_label (native_widget)) {
			extra = pong_bonobo_entry_label_new (native_widget);
			bonobo_object_add_interface (BONOBO_OBJECT (control),
						     BONOBO_OBJECT (extra));
		}

		return control;
	}}
#line 329 "pong-bonobo-entry.c"
#undef __GOB_FUNCTION__

#line 141 "pong-bonobo-entry.gob"
static void 
pong_bonobo_entry_entry_changed (PongBonoboEntry * self)
#line 335 "pong-bonobo-entry.c"
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::entry_changed"
#line 141 "pong-bonobo-entry.gob"
	g_return_if_fail (self != NULL);
#line 141 "pong-bonobo-entry.gob"
	g_return_if_fail (PONG_IS_BONOBO_ENTRY (self));
#line 342 "pong-bonobo-entry.c"
{
#line 143 "pong-bonobo-entry.gob"
	
		if (self->_priv->listener != CORBA_OBJECT_NIL) {
			CORBA_Environment ev;
			CORBA_exception_init (&ev);
			GNOME_PonG_ChangedValueListener_changedValue
				(self->_priv->listener, &ev);
			CORBA_exception_free (&ev);
		}
	}}
#line 354 "pong-bonobo-entry.c"
#undef __GOB_FUNCTION__

#line 154 "pong-bonobo-entry.gob"
static void 
pong_bonobo_entry_setListener (PortableServer_Servant servant, const GNOME_PonG_ChangedValueListener listener, CORBA_Environment * ev)
#line 360 "pong-bonobo-entry.c"
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::setListener"
{
#line 158 "pong-bonobo-entry.gob"
	
		Self *self = SELF (bonobo_object_from_servant (servant));

		if (self->_priv->listener != CORBA_OBJECT_NIL) {
			CORBA_Environment pev;
			CORBA_exception_init (&pev);
			CORBA_Object_release (self->_priv->listener, &pev);
			CORBA_exception_free (&pev);
		}

		self->_priv->listener = CORBA_Object_duplicate (listener, ev);
	}}
#line 377 "pong-bonobo-entry.c"
#undef __GOB_FUNCTION__

#line 172 "pong-bonobo-entry.gob"
static GNOME_PonG_Value * 
pong_bonobo_entry_getValue (PortableServer_Servant servant, const CORBA_char * specifier, const GNOME_PonG_ValueType type, CORBA_Environment * ev)
#line 383 "pong-bonobo-entry.c"
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::getValue"
{
#line 177 "pong-bonobo-entry.gob"
	
		Self *self = SELF (bonobo_object_from_servant (servant));
		GtkWidget *nw = self->_priv->native_widget;
		GNOME_PonG_Value *value = NULL;
		GConfValue *gconf_value = NULL;

		if ( !  pong_widget_interface_get_value (nw,
							 specifier,
							 /* XXX: this must
							  * map perfectly */
							 (PongType) type,
							 &gconf_value)) {
			bonobo_exception_set (ev,
					      ex_GNOME_PonG_UnsupportedType);
			return CORBA_OBJECT_NIL;
		}

		value = CORBA_any__alloc ();

		pong_bonobo_make_value (value, gconf_value);

		gconf_value_free (gconf_value);

		return value;
	}}
#line 413 "pong-bonobo-entry.c"
#undef __GOB_FUNCTION__

#line 204 "pong-bonobo-entry.gob"
static void 
pong_bonobo_entry_setValue (PortableServer_Servant servant, const CORBA_char * specifier, const GNOME_PonG_Value * value, CORBA_Environment * ev)
#line 419 "pong-bonobo-entry.c"
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::setValue"
{
#line 209 "pong-bonobo-entry.gob"
	
		Self *self = SELF (bonobo_object_from_servant (servant));
		GtkWidget *nw = self->_priv->native_widget;
		GConfValue *gconf_value;
		PongType type;

		type = get_pong_type (value);

		if (type == PONG_TYPE_INVALID) {
			bonobo_exception_set (ev,
					      ex_GNOME_PonG_UnsupportedType);
			return;
		}

		gconf_value = pong_bonobo_pull_value (value, type,
						      GCONF_VALUE_INVALID);
		if (gconf_value == NULL) {
			bonobo_exception_set (ev,
					      ex_GNOME_PonG_UnsupportedType);
			return;
		}

		if ( !  pong_widget_interface_set_value (nw,
							 specifier,
							 gconf_value)) {
			gconf_value_free (gconf_value);
			bonobo_exception_set (ev,
					      ex_GNOME_PonG_UnsupportedType);
			return;
		}

		gconf_value_free (gconf_value);
	}}
#line 457 "pong-bonobo-entry.c"
#undef __GOB_FUNCTION__

#line 244 "pong-bonobo-entry.gob"
static void 
pong_bonobo_entry_addOptions (PortableServer_Servant servant, const GNOME_PonG_OptionSequence * options, CORBA_Environment * ev)
#line 463 "pong-bonobo-entry.c"
{
#define __GOB_FUNCTION__ "Pong:Bonobo:Entry::addOptions"
{
#line 248 "pong-bonobo-entry.gob"
	
		Self *self = SELF (bonobo_object_from_servant (servant));
		GtkWidget *nw = self->_priv->native_widget;
		int i;
		GList *option_list = NULL;

		if ( ! pong_widget_interface_implements_add_options (nw)) {
			return;
		}

		for (i = 0; i < options->_length; i++) {
			GNOME_PonG_Option *option = &options->_buffer[i];

			/* By an act of god, we can abuse the memory layout
			 * of the CORBA interface here, since PongOption has
			 * the same layout as GNOME_PonG_Option */
			option_list = g_list_prepend (option_list, option);
		}
		option_list = g_list_reverse (option_list);

		pong_widget_interface_add_options (nw, option_list);

		g_list_free (option_list);
	}}
#line 492 "pong-bonobo-entry.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___pong_bonobo_entry_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))make_control)();
	((void (*)(void))entry_changed)();
	((void (*)(void))setListener)();
	((void (*)(void))getValue)();
	((void (*)(void))setValue)();
	((void (*)(void))addOptions)();
	___pong_bonobo_entry_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */


#line 274 "pong-bonobo-entry.gob"


static PongType
get_pong_type (const CORBA_any *any)
{
	CORBA_Environment ev;

	switch (any->_type->kind) {
	case CORBA_tk_string:
		return PONG_TYPE_STRING;
	case CORBA_tk_long:
		return PONG_TYPE_INT;
	case CORBA_tk_float:
	case CORBA_tk_double:
		return PONG_TYPE_FLOAT;
	case CORBA_tk_boolean:
		return PONG_TYPE_BOOL;
	default:
		CORBA_exception_init (&ev);
		if (CORBA_TypeCode_equal (any->_type,
					  TC_GNOME_PonG_PairValue, &ev)) {
			GNOME_PonG_PairValue *pair_value = any->_value;
			PongType t1 = get_pong_type (&pair_value->car);
			PongType t2 = get_pong_type (&pair_value->cdr);

			CORBA_exception_free (&ev);

			/* FIXME: further checking */
			return pong_type_from_gconf_types
				(GCONF_VALUE_PAIR,
				 GCONF_VALUE_INVALID,
				 pong_gconf_value_type_from_pong_type (t1),
				 pong_gconf_value_type_from_pong_type (t2));

		} else if (CORBA_TypeCode_equal (any->_type,
						 TC_GNOME_PonG_ListValue, &ev)) {
			GNOME_PonG_ListValue *list_value = any->_value;

			CORBA_exception_free (&ev);

			/* FIXME: further checking */
			return pong_type_from_gconf_types
				(GCONF_VALUE_LIST,
				 /* XXX: yaikes, we need a nicer conversion
				  * functions, assuming this matches is evil */
				 list_value->type,
				 GCONF_VALUE_INVALID,
				 GCONF_VALUE_INVALID);
		} else {
			g_warning (_("Unsupported value type in get_pong_type!"));
			CORBA_exception_free (&ev);
			return PONG_TYPE_INVALID;
		}
	}
}


#line 574 "pong-bonobo-entry.c"
