# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: docbook.py,v 1.4 1999/07/30 12:34:22 gobry Exp $


# SGML DocBook Module

import sys, string, recode
import Pyblio.Base, Pyblio.Open

Mapping = {'abstract' : 'Abstract',
           'title' : 'Title',
           'pages' : 'PageNums',
           'volume' : 'VolumeNum',
           'year' : 'Year',
           'publisher' : 'Publisher',
           'isbn' : 'ISBN',
           'issn' : 'ISSN',
           'dates' : 'Date',
           }

htmlcode = recode.request ("latin1..html")

def qs (s):
    return recode.recode (htmlcode, s)


def printer (entry, output):
    """Compose the next entry"""
    
    output.write ("<BiblioEntry id=\"%s\">\n" % entry.name)
    
    # First, the authors
    if entry.has_key ('author'):
        output.write (" <AuthorGroup>\n")
        
        for author in entry ['author']:
            if author.honorific:
                output.write ("  <Honorific> " + qs (author.honorific) +
                              " </Honorific>\n")
            if author.first:
                output.write ("  <Firstname> " + qs (author.first) +
                              " </Firstname>\n")
            if author.last:
                output.write ("  <Surname> " + qs (author.last) +
                              " </Surname>\n")
            if author.lineage:
                output.write ("  <Lineage> " + qs (author.lineage) +
                              " </Lineage>\n")
                
        output.write (" </AuthorGroup>\n")


    # Then, the more regular entries
    for field in entry.keys ():
        if Mapping.has_key (field):
            sf = Mapping[field]
            output.write (' <'  + sf + '> ' +
                          qs (str (entry [field])) +
                          ' </' + sf + ">\n")

    # Close the field
    output.write ("</BiblioEntry>\n")

Pyblio.Open.register ('DocBook', None, printer)
