/* ui.c generated by valac 0.20.1, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;
typedef struct _UserInterfacePrivate UserInterfacePrivate;

#define TYPE_PROGRESS_BAR_DIALOG (progress_bar_dialog_get_type ())
#define PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog))
#define PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))
#define IS_PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_BAR_DIALOG))
#define IS_PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_BAR_DIALOG))
#define PROGRESS_BAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))

typedef struct _ProgressBarDialog ProgressBarDialog;
typedef struct _ProgressBarDialogClass ProgressBarDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ParamSpecUserInterface ParamSpecUserInterface;
typedef struct _ProgressBarDialogPrivate ProgressBarDialogPrivate;

struct _UserInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UserInterfacePrivate * priv;
};

struct _UserInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (UserInterface *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _UserInterfacePrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkWindow* window;
	GtkVBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkMenuItem* copy_to_clipboard_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* quality_scale;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* quality_adjustment;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	ProgressBarDialog* progress_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* book;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* default_file_name;
	gboolean scanning;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecUserInterface {
	GParamSpec parent_instance;
};

struct _ProgressBarDialog {
	GtkWindow parent_instance;
	ProgressBarDialogPrivate * priv;
};

struct _ProgressBarDialogClass {
	GtkWindowClass parent_class;
};

struct _ProgressBarDialogPrivate {
	GtkProgressBar* bar;
};


static gpointer user_interface_parent_class = NULL;
static gpointer progress_bar_dialog_parent_class = NULL;

gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
GType progress_bar_dialog_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define USER_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_INTERFACE, UserInterfacePrivate))
enum  {
	USER_INTERFACE_DUMMY_PROPERTY
};
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
#define USER_INTERFACE_DEFAULT_TEXT_DPI 150
#define USER_INTERFACE_DEFAULT_PHOTO_DPI 300
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
static void user_interface_load (UserInterface* self);
AutosaveManager* autosave_manager_create (Book** book);
static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter);
static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text);
void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_update_info_bar (UserInterface* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
static gchar* user_interface_get_selected_device (UserInterface* self);
void user_interface_set_selected_device (UserInterface* self, const gchar* device);
static void user_interface_add_default_page (UserInterface* self);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_view_select_page (BookView* self, Page* page);
static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_choose_file_location (UserInterface* self);
static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
static gint user_interface_get_quality (UserInterface* self);
void user_interface_hide_progress_dialog (UserInterface* self);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void book_set_needs_saving (Book* self, gboolean needs_saving);
static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void user_interface_clear_document (UserInterface* self);
void book_clear (Book* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void user_interface_set_page_side (UserInterface* self, ScanType page_side);
static void user_interface_set_paper_size (UserInterface* self, gint width, gint height);
static void user_interface_set_brightness (UserInterface* self, gint brightness);
static void user_interface_set_contrast (UserInterface* self, gint contrast);
static void user_interface_set_quality (UserInterface* self, gint quality);
static gint user_interface_get_text_dpi (UserInterface* self);
static gint user_interface_get_photo_dpi (UserInterface* self);
static ScanType user_interface_get_page_side (UserInterface* self);
static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height);
static gint user_interface_get_brightness (UserInterface* self);
static gint user_interface_get_contrast (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* user_interface_get_scan_options (UserInterface* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self);
static void user_interface_update_page_menu (UserInterface* self);
Page* book_view_get_selected (BookView* self);
guint book_get_page_index (Book* self, Page* page);
guint book_get_n_pages (Book* self);
static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page);
gchar* get_temporary_filename (const gchar* prefix, const gchar* extension);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_right (Page* self);
static void user_interface_set_crop (UserInterface* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
Page* book_get_page (Book* self, gint page_number);
gboolean page_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
static gboolean user_interface_on_quit (UserInterface* self);
void autosave_manager_cleanup (AutosaveManager* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self);
static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self);
static void user_interface_page_size_changed_cb (UserInterface* self, Page* page);
static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static void user_interface_needs_saving_cb (UserInterface* self, Book* book);
static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
ProgressBarDialog* progress_bar_dialog_new (GtkWindow* parent, const gchar* title);
ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkWindow* parent, const gchar* title);
static void user_interface_book_saving_cb (UserInterface* self, gint page_number);
static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self);
static gboolean ___lambda3_ (UserInterface* self);
static gboolean ____lambda3__gsource_func (gpointer self);
void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent);
void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message);
Book* user_interface_get_book (UserInterface* self);
void user_interface_set_selected_page (UserInterface* self, Page* page);
Page* user_interface_get_selected_page (UserInterface* self);
void user_interface_set_scanning (UserInterface* self, gboolean scanning);
void user_interface_start (UserInterface* self);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_interface_finalize (UserInterface* obj);
#define PROGRESS_BAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogPrivate))
enum  {
	PROGRESS_BAR_DIALOG_DUMMY_PROPERTY
};
static void progress_bar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_removed_cb (self, _sender, page);
#line 504 "ui.c"
}


static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_added_cb (self, _sender, page);
#line 511 "ui.c"
}


UserInterface* user_interface_construct (GType object_type) {
	UserInterface* self = NULL;
	GSettings* _tmp0_;
	Book* _tmp1_;
	Book* _tmp2_;
	Book* _tmp3_;
	AutosaveManager* _tmp4_ = NULL;
#line 102 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (UserInterface*) g_type_create_instance (object_type);
#line 104 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_settings_new ("org.gnome.SimpleScan");
#line 104 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 104 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->settings = _tmp0_;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_new ();
#line 106 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (self->priv->book);
#line 106 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book = _tmp1_;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp2_, "page-removed", (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 108 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp3_, "page-added", (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 110 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_load (self);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = autosave_manager_create (&self->priv->book);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->autosave_manager = _tmp4_;
#line 102 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self;
#line 554 "ui.c"
}


UserInterface* user_interface_new (void) {
#line 102 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return user_interface_construct (TYPE_USER_INTERFACE);
#line 561 "ui.c"
}


static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 121 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (device != NULL, FALSE);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	have_iter = FALSE;
#line 125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->device_model;
#line 125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_iter = _tmp1_;
#line 125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 586 "ui.c"
		{
			gboolean _tmp3_;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = TRUE;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 593 "ui.c"
				gboolean _tmp4_;
				gchar* d = NULL;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp4_ = _tmp3_;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp4_) {
#line 604 "ui.c"
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_;
					gboolean _tmp9_;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp6_ = have_iter;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp6_) {
#line 612 "ui.c"
						GtkListStore* _tmp7_;
						gboolean _tmp8_ = FALSE;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp7_ = self->priv->device_model;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &_vala_iter);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp5_ = _tmp8_;
#line 621 "ui.c"
					} else {
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp5_ = FALSE;
#line 625 "ui.c"
					}
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp9_ = _tmp5_;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp9_) {
#line 133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 633 "ui.c"
					}
				}
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp3_ = FALSE;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = self->priv->device_model;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp11_ = _vala_iter;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &d, -1, -1);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp12_ = d;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp13_ = device;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 132 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					have_iter = TRUE;
#line 652 "ui.c"
				}
#line 127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (d);
#line 656 "ui.c"
			}
		}
	}
#line 136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = have_iter;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (iter) {
#line 136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*iter = _vala_iter;
#line 666 "ui.c"
	}
#line 136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 670 "ui.c"
}


static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text) {
	GtkWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* dialog;
	const gchar* _tmp3_;
#line 139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = error_title;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dialog = _tmp2_;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CLOSE, 0);
#line 147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = error_text;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp3_);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 139 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (dialog);
#line 706 "ui.c"
}


void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (default_file_name != NULL);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = default_file_name;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->default_file_name);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_file_name = _tmp1_;
#line 725 "ui.c"
}


void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* description;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkLabel* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GtkEntry* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (resource != NULL);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Username and password required to access '%s'");
#line 159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = resource;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	description = _tmp2_;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->username_entry;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_entry_set_text (_tmp3_, "");
#line 162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->password_entry;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_entry_set_text (_tmp4_, "");
#line 163 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->authorize_label;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_label_set_text (_tmp5_, description);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->authorize_dialog;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = self->priv->authorize_dialog;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_run (_tmp7_);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->authorize_dialog;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->username_entry;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_vala_username);
#line 169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_username = _tmp11_;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->password_entry;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = gtk_entry_get_text (_tmp12_);
#line 170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_vala_password);
#line 170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_password = _tmp14_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (description);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (username) {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*username = _vala_username;
#line 810 "ui.c"
	} else {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_vala_username);
#line 814 "ui.c"
	}
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (password) {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*password = _vala_password;
#line 820 "ui.c"
	} else {
#line 156 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_vala_password);
#line 824 "ui.c"
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->setting_devices;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 177 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 841 "ui.c"
	}
#line 178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 845 "ui.c"
}


static void user_interface_update_info_bar (UserInterface* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button;
	gboolean show_change_scanner_button;
	gboolean _tmp0_;
	GtkInfoBar* _tmp15_;
	GtkMessageType _tmp16_;
	GtkImage* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* message;
	GtkLabel* _tmp22_;
	const gchar* _tmp23_;
	GtkButton* _tmp24_;
	gboolean _tmp25_;
	GtkButton* _tmp26_;
	gboolean _tmp27_;
	GtkInfoBar* _tmp28_;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_close_button = FALSE;
#line 186 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	show_change_scanner_button = FALSE;
#line 188 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->have_error;
#line 188 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 882 "ui.c"
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
#line 190 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		type = GTK_MESSAGE_ERROR;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
#line 191 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (image_id);
#line 191 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		image_id = _tmp1_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = self->priv->error_title;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (title);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		title = _tmp3_;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->error_text;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (text);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		text = _tmp5_;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		show_close_button = TRUE;
#line 195 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->error_change_scanner_hint;
#line 195 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		show_change_scanner_button = _tmp6_;
#line 919 "ui.c"
	} else {
		GtkListStore* _tmp7_;
		gint _tmp8_ = 0;
#line 197 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = self->priv->device_model;
#line 197 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
#line 197 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp8_ == 0) {
#line 929 "ui.c"
			gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
#line 199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			type = GTK_MESSAGE_WARNING;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (image_id);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			image_id = _tmp9_;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = _ ("No scanners detected");
#line 202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (title);
#line 202 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			title = _tmp11_;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
#line 204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (text);
#line 204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			text = _tmp13_;
#line 959 "ui.c"
		} else {
			GtkInfoBar* _tmp14_;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp14_ = self->priv->info_bar;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_widget_hide ((GtkWidget*) _tmp14_);
#line 209 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (image_id);
#line 209 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (text);
#line 209 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (title);
#line 209 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return;
#line 974 "ui.c"
		}
	}
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->info_bar;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = type;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->info_bar_image;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = image_id;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_image_set_from_stock (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = title;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = text;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
#line 214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	message = _tmp21_;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = self->priv->info_bar_label;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = message;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_label_set_markup (_tmp22_, _tmp23_);
#line 216 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = self->priv->info_bar_close_button;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = show_close_button;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
#line 217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = self->priv->info_bar_change_scanner_button;
#line 217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = show_change_scanner_button;
#line 217 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
#line 218 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = self->priv->info_bar;
#line 218 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp28_);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (message);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (image_id);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (text);
#line 181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (title);
#line 1027 "ui.c"
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? scan_device_ref (self) : NULL;
#line 1034 "ui.c"
}


void user_interface_set_scan_devices (UserInterface* self, GList* devices) {
	gboolean have_selection;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_;
	GList* _tmp3_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_;
	gboolean _tmp55_;
#line 221 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	have_selection = FALSE;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->setting_devices = TRUE;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->user_selected_device;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 1057 "ui.c"
		GtkComboBox* _tmp1_;
		gint _tmp2_ = 0;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
#line 231 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_selection = _tmp2_ >= 0;
#line 1066 "ui.c"
	}
#line 234 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = 0;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = devices;
#line 1072 "ui.c"
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		device_collection = _tmp3_;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 1080 "ui.c"
			ScanDevice* _tmp4_;
			ScanDevice* device = NULL;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp4_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			device = _tmp4_;
#line 1087 "ui.c"
			{
				gint n_delete;
				GtkListStore* _tmp5_;
				gint _tmp6_;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gint _tmp21_;
				gint _tmp45_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				n_delete = -1;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp5_ = self->priv->device_model;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp6_ = index;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp7_, NULL, _tmp6_);
#line 240 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				iter = _tmp7_;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp8_) {
#line 1108 "ui.c"
					gint i;
#line 242 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					i = 0;
#line 1112 "ui.c"
					{
						gboolean _tmp9_;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp9_ = TRUE;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						while (TRUE) {
#line 1119 "ui.c"
							gboolean _tmp10_;
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp13_;
							GtkTreeIter _tmp14_;
							const gchar* _tmp15_;
							ScanDevice* _tmp16_;
							const gchar* _tmp17_;
							gboolean _tmp18_;
							gint _tmp20_;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp10_ = _tmp9_;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!_tmp10_) {
#line 1134 "ui.c"
								GtkListStore* _tmp11_;
								gboolean _tmp12_ = FALSE;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp11_ = self->priv->device_model;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp12_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp11_, &iter);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								if (!_tmp12_) {
#line 257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									break;
#line 1145 "ui.c"
								}
							}
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp9_ = FALSE;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp13_ = self->priv->device_model;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp14_ = iter;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, 0, &name, -1, -1);
#line 249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp15_ = name;
#line 249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp16_ = device;
#line 249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp17_ = _tmp16_->name;
#line 249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							matched = g_strcmp0 (_tmp15_, _tmp17_) == 0;
#line 251 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp18_ = matched;
#line 251 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (_tmp18_) {
#line 1168 "ui.c"
								gint _tmp19_;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp19_ = i;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								n_delete = _tmp19_;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_g_free0 (name);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								break;
#line 1178 "ui.c"
							}
#line 256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp20_ = i;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							i = _tmp20_ + 1;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (name);
#line 1186 "ui.c"
						}
					}
				}
#line 261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp21_ = n_delete;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp21_ >= 0) {
#line 1194 "ui.c"
					gint i = 0;
					GtkListStore* _tmp22_;
					GtkTreeIter _tmp23_;
					ScanDevice* _tmp24_;
					const gchar* _tmp25_;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp22_ = self->priv->device_model;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = iter;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp24_ = device;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp25_ = _tmp24_->label;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
#line 1210 "ui.c"
					{
						gboolean _tmp26_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						i = 0;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp26_ = TRUE;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						while (TRUE) {
#line 1219 "ui.c"
							gboolean _tmp27_;
							gint _tmp29_;
							gint _tmp30_;
							GtkListStore* _tmp31_;
							gint _tmp32_;
							GtkTreeIter _tmp33_ = {0};
							GtkListStore* _tmp34_;
							GtkTreeIter _tmp35_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp27_ = _tmp26_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!_tmp27_) {
#line 1232 "ui.c"
								gint _tmp28_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp28_ = i;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								i = _tmp28_ + 1;
#line 1238 "ui.c"
							}
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp26_ = FALSE;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp29_ = i;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp30_ = n_delete;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (!(_tmp29_ < _tmp30_)) {
#line 268 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								break;
#line 1250 "ui.c"
							}
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp31_ = self->priv->device_model;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp32_ = index;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp31_, &_tmp33_, NULL, _tmp32_);
#line 270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							iter = _tmp33_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp34_ = self->priv->device_model;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp35_ = iter;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							gtk_list_store_remove (_tmp34_, &_tmp35_);
#line 1266 "ui.c"
						}
					}
				} else {
					GtkListStore* _tmp36_;
					gint _tmp37_;
					GtkTreeIter _tmp38_ = {0};
					GtkListStore* _tmp39_;
					GtkTreeIter _tmp40_;
					ScanDevice* _tmp41_;
					const gchar* _tmp42_;
					ScanDevice* _tmp43_;
					const gchar* _tmp44_;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp36_ = self->priv->device_model;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp37_ = index;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_insert (_tmp36_, &_tmp38_, _tmp37_);
#line 276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					iter = _tmp38_;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp39_ = self->priv->device_model;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp40_ = iter;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp41_ = device;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp42_ = _tmp41_->name;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp43_ = device;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp44_ = _tmp43_->label;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_list_store_set (_tmp39_, &_tmp40_, 0, _tmp42_, 1, _tmp44_, -1, -1);
#line 1301 "ui.c"
				}
#line 279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp45_ = index;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				index = _tmp45_ + 1;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_scan_device_unref0 (device);
#line 1309 "ui.c"
			}
		}
	}
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	while (TRUE) {
#line 1315 "ui.c"
		GtkListStore* _tmp46_;
		gint _tmp47_;
		GtkTreeIter _tmp48_ = {0};
		gboolean _tmp49_ = FALSE;
		GtkListStore* _tmp50_;
		GtkTreeIter _tmp51_;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp46_ = self->priv->device_model;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp47_ = index;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp49_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp46_, &_tmp48_, NULL, _tmp47_);
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp48_;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!_tmp49_) {
#line 283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 1334 "ui.c"
		}
#line 284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp50_ = self->priv->device_model;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp51_ = iter;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_list_store_remove (_tmp50_, &_tmp51_);
#line 1342 "ui.c"
	}
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp53_ = have_selection;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp53_) {
#line 1348 "ui.c"
		GList* _tmp54_;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp54_ = devices;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp52_ = _tmp54_ != NULL;
#line 1354 "ui.c"
	} else {
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp52_ = FALSE;
#line 1358 "ui.c"
	}
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = _tmp52_;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp55_) {
#line 1364 "ui.c"
		GtkComboBox* _tmp56_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp56_ = self->priv->device_combo;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_combo_box_set_active (_tmp56_, 0);
#line 1370 "ui.c"
	}
#line 290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->setting_devices = FALSE;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_info_bar (self);
#line 1376 "ui.c"
}


static gchar* user_interface_get_selected_device (UserInterface* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->device_combo;
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 299 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 1396 "ui.c"
		gchar* device = NULL;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->device_model;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
#line 303 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = device;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 1410 "ui.c"
	}
#line 306 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = NULL;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 1416 "ui.c"
}


void user_interface_set_selected_device (UserInterface* self, const gchar* device) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (device != NULL);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = device;
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_find_scan_device (self, _tmp0_, &_tmp1_);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 1441 "ui.c"
	}
#line 315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->device_combo;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = iter;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
#line 316 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->user_selected_device = TRUE;
#line 1451 "ui.c"
}


static void user_interface_add_default_page (UserInterface* self) {
	Book* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ScanDirection _tmp4_;
	Page* _tmp5_ = NULL;
	Page* page;
	BookView* _tmp6_;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->default_page_width;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->default_page_height;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->default_page_dpi;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->default_page_scan_direction;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_append_page (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 321 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp5_;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->book_view;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_view_select_page (_tmp6_, page);
#line 319 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 1486 "ui.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 928 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1511 "ui.c"
		gchar* _tmp4_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1519 "ui.c"
	} else {
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1525 "ui.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1190 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1561 "ui.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1570 "ui.c"
	}
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1576 "ui.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1585 "ui.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1591 "ui.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1600 "ui.c"
	} else {
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1604 "ui.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 1614 "ui.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 1623 "ui.c"
	} else {
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 1627 "ui.c"
	}
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1651 "ui.c"
}


static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection) {
	GtkTreeSelection* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* extension;
	GtkFileChooserDialog* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* path;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* filename;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint extension_index;
	gint _tmp8_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GtkFileChooserDialog* _tmp15_;
	const gchar* _tmp16_;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (selection != NULL);
#line 330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = selection;
#line 330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_extension (self, _tmp0_);
#line 330 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension = _tmp1_;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->save_dialog;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp2_);
#line 331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	path = _tmp3_;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = path;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp5_;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = filename;
#line 335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
#line 335 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension_index = _tmp7_;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = extension_index;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp8_ >= 0) {
#line 1706 "ui.c"
		const gchar* _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = filename;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = extension_index;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = string_slice (_tmp9_, (glong) 0, (glong) _tmp10_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		filename = _tmp11_;
#line 1720 "ui.c"
	}
#line 338 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = filename;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = extension;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp14_;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = filename;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (path);
#line 328 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (extension);
#line 1744 "ui.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? g_object_ref (self) : NULL;
#line 1751 "ui.c"
}


static gchar* user_interface_get_selected_extension (UserInterface* self, GtkTreeSelection* selection) {
	gchar* result = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	gchar* _tmp0_;
	gchar* extension;
	GtkTreeSelection* _tmp1_;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkTreeModel* _tmp5_;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (selection != NULL, NULL);
#line 346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("");
#line 346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	extension = _tmp0_;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = selection;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp1_, &_tmp2_, &_tmp3_);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _g_object_ref0 (_tmp2_);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	model = _tmp5_;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp3_;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp4_) {
#line 1788 "ui.c"
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = model;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = iter;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &extension, -1, -1);
#line 1797 "ui.c"
	}
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = extension;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 1805 "ui.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1828 "ui.c"
		glong _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1836 "ui.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1848 "ui.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1168 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1873 "ui.c"
		glong _tmp2_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1879 "ui.c"
	} else {
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1883 "ui.c"
	}
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1889 "ui.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1901 "ui.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1911 "ui.c"
	}
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1917 "ui.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1931 "ui.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1941 "ui.c"
	}
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1947 "ui.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1956 "ui.c"
	}
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1976 "ui.c"
}


static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_file_type_changed (self, _sender);
#line 1983 "ui.c"
}


static gchar* user_interface_choose_file_location (UserInterface* self) {
	gchar* result = NULL;
	gchar* directory;
	GSettings* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp8_ = NULL;
	GtkWindow* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkFileChooserDialog* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	const gchar* _tmp14_;
	GtkFileChooserDialog* _tmp15_;
	const gchar* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* filter;
	GtkFileFilter* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_;
	GtkFileFilter* _tmp21_;
	GtkFileChooserDialog* _tmp22_;
	GtkFileFilter* _tmp23_;
	GtkFileFilter* _tmp24_;
	GtkFileFilter* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_;
	GtkFileChooserDialog* _tmp28_;
	GtkFileFilter* _tmp29_;
	const gchar* _tmp30_ = NULL;
	GtkExpander* _tmp31_;
	GtkExpander* expander;
	GtkExpander* _tmp32_;
	GtkFileChooserDialog* _tmp33_;
	GtkExpander* _tmp34_;
	gchar* _tmp35_;
	gchar* default_extension;
	const gchar* _tmp36_;
	gint _tmp37_ = 0;
	gint index;
	gint _tmp38_;
	GtkListStore* _tmp42_;
	GtkListStore* file_type_store;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp43_;
	GtkTreeIter _tmp44_ = {0};
	GtkListStore* _tmp45_;
	GtkTreeIter _tmp46_;
	const gchar* _tmp47_ = NULL;
	GtkListStore* _tmp48_;
	GtkTreeIter _tmp49_ = {0};
	GtkListStore* _tmp50_;
	GtkTreeIter _tmp51_;
	const gchar* _tmp52_ = NULL;
	GtkListStore* _tmp53_;
	GtkTreeIter _tmp54_ = {0};
	GtkListStore* _tmp55_;
	GtkTreeIter _tmp56_;
	const gchar* _tmp57_ = NULL;
	GtkListStore* _tmp58_;
	GtkTreeView* _tmp59_;
	GtkTreeView* file_type_view;
	GtkTreeView* _tmp60_;
	GtkTreeView* _tmp61_;
	GtkCellRendererText* _tmp62_;
	GtkCellRendererText* _tmp63_;
	GtkTreeViewColumn* _tmp64_;
	GtkTreeViewColumn* _tmp65_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp66_;
	GtkTreeViewColumn* _tmp67_;
	GtkExpander* _tmp68_;
	GtkTreeView* _tmp69_;
	GtkListStore* _tmp70_;
	GtkTreeIter _tmp71_ = {0};
	gboolean _tmp72_ = FALSE;
	GtkTreeView* _tmp84_;
	GtkTreeSelection* _tmp85_ = NULL;
	GtkExpander* _tmp86_;
	GtkFileChooserDialog* _tmp87_;
	gint _tmp88_ = 0;
	gint response;
	gchar* uri;
	gint _tmp89_;
	GSettings* _tmp109_;
	GtkFileChooserDialog* _tmp110_;
	gchar* _tmp111_ = NULL;
	gchar* _tmp112_;
	GtkTreeView* _tmp113_;
	GtkTreeSelection* _tmp114_ = NULL;
	guint _tmp115_ = 0U;
	GtkFileChooserDialog* _tmp116_;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 356 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	directory = NULL;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->settings;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (directory);
#line 357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	directory = _tmp1_;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = directory;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_ == NULL) {
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = TRUE;
#line 2099 "ui.c"
	} else {
		const gchar* _tmp4_;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = directory;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 2106 "ui.c"
	}
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp2_;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_) {
#line 2112 "ui.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
#line 360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
#line 360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (directory);
#line 360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		directory = _tmp7_;
#line 2123 "ui.c"
	}
#line 362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = _ ("Save As...");
#line 362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->window;
#line 362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp8_, _tmp9_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp10_);
#line 362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_dialog = _tmp10_;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = self->priv->save_dialog;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp11_, TRUE);
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = self->priv->save_dialog;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp12_, FALSE);
#line 371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->save_dialog;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = directory;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp13_, _tmp14_);
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->save_dialog;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = self->priv->default_file_name;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = gtk_file_filter_new ();
#line 375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp17_);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filter = _tmp17_;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = filter;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = _ ("Image Files");
#line 376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_set_name (_tmp18_, _tmp19_);
#line 378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = filter;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_pixbuf_formats (_tmp20_);
#line 379 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = filter;
#line 379 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_mime_type (_tmp21_, "application/pdf");
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = self->priv->save_dialog;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = filter;
#line 380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp22_, _tmp23_);
#line 381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = gtk_file_filter_new ();
#line 381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp24_);
#line 381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (filter);
#line 381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filter = _tmp24_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = filter;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = _ ("All Files");
#line 382 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_set_name (_tmp25_, _tmp26_);
#line 384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = filter;
#line 384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_filter_add_pattern (_tmp27_, "*");
#line 385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = self->priv->save_dialog;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = filter;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp28_, _tmp29_);
#line 387 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = _ ("Select File _Type");
#line 387 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp30_);
#line 387 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp31_);
#line 387 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	expander = _tmp31_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = expander;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_expander_set_spacing (_tmp32_, 5);
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = self->priv->save_dialog;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = expander;
#line 390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp33_, (GtkWidget*) _tmp34_);
#line 392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = g_strdup ("");
#line 392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	default_extension = _tmp35_;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp36_ = self->priv->default_file_name;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp37_ = string_last_index_of_char (_tmp36_, (gunichar) '.', 0);
#line 393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp37_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = index;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp38_ >= 0) {
#line 2239 "ui.c"
		const gchar* _tmp39_;
		gint _tmp40_;
		gchar* _tmp41_ = NULL;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp39_ = self->priv->default_file_name;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp40_ = index;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp41_ = string_substring (_tmp39_, (glong) _tmp40_, (glong) (-1));
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (default_extension);
#line 395 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		default_extension = _tmp41_;
#line 2253 "ui.c"
	}
#line 397 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp42_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
#line 397 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file_type_store = _tmp42_;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp43_ = file_type_store;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp43_, &_tmp44_);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp44_;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp45_ = file_type_store;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp46_ = iter;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp47_ = _ ("PDF (multi-page document)");
#line 400 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, ".pdf", -1, -1);
#line 405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp48_ = file_type_store;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp48_, &_tmp49_);
#line 405 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp49_;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp50_ = file_type_store;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp51_ = iter;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp52_ = _ ("JPEG (compressed)");
#line 406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp50_, &_tmp51_, 0, _tmp52_, 1, ".jpg", -1, -1);
#line 411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp53_ = file_type_store;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp53_, &_tmp54_);
#line 411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp54_;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = file_type_store;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp56_ = iter;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp57_ = _ ("PNG (lossless)");
#line 412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp55_, &_tmp56_, 0, _tmp57_, 1, ".png", -1, -1);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp58_ = file_type_store;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp59_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp58_);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp59_);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file_type_view = _tmp59_;
#line 419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp60_ = file_type_view;
#line 419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_set_headers_visible (_tmp60_, FALSE);
#line 420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp61_ = file_type_view;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_set_rules_hint (_tmp61_, TRUE);
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp62_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp62_);
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp63_ = _tmp62_;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp64_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp63_, "text", 0, NULL, NULL);
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp64_);
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp65_ = _tmp64_;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (_tmp63_);
#line 421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	column = _tmp65_;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp66_ = file_type_view;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp67_ = column;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_tree_view_append_column (_tmp66_, _tmp67_);
#line 425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp68_ = expander;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp69_ = file_type_view;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp70_ = file_type_store;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp72_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp70_, &_tmp71_);
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp71_;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp72_) {
#line 2353 "ui.c"
		{
			gboolean _tmp73_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp73_ = TRUE;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 2360 "ui.c"
				gboolean _tmp74_;
				gchar* e = NULL;
				GtkListStore* _tmp77_;
				GtkTreeIter _tmp78_;
				const gchar* _tmp79_;
				const gchar* _tmp80_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp74_ = _tmp73_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp74_) {
#line 2371 "ui.c"
					GtkListStore* _tmp75_;
					gboolean _tmp76_ = FALSE;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp75_ = file_type_store;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp76_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp75_, &iter);
#line 435 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp76_) {
#line 435 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 2382 "ui.c"
					}
				}
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp73_ = FALSE;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp77_ = file_type_store;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp78_ = iter;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp77_, &_tmp78_, 1, &e, -1, -1);
#line 433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp79_ = default_extension;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp80_ = e;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp79_, _tmp80_) == 0) {
#line 2399 "ui.c"
					GtkTreeView* _tmp81_;
					GtkTreeSelection* _tmp82_ = NULL;
					GtkTreeIter _tmp83_;
#line 434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp81_ = file_type_view;
#line 434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp82_ = gtk_tree_view_get_selection (_tmp81_);
#line 434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp83_ = iter;
#line 434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_tree_selection_select_iter (_tmp82_, &_tmp83_);
#line 2411 "ui.c"
				}
#line 429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (e);
#line 2415 "ui.c"
			}
		}
	}
#line 437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp84_ = file_type_view;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp85_ = gtk_tree_view_get_selection (_tmp84_);
#line 437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp85_, "changed", (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp86_ = expander;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp86_);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp87_ = self->priv->save_dialog;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp88_ = gtk_dialog_run ((GtkDialog*) _tmp87_);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	response = _tmp88_;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	uri = NULL;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp89_ = response;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp89_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 2441 "ui.c"
		GtkTreeView* _tmp90_;
		GtkTreeSelection* _tmp91_ = NULL;
		GtkTreeSelection* _tmp92_;
		GtkTreeSelection* selection;
		GtkTreeSelection* _tmp93_;
		gchar* _tmp94_ = NULL;
		gchar* extension;
		GtkFileChooserDialog* _tmp95_;
		gchar* _tmp96_ = NULL;
		gchar* path;
		const gchar* _tmp97_;
		gchar* _tmp98_ = NULL;
		gchar* filename;
		const gchar* _tmp99_;
		gint _tmp100_ = 0;
		gint extension_index;
		gint _tmp101_;
		const gchar* _tmp105_;
		GFile* _tmp106_ = NULL;
		GFile* _tmp107_;
		gchar* _tmp108_ = NULL;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp90_ = file_type_view;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp91_ = gtk_tree_view_get_selection (_tmp90_);
#line 446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp92_ = _g_object_ref0 (_tmp91_);
#line 446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		selection = _tmp92_;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp93_ = selection;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp94_ = user_interface_get_selected_extension (self, _tmp93_);
#line 447 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		extension = _tmp94_;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp95_ = self->priv->save_dialog;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp96_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp95_);
#line 449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		path = _tmp96_;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp97_ = path;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp98_ = g_path_get_basename (_tmp97_);
#line 450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		filename = _tmp98_;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp99_ = filename;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp100_ = string_last_index_of_char (_tmp99_, (gunichar) '.', 0);
#line 452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		extension_index = _tmp100_;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp101_ = extension_index;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp101_ < 0) {
#line 2499 "ui.c"
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp102_ = path;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp103_ = extension;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp104_ = g_strconcat (_tmp102_, _tmp103_, NULL);
#line 454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (path);
#line 454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			path = _tmp104_;
#line 2513 "ui.c"
		}
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp105_ = path;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp106_ = g_file_new_for_path (_tmp105_);
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp107_ = _tmp106_;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp108_ = g_file_get_uri (_tmp107_);
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp108_;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (_tmp107_);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (extension);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (selection);
#line 2537 "ui.c"
	}
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp109_ = self->priv->settings;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp110_ = self->priv->save_dialog;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp111_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp110_);
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp112_ = _tmp111_;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_string (_tmp109_, "save-directory", _tmp112_);
#line 459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp112_);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp113_ = file_type_view;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp114_ = gtk_tree_view_get_selection (_tmp113_);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("changed", GTK_TYPE_TREE_SELECTION, &_tmp115_, NULL, FALSE);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp114_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp115_, 0, NULL, (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp116_ = self->priv->save_dialog;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp116_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_dialog = NULL;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = uri;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (column);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file_type_view);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file_type_store);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (default_extension);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (expander);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (filter);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (directory);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 2585 "ui.c"
}


static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_ = NULL;
	GFile* file;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* uri_lower;
	gchar* _tmp13_;
	gchar* format;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	Book* _tmp41_;
	GError * _inner_error_ = NULL;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_uri;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_ != NULL) {
#line 2617 "ui.c"
		gboolean _tmp2_;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = force_choose_location;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = !_tmp2_;
#line 2623 "ui.c"
	} else {
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = FALSE;
#line 2627 "ui.c"
	}
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = _tmp0_;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 2633 "ui.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->book_uri;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp5_;
#line 2644 "ui.c"
	} else {
		gchar* _tmp6_ = NULL;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = user_interface_choose_file_location (self);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		uri = _tmp6_;
#line 2653 "ui.c"
	}
#line 475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = uri;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ == NULL) {
#line 476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 2665 "ui.c"
	}
#line 478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = uri;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = g_file_new_for_uri (_tmp8_);
#line 478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file = _tmp9_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = uri;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:480: Saving to '%s'", _tmp10_);
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = uri;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) (-1));
#line 482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	uri_lower = _tmp12_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = g_strdup ("jpeg");
#line 483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	format = _tmp13_;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = uri_lower;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = g_str_has_suffix (_tmp14_, ".pdf");
#line 484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp15_) {
#line 2693 "ui.c"
		gchar* _tmp16_;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = g_strdup ("pdf");
#line 485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 485 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		format = _tmp16_;
#line 2701 "ui.c"
	} else {
		const gchar* _tmp17_;
		gboolean _tmp18_ = FALSE;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = uri_lower;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp18_ = g_str_has_suffix (_tmp17_, ".ps");
#line 486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp18_) {
#line 2711 "ui.c"
			gchar* _tmp19_;
#line 487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp19_ = g_strdup ("ps");
#line 487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (format);
#line 487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			format = _tmp19_;
#line 2719 "ui.c"
		} else {
			const gchar* _tmp20_;
			gboolean _tmp21_ = FALSE;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp20_ = uri_lower;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp21_ = g_str_has_suffix (_tmp20_, ".png");
#line 488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp21_) {
#line 2729 "ui.c"
				gchar* _tmp22_;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp22_ = g_strdup ("png");
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (format);
#line 489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				format = _tmp22_;
#line 2737 "ui.c"
			} else {
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp28_;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp24_ = uri_lower;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp25_ = g_str_has_suffix (_tmp24_, ".tif");
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp25_) {
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = TRUE;
#line 2751 "ui.c"
				} else {
					const gchar* _tmp26_;
					gboolean _tmp27_ = FALSE;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp26_ = uri_lower;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp27_ = g_str_has_suffix (_tmp26_, ".tiff");
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp23_ = _tmp27_;
#line 2761 "ui.c"
				}
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp28_ = _tmp23_;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp28_) {
#line 2767 "ui.c"
					gchar* _tmp29_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp29_ = g_strdup ("tiff");
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (format);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					format = _tmp29_;
#line 2775 "ui.c"
				}
			}
		}
	}
#line 493 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_progress_dialog (self);
#line 2782 "ui.c"
	{
		Book* _tmp30_;
		const gchar* _tmp31_;
		gint _tmp32_ = 0;
		GFile* _tmp33_;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp30_ = self->priv->book;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp31_ = format;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp32_ = user_interface_get_quality (self);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp33_ = file;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_save (_tmp30_, _tmp31_, _tmp32_, _tmp33_, &_inner_error_);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 2800 "ui.c"
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_ = NULL;
		GError* _tmp37_;
		const gchar* _tmp38_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_hide_progress_dialog (self);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp34_ = e;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp35_ = _tmp34_->message;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:501: Error saving file: %s", _tmp35_);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp36_ = _ ("Failed to save file");
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp37_ = e;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp38_ = _tmp37_->message;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error (self, _tmp36_, _tmp38_, FALSE);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri_lower);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 506 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 2847 "ui.c"
	}
	__finally16:
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (format);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri_lower);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (uri);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return FALSE;
#line 2866 "ui.c"
	}
#line 509 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = uri;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = g_strdup (_tmp39_);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = _tmp40_;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp41_ = self->priv->book;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_set_needs_saving (_tmp41_, FALSE);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (format);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (uri_lower);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (uri);
#line 511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 2892 "ui.c"
}


static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkWindow* _tmp2_;
	const gchar* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* dialog;
	GtkMessageDialog* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_;
	const gchar* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	gint _tmp12_ = 0;
	gint response;
	GtkMessageDialog* _tmp13_;
	gint _tmp14_;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (title != NULL, FALSE);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (discard_label != NULL, FALSE);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_get_needs_saving (_tmp0_);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp1_) {
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = TRUE;
#line 517 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 2931 "ui.c"
	}
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->window;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = title;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp3_);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp4_);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dialog = _tmp4_;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = dialog;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _ ("If you don't save, changes will be permanently lost.");
#line 524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_message_dialog_format_secondary_text (_tmp5_, "%s", _tmp6_);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = dialog;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = discard_label;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp7_, _tmp8_, (gint) GTK_RESPONSE_NO);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = dialog;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = dialog;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = dialog;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	response = _tmp12_;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = dialog;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = response;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	switch (_tmp14_) {
#line 534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_YES:
#line 2979 "ui.c"
		{
			gboolean _tmp15_ = FALSE;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp15_ = user_interface_save_document (self, FALSE);
#line 537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp15_) {
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				result = TRUE;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (dialog);
#line 538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				return result;
#line 2992 "ui.c"
			} else {
#line 540 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				result = FALSE;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_object_unref0 (dialog);
#line 540 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				return result;
#line 3000 "ui.c"
			}
		}
#line 534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_CANCEL:
#line 3005 "ui.c"
		{
#line 542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			result = FALSE;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_object_unref0 (dialog);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return result;
#line 3013 "ui.c"
		}
		default:
#line 534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		case GTK_RESPONSE_NO:
#line 3018 "ui.c"
		{
#line 545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			result = TRUE;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_object_unref0 (dialog);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return result;
#line 3026 "ui.c"
		}
	}
#line 514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (dialog);
#line 3031 "ui.c"
}


static void user_interface_clear_document (UserInterface* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_clear (_tmp0_);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_add_default_page (self);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = NULL;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_set_needs_saving (_tmp1_, FALSE);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->save_as_menuitem;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->copy_to_clipboard_menuitem;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 3064 "ui.c"
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Save current document?");
#line 562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Discard Changes");
#line 562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 562 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 3087 "ui.c"
	}
#line 568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->scanning;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 569 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3095 "ui.c"
	}
#line 570 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_clear_document (self);
#line 3099 "ui.c"
}


static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (document_hint != NULL);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = document_hint;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->document_hint = _tmp1_;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = document_hint;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_strcmp0 (_tmp2_, "text") == 0) {
#line 3123 "ui.c"
		GtkRadioMenuItem* _tmp3_;
		GtkRadioMenuItem* _tmp4_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->text_toolbar_menuitem;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
#line 580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->text_menu_menuitem;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
#line 3134 "ui.c"
	} else {
		const gchar* _tmp5_;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = document_hint;
#line 582 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
#line 3141 "ui.c"
			GtkRadioMenuItem* _tmp6_;
			GtkRadioMenuItem* _tmp7_;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp6_ = self->priv->photo_toolbar_menuitem;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp7_ = self->priv->photo_menu_menuitem;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
#line 3152 "ui.c"
		}
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 590 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, "text");
#line 3173 "ui.c"
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 597 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 600 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, "photo");
#line 3193 "ui.c"
	}
}


static void user_interface_set_page_side (UserInterface* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->page_side_model;
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3213 "ui.c"
		{
			gboolean _tmp3_;
#line 609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = TRUE;
#line 609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			while (TRUE) {
#line 3220 "ui.c"
				gboolean _tmp4_;
				gint s = 0;
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_;
				gint _tmp9_;
				ScanType _tmp10_;
#line 609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp4_ = _tmp3_;
#line 609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (!_tmp4_) {
#line 3231 "ui.c"
					GtkListStore* _tmp5_;
					gboolean _tmp6_ = FALSE;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp5_ = self->priv->page_side_model;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (!_tmp6_) {
#line 618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						break;
#line 3242 "ui.c"
					}
				}
#line 609 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp3_ = FALSE;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp7_ = self->priv->page_side_model;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = iter;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &s, -1, -1);
#line 613 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp9_ = s;
#line 613 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = page_side;
#line 613 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp9_ == ((gint) _tmp10_)) {
#line 3259 "ui.c"
					GtkComboBox* _tmp11_;
					GtkTreeIter _tmp12_;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp11_ = self->priv->page_side_combo;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp12_ = iter;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp11_, &_tmp12_);
#line 616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					return;
#line 3270 "ui.c"
				}
			}
		}
	}
}


static void user_interface_set_paper_size (UserInterface* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp16_;
	gboolean _tmp20_;
#line 622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 3285 "ui.c"
	{
		GtkListStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = self->priv->paper_size_model;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp1_;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_iter = _tmp2_;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = TRUE;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		while (TRUE) {
#line 3303 "ui.c"
			gboolean _tmp4_;
			gboolean _tmp7_;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp8_;
			GtkTreeIter _tmp9_;
			gboolean _tmp10_ = FALSE;
			gint _tmp11_;
			gint _tmp12_;
			gboolean _tmp15_;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp4_ = _tmp3_;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (!_tmp4_) {
#line 3318 "ui.c"
				GtkListStore* _tmp5_;
				gboolean _tmp6_ = FALSE;
#line 629 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp5_ = self->priv->paper_size_model;
#line 629 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
#line 629 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				have_iter = _tmp6_;
#line 3327 "ui.c"
			}
#line 627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp3_ = FALSE;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp7_ = have_iter;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (!_tmp7_) {
#line 628 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 3337 "ui.c"
			}
#line 632 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp8_ = self->priv->paper_size_model;
#line 632 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = iter;
#line 632 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &w, 1, &h, -1, -1);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = w;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = width;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp11_ == _tmp12_) {
#line 3351 "ui.c"
				gint _tmp13_;
				gint _tmp14_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp13_ = h;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp14_ = height;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = _tmp13_ == _tmp14_;
#line 3360 "ui.c"
			} else {
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = FALSE;
#line 3364 "ui.c"
			}
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp15_ = _tmp10_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (_tmp15_) {
#line 634 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				break;
#line 3372 "ui.c"
			}
		}
	}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = have_iter;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp16_) {
#line 3380 "ui.c"
		GtkListStore* _tmp17_;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = self->priv->paper_size_model;
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp19_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp17_, &_tmp18_);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp18_;
#line 638 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		have_iter = _tmp19_;
#line 3392 "ui.c"
	}
#line 639 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = have_iter;
#line 639 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp20_) {
#line 3398 "ui.c"
		GtkComboBox* _tmp21_;
		GtkTreeIter _tmp22_;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp21_ = self->priv->paper_size_combo;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp22_ = iter;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 3407 "ui.c"
	}
}


static void user_interface_set_brightness (UserInterface* self, gint brightness) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = brightness;
#line 645 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 3423 "ui.c"
}


static void user_interface_set_contrast (UserInterface* self, gint contrast) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
#line 648 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 650 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 650 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = contrast;
#line 650 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 3438 "ui.c"
}


static void user_interface_set_quality (UserInterface* self, gint quality) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
#line 653 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 655 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 655 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = quality;
#line 655 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
#line 3453 "ui.c"
}


static gint user_interface_get_text_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 658 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 661 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->text_dpi_combo;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3476 "ui.c"
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->text_dpi_model;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3485 "ui.c"
	}
#line 666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = dpi;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3491 "ui.c"
}


static gint user_interface_get_photo_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 672 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->photo_dpi_combo;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3514 "ui.c"
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->photo_dpi_model;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
#line 3523 "ui.c"
	}
#line 677 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = dpi;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3529 "ui.c"
}


static ScanType user_interface_get_page_side (UserInterface* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 683 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->page_side_combo;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp1_;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 3553 "ui.c"
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->page_side_model;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = iter;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
#line 3562 "ui.c"
	}
#line 688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page_side;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (ScanType) _tmp5_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3570 "ui.c"
}


static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_;
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 691 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 695 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_height = 0;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _vala_height;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_vala_width = _tmp0_;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->paper_size_combo;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
#line 696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp2_;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_) {
#line 3599 "ui.c"
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
#line 698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->paper_size_model;
#line 698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = iter;
#line 698 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = TRUE;
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (width) {
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			*width = _vala_width;
#line 3614 "ui.c"
		}
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (height) {
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			*height = _vala_height;
#line 3620 "ui.c"
		}
#line 699 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 3624 "ui.c"
	}
#line 702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (width) {
#line 702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*width = _vala_width;
#line 3632 "ui.c"
	}
#line 702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (height) {
#line 702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*height = _vala_height;
#line 3638 "ui.c"
	}
#line 702 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3642 "ui.c"
}


static gint user_interface_get_brightness (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
#line 705 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 707 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->brightness_adjustment;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 707 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp1_;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3660 "ui.c"
}


static gint user_interface_get_contrast (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
#line 710 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->contrast_adjustment;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp1_;
#line 712 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3678 "ui.c"
}


static gint user_interface_get_quality (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->quality_adjustment;
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = (gint) _tmp1_;
#line 717 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3696 "ui.c"
}


static ScanOptions* user_interface_get_scan_options (UserInterface* self) {
	ScanOptions* result = NULL;
	ScanOptions* _tmp0_;
	ScanOptions* options;
	const gchar* _tmp1_;
	ScanOptions* _tmp10_;
	ScanOptions* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	ScanOptions* _tmp14_;
	gint _tmp15_ = 0;
	ScanOptions* _tmp16_;
	gint _tmp17_ = 0;
#line 720 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = scan_options_new ();
#line 722 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options = _tmp0_;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->document_hint;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 3723 "ui.c"
		ScanOptions* _tmp2_;
		ScanOptions* _tmp3_;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = options;
#line 725 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = options;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = user_interface_get_text_dpi (self);
#line 726 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_->dpi = _tmp4_;
#line 727 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = options;
#line 727 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_->depth = 2;
#line 3742 "ui.c"
	} else {
		ScanOptions* _tmp6_;
		ScanOptions* _tmp7_;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_;
#line 731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = options;
#line 731 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = options;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = user_interface_get_photo_dpi (self);
#line 732 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_->dpi = _tmp8_;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = options;
#line 733 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_->depth = 8;
#line 3762 "ui.c"
	}
#line 735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = options;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = options;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp12_, &_tmp13_);
#line 735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_->paper_width = _tmp12_;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_->paper_height = _tmp13_;
#line 736 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = options;
#line 736 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = user_interface_get_brightness (self);
#line 736 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_->brightness = _tmp15_;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = options;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = user_interface_get_contrast (self);
#line 737 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_->contrast = _tmp17_;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = options;
#line 739 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3790 "ui.c"
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	ScanOptions* _tmp0_ = NULL;
	ScanOptions* options;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_get_scan_options (self);
#line 745 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options = _tmp0_;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	options->type = SCAN_TYPE_SINGLE;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_selected_device (self);
#line 747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "start-scan", _tmp2_, options);
#line 747 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (_tmp2_);
#line 743 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_scan_options_unref0 (options);
#line 3819 "ui.c"
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 751 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 751 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 753 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "stop-scan");
#line 3830 "ui.c"
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
#line 757 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 757 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->scanning;
#line 759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 760 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "stop-scan");
#line 3846 "ui.c"
	} else {
		ScanOptions* _tmp1_ = NULL;
		ScanOptions* options;
		ScanOptions* _tmp2_;
		ScanType _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		ScanOptions* _tmp6_;
#line 763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = user_interface_get_scan_options (self);
#line 763 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		options = _tmp1_;
#line 764 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = options;
#line 764 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = user_interface_get_page_side (self);
#line 764 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_->type = _tmp3_;
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = user_interface_get_selected_device (self);
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _tmp4_;
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = options;
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_signal_emit_by_name (self, "start-scan", _tmp5_, _tmp6_);
#line 765 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp5_);
#line 759 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_scan_options_unref0 (options);
#line 3877 "ui.c"
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkDialog* _tmp0_;
#line 770 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 770 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 772 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 3892 "ui.c"
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self) {
	gboolean result = FALSE;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 776 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 778 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 778 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 3906 "ui.c"
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self) {
	GtkDialog* _tmp0_;
#line 782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 782 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 784 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 784 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 3920 "ui.c"
}


static void user_interface_update_page_menu (UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 789 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 789 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 789 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp1_;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 790 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_ == NULL) {
#line 3941 "ui.c"
		GtkMenuItem* _tmp3_;
		GtkMenuItem* _tmp4_;
#line 792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->page_move_left_menuitem;
#line 792 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
#line 793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->page_move_right_menuitem;
#line 793 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
#line 3952 "ui.c"
	} else {
		Book* _tmp5_;
		Page* _tmp6_;
		guint _tmp7_ = 0U;
		guint index;
		GtkMenuItem* _tmp8_;
		guint _tmp9_;
		GtkMenuItem* _tmp10_;
		guint _tmp11_;
		Book* _tmp12_;
		guint _tmp13_ = 0U;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = self->priv->book;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = page;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = book_get_page_index (_tmp5_, _tmp6_);
#line 797 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		index = _tmp7_;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = self->priv->page_move_left_menuitem;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = index;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp9_ > ((guint) 0));
#line 799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = self->priv->page_move_right_menuitem;
#line 799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = index;
#line 799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = self->priv->book;
#line 799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = book_get_n_pages (_tmp12_);
#line 799 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ < (_tmp13_ - 1));
#line 3988 "ui.c"
	}
#line 787 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 3992 "ui.c"
}


static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page) {
	Page* _tmp0_;
	gchar* name;
	Page* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkBuilder* _tmp20_;
	const gchar* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkRadioMenuItem* _tmp23_;
	GtkRadioMenuItem* menuitem;
	GtkRadioMenuItem* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkToggleToolButton* _tmp27_;
	GtkToggleToolButton* toolbutton;
	GtkToggleToolButton* _tmp28_;
	Page* _tmp29_;
	gboolean _tmp30_ = FALSE;
#line 803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 805 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 805 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_ == NULL) {
#line 806 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4024 "ui.c"
	}
#line 808 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->updating_page_menu = TRUE;
#line 810 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 812 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	name = NULL;
#line 813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page;
#line 813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page_has_crop (_tmp1_);
#line 813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 4038 "ui.c"
		Page* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* crop_name;
		const gchar* _tmp5_;
#line 816 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = page;
#line 816 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = page_get_named_crop (_tmp3_);
#line 816 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		crop_name = _tmp4_;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = crop_name;
#line 817 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp5_ != NULL) {
#line 4053 "ui.c"
			const gchar* _tmp6_;
#line 819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp6_ = crop_name;
#line 819 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			if (g_strcmp0 (_tmp6_, "A4") == 0) {
#line 4059 "ui.c"
				gchar* _tmp7_;
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp7_ = g_strdup ("a4_menuitem");
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (name);
#line 820 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				name = _tmp7_;
#line 4067 "ui.c"
			} else {
				const gchar* _tmp8_;
#line 821 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp8_ = crop_name;
#line 821 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (g_strcmp0 (_tmp8_, "A5") == 0) {
#line 4074 "ui.c"
					gchar* _tmp9_;
#line 822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp9_ = g_strdup ("a5_menuitem");
#line 822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (name);
#line 822 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					name = _tmp9_;
#line 4082 "ui.c"
				} else {
					const gchar* _tmp10_;
#line 823 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp10_ = crop_name;
#line 823 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (g_strcmp0 (_tmp10_, "A6") == 0) {
#line 4089 "ui.c"
						gchar* _tmp11_;
#line 824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp11_ = g_strdup ("a6_menuitem");
#line 824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_g_free0 (name);
#line 824 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						name = _tmp11_;
#line 4097 "ui.c"
					} else {
						const gchar* _tmp12_;
#line 825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp12_ = crop_name;
#line 825 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						if (g_strcmp0 (_tmp12_, "letter") == 0) {
#line 4104 "ui.c"
							gchar* _tmp13_;
#line 826 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp13_ = g_strdup ("letter_menuitem");
#line 826 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (name);
#line 826 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							name = _tmp13_;
#line 4112 "ui.c"
						} else {
							const gchar* _tmp14_;
#line 827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp14_ = crop_name;
#line 827 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							if (g_strcmp0 (_tmp14_, "legal") == 0) {
#line 4119 "ui.c"
								gchar* _tmp15_;
#line 828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp15_ = g_strdup ("legal_menuitem");
#line 828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_g_free0 (name);
#line 828 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								name = _tmp15_;
#line 4127 "ui.c"
							} else {
								const gchar* _tmp16_;
#line 829 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								_tmp16_ = crop_name;
#line 829 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
								if (g_strcmp0 (_tmp16_, "4x6") == 0) {
#line 4134 "ui.c"
									gchar* _tmp17_;
#line 830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									_tmp17_ = g_strdup ("4x6_menuitem");
#line 830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									_g_free0 (name);
#line 830 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
									name = _tmp17_;
#line 4142 "ui.c"
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp18_;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp18_ = g_strdup ("custom_crop_menuitem");
#line 833 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_g_free0 (name);
#line 833 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			name = _tmp18_;
#line 4157 "ui.c"
		}
#line 813 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (crop_name);
#line 4161 "ui.c"
	} else {
		gchar* _tmp19_;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp19_ = g_strdup ("no_crop_menuitem");
#line 836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (name);
#line 836 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		name = _tmp19_;
#line 4170 "ui.c"
	}
#line 838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = self->priv->builder;
#line 838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = name;
#line 838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = gtk_builder_get_object (_tmp20_, _tmp21_);
#line 838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 838 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	menuitem = _tmp23_;
#line 839 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = menuitem;
#line 839 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp24_, TRUE);
#line 840 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = self->priv->builder;
#line 840 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = gtk_builder_get_object (_tmp25_, "crop_toolbutton");
#line 840 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_TOGGLE_TOOL_BUTTON, GtkToggleToolButton));
#line 840 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	toolbutton = _tmp27_;
#line 841 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = toolbutton;
#line 841 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = page;
#line 841 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = page_has_crop (_tmp29_);
#line 841 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_toggle_tool_button_set_active (_tmp28_, _tmp30_);
#line 843 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->updating_page_menu = FALSE;
#line 803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (toolbutton);
#line 803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 803 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (name);
#line 4210 "ui.c"
}


static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page) {
	gchar* _tmp0_ = NULL;
	gchar* path;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
#line 846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 848 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = get_temporary_filename ("scanned-page", "tiff");
#line 848 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	path = _tmp0_;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = path;
#line 849 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_ == NULL) {
#line 850 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 850 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4240 "ui.c"
	}
#line 851 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = path;
#line 851 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 851 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	file = _tmp3_;
#line 4248 "ui.c"
	{
		Page* _tmp4_;
		gint _tmp5_ = 0;
		GFile* _tmp6_;
#line 855 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = page;
#line 855 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = user_interface_get_quality (self);
#line 855 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = file;
#line 855 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_save (_tmp4_, "tiff", _tmp5_, _tmp6_, &_inner_error_);
#line 855 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4263 "ui.c"
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = _ ("Unable to save image for preview");
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = e;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = _tmp8_->message;
#line 859 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp7_, _tmp9_);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4294 "ui.c"
	}
	__finally17:
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 853 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4309 "ui.c"
	}
	{
		GtkWindow* _tmp10_;
		GdkScreen* _tmp11_ = NULL;
		GFile* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		guint32 _tmp15_ = 0U;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = self->priv->window;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = gtk_window_get_screen (_tmp10_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = file;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = g_file_get_uri (_tmp12_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = _tmp13_;
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = gtk_get_current_event_time ();
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_show_uri (_tmp11_, _tmp14_, _tmp15_, &_inner_error_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (_tmp14_);
#line 867 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 4336 "ui.c"
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 871 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = _ ("Unable to open image preview application");
#line 871 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp17_ = e;
#line 871 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp18_ = _tmp17_->message;
#line 871 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp16_, _tmp18_);
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 4361 "ui.c"
	}
	__finally18:
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (file);
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 865 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4376 "ui.c"
	}
#line 846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (file);
#line 846 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (path);
#line 4382 "ui.c"
}


static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_;
	GtkMenu* menu;
	guint32 _tmp3_ = 0U;
#line 877 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 877 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (view != NULL);
#line 879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->builder;
#line 879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_builder_get_object (_tmp0_, "page_menu");
#line 879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_MENU, GtkMenu));
#line 879 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	menu = _tmp2_;
#line 880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = gtk_get_current_event_time ();
#line 880 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp3_);
#line 877 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (menu);
#line 4410 "ui.c"
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 886 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 886 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 887 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4430 "ui.c"
	}
#line 888 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 888 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_view_get_selected (_tmp1_);
#line 888 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp2_;
#line 889 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 889 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_ != NULL) {
#line 4442 "ui.c"
		Page* _tmp4_;
#line 890 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = page;
#line 890 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_rotate_left (_tmp4_);
#line 4448 "ui.c"
	}
#line 884 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4452 "ui.c"
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
#line 894 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 894 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 897 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4472 "ui.c"
	}
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book_view;
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_view_get_selected (_tmp1_);
#line 898 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp2_;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp3_ != NULL) {
#line 4484 "ui.c"
		Page* _tmp4_;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = page;
#line 900 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_rotate_right (_tmp4_);
#line 4490 "ui.c"
	}
#line 894 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4494 "ui.c"
}


static void user_interface_set_crop (UserInterface* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* page;
	Page* _tmp5_;
	const gchar* _tmp6_;
#line 903 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->crop_rotate_menuitem;
#line 905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = crop_name;
#line 905 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
#line 907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->updating_page_menu;
#line 907 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 908 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4521 "ui.c"
	}
#line 910 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 910 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_view_get_selected (_tmp3_);
#line 910 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp4_;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page;
#line 911 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ == NULL) {
#line 912 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (page);
#line 912 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4537 "ui.c"
	}
#line 914 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = crop_name;
#line 914 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp6_ == NULL) {
#line 4543 "ui.c"
		Page* _tmp7_;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = page;
#line 916 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_set_no_crop (_tmp7_);
#line 917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (page);
#line 917 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4553 "ui.c"
	} else {
		const gchar* _tmp8_;
#line 919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = crop_name;
#line 919 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (g_strcmp0 (_tmp8_, "custom") == 0) {
#line 4560 "ui.c"
			Page* _tmp9_;
			gint _tmp10_ = 0;
			gint width;
			Page* _tmp11_;
			gint _tmp12_ = 0;
			gint height;
			gint _tmp13_;
			gint crop_width;
			gint _tmp14_;
			gint crop_height;
			Page* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Page* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp9_ = page;
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp10_ = page_get_width (_tmp9_);
#line 921 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			width = _tmp10_;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp11_ = page;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp12_ = page_get_height (_tmp11_);
#line 922 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			height = _tmp12_;
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp13_ = width;
#line 923 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			crop_width = (gint) ((_tmp13_ * 0.8) + 0.5);
#line 924 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp14_ = height;
#line 924 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			crop_height = (gint) ((_tmp14_ * 0.8) + 0.5);
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp15_ = page;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp16_ = crop_width;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp17_ = crop_height;
#line 925 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_set_custom_crop (_tmp15_, _tmp16_, _tmp17_);
#line 926 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp18_ = page;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp19_ = width;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp20_ = crop_width;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp21_ = height;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp22_ = crop_height;
#line 926 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_move_crop (_tmp18_, (_tmp19_ - _tmp20_) / 2, (_tmp21_ - _tmp22_) / 2);
#line 4619 "ui.c"
		} else {
			Page* _tmp23_;
			const gchar* _tmp24_;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp23_ = page;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp24_ = crop_name;
#line 929 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			page_set_named_crop (_tmp23_, _tmp24_);
#line 4629 "ui.c"
		}
	}
#line 903 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4634 "ui.c"
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 933 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 933 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 935 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 936 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, NULL);
#line 4653 "ui.c"
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 940 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 940 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 942 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 943 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "custom");
#line 4673 "ui.c"
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self) {
	gboolean _tmp0_;
	GtkRadioMenuItem* menuitem = NULL;
	GtkToggleToolButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* _tmp9_;
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->updating_page_menu;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_) {
#line 950 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4694 "ui.c"
	}
#line 953 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = widget;
#line 953 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
#line 953 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_) {
#line 4702 "ui.c"
		GtkBuilder* _tmp3_;
		GObject* _tmp4_ = NULL;
		GtkRadioMenuItem* _tmp5_;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->builder;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = gtk_builder_get_object (_tmp3_, "custom_crop_menuitem");
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 954 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		menuitem = _tmp5_;
#line 4716 "ui.c"
	} else {
		GtkBuilder* _tmp6_;
		GObject* _tmp7_ = NULL;
		GtkRadioMenuItem* _tmp8_;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->builder;
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = gtk_builder_get_object (_tmp6_, "no_crop_menuitem");
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (menuitem);
#line 956 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		menuitem = _tmp8_;
#line 4731 "ui.c"
	}
#line 957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = menuitem;
#line 957 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp9_, TRUE);
#line 947 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (menuitem);
#line 4739 "ui.c"
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 961 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 963 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 964 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "4x6");
#line 4758 "ui.c"
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 968 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 970 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 970 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 970 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 971 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "legal");
#line 4778 "ui.c"
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 975 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 977 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 978 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "letter");
#line 4798 "ui.c"
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 982 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 984 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 985 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A6");
#line 4818 "ui.c"
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 989 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 989 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 992 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A5");
#line 4838 "ui.c"
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 996 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 996 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 998 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = widget;
#line 998 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
#line 998 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp1_) {
#line 999 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_crop (self, "A4");
#line 4858 "ui.c"
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
	Page* _tmp3_;
#line 1003 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1003 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1005 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp1_;
#line 1006 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 1006 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_ == NULL) {
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_page_unref0 (page);
#line 1007 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 4887 "ui.c"
	}
#line 1008 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 1008 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page_rotate_crop (_tmp3_);
#line 1003 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4895 "ui.c"
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp1_;
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp4_;
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = index;
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ > ((guint) 0)) {
#line 4930 "ui.c"
		Book* _tmp6_;
		Page* _tmp7_;
		guint _tmp8_;
#line 1017 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = self->priv->book;
#line 1017 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = page;
#line 1017 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = index;
#line 1017 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_move_page (_tmp6_, _tmp7_, _tmp8_ - 1);
#line 4942 "ui.c"
	}
#line 1019 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1012 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 4948 "ui.c"
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
	Book* _tmp6_;
	guint _tmp7_ = 0U;
#line 1023 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1023 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1025 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1025 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1025 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp1_;
#line 1026 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 1026 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page;
#line 1026 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
#line 1026 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	index = _tmp4_;
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = index;
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->book;
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = book_get_n_pages (_tmp6_);
#line 1027 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ < (_tmp7_ - 1)) {
#line 4989 "ui.c"
		Book* _tmp8_;
		Page* _tmp9_;
		Book* _tmp10_;
		Page* _tmp11_;
		guint _tmp12_ = 0U;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = self->priv->book;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp9_ = page;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp10_ = self->priv->book;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp11_ = page;
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp12_ = book_get_page_index (_tmp10_, _tmp11_);
#line 1028 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		book_move_page (_tmp8_, _tmp9_, _tmp12_ + 1);
#line 5007 "ui.c"
	}
#line 1030 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 1023 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5013 "ui.c"
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Book* _tmp1_ = NULL;
	Book* _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* _tmp5_;
#line 1034 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1034 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_book (_tmp0_);
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _tmp1_;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book_view;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book_view_get_selected (_tmp3_);
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = _tmp4_;
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_delete_page (_tmp2_, _tmp5_);
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (_tmp5_);
#line 1036 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (_tmp2_);
#line 5046 "ui.c"
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, FALSE);
#line 5057 "ui.c"
}


void G_MODULE_EXPORT copy_to_clipboard_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1048 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1048 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1048 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp1_;
#line 1049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 1049 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp2_ != NULL) {
#line 5080 "ui.c"
		Page* _tmp3_;
		GtkWindow* _tmp4_;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = page;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = self->priv->window;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		page_copy_to_clipboard (_tmp3_, _tmp4_);
#line 5089 "ui.c"
	}
#line 1046 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 5093 "ui.c"
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1054 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1056 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_save_document (self, TRUE);
#line 5104 "ui.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? cairo_reference (self) : NULL;
#line 5111 "ui.c"
}


static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	GtkPrintContext* _tmp0_;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_;
	cairo_t* context;
	Book* _tmp3_;
	gint _tmp4_;
	Page* _tmp5_ = NULL;
	Page* page;
	gboolean is_landscape;
	GtkPrintContext* _tmp6_;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	cairo_t* _tmp17_;
	GtkPrintContext* _tmp18_;
	gdouble _tmp19_ = 0.0;
	Page* _tmp20_;
	gint _tmp21_ = 0;
	GtkPrintContext* _tmp22_;
	gdouble _tmp23_ = 0.0;
	Page* _tmp24_;
	gint _tmp25_ = 0;
	Page* _tmp26_;
	GdkPixbuf* _tmp27_ = NULL;
	GdkPixbuf* image;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (operation != NULL);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (print_context != NULL);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = print_context;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	context = _tmp2_;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->book;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page_number;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	page = _tmp5_;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	is_landscape = FALSE;
#line 1068 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = print_context;
#line 1068 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
#line 1068 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = print_context;
#line 1068 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
#line 1068 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_ > _tmp9_) {
#line 1069 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		is_landscape = TRUE;
#line 5182 "ui.c"
	}
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = page;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = page_is_landscape (_tmp10_);
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = is_landscape;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp11_ != _tmp12_) {
#line 5192 "ui.c"
		cairo_t* _tmp13_;
		GtkPrintContext* _tmp14_;
		gdouble _tmp15_ = 0.0;
		cairo_t* _tmp16_;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp13_ = context;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp14_ = print_context;
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp15_ = gtk_print_context_get_width (_tmp14_);
#line 1072 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		cairo_translate (_tmp13_, _tmp15_, (gdouble) 0);
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp16_ = context;
#line 1073 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		cairo_rotate (_tmp16_, G_PI_2);
#line 5209 "ui.c"
	}
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = context;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = print_context;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = gtk_print_context_get_dpi_x (_tmp18_);
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = page;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = page_get_dpi (_tmp20_);
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = print_context;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = gtk_print_context_get_dpi_y (_tmp22_);
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = page;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = page_get_dpi (_tmp24_);
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_scale (_tmp17_, _tmp19_ / _tmp21_, _tmp23_ / _tmp25_);
#line 1079 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = page;
#line 1079 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = page_get_image (_tmp26_, TRUE);
#line 1079 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	image = _tmp27_;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = context;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gdk_cairo_set_source_pixbuf (_tmp28_, image, (gdouble) 0, (gdouble) 0);
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = context;
#line 1081 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	cairo_paint (_tmp29_);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (image);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_page_unref0 (page);
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_cairo_destroy0 (context);
#line 5251 "ui.c"
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->document_hint;
#line 1087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = user_interface_get_quality (self);
#line 1087 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_emit_by_name (self, "email", _tmp0_, _tmp1_);
#line 5268 "ui.c"
}


static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_draw_page (self, _sender, context, page_nr);
#line 5275 "ui.c"
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkPrintOperation* _tmp0_;
	GtkPrintOperation* print;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp6_ = 0U;
	GError * _inner_error_ = NULL;
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1093 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_print_operation_new ();
#line 1093 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	print = _tmp0_;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_print_operation_set_n_pages (print, (gint) _tmp2_);
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (print, "draw-page", (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 5302 "ui.c"
	{
		GtkWindow* _tmp3_;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = self->priv->window;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp3_, &_inner_error_);
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 5311 "ui.c"
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = e;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1103 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1103: Error printing: %s", _tmp5_);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 5333 "ui.c"
	}
	__finally19:
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_object_unref0 (print);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5346 "ui.c"
	}
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("draw-page", GTK_TYPE_PRINT_OPERATION, &_tmp6_, NULL, FALSE);
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
#line 1091 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (print);
#line 5354 "ui.c"
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	GError * _inner_error_ = NULL;
#line 1110 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1110 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 5364 "ui.c"
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1114 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = self->priv->window;
#line 1114 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 1114 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1114 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
#line 1114 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 5379 "ui.c"
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = _ ("Unable to open help file");
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = e;
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _tmp4_->message;
#line 1118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp3_, _tmp5_);
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 5404 "ui.c"
	}
	__finally20:
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1112 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 5415 "ui.c"
	}
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* license;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* title;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* description;
	GtkWindow* _tmp8_;
	const gchar* _tmp9_ = NULL;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_[0] = _tmp0_;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors = _tmp1_;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors_length1 = 1;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_authors_size_ = authors_length1;
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	license = _tmp3_;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = _ ("About Simple Scan");
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	title = _tmp5_;
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = _ ("Simple document scanning tool");
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	description = _tmp7_;
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->window;
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = _ ("translator-credits");
#line 1138 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_show_about_dialog (_tmp8_, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp9_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (description);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (title);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (license);
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 5485 "ui.c"
}


static gboolean user_interface_on_quit (UserInterface* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* device;
	gint paper_width;
	gint paper_height;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	const gchar* _tmp6_;
	GSettings* _tmp9_;
	const gchar* _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_ = 0;
	GSettings* _tmp13_;
	gint _tmp14_ = 0;
	GSettings* _tmp15_;
	ScanType _tmp16_ = 0;
	GSettings* _tmp17_;
	gint _tmp18_;
	GSettings* _tmp19_;
	gint _tmp20_;
	GSettings* _tmp21_;
	gint _tmp22_ = 0;
	GSettings* _tmp23_;
	gint _tmp24_ = 0;
	GSettings* _tmp25_;
	gint _tmp26_ = 0;
	GSettings* _tmp27_;
	gint _tmp28_;
	GSettings* _tmp29_;
	gint _tmp30_;
	GSettings* _tmp31_;
	gboolean _tmp32_;
	GSettings* _tmp33_;
	ScanDirection _tmp34_;
	GSettings* _tmp35_;
	gint _tmp36_;
	GSettings* _tmp37_;
	gint _tmp38_;
	GSettings* _tmp39_;
	gint _tmp40_;
	GtkWindow* _tmp41_;
	AutosaveManager* _tmp42_;
#line 1153 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = _ ("Save document before quitting?");
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Quit without Saving");
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp2_) {
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = FALSE;
#line 1159 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 5549 "ui.c"
	}
#line 1161 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = user_interface_get_selected_device (self);
#line 1161 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	device = _tmp3_;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_width = 0;
#line 1162 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_height = 0;
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_get_paper_size (self, &_tmp4_, &_tmp5_);
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_width = _tmp4_;
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_height = _tmp5_;
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = device;
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp6_ != NULL) {
#line 5569 "ui.c"
		GSettings* _tmp7_;
		const gchar* _tmp8_;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = self->priv->settings;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = device;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_settings_set_string (_tmp7_, "selected-device", _tmp8_);
#line 5578 "ui.c"
	}
#line 1167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->settings;
#line 1167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = self->priv->document_hint;
#line 1167 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_string (_tmp9_, "document-type", _tmp10_);
#line 1168 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = self->priv->settings;
#line 1168 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = user_interface_get_text_dpi (self);
#line 1168 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp11_, "text-dpi", _tmp12_);
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->settings;
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = user_interface_get_photo_dpi (self);
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp13_, "photo-dpi", _tmp14_);
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->settings;
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = user_interface_get_page_side (self);
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_enum (_tmp15_, "page-side", (gint) _tmp16_);
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = self->priv->settings;
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = paper_width;
#line 1171 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp17_, "paper-width", _tmp18_);
#line 1172 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = self->priv->settings;
#line 1172 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = paper_height;
#line 1172 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp19_, "paper-height", _tmp20_);
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = self->priv->settings;
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = user_interface_get_brightness (self);
#line 1173 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp21_, "brightness", _tmp22_);
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = self->priv->settings;
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = user_interface_get_contrast (self);
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp23_, "contrast", _tmp24_);
#line 1175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = self->priv->settings;
#line 1175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = user_interface_get_quality (self);
#line 1175 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp25_, "jpeg-quality", _tmp26_);
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = self->priv->settings;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = self->priv->window_width;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp27_, "window-width", _tmp28_);
#line 1177 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = self->priv->settings;
#line 1177 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = self->priv->window_height;
#line 1177 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp29_, "window-height", _tmp30_);
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = self->priv->settings;
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = self->priv->window_is_maximized;
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_boolean (_tmp31_, "window-is-maximized", _tmp32_);
#line 1179 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = self->priv->settings;
#line 1179 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = self->priv->default_page_scan_direction;
#line 1179 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_enum (_tmp33_, "scan-direction", (gint) _tmp34_);
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = self->priv->settings;
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp36_ = self->priv->default_page_width;
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp35_, "page-width", _tmp36_);
#line 1181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp37_ = self->priv->settings;
#line 1181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = self->priv->default_page_height;
#line 1181 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp37_, "page-height", _tmp38_);
#line 1182 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = self->priv->settings;
#line 1182 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = self->priv->default_page_dpi;
#line 1182 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_settings_set_int (_tmp39_, "page-dpi", _tmp40_);
#line 1184 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp41_ = self->priv->window;
#line 1184 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp41_);
#line 1186 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp42_ = self->priv->autosave_manager;
#line 1186 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp42_ != NULL) {
#line 5684 "ui.c"
		AutosaveManager* _tmp43_;
#line 1187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp43_ = self->priv->autosave_manager;
#line 1187 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		autosave_manager_cleanup (_tmp43_);
#line 5690 "ui.c"
	}
#line 1189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = TRUE;
#line 1189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (device);
#line 1189 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5698 "ui.c"
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1195 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_on_quit (self);
#line 5709 "ui.c"
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 1199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1199 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->window_is_maximized;
#line 1201 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!_tmp0_) {
#line 5726 "ui.c"
		GdkEventConfigure _tmp1_;
		gint _tmp2_;
		GdkEventConfigure _tmp3_;
		gint _tmp4_;
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = *event;
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = _tmp1_.width;
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_width = _tmp2_;
#line 1204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = *event;
#line 1204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = _tmp3_.height;
#line 1204 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_height = _tmp4_;
#line 5743 "ui.c"
	}
#line 1207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1207 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5749 "ui.c"
}


static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_;
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (widget != NULL);
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = response_id;
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp0_ == 1) {
#line 5763 "ui.c"
		GtkComboBox* _tmp1_;
		GtkDialog* _tmp2_;
#line 1214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp1_ = self->priv->device_combo;
#line 1214 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1215 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = self->priv->preferences_dialog;
#line 1215 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 5774 "ui.c"
	} else {
#line 1219 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->have_error = FALSE;
#line 1220 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (self->priv->error_title);
#line 1220 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->error_title = NULL;
#line 1221 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (self->priv->error_text);
#line 1221 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->error_text = NULL;
#line 1222 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_update_info_bar (self);
#line 5788 "ui.c"
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_;
	GdkWindowState _tmp1_;
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = *event;
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _tmp0_.changed_mask;
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 5809 "ui.c"
		GdkEventWindowState _tmp2_;
		GdkWindowState _tmp3_;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = *event;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = _tmp2_.new_window_state;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 5818 "ui.c"
	}
#line 1231 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1231 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5824 "ui.c"
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1235 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = user_interface_on_quit (self);
#line 1237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = !_tmp0_;
#line 1237 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 5843 "ui.c"
}


static void user_interface_page_size_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_width = _tmp1_;
#line 1243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 1243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 1243 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_height = _tmp3_;
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page_get_dpi (_tmp4_);
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_dpi = _tmp5_;
#line 5876 "ui.c"
}


static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_;
	ScanDirection _tmp1_ = 0;
#line 1247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1247 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 1249 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp1_;
#line 5893 "ui.c"
}


static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_size_changed_cb (self, _sender);
#line 5900 "ui.c"
}


static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 1259 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_scan_direction_changed_cb (self, _sender);
#line 5907 "ui.c"
}


static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
	Page* _tmp6_;
	ScanDirection _tmp7_ = 0;
	Page* _tmp8_;
	Page* _tmp9_;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 1254 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_width = _tmp1_;
#line 1255 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 1255 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 1255 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_height = _tmp3_;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = page;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = page_get_dpi (_tmp4_);
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_dpi = _tmp5_;
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = page;
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = page_get_scan_direction (_tmp6_);
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_scan_direction = _tmp7_;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = page;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp8_, "size-changed", (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1259 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = page;
#line 1259 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp9_, "scan-direction-changed", (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1261 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 5962 "ui.c"
}


static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Book* _tmp4_;
	guint _tmp5_ = 0U;
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = page;
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 1266 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
#line 1267 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = page;
#line 1267 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 1267 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book;
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_get_n_pages (_tmp4_);
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp5_ == ((guint) 1)) {
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_add_default_page (self);
#line 5999 "ui.c"
	}
#line 1273 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_page_menu (self);
#line 6003 "ui.c"
}


static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp1_;
	GtkCellRendererText* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkCellRendererText* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_ = NULL;
	GtkListStore* _tmp7_;
	GtkListStore* model;
	gint* _tmp8_ = NULL;
	gint* scan_resolutions;
	gint scan_resolutions_length1;
	gint _scan_resolutions_size_;
	gint* _tmp9_;
	gint _tmp9__length1;
#line 1276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (combo != NULL);
#line 1278 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1278 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1278 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp0_;
#line 1279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = combo;
#line 1279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = renderer;
#line 1279 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) _tmp2_, TRUE);
#line 1280 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = combo;
#line 1280 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = renderer;
#line 1280 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, "text", 1);
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = combo;
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1282 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	model = _tmp7_;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = g_new0 (gint, 6);
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[0] = 75;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[1] = 150;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[2] = 300;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[3] = 600;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[4] = 1200;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_[5] = 2400;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions = _tmp8_;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions_length1 = 6;
#line 1283 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_scan_resolutions_size_ = scan_resolutions_length1;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = scan_resolutions;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9__length1 = scan_resolutions_length1;
#line 6078 "ui.c"
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi_collection = _tmp9_;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi_collection_length1 = _tmp9__length1;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		for (dpi_it = 0; dpi_it < _tmp9__length1; dpi_it = dpi_it + 1) {
#line 6090 "ui.c"
			gint dpi = 0;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			dpi = dpi_collection[dpi_it];
#line 6094 "ui.c"
			{
				gchar* label = NULL;
				gint _tmp10_;
				gint _tmp11_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp26_;
				GtkTreeIter _tmp27_ = {0};
				GtkListStore* _tmp28_;
				GtkTreeIter _tmp29_;
				gint _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
#line 1287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp10_ = dpi;
#line 1287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp11_ = default_dpi;
#line 1287 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp10_ == _tmp11_) {
#line 6114 "ui.c"
					const gchar* _tmp12_ = NULL;
					gint _tmp13_;
					gchar* _tmp14_ = NULL;
#line 1289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp12_ = _ ("%d dpi (default)");
#line 1289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp13_ = dpi;
#line 1289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
#line 1289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_g_free0 (label);
#line 1289 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					label = _tmp14_;
#line 6128 "ui.c"
				} else {
					gint _tmp15_;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp15_ = dpi;
#line 1290 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					if (_tmp15_ == 75) {
#line 6135 "ui.c"
						const gchar* _tmp16_ = NULL;
						gint _tmp17_;
						gchar* _tmp18_ = NULL;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp16_ = _ ("%d dpi (draft)");
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp17_ = dpi;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_g_free0 (label);
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						label = _tmp18_;
#line 6149 "ui.c"
					} else {
						gint _tmp19_;
#line 1293 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						_tmp19_ = dpi;
#line 1293 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
						if (_tmp19_ == 1200) {
#line 6156 "ui.c"
							const gchar* _tmp20_ = NULL;
							gint _tmp21_;
							gchar* _tmp22_ = NULL;
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp20_ = _ ("%d dpi (high resolution)");
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp21_ = dpi;
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (label);
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							label = _tmp22_;
#line 6170 "ui.c"
						} else {
							const gchar* _tmp23_ = NULL;
							gint _tmp24_;
							gchar* _tmp25_ = NULL;
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp23_ = _ ("%d dpi");
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp24_ = dpi;
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_tmp25_ = g_strdup_printf (_tmp23_, _tmp24_);
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							_g_free0 (label);
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
							label = _tmp25_;
#line 6185 "ui.c"
						}
					}
				}
#line 1301 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp26_ = model;
#line 1301 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_list_store_append (_tmp26_, &_tmp27_);
#line 1301 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				iter = _tmp27_;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp28_ = model;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp29_ = iter;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp30_ = dpi;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp31_ = label;
#line 1302 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, 1, _tmp31_, -1, -1);
#line 1304 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp32_ = dpi;
#line 1304 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_tmp33_ = current_dpi;
#line 1304 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				if (_tmp32_ == _tmp33_) {
#line 6211 "ui.c"
					GtkComboBox* _tmp34_;
					GtkTreeIter _tmp35_;
#line 1305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp34_ = combo;
#line 1305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					_tmp35_ = iter;
#line 1305 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
					gtk_combo_box_set_active_iter (_tmp34_, &_tmp35_);
#line 6220 "ui.c"
				}
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
				_g_free0 (label);
#line 6224 "ui.c"
			}
		}
	}
#line 1276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	scan_resolutions = (g_free (scan_resolutions), NULL);
#line 1276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (model);
#line 1276 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 6234 "ui.c"
}


static void user_interface_needs_saving_cb (UserInterface* self, Book* book) {
	GtkMenuItem* _tmp0_;
	Book* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkToolButton* _tmp3_;
	Book* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Book* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GtkMenuItem* _tmp9_;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (book != NULL);
#line 1311 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->save_menuitem;
#line 1311 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book;
#line 1311 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_needs_saving (_tmp1_);
#line 1311 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
#line 1312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->save_toolbutton;
#line 1312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = book;
#line 1312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = book_get_needs_saving (_tmp4_);
#line 1312 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = book;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = book_get_needs_saving (_tmp6_);
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp7_) {
#line 6274 "ui.c"
		GtkMenuItem* _tmp8_;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = self->priv->save_as_menuitem;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
#line 6280 "ui.c"
	}
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->copy_to_clipboard_menuitem;
#line 1315 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
#line 6286 "ui.c"
}


static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_info_bar_response_cb (self, _sender, response_id);
#line 6293 "ui.c"
}


static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_page_selected_cb (self, _sender, page);
#line 6300 "ui.c"
}


static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_page_cb (self, _sender, page);
#line 6307 "ui.c"
}


static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_show_page_menu_cb (self, _sender);
#line 6314 "ui.c"
}


static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_needs_saving_cb (self, _sender);
#line 6321 "ui.c"
}


static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self) {
#line 1528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_book_saving_cb (self, i);
#line 6328 "ui.c"
}


static void user_interface_load (UserInterface* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp7_;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkWindow* _tmp10_;
	GApplication* _tmp11_ = NULL;
	GtkApplication* _tmp12_;
	GtkApplication* app;
	GtkApplication* _tmp13_;
	GtkWindow* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkVBox* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkMenuItem* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkMenuItem* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkMenuItem* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_ = NULL;
	GtkMenuItem* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkToolButton* _tmp41_;
	GtkBuilder* _tmp42_;
	GObject* _tmp43_ = NULL;
	GtkMenuItem* _tmp44_;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_ = NULL;
	GtkToolButton* _tmp47_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_ = NULL;
	GtkRadioMenuItem* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_ = NULL;
	GtkRadioMenuItem* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_ = NULL;
	GtkRadioMenuItem* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_ = NULL;
	GtkRadioMenuItem* _tmp59_;
	GtkBuilder* _tmp60_;
	GObject* _tmp61_ = NULL;
	GtkDialog* _tmp62_;
	GtkBuilder* _tmp63_;
	GObject* _tmp64_ = NULL;
	GtkLabel* _tmp65_;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_ = NULL;
	GtkEntry* _tmp68_;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_ = NULL;
	GtkEntry* _tmp71_;
	GtkBuilder* _tmp72_;
	GObject* _tmp73_ = NULL;
	GtkDialog* _tmp74_;
	GtkBuilder* _tmp75_;
	GObject* _tmp76_ = NULL;
	GtkComboBox* _tmp77_;
	GtkComboBox* _tmp78_;
	GtkTreeModel* _tmp79_ = NULL;
	GtkListStore* _tmp80_;
	GtkBuilder* _tmp81_;
	GObject* _tmp82_ = NULL;
	GtkComboBox* _tmp83_;
	GtkComboBox* _tmp84_;
	GtkTreeModel* _tmp85_ = NULL;
	GtkListStore* _tmp86_;
	GtkBuilder* _tmp87_;
	GObject* _tmp88_ = NULL;
	GtkComboBox* _tmp89_;
	GtkComboBox* _tmp90_;
	GtkTreeModel* _tmp91_ = NULL;
	GtkListStore* _tmp92_;
	GtkBuilder* _tmp93_;
	GObject* _tmp94_ = NULL;
	GtkComboBox* _tmp95_;
	GtkComboBox* _tmp96_;
	GtkTreeModel* _tmp97_ = NULL;
	GtkListStore* _tmp98_;
	GtkBuilder* _tmp99_;
	GObject* _tmp100_ = NULL;
	GtkComboBox* _tmp101_;
	GtkComboBox* _tmp102_;
	GtkTreeModel* _tmp103_ = NULL;
	GtkListStore* _tmp104_;
	GtkBuilder* _tmp105_;
	GObject* _tmp106_ = NULL;
	GtkScale* _tmp107_;
	GtkScale* _tmp108_;
	GtkAdjustment* _tmp109_ = NULL;
	GtkAdjustment* _tmp110_;
	GtkBuilder* _tmp111_;
	GObject* _tmp112_ = NULL;
	GtkScale* _tmp113_;
	GtkScale* _tmp114_;
	GtkAdjustment* _tmp115_ = NULL;
	GtkAdjustment* _tmp116_;
	GtkBuilder* _tmp117_;
	GObject* _tmp118_ = NULL;
	GtkScale* _tmp119_;
	GtkScale* _tmp120_;
	GtkAdjustment* _tmp121_ = NULL;
	GtkAdjustment* _tmp122_;
	GtkInfoBar* _tmp123_;
	GtkInfoBar* _tmp124_;
	GtkVBox* _tmp125_;
	GtkInfoBar* _tmp126_;
	GtkBox* _tmp127_;
	GtkBox* hbox;
	GtkInfoBar* _tmp128_;
	GtkContainer* _tmp129_ = NULL;
	GtkContainer* _tmp130_;
	GtkContainer* content_area;
	GtkContainer* _tmp131_;
	GtkBox* _tmp132_;
	GtkBox* _tmp133_;
	GtkImage* _tmp134_;
	GtkBox* _tmp135_;
	GtkImage* _tmp136_;
	GtkImage* _tmp137_;
	GtkLabel* _tmp138_;
	GtkLabel* _tmp139_;
	GtkBox* _tmp140_;
	GtkLabel* _tmp141_;
	GtkLabel* _tmp142_;
	GtkInfoBar* _tmp143_;
	GtkButton* _tmp144_ = NULL;
	GtkButton* _tmp145_;
	GtkInfoBar* _tmp146_;
	const gchar* _tmp147_ = NULL;
	GtkButton* _tmp148_ = NULL;
	GtkButton* _tmp149_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp150_;
	GtkTreeIter _tmp151_ = {0};
	GtkListStore* _tmp152_;
	GtkTreeIter _tmp153_;
	const gchar* _tmp154_ = NULL;
	GtkListStore* _tmp155_;
	GtkTreeIter _tmp156_ = {0};
	GtkListStore* _tmp157_;
	GtkTreeIter _tmp158_;
	GtkListStore* _tmp159_;
	GtkTreeIter _tmp160_ = {0};
	GtkListStore* _tmp161_;
	GtkTreeIter _tmp162_;
	GtkListStore* _tmp163_;
	GtkTreeIter _tmp164_ = {0};
	GtkListStore* _tmp165_;
	GtkTreeIter _tmp166_;
	GtkListStore* _tmp167_;
	GtkTreeIter _tmp168_ = {0};
	GtkListStore* _tmp169_;
	GtkTreeIter _tmp170_;
	GtkListStore* _tmp171_;
	GtkTreeIter _tmp172_ = {0};
	GtkListStore* _tmp173_;
	GtkTreeIter _tmp174_;
	GtkListStore* _tmp175_;
	GtkTreeIter _tmp176_ = {0};
	GtkListStore* _tmp177_;
	GtkTreeIter _tmp178_;
	GSettings* _tmp179_;
	gint _tmp180_ = 0;
	gint dpi;
	gint _tmp181_;
	GtkComboBox* _tmp182_;
	gint _tmp183_;
	GSettings* _tmp184_;
	gint _tmp185_ = 0;
	gint _tmp186_;
	GtkComboBox* _tmp187_;
	gint _tmp188_;
	GtkCellRendererText* _tmp189_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp190_;
	GtkCellRendererText* _tmp191_;
	GtkComboBox* _tmp192_;
	GtkCellRendererText* _tmp193_;
	GtkCellRendererText* _tmp194_;
	GtkComboBox* _tmp195_;
	GtkCellRendererText* _tmp196_;
	GtkComboBox* _tmp197_;
	GtkCellRendererText* _tmp198_;
	GSettings* _tmp199_;
	gint _tmp200_ = 0;
	GtkCellRendererText* _tmp201_;
	GtkComboBox* _tmp202_;
	GtkCellRendererText* _tmp203_;
	GtkComboBox* _tmp204_;
	GtkCellRendererText* _tmp205_;
	GSettings* _tmp206_;
	gint _tmp207_ = 0;
	gint paper_width;
	GSettings* _tmp208_;
	gint _tmp209_ = 0;
	gint paper_height;
	gint _tmp210_;
	gint _tmp211_;
	GtkAdjustment* _tmp212_;
	gdouble _tmp213_ = 0.0;
	gdouble lower;
	const gchar* _tmp214_ = NULL;
	gchar* _tmp215_ = NULL;
	gchar* darker_label;
	GtkAdjustment* _tmp216_;
	gdouble _tmp217_ = 0.0;
	gdouble upper;
	const gchar* _tmp218_ = NULL;
	gchar* _tmp219_ = NULL;
	gchar* lighter_label;
	GtkScale* _tmp220_;
	gdouble _tmp221_;
	const gchar* _tmp222_;
	GtkScale* _tmp223_;
	GtkScale* _tmp224_;
	gdouble _tmp225_;
	const gchar* _tmp226_;
	GSettings* _tmp227_;
	gint _tmp228_ = 0;
	GtkAdjustment* _tmp229_;
	gdouble _tmp230_ = 0.0;
	const gchar* _tmp231_ = NULL;
	gchar* _tmp232_ = NULL;
	gchar* less_label;
	GtkAdjustment* _tmp233_;
	gdouble _tmp234_ = 0.0;
	const gchar* _tmp235_ = NULL;
	gchar* _tmp236_ = NULL;
	gchar* more_label;
	GtkScale* _tmp237_;
	gdouble _tmp238_;
	const gchar* _tmp239_;
	GtkScale* _tmp240_;
	GtkScale* _tmp241_;
	gdouble _tmp242_;
	const gchar* _tmp243_;
	GSettings* _tmp244_;
	gint _tmp245_ = 0;
	GtkAdjustment* _tmp246_;
	gdouble _tmp247_ = 0.0;
	const gchar* _tmp248_ = NULL;
	gchar* _tmp249_ = NULL;
	gchar* minimum_label;
	GtkAdjustment* _tmp250_;
	gdouble _tmp251_ = 0.0;
	const gchar* _tmp252_ = NULL;
	gchar* _tmp253_ = NULL;
	gchar* maximum_label;
	GtkScale* _tmp254_;
	gdouble _tmp255_;
	const gchar* _tmp256_;
	GtkScale* _tmp257_;
	GtkScale* _tmp258_;
	gdouble _tmp259_;
	const gchar* _tmp260_;
	GSettings* _tmp261_;
	gint _tmp262_ = 0;
	GSettings* _tmp263_;
	gchar* _tmp264_ = NULL;
	gchar* device;
	const gchar* _tmp265_;
	GSettings* _tmp271_;
	gchar* _tmp272_ = NULL;
	gchar* document_type;
	const gchar* _tmp273_;
	Book* _tmp275_;
	BookView* _tmp276_;
	BookView* _tmp277_;
	GtkVBox* _tmp278_;
	BookView* _tmp279_;
	BookView* _tmp280_;
	BookView* _tmp281_;
	BookView* _tmp282_;
	BookView* _tmp283_;
	GSettings* _tmp284_;
	gint _tmp285_ = 0;
	GSettings* _tmp286_;
	gint _tmp287_ = 0;
	gint _tmp288_;
	GSettings* _tmp289_;
	gint _tmp290_ = 0;
	gint _tmp291_;
	GSettings* _tmp292_;
	gint _tmp293_ = 0;
	gint _tmp294_;
	GSettings* _tmp295_;
	gint _tmp296_ = 0;
	gint _tmp297_;
	GSettings* _tmp298_;
	gint _tmp299_ = 0;
	gint _tmp300_;
	gint _tmp301_;
	gint _tmp302_;
	GtkWindow* _tmp303_;
	gint _tmp304_;
	gint _tmp305_;
	GSettings* _tmp306_;
	gboolean _tmp307_ = FALSE;
	gboolean _tmp308_;
	Book* _tmp310_;
	guint _tmp311_ = 0U;
	Book* _tmp312_;
	Book* _tmp313_;
	GtkWindow* _tmp314_;
	const gchar* _tmp315_ = NULL;
	ProgressBarDialog* _tmp316_;
	Book* _tmp317_;
	GError * _inner_error_ = NULL;
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = gtk_icon_theme_get_default ();
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_default_icon_name ("scanner");
#line 1324 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = gtk_builder_new ();
#line 1324 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 1324 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->builder = _tmp1_;
#line 6672 "ui.c"
	{
		GtkBuilder* _tmp2_;
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp2_ = self->priv->builder;
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_builder_add_from_resource (_tmp2_, "/org/gnome/SimpleScan/simple-scan.ui", &_inner_error_);
#line 1327 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 6681 "ui.c"
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = e;
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp4_ = _tmp3_->message;
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("ui.vala:1331: Unable to load UI: %s\n", _tmp4_);
#line 1332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = _ ("Files missing");
#line 1332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = _ ("Please check your installation");
#line 1332 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_show_error_dialog (self, _tmp5_, _tmp6_);
#line 1336 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		exit (EXIT_FAILURE);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 6713 "ui.c"
	}
	__finally21:
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1325 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return;
#line 6724 "ui.c"
	}
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = self->priv->builder;
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_builder_connect_signals (_tmp7_, self);
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = self->priv->builder;
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = gtk_builder_get_object (_tmp8_, "simple_scan_window");
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_WINDOW, GtkWindow));
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window = _tmp10_;
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = g_application_get_default ();
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_APPLICATION) ? ((GtkApplication*) _tmp11_) : NULL);
#line 1341 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	app = _tmp12_;
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = app;
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp14_ = self->priv->window;
#line 1342 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_application_add_window (_tmp13_, _tmp14_);
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp15_ = self->priv->builder;
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp16_ = gtk_builder_get_object (_tmp15_, "main_vbox");
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GTK_TYPE_VBOX, GtkVBox));
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->main_vbox = _tmp17_;
#line 1344 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp18_ = self->priv->builder;
#line 1344 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "page_move_left_menuitem");
#line 1344 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1344 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 1344 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_move_left_menuitem = _tmp20_;
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp21_ = self->priv->builder;
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "page_move_right_menuitem");
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_move_right_menuitem = _tmp23_;
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp24_ = self->priv->builder;
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp25_ = gtk_builder_get_object (_tmp24_, "page_delete_menuitem");
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_delete_menuitem = _tmp26_;
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp27_ = self->priv->builder;
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp28_ = gtk_builder_get_object (_tmp27_, "crop_rotate_menuitem");
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 1347 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->crop_rotate_menuitem = _tmp29_;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp30_ = self->priv->builder;
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "save_menuitem");
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 1348 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_menuitem = _tmp32_;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp33_ = self->priv->builder;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "save_as_menuitem");
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_as_menuitem = _tmp35_;
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp36_ = self->priv->builder;
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "copy_to_clipboard_menuitem");
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->copy_to_clipboard_menuitem = _tmp38_;
#line 1351 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp39_ = self->priv->builder;
#line 1351 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "save_toolbutton");
#line 1351 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1351 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 1351 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->save_toolbutton = _tmp41_;
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp42_ = self->priv->builder;
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "stop_scan_menuitem");
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->stop_menuitem = _tmp44_;
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp45_ = self->priv->builder;
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "stop_toolbutton");
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->stop_toolbutton = _tmp47_;
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp48_ = self->priv->builder;
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "text_toolbutton_menuitem");
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_toolbar_menuitem = _tmp50_;
#line 1356 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp51_ = self->priv->builder;
#line 1356 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "text_menuitem");
#line 1356 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1356 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 1356 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_menu_menuitem = _tmp53_;
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp54_ = self->priv->builder;
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "photo_toolbutton_menuitem");
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 1357 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_toolbar_menuitem = _tmp56_;
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp57_ = self->priv->builder;
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "photo_menuitem");
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_menu_menuitem = _tmp59_;
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp60_ = self->priv->builder;
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "authorize_dialog");
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GTK_TYPE_DIALOG, GtkDialog));
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 1360 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->authorize_dialog = _tmp62_;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp63_ = self->priv->builder;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "authorize_label");
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GTK_TYPE_LABEL, GtkLabel));
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->authorize_label = _tmp65_;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp66_ = self->priv->builder;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "username_entry");
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GTK_TYPE_ENTRY, GtkEntry));
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->username_entry = _tmp68_;
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp69_ = self->priv->builder;
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp70_ = gtk_builder_get_object (_tmp69_, "password_entry");
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, GTK_TYPE_ENTRY, GtkEntry));
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 1363 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->password_entry = _tmp71_;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp72_ = self->priv->builder;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp73_ = gtk_builder_get_object (_tmp72_, "preferences_dialog");
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GTK_TYPE_DIALOG, GtkDialog));
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->preferences_dialog = _tmp74_;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp75_ = self->priv->builder;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp76_ = gtk_builder_get_object (_tmp75_, "device_combo");
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->device_combo = _tmp77_;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp78_ = self->priv->device_combo;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp79_ = gtk_combo_box_get_model (_tmp78_);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->device_model = _tmp80_;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp81_ = self->priv->builder;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp82_ = gtk_builder_get_object (_tmp81_, "text_dpi_combo");
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_dpi_combo = _tmp83_;
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp84_ = self->priv->text_dpi_combo;
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp85_ = gtk_combo_box_get_model (_tmp84_);
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->text_dpi_model = _tmp86_;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp87_ = self->priv->builder;
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp88_ = gtk_builder_get_object (_tmp87_, "photo_dpi_combo");
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp89_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 1370 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_dpi_combo = _tmp89_;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp90_ = self->priv->photo_dpi_combo;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp91_ = gtk_combo_box_get_model (_tmp90_);
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->photo_dpi_model = _tmp92_;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp93_ = self->priv->builder;
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp94_ = gtk_builder_get_object (_tmp93_, "page_side_combo");
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 1372 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_side_combo = _tmp95_;
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp96_ = self->priv->page_side_combo;
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp97_ = gtk_combo_box_get_model (_tmp96_);
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 1373 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->page_side_model = _tmp98_;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp99_ = self->priv->builder;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp100_ = gtk_builder_get_object (_tmp99_, "paper_size_combo");
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->paper_size_combo = _tmp101_;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp102_ = self->priv->paper_size_combo;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp103_ = gtk_combo_box_get_model (_tmp102_);
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp104_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->paper_size_model = _tmp104_;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp105_ = self->priv->builder;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp106_ = gtk_builder_get_object (_tmp105_, "brightness_scale");
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, GTK_TYPE_SCALE, GtkScale));
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->brightness_scale = _tmp107_;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp108_ = self->priv->brightness_scale;
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp109_ = gtk_range_get_adjustment ((GtkRange*) _tmp108_);
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 1377 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->brightness_adjustment = _tmp110_;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp111_ = self->priv->builder;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp112_ = gtk_builder_get_object (_tmp111_, "contrast_scale");
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GTK_TYPE_SCALE, GtkScale));
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->contrast_scale = _tmp113_;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp114_ = self->priv->contrast_scale;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp115_ = gtk_range_get_adjustment ((GtkRange*) _tmp114_);
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->contrast_adjustment = _tmp116_;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp117_ = self->priv->builder;
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp118_ = gtk_builder_get_object (_tmp117_, "quality_scale");
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp119_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, GTK_TYPE_SCALE, GtkScale));
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->quality_scale = _tmp119_;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp120_ = self->priv->quality_scale;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp121_ = gtk_range_get_adjustment ((GtkRange*) _tmp120_);
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->quality_adjustment = _tmp122_;
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp123_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp123_);
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar = _tmp123_;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp124_ = self->priv->info_bar;
#line 1385 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp124_, "response", (GCallback) _user_interface_info_bar_response_cb_gtk_info_bar_response, self);
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp125_ = self->priv->main_vbox;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp126_ = self->priv->info_bar;
#line 1386 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start ((GtkBox*) _tmp125_, (GtkWidget*) _tmp126_, FALSE, TRUE, (guint) 0);
#line 1387 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp127_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 1387 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp127_);
#line 1387 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	hbox = _tmp127_;
#line 1388 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp128_ = self->priv->info_bar;
#line 1388 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp129_ = gtk_info_bar_get_content_area (_tmp128_);
#line 1388 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, GTK_TYPE_CONTAINER, GtkContainer));
#line 1388 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	content_area = _tmp130_;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp131_ = content_area;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp132_ = hbox;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add (_tmp131_, (GtkWidget*) _tmp132_);
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp133_ = hbox;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp133_);
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp134_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp134_);
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_image = _tmp134_;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp135_ = hbox;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp136_ = self->priv->info_bar_image;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp135_, (GtkWidget*) _tmp136_, FALSE, TRUE, (guint) 0);
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp137_ = self->priv->info_bar_image;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp137_);
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp138_ = (GtkLabel*) gtk_label_new (NULL);
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp138_);
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 1396 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_label = _tmp138_;
#line 1397 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp139_ = self->priv->info_bar_label;
#line 1397 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp139_, 0.0f, 0.5f);
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp140_ = hbox;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp141_ = self->priv->info_bar_label;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, TRUE, TRUE, (guint) 0);
#line 1399 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp142_ = self->priv->info_bar_label;
#line 1399 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp142_);
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp143_ = self->priv->info_bar;
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp144_ = gtk_info_bar_add_button (_tmp143_, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp145_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, GTK_TYPE_BUTTON, GtkButton));
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 1401 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_close_button = _tmp145_;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp146_ = self->priv->info_bar;
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp147_ = _ ("Change _Scanner");
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp148_ = gtk_info_bar_add_button (_tmp146_, _tmp147_, 1);
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp149_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, GTK_TYPE_BUTTON, GtkButton));
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 1402 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->info_bar_change_scanner_button = _tmp149_;
#line 1406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp150_ = self->priv->paper_size_model;
#line 1406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp150_, &_tmp151_);
#line 1406 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp151_;
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp152_ = self->priv->paper_size_model;
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp153_ = iter;
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp154_ = _ ("Automatic");
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp152_, &_tmp153_, 0, 0, 1, 0, 2, _tmp154_, -1, -1);
#line 1410 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp155_ = self->priv->paper_size_model;
#line 1410 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp155_, &_tmp156_);
#line 1410 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp156_;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp157_ = self->priv->paper_size_model;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp158_ = iter;
#line 1411 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp157_, &_tmp158_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp159_ = self->priv->paper_size_model;
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp159_, &_tmp160_);
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp160_;
#line 1413 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp161_ = self->priv->paper_size_model;
#line 1413 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp162_ = iter;
#line 1413 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp161_, &_tmp162_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
#line 1414 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp163_ = self->priv->paper_size_model;
#line 1414 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp163_, &_tmp164_);
#line 1414 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp164_;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp165_ = self->priv->paper_size_model;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp166_ = iter;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp165_, &_tmp166_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp167_ = self->priv->paper_size_model;
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp167_, &_tmp168_);
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp168_;
#line 1417 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp169_ = self->priv->paper_size_model;
#line 1417 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp170_ = iter;
#line 1417 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp169_, &_tmp170_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
#line 1418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp171_ = self->priv->paper_size_model;
#line 1418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp171_, &_tmp172_);
#line 1418 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp172_;
#line 1419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp173_ = self->priv->paper_size_model;
#line 1419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp174_ = iter;
#line 1419 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp173_, &_tmp174_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
#line 1420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp175_ = self->priv->paper_size_model;
#line 1420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_append (_tmp175_, &_tmp176_);
#line 1420 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	iter = _tmp176_;
#line 1421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp177_ = self->priv->paper_size_model;
#line 1421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp178_ = iter;
#line 1421 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_list_store_set (_tmp177_, &_tmp178_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp179_ = self->priv->settings;
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp180_ = g_settings_get_int (_tmp179_, "text-dpi");
#line 1423 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = _tmp180_;
#line 1424 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp181_ = dpi;
#line 1424 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp181_ <= 0) {
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
#line 7314 "ui.c"
	}
#line 1426 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp182_ = self->priv->text_dpi_combo;
#line 1426 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp183_ = dpi;
#line 1426 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp182_, USER_INTERFACE_DEFAULT_TEXT_DPI, _tmp183_);
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp184_ = self->priv->settings;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp185_ = g_settings_get_int (_tmp184_, "photo-dpi");
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	dpi = _tmp185_;
#line 1428 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp186_ = dpi;
#line 1428 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp186_ <= 0) {
#line 1429 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
#line 7334 "ui.c"
	}
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp187_ = self->priv->photo_dpi_combo;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp188_ = dpi;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_dpi_combo (self, _tmp187_, USER_INTERFACE_DEFAULT_PHOTO_DPI, _tmp188_);
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp189_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp189_);
#line 1432 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp189_;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp190_ = self->priv->device_combo;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp191_ = renderer;
#line 1433 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp190_, (GtkCellRenderer*) _tmp191_, TRUE);
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp192_ = self->priv->device_combo;
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp193_ = renderer;
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp192_, (GtkCellRenderer*) _tmp193_, "text", 1);
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp194_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp194_);
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1436 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp194_;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp195_ = self->priv->page_side_combo;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp196_ = renderer;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp195_, (GtkCellRenderer*) _tmp196_, TRUE);
#line 1438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp197_ = self->priv->page_side_combo;
#line 1438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp198_ = renderer;
#line 1438 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp197_, (GtkCellRenderer*) _tmp198_, "text", 1);
#line 1439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp199_ = self->priv->settings;
#line 1439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp200_ = g_settings_get_enum (_tmp199_, "page-side");
#line 1439 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_page_side (self, (ScanType) _tmp200_);
#line 1441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp201_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 1441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp201_);
#line 1441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1441 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	renderer = _tmp201_;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp202_ = self->priv->paper_size_combo;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp203_ = renderer;
#line 1442 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp202_, (GtkCellRenderer*) _tmp203_, TRUE);
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp204_ = self->priv->paper_size_combo;
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp205_ = renderer;
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp204_, (GtkCellRenderer*) _tmp205_, "text", 2);
#line 1444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp206_ = self->priv->settings;
#line 1444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp207_ = g_settings_get_int (_tmp206_, "paper-width");
#line 1444 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_width = _tmp207_;
#line 1445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp208_ = self->priv->settings;
#line 1445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp209_ = g_settings_get_int (_tmp208_, "paper-height");
#line 1445 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	paper_height = _tmp209_;
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp210_ = paper_width;
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp211_ = paper_height;
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_paper_size (self, _tmp210_, _tmp211_);
#line 1448 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp212_ = self->priv->brightness_adjustment;
#line 1448 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp213_ = gtk_adjustment_get_lower (_tmp212_);
#line 1448 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp213_;
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp214_ = _ ("Darker");
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp215_ = g_strdup_printf ("<small>%s</small>", _tmp214_);
#line 1449 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	darker_label = _tmp215_;
#line 1450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp216_ = self->priv->brightness_adjustment;
#line 1450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp217_ = gtk_adjustment_get_upper (_tmp216_);
#line 1450 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp217_;
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp218_ = _ ("Lighter");
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp219_ = g_strdup_printf ("<small>%s</small>", _tmp218_);
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lighter_label = _tmp219_;
#line 1452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp220_ = self->priv->brightness_scale;
#line 1452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp221_ = lower;
#line 1452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp222_ = darker_label;
#line 1452 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp220_, _tmp221_, GTK_POS_BOTTOM, _tmp222_);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp223_ = self->priv->brightness_scale;
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp223_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp224_ = self->priv->brightness_scale;
#line 1454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp225_ = upper;
#line 1454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp226_ = lighter_label;
#line 1454 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp224_, _tmp225_, GTK_POS_BOTTOM, _tmp226_);
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp227_ = self->priv->settings;
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp228_ = g_settings_get_int (_tmp227_, "brightness");
#line 1455 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_brightness (self, _tmp228_);
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp229_ = self->priv->contrast_adjustment;
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp230_ = gtk_adjustment_get_lower (_tmp229_);
#line 1457 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp230_;
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp231_ = _ ("Less");
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp232_ = g_strdup_printf ("<small>%s</small>", _tmp231_);
#line 1458 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	less_label = _tmp232_;
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp233_ = self->priv->contrast_adjustment;
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp234_ = gtk_adjustment_get_upper (_tmp233_);
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp234_;
#line 1460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp235_ = _ ("More");
#line 1460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp236_ = g_strdup_printf ("<small>%s</small>", _tmp235_);
#line 1460 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	more_label = _tmp236_;
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp237_ = self->priv->contrast_scale;
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp238_ = lower;
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp239_ = less_label;
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp237_, _tmp238_, GTK_POS_BOTTOM, _tmp239_);
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp240_ = self->priv->contrast_scale;
#line 1462 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp240_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp241_ = self->priv->contrast_scale;
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp242_ = upper;
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp243_ = more_label;
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp241_, _tmp242_, GTK_POS_BOTTOM, _tmp243_);
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp244_ = self->priv->settings;
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp245_ = g_settings_get_int (_tmp244_, "contrast");
#line 1464 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_contrast (self, _tmp245_);
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp246_ = self->priv->quality_adjustment;
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp247_ = gtk_adjustment_get_lower (_tmp246_);
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	lower = _tmp247_;
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp248_ = _ ("Minimum");
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp249_ = g_strdup_printf ("<small>%s</small>", _tmp248_);
#line 1467 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	minimum_label = _tmp249_;
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp250_ = self->priv->quality_adjustment;
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp251_ = gtk_adjustment_get_upper (_tmp250_);
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	upper = _tmp251_;
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp252_ = _ ("Maximum");
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp253_ = g_strdup_printf ("<small>%s</small>", _tmp252_);
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	maximum_label = _tmp253_;
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp254_ = self->priv->quality_scale;
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp255_ = lower;
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp256_ = minimum_label;
#line 1470 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp254_, _tmp255_, GTK_POS_BOTTOM, _tmp256_);
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp257_ = self->priv->quality_scale;
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp257_, (gdouble) 75, GTK_POS_BOTTOM, NULL);
#line 1472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp258_ = self->priv->quality_scale;
#line 1472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp259_ = upper;
#line 1472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp260_ = maximum_label;
#line 1472 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_scale_add_mark (_tmp258_, _tmp259_, GTK_POS_BOTTOM, _tmp260_);
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp261_ = self->priv->settings;
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp262_ = g_settings_get_int (_tmp261_, "jpeg-quality");
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_set_quality (self, _tmp262_);
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp263_ = self->priv->settings;
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp264_ = g_settings_get_string (_tmp263_, "selected-device");
#line 1475 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	device = _tmp264_;
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp265_ = device;
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp265_ != NULL) {
#line 7584 "ui.c"
		const gchar* _tmp266_;
		GtkTreeIter _tmp267_ = {0};
		gboolean _tmp268_ = FALSE;
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp266_ = device;
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp268_ = user_interface_find_scan_device (self, _tmp266_, &_tmp267_);
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		iter = _tmp267_;
#line 1478 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_tmp268_) {
#line 7596 "ui.c"
			GtkComboBox* _tmp269_;
			GtkTreeIter _tmp270_;
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp269_ = self->priv->device_combo;
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			_tmp270_ = iter;
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			gtk_combo_box_set_active_iter (_tmp269_, &_tmp270_);
#line 7605 "ui.c"
		}
	}
#line 1482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp271_ = self->priv->settings;
#line 1482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp272_ = g_settings_get_string (_tmp271_, "document-type");
#line 1482 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	document_type = _tmp272_;
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp273_ = document_type;
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp273_ != NULL) {
#line 7618 "ui.c"
		const gchar* _tmp274_;
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp274_ = document_type;
#line 1484 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_set_document_hint (self, _tmp274_);
#line 7624 "ui.c"
	}
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp275_ = self->priv->book;
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp276_ = book_view_new (_tmp275_);
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp276_);
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_view = _tmp276_;
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp277_ = self->priv->book_view;
#line 1487 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp277_, (guint) 18);
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp278_ = self->priv->main_vbox;
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp279_ = self->priv->book_view;
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_end ((GtkBox*) _tmp278_, (GtkWidget*) _tmp279_, TRUE, TRUE, (guint) 0);
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp280_ = self->priv->book_view;
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp280_, "page-selected", (GCallback) _user_interface_page_selected_cb_book_view_page_selected, self);
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp281_ = self->priv->book_view;
#line 1490 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp281_, "show-page", (GCallback) _user_interface_show_page_cb_book_view_show_page, self);
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp282_ = self->priv->book_view;
#line 1491 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp282_, "show-menu", (GCallback) _user_interface_show_page_menu_cb_book_view_show_menu, self);
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp283_ = self->priv->book_view;
#line 1492 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp283_);
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp284_ = self->priv->settings;
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp285_ = g_settings_get_enum (_tmp284_, "scan-direction");
#line 1495 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_scan_direction = (ScanDirection) _tmp285_;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp286_ = self->priv->settings;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp287_ = g_settings_get_int (_tmp286_, "page-width");
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_width = _tmp287_;
#line 1497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp288_ = self->priv->default_page_width;
#line 1497 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp288_ <= 0) {
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->default_page_width = 595;
#line 7680 "ui.c"
	}
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp289_ = self->priv->settings;
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp290_ = g_settings_get_int (_tmp289_, "page-height");
#line 1499 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_height = _tmp290_;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp291_ = self->priv->default_page_height;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp291_ <= 0) {
#line 1501 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->default_page_height = 842;
#line 7694 "ui.c"
	}
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp292_ = self->priv->settings;
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp293_ = g_settings_get_int (_tmp292_, "page-dpi");
#line 1502 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_page_dpi = _tmp293_;
#line 1503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp294_ = self->priv->default_page_dpi;
#line 1503 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp294_ <= 0) {
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->default_page_dpi = 72;
#line 7708 "ui.c"
	}
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp295_ = self->priv->settings;
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp296_ = g_settings_get_int (_tmp295_, "window-width");
#line 1507 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_width = _tmp296_;
#line 1508 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp297_ = self->priv->window_width;
#line 1508 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp297_ <= 0) {
#line 1509 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_width = 600;
#line 7722 "ui.c"
	}
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp298_ = self->priv->settings;
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp299_ = g_settings_get_int (_tmp298_, "window-height");
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_height = _tmp299_;
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp300_ = self->priv->window_height;
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp300_ <= 0) {
#line 1512 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		self->priv->window_height = 400;
#line 7736 "ui.c"
	}
#line 1513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp301_ = self->priv->window_width;
#line 1513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp302_ = self->priv->window_height;
#line 1513 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_debug ("ui.vala:1513: Restoring window to %dx%d pixels", _tmp301_, _tmp302_);
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp303_ = self->priv->window;
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp304_ = self->priv->window_width;
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp305_ = self->priv->window_height;
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_default_size (_tmp303_, _tmp304_, _tmp305_);
#line 1515 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp306_ = self->priv->settings;
#line 1515 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp307_ = g_settings_get_boolean (_tmp306_, "window-is-maximized");
#line 1515 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->window_is_maximized = _tmp307_;
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp308_ = self->priv->window_is_maximized;
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp308_) {
#line 7762 "ui.c"
		GtkWindow* _tmp309_;
#line 1518 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_debug ("ui.vala:1518: Restoring window to maximized");
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp309_ = self->priv->window;
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_window_maximize (_tmp309_);
#line 7770 "ui.c"
	}
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp310_ = self->priv->book;
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp311_ = book_get_n_pages (_tmp310_);
#line 1522 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp311_ == ((guint) 0)) {
#line 1523 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_add_default_page (self);
#line 7780 "ui.c"
	}
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp312_ = self->priv->book;
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_set_needs_saving (_tmp312_, FALSE);
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp313_ = self->priv->book;
#line 1525 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp313_, "needs-saving-changed", (GCallback) _user_interface_needs_saving_cb_book_needs_saving_changed, self);
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp314_ = self->priv->window;
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp315_ = _ ("Saving document...");
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp316_ = progress_bar_dialog_new (_tmp314_, _tmp315_);
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp316_);
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 1527 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->progress_dialog = _tmp316_;
#line 1528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp317_ = self->priv->book;
#line 1528 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_connect (_tmp317_, "saving", (GCallback) _user_interface_book_saving_cb_book_saving, self);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (document_type);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (device);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (maximum_label);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (minimum_label);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (more_label);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (less_label);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (lighter_label);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (darker_label);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (renderer);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (content_area);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1318 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (app);
#line 7830 "ui.c"
}


static gboolean ___lambda3_ (UserInterface* self) {
	gboolean result = FALSE;
	ProgressBarDialog* _tmp0_;
#line 1542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1542 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = FALSE;
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7845 "ui.c"
}


static gboolean ____lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda3_ (self);
#line 1541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7854 "ui.c"
}


static void user_interface_book_saving_cb (UserInterface* self, gint page_number) {
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	gint total;
	gint _tmp3_;
	gint _tmp4_;
	gdouble fraction;
	gdouble _tmp5_;
	gboolean complete;
	gboolean _tmp6_;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* message;
	ProgressBarDialog* _tmp11_;
	gdouble _tmp12_;
	ProgressBarDialog* _tmp13_;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	while (TRUE) {
#line 7880 "ui.c"
		gboolean _tmp0_ = FALSE;
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp0_ = gtk_events_pending ();
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (!_tmp0_) {
#line 1534 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			break;
#line 7888 "ui.c"
		}
#line 1535 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		gtk_main_iteration ();
#line 7892 "ui.c"
	}
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->book;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	total = (gint) _tmp2_;
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = page_number;
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = total;
#line 1538 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	fraction = (_tmp3_ + 1.0) / _tmp4_;
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = fraction;
#line 1539 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	complete = _tmp5_ == 1.0;
#line 1540 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = complete;
#line 1540 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_tmp6_) {
#line 1541 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda3__gsource_func, user_interface_ref (self), user_interface_unref);
#line 7916 "ui.c"
	}
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = _ ("Saving page %d out of %d");
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = page_number;
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = total;
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp10_ = g_strdup_printf (_tmp7_, _tmp8_ + 1, _tmp9_);
#line 1545 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	message = _tmp10_;
#line 1547 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp11_ = self->priv->progress_dialog;
#line 1547 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp12_ = fraction;
#line 1547 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_set_fraction (_tmp11_, _tmp12_);
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp13_ = self->priv->progress_dialog;
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_set_message (_tmp13_, message);
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (message);
#line 7940 "ui.c"
}


void user_interface_show_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_;
#line 1551 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1553 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 7952 "ui.c"
}


void user_interface_hide_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_;
#line 1556 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 7964 "ui.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self ? book_ref (self) : NULL;
#line 7971 "ui.c"
}


Book* user_interface_get_book (UserInterface* self) {
	Book* result = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _book_ref0 (_tmp0_);
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp1_;
#line 1563 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 7989 "ui.c"
}


void user_interface_set_selected_page (UserInterface* self, Page* page) {
	BookView* _tmp0_;
	Page* _tmp1_;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (page != NULL);
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = page;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	book_view_select_page (_tmp0_, _tmp1_);
#line 8006 "ui.c"
}


Page* user_interface_get_selected_page (UserInterface* self) {
	Page* result = NULL;
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book_view;
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = book_view_get_selected (_tmp0_);
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = _tmp1_;
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 8024 "ui.c"
}


void user_interface_set_scanning (UserInterface* self, gboolean scanning) {
	gboolean _tmp0_;
	GtkMenuItem* _tmp1_;
	gboolean _tmp2_;
	GtkMenuItem* _tmp3_;
	gboolean _tmp4_;
	GtkToolButton* _tmp5_;
	gboolean _tmp6_;
#line 1576 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = scanning;
#line 1578 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->scanning = _tmp0_;
#line 1579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = self->priv->page_delete_menuitem;
#line 1579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = scanning;
#line 1579 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
#line 1580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->stop_menuitem;
#line 1580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = scanning;
#line 1580 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->stop_toolbutton;
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = scanning;
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
#line 8060 "ui.c"
}


void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_title != NULL);
#line 1584 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (error_text != NULL);
#line 1586 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->have_error = TRUE;
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = error_title;
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_title = _tmp1_;
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = error_text;
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 1588 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_text = _tmp3_;
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = change_scanner_hint;
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->error_change_scanner_hint = _tmp4_;
#line 1590 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_update_info_bar (self);
#line 8100 "ui.c"
}


void user_interface_start (UserInterface* self) {
	GtkWindow* _tmp0_;
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1595 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->window;
#line 1595 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 8112 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 8131 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = closure->data;
#line 8137 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
#line 8143 "ui.c"
}


static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = param_values->data[0].v_pointer;
#line 8162 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		data2 = closure->data;
#line 8168 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 8174 "ui.c"
}


static void value_user_interface_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	value->data[0].v_pointer = NULL;
#line 8181 "ui.c"
}


static void value_user_interface_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_unref (value->data[0].v_pointer);
#line 8190 "ui.c"
	}
}


static void value_user_interface_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dest_value->data[0].v_pointer = user_interface_ref (src_value->data[0].v_pointer);
#line 8200 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8204 "ui.c"
	}
}


static gpointer value_user_interface_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return value->data[0].v_pointer;
#line 8212 "ui.c"
}


static gchar* value_user_interface_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (collect_values[0].v_pointer) {
#line 8219 "ui.c"
		UserInterface* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8226 "ui.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8230 "ui.c"
		}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = user_interface_ref (object);
#line 8234 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 8238 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return NULL;
#line 8242 "ui.c"
}


static gchar* value_user_interface_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UserInterface** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8253 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*object_p = NULL;
#line 8259 "ui.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*object_p = value->data[0].v_pointer;
#line 8263 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		*object_p = user_interface_ref (value->data[0].v_pointer);
#line 8267 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return NULL;
#line 8271 "ui.c"
}


GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUserInterface* spec;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return G_PARAM_SPEC (spec);
#line 8285 "ui.c"
}


gpointer value_get_user_interface (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return value->data[0].v_pointer;
#line 8294 "ui.c"
}


void value_set_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_ref (value->data[0].v_pointer);
#line 8314 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 8318 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_unref (old);
#line 8324 "ui.c"
	}
}


void value_take_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = v_object;
#line 8343 "ui.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		value->data[0].v_pointer = NULL;
#line 8347 "ui.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		user_interface_unref (old);
#line 8353 "ui.c"
	}
}


static void user_interface_class_init (UserInterfaceClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	user_interface_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	USER_INTERFACE_CLASS (klass)->finalize = user_interface_finalize;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_type_class_add_private (klass, sizeof (UserInterfacePrivate));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("start_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("stop_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_new ("email", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
#line 8371 "ui.c"
}


static void user_interface_instance_init (UserInterface * self) {
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv = USER_INTERFACE_GET_PRIVATE (self);
#line 78 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->book_uri = NULL;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = g_strdup ("photo");
#line 89 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->document_hint = _tmp0_;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = _ ("Scanned Document.pdf");
#line 91 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->default_file_name = _tmp2_;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->scanning = FALSE;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->ref_count = 1;
#line 8397 "ui.c"
}


static void user_interface_finalize (UserInterface* obj) {
	UserInterface * self;
	Book* _tmp0_;
	guint _tmp1_ = 0U;
	Book* _tmp2_;
	guint _tmp3_ = 0U;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INTERFACE, UserInterface);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->book;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp1_, NULL, FALSE);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = self->priv->book;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp3_, NULL, FALSE);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_added_cb_book_page_added, self);
#line 17 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->settings);
#line 19 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->builder);
#line 21 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->window);
#line 22 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 23 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 24 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_image);
#line 25 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 26 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_close_button);
#line 27 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
#line 28 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_left_menuitem);
#line 29 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_move_right_menuitem);
#line 30 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_delete_menuitem);
#line 31 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_menuitem);
#line 33 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_as_menuitem);
#line 34 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->copy_to_clipboard_menuitem);
#line 35 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_toolbutton);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_menuitem);
#line 37 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->stop_toolbutton);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_menu_menuitem);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
#line 42 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_menu_menuitem);
#line 44 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_dialog);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->authorize_label);
#line 46 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->username_entry);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->password_entry);
#line 49 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 50 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_combo);
#line 51 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_combo);
#line 52 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_combo);
#line 53 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_combo);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_combo);
#line 55 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_scale);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_scale);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_scale);
#line 58 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->device_model);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->text_dpi_model);
#line 60 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->photo_dpi_model);
#line 61 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->page_side_model);
#line 62 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->paper_size_model);
#line 63 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->brightness_adjustment);
#line 64 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->contrast_adjustment);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->quality_adjustment);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 70 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_title);
#line 74 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->error_text);
#line 77 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_book_unref0 (self->priv->book);
#line 78 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->book_uri);
#line 80 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_autosave_manager_unref0 (self->priv->autosave_manager);
#line 82 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->book_view);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->document_hint);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (self->priv->default_file_name);
#line 8529 "ui.c"
}


GType user_interface_get_type (void) {
	static volatile gsize user_interface_type_id__volatile = 0;
	if (g_once_init_enter (&user_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_user_interface_init, value_user_interface_free_value, value_user_interface_copy_value, value_user_interface_peek_pointer, "p", value_user_interface_collect_value, "p", value_user_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UserInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserInterface), 0, (GInstanceInitFunc) user_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType user_interface_type_id;
		user_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UserInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&user_interface_type_id__volatile, user_interface_type_id);
	}
	return user_interface_type_id__volatile;
}


gpointer user_interface_ref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return instance;
#line 8554 "ui.c"
}


void user_interface_unref (gpointer instance) {
	UserInterface* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		USER_INTERFACE_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8567 "ui.c"
	}
}


ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkWindow* parent, const gchar* title) {
	ProgressBarDialog * self = NULL;
	GtkProgressBar* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* hbox;
	GtkBox* _tmp2_;
	GtkBox* vbox;
	GtkProgressBar* _tmp3_;
	GtkProgressBar* _tmp4_;
	GtkProgressBar* _tmp5_;
	GtkProgressBar* _tmp6_;
	const gchar* _tmp7_;
	GtkWindow* _tmp8_;
	GtkProgressBar* _tmp9_;
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = (ProgressBarDialog*) g_object_new (object_type, NULL);
#line 1605 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 1605 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp0_);
#line 1605 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1605 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv->bar = _tmp0_;
#line 1606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
#line 1606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp1_);
#line 1606 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	hbox = _tmp1_;
#line 1607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
#line 1607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_object_ref_sink (_tmp2_);
#line 1607 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	vbox = _tmp2_;
#line 1608 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_hexpand ((GtkWidget*) hbox, TRUE);
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp3_ = self->priv->bar;
#line 1610 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_text (_tmp3_, "");
#line 1611 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp4_ = self->priv->bar;
#line 1611 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
#line 1612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp5_ = self->priv->bar;
#line 1612 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 225, 25);
#line 1613 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 50);
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp6_ = self->priv->bar;
#line 1615 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp6_, TRUE, FALSE, (guint) 0);
#line 1616 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, FALSE, (guint) 0);
#line 1617 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
#line 1618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp7_ = title;
#line 1618 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp7_);
#line 1620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp8_ = parent;
#line 1620 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp8_);
#line 1621 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ON_PARENT);
#line 1622 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 1623 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 1625 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) hbox);
#line 1626 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 1627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp9_ = self->priv->bar;
#line 1627 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_widget_show ((GtkWidget*) _tmp9_);
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (vbox);
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (hbox);
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return self;
#line 8664 "ui.c"
}


ProgressBarDialog* progress_bar_dialog_new (GtkWindow* parent, const gchar* title) {
#line 1603 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return progress_bar_dialog_construct (TYPE_PROGRESS_BAR_DIALOG, parent, title);
#line 8671 "ui.c"
}


void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent) {
	GtkProgressBar* _tmp0_;
	gdouble _tmp1_;
#line 1630 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1632 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1632 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = percent;
#line 1632 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_fraction (_tmp0_, _tmp1_);
#line 8686 "ui.c"
}


void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message) {
	GtkProgressBar* _tmp0_;
	const gchar* _tmp1_;
#line 1635 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (self != NULL);
#line 1635 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_if_fail (message != NULL);
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = self->priv->bar;
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = message;
#line 1637 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	gtk_progress_bar_set_text (_tmp0_, _tmp1_);
#line 8703 "ui.c"
}


static void progress_bar_dialog_class_init (ProgressBarDialogClass * klass) {
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	progress_bar_dialog_parent_class = g_type_class_peek_parent (klass);
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_type_class_add_private (klass, sizeof (ProgressBarDialogPrivate));
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (klass)->finalize = progress_bar_dialog_finalize;
#line 8714 "ui.c"
}


static void progress_bar_dialog_instance_init (ProgressBarDialog * self) {
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self->priv = PROGRESS_BAR_DIALOG_GET_PRIVATE (self);
#line 8721 "ui.c"
}


static void progress_bar_dialog_finalize (GObject* obj) {
	ProgressBarDialog * self;
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
#line 1601 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_object_unref0 (self->priv->bar);
#line 1599 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	G_OBJECT_CLASS (progress_bar_dialog_parent_class)->finalize (obj);
#line 8733 "ui.c"
}


GType progress_bar_dialog_get_type (void) {
	static volatile gsize progress_bar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&progress_bar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProgressBarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) progress_bar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgressBarDialog), 0, (GInstanceInitFunc) progress_bar_dialog_instance_init, NULL };
		GType progress_bar_dialog_type_id;
		progress_bar_dialog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "ProgressBarDialog", &g_define_type_info, 0);
		g_once_init_leave (&progress_bar_dialog_type_id__volatile, progress_bar_dialog_type_id);
	}
	return progress_bar_dialog_type_id__volatile;
}


gchar* get_temporary_filename (const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 1642 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 1642 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 1647 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp0_ = prefix;
#line 1647 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp1_ = extension;
#line 1647 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 1647 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	filename = _tmp2_;
#line 8769 "ui.c"
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint fd;
		gint _tmp6_;
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp3_ = filename;
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		path = _tmp4_;
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		fd = _tmp5_;
#line 1651 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		if (_inner_error_ != NULL) {
#line 8788 "ui.c"
			goto __catch22_g_error;
		}
#line 1652 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp6_ = fd;
#line 1652 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		close (_tmp6_);
#line 8795 "ui.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		e = _inner_error_;
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_inner_error_ = NULL;
#line 1656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp7_ = e;
#line 1656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_tmp8_ = _tmp7_->message;
#line 1656 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_warning ("ui.vala:1656: Error saving email attachment: %s", _tmp8_);
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		result = NULL;
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_error_free0 (e);
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 1657 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return result;
#line 8823 "ui.c"
	}
	__finally22:
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	if (_inner_error_ != NULL) {
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (path);
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		_g_free0 (filename);
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		g_clear_error (&_inner_error_);
#line 1649 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
		return NULL;
#line 8838 "ui.c"
	}
#line 1660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	result = path;
#line 1660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	_g_free0 (filename);
#line 1660 "/home/bob/bzr/simple-scan/trunk/src/ui.vala"
	return result;
#line 8846 "ui.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



