/* ui.c generated by valac 0.18.1, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;
typedef struct _UserInterfacePrivate UserInterfacePrivate;

#define TYPE_PROGRESS_BAR_DIALOG (progress_bar_dialog_get_type ())
#define PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog))
#define PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))
#define IS_PROGRESS_BAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_BAR_DIALOG))
#define IS_PROGRESS_BAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_BAR_DIALOG))
#define PROGRESS_BAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogClass))

typedef struct _ProgressBarDialog ProgressBarDialog;
typedef struct _ProgressBarDialogClass ProgressBarDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ParamSpecUserInterface ParamSpecUserInterface;
typedef struct _ProgressBarDialogPrivate ProgressBarDialogPrivate;

struct _UserInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UserInterfacePrivate * priv;
};

struct _UserInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (UserInterface *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _UserInterfacePrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkWindow* window;
	GtkVBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	ProgressBarDialog* progress_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* book;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* default_file_name;
	gboolean scanning;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecUserInterface {
	GParamSpec parent_instance;
};

struct _ProgressBarDialog {
	GtkWindow parent_instance;
	ProgressBarDialogPrivate * priv;
};

struct _ProgressBarDialogClass {
	GtkWindowClass parent_class;
};

struct _ProgressBarDialogPrivate {
	GtkProgressBar* bar;
};


static gpointer user_interface_parent_class = NULL;
static gpointer progress_bar_dialog_parent_class = NULL;

gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
GType progress_bar_dialog_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define USER_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_INTERFACE, UserInterfacePrivate))
enum  {
	USER_INTERFACE_DUMMY_PROPERTY
};
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page);
static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
#define USER_INTERFACE_DEFAULT_TEXT_DPI 150
#define USER_INTERFACE_DEFAULT_PHOTO_DPI 300
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
static void user_interface_load (UserInterface* self);
AutosaveManager* autosave_manager_create (Book** book);
static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter);
static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text);
void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_update_info_bar (UserInterface* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
static gchar* user_interface_get_selected_device (UserInterface* self);
void user_interface_set_selected_device (UserInterface* self, const gchar* device);
static void user_interface_add_default_page (UserInterface* self);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_view_select_page (BookView* self, Page* page);
static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection);
static gchar* user_interface_choose_file_location (UserInterface* self);
static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void user_interface_hide_progress_dialog (UserInterface* self);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void book_set_needs_saving (Book* self, gboolean needs_saving);
static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void user_interface_clear_document (UserInterface* self);
void book_clear (Book* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void user_interface_set_page_side (UserInterface* self, ScanType page_side);
static void user_interface_set_paper_size (UserInterface* self, gint width, gint height);
static void user_interface_set_brightness (UserInterface* self, gint brightness);
static void user_interface_set_contrast (UserInterface* self, gint contrast);
static gint user_interface_get_text_dpi (UserInterface* self);
static gint user_interface_get_photo_dpi (UserInterface* self);
static ScanType user_interface_get_page_side (UserInterface* self);
static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height);
static gint user_interface_get_brightness (UserInterface* self);
static gint user_interface_get_contrast (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* user_interface_get_scan_options (UserInterface* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self);
static void user_interface_update_page_menu (UserInterface* self);
Page* book_view_get_selected (BookView* self);
guint book_get_page_index (Book* self, Page* page);
guint book_get_n_pages (Book* self);
static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page);
gchar* get_temporary_filename (const gchar* prefix, const gchar* extension);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_right (Page* self);
static void user_interface_set_crop (UserInterface* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
Page* book_get_page (Book* self, gint page_number);
gboolean page_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self);
static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
static gboolean user_interface_on_quit (UserInterface* self);
void autosave_manager_cleanup (AutosaveManager* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self);
static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self);
static void user_interface_page_size_changed_cb (UserInterface* self, Page* page);
static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static void user_interface_needs_saving_cb (UserInterface* self, Book* book);
static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
ProgressBarDialog* progress_bar_dialog_new (GtkWindow* parent, const gchar* title);
ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkWindow* parent, const gchar* title);
static void user_interface_book_saving_cb (UserInterface* self, gint page_number);
static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self);
static gboolean ___lambda2_ (UserInterface* self);
static gboolean ____lambda2__gsource_func (gpointer self);
void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent);
void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message);
Book* user_interface_get_book (UserInterface* self);
void user_interface_set_selected_page (UserInterface* self, Page* page);
Page* user_interface_get_selected_page (UserInterface* self);
void user_interface_set_scanning (UserInterface* self, gboolean scanning);
void user_interface_start (UserInterface* self);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void user_interface_finalize (UserInterface* obj);
#define PROGRESS_BAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialogPrivate))
enum  {
	PROGRESS_BAR_DIALOG_DUMMY_PROPERTY
};
static void progress_bar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _user_interface_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
	user_interface_page_removed_cb (self, _sender, page);
}


static void _user_interface_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
	user_interface_page_added_cb (self, _sender, page);
}


UserInterface* user_interface_construct (GType object_type) {
	UserInterface* self = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	Book* _tmp2_;
	GSettings* _tmp3_;
	AutosaveManager* _tmp4_ = NULL;
	self = (UserInterface*) g_type_create_instance (object_type);
	_tmp0_ = book_new ();
	_book_unref0 (self->priv->book);
	self->priv->book = _tmp0_;
	_tmp1_ = self->priv->book;
	g_signal_connect (_tmp1_, "page-removed", (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
	_tmp2_ = self->priv->book;
	g_signal_connect (_tmp2_, "page-added", (GCallback) _user_interface_page_added_cb_book_page_added, self);
	_tmp3_ = g_settings_new ("org.gnome.SimpleScan");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	user_interface_load (self);
	_tmp4_ = autosave_manager_create (&self->priv->book);
	_autosave_manager_unref0 (self->priv->autosave_manager);
	self->priv->autosave_manager = _tmp4_;
	return self;
}


UserInterface* user_interface_new (void) {
	return user_interface_construct (TYPE_USER_INTERFACE);
}


static gboolean user_interface_find_scan_device (UserInterface* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	have_iter = FALSE;
	_tmp0_ = self->priv->device_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	_vala_iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gchar* d = NULL;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_;
					gboolean _tmp9_;
					_tmp6_ = have_iter;
					if (!_tmp6_) {
						GtkListStore* _tmp7_;
						gboolean _tmp8_ = FALSE;
						_tmp7_ = self->priv->device_model;
						_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &_vala_iter);
						_tmp5_ = _tmp8_;
					} else {
						_tmp5_ = FALSE;
					}
					_tmp9_ = _tmp5_;
					if (!_tmp9_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp10_ = self->priv->device_model;
				_tmp11_ = _vala_iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &d, -1, -1);
				_tmp12_ = d;
				_tmp13_ = device;
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					have_iter = TRUE;
				}
				_g_free0 (d);
			}
		}
	}
	result = have_iter;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static void user_interface_show_error_dialog (UserInterface* self, const gchar* error_title, const gchar* error_text) {
	GtkWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* dialog;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = error_title;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CLOSE, 0);
	_tmp3_ = error_text;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp3_);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (default_file_name != NULL);
	_tmp0_ = default_file_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->default_file_name);
	self->priv->default_file_name = _tmp1_;
}


void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* description;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkLabel* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GtkEntry* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = _ ("Username and password required to access '%s'");
	_tmp1_ = resource;
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
	description = _tmp2_;
	_tmp3_ = self->priv->username_entry;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->password_entry;
	gtk_entry_set_text (_tmp4_, "");
	_tmp5_ = self->priv->authorize_label;
	gtk_label_set_text (_tmp5_, description);
	_tmp6_ = self->priv->authorize_dialog;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->authorize_dialog;
	gtk_dialog_run (_tmp7_);
	_tmp8_ = self->priv->authorize_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->username_entry;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_vala_username);
	_vala_username = _tmp11_;
	_tmp12_ = self->priv->password_entry;
	_tmp13_ = gtk_entry_get_text (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (_vala_password);
	_vala_password = _tmp14_;
	_g_free0 (description);
	if (username) {
		*username = _vala_username;
	} else {
		_g_free0 (_vala_username);
	}
	if (password) {
		*password = _vala_password;
	} else {
		_g_free0 (_vala_password);
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->setting_devices;
	if (_tmp0_) {
		return;
	}
	self->priv->user_selected_device = TRUE;
}


static void user_interface_update_info_bar (UserInterface* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button;
	gboolean show_change_scanner_button;
	gboolean _tmp0_;
	GtkInfoBar* _tmp15_;
	GtkMessageType _tmp16_;
	GtkImage* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* message;
	GtkLabel* _tmp22_;
	const gchar* _tmp23_;
	GtkButton* _tmp24_;
	gboolean _tmp25_;
	GtkButton* _tmp26_;
	gboolean _tmp27_;
	GtkInfoBar* _tmp28_;
	g_return_if_fail (self != NULL);
	show_close_button = FALSE;
	show_change_scanner_button = FALSE;
	_tmp0_ = self->priv->have_error;
	if (_tmp0_) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		type = GTK_MESSAGE_ERROR;
		_tmp1_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
		_g_free0 (image_id);
		image_id = _tmp1_;
		_tmp2_ = self->priv->error_title;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (title);
		title = _tmp3_;
		_tmp4_ = self->priv->error_text;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (text);
		text = _tmp5_;
		show_close_button = TRUE;
		_tmp6_ = self->priv->error_change_scanner_hint;
		show_change_scanner_button = _tmp6_;
	} else {
		GtkListStore* _tmp7_;
		gint _tmp8_ = 0;
		_tmp7_ = self->priv->device_model;
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
		if (_tmp8_ == 0) {
			gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			type = GTK_MESSAGE_WARNING;
			_tmp9_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
			_g_free0 (image_id);
			image_id = _tmp9_;
			_tmp10_ = _ ("No scanners detected");
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (title);
			title = _tmp11_;
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (text);
			text = _tmp13_;
		} else {
			GtkInfoBar* _tmp14_;
			_tmp14_ = self->priv->info_bar;
			gtk_widget_hide ((GtkWidget*) _tmp14_);
			_g_free0 (image_id);
			_g_free0 (text);
			_g_free0 (title);
			return;
		}
	}
	_tmp15_ = self->priv->info_bar;
	_tmp16_ = type;
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->info_bar_image;
	_tmp18_ = image_id;
	gtk_image_set_from_stock (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
	_tmp19_ = title;
	_tmp20_ = text;
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
	message = _tmp21_;
	_tmp22_ = self->priv->info_bar_label;
	_tmp23_ = message;
	gtk_label_set_markup (_tmp22_, _tmp23_);
	_tmp24_ = self->priv->info_bar_close_button;
	_tmp25_ = show_close_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
	_tmp26_ = self->priv->info_bar_change_scanner_button;
	_tmp27_ = show_change_scanner_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
	_tmp28_ = self->priv->info_bar;
	gtk_widget_show ((GtkWidget*) _tmp28_);
	_g_free0 (message);
	_g_free0 (image_id);
	_g_free0 (text);
	_g_free0 (title);
}


static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


void user_interface_set_scan_devices (UserInterface* self, GList* devices) {
	gboolean have_selection;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_;
	GList* _tmp3_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_;
	gboolean _tmp55_;
	g_return_if_fail (self != NULL);
	have_selection = FALSE;
	self->priv->setting_devices = TRUE;
	_tmp0_ = self->priv->user_selected_device;
	if (_tmp0_) {
		GtkComboBox* _tmp1_;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->device_combo;
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
		have_selection = _tmp2_ >= 0;
	}
	index = 0;
	_tmp3_ = devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp3_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			ScanDevice* _tmp4_;
			ScanDevice* device = NULL;
			_tmp4_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
			device = _tmp4_;
			{
				gint n_delete;
				GtkListStore* _tmp5_;
				gint _tmp6_;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gint _tmp21_;
				gint _tmp45_;
				n_delete = -1;
				_tmp5_ = self->priv->device_model;
				_tmp6_ = index;
				_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp7_, NULL, _tmp6_);
				iter = _tmp7_;
				if (_tmp8_) {
					gint i;
					i = 0;
					{
						gboolean _tmp9_;
						_tmp9_ = TRUE;
						while (TRUE) {
							gboolean _tmp10_;
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp13_;
							GtkTreeIter _tmp14_;
							const gchar* _tmp15_;
							ScanDevice* _tmp16_;
							const gchar* _tmp17_;
							gboolean _tmp18_;
							gint _tmp20_;
							_tmp10_ = _tmp9_;
							if (!_tmp10_) {
								GtkListStore* _tmp11_;
								gboolean _tmp12_ = FALSE;
								_tmp11_ = self->priv->device_model;
								_tmp12_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp11_, &iter);
								if (!_tmp12_) {
									break;
								}
							}
							_tmp9_ = FALSE;
							_tmp13_ = self->priv->device_model;
							_tmp14_ = iter;
							gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, 0, &name, -1, -1);
							_tmp15_ = name;
							_tmp16_ = device;
							_tmp17_ = _tmp16_->name;
							matched = g_strcmp0 (_tmp15_, _tmp17_) == 0;
							_tmp18_ = matched;
							if (_tmp18_) {
								gint _tmp19_;
								_tmp19_ = i;
								n_delete = _tmp19_;
								_g_free0 (name);
								break;
							}
							_tmp20_ = i;
							i = _tmp20_ + 1;
							_g_free0 (name);
						}
					}
				}
				_tmp21_ = n_delete;
				if (_tmp21_ >= 0) {
					gint i = 0;
					GtkListStore* _tmp22_;
					GtkTreeIter _tmp23_;
					ScanDevice* _tmp24_;
					const gchar* _tmp25_;
					_tmp22_ = self->priv->device_model;
					_tmp23_ = iter;
					_tmp24_ = device;
					_tmp25_ = _tmp24_->label;
					gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
					{
						gboolean _tmp26_;
						i = 0;
						_tmp26_ = TRUE;
						while (TRUE) {
							gboolean _tmp27_;
							gint _tmp29_;
							gint _tmp30_;
							GtkListStore* _tmp31_;
							gint _tmp32_;
							GtkTreeIter _tmp33_ = {0};
							GtkListStore* _tmp34_;
							GtkTreeIter _tmp35_;
							_tmp27_ = _tmp26_;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = i;
								i = _tmp28_ + 1;
							}
							_tmp26_ = FALSE;
							_tmp29_ = i;
							_tmp30_ = n_delete;
							if (!(_tmp29_ < _tmp30_)) {
								break;
							}
							_tmp31_ = self->priv->device_model;
							_tmp32_ = index;
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp31_, &_tmp33_, NULL, _tmp32_);
							iter = _tmp33_;
							_tmp34_ = self->priv->device_model;
							_tmp35_ = iter;
							gtk_list_store_remove (_tmp34_, &_tmp35_);
						}
					}
				} else {
					GtkListStore* _tmp36_;
					gint _tmp37_;
					GtkTreeIter _tmp38_ = {0};
					GtkListStore* _tmp39_;
					GtkTreeIter _tmp40_;
					ScanDevice* _tmp41_;
					const gchar* _tmp42_;
					ScanDevice* _tmp43_;
					const gchar* _tmp44_;
					_tmp36_ = self->priv->device_model;
					_tmp37_ = index;
					gtk_list_store_insert (_tmp36_, &_tmp38_, _tmp37_);
					iter = _tmp38_;
					_tmp39_ = self->priv->device_model;
					_tmp40_ = iter;
					_tmp41_ = device;
					_tmp42_ = _tmp41_->name;
					_tmp43_ = device;
					_tmp44_ = _tmp43_->label;
					gtk_list_store_set (_tmp39_, &_tmp40_, 0, _tmp42_, 1, _tmp44_, -1, -1);
				}
				_tmp45_ = index;
				index = _tmp45_ + 1;
				_scan_device_unref0 (device);
			}
		}
	}
	while (TRUE) {
		GtkListStore* _tmp46_;
		gint _tmp47_;
		GtkTreeIter _tmp48_ = {0};
		gboolean _tmp49_ = FALSE;
		GtkListStore* _tmp50_;
		GtkTreeIter _tmp51_;
		_tmp46_ = self->priv->device_model;
		_tmp47_ = index;
		_tmp49_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp46_, &_tmp48_, NULL, _tmp47_);
		iter = _tmp48_;
		if (!_tmp49_) {
			break;
		}
		_tmp50_ = self->priv->device_model;
		_tmp51_ = iter;
		gtk_list_store_remove (_tmp50_, &_tmp51_);
	}
	_tmp53_ = have_selection;
	if (!_tmp53_) {
		GList* _tmp54_;
		_tmp54_ = devices;
		_tmp52_ = _tmp54_ != NULL;
	} else {
		_tmp52_ = FALSE;
	}
	_tmp55_ = _tmp52_;
	if (_tmp55_) {
		GtkComboBox* _tmp56_;
		_tmp56_ = self->priv->device_combo;
		gtk_combo_box_set_active (_tmp56_, 0);
	}
	self->priv->setting_devices = FALSE;
	user_interface_update_info_bar (self);
}


static gchar* user_interface_get_selected_device (UserInterface* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->device_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gchar* device = NULL;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->device_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
		result = device;
		return result;
	}
	result = NULL;
	return result;
}


void user_interface_set_selected_device (UserInterface* self, const gchar* device) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp2_ = user_interface_find_scan_device (self, _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->device_combo;
	_tmp4_ = iter;
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
	self->priv->user_selected_device = TRUE;
}


static void user_interface_add_default_page (UserInterface* self) {
	Book* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ScanDirection _tmp4_;
	Page* _tmp5_ = NULL;
	Page* page;
	BookView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->default_page_width;
	_tmp2_ = self->priv->default_page_height;
	_tmp3_ = self->priv->default_page_dpi;
	_tmp4_ = self->priv->default_page_scan_direction;
	_tmp5_ = book_append_page (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	page = _tmp5_;
	_tmp6_ = self->priv->book_view;
	book_view_select_page (_tmp6_, page);
	_page_unref0 (page);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void user_interface_on_file_type_changed (UserInterface* self, GtkTreeSelection* selection) {
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_;
	gchar* extension = NULL;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* path;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* filename;
	const gchar* _tmp11_;
	gint _tmp12_ = 0;
	gint extension_index;
	gint _tmp13_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GtkFileChooserDialog* _tmp20_;
	const gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_tmp0_ = selection;
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (!_tmp3_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp5_ = model;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &extension, -1, -1);
	_tmp7_ = self->priv->save_dialog;
	_tmp8_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp7_);
	path = _tmp8_;
	_tmp9_ = path;
	_tmp10_ = g_path_get_basename (_tmp9_);
	filename = _tmp10_;
	_tmp11_ = filename;
	_tmp12_ = string_last_index_of_char (_tmp11_, (gunichar) '.', 0);
	extension_index = _tmp12_;
	_tmp13_ = extension_index;
	if (_tmp13_ >= 0) {
		const gchar* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		_tmp14_ = filename;
		_tmp15_ = extension_index;
		_tmp16_ = string_slice (_tmp14_, (glong) 0, (glong) _tmp15_);
		_g_free0 (filename);
		filename = _tmp16_;
	}
	_tmp17_ = filename;
	_tmp18_ = extension;
	_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
	_g_free0 (filename);
	filename = _tmp19_;
	_tmp20_ = self->priv->save_dialog;
	_tmp21_ = filename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp20_, _tmp21_);
	_g_free0 (filename);
	_g_free0 (path);
	_g_free0 (extension);
	_g_object_unref0 (model);
}


static void _user_interface_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	user_interface_on_file_type_changed (self, _sender);
}


static gchar* user_interface_choose_file_location (UserInterface* self) {
	gchar* result = NULL;
	gchar* directory;
	GSettings* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp8_ = NULL;
	GtkWindow* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkFileChooserDialog* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	const gchar* _tmp14_;
	GtkFileChooserDialog* _tmp15_;
	const gchar* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* filter;
	GtkFileFilter* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_;
	GtkFileFilter* _tmp21_;
	GtkFileChooserDialog* _tmp22_;
	GtkFileFilter* _tmp23_;
	GtkFileFilter* _tmp24_;
	GtkFileFilter* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_;
	GtkFileChooserDialog* _tmp28_;
	GtkFileFilter* _tmp29_;
	const gchar* _tmp30_ = NULL;
	GtkExpander* _tmp31_;
	GtkExpander* expander;
	GtkExpander* _tmp32_;
	GtkFileChooserDialog* _tmp33_;
	GtkExpander* _tmp34_;
	gchar* _tmp35_;
	gchar* extension;
	const gchar* _tmp36_;
	gint _tmp37_ = 0;
	gint index;
	gint _tmp38_;
	GtkListStore* _tmp42_;
	GtkListStore* file_type_store;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp43_;
	GtkTreeIter _tmp44_ = {0};
	GtkListStore* _tmp45_;
	GtkTreeIter _tmp46_;
	const gchar* _tmp47_ = NULL;
	GtkListStore* _tmp48_;
	GtkTreeIter _tmp49_ = {0};
	GtkListStore* _tmp50_;
	GtkTreeIter _tmp51_;
	const gchar* _tmp52_ = NULL;
	GtkListStore* _tmp53_;
	GtkTreeIter _tmp54_ = {0};
	GtkListStore* _tmp55_;
	GtkTreeIter _tmp56_;
	const gchar* _tmp57_ = NULL;
	GtkListStore* _tmp58_;
	GtkTreeView* _tmp59_;
	GtkTreeView* file_type_view;
	GtkTreeView* _tmp60_;
	GtkTreeView* _tmp61_;
	GtkCellRendererText* _tmp62_;
	GtkCellRendererText* _tmp63_;
	GtkTreeViewColumn* _tmp64_;
	GtkTreeViewColumn* _tmp65_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp66_;
	GtkTreeViewColumn* _tmp67_;
	GtkExpander* _tmp68_;
	GtkTreeView* _tmp69_;
	GtkListStore* _tmp70_;
	GtkTreeIter _tmp71_ = {0};
	gboolean _tmp72_ = FALSE;
	GtkTreeView* _tmp84_;
	GtkTreeSelection* _tmp85_ = NULL;
	GtkExpander* _tmp86_;
	GtkFileChooserDialog* _tmp87_;
	gint _tmp88_ = 0;
	gint response;
	gchar* uri;
	gint _tmp89_;
	GSettings* _tmp92_;
	GtkFileChooserDialog* _tmp93_;
	gchar* _tmp94_ = NULL;
	gchar* _tmp95_;
	GtkTreeView* _tmp96_;
	GtkTreeSelection* _tmp97_ = NULL;
	guint _tmp98_ = 0U;
	GtkFileChooserDialog* _tmp99_;
	g_return_val_if_fail (self != NULL, NULL);
	directory = NULL;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
	_g_free0 (directory);
	directory = _tmp1_;
	_tmp3_ = directory;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = directory;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (directory);
		directory = _tmp7_;
	}
	_tmp8_ = _ ("Save As...");
	_tmp9_ = self->priv->window;
	_tmp10_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp8_, _tmp9_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = _tmp10_;
	_tmp11_ = self->priv->save_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp11_, TRUE);
	_tmp12_ = self->priv->save_dialog;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp12_, FALSE);
	_tmp13_ = self->priv->save_dialog;
	_tmp14_ = directory;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->save_dialog;
	_tmp16_ = self->priv->default_file_name;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp16_);
	_tmp17_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp17_);
	filter = _tmp17_;
	_tmp18_ = filter;
	_tmp19_ = _ ("Image Files");
	gtk_file_filter_set_name (_tmp18_, _tmp19_);
	_tmp20_ = filter;
	gtk_file_filter_add_pixbuf_formats (_tmp20_);
	_tmp21_ = filter;
	gtk_file_filter_add_mime_type (_tmp21_, "application/pdf");
	_tmp22_ = self->priv->save_dialog;
	_tmp23_ = filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp22_, _tmp23_);
	_tmp24_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (filter);
	filter = _tmp24_;
	_tmp25_ = filter;
	_tmp26_ = _ ("All Files");
	gtk_file_filter_set_name (_tmp25_, _tmp26_);
	_tmp27_ = filter;
	gtk_file_filter_add_pattern (_tmp27_, "*");
	_tmp28_ = self->priv->save_dialog;
	_tmp29_ = filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp28_, _tmp29_);
	_tmp30_ = _ ("Select File _Type");
	_tmp31_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp30_);
	g_object_ref_sink (_tmp31_);
	expander = _tmp31_;
	_tmp32_ = expander;
	gtk_expander_set_spacing (_tmp32_, 5);
	_tmp33_ = self->priv->save_dialog;
	_tmp34_ = expander;
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = g_strdup ("");
	extension = _tmp35_;
	_tmp36_ = self->priv->default_file_name;
	_tmp37_ = string_last_index_of_char (_tmp36_, (gunichar) '.', 0);
	index = _tmp37_;
	_tmp38_ = index;
	if (_tmp38_ >= 0) {
		const gchar* _tmp39_;
		gint _tmp40_;
		gchar* _tmp41_ = NULL;
		_tmp39_ = self->priv->default_file_name;
		_tmp40_ = index;
		_tmp41_ = string_slice (_tmp39_, (glong) 0, (glong) _tmp40_);
		_g_free0 (extension);
		extension = _tmp41_;
	}
	_tmp42_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	file_type_store = _tmp42_;
	_tmp43_ = file_type_store;
	gtk_list_store_append (_tmp43_, &_tmp44_);
	iter = _tmp44_;
	_tmp45_ = file_type_store;
	_tmp46_ = iter;
	_tmp47_ = _ ("PDF (multi-page document)");
	gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, ".pdf", -1, -1);
	_tmp48_ = file_type_store;
	gtk_list_store_append (_tmp48_, &_tmp49_);
	iter = _tmp49_;
	_tmp50_ = file_type_store;
	_tmp51_ = iter;
	_tmp52_ = _ ("JPEG (compressed)");
	gtk_list_store_set (_tmp50_, &_tmp51_, 0, _tmp52_, 1, ".jpg", -1, -1);
	_tmp53_ = file_type_store;
	gtk_list_store_append (_tmp53_, &_tmp54_);
	iter = _tmp54_;
	_tmp55_ = file_type_store;
	_tmp56_ = iter;
	_tmp57_ = _ ("PNG (lossless)");
	gtk_list_store_set (_tmp55_, &_tmp56_, 0, _tmp57_, 1, ".png", -1, -1);
	_tmp58_ = file_type_store;
	_tmp59_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp58_);
	g_object_ref_sink (_tmp59_);
	file_type_view = _tmp59_;
	_tmp60_ = file_type_view;
	gtk_tree_view_set_headers_visible (_tmp60_, FALSE);
	_tmp61_ = file_type_view;
	gtk_tree_view_set_rules_hint (_tmp61_, TRUE);
	_tmp62_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp62_);
	_tmp63_ = _tmp62_;
	_tmp64_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp63_, "text", 0, NULL, NULL);
	g_object_ref_sink (_tmp64_);
	_tmp65_ = _tmp64_;
	_g_object_unref0 (_tmp63_);
	column = _tmp65_;
	_tmp66_ = file_type_view;
	_tmp67_ = column;
	gtk_tree_view_append_column (_tmp66_, _tmp67_);
	_tmp68_ = expander;
	_tmp69_ = file_type_view;
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = file_type_store;
	_tmp72_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp70_, &_tmp71_);
	iter = _tmp71_;
	if (_tmp72_) {
		{
			gboolean _tmp73_;
			_tmp73_ = TRUE;
			while (TRUE) {
				gboolean _tmp74_;
				gchar* e = NULL;
				GtkListStore* _tmp77_;
				GtkTreeIter _tmp78_;
				const gchar* _tmp79_;
				const gchar* _tmp80_;
				_tmp74_ = _tmp73_;
				if (!_tmp74_) {
					GtkListStore* _tmp75_;
					gboolean _tmp76_ = FALSE;
					_tmp75_ = file_type_store;
					_tmp76_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp75_, &iter);
					if (!_tmp76_) {
						break;
					}
				}
				_tmp73_ = FALSE;
				_tmp77_ = file_type_store;
				_tmp78_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp77_, &_tmp78_, 1, &e, -1, -1);
				_tmp79_ = extension;
				_tmp80_ = e;
				if (g_strcmp0 (_tmp79_, _tmp80_) == 0) {
					GtkTreeView* _tmp81_;
					GtkTreeSelection* _tmp82_ = NULL;
					GtkTreeIter _tmp83_;
					_tmp81_ = file_type_view;
					_tmp82_ = gtk_tree_view_get_selection (_tmp81_);
					_tmp83_ = iter;
					gtk_tree_selection_select_iter (_tmp82_, &_tmp83_);
				}
				_g_free0 (e);
			}
		}
	}
	_tmp84_ = file_type_view;
	_tmp85_ = gtk_tree_view_get_selection (_tmp84_);
	g_signal_connect (_tmp85_, "changed", (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
	_tmp86_ = expander;
	gtk_widget_show_all ((GtkWidget*) _tmp86_);
	_tmp87_ = self->priv->save_dialog;
	_tmp88_ = gtk_dialog_run ((GtkDialog*) _tmp87_);
	response = _tmp88_;
	uri = NULL;
	_tmp89_ = response;
	if (_tmp89_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp90_;
		gchar* _tmp91_ = NULL;
		_tmp90_ = self->priv->save_dialog;
		_tmp91_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp90_);
		_g_free0 (uri);
		uri = _tmp91_;
	}
	_tmp92_ = self->priv->settings;
	_tmp93_ = self->priv->save_dialog;
	_tmp94_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp93_);
	_tmp95_ = _tmp94_;
	g_settings_set_string (_tmp92_, "save-directory", _tmp95_);
	_g_free0 (_tmp95_);
	_tmp96_ = file_type_view;
	_tmp97_ = gtk_tree_view_get_selection (_tmp96_);
	g_signal_parse_name ("changed", GTK_TYPE_TREE_SELECTION, &_tmp98_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp97_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp98_, 0, NULL, (GCallback) _user_interface_on_file_type_changed_gtk_tree_selection_changed, self);
	_tmp99_ = self->priv->save_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp99_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	result = uri;
	_g_object_unref0 (column);
	_g_object_unref0 (file_type_view);
	_g_object_unref0 (file_type_store);
	_g_free0 (extension);
	_g_object_unref0 (expander);
	_g_object_unref0 (filter);
	_g_free0 (directory);
	return result;
}


static gboolean user_interface_save_document (UserInterface* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_ = NULL;
	GFile* file;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* uri_lower;
	gchar* _tmp13_;
	gchar* format;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	Book* _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->book_uri;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_;
		_tmp2_ = force_choose_location;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->book_uri;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (uri);
		uri = _tmp5_;
	} else {
		gchar* _tmp6_ = NULL;
		_tmp6_ = user_interface_choose_file_location (self);
		_g_free0 (uri);
		uri = _tmp6_;
	}
	_tmp7_ = uri;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_free0 (uri);
		return result;
	}
	_tmp8_ = uri;
	_tmp9_ = g_file_new_for_uri (_tmp8_);
	file = _tmp9_;
	_tmp10_ = uri;
	g_debug ("ui.vala:460: Saving to '%s'", _tmp10_);
	_tmp11_ = uri;
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) (-1));
	uri_lower = _tmp12_;
	_tmp13_ = g_strdup ("jpeg");
	format = _tmp13_;
	_tmp14_ = uri_lower;
	_tmp15_ = g_str_has_suffix (_tmp14_, ".pdf");
	if (_tmp15_) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("pdf");
		_g_free0 (format);
		format = _tmp16_;
	} else {
		const gchar* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = uri_lower;
		_tmp18_ = g_str_has_suffix (_tmp17_, ".ps");
		if (_tmp18_) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("ps");
			_g_free0 (format);
			format = _tmp19_;
		} else {
			const gchar* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = uri_lower;
			_tmp21_ = g_str_has_suffix (_tmp20_, ".png");
			if (_tmp21_) {
				gchar* _tmp22_;
				_tmp22_ = g_strdup ("png");
				_g_free0 (format);
				format = _tmp22_;
			} else {
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp28_;
				_tmp24_ = uri_lower;
				_tmp25_ = g_str_has_suffix (_tmp24_, ".tif");
				if (_tmp25_) {
					_tmp23_ = TRUE;
				} else {
					const gchar* _tmp26_;
					gboolean _tmp27_ = FALSE;
					_tmp26_ = uri_lower;
					_tmp27_ = g_str_has_suffix (_tmp26_, ".tiff");
					_tmp23_ = _tmp27_;
				}
				_tmp28_ = _tmp23_;
				if (_tmp28_) {
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("tiff");
					_g_free0 (format);
					format = _tmp29_;
				}
			}
		}
	}
	user_interface_show_progress_dialog (self);
	{
		Book* _tmp30_;
		const gchar* _tmp31_;
		GFile* _tmp32_;
		_tmp30_ = self->priv->book;
		_tmp31_ = format;
		_tmp32_ = file;
		book_save (_tmp30_, _tmp31_, _tmp32_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		user_interface_hide_progress_dialog (self);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("ui.vala:481: Error saving file: %s", _tmp34_);
		_tmp35_ = _ ("Failed to save file");
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		user_interface_show_error (self, _tmp35_, _tmp37_, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (format);
		_g_free0 (uri_lower);
		_g_object_unref0 (file);
		_g_free0 (uri);
		return result;
	}
	__finally15:
	if (_inner_error_ != NULL) {
		_g_free0 (format);
		_g_free0 (uri_lower);
		_g_object_unref0 (file);
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp38_ = uri;
	_tmp39_ = g_strdup (_tmp38_);
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = _tmp39_;
	_tmp40_ = self->priv->book;
	book_set_needs_saving (_tmp40_, FALSE);
	result = TRUE;
	_g_free0 (format);
	_g_free0 (uri_lower);
	_g_object_unref0 (file);
	_g_free0 (uri);
	return result;
}


static gboolean user_interface_prompt_to_save (UserInterface* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkWindow* _tmp2_;
	const gchar* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* dialog;
	GtkMessageDialog* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_;
	const gchar* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	gint _tmp12_ = 0;
	gint response;
	GtkMessageDialog* _tmp13_;
	gint _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	g_return_val_if_fail (discard_label != NULL, FALSE);
	_tmp0_ = self->priv->book;
	_tmp1_ = book_get_needs_saving (_tmp0_);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->window;
	_tmp3_ = title;
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp3_);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	_tmp5_ = dialog;
	_tmp6_ = _ ("If you don't save, changes will be permanently lost.");
	gtk_message_dialog_format_secondary_text (_tmp5_, "%s", _tmp6_);
	_tmp7_ = dialog;
	_tmp8_ = discard_label;
	gtk_dialog_add_button ((GtkDialog*) _tmp7_, _tmp8_, (gint) GTK_RESPONSE_NO);
	_tmp9_ = dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp9_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp10_ = dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
	_tmp11_ = dialog;
	_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
	response = _tmp12_;
	_tmp13_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_tmp14_ = response;
	switch (_tmp14_) {
		case GTK_RESPONSE_YES:
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = user_interface_save_document (self, FALSE);
			if (_tmp15_) {
				result = TRUE;
				_g_object_unref0 (dialog);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (dialog);
				return result;
			}
		}
		case GTK_RESPONSE_CANCEL:
		{
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		default:
		case GTK_RESPONSE_NO:
		{
			result = TRUE;
			_g_object_unref0 (dialog);
			return result;
		}
	}
	_g_object_unref0 (dialog);
}


static void user_interface_clear_document (UserInterface* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	GtkMenuItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book;
	book_clear (_tmp0_);
	user_interface_add_default_page (self);
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = NULL;
	_tmp1_ = self->priv->book;
	book_set_needs_saving (_tmp1_, FALSE);
	_tmp2_ = self->priv->save_as_menuitem;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _ ("Save current document?");
	_tmp1_ = _ ("Discard Changes");
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->scanning;
	if (_tmp3_) {
		g_signal_emit_by_name (self, "stop-scan");
	}
	user_interface_clear_document (self);
}


static void user_interface_set_document_hint (UserInterface* self, const gchar* document_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document_hint != NULL);
	_tmp0_ = document_hint;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->document_hint);
	self->priv->document_hint = _tmp1_;
	_tmp2_ = document_hint;
	if (g_strcmp0 (_tmp2_, "text") == 0) {
		GtkRadioMenuItem* _tmp3_;
		GtkRadioMenuItem* _tmp4_;
		_tmp3_ = self->priv->text_toolbar_menuitem;
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
		_tmp4_ = self->priv->text_menu_menuitem;
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
	} else {
		const gchar* _tmp5_;
		_tmp5_ = document_hint;
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
			GtkRadioMenuItem* _tmp6_;
			GtkRadioMenuItem* _tmp7_;
			_tmp6_ = self->priv->photo_toolbar_menuitem;
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
			_tmp7_ = self->priv->photo_menu_menuitem;
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
		}
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_document_hint (self, "text");
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_document_hint (self, "photo");
	}
}


static void user_interface_set_page_side (UserInterface* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_side_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint s = 0;
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_;
				gint _tmp9_;
				ScanType _tmp10_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					GtkListStore* _tmp5_;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = self->priv->page_side_model;
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
					if (!_tmp6_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp7_ = self->priv->page_side_model;
				_tmp8_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &s, -1, -1);
				_tmp9_ = s;
				_tmp10_ = page_side;
				if (_tmp9_ == ((gint) _tmp10_)) {
					GtkComboBox* _tmp11_;
					GtkTreeIter _tmp12_;
					_tmp11_ = self->priv->page_side_combo;
					_tmp12_ = iter;
					gtk_combo_box_set_active_iter (_tmp11_, &_tmp12_);
					return;
				}
			}
		}
	}
}


static void user_interface_set_paper_size (UserInterface* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp16_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	{
		GtkListStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp0_ = self->priv->paper_size_model;
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
		iter = _tmp1_;
		have_iter = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gboolean _tmp4_;
			gboolean _tmp7_;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp8_;
			GtkTreeIter _tmp9_;
			gboolean _tmp10_ = FALSE;
			gint _tmp11_;
			gint _tmp12_;
			gboolean _tmp15_;
			_tmp4_ = _tmp3_;
			if (!_tmp4_) {
				GtkListStore* _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp5_ = self->priv->paper_size_model;
				_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
				have_iter = _tmp6_;
			}
			_tmp3_ = FALSE;
			_tmp7_ = have_iter;
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = self->priv->paper_size_model;
			_tmp9_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &w, 1, &h, -1, -1);
			_tmp11_ = w;
			_tmp12_ = width;
			if (_tmp11_ == _tmp12_) {
				gint _tmp13_;
				gint _tmp14_;
				_tmp13_ = h;
				_tmp14_ = height;
				_tmp10_ = _tmp13_ == _tmp14_;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp15_ = _tmp10_;
			if (_tmp15_) {
				break;
			}
		}
	}
	_tmp16_ = have_iter;
	if (!_tmp16_) {
		GtkListStore* _tmp17_;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
		_tmp17_ = self->priv->paper_size_model;
		_tmp19_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp17_, &_tmp18_);
		iter = _tmp18_;
		have_iter = _tmp19_;
	}
	_tmp20_ = have_iter;
	if (_tmp20_) {
		GtkComboBox* _tmp21_;
		GtkTreeIter _tmp22_;
		_tmp21_ = self->priv->paper_size_combo;
		_tmp22_ = iter;
		gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
	}
}


static void user_interface_set_brightness (UserInterface* self, gint brightness) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = brightness;
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
}


static void user_interface_set_contrast (UserInterface* self, gint contrast) {
	GtkAdjustment* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contrast_adjustment;
	_tmp1_ = contrast;
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
}


static gint user_interface_get_text_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
	_tmp0_ = self->priv->text_dpi_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->text_dpi_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
	}
	result = dpi;
	return result;
}


static gint user_interface_get_photo_dpi (UserInterface* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
	_tmp0_ = self->priv->photo_dpi_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->photo_dpi_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
	}
	result = dpi;
	return result;
}


static ScanType user_interface_get_page_side (UserInterface* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
	_tmp0_ = self->priv->page_side_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->page_side_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
	}
	_tmp5_ = page_side;
	result = (ScanType) _tmp5_;
	return result;
}


static gboolean user_interface_get_paper_size (UserInterface* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_;
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_height = 0;
	_tmp0_ = _vala_height;
	_vala_width = _tmp0_;
	_tmp1_ = self->priv->paper_size_combo;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->paper_size_model;
		_tmp5_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
		result = TRUE;
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		return result;
	}
	result = FALSE;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}


static gint user_interface_get_brightness (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	result = (gint) _tmp1_;
	return result;
}


static gint user_interface_get_contrast (UserInterface* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->contrast_adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	result = (gint) _tmp1_;
	return result;
}


static ScanOptions* user_interface_get_scan_options (UserInterface* self) {
	ScanOptions* result = NULL;
	ScanOptions* _tmp0_;
	ScanOptions* options;
	const gchar* _tmp1_;
	ScanOptions* _tmp10_;
	ScanOptions* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	ScanOptions* _tmp14_;
	gint _tmp15_ = 0;
	ScanOptions* _tmp16_;
	gint _tmp17_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = scan_options_new ();
	options = _tmp0_;
	_tmp1_ = self->priv->document_hint;
	if (g_strcmp0 (_tmp1_, "text") == 0) {
		ScanOptions* _tmp2_;
		ScanOptions* _tmp3_;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_;
		_tmp2_ = options;
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
		_tmp3_ = options;
		_tmp4_ = user_interface_get_text_dpi (self);
		_tmp3_->dpi = _tmp4_;
		_tmp5_ = options;
		_tmp5_->depth = 2;
	} else {
		ScanOptions* _tmp6_;
		ScanOptions* _tmp7_;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_;
		_tmp6_ = options;
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
		_tmp7_ = options;
		_tmp8_ = user_interface_get_photo_dpi (self);
		_tmp7_->dpi = _tmp8_;
		_tmp9_ = options;
		_tmp9_->depth = 8;
	}
	_tmp10_ = options;
	_tmp11_ = options;
	user_interface_get_paper_size (self, &_tmp12_, &_tmp13_);
	_tmp10_->paper_width = _tmp12_;
	_tmp11_->paper_height = _tmp13_;
	_tmp14_ = options;
	_tmp15_ = user_interface_get_brightness (self);
	_tmp14_->brightness = _tmp15_;
	_tmp16_ = options;
	_tmp17_ = user_interface_get_contrast (self);
	_tmp16_->contrast = _tmp17_;
	result = options;
	return result;
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	ScanOptions* _tmp0_ = NULL;
	ScanOptions* options;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = user_interface_get_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_SINGLE;
	_tmp1_ = user_interface_get_selected_device (self);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (self, "start-scan", _tmp2_, options);
	_g_free0 (_tmp2_);
	_scan_options_unref0 (options);
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_signal_emit_by_name (self, "stop-scan");
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scanning;
	if (_tmp0_) {
		g_signal_emit_by_name (self, "stop-scan");
	} else {
		ScanOptions* _tmp1_ = NULL;
		ScanOptions* options;
		ScanOptions* _tmp2_;
		ScanType _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		ScanOptions* _tmp6_;
		_tmp1_ = user_interface_get_scan_options (self);
		options = _tmp1_;
		_tmp2_ = options;
		_tmp3_ = user_interface_get_page_side (self);
		_tmp2_->type = _tmp3_;
		_tmp4_ = user_interface_get_selected_device (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = options;
		g_signal_emit_by_name (self, "start-scan", _tmp5_, _tmp6_);
		_g_free0 (_tmp5_);
		_scan_options_unref0 (options);
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, UserInterface* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	result = TRUE;
	return result;
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, UserInterface* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void user_interface_update_page_menu (UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == NULL) {
		GtkMenuItem* _tmp3_;
		GtkMenuItem* _tmp4_;
		_tmp3_ = self->priv->page_move_left_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->page_move_right_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	} else {
		Book* _tmp5_;
		Page* _tmp6_;
		guint _tmp7_ = 0U;
		guint index;
		GtkMenuItem* _tmp8_;
		guint _tmp9_;
		GtkMenuItem* _tmp10_;
		guint _tmp11_;
		Book* _tmp12_;
		guint _tmp13_ = 0U;
		_tmp5_ = self->priv->book;
		_tmp6_ = page;
		_tmp7_ = book_get_page_index (_tmp5_, _tmp6_);
		index = _tmp7_;
		_tmp8_ = self->priv->page_move_left_menuitem;
		_tmp9_ = index;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp9_ > ((guint) 0));
		_tmp10_ = self->priv->page_move_right_menuitem;
		_tmp11_ = index;
		_tmp12_ = self->priv->book;
		_tmp13_ = book_get_n_pages (_tmp12_);
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ < (_tmp13_ - 1));
	}
	_page_unref0 (page);
}


static void user_interface_page_selected_cb (UserInterface* self, BookView* view, Page* page) {
	Page* _tmp0_;
	gchar* name;
	Page* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkBuilder* _tmp20_;
	const gchar* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkRadioMenuItem* _tmp23_;
	GtkRadioMenuItem* menuitem;
	GtkRadioMenuItem* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkToggleToolButton* _tmp27_;
	GtkToggleToolButton* toolbutton;
	GtkToggleToolButton* _tmp28_;
	Page* _tmp29_;
	gboolean _tmp30_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = page;
	if (_tmp0_ == NULL) {
		return;
	}
	self->priv->updating_page_menu = TRUE;
	user_interface_update_page_menu (self);
	name = NULL;
	_tmp1_ = page;
	_tmp2_ = page_has_crop (_tmp1_);
	if (_tmp2_) {
		Page* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* crop_name;
		const gchar* _tmp5_;
		_tmp3_ = page;
		_tmp4_ = page_get_named_crop (_tmp3_);
		crop_name = _tmp4_;
		_tmp5_ = crop_name;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			_tmp6_ = crop_name;
			if (g_strcmp0 (_tmp6_, "A4") == 0) {
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("a4_menuitem");
				_g_free0 (name);
				name = _tmp7_;
			} else {
				const gchar* _tmp8_;
				_tmp8_ = crop_name;
				if (g_strcmp0 (_tmp8_, "A5") == 0) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("a5_menuitem");
					_g_free0 (name);
					name = _tmp9_;
				} else {
					const gchar* _tmp10_;
					_tmp10_ = crop_name;
					if (g_strcmp0 (_tmp10_, "A6") == 0) {
						gchar* _tmp11_;
						_tmp11_ = g_strdup ("a6_menuitem");
						_g_free0 (name);
						name = _tmp11_;
					} else {
						const gchar* _tmp12_;
						_tmp12_ = crop_name;
						if (g_strcmp0 (_tmp12_, "letter") == 0) {
							gchar* _tmp13_;
							_tmp13_ = g_strdup ("letter_menuitem");
							_g_free0 (name);
							name = _tmp13_;
						} else {
							const gchar* _tmp14_;
							_tmp14_ = crop_name;
							if (g_strcmp0 (_tmp14_, "legal") == 0) {
								gchar* _tmp15_;
								_tmp15_ = g_strdup ("legal_menuitem");
								_g_free0 (name);
								name = _tmp15_;
							} else {
								const gchar* _tmp16_;
								_tmp16_ = crop_name;
								if (g_strcmp0 (_tmp16_, "4x6") == 0) {
									gchar* _tmp17_;
									_tmp17_ = g_strdup ("4x6_menuitem");
									_g_free0 (name);
									name = _tmp17_;
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("custom_crop_menuitem");
			_g_free0 (name);
			name = _tmp18_;
		}
		_g_free0 (crop_name);
	} else {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("no_crop_menuitem");
		_g_free0 (name);
		name = _tmp19_;
	}
	_tmp20_ = self->priv->builder;
	_tmp21_ = name;
	_tmp22_ = gtk_builder_get_object (_tmp20_, _tmp21_);
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
	menuitem = _tmp23_;
	_tmp24_ = menuitem;
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp24_, TRUE);
	_tmp25_ = self->priv->builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "crop_toolbutton");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_TOGGLE_TOOL_BUTTON, GtkToggleToolButton));
	toolbutton = _tmp27_;
	_tmp28_ = toolbutton;
	_tmp29_ = page;
	_tmp30_ = page_has_crop (_tmp29_);
	gtk_toggle_tool_button_set_active (_tmp28_, _tmp30_);
	self->priv->updating_page_menu = FALSE;
	_g_object_unref0 (toolbutton);
	_g_object_unref0 (menuitem);
	_g_free0 (name);
}


static void user_interface_show_page_cb (UserInterface* self, BookView* view, Page* page) {
	gchar* _tmp0_ = NULL;
	gchar* path;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = get_temporary_filename ("scanned-page", "tiff");
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		_g_free0 (path);
		return;
	}
	_tmp2_ = path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	{
		Page* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = page;
		_tmp5_ = file;
		page_save (_tmp4_, "tiff", _tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _ ("Unable to save image for preview");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		user_interface_show_error_dialog (self, _tmp6_, _tmp8_);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_free0 (path);
		return;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GtkWindow* _tmp9_;
		GdkScreen* _tmp10_ = NULL;
		GFile* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		guint32 _tmp14_ = 0U;
		_tmp9_ = self->priv->window;
		_tmp10_ = gtk_window_get_screen (_tmp9_);
		_tmp11_ = file;
		_tmp12_ = g_file_get_uri (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp10_, _tmp13_, _tmp14_, &_inner_error_);
		_g_free0 (_tmp13_);
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = _ ("Unable to open image preview application");
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		user_interface_show_error_dialog (self, _tmp15_, _tmp17_);
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (path);
}


static void user_interface_show_page_menu_cb (UserInterface* self, BookView* view) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_;
	GtkMenu* menu;
	guint32 _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "page_menu");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_MENU, GtkMenu));
	menu = _tmp2_;
	_tmp3_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp3_);
	_g_object_unref0 (menu);
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->updating_page_menu;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->book_view;
	_tmp2_ = book_view_get_selected (_tmp1_);
	page = _tmp2_;
	_tmp3_ = page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_;
		_tmp4_ = page;
		page_rotate_left (_tmp4_);
	}
	_page_unref0 (page);
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->updating_page_menu;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->book_view;
	_tmp2_ = book_view_get_selected (_tmp1_);
	page = _tmp2_;
	_tmp3_ = page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_;
		_tmp4_ = page;
		page_rotate_right (_tmp4_);
	}
	_page_unref0 (page);
}


static void user_interface_set_crop (UserInterface* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* page;
	Page* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_rotate_menuitem;
	_tmp1_ = crop_name;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
	_tmp2_ = self->priv->updating_page_menu;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->book_view;
	_tmp4_ = book_view_get_selected (_tmp3_);
	page = _tmp4_;
	_tmp5_ = page;
	if (_tmp5_ == NULL) {
		_page_unref0 (page);
		return;
	}
	_tmp6_ = crop_name;
	if (_tmp6_ == NULL) {
		Page* _tmp7_;
		_tmp7_ = page;
		page_set_no_crop (_tmp7_);
		_page_unref0 (page);
		return;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = crop_name;
		if (g_strcmp0 (_tmp8_, "custom") == 0) {
			Page* _tmp9_;
			gint _tmp10_ = 0;
			gint width;
			Page* _tmp11_;
			gint _tmp12_ = 0;
			gint height;
			gint _tmp13_;
			gint crop_width;
			gint _tmp14_;
			gint crop_height;
			Page* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Page* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp9_ = page;
			_tmp10_ = page_get_width (_tmp9_);
			width = _tmp10_;
			_tmp11_ = page;
			_tmp12_ = page_get_height (_tmp11_);
			height = _tmp12_;
			_tmp13_ = width;
			crop_width = (gint) ((_tmp13_ * 0.8) + 0.5);
			_tmp14_ = height;
			crop_height = (gint) ((_tmp14_ * 0.8) + 0.5);
			_tmp15_ = page;
			_tmp16_ = crop_width;
			_tmp17_ = crop_height;
			page_set_custom_crop (_tmp15_, _tmp16_, _tmp17_);
			_tmp18_ = page;
			_tmp19_ = width;
			_tmp20_ = crop_width;
			_tmp21_ = height;
			_tmp22_ = crop_height;
			page_move_crop (_tmp18_, (_tmp19_ - _tmp20_) / 2, (_tmp21_ - _tmp22_) / 2);
		} else {
			Page* _tmp23_;
			const gchar* _tmp24_;
			_tmp23_ = page;
			_tmp24_ = crop_name;
			page_set_named_crop (_tmp23_, _tmp24_);
		}
	}
	_page_unref0 (page);
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, NULL);
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, "custom");
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, UserInterface* self) {
	gboolean _tmp0_;
	GtkRadioMenuItem* menuitem = NULL;
	GtkToggleToolButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->updating_page_menu;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
	if (_tmp2_) {
		GtkBuilder* _tmp3_;
		GObject* _tmp4_ = NULL;
		GtkRadioMenuItem* _tmp5_;
		_tmp3_ = self->priv->builder;
		_tmp4_ = gtk_builder_get_object (_tmp3_, "custom_crop_menuitem");
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
		_g_object_unref0 (menuitem);
		menuitem = _tmp5_;
	} else {
		GtkBuilder* _tmp6_;
		GObject* _tmp7_ = NULL;
		GtkRadioMenuItem* _tmp8_;
		_tmp6_ = self->priv->builder;
		_tmp7_ = gtk_builder_get_object (_tmp6_, "no_crop_menuitem");
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
		_g_object_unref0 (menuitem);
		menuitem = _tmp8_;
	}
	_tmp9_ = menuitem;
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp9_, TRUE);
	_g_object_unref0 (menuitem);
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, "4x6");
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, "legal");
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, "letter");
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, "A6");
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, "A5");
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, UserInterface* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		user_interface_set_crop (self, "A4");
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
	Page* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == NULL) {
		_page_unref0 (page);
		return;
	}
	_tmp3_ = page;
	page_rotate_crop (_tmp3_);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = self->priv->book;
	_tmp3_ = page;
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
	index = _tmp4_;
	_tmp5_ = index;
	if (_tmp5_ > ((guint) 0)) {
		Book* _tmp6_;
		Page* _tmp7_;
		guint _tmp8_;
		_tmp6_ = self->priv->book;
		_tmp7_ = page;
		_tmp8_ = index;
		book_move_page (_tmp6_, _tmp7_, _tmp8_ - 1);
	}
	user_interface_update_page_menu (self);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
	Book* _tmp6_;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = self->priv->book;
	_tmp3_ = page;
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
	index = _tmp4_;
	_tmp5_ = index;
	_tmp6_ = self->priv->book;
	_tmp7_ = book_get_n_pages (_tmp6_);
	if (_tmp5_ < (_tmp7_ - 1)) {
		Book* _tmp8_;
		Page* _tmp9_;
		Book* _tmp10_;
		Page* _tmp11_;
		guint _tmp12_ = 0U;
		_tmp8_ = self->priv->book;
		_tmp9_ = page;
		_tmp10_ = self->priv->book;
		_tmp11_ = page;
		_tmp12_ = book_get_page_index (_tmp10_, _tmp11_);
		book_move_page (_tmp8_, _tmp9_, _tmp12_ + 1);
	}
	user_interface_update_page_menu (self);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	BookView* _tmp0_;
	Book* _tmp1_ = NULL;
	Book* _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_book (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->book_view;
	_tmp4_ = book_view_get_selected (_tmp3_);
	_tmp5_ = _tmp4_;
	book_delete_page (_tmp2_, _tmp5_);
	_page_unref0 (_tmp5_);
	_book_unref0 (_tmp2_);
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	user_interface_save_document (self, FALSE);
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	user_interface_save_document (self, TRUE);
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static void user_interface_draw_page (UserInterface* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	GtkPrintContext* _tmp0_;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_;
	cairo_t* context;
	Book* _tmp3_;
	gint _tmp4_;
	Page* _tmp5_ = NULL;
	Page* page;
	gboolean is_landscape;
	GtkPrintContext* _tmp6_;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	cairo_t* _tmp17_;
	GtkPrintContext* _tmp18_;
	gdouble _tmp19_ = 0.0;
	Page* _tmp20_;
	gint _tmp21_ = 0;
	GtkPrintContext* _tmp22_;
	gdouble _tmp23_ = 0.0;
	Page* _tmp24_;
	gint _tmp25_ = 0;
	Page* _tmp26_;
	GdkPixbuf* _tmp27_ = NULL;
	GdkPixbuf* image;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (print_context != NULL);
	_tmp0_ = print_context;
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
	_tmp2_ = _cairo_reference0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = self->priv->book;
	_tmp4_ = page_number;
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
	page = _tmp5_;
	is_landscape = FALSE;
	_tmp6_ = print_context;
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
	_tmp8_ = print_context;
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
	if (_tmp7_ > _tmp9_) {
		is_landscape = TRUE;
	}
	_tmp10_ = page;
	_tmp11_ = page_is_landscape (_tmp10_);
	_tmp12_ = is_landscape;
	if (_tmp11_ != _tmp12_) {
		cairo_t* _tmp13_;
		GtkPrintContext* _tmp14_;
		gdouble _tmp15_ = 0.0;
		cairo_t* _tmp16_;
		_tmp13_ = context;
		_tmp14_ = print_context;
		_tmp15_ = gtk_print_context_get_width (_tmp14_);
		cairo_translate (_tmp13_, _tmp15_, (gdouble) 0);
		_tmp16_ = context;
		cairo_rotate (_tmp16_, G_PI_2);
	}
	_tmp17_ = context;
	_tmp18_ = print_context;
	_tmp19_ = gtk_print_context_get_dpi_x (_tmp18_);
	_tmp20_ = page;
	_tmp21_ = page_get_dpi (_tmp20_);
	_tmp22_ = print_context;
	_tmp23_ = gtk_print_context_get_dpi_y (_tmp22_);
	_tmp24_ = page;
	_tmp25_ = page_get_dpi (_tmp24_);
	cairo_scale (_tmp17_, _tmp19_ / _tmp21_, _tmp23_ / _tmp25_);
	_tmp26_ = page;
	_tmp27_ = page_get_image (_tmp26_, TRUE);
	image = _tmp27_;
	_tmp28_ = context;
	gdk_cairo_set_source_pixbuf (_tmp28_, image, (gdouble) 0, (gdouble) 0);
	_tmp29_ = context;
	cairo_paint (_tmp29_);
	_g_object_unref0 (image);
	_page_unref0 (page);
	_cairo_destroy0 (context);
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->document_hint;
	g_signal_emit_by_name (self, "email", _tmp0_);
}


static void _user_interface_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
	user_interface_draw_page (self, _sender, context, page_nr);
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, UserInterface* self) {
	GtkPrintOperation* _tmp0_;
	GtkPrintOperation* print;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	guint _tmp6_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_print_operation_new ();
	print = _tmp0_;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	gtk_print_operation_set_n_pages (print, (gint) _tmp2_);
	g_signal_connect (print, "draw-page", (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
	{
		GtkWindow* _tmp3_;
		_tmp3_ = self->priv->window;
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ui.vala:1064: Error printing: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (print);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_signal_parse_name ("draw-page", GTK_TYPE_PRINT_OPERATION, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _user_interface_draw_page_gtk_print_operation_draw_page, self);
	_g_object_unref0 (print);
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Unable to open help file");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		user_interface_show_error_dialog (self, _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* license;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* title;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* description;
	GtkWindow* _tmp8_;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	authors = _tmp1_;
	authors_length1 = 1;
	_authors_size_ = authors_length1;
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
	_tmp3_ = g_strdup (_tmp2_);
	license = _tmp3_;
	_tmp4_ = _ ("About Simple Scan");
	_tmp5_ = g_strdup (_tmp4_);
	title = _tmp5_;
	_tmp6_ = _ ("Simple document scanning tool");
	_tmp7_ = g_strdup (_tmp6_);
	description = _tmp7_;
	_tmp8_ = self->priv->window;
	_tmp9_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp8_, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp9_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
	_g_free0 (description);
	_g_free0 (title);
	_g_free0 (license);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean user_interface_on_quit (UserInterface* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* device;
	gint paper_width;
	gint paper_height;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	const gchar* _tmp6_;
	GSettings* _tmp9_;
	const gchar* _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_ = 0;
	GSettings* _tmp13_;
	gint _tmp14_ = 0;
	GSettings* _tmp15_;
	ScanType _tmp16_ = 0;
	GSettings* _tmp17_;
	gint _tmp18_;
	GSettings* _tmp19_;
	gint _tmp20_;
	GSettings* _tmp21_;
	gint _tmp22_ = 0;
	GSettings* _tmp23_;
	gint _tmp24_ = 0;
	GSettings* _tmp25_;
	gint _tmp26_;
	GSettings* _tmp27_;
	gint _tmp28_;
	GSettings* _tmp29_;
	gboolean _tmp30_;
	GSettings* _tmp31_;
	ScanDirection _tmp32_;
	GSettings* _tmp33_;
	gint _tmp34_;
	GSettings* _tmp35_;
	gint _tmp36_;
	GSettings* _tmp37_;
	gint _tmp38_;
	GtkWindow* _tmp39_;
	AutosaveManager* _tmp40_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _ ("Save document before quitting?");
	_tmp1_ = _ ("Quit without Saving");
	_tmp2_ = user_interface_prompt_to_save (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = user_interface_get_selected_device (self);
	device = _tmp3_;
	paper_width = 0;
	paper_height = 0;
	user_interface_get_paper_size (self, &_tmp4_, &_tmp5_);
	paper_width = _tmp4_;
	paper_height = _tmp5_;
	_tmp6_ = device;
	if (_tmp6_ != NULL) {
		GSettings* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->settings;
		_tmp8_ = device;
		g_settings_set_string (_tmp7_, "selected-device", _tmp8_);
	}
	_tmp9_ = self->priv->settings;
	_tmp10_ = self->priv->document_hint;
	g_settings_set_string (_tmp9_, "document-type", _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = user_interface_get_text_dpi (self);
	g_settings_set_int (_tmp11_, "text-dpi", _tmp12_);
	_tmp13_ = self->priv->settings;
	_tmp14_ = user_interface_get_photo_dpi (self);
	g_settings_set_int (_tmp13_, "photo-dpi", _tmp14_);
	_tmp15_ = self->priv->settings;
	_tmp16_ = user_interface_get_page_side (self);
	g_settings_set_enum (_tmp15_, "page-side", (gint) _tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = paper_width;
	g_settings_set_int (_tmp17_, "paper-width", _tmp18_);
	_tmp19_ = self->priv->settings;
	_tmp20_ = paper_height;
	g_settings_set_int (_tmp19_, "paper-height", _tmp20_);
	_tmp21_ = self->priv->settings;
	_tmp22_ = user_interface_get_brightness (self);
	g_settings_set_int (_tmp21_, "brightness", _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = user_interface_get_contrast (self);
	g_settings_set_int (_tmp23_, "contrast", _tmp24_);
	_tmp25_ = self->priv->settings;
	_tmp26_ = self->priv->window_width;
	g_settings_set_int (_tmp25_, "window-width", _tmp26_);
	_tmp27_ = self->priv->settings;
	_tmp28_ = self->priv->window_height;
	g_settings_set_int (_tmp27_, "window-height", _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = self->priv->window_is_maximized;
	g_settings_set_boolean (_tmp29_, "window-is-maximized", _tmp30_);
	_tmp31_ = self->priv->settings;
	_tmp32_ = self->priv->default_page_scan_direction;
	g_settings_set_enum (_tmp31_, "scan-direction", (gint) _tmp32_);
	_tmp33_ = self->priv->settings;
	_tmp34_ = self->priv->default_page_width;
	g_settings_set_int (_tmp33_, "page-width", _tmp34_);
	_tmp35_ = self->priv->settings;
	_tmp36_ = self->priv->default_page_height;
	g_settings_set_int (_tmp35_, "page-height", _tmp36_);
	_tmp37_ = self->priv->settings;
	_tmp38_ = self->priv->default_page_dpi;
	g_settings_set_int (_tmp37_, "page-dpi", _tmp38_);
	_tmp39_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->autosave_manager;
	if (_tmp40_ != NULL) {
		AutosaveManager* _tmp41_;
		_tmp41_ = self->priv->autosave_manager;
		autosave_manager_cleanup (_tmp41_);
	}
	result = TRUE;
	_g_free0 (device);
	return result;
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, UserInterface* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	user_interface_on_quit (self);
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->window_is_maximized;
	if (!_tmp0_) {
		GdkEventConfigure _tmp1_;
		gint _tmp2_;
		GdkEventConfigure _tmp3_;
		gint _tmp4_;
		_tmp1_ = *event;
		_tmp2_ = _tmp1_.width;
		self->priv->window_width = _tmp2_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.height;
		self->priv->window_height = _tmp4_;
	}
	result = FALSE;
	return result;
}


static void user_interface_info_bar_response_cb (UserInterface* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == 1) {
		GtkComboBox* _tmp1_;
		GtkDialog* _tmp2_;
		_tmp1_ = self->priv->device_combo;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp2_);
	} else {
		self->priv->have_error = FALSE;
		_g_free0 (self->priv->error_title);
		self->priv->error_title = NULL;
		_g_free0 (self->priv->error_text);
		self->priv->error_text = NULL;
		user_interface_update_info_bar (self);
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, UserInterface* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_;
	GdkWindowState _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_;
		GdkWindowState _tmp3_;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, UserInterface* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = user_interface_on_quit (self);
	result = !_tmp0_;
	return result;
}


static void user_interface_page_size_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_width (_tmp0_);
	self->priv->default_page_width = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_height (_tmp2_);
	self->priv->default_page_height = _tmp3_;
	_tmp4_ = page;
	_tmp5_ = page_get_dpi (_tmp4_);
	self->priv->default_page_dpi = _tmp5_;
}


static void user_interface_page_scan_direction_changed_cb (UserInterface* self, Page* page) {
	Page* _tmp0_;
	ScanDirection _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_scan_direction (_tmp0_);
	self->priv->default_page_scan_direction = _tmp1_;
}


static void _user_interface_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
	user_interface_page_size_changed_cb (self, _sender);
}


static void _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
	user_interface_page_scan_direction_changed_cb (self, _sender);
}


static void user_interface_page_added_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
	Page* _tmp6_;
	ScanDirection _tmp7_ = 0;
	Page* _tmp8_;
	Page* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_width (_tmp0_);
	self->priv->default_page_width = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_height (_tmp2_);
	self->priv->default_page_height = _tmp3_;
	_tmp4_ = page;
	_tmp5_ = page_get_dpi (_tmp4_);
	self->priv->default_page_dpi = _tmp5_;
	_tmp6_ = page;
	_tmp7_ = page_get_scan_direction (_tmp6_);
	self->priv->default_page_scan_direction = _tmp7_;
	_tmp8_ = page;
	g_signal_connect (_tmp8_, "size-changed", (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
	_tmp9_ = page;
	g_signal_connect (_tmp9_, "scan-direction-changed", (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
	user_interface_update_page_menu (self);
}


static void user_interface_page_removed_cb (UserInterface* self, Book* book, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Book* _tmp4_;
	guint _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_size_changed_cb_page_size_changed, self);
	_tmp2_ = page;
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_scan_direction_changed_cb_page_scan_direction_changed, self);
	_tmp4_ = book;
	_tmp5_ = book_get_n_pages (_tmp4_);
	if (_tmp5_ == ((guint) 1)) {
		user_interface_add_default_page (self);
	}
	user_interface_update_page_menu (self);
}


static void user_interface_set_dpi_combo (UserInterface* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp1_;
	GtkCellRendererText* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkCellRendererText* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_ = NULL;
	GtkListStore* _tmp7_;
	GtkListStore* model;
	gint* _tmp8_ = NULL;
	gint* scan_resolutions;
	gint scan_resolutions_length1;
	gint _scan_resolutions_size_;
	gint* _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp0_);
	renderer = _tmp0_;
	_tmp1_ = combo;
	_tmp2_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp1_, (GtkCellRenderer*) _tmp2_, TRUE);
	_tmp3_ = combo;
	_tmp4_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) _tmp4_, "text", 1);
	_tmp5_ = combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_LIST_STORE, GtkListStore));
	model = _tmp7_;
	_tmp8_ = g_new0 (gint, 6);
	_tmp8_[0] = 75;
	_tmp8_[1] = 150;
	_tmp8_[2] = 300;
	_tmp8_[3] = 600;
	_tmp8_[4] = 1200;
	_tmp8_[5] = 2400;
	scan_resolutions = _tmp8_;
	scan_resolutions_length1 = 6;
	_scan_resolutions_size_ = scan_resolutions_length1;
	_tmp9_ = scan_resolutions;
	_tmp9__length1 = scan_resolutions_length1;
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
		dpi_collection = _tmp9_;
		dpi_collection_length1 = _tmp9__length1;
		for (dpi_it = 0; dpi_it < _tmp9__length1; dpi_it = dpi_it + 1) {
			gint dpi = 0;
			dpi = dpi_collection[dpi_it];
			{
				gchar* label = NULL;
				gint _tmp10_;
				gint _tmp11_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp26_;
				GtkTreeIter _tmp27_ = {0};
				GtkListStore* _tmp28_;
				GtkTreeIter _tmp29_;
				gint _tmp30_;
				const gchar* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				_tmp10_ = dpi;
				_tmp11_ = default_dpi;
				if (_tmp10_ == _tmp11_) {
					const gchar* _tmp12_ = NULL;
					gint _tmp13_;
					gchar* _tmp14_ = NULL;
					_tmp12_ = _ ("%d dpi (default)");
					_tmp13_ = dpi;
					_tmp14_ = g_strdup_printf (_tmp12_, _tmp13_);
					_g_free0 (label);
					label = _tmp14_;
				} else {
					gint _tmp15_;
					_tmp15_ = dpi;
					if (_tmp15_ == 75) {
						const gchar* _tmp16_ = NULL;
						gint _tmp17_;
						gchar* _tmp18_ = NULL;
						_tmp16_ = _ ("%d dpi (draft)");
						_tmp17_ = dpi;
						_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
						_g_free0 (label);
						label = _tmp18_;
					} else {
						gint _tmp19_;
						_tmp19_ = dpi;
						if (_tmp19_ == 1200) {
							const gchar* _tmp20_ = NULL;
							gint _tmp21_;
							gchar* _tmp22_ = NULL;
							_tmp20_ = _ ("%d dpi (high resolution)");
							_tmp21_ = dpi;
							_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
							_g_free0 (label);
							label = _tmp22_;
						} else {
							const gchar* _tmp23_ = NULL;
							gint _tmp24_;
							gchar* _tmp25_ = NULL;
							_tmp23_ = _ ("%d dpi");
							_tmp24_ = dpi;
							_tmp25_ = g_strdup_printf (_tmp23_, _tmp24_);
							_g_free0 (label);
							label = _tmp25_;
						}
					}
				}
				_tmp26_ = model;
				gtk_list_store_append (_tmp26_, &_tmp27_);
				iter = _tmp27_;
				_tmp28_ = model;
				_tmp29_ = iter;
				_tmp30_ = dpi;
				_tmp31_ = label;
				gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, 1, _tmp31_, -1, -1);
				_tmp32_ = dpi;
				_tmp33_ = current_dpi;
				if (_tmp32_ == _tmp33_) {
					GtkComboBox* _tmp34_;
					GtkTreeIter _tmp35_;
					_tmp34_ = combo;
					_tmp35_ = iter;
					gtk_combo_box_set_active_iter (_tmp34_, &_tmp35_);
				}
				_g_free0 (label);
			}
		}
	}
	scan_resolutions = (g_free (scan_resolutions), NULL);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
}


static void user_interface_needs_saving_cb (UserInterface* self, Book* book) {
	GtkMenuItem* _tmp0_;
	Book* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkToolButton* _tmp3_;
	Book* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Book* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = self->priv->save_menuitem;
	_tmp1_ = book;
	_tmp2_ = book_get_needs_saving (_tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
	_tmp3_ = self->priv->save_toolbutton;
	_tmp4_ = book;
	_tmp5_ = book_get_needs_saving (_tmp4_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
	_tmp6_ = book;
	_tmp7_ = book_get_needs_saving (_tmp6_);
	if (_tmp7_) {
		GtkMenuItem* _tmp8_;
		_tmp8_ = self->priv->save_as_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
	}
}


static void _user_interface_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	user_interface_info_bar_response_cb (self, _sender, response_id);
}


static void _user_interface_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
	user_interface_page_selected_cb (self, _sender, page);
}


static void _user_interface_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
	user_interface_show_page_cb (self, _sender, page);
}


static void _user_interface_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
	user_interface_show_page_menu_cb (self, _sender);
}


static void _user_interface_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
	user_interface_needs_saving_cb (self, _sender);
}


static void _user_interface_book_saving_cb_book_saving (Book* _sender, gint i, gpointer self) {
	user_interface_book_saving_cb (self, i);
}


static void user_interface_load (UserInterface* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkBuilder* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	GtkBuilder* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkWindow* _tmp11_;
	GApplication* _tmp12_ = NULL;
	GtkApplication* _tmp13_;
	GtkApplication* app;
	GtkApplication* _tmp14_;
	GtkWindow* _tmp15_;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_ = NULL;
	GtkVBox* _tmp18_;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkMenuItem* _tmp21_;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkMenuItem* _tmp27_;
	GtkBuilder* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkMenuItem* _tmp30_;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkMenuItem* _tmp33_;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_ = NULL;
	GtkMenuItem* _tmp36_;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkToolButton* _tmp39_;
	GtkBuilder* _tmp40_;
	GObject* _tmp41_ = NULL;
	GtkMenuItem* _tmp42_;
	GtkBuilder* _tmp43_;
	GObject* _tmp44_ = NULL;
	GtkToolButton* _tmp45_;
	GtkBuilder* _tmp46_;
	GObject* _tmp47_ = NULL;
	GtkRadioMenuItem* _tmp48_;
	GtkBuilder* _tmp49_;
	GObject* _tmp50_ = NULL;
	GtkRadioMenuItem* _tmp51_;
	GtkBuilder* _tmp52_;
	GObject* _tmp53_ = NULL;
	GtkRadioMenuItem* _tmp54_;
	GtkBuilder* _tmp55_;
	GObject* _tmp56_ = NULL;
	GtkRadioMenuItem* _tmp57_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_ = NULL;
	GtkDialog* _tmp60_;
	GtkBuilder* _tmp61_;
	GObject* _tmp62_ = NULL;
	GtkLabel* _tmp63_;
	GtkBuilder* _tmp64_;
	GObject* _tmp65_ = NULL;
	GtkEntry* _tmp66_;
	GtkBuilder* _tmp67_;
	GObject* _tmp68_ = NULL;
	GtkEntry* _tmp69_;
	GtkBuilder* _tmp70_;
	GObject* _tmp71_ = NULL;
	GtkDialog* _tmp72_;
	GtkBuilder* _tmp73_;
	GObject* _tmp74_ = NULL;
	GtkComboBox* _tmp75_;
	GtkComboBox* _tmp76_;
	GtkTreeModel* _tmp77_ = NULL;
	GtkListStore* _tmp78_;
	GtkBuilder* _tmp79_;
	GObject* _tmp80_ = NULL;
	GtkComboBox* _tmp81_;
	GtkComboBox* _tmp82_;
	GtkTreeModel* _tmp83_ = NULL;
	GtkListStore* _tmp84_;
	GtkBuilder* _tmp85_;
	GObject* _tmp86_ = NULL;
	GtkComboBox* _tmp87_;
	GtkComboBox* _tmp88_;
	GtkTreeModel* _tmp89_ = NULL;
	GtkListStore* _tmp90_;
	GtkBuilder* _tmp91_;
	GObject* _tmp92_ = NULL;
	GtkComboBox* _tmp93_;
	GtkComboBox* _tmp94_;
	GtkTreeModel* _tmp95_ = NULL;
	GtkListStore* _tmp96_;
	GtkBuilder* _tmp97_;
	GObject* _tmp98_ = NULL;
	GtkComboBox* _tmp99_;
	GtkComboBox* _tmp100_;
	GtkTreeModel* _tmp101_ = NULL;
	GtkListStore* _tmp102_;
	GtkBuilder* _tmp103_;
	GObject* _tmp104_ = NULL;
	GtkScale* _tmp105_;
	GtkScale* _tmp106_;
	GtkAdjustment* _tmp107_ = NULL;
	GtkAdjustment* _tmp108_;
	GtkBuilder* _tmp109_;
	GObject* _tmp110_ = NULL;
	GtkScale* _tmp111_;
	GtkScale* _tmp112_;
	GtkAdjustment* _tmp113_ = NULL;
	GtkAdjustment* _tmp114_;
	GtkInfoBar* _tmp115_;
	GtkInfoBar* _tmp116_;
	GtkVBox* _tmp117_;
	GtkInfoBar* _tmp118_;
	GtkBox* _tmp119_;
	GtkBox* hbox;
	GtkInfoBar* _tmp120_;
	GtkContainer* _tmp121_ = NULL;
	GtkContainer* _tmp122_;
	GtkContainer* content_area;
	GtkContainer* _tmp123_;
	GtkBox* _tmp124_;
	GtkBox* _tmp125_;
	GtkImage* _tmp126_;
	GtkBox* _tmp127_;
	GtkImage* _tmp128_;
	GtkImage* _tmp129_;
	GtkLabel* _tmp130_;
	GtkLabel* _tmp131_;
	GtkBox* _tmp132_;
	GtkLabel* _tmp133_;
	GtkLabel* _tmp134_;
	GtkInfoBar* _tmp135_;
	GtkButton* _tmp136_ = NULL;
	GtkButton* _tmp137_;
	GtkInfoBar* _tmp138_;
	const gchar* _tmp139_ = NULL;
	GtkButton* _tmp140_ = NULL;
	GtkButton* _tmp141_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp142_;
	GtkTreeIter _tmp143_ = {0};
	GtkListStore* _tmp144_;
	GtkTreeIter _tmp145_;
	const gchar* _tmp146_ = NULL;
	GtkListStore* _tmp147_;
	GtkTreeIter _tmp148_ = {0};
	GtkListStore* _tmp149_;
	GtkTreeIter _tmp150_;
	GtkListStore* _tmp151_;
	GtkTreeIter _tmp152_ = {0};
	GtkListStore* _tmp153_;
	GtkTreeIter _tmp154_;
	GtkListStore* _tmp155_;
	GtkTreeIter _tmp156_ = {0};
	GtkListStore* _tmp157_;
	GtkTreeIter _tmp158_;
	GtkListStore* _tmp159_;
	GtkTreeIter _tmp160_ = {0};
	GtkListStore* _tmp161_;
	GtkTreeIter _tmp162_;
	GtkListStore* _tmp163_;
	GtkTreeIter _tmp164_ = {0};
	GtkListStore* _tmp165_;
	GtkTreeIter _tmp166_;
	GtkListStore* _tmp167_;
	GtkTreeIter _tmp168_ = {0};
	GtkListStore* _tmp169_;
	GtkTreeIter _tmp170_;
	GSettings* _tmp171_;
	gint _tmp172_ = 0;
	gint dpi;
	gint _tmp173_;
	GtkComboBox* _tmp174_;
	gint _tmp175_;
	GSettings* _tmp176_;
	gint _tmp177_ = 0;
	gint _tmp178_;
	GtkComboBox* _tmp179_;
	gint _tmp180_;
	GtkCellRendererText* _tmp181_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp182_;
	GtkCellRendererText* _tmp183_;
	GtkComboBox* _tmp184_;
	GtkCellRendererText* _tmp185_;
	GtkCellRendererText* _tmp186_;
	GtkComboBox* _tmp187_;
	GtkCellRendererText* _tmp188_;
	GtkComboBox* _tmp189_;
	GtkCellRendererText* _tmp190_;
	GSettings* _tmp191_;
	gint _tmp192_ = 0;
	GtkCellRendererText* _tmp193_;
	GtkComboBox* _tmp194_;
	GtkCellRendererText* _tmp195_;
	GtkComboBox* _tmp196_;
	GtkCellRendererText* _tmp197_;
	GSettings* _tmp198_;
	gint _tmp199_ = 0;
	gint paper_width;
	GSettings* _tmp200_;
	gint _tmp201_ = 0;
	gint paper_height;
	gint _tmp202_;
	gint _tmp203_;
	GtkAdjustment* _tmp204_;
	gdouble _tmp205_ = 0.0;
	gdouble lower;
	const gchar* _tmp206_ = NULL;
	gchar* _tmp207_ = NULL;
	gchar* darker_label;
	GtkAdjustment* _tmp208_;
	gdouble _tmp209_ = 0.0;
	gdouble upper;
	const gchar* _tmp210_ = NULL;
	gchar* _tmp211_ = NULL;
	gchar* lighter_label;
	GtkScale* _tmp212_;
	gdouble _tmp213_;
	const gchar* _tmp214_;
	GtkScale* _tmp215_;
	GtkScale* _tmp216_;
	gdouble _tmp217_;
	const gchar* _tmp218_;
	GSettings* _tmp219_;
	gint _tmp220_ = 0;
	GtkAdjustment* _tmp221_;
	gdouble _tmp222_ = 0.0;
	const gchar* _tmp223_ = NULL;
	gchar* _tmp224_ = NULL;
	gchar* less_label;
	GtkAdjustment* _tmp225_;
	gdouble _tmp226_ = 0.0;
	const gchar* _tmp227_ = NULL;
	gchar* _tmp228_ = NULL;
	gchar* more_label;
	GtkScale* _tmp229_;
	gdouble _tmp230_;
	const gchar* _tmp231_;
	GtkScale* _tmp232_;
	GtkScale* _tmp233_;
	gdouble _tmp234_;
	const gchar* _tmp235_;
	GSettings* _tmp236_;
	gint _tmp237_ = 0;
	GSettings* _tmp238_;
	gchar* _tmp239_ = NULL;
	gchar* device;
	const gchar* _tmp240_;
	GSettings* _tmp246_;
	gchar* _tmp247_ = NULL;
	gchar* document_type;
	const gchar* _tmp248_;
	Book* _tmp250_;
	BookView* _tmp251_;
	BookView* _tmp252_;
	GtkVBox* _tmp253_;
	BookView* _tmp254_;
	BookView* _tmp255_;
	BookView* _tmp256_;
	BookView* _tmp257_;
	BookView* _tmp258_;
	GSettings* _tmp259_;
	gint _tmp260_ = 0;
	GSettings* _tmp261_;
	gint _tmp262_ = 0;
	gint _tmp263_;
	GSettings* _tmp264_;
	gint _tmp265_ = 0;
	gint _tmp266_;
	GSettings* _tmp267_;
	gint _tmp268_ = 0;
	gint _tmp269_;
	GSettings* _tmp270_;
	gint _tmp271_ = 0;
	gint _tmp272_;
	GSettings* _tmp273_;
	gint _tmp274_ = 0;
	gint _tmp275_;
	gint _tmp276_;
	gint _tmp277_;
	GtkWindow* _tmp278_;
	gint _tmp279_;
	gint _tmp280_;
	GSettings* _tmp281_;
	gboolean _tmp282_ = FALSE;
	gboolean _tmp283_;
	Book* _tmp285_;
	guint _tmp286_ = 0U;
	Book* _tmp287_;
	Book* _tmp288_;
	GtkWindow* _tmp289_;
	const gchar* _tmp290_ = NULL;
	ProgressBarDialog* _tmp291_;
	Book* _tmp292_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
	gtk_window_set_default_icon_name ("scanner");
	_tmp1_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp1_;
	_tmp2_ = g_build_filename (UI_DIR, "simple-scan.ui", NULL, NULL);
	filename = _tmp2_;
	{
		GtkBuilder* _tmp3_;
		_tmp3_ = self->priv->builder;
		gtk_builder_add_from_file (_tmp3_, filename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("ui.vala:1291: Unable to load UI %s: %s\n", filename, _tmp5_);
		_tmp6_ = _ ("Files missing");
		_tmp7_ = _ ("Please check your installation");
		user_interface_show_error_dialog (self, _tmp6_, _tmp7_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->builder;
	gtk_builder_connect_signals (_tmp8_, self);
	_tmp9_ = self->priv->builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "simple_scan_window");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_WINDOW, GtkWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp11_;
	_tmp12_ = g_application_get_default ();
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GTK_TYPE_APPLICATION) ? ((GtkApplication*) _tmp12_) : NULL);
	app = _tmp13_;
	_tmp14_ = app;
	_tmp15_ = self->priv->window;
	gtk_application_add_window (_tmp14_, _tmp15_);
	_tmp16_ = self->priv->builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "main_vbox");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GTK_TYPE_VBOX, GtkVBox));
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp18_;
	_tmp19_ = self->priv->builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "page_move_left_menuitem");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
	_g_object_unref0 (self->priv->page_move_left_menuitem);
	self->priv->page_move_left_menuitem = _tmp21_;
	_tmp22_ = self->priv->builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "page_move_right_menuitem");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
	_g_object_unref0 (self->priv->page_move_right_menuitem);
	self->priv->page_move_right_menuitem = _tmp24_;
	_tmp25_ = self->priv->builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "page_delete_menuitem");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
	_g_object_unref0 (self->priv->page_delete_menuitem);
	self->priv->page_delete_menuitem = _tmp27_;
	_tmp28_ = self->priv->builder;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "crop_rotate_menuitem");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
	self->priv->crop_rotate_menuitem = _tmp30_;
	_tmp31_ = self->priv->builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "save_menuitem");
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
	_g_object_unref0 (self->priv->save_menuitem);
	self->priv->save_menuitem = _tmp33_;
	_tmp34_ = self->priv->builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "save_as_menuitem");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
	_g_object_unref0 (self->priv->save_as_menuitem);
	self->priv->save_as_menuitem = _tmp36_;
	_tmp37_ = self->priv->builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "save_toolbutton");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
	_g_object_unref0 (self->priv->save_toolbutton);
	self->priv->save_toolbutton = _tmp39_;
	_tmp40_ = self->priv->builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "stop_scan_menuitem");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GTK_TYPE_MENU_ITEM, GtkMenuItem));
	_g_object_unref0 (self->priv->stop_menuitem);
	self->priv->stop_menuitem = _tmp42_;
	_tmp43_ = self->priv->builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "stop_toolbutton");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
	_g_object_unref0 (self->priv->stop_toolbutton);
	self->priv->stop_toolbutton = _tmp45_;
	_tmp46_ = self->priv->builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "text_toolbutton_menuitem");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
	self->priv->text_toolbar_menuitem = _tmp48_;
	_tmp49_ = self->priv->builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "text_menuitem");
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
	_g_object_unref0 (self->priv->text_menu_menuitem);
	self->priv->text_menu_menuitem = _tmp51_;
	_tmp52_ = self->priv->builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "photo_toolbutton_menuitem");
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
	self->priv->photo_toolbar_menuitem = _tmp54_;
	_tmp55_ = self->priv->builder;
	_tmp56_ = gtk_builder_get_object (_tmp55_, "photo_menuitem");
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GTK_TYPE_RADIO_MENU_ITEM, GtkRadioMenuItem));
	_g_object_unref0 (self->priv->photo_menu_menuitem);
	self->priv->photo_menu_menuitem = _tmp57_;
	_tmp58_ = self->priv->builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "authorize_dialog");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GTK_TYPE_DIALOG, GtkDialog));
	_g_object_unref0 (self->priv->authorize_dialog);
	self->priv->authorize_dialog = _tmp60_;
	_tmp61_ = self->priv->builder;
	_tmp62_ = gtk_builder_get_object (_tmp61_, "authorize_label");
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, GTK_TYPE_LABEL, GtkLabel));
	_g_object_unref0 (self->priv->authorize_label);
	self->priv->authorize_label = _tmp63_;
	_tmp64_ = self->priv->builder;
	_tmp65_ = gtk_builder_get_object (_tmp64_, "username_entry");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, GTK_TYPE_ENTRY, GtkEntry));
	_g_object_unref0 (self->priv->username_entry);
	self->priv->username_entry = _tmp66_;
	_tmp67_ = self->priv->builder;
	_tmp68_ = gtk_builder_get_object (_tmp67_, "password_entry");
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, GTK_TYPE_ENTRY, GtkEntry));
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp69_;
	_tmp70_ = self->priv->builder;
	_tmp71_ = gtk_builder_get_object (_tmp70_, "preferences_dialog");
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GTK_TYPE_DIALOG, GtkDialog));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp72_;
	_tmp73_ = self->priv->builder;
	_tmp74_ = gtk_builder_get_object (_tmp73_, "device_combo");
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->device_combo);
	self->priv->device_combo = _tmp75_;
	_tmp76_ = self->priv->device_combo;
	_tmp77_ = gtk_combo_box_get_model (_tmp76_);
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, GTK_TYPE_LIST_STORE, GtkListStore));
	_g_object_unref0 (self->priv->device_model);
	self->priv->device_model = _tmp78_;
	_tmp79_ = self->priv->builder;
	_tmp80_ = gtk_builder_get_object (_tmp79_, "text_dpi_combo");
	_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->text_dpi_combo);
	self->priv->text_dpi_combo = _tmp81_;
	_tmp82_ = self->priv->text_dpi_combo;
	_tmp83_ = gtk_combo_box_get_model (_tmp82_);
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, GTK_TYPE_LIST_STORE, GtkListStore));
	_g_object_unref0 (self->priv->text_dpi_model);
	self->priv->text_dpi_model = _tmp84_;
	_tmp85_ = self->priv->builder;
	_tmp86_ = gtk_builder_get_object (_tmp85_, "photo_dpi_combo");
	_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->photo_dpi_combo);
	self->priv->photo_dpi_combo = _tmp87_;
	_tmp88_ = self->priv->photo_dpi_combo;
	_tmp89_ = gtk_combo_box_get_model (_tmp88_);
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, GTK_TYPE_LIST_STORE, GtkListStore));
	_g_object_unref0 (self->priv->photo_dpi_model);
	self->priv->photo_dpi_model = _tmp90_;
	_tmp91_ = self->priv->builder;
	_tmp92_ = gtk_builder_get_object (_tmp91_, "page_side_combo");
	_tmp93_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->page_side_combo);
	self->priv->page_side_combo = _tmp93_;
	_tmp94_ = self->priv->page_side_combo;
	_tmp95_ = gtk_combo_box_get_model (_tmp94_);
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, GTK_TYPE_LIST_STORE, GtkListStore));
	_g_object_unref0 (self->priv->page_side_model);
	self->priv->page_side_model = _tmp96_;
	_tmp97_ = self->priv->builder;
	_tmp98_ = gtk_builder_get_object (_tmp97_, "paper_size_combo");
	_tmp99_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, GTK_TYPE_COMBO_BOX, GtkComboBox));
	_g_object_unref0 (self->priv->paper_size_combo);
	self->priv->paper_size_combo = _tmp99_;
	_tmp100_ = self->priv->paper_size_combo;
	_tmp101_ = gtk_combo_box_get_model (_tmp100_);
	_tmp102_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, GTK_TYPE_LIST_STORE, GtkListStore));
	_g_object_unref0 (self->priv->paper_size_model);
	self->priv->paper_size_model = _tmp102_;
	_tmp103_ = self->priv->builder;
	_tmp104_ = gtk_builder_get_object (_tmp103_, "brightness_scale");
	_tmp105_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, GTK_TYPE_SCALE, GtkScale));
	_g_object_unref0 (self->priv->brightness_scale);
	self->priv->brightness_scale = _tmp105_;
	_tmp106_ = self->priv->brightness_scale;
	_tmp107_ = gtk_range_get_adjustment ((GtkRange*) _tmp106_);
	_tmp108_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
	_g_object_unref0 (self->priv->brightness_adjustment);
	self->priv->brightness_adjustment = _tmp108_;
	_tmp109_ = self->priv->builder;
	_tmp110_ = gtk_builder_get_object (_tmp109_, "contrast_scale");
	_tmp111_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, GTK_TYPE_SCALE, GtkScale));
	_g_object_unref0 (self->priv->contrast_scale);
	self->priv->contrast_scale = _tmp111_;
	_tmp112_ = self->priv->contrast_scale;
	_tmp113_ = gtk_range_get_adjustment ((GtkRange*) _tmp112_);
	_tmp114_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
	_g_object_unref0 (self->priv->contrast_adjustment);
	self->priv->contrast_adjustment = _tmp114_;
	_tmp115_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp115_);
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = _tmp115_;
	_tmp116_ = self->priv->info_bar;
	g_signal_connect (_tmp116_, "response", (GCallback) _user_interface_info_bar_response_cb_gtk_info_bar_response, self);
	_tmp117_ = self->priv->main_vbox;
	_tmp118_ = self->priv->info_bar;
	gtk_box_pack_start ((GtkBox*) _tmp117_, (GtkWidget*) _tmp118_, FALSE, TRUE, (guint) 0);
	_tmp119_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp119_);
	hbox = _tmp119_;
	_tmp120_ = self->priv->info_bar;
	_tmp121_ = gtk_info_bar_get_content_area (_tmp120_);
	_tmp122_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, GTK_TYPE_CONTAINER, GtkContainer));
	content_area = _tmp122_;
	_tmp123_ = content_area;
	_tmp124_ = hbox;
	gtk_container_add (_tmp123_, (GtkWidget*) _tmp124_);
	_tmp125_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp125_);
	_tmp126_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp126_);
	_g_object_unref0 (self->priv->info_bar_image);
	self->priv->info_bar_image = _tmp126_;
	_tmp127_ = hbox;
	_tmp128_ = self->priv->info_bar_image;
	gtk_box_pack_start (_tmp127_, (GtkWidget*) _tmp128_, FALSE, TRUE, (guint) 0);
	_tmp129_ = self->priv->info_bar_image;
	gtk_widget_show ((GtkWidget*) _tmp129_);
	_tmp130_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp130_);
	_g_object_unref0 (self->priv->info_bar_label);
	self->priv->info_bar_label = _tmp130_;
	_tmp131_ = self->priv->info_bar_label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp131_, 0.0f, 0.5f);
	_tmp132_ = hbox;
	_tmp133_ = self->priv->info_bar_label;
	gtk_box_pack_start (_tmp132_, (GtkWidget*) _tmp133_, TRUE, TRUE, (guint) 0);
	_tmp134_ = self->priv->info_bar_label;
	gtk_widget_show ((GtkWidget*) _tmp134_);
	_tmp135_ = self->priv->info_bar;
	_tmp136_ = gtk_info_bar_add_button (_tmp135_, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	_tmp137_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, GTK_TYPE_BUTTON, GtkButton));
	_g_object_unref0 (self->priv->info_bar_close_button);
	self->priv->info_bar_close_button = _tmp137_;
	_tmp138_ = self->priv->info_bar;
	_tmp139_ = _ ("Change _Scanner");
	_tmp140_ = gtk_info_bar_add_button (_tmp138_, _tmp139_, 1);
	_tmp141_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, GTK_TYPE_BUTTON, GtkButton));
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
	self->priv->info_bar_change_scanner_button = _tmp141_;
	_tmp142_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp142_, &_tmp143_);
	iter = _tmp143_;
	_tmp144_ = self->priv->paper_size_model;
	_tmp145_ = iter;
	_tmp146_ = _ ("Automatic");
	gtk_list_store_set (_tmp144_, &_tmp145_, 0, 0, 1, 0, 2, _tmp146_, -1, -1);
	_tmp147_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp147_, &_tmp148_);
	iter = _tmp148_;
	_tmp149_ = self->priv->paper_size_model;
	_tmp150_ = iter;
	gtk_list_store_set (_tmp149_, &_tmp150_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
	_tmp151_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp151_, &_tmp152_);
	iter = _tmp152_;
	_tmp153_ = self->priv->paper_size_model;
	_tmp154_ = iter;
	gtk_list_store_set (_tmp153_, &_tmp154_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
	_tmp155_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp155_, &_tmp156_);
	iter = _tmp156_;
	_tmp157_ = self->priv->paper_size_model;
	_tmp158_ = iter;
	gtk_list_store_set (_tmp157_, &_tmp158_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
	_tmp159_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp159_, &_tmp160_);
	iter = _tmp160_;
	_tmp161_ = self->priv->paper_size_model;
	_tmp162_ = iter;
	gtk_list_store_set (_tmp161_, &_tmp162_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
	_tmp163_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp163_, &_tmp164_);
	iter = _tmp164_;
	_tmp165_ = self->priv->paper_size_model;
	_tmp166_ = iter;
	gtk_list_store_set (_tmp165_, &_tmp166_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
	_tmp167_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp167_, &_tmp168_);
	iter = _tmp168_;
	_tmp169_ = self->priv->paper_size_model;
	_tmp170_ = iter;
	gtk_list_store_set (_tmp169_, &_tmp170_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
	_tmp171_ = self->priv->settings;
	_tmp172_ = g_settings_get_int (_tmp171_, "text-dpi");
	dpi = _tmp172_;
	_tmp173_ = dpi;
	if (_tmp173_ <= 0) {
		dpi = USER_INTERFACE_DEFAULT_TEXT_DPI;
	}
	_tmp174_ = self->priv->text_dpi_combo;
	_tmp175_ = dpi;
	user_interface_set_dpi_combo (self, _tmp174_, USER_INTERFACE_DEFAULT_TEXT_DPI, _tmp175_);
	_tmp176_ = self->priv->settings;
	_tmp177_ = g_settings_get_int (_tmp176_, "photo-dpi");
	dpi = _tmp177_;
	_tmp178_ = dpi;
	if (_tmp178_ <= 0) {
		dpi = USER_INTERFACE_DEFAULT_PHOTO_DPI;
	}
	_tmp179_ = self->priv->photo_dpi_combo;
	_tmp180_ = dpi;
	user_interface_set_dpi_combo (self, _tmp179_, USER_INTERFACE_DEFAULT_PHOTO_DPI, _tmp180_);
	_tmp181_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp181_);
	renderer = _tmp181_;
	_tmp182_ = self->priv->device_combo;
	_tmp183_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp182_, (GtkCellRenderer*) _tmp183_, TRUE);
	_tmp184_ = self->priv->device_combo;
	_tmp185_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp184_, (GtkCellRenderer*) _tmp185_, "text", 1);
	_tmp186_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp186_);
	_g_object_unref0 (renderer);
	renderer = _tmp186_;
	_tmp187_ = self->priv->page_side_combo;
	_tmp188_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp187_, (GtkCellRenderer*) _tmp188_, TRUE);
	_tmp189_ = self->priv->page_side_combo;
	_tmp190_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp189_, (GtkCellRenderer*) _tmp190_, "text", 1);
	_tmp191_ = self->priv->settings;
	_tmp192_ = g_settings_get_enum (_tmp191_, "page-side");
	user_interface_set_page_side (self, (ScanType) _tmp192_);
	_tmp193_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp193_);
	_g_object_unref0 (renderer);
	renderer = _tmp193_;
	_tmp194_ = self->priv->paper_size_combo;
	_tmp195_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp194_, (GtkCellRenderer*) _tmp195_, TRUE);
	_tmp196_ = self->priv->paper_size_combo;
	_tmp197_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp196_, (GtkCellRenderer*) _tmp197_, "text", 2);
	_tmp198_ = self->priv->settings;
	_tmp199_ = g_settings_get_int (_tmp198_, "paper-width");
	paper_width = _tmp199_;
	_tmp200_ = self->priv->settings;
	_tmp201_ = g_settings_get_int (_tmp200_, "paper-height");
	paper_height = _tmp201_;
	_tmp202_ = paper_width;
	_tmp203_ = paper_height;
	user_interface_set_paper_size (self, _tmp202_, _tmp203_);
	_tmp204_ = self->priv->brightness_adjustment;
	_tmp205_ = gtk_adjustment_get_lower (_tmp204_);
	lower = _tmp205_;
	_tmp206_ = _ ("Darker");
	_tmp207_ = g_strdup_printf ("<small>%s</small>", _tmp206_);
	darker_label = _tmp207_;
	_tmp208_ = self->priv->brightness_adjustment;
	_tmp209_ = gtk_adjustment_get_upper (_tmp208_);
	upper = _tmp209_;
	_tmp210_ = _ ("Lighter");
	_tmp211_ = g_strdup_printf ("<small>%s</small>", _tmp210_);
	lighter_label = _tmp211_;
	_tmp212_ = self->priv->brightness_scale;
	_tmp213_ = lower;
	_tmp214_ = darker_label;
	gtk_scale_add_mark (_tmp212_, _tmp213_, GTK_POS_BOTTOM, _tmp214_);
	_tmp215_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp215_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp216_ = self->priv->brightness_scale;
	_tmp217_ = upper;
	_tmp218_ = lighter_label;
	gtk_scale_add_mark (_tmp216_, _tmp217_, GTK_POS_BOTTOM, _tmp218_);
	_tmp219_ = self->priv->settings;
	_tmp220_ = g_settings_get_int (_tmp219_, "brightness");
	user_interface_set_brightness (self, _tmp220_);
	_tmp221_ = self->priv->contrast_adjustment;
	_tmp222_ = gtk_adjustment_get_lower (_tmp221_);
	lower = _tmp222_;
	_tmp223_ = _ ("Less");
	_tmp224_ = g_strdup_printf ("<small>%s</small>", _tmp223_);
	less_label = _tmp224_;
	_tmp225_ = self->priv->contrast_adjustment;
	_tmp226_ = gtk_adjustment_get_upper (_tmp225_);
	upper = _tmp226_;
	_tmp227_ = _ ("More");
	_tmp228_ = g_strdup_printf ("<small>%s</small>", _tmp227_);
	more_label = _tmp228_;
	_tmp229_ = self->priv->contrast_scale;
	_tmp230_ = lower;
	_tmp231_ = less_label;
	gtk_scale_add_mark (_tmp229_, _tmp230_, GTK_POS_BOTTOM, _tmp231_);
	_tmp232_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp232_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp233_ = self->priv->contrast_scale;
	_tmp234_ = upper;
	_tmp235_ = more_label;
	gtk_scale_add_mark (_tmp233_, _tmp234_, GTK_POS_BOTTOM, _tmp235_);
	_tmp236_ = self->priv->settings;
	_tmp237_ = g_settings_get_int (_tmp236_, "contrast");
	user_interface_set_contrast (self, _tmp237_);
	_tmp238_ = self->priv->settings;
	_tmp239_ = g_settings_get_string (_tmp238_, "selected-device");
	device = _tmp239_;
	_tmp240_ = device;
	if (_tmp240_ != NULL) {
		const gchar* _tmp241_;
		GtkTreeIter _tmp242_ = {0};
		gboolean _tmp243_ = FALSE;
		_tmp241_ = device;
		_tmp243_ = user_interface_find_scan_device (self, _tmp241_, &_tmp242_);
		iter = _tmp242_;
		if (_tmp243_) {
			GtkComboBox* _tmp244_;
			GtkTreeIter _tmp245_;
			_tmp244_ = self->priv->device_combo;
			_tmp245_ = iter;
			gtk_combo_box_set_active_iter (_tmp244_, &_tmp245_);
		}
	}
	_tmp246_ = self->priv->settings;
	_tmp247_ = g_settings_get_string (_tmp246_, "document-type");
	document_type = _tmp247_;
	_tmp248_ = document_type;
	if (_tmp248_ != NULL) {
		const gchar* _tmp249_;
		_tmp249_ = document_type;
		user_interface_set_document_hint (self, _tmp249_);
	}
	_tmp250_ = self->priv->book;
	_tmp251_ = book_view_new (_tmp250_);
	g_object_ref_sink (_tmp251_);
	_g_object_unref0 (self->priv->book_view);
	self->priv->book_view = _tmp251_;
	_tmp252_ = self->priv->book_view;
	gtk_container_set_border_width ((GtkContainer*) _tmp252_, (guint) 18);
	_tmp253_ = self->priv->main_vbox;
	_tmp254_ = self->priv->book_view;
	gtk_box_pack_end ((GtkBox*) _tmp253_, (GtkWidget*) _tmp254_, TRUE, TRUE, (guint) 0);
	_tmp255_ = self->priv->book_view;
	g_signal_connect (_tmp255_, "page-selected", (GCallback) _user_interface_page_selected_cb_book_view_page_selected, self);
	_tmp256_ = self->priv->book_view;
	g_signal_connect (_tmp256_, "show-page", (GCallback) _user_interface_show_page_cb_book_view_show_page, self);
	_tmp257_ = self->priv->book_view;
	g_signal_connect (_tmp257_, "show-menu", (GCallback) _user_interface_show_page_menu_cb_book_view_show_menu, self);
	_tmp258_ = self->priv->book_view;
	gtk_widget_show ((GtkWidget*) _tmp258_);
	_tmp259_ = self->priv->settings;
	_tmp260_ = g_settings_get_enum (_tmp259_, "scan-direction");
	self->priv->default_page_scan_direction = (ScanDirection) _tmp260_;
	_tmp261_ = self->priv->settings;
	_tmp262_ = g_settings_get_int (_tmp261_, "page-width");
	self->priv->default_page_width = _tmp262_;
	_tmp263_ = self->priv->default_page_width;
	if (_tmp263_ <= 0) {
		self->priv->default_page_width = 595;
	}
	_tmp264_ = self->priv->settings;
	_tmp265_ = g_settings_get_int (_tmp264_, "page-height");
	self->priv->default_page_height = _tmp265_;
	_tmp266_ = self->priv->default_page_height;
	if (_tmp266_ <= 0) {
		self->priv->default_page_height = 842;
	}
	_tmp267_ = self->priv->settings;
	_tmp268_ = g_settings_get_int (_tmp267_, "page-dpi");
	self->priv->default_page_dpi = _tmp268_;
	_tmp269_ = self->priv->default_page_dpi;
	if (_tmp269_ <= 0) {
		self->priv->default_page_dpi = 72;
	}
	_tmp270_ = self->priv->settings;
	_tmp271_ = g_settings_get_int (_tmp270_, "window-width");
	self->priv->window_width = _tmp271_;
	_tmp272_ = self->priv->window_width;
	if (_tmp272_ <= 0) {
		self->priv->window_width = 600;
	}
	_tmp273_ = self->priv->settings;
	_tmp274_ = g_settings_get_int (_tmp273_, "window-height");
	self->priv->window_height = _tmp274_;
	_tmp275_ = self->priv->window_height;
	if (_tmp275_ <= 0) {
		self->priv->window_height = 400;
	}
	_tmp276_ = self->priv->window_width;
	_tmp277_ = self->priv->window_height;
	g_debug ("ui.vala:1461: Restoring window to %dx%d pixels", _tmp276_, _tmp277_);
	_tmp278_ = self->priv->window;
	_tmp279_ = self->priv->window_width;
	_tmp280_ = self->priv->window_height;
	gtk_window_set_default_size (_tmp278_, _tmp279_, _tmp280_);
	_tmp281_ = self->priv->settings;
	_tmp282_ = g_settings_get_boolean (_tmp281_, "window-is-maximized");
	self->priv->window_is_maximized = _tmp282_;
	_tmp283_ = self->priv->window_is_maximized;
	if (_tmp283_) {
		GtkWindow* _tmp284_;
		g_debug ("ui.vala:1466: Restoring window to maximized");
		_tmp284_ = self->priv->window;
		gtk_window_maximize (_tmp284_);
	}
	_tmp285_ = self->priv->book;
	_tmp286_ = book_get_n_pages (_tmp285_);
	if (_tmp286_ == ((guint) 0)) {
		user_interface_add_default_page (self);
	}
	_tmp287_ = self->priv->book;
	book_set_needs_saving (_tmp287_, FALSE);
	_tmp288_ = self->priv->book;
	g_signal_connect (_tmp288_, "needs-saving-changed", (GCallback) _user_interface_needs_saving_cb_book_needs_saving_changed, self);
	_tmp289_ = self->priv->window;
	_tmp290_ = _ ("Saving document...");
	_tmp291_ = progress_bar_dialog_new (_tmp289_, _tmp290_);
	g_object_ref_sink (_tmp291_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = _tmp291_;
	_tmp292_ = self->priv->book;
	g_signal_connect (_tmp292_, "saving", (GCallback) _user_interface_book_saving_cb_book_saving, self);
	_g_free0 (document_type);
	_g_free0 (device);
	_g_free0 (more_label);
	_g_free0 (less_label);
	_g_free0 (lighter_label);
	_g_free0 (darker_label);
	_g_object_unref0 (renderer);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	_g_object_unref0 (app);
	_g_free0 (filename);
}


static gboolean ___lambda2_ (UserInterface* self) {
	gboolean result = FALSE;
	ProgressBarDialog* _tmp0_;
	_tmp0_ = self->priv->progress_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ____lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda2_ (self);
	return result;
}


static void user_interface_book_saving_cb (UserInterface* self, gint page_number) {
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	gint total;
	gint _tmp3_;
	gint _tmp4_;
	gdouble fraction;
	gdouble _tmp5_;
	gboolean complete;
	gboolean _tmp6_;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* message;
	ProgressBarDialog* _tmp11_;
	gdouble _tmp12_;
	ProgressBarDialog* _tmp13_;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		_tmp0_ = gtk_events_pending ();
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration ();
	}
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	total = (gint) _tmp2_;
	_tmp3_ = page_number;
	_tmp4_ = total;
	fraction = (_tmp3_ + 1.0) / _tmp4_;
	_tmp5_ = fraction;
	complete = _tmp5_ == 1.0;
	_tmp6_ = complete;
	if (_tmp6_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda2__gsource_func, user_interface_ref (self), user_interface_unref);
	}
	_tmp7_ = _ ("Saving page %d out of %d");
	_tmp8_ = page_number;
	_tmp9_ = total;
	_tmp10_ = g_strdup_printf (_tmp7_, _tmp8_ + 1, _tmp9_);
	message = _tmp10_;
	_tmp11_ = self->priv->progress_dialog;
	_tmp12_ = fraction;
	progress_bar_dialog_set_fraction (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->progress_dialog;
	progress_bar_dialog_set_message (_tmp13_, message);
	_g_free0 (message);
}


void user_interface_show_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_dialog;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


void user_interface_hide_progress_dialog (UserInterface* self) {
	ProgressBarDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static gpointer _book_ref0 (gpointer self) {
	return self ? book_ref (self) : NULL;
}


Book* user_interface_get_book (UserInterface* self) {
	Book* result = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = _book_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void user_interface_set_selected_page (UserInterface* self, Page* page) {
	BookView* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = page;
	book_view_select_page (_tmp0_, _tmp1_);
}


Page* user_interface_get_selected_page (UserInterface* self) {
	Page* result = NULL;
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	result = _tmp1_;
	return result;
}


void user_interface_set_scanning (UserInterface* self, gboolean scanning) {
	gboolean _tmp0_;
	GtkMenuItem* _tmp1_;
	gboolean _tmp2_;
	GtkMenuItem* _tmp3_;
	gboolean _tmp4_;
	GtkToolButton* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = scanning;
	self->priv->scanning = _tmp0_;
	_tmp1_ = self->priv->page_delete_menuitem;
	_tmp2_ = scanning;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
	_tmp3_ = self->priv->stop_menuitem;
	_tmp4_ = scanning;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->stop_toolbutton;
	_tmp6_ = scanning;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
}


void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	self->priv->have_error = TRUE;
	_tmp0_ = error_title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->error_title);
	self->priv->error_title = _tmp1_;
	_tmp2_ = error_text;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->error_text);
	self->priv->error_text = _tmp3_;
	_tmp4_ = change_scanner_hint;
	self->priv->error_change_scanner_hint = _tmp4_;
	user_interface_update_info_bar (self);
}


void user_interface_start (UserInterface* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
}


static void value_user_interface_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_user_interface_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		user_interface_unref (value->data[0].v_pointer);
	}
}


static void value_user_interface_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = user_interface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_user_interface_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_user_interface_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UserInterface* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = user_interface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_user_interface_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UserInterface** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = user_interface_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUserInterface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_USER_INTERFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_user_interface (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE), NULL);
	return value->data[0].v_pointer;
}


void value_set_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		user_interface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		user_interface_unref (old);
	}
}


void value_take_user_interface (GValue* value, gpointer v_object) {
	UserInterface* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_INTERFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_INTERFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		user_interface_unref (old);
	}
}


static void user_interface_class_init (UserInterfaceClass * klass) {
	user_interface_parent_class = g_type_class_peek_parent (klass);
	USER_INTERFACE_CLASS (klass)->finalize = user_interface_finalize;
	g_type_class_add_private (klass, sizeof (UserInterfacePrivate));
	g_signal_new ("start_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
	g_signal_new ("stop_scan", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("email", TYPE_USER_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void user_interface_instance_init (UserInterface * self) {
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self->priv = USER_INTERFACE_GET_PRIVATE (self);
	self->priv->book_uri = NULL;
	_tmp0_ = g_strdup ("photo");
	self->priv->document_hint = _tmp0_;
	_tmp1_ = _ ("Scanned Document.pdf");
	_tmp2_ = g_strdup (_tmp1_);
	self->priv->default_file_name = _tmp2_;
	self->priv->scanning = FALSE;
	self->ref_count = 1;
}


static void user_interface_finalize (UserInterface* obj) {
	UserInterface * self;
	Book* _tmp0_;
	guint _tmp1_ = 0U;
	Book* _tmp2_;
	guint _tmp3_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INTERFACE, UserInterface);
	_tmp0_ = self->priv->book;
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _user_interface_page_removed_cb_book_page_removed, self);
	_tmp2_ = self->priv->book;
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _user_interface_page_added_cb_book_page_added, self);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->info_bar_image);
	_g_object_unref0 (self->priv->info_bar_label);
	_g_object_unref0 (self->priv->info_bar_close_button);
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
	_g_object_unref0 (self->priv->page_move_left_menuitem);
	_g_object_unref0 (self->priv->page_move_right_menuitem);
	_g_object_unref0 (self->priv->page_delete_menuitem);
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
	_g_object_unref0 (self->priv->save_menuitem);
	_g_object_unref0 (self->priv->save_as_menuitem);
	_g_object_unref0 (self->priv->save_toolbutton);
	_g_object_unref0 (self->priv->stop_menuitem);
	_g_object_unref0 (self->priv->stop_toolbutton);
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
	_g_object_unref0 (self->priv->text_menu_menuitem);
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
	_g_object_unref0 (self->priv->photo_menu_menuitem);
	_g_object_unref0 (self->priv->authorize_dialog);
	_g_object_unref0 (self->priv->authorize_label);
	_g_object_unref0 (self->priv->username_entry);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->device_combo);
	_g_object_unref0 (self->priv->text_dpi_combo);
	_g_object_unref0 (self->priv->photo_dpi_combo);
	_g_object_unref0 (self->priv->page_side_combo);
	_g_object_unref0 (self->priv->paper_size_combo);
	_g_object_unref0 (self->priv->brightness_scale);
	_g_object_unref0 (self->priv->contrast_scale);
	_g_object_unref0 (self->priv->device_model);
	_g_object_unref0 (self->priv->text_dpi_model);
	_g_object_unref0 (self->priv->photo_dpi_model);
	_g_object_unref0 (self->priv->page_side_model);
	_g_object_unref0 (self->priv->paper_size_model);
	_g_object_unref0 (self->priv->brightness_adjustment);
	_g_object_unref0 (self->priv->contrast_adjustment);
	_g_object_unref0 (self->priv->save_dialog);
	_g_object_unref0 (self->priv->progress_dialog);
	_g_free0 (self->priv->error_title);
	_g_free0 (self->priv->error_text);
	_book_unref0 (self->priv->book);
	_g_free0 (self->priv->book_uri);
	_autosave_manager_unref0 (self->priv->autosave_manager);
	_g_object_unref0 (self->priv->book_view);
	_g_free0 (self->priv->document_hint);
	_g_free0 (self->priv->default_file_name);
}


GType user_interface_get_type (void) {
	static volatile gsize user_interface_type_id__volatile = 0;
	if (g_once_init_enter (&user_interface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_user_interface_init, value_user_interface_free_value, value_user_interface_copy_value, value_user_interface_peek_pointer, "p", value_user_interface_collect_value, "p", value_user_interface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UserInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserInterface), 0, (GInstanceInitFunc) user_interface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType user_interface_type_id;
		user_interface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UserInterface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&user_interface_type_id__volatile, user_interface_type_id);
	}
	return user_interface_type_id__volatile;
}


gpointer user_interface_ref (gpointer instance) {
	UserInterface* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void user_interface_unref (gpointer instance) {
	UserInterface* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		USER_INTERFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ProgressBarDialog* progress_bar_dialog_construct (GType object_type, GtkWindow* parent, const gchar* title) {
	ProgressBarDialog * self = NULL;
	GtkProgressBar* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* hbox;
	GtkBox* _tmp2_;
	GtkBox* vbox;
	GtkProgressBar* _tmp3_;
	GtkProgressBar* _tmp4_;
	GtkProgressBar* _tmp5_;
	GtkProgressBar* _tmp6_;
	const gchar* _tmp7_;
	GtkWindow* _tmp8_;
	GtkProgressBar* _tmp9_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (ProgressBarDialog*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->bar);
	self->priv->bar = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp1_);
	hbox = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp2_);
	vbox = _tmp2_;
	gtk_widget_set_hexpand ((GtkWidget*) hbox, TRUE);
	_tmp3_ = self->priv->bar;
	gtk_progress_bar_set_text (_tmp3_, "");
	_tmp4_ = self->priv->bar;
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
	_tmp5_ = self->priv->bar;
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 225, 25);
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 50);
	_tmp6_ = self->priv->bar;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp6_, TRUE, FALSE, (guint) 0);
	gtk_box_pack_start (hbox, (GtkWidget*) vbox, TRUE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
	_tmp7_ = title;
	gtk_window_set_title ((GtkWindow*) self, _tmp7_);
	_tmp8_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp8_);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_widget_show ((GtkWidget*) hbox);
	gtk_widget_show ((GtkWidget*) vbox);
	_tmp9_ = self->priv->bar;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox);
	return self;
}


ProgressBarDialog* progress_bar_dialog_new (GtkWindow* parent, const gchar* title) {
	return progress_bar_dialog_construct (TYPE_PROGRESS_BAR_DIALOG, parent, title);
}


void progress_bar_dialog_set_fraction (ProgressBarDialog* self, gdouble percent) {
	GtkProgressBar* _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bar;
	_tmp1_ = percent;
	gtk_progress_bar_set_fraction (_tmp0_, _tmp1_);
}


void progress_bar_dialog_set_message (ProgressBarDialog* self, const gchar* message) {
	GtkProgressBar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->bar;
	_tmp1_ = message;
	gtk_progress_bar_set_text (_tmp0_, _tmp1_);
}


static void progress_bar_dialog_class_init (ProgressBarDialogClass * klass) {
	progress_bar_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ProgressBarDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = progress_bar_dialog_finalize;
}


static void progress_bar_dialog_instance_init (ProgressBarDialog * self) {
	self->priv = PROGRESS_BAR_DIALOG_GET_PRIVATE (self);
}


static void progress_bar_dialog_finalize (GObject* obj) {
	ProgressBarDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRESS_BAR_DIALOG, ProgressBarDialog);
	_g_object_unref0 (self->priv->bar);
	G_OBJECT_CLASS (progress_bar_dialog_parent_class)->finalize (obj);
}


GType progress_bar_dialog_get_type (void) {
	static volatile gsize progress_bar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&progress_bar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProgressBarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) progress_bar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgressBarDialog), 0, (GInstanceInitFunc) progress_bar_dialog_instance_init, NULL };
		GType progress_bar_dialog_type_id;
		progress_bar_dialog_type_id = g_type_register_static (GTK_TYPE_WINDOW, "ProgressBarDialog", &g_define_type_info, 0);
		g_once_init_leave (&progress_bar_dialog_type_id__volatile, progress_bar_dialog_type_id);
	}
	return progress_bar_dialog_type_id__volatile;
}


gchar* get_temporary_filename (const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = prefix;
	_tmp1_ = extension;
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
	filename = _tmp2_;
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint fd;
		gint _tmp6_;
		_tmp3_ = filename;
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
		_g_free0 (path);
		path = _tmp4_;
		fd = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_tmp6_ = fd;
		close (_tmp6_);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ui.vala:1604: Error saving email attachment: %s", _tmp8_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		_g_free0 (filename);
		return result;
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = path;
	_g_free0 (filename);
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



