/* tracker-backend.c generated by valac 0.22.1, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-bus/tracker-bus.h"


#define TRACKER_SPARQL_TYPE_BACKEND (tracker_sparql_backend_get_type ())
#define TRACKER_SPARQL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend))
#define TRACKER_SPARQL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))
#define TRACKER_SPARQL_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_BACKEND))
#define TRACKER_SPARQL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendClass))

typedef struct _TrackerSparqlBackend TrackerSparqlBackend;
typedef struct _TrackerSparqlBackendClass TrackerSparqlBackendClass;
typedef struct _TrackerSparqlBackendPrivate TrackerSparqlBackendPrivate;

#define TRACKER_SPARQL_BACKEND_TYPE_BACKEND (tracker_sparql_backend_backend_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlBackendQueryAsyncData TrackerSparqlBackendQueryAsyncData;
typedef struct _TrackerSparqlBackendUpdateAsyncData TrackerSparqlBackendUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateArrayAsyncData TrackerSparqlBackendUpdateArrayAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlBackendUpdateBlankAsyncData TrackerSparqlBackendUpdateBlankAsyncData;
typedef struct _TrackerSparqlBackendLoadAsyncData TrackerSparqlBackendLoadAsyncData;
typedef struct _TrackerSparqlBackendStatisticsAsyncData TrackerSparqlBackendStatisticsAsyncData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerSparqlBackendGetInternalAsyncData TrackerSparqlBackendGetInternalAsyncData;
typedef struct _TrackerSparqlConnectionGetAsyncData TrackerSparqlConnectionGetAsyncData;
typedef struct _TrackerSparqlConnectionGetDirectAsyncData TrackerSparqlConnectionGetDirectAsyncData;

struct _TrackerSparqlBackend {
	TrackerSparqlConnection parent_instance;
	TrackerSparqlBackendPrivate * priv;
};

struct _TrackerSparqlBackendClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerSparqlBackendPrivate {
	gboolean initialized;
	TrackerSparqlConnection* direct;
	TrackerSparqlConnection* bus;
};

typedef enum  {
	TRACKER_SPARQL_BACKEND_BACKEND_AUTO,
	TRACKER_SPARQL_BACKEND_BACKEND_DIRECT,
	TRACKER_SPARQL_BACKEND_BACKEND_BUS
} TrackerSparqlBackendBackend;

struct _TrackerSparqlBackendQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	const gchar* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	TrackerSparqlCursor* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlConnection* _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	GPtrArray* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	GCancellable* _tmp6_;
	GPtrArray* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	gint _tmp0_;
	const gchar* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError* _tmp3_;
	GVariant* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	GCancellable* _tmp8_;
	GVariant* _tmp9_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GFile* file;
	GCancellable* cancellable;
	gchar* uri;
	GFile* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GError* _tmp4_;
	TrackerSparqlConnection* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	GError * _inner_error_;
};

struct _TrackerSparqlBackendStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlBackend* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	GError* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	GCancellable* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* async_result;
};

struct _Block2Data {
	int _ref_count_;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	GError* spawn_error;
	TrackerSparqlConnection* _result_;
	GMainContext* context;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TrackerSparqlBackendGetInternalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	Block2Data* _data2_;
	GCancellable* _tmp0_;
	gboolean _tmp1_;
	TrackerSparqlConnection* _result_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	GMainContext* _tmp5_;
	GMainContext* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	TrackerSparqlConnection* _tmp19_;
	TrackerSparqlConnection* _tmp20_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError * _inner_error_;
};

struct _TrackerSparqlConnectionGetDirectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	GError * _inner_error_;
};


static gpointer tracker_sparql_backend_parent_class = NULL;
static TrackerSparqlConnection* tracker_sparql_backend_singleton;
static TrackerSparqlConnection* tracker_sparql_backend_singleton = NULL;
static gboolean tracker_sparql_backend_log_initialized;
static gboolean tracker_sparql_backend_log_initialized = FALSE;
static GMutex tracker_sparql_backend_door;
static GMutex tracker_sparql_backend_door = {0};

GType tracker_sparql_backend_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackendPrivate))
enum  {
	TRACKER_SPARQL_BACKEND_DUMMY_PROPERTY
};
static GType tracker_sparql_backend_backend_get_type (void) G_GNUC_UNUSED;
TrackerSparqlBackend* tracker_sparql_backend_new (GError** error);
TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error);
static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, GError** error);
static void tracker_sparql_backend_real_dispose (GObject* base);
static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_query_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_);
static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_update_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_);
static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_);
static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_);
static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_load_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_);
static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_);
static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable, GError** error);
static void tracker_sparql_backend_log_init (void);
TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void tracker_sparql_backend_get_internal_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error);
static void __lambda4_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data);
static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda2_ (Block2Data* _data2_, GIOSchedulerJob* job);
static gboolean __lambda3_ (Block2Data* _data2_);
static gboolean ___lambda3__gsource_func (gpointer self);
static gboolean ___lambda2__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self);
static void tracker_sparql_backend_remove_log_handler (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
static void _tracker_sparql_backend_remove_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void tracker_sparql_backend_finalize (GObject* obj);
static void tracker_sparql_connection_get_async_data_free (gpointer _data);
void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_);
static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_get_direct_async_data_free (gpointer _data);
void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_get_direct_async_co (TrackerSparqlConnectionGetDirectAsyncData* _data_);
static void tracker_sparql_connection_get_direct_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error);


static GType tracker_sparql_backend_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_backend_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_BACKEND_BACKEND_AUTO, "TRACKER_SPARQL_BACKEND_BACKEND_AUTO", "auto"}, {TRACKER_SPARQL_BACKEND_BACKEND_DIRECT, "TRACKER_SPARQL_BACKEND_BACKEND_DIRECT", "direct"}, {TRACKER_SPARQL_BACKEND_BACKEND_BUS, "TRACKER_SPARQL_BACKEND_BACKEND_BUS", "bus"}, {0, NULL, NULL}};
		GType tracker_sparql_backend_backend_type_id;
		tracker_sparql_backend_backend_type_id = g_enum_register_static ("TrackerSparqlBackendBackend", values);
		g_once_init_leave (&tracker_sparql_backend_backend_type_id__volatile, tracker_sparql_backend_backend_type_id);
	}
	return tracker_sparql_backend_backend_type_id__volatile;
}


TrackerSparqlBackend* tracker_sparql_backend_construct (GType object_type, GError** error) {
	TrackerSparqlBackend * self = NULL;
	GError * _inner_error_ = NULL;
#line 30 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) tracker_sparql_connection_construct (object_type);
#line 390 "tracker-backend.c"
	{
		GDBusConnection* bus = NULL;
		GDBusConnection* _tmp0_ = NULL;
		GDBusMessage* msg = NULL;
		GDBusMessage* _tmp1_ = NULL;
		GDBusMessage* _tmp2_ = NULL;
		GDBusConnection* _tmp3_ = NULL;
		GDBusMessage* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GDBusMessage* _tmp6_ = NULL;
		GDBusMessage* _tmp7_ = NULL;
#line 33 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:33: Waiting for service to become available...");
#line 37 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
#line 37 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		bus = _tmp0_;
#line 37 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 410 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 38 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = g_dbus_message_new_method_call (TRACKER_DBUS_SERVICE, TRACKER_DBUS_OBJECT_STATUS, TRACKER_DBUS_INTERFACE_STATUS, "Wait");
#line 38 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		msg = _tmp1_;
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = bus;
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = msg;
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = G_MAXINT;
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = g_dbus_connection_send_message_with_reply_sync (_tmp3_, _tmp4_, 0, _tmp5_, NULL, NULL, &_inner_error_);
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = _tmp6_;
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (msg);
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (bus);
#line 433 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = _tmp2_;
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_dbus_message_to_gerror (_tmp7_, &_inner_error_);
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_tmp7_);
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (msg);
#line 39 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (bus);
#line 448 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 41 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:41: Service is ready");
#line 43 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:43: Constructing connection");
#line 44 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_backend_load_plugins (self, &_inner_error_);
#line 44 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 44 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (msg);
#line 44 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (bus);
#line 463 "tracker-backend.c"
			goto __catch0_g_error;
		}
#line 45 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:45: Backend is ready");
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (msg);
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (bus);
#line 472 "tracker-backend.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e = _inner_error_;
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 47 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = e;
#line 47 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = _tmp8_->message;
#line 47 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp9_);
#line 47 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp10_;
#line 47 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e);
#line 495 "tracker-backend.c"
		goto __finally0;
	}
	__finally0:
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self);
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 509 "tracker-backend.c"
		} else {
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 31 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 517 "tracker-backend.c"
		}
	}
#line 50 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->initialized = TRUE;
#line 30 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self;
#line 524 "tracker-backend.c"
}


TrackerSparqlBackend* tracker_sparql_backend_new (GError** error) {
#line 30 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return tracker_sparql_backend_construct (TRACKER_SPARQL_TYPE_BACKEND, error);
#line 531 "tracker-backend.c"
}


static void tracker_sparql_backend_real_dispose (GObject* base) {
	TrackerSparqlBackend * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 53 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 55 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = self->priv->initialized;
#line 55 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_) {
#line 56 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_lock (&tracker_sparql_backend_door);
#line 547 "tracker-backend.c"
		{
			TrackerSparqlConnection* _tmp1_ = NULL;
#line 63 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp1_ = tracker_sparql_backend_singleton;
#line 63 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection)) {
#line 64 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				tracker_sparql_backend_singleton = NULL;
#line 556 "tracker-backend.c"
			}
		}
		__finally1:
		{
#line 67 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 563 "tracker-backend.c"
		}
#line 58 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 58 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 58 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 573 "tracker-backend.c"
		}
	}
#line 71 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection));
#line 578 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	const gchar* _tmp0_ = NULL;
	TrackerSparqlConnection* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 74 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 74 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 75 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = sparql;
#line 75 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:75: %s(): '%s'", "Tracker.Sparql.Backend.query", _tmp0_);
#line 76 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = self->priv->direct;
#line 76 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp1_ != NULL) {
#line 600 "tracker-backend.c"
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		TrackerSparqlCursor* _tmp6_ = NULL;
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = self->priv->direct;
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = sparql;
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = cancellable;
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = tracker_sparql_connection_query (_tmp3_, _tmp4_, _tmp5_, &_inner_error_);
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = _tmp6_;
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 624 "tracker-backend.c"
			} else {
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 632 "tracker-backend.c"
			}
		}
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp2_;
#line 77 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 639 "tracker-backend.c"
	} else {
		TrackerSparqlCursor* _tmp7_ = NULL;
		TrackerSparqlConnection* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GCancellable* _tmp10_ = NULL;
		TrackerSparqlCursor* _tmp11_ = NULL;
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = self->priv->bus;
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = sparql;
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = cancellable;
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp11_ = tracker_sparql_connection_query (_tmp8_, _tmp9_, _tmp10_, &_inner_error_);
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = _tmp11_;
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 664 "tracker-backend.c"
			} else {
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 672 "tracker-backend.c"
			}
		}
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp7_;
#line 79 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 679 "tracker-backend.c"
	}
}


static void tracker_sparql_backend_real_query_async_data_free (gpointer _data) {
	TrackerSparqlBackendQueryAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendQueryAsyncData, _data_);
#line 697 "tracker-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 704 "tracker-backend.c"
}


static void tracker_sparql_backend_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendQueryAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendQueryAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_query_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_query_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 746 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 757 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 767 "tracker-backend.c"
}


static void tracker_sparql_backend_query_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendQueryAsyncData* _data_;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_query_async_co (_data_);
#line 781 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_query_async_co (TrackerSparqlBackendQueryAsyncData* _data_) {
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 790 "tracker-backend.c"
		goto _state_0;
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 794 "tracker-backend.c"
		goto _state_1;
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 2:
#line 798 "tracker-backend.c"
		goto _state_2;
		default:
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 803 "tracker-backend.c"
	}
	_state_0:
#line 84 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 84 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 84 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:84: %s(): '%s'", "Tracker.Sparql.Backend.query_async", _data_->_tmp0_);
#line 85 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 85 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->self->priv->direct;
#line 85 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp1_ != NULL) {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = _data_->self->priv->direct;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = NULL;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = _data_->sparql;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp5_ = NULL;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp5_ = _data_->cancellable;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_state_ = 1;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, tracker_sparql_backend_query_async_ready, _data_);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 836 "tracker-backend.c"
		_state_1:
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp6_ = NULL;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp6_ = tracker_sparql_connection_query_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = _data_->_tmp6_;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_error_free (_data_->_inner_error_);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_state_ == 0) {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 856 "tracker-backend.c"
				} else {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 860 "tracker-backend.c"
				}
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 866 "tracker-backend.c"
			} else {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 874 "tracker-backend.c"
			}
		}
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->result = _data_->_tmp2_;
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_state_ == 0) {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 883 "tracker-backend.c"
		} else {
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 887 "tracker-backend.c"
		}
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 86 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 893 "tracker-backend.c"
	} else {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = NULL;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = _data_->self->priv->bus;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = NULL;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = _data_->sparql;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = NULL;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = _data_->cancellable;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_state_ = 2;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		tracker_sparql_connection_query_async (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, tracker_sparql_backend_query_async_ready, _data_);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 913 "tracker-backend.c"
		_state_2:
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp11_ = NULL;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp11_ = tracker_sparql_connection_query_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp7_ = _data_->_tmp11_;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_error_free (_data_->_inner_error_);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_state_ == 0) {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 933 "tracker-backend.c"
				} else {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 937 "tracker-backend.c"
				}
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 943 "tracker-backend.c"
			} else {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 951 "tracker-backend.c"
			}
		}
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->result = _data_->_tmp7_;
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_state_ == 0) {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 960 "tracker-backend.c"
		} else {
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 964 "tracker-backend.c"
		}
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_object_unref (_data_->_async_result);
#line 88 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 970 "tracker-backend.c"
	}
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 976 "tracker-backend.c"
	} else {
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 980 "tracker-backend.c"
	}
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 83 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 986 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GCancellable* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 92 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 92 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (sparql != NULL);
#line 93 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = priority;
#line 93 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 93 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:93: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update", _tmp0_, _tmp1_);
#line 94 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 94 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ == NULL) {
#line 1014 "tracker-backend.c"
		GError* _tmp3_ = NULL;
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp3_;
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1026 "tracker-backend.c"
		} else {
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 95 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1034 "tracker-backend.c"
		}
	}
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = self->priv->bus;
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = sparql;
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = priority;
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = cancellable;
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update (_tmp4_, _tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1055 "tracker-backend.c"
		} else {
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1063 "tracker-backend.c"
		}
	}
}


static GVariant* tracker_sparql_backend_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	GVariant* result = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	GVariant* _tmp4_ = NULL;
	TrackerSparqlConnection* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GCancellable* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 100 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 100 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 101 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = priority;
#line 101 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 101 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:101: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank", _tmp0_, _tmp1_);
#line 102 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = self->priv->bus;
#line 102 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ == NULL) {
#line 1096 "tracker-backend.c"
		GError* _tmp3_ = NULL;
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp3_;
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1108 "tracker-backend.c"
		} else {
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 103 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1116 "tracker-backend.c"
		}
	}
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = self->priv->bus;
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = sparql;
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = priority;
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = cancellable;
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = tracker_sparql_connection_update_blank (_tmp5_, _tmp6_, _tmp7_, _tmp8_, &_inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _tmp9_;
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1139 "tracker-backend.c"
		} else {
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 1147 "tracker-backend.c"
		}
	}
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp4_;
#line 105 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1154 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateAsyncData, _data_);
#line 1169 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = priority;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp3_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp5_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1216 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 1226 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1230 "tracker-backend.c"
}


static void tracker_sparql_backend_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateAsyncData* _data_;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_async_co (_data_);
#line 1244 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_async_co (TrackerSparqlBackendUpdateAsyncData* _data_) {
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1253 "tracker-backend.c"
		goto _state_0;
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1257 "tracker-backend.c"
		goto _state_1;
		default:
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1262 "tracker-backend.c"
	}
	_state_0:
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = 0;
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->priority;
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->sparql;
#line 109 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:109: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_async", _data_->_tmp0_, _data_->_tmp1_);
#line 110 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 110 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 110 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp2_ == NULL) {
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1297 "tracker-backend.c"
			} else {
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1301 "tracker-backend.c"
			}
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1307 "tracker-backend.c"
		} else {
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 111 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1315 "tracker-backend.c"
		}
	}
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->self->priv->bus;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->sparql;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = 0;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->priority;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_async (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, tracker_sparql_backend_update_async_ready, _data_);
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1340 "tracker-backend.c"
	_state_1:
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1356 "tracker-backend.c"
			} else {
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1360 "tracker-backend.c"
			}
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1366 "tracker-backend.c"
		} else {
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 113 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1374 "tracker-backend.c"
		}
	}
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1381 "tracker-backend.c"
	} else {
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1385 "tracker-backend.c"
	}
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 108 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1391 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateArrayAsyncData, _data_);
#line 1406 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_array_async (TrackerSparqlConnection* base, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateArrayAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_array_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_array_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1__length1 = sparql_length1;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp1_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql_length1 = _tmp1__length1;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = priority;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp2_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1453 "tracker-backend.c"
}


static GPtrArray* tracker_sparql_backend_real_update_array_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 1464 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1474 "tracker-backend.c"
}


static void tracker_sparql_backend_update_array_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateArrayAsyncData* _data_;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_array_async_co (_data_);
#line 1488 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_array_async_co (TrackerSparqlBackendUpdateArrayAsyncData* _data_) {
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1497 "tracker-backend.c"
		goto _state_0;
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1501 "tracker-backend.c"
		goto _state_1;
		default:
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1506 "tracker-backend.c"
	}
	_state_0:
#line 117 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 117 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 117 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = NULL;
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1531 "tracker-backend.c"
			} else {
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1535 "tracker-backend.c"
			}
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1541 "tracker-backend.c"
		} else {
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 118 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1549 "tracker-backend.c"
		}
	}
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4__length1 = 0;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->sparql;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4__length1 = _data_->sparql_length1;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = 0;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->priority;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->cancellable;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_array_async (_data_->_tmp3_, _data_->_tmp4_, _data_->_tmp4__length1, _data_->_tmp5_, _data_->_tmp6_, tracker_sparql_backend_update_array_async_ready, _data_);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1578 "tracker-backend.c"
	_state_1:
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = tracker_sparql_connection_update_array_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp7_;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1598 "tracker-backend.c"
			} else {
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1602 "tracker-backend.c"
			}
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1608 "tracker-backend.c"
		} else {
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1616 "tracker-backend.c"
		}
	}
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp2_;
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1625 "tracker-backend.c"
	} else {
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1629 "tracker-backend.c"
	}
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 120 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1639 "tracker-backend.c"
	} else {
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1643 "tracker-backend.c"
	}
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 116 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1649 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_variant_unref0 (_data_->result);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendUpdateBlankAsyncData, _data_);
#line 1666 "tracker-backend.c"
}


static void tracker_sparql_backend_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendUpdateBlankAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_update_blank_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_update_blank_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = priority;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->priority = _tmp3_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp5_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1713 "tracker-backend.c"
}


static GVariant* tracker_sparql_backend_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 1724 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 1734 "tracker-backend.c"
}


static void tracker_sparql_backend_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendUpdateBlankAsyncData* _data_;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_update_blank_async_co (_data_);
#line 1748 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_update_blank_async_co (TrackerSparqlBackendUpdateBlankAsyncData* _data_) {
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 1757 "tracker-backend.c"
		goto _state_0;
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 1761 "tracker-backend.c"
		goto _state_1;
		default:
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 1766 "tracker-backend.c"
	}
	_state_0:
#line 124 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = 0;
#line 124 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->priority;
#line 124 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 124 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->sparql;
#line 124 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:124: %s(priority:%d): '%s'", "Tracker.Sparql.Backend.update_blank_async", _data_->_tmp0_, _data_->_tmp1_);
#line 125 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 125 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 125 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp2_ == NULL) {
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1801 "tracker-backend.c"
			} else {
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1805 "tracker-backend.c"
			}
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1811 "tracker-backend.c"
		} else {
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 126 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1819 "tracker-backend.c"
		}
	}
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->self->priv->bus;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->sparql;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = 0;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->priority;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = NULL;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp8_ = _data_->cancellable;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_update_blank_async (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, tracker_sparql_backend_update_blank_async_ready, _data_);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1844 "tracker-backend.c"
	_state_1:
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp9_ = NULL;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp9_ = tracker_sparql_connection_update_blank_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->_tmp9_;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1864 "tracker-backend.c"
			} else {
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1868 "tracker-backend.c"
			}
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1874 "tracker-backend.c"
		} else {
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 1882 "tracker-backend.c"
		}
	}
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp4_;
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1891 "tracker-backend.c"
	} else {
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1895 "tracker-backend.c"
	}
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 128 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1905 "tracker-backend.c"
	} else {
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1909 "tracker-backend.c"
	}
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 123 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 1915 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	gchar* uri = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_ = NULL;
	TrackerSparqlConnection* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 131 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 131 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (file != NULL);
#line 132 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = file;
#line 132 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 132 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	uri = _tmp1_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = uri;
#line 133 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:133: %s(): '%s'", "Tracker.Sparql.Backend.load", _tmp2_);
#line 134 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 134 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp3_ == NULL) {
#line 1948 "tracker-backend.c"
		GError* _tmp4_ = NULL;
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp4_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1962 "tracker-backend.c"
		} else {
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1972 "tracker-backend.c"
		}
	}
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = self->priv->bus;
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = file;
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = cancellable;
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 1993 "tracker-backend.c"
		} else {
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (uri);
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 137 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return;
#line 2003 "tracker-backend.c"
		}
	}
#line 131 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (uri);
#line 2008 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_async_data_free (gpointer _data) {
	TrackerSparqlBackendLoadAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendLoadAsyncData, _data_);
#line 2023 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendLoadAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendLoadAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_load_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_load_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = file;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->file);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->file = _tmp2_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 2065 "tracker-backend.c"
}


static void tracker_sparql_backend_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 2075 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2079 "tracker-backend.c"
}


static void tracker_sparql_backend_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendLoadAsyncData* _data_;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_load_async_co (_data_);
#line 2093 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_load_async_co (TrackerSparqlBackendLoadAsyncData* _data_) {
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 2102 "tracker-backend.c"
		goto _state_0;
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 2106 "tracker-backend.c"
		goto _state_1;
		default:
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 2111 "tracker-backend.c"
	}
	_state_0:
#line 141 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 141 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->file;
#line 141 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 141 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = g_file_get_uri (_data_->_tmp0_);
#line 141 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->uri = _data_->_tmp1_;
#line 142 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 142 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->uri;
#line 142 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:142: %s(): '%s'", "Tracker.Sparql.Backend.load_async", _data_->_tmp2_);
#line 143 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 143 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 143 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp3_ == NULL) {
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = NULL;
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Update support not available for direct-only connection");
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp4_;
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2154 "tracker-backend.c"
			} else {
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2158 "tracker-backend.c"
			}
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2164 "tracker-backend.c"
		} else {
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 144 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2174 "tracker-backend.c"
		}
	}
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = _data_->self->priv->bus;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _data_->file;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load_async (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, tracker_sparql_backend_load_async_ready, _data_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2195 "tracker-backend.c"
	_state_1:
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_load_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2213 "tracker-backend.c"
			} else {
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2217 "tracker-backend.c"
			}
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2223 "tracker-backend.c"
		} else {
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_free0 (_data_->uri);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 146 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2233 "tracker-backend.c"
		}
	}
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (_data_->uri);
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2242 "tracker-backend.c"
	} else {
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2246 "tracker-backend.c"
	}
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 140 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2252 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics (TrackerSparqlConnection* base, GCancellable* cancellable, GError** error) {
	TrackerSparqlBackend * self;
	TrackerSparqlCursor* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlConnection* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	TrackerSparqlCursor* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 149 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 150 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:150: %s()", "Tracker.Sparql.Backend.statistics");
#line 151 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = self->priv->bus;
#line 151 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 2273 "tracker-backend.c"
		GError* _tmp1_ = NULL;
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = _tmp1_;
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2285 "tracker-backend.c"
		} else {
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 152 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2293 "tracker-backend.c"
		}
	}
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = self->priv->bus;
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = cancellable;
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = tracker_sparql_connection_statistics (_tmp3_, _tmp4_, &_inner_error_);
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _tmp5_;
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2312 "tracker-backend.c"
		} else {
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 2320 "tracker-backend.c"
		}
	}
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp2_;
#line 154 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2327 "tracker-backend.c"
}


static void tracker_sparql_backend_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendStatisticsAsyncData, _data_);
#line 2342 "tracker-backend.c"
}


static void tracker_sparql_backend_real_statistics_async (TrackerSparqlConnection* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackend * self;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
	TrackerSparqlBackend* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = (TrackerSparqlBackend*) base;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendStatisticsAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_backend_real_statistics_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_real_statistics_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp2_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2374 "tracker-backend.c"
}


static TrackerSparqlCursor* tracker_sparql_backend_real_statistics_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2385 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 2395 "tracker-backend.c"
}


static void tracker_sparql_backend_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlBackendStatisticsAsyncData* _data_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_real_statistics_async_co (_data_);
#line 2409 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_real_statistics_async_co (TrackerSparqlBackendStatisticsAsyncData* _data_) {
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 2418 "tracker-backend.c"
		goto _state_0;
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 2422 "tracker-backend.c"
		goto _state_1;
		default:
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 2427 "tracker-backend.c"
	}
	_state_0:
#line 158 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_debug ("tracker-backend.vala:158: %s()", "Tracker.Sparql.Backend.statistics_async");
#line 159 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 159 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->self->priv->bus;
#line 159 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp0_ == NULL) {
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = NULL;
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Statistics support not available for direct-only connection");
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp1_;
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2454 "tracker-backend.c"
			} else {
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2458 "tracker-backend.c"
			}
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2464 "tracker-backend.c"
		} else {
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 160 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2472 "tracker-backend.c"
		}
	}
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = NULL;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp3_ = _data_->self->priv->bus;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = NULL;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_statistics_async (_data_->_tmp3_, _data_->_tmp4_, tracker_sparql_backend_statistics_async_ready, _data_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2489 "tracker-backend.c"
	_state_1:
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = tracker_sparql_connection_statistics_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = _data_->_tmp5_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2509 "tracker-backend.c"
			} else {
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2513 "tracker-backend.c"
			}
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2519 "tracker-backend.c"
		} else {
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 2527 "tracker-backend.c"
		}
	}
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp2_;
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2536 "tracker-backend.c"
	} else {
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2540 "tracker-backend.c"
	}
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 162 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2550 "tracker-backend.c"
	} else {
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2554 "tracker-backend.c"
	}
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 157 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 2560 "tracker-backend.c"
}


static void tracker_sparql_backend_load_plugins (TrackerSparqlBackend* self, GError** error) {
	gchar* env_backend = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TrackerSparqlBackendBackend backend = 0;
	const gchar* _tmp2_ = NULL;
	TrackerSparqlBackendBackend _tmp8_ = 0;
	TrackerSparqlBackendBackend _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 166 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (self != NULL);
#line 167 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = g_getenv ("TRACKER_SPARQL_BACKEND");
#line 167 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 167 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	env_backend = _tmp1_;
#line 168 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	backend = TRACKER_SPARQL_BACKEND_BACKEND_AUTO;
#line 170 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = env_backend;
#line 170 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp2_ != NULL) {
#line 2587 "tracker-backend.c"
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = env_backend;
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = g_ascii_strcasecmp (_tmp3_, "direct");
#line 171 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_tmp4_ == 0) {
#line 172 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			backend = TRACKER_SPARQL_BACKEND_BACKEND_DIRECT;
#line 173 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_debug ("tracker-backend.vala:173: Using backend = 'DIRECT'");
#line 2600 "tracker-backend.c"
		} else {
			const gchar* _tmp5_ = NULL;
			gint _tmp6_ = 0;
#line 174 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp5_ = env_backend;
#line 174 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp6_ = g_ascii_strcasecmp (_tmp5_, "bus");
#line 174 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp6_ == 0) {
#line 175 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				backend = TRACKER_SPARQL_BACKEND_BACKEND_BUS;
#line 176 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_debug ("tracker-backend.vala:176: Using backend = 'BUS'");
#line 2614 "tracker-backend.c"
			} else {
				const gchar* _tmp7_ = NULL;
#line 178 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp7_ = env_backend;
#line 178 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_warning ("tracker-backend.vala:178: Environment variable TRACKER_SPARQL_BACKEND " \
"set to unknown value '%s'", _tmp7_);
#line 2621 "tracker-backend.c"
			}
		}
	}
#line 182 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = backend;
#line 182 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp8_ == TRACKER_SPARQL_BACKEND_BACKEND_AUTO) {
#line 183 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_debug ("tracker-backend.vala:183: Using backend = 'AUTO'");
#line 2631 "tracker-backend.c"
	}
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = backend;
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_tmp9_) {
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_AUTO:
#line 2639 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp16_ = NULL;
			TrackerBusConnection* _tmp17_ = NULL;
			{
				TrackerDirectConnection* _tmp10_ = NULL;
				TrackerDirectConnection* _tmp11_ = NULL;
#line 189 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp11_ = tracker_direct_connection_new (&_inner_error_);
#line 189 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp10_ = _tmp11_;
#line 189 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_inner_error_ != NULL) {
#line 189 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 2654 "tracker-backend.c"
						goto __catch2_tracker_sparql_error;
					}
					goto __finally2;
				}
#line 189 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (self->priv->direct);
#line 189 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				self->priv->direct = (TrackerSparqlConnection*) _tmp10_;
#line 2663 "tracker-backend.c"
			}
			goto __finally2;
			__catch2_tracker_sparql_error:
			{
				GError* e = NULL;
				GError* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				e = _inner_error_;
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_inner_error_ = NULL;
#line 191 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp12_ = e;
#line 191 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp13_ = _tmp12_->message;
#line 191 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp14_ = g_strconcat ("Unable to initialize direct backend: ", _tmp13_, NULL);
#line 191 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp15_ = _tmp14_;
#line 191 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_debug ("tracker-backend.vala:191: %s", _tmp15_);
#line 191 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (_tmp15_);
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_error_free0 (e);
#line 2691 "tracker-backend.c"
			}
			__finally2:
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_ != NULL) {
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 188 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2702 "tracker-backend.c"
			}
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp17_ = tracker_bus_connection_new (&_inner_error_);
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp16_ = _tmp17_;
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_ != NULL) {
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2716 "tracker-backend.c"
			}
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 194 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp16_;
#line 195 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2724 "tracker-backend.c"
		}
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_DIRECT:
#line 2728 "tracker-backend.c"
		{
			TrackerDirectConnection* _tmp18_ = NULL;
			TrackerDirectConnection* _tmp19_ = NULL;
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp19_ = tracker_direct_connection_new (&_inner_error_);
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp18_ = _tmp19_;
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_ != NULL) {
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2744 "tracker-backend.c"
			}
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->direct);
#line 198 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->direct = (TrackerSparqlConnection*) _tmp18_;
#line 199 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2752 "tracker-backend.c"
		}
#line 186 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case TRACKER_SPARQL_BACKEND_BACKEND_BUS:
#line 2756 "tracker-backend.c"
		{
			TrackerBusConnection* _tmp20_ = NULL;
			TrackerBusConnection* _tmp21_ = NULL;
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp21_ = tracker_bus_connection_new (&_inner_error_);
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp20_ = _tmp21_;
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_ != NULL) {
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_free0 (env_backend);
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return;
#line 2772 "tracker-backend.c"
			}
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (self->priv->bus);
#line 202 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			self->priv->bus = (TrackerSparqlConnection*) _tmp20_;
#line 203 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 2780 "tracker-backend.c"
		}
		default:
		{
#line 206 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_assert_not_reached ();
#line 2786 "tracker-backend.c"
		}
	}
#line 166 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (env_backend);
#line 2791 "tracker-backend.c"
}


static TrackerSparqlConnection* tracker_sparql_backend_get (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_ = NULL;
#line 215 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_mutex_lock (&tracker_sparql_backend_door);
#line 2800 "tracker-backend.c"
	{
		TrackerSparqlConnection* _result_ = NULL;
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_ = NULL;
#line 219 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = tracker_sparql_backend_singleton;
#line 219 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 219 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_result_ = _tmp1_;
#line 221 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = _result_;
#line 221 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_tmp2_ == NULL) {
#line 2816 "tracker-backend.c"
			TrackerSparqlBackend* _tmp3_ = NULL;
			TrackerSparqlBackend* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			GCancellable* _tmp6_ = NULL;
			gboolean _tmp9_ = FALSE;
			TrackerSparqlConnection* _tmp11_ = NULL;
#line 222 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			tracker_sparql_backend_log_init ();
#line 224 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp4_ = tracker_sparql_backend_new (&_inner_error_);
#line 224 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp3_ = _tmp4_;
#line 224 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_ != NULL) {
#line 224 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 2833 "tracker-backend.c"
				goto __finally3;
			}
#line 224 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_object_unref0 (_result_);
#line 224 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_result_ = (TrackerSparqlConnection*) _tmp3_;
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp6_ = cancellable;
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp6_ != NULL) {
#line 2844 "tracker-backend.c"
				GCancellable* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp7_ = cancellable;
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp8_ = g_cancellable_is_cancelled (_tmp7_);
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp5_ = _tmp8_;
#line 2853 "tracker-backend.c"
			} else {
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp5_ = FALSE;
#line 2857 "tracker-backend.c"
			}
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp9_ = _tmp5_;
#line 226 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_tmp9_) {
#line 2863 "tracker-backend.c"
				GError* _tmp10_ = NULL;
#line 227 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_tmp10_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 227 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_inner_error_ = _tmp10_;
#line 227 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_g_object_unref0 (_result_);
#line 2871 "tracker-backend.c"
				goto __finally3;
			}
#line 230 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_tmp11_ = _result_;
#line 230 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			tracker_sparql_backend_singleton = _tmp11_;
#line 2878 "tracker-backend.c"
		}
#line 233 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _result_;
#line 2882 "tracker-backend.c"
		{
#line 235 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_mutex_unlock (&tracker_sparql_backend_door);
#line 2886 "tracker-backend.c"
		}
#line 233 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 2890 "tracker-backend.c"
	}
	__finally3:
	{
#line 235 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 2896 "tracker-backend.c"
	}
#line 217 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 217 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_propagate_error (error, _inner_error_);
#line 217 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2904 "tracker-backend.c"
	} else {
#line 217 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 217 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 217 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 2912 "tracker-backend.c"
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return _data1_;
#line 2922 "tracker-backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data1_->async_result);
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 2937 "tracker-backend.c"
	}
}


static void __lambda4_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (res != NULL);
#line 253 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = res;
#line 253 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 253 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data1_->async_result);
#line 253 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->async_result = _tmp1_;
#line 254 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = _data1_->loop;
#line 254 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_loop_quit (_tmp2_);
#line 2960 "tracker-backend.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	__lambda4_ (self, source_object, res);
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block1_data_unref (self);
#line 2969 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	Block1Data* _data1_;
	GMainContext* _tmp0_ = NULL;
	GMainContext* context = NULL;
	GMainContext* _tmp4_ = NULL;
	GMainContext* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	GMainContext* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GMainLoop* _tmp9_ = NULL;
	GMainContext* _tmp10_ = NULL;
	TrackerSparqlConnection* _tmp11_ = NULL;
	GAsyncResult* _tmp12_ = NULL;
	TrackerSparqlConnection* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 239 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->_ref_count_ = 1;
#line 240 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = g_main_context_get_thread_default ();
#line 240 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_ == NULL) {
#line 2997 "tracker-backend.c"
		TrackerSparqlConnection* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_ = NULL;
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = cancellable;
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = tracker_sparql_backend_get (_tmp2_, &_inner_error_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _tmp3_;
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_propagate_error (error, _inner_error_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block1_data_unref (_data1_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data1_ = NULL;
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 3019 "tracker-backend.c"
			} else {
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block1_data_unref (_data1_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data1_ = NULL;
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_inner_error_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return NULL;
#line 3031 "tracker-backend.c"
			}
		}
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		result = _tmp1_;
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		block1_data_unref (_data1_);
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data1_ = NULL;
#line 242 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return result;
#line 3042 "tracker-backend.c"
	}
#line 246 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp4_ = g_main_context_new ();
#line 246 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	context = _tmp4_;
#line 247 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp5_ = context;
#line 247 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = g_main_loop_new (_tmp5_, FALSE);
#line 247 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->loop = _tmp6_;
#line 248 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_->async_result = NULL;
#line 250 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = context;
#line 250 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_context_push_thread_default (_tmp7_);
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = cancellable;
#line 252 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_tmp8_, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
#line 257 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp9_ = _data1_->loop;
#line 257 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_loop_run (_tmp9_);
#line 259 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp10_ = context;
#line 259 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_main_context_pop_thread_default (_tmp10_);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp12_ = _data1_->async_result;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp13_ = tracker_sparql_backend_get_internal_finish (_tmp12_, &_inner_error_);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp11_ = _tmp13_;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block1_data_unref (_data1_);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data1_ = NULL;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 3092 "tracker-backend.c"
		} else {
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_g_main_context_unref0 (context);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block1_data_unref (_data1_);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data1_ = NULL;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 3106 "tracker-backend.c"
		}
	}
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp11_;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_main_context_unref0 (context);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block1_data_unref (_data1_);
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data1_ = NULL;
#line 261 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3119 "tracker-backend.c"
}


static void tracker_sparql_backend_get_internal_async_data_free (gpointer _data) {
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_slice_free (TrackerSparqlBackendGetInternalAsyncData, _data_);
#line 3130 "tracker-backend.c"
}


void tracker_sparql_backend_get_internal_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlBackendGetInternalAsyncData* _data_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_slice_new0 (TrackerSparqlBackendGetInternalAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_backend_get_internal_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_backend_get_internal_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->cancellable = _tmp1_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data_);
#line 3154 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_backend_get_internal_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlBackendGetInternalAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return NULL;
#line 3165 "tracker-backend.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3175 "tracker-backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return _data2_;
#line 3184 "tracker-backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_main_context_unref0 (_data2_->context);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->cancellable);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 3209 "tracker-backend.c"
	}
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 3217 "tracker-backend.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 289 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return self ? g_error_copy (self) : NULL;
#line 3224 "tracker-backend.c"
}


static gboolean __lambda3_ (Block2Data* _data2_) {
	gboolean result = FALSE;
#line 300 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async_co (_data2_->_async_data_);
#line 301 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = FALSE;
#line 301 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3236 "tracker-backend.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 299 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3245 "tracker-backend.c"
}


static gboolean __lambda2_ (Block2Data* _data2_, GIOSchedulerJob* job) {
	gboolean result = FALSE;
	GSource* source = NULL;
	GSource* _tmp11_ = NULL;
	GMainContext* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 285 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_val_if_fail (job != NULL, FALSE);
#line 3257 "tracker-backend.c"
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		GCancellable* _tmp1_ = NULL;
		TrackerSparqlConnection* _tmp2_ = NULL;
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp1_ = _data2_->cancellable;
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp2_ = tracker_sparql_backend_get (_tmp1_, &_inner_error_);
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp0_ = _tmp2_;
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_inner_error_ != NULL) {
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 3272 "tracker-backend.c"
				goto __catch4_g_io_error;
			}
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 3277 "tracker-backend.c"
				goto __catch4_tracker_sparql_error;
			}
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 3282 "tracker-backend.c"
				goto __catch4_g_dbus_error;
			}
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 3287 "tracker-backend.c"
				goto __catch4_g_spawn_error;
			}
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3296 "tracker-backend.c"
		}
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data2_->_result_);
#line 287 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->_result_ = _tmp0_;
#line 3302 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_io = _inner_error_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 289 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp3_ = e_io;
#line 289 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = _g_error_copy0 (_tmp3_);
#line 289 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->io_error);
#line 289 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->io_error = _tmp4_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_io);
#line 3324 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_spql = _inner_error_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 291 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = e_spql;
#line 291 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 291 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 291 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->sparql_error = _tmp6_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_spql);
#line 3346 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_dbus = _inner_error_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 293 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp7_ = e_dbus;
#line 293 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 293 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 293 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->dbus_error = _tmp8_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_dbus);
#line 3368 "tracker-backend.c"
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e_spawn = NULL;
		GError* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		e_spawn = _inner_error_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_inner_error_ = NULL;
#line 295 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = e_spawn;
#line 295 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp10_ = _g_error_copy0 (_tmp9_);
#line 295 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (_data2_->spawn_error);
#line 295 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data2_->spawn_error = _tmp10_;
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_error_free0 (e_spawn);
#line 3390 "tracker-backend.c"
	}
	__finally4:
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_clear_error (&_inner_error_);
#line 286 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return FALSE;
#line 3401 "tracker-backend.c"
	}
#line 298 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp11_ = g_idle_source_new ();
#line 298 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	source = _tmp11_;
#line 299 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_source_set_callback (source, ___lambda3__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 303 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp12_ = _data2_->context;
#line 303 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_source_attach (source, _tmp12_);
#line 305 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = FALSE;
#line 305 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_source_unref0 (source);
#line 305 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3419 "tracker-backend.c"
}


static gboolean ___lambda2__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self) {
	gboolean result;
	result = __lambda2_ (self, job);
#line 285 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 3428 "tracker-backend.c"
}


static gboolean tracker_sparql_backend_get_internal_async_co (TrackerSparqlBackendGetInternalAsyncData* _data_) {
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 3437 "tracker-backend.c"
		goto _state_0;
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 3441 "tracker-backend.c"
		goto _state_1;
		default:
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 3446 "tracker-backend.c"
	}
	_state_0:
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = NULL;
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->cancellable;
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (_data_->_data2_->cancellable);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->cancellable = _data_->_tmp0_;
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 266 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = FALSE;
#line 266 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = g_mutex_trylock (&tracker_sparql_backend_door);
#line 266 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp1_) {
#line 268 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = NULL;
#line 268 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp2_ = tracker_sparql_backend_singleton;
#line 268 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = NULL;
#line 268 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 268 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_result_ = _data_->_tmp3_;
#line 270 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_mutex_unlock (&tracker_sparql_backend_door);
#line 272 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = NULL;
#line 272 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp4_ = _data_->_result_;
#line 272 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_tmp4_ != NULL) {
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->result = _data_->_result_;
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3497 "tracker-backend.c"
			} else {
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3501 "tracker-backend.c"
			}
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 273 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3507 "tracker-backend.c"
		}
#line 266 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_g_object_unref0 (_data_->_result_);
#line 3511 "tracker-backend.c"
	}
#line 278 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->sparql_error = NULL;
#line 279 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->io_error = NULL;
#line 280 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->dbus_error = NULL;
#line 281 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->spawn_error = NULL;
#line 282 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->_result_ = NULL;
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = NULL;
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp5_ = g_main_context_get_thread_default ();
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = NULL;
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp6_ = _g_main_context_ref0 (_data_->_tmp5_);
#line 283 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_->context = _data_->_tmp6_;
#line 285 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_io_scheduler_push_job (___lambda2__gio_scheduler_job_func, block2_data_ref (_data_->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, NULL);
#line 307 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 307 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3539 "tracker-backend.c"
	_state_1:
	;
#line 309 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = NULL;
#line 309 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp7_ = _data_->_data2_->sparql_error;
#line 309 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_tmp7_ != NULL) {
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = NULL;
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp8_ = _data_->_data2_->sparql_error;
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = NULL;
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_inner_error_ = _data_->_tmp9_;
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3572 "tracker-backend.c"
			} else {
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3576 "tracker-backend.c"
			}
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3582 "tracker-backend.c"
		} else {
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			block2_data_unref (_data_->_data2_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_data2_ = NULL;
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 310 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 3594 "tracker-backend.c"
		}
	} else {
#line 311 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = NULL;
#line 311 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_data_->_tmp10_ = _data_->_data2_->io_error;
#line 311 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if (_data_->_tmp10_ != NULL) {
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp11_ = NULL;
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp11_ = _data_->_data2_->io_error;
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp12_ = NULL;
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_error_free (_data_->_inner_error_);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_state_ == 0) {
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3627 "tracker-backend.c"
				} else {
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 3631 "tracker-backend.c"
				}
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_object_unref (_data_->_async_result);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 3637 "tracker-backend.c"
			} else {
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				block2_data_unref (_data_->_data2_);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_data2_ = NULL;
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_clear_error (&_data_->_inner_error_);
#line 312 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				return FALSE;
#line 3649 "tracker-backend.c"
			}
		} else {
#line 313 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp13_ = NULL;
#line 313 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			_data_->_tmp13_ = _data_->_data2_->dbus_error;
#line 313 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_tmp13_ != NULL) {
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp14_ = NULL;
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp14_ = _data_->_data2_->dbus_error;
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp15_ = NULL;
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_inner_error_ = _data_->_tmp15_;
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_error_free (_data_->_inner_error_);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_data_->_state_ == 0) {
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3682 "tracker-backend.c"
					} else {
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3686 "tracker-backend.c"
					}
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3692 "tracker-backend.c"
				} else {
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_clear_error (&_data_->_inner_error_);
#line 314 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3704 "tracker-backend.c"
				}
			} else {
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp16_ = NULL;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				_data_->_tmp16_ = _data_->_data2_->spawn_error;
#line 315 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				if (_data_->_tmp16_ != NULL) {
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp17_ = NULL;
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp17_ = _data_->_data2_->spawn_error;
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp18_ = NULL;
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_inner_error_ = _data_->_tmp18_;
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_error_free (_data_->_inner_error_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						if (_data_->_state_ == 0) {
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3737 "tracker-backend.c"
						} else {
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 3741 "tracker-backend.c"
						}
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_object_unref (_data_->_async_result);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						return FALSE;
#line 3747 "tracker-backend.c"
					} else {
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						block2_data_unref (_data_->_data2_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						_data_->_data2_ = NULL;
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_clear_error (&_data_->_inner_error_);
#line 316 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						return FALSE;
#line 3759 "tracker-backend.c"
					}
				} else {
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp19_ = NULL;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp19_ = _data_->_data2_->_result_;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp20_ = NULL;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->result = _data_->_tmp20_;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					block2_data_unref (_data_->_data2_);
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					_data_->_data2_ = NULL;
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					if (_data_->_state_ == 0) {
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3780 "tracker-backend.c"
					} else {
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 3784 "tracker-backend.c"
					}
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					g_object_unref (_data_->_async_result);
#line 318 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
					return FALSE;
#line 3790 "tracker-backend.c"
				}
			}
		}
	}
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	block2_data_unref (_data_->_data2_);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_data2_ = NULL;
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3803 "tracker-backend.c"
	} else {
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3807 "tracker-backend.c"
	}
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 264 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 3813 "tracker-backend.c"
}


static void _tracker_sparql_backend_remove_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
#line 368 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_remove_log_handler (log_domain, log_levels, message);
#line 3820 "tracker-backend.c"
}


static void tracker_sparql_backend_log_init (void) {
	gboolean _tmp0_ = FALSE;
	gint verbosity = 0;
	gchar* env_verbosity = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GLogLevelFlags remove_levels = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GLogLevelFlags _tmp8_ = 0;
#line 323 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = tracker_sparql_backend_log_initialized;
#line 323 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp0_) {
#line 324 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		return;
#line 3841 "tracker-backend.c"
	}
#line 327 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_log_initialized = TRUE;
#line 330 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	verbosity = 0;
#line 331 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = g_getenv ("TRACKER_VERBOSITY");
#line 331 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 331 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	env_verbosity = _tmp2_;
#line 332 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp3_ = env_verbosity;
#line 332 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp3_ != NULL) {
#line 3857 "tracker-backend.c"
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 333 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp4_ = env_verbosity;
#line 333 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp5_ = atoi (_tmp4_);
#line 333 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		verbosity = _tmp5_;
#line 3866 "tracker-backend.c"
	}
#line 335 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	remove_levels = 0;
#line 339 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp6_ = verbosity;
#line 339 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp6_ > 2) {
#line 340 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_setenv ("G_MESSAGES_DEBUG", "all", TRUE);
#line 3876 "tracker-backend.c"
	}
#line 342 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp7_ = verbosity;
#line 342 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_tmp7_) {
#line 342 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 3:
#line 3884 "tracker-backend.c"
		{
#line 345 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 3888 "tracker-backend.c"
		}
#line 342 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 2:
#line 3892 "tracker-backend.c"
		{
#line 349 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			remove_levels = G_LOG_LEVEL_DEBUG;
#line 350 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 3898 "tracker-backend.c"
		}
#line 342 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 3902 "tracker-backend.c"
		{
#line 354 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			remove_levels = G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE;
#line 356 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 3908 "tracker-backend.c"
		}
		default:
#line 342 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 3913 "tracker-backend.c"
		{
#line 361 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			remove_levels = (G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO;
#line 364 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			break;
#line 3919 "tracker-backend.c"
		}
	}
#line 367 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp8_ = remove_levels;
#line 367 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_tmp8_ != 0) {
#line 3926 "tracker-backend.c"
		GLogLevelFlags _tmp9_ = 0;
#line 368 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		_tmp9_ = remove_levels;
#line 368 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_log_set_handler ("Tracker", _tmp9_, _tracker_sparql_backend_remove_log_handler_glog_func, NULL);
#line 3932 "tracker-backend.c"
	}
#line 322 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_free0 (env_verbosity);
#line 3936 "tracker-backend.c"
}


static void tracker_sparql_backend_remove_log_handler (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
#line 372 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_return_if_fail (message != NULL);
#line 3943 "tracker-backend.c"
}


static void tracker_sparql_backend_class_init (TrackerSparqlBackendClass * klass) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlBackendPrivate));
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (klass)->dispose = tracker_sparql_backend_real_dispose;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_sparql_backend_real_query;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_sparql_backend_real_query_async;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_sparql_backend_real_query_finish;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_sparql_backend_real_update;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_sparql_backend_real_update_blank;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_sparql_backend_real_update_async;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_sparql_backend_real_update_finish;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_async = tracker_sparql_backend_real_update_array_async;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_array_finish = tracker_sparql_backend_real_update_array_finish;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_sparql_backend_real_update_blank_async;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_sparql_backend_real_update_blank_finish;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_sparql_backend_real_load;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_sparql_backend_real_load_async;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_sparql_backend_real_load_finish;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_sparql_backend_real_statistics;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_sparql_backend_real_statistics_async;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_sparql_backend_real_statistics_finish;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_backend_finalize;
#line 3990 "tracker-backend.c"
}


static void tracker_sparql_backend_instance_init (TrackerSparqlBackend * self) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv = TRACKER_SPARQL_BACKEND_GET_PRIVATE (self);
#line 22 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->direct = NULL;
#line 23 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self->priv->bus = NULL;
#line 4001 "tracker-backend.c"
}


static void tracker_sparql_backend_finalize (GObject* obj) {
	TrackerSparqlBackend * self;
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BACKEND, TrackerSparqlBackend);
#line 22 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (self->priv->direct);
#line 23 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_g_object_unref0 (self->priv->bus);
#line 20 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	G_OBJECT_CLASS (tracker_sparql_backend_parent_class)->finalize (obj);
#line 4015 "tracker-backend.c"
}


GType tracker_sparql_backend_get_type (void) {
	static volatile gsize tracker_sparql_backend_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBackend), 0, (GInstanceInitFunc) tracker_sparql_backend_instance_init, NULL };
		GType tracker_sparql_backend_type_id;
		tracker_sparql_backend_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerSparqlBackend", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_backend_type_id__volatile, tracker_sparql_backend_type_id);
	}
	return tracker_sparql_backend_type_id__volatile;
}


static void tracker_sparql_connection_get_async_data_free (gpointer _data) {
	TrackerSparqlConnectionGetAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionGetAsyncData, _data_);
}


void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* _data_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_connection_get_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_get_async_data_free);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	tracker_sparql_connection_get_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_get_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionGetAsyncData* _data_;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_get_async_co (_data_);
#line 4078 "tracker-backend.c"
}


static gboolean tracker_sparql_connection_get_async_co (TrackerSparqlConnectionGetAsyncData* _data_) {
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 4087 "tracker-backend.c"
		goto _state_0;
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 4091 "tracker-backend.c"
		goto _state_1;
		default:
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 4096 "tracker-backend.c"
	}
	_state_0:
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_data_->_tmp1_, tracker_sparql_connection_get_async_ready, _data_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4109 "tracker-backend.c"
	_state_1:
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = tracker_sparql_backend_get_internal_finish (_data_->_res_, &_data_->_inner_error_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->_tmp2_;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4129 "tracker-backend.c"
			} else {
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4133 "tracker-backend.c"
			}
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4139 "tracker-backend.c"
		} else {
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4147 "tracker-backend.c"
		}
	}
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp0_;
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4156 "tracker-backend.c"
	} else {
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4160 "tracker-backend.c"
	}
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 378 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4170 "tracker-backend.c"
	} else {
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4174 "tracker-backend.c"
	}
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 377 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4180 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = tracker_sparql_backend_get_internal (_tmp1_, &_inner_error_);
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _tmp2_;
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4204 "tracker-backend.c"
		} else {
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4212 "tracker-backend.c"
		}
	}
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp0_;
#line 382 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 4219 "tracker-backend.c"
}


static void tracker_sparql_connection_get_direct_async_data_free (gpointer _data) {
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionGetDirectAsyncData, _data_);
}


void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	_data_ = g_slice_new0 (TrackerSparqlConnectionGetDirectAsyncData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_sparql_connection_get_direct_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_get_direct_async_data_free);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	tracker_sparql_connection_get_direct_async_co (_data_);
}


TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_get_direct_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionGetDirectAsyncData* _data_;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_ = _user_data_;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_source_object_ = source_object;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_res_ = _res_;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_connection_get_direct_async_co (_data_);
#line 4270 "tracker-backend.c"
}


static gboolean tracker_sparql_connection_get_direct_async_co (TrackerSparqlConnectionGetDirectAsyncData* _data_) {
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	switch (_data_->_state_) {
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 0:
#line 4279 "tracker-backend.c"
		goto _state_0;
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		case 1:
#line 4283 "tracker-backend.c"
		goto _state_1;
		default:
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_assert_not_reached ();
#line 4288 "tracker-backend.c"
	}
	_state_0:
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = NULL;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_state_ = 1;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	tracker_sparql_backend_get_internal_async (_data_->_tmp1_, tracker_sparql_connection_get_direct_async_ready, _data_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4301 "tracker-backend.c"
	_state_1:
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = NULL;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp2_ = tracker_sparql_backend_get_internal_finish (_data_->_res_, &_data_->_inner_error_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->_tmp0_ = _data_->_tmp2_;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_inner_error_ != NULL) {
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_SPAWN_ERROR)) {
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			if (_data_->_state_ == 0) {
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4321 "tracker-backend.c"
			} else {
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4325 "tracker-backend.c"
			}
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_object_unref (_data_->_async_result);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4331 "tracker-backend.c"
		} else {
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_data_->_inner_error_);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return FALSE;
#line 4339 "tracker-backend.c"
		}
	}
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_data_->result = _data_->_tmp0_;
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4348 "tracker-backend.c"
	} else {
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4352 "tracker-backend.c"
	}
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 386 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_data_->_state_ == 0) {
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4362 "tracker-backend.c"
	} else {
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4366 "tracker-backend.c"
	}
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	g_object_unref (_data_->_async_result);
#line 385 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return FALSE;
#line 4372 "tracker-backend.c"
}


TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error) {
	TrackerSparqlConnection* result = NULL;
	TrackerSparqlConnection* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	TrackerSparqlConnection* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp1_ = cancellable;
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp2_ = tracker_sparql_backend_get_internal (_tmp1_, &_inner_error_);
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	_tmp0_ = _tmp2_;
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	if (_inner_error_ != NULL) {
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
		if ((((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) || (_inner_error_->domain == G_SPAWN_ERROR)) {
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_propagate_error (error, _inner_error_);
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4396 "tracker-backend.c"
		} else {
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			g_clear_error (&_inner_error_);
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
			return NULL;
#line 4404 "tracker-backend.c"
		}
	}
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	result = _tmp0_;
#line 390 "/home/martyn/Source/tracker/src/libtracker-sparql-backend/tracker-backend.vala"
	return result;
#line 4411 "tracker-backend.c"
}



