/*	$NetBSD: sony12x24.h,v 1.3 2001/03/30 13:06:46 tsutsui Exp $	*/
/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Sony Corp. and Kazumasa Utashiro of Software Research Associates, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: $Hdr: fnt24.c,v 4.300 91/06/09 06:14:46 root Rel41 $ SONY
 *
 *	@(#)fnt24.c	8.1 (Berkeley) 6/10/93
 */

/* This font data is generated from sys/arch/newsmips/dev/fnt24.c */

extern u_char sony12x24_data[];

struct wsdisplay_font sony12x24 = {
	"sony12x24",			/* typeface name */
	' ',				/* firstchar */
	0xff - ' ' + 1,			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	12,				/* width */
	24,				/* height */
	2,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	sony12x24_data			/* data */
};

static u_char sony12x24_data[] = {

#if 0
	/* 0x00 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x01 */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x1f, 0x00,	/* ...*****.... */
	0x1f, 0x00,	/* ...*****.... */
	0x3f, 0x80,	/* ..*******... */
	0x3f, 0x80,	/* ..*******... */
	0x7f, 0xc0,	/* .*********.. */
	0x7f, 0xc0,	/* .*********.. */
	0xff, 0xe0,	/* ***********. */
	0x7f, 0xc0,	/* .*********.. */
	0x7f, 0xc0,	/* .*********.. */
	0x3f, 0x80,	/* ..*******... */
	0x3f, 0x80,	/* ..*******... */
	0x1f, 0x00,	/* ...*****.... */
	0x1f, 0x00,	/* ...*****.... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x02 */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0xc0,	/* ..**....**.. */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0xc6, 0x30,	/* **...**...** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x03 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xc6, 0x00,	/* **...**..... */
	0xc6, 0x00,	/* **...**..... */
	0xc6, 0x00,	/* **...**..... */
	0xc6, 0x00,	/* **...**..... */
	0xfe, 0x00,	/* *******..... */
	0xc6, 0x00,	/* **...**..... */
	0xc6, 0x00,	/* **...**..... */
	0xc6, 0x00,	/* **...**..... */
	0xc6, 0x00,	/* **...**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3f, 0xc0,	/* ..********.. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x04 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xfe, 0x00,	/* *******..... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xfc, 0x00,	/* ******...... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x00, 0x00,	/* ............ */
	0x1f, 0xc0,	/* ...*******.. */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x1f, 0x80,	/* ...******... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x05 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3c, 0x00,	/* ..****...... */
	0x66, 0x00,	/* .**..**..... */
	0xc6, 0x00,	/* **...**..... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x66, 0x00,	/* .**..**..... */
	0x3c, 0x00,	/* ..****...... */
	0x00, 0x00,	/* ............ */
	0x1f, 0x80,	/* ...******... */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x1f, 0x80,	/* ...******... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x80,	/* ...**..**... */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x06 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xfe, 0x00,	/* *******..... */
	0x00, 0x00,	/* ............ */
	0x1f, 0xc0,	/* ...*******.. */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x1f, 0x80,	/* ...******... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x07 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x1b, 0x00,	/* ...**.**.... */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x1b, 0x00,	/* ...**.**.... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x08 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0xff, 0xc0,	/* **********.. */
	0xff, 0xc0,	/* **********.. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x09 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xe3, 0x00,	/* ***...**.... */
	0xe3, 0x00,	/* ***...**.... */
	0xd3, 0x00,	/* **.*..**.... */
	0xd3, 0x00,	/* **.*..**.... */
	0xcb, 0x00,	/* **..*.**.... */
	0xcb, 0x00,	/* **..*.**.... */
	0xc7, 0x00,	/* **...***.... */
	0xc7, 0x00,	/* **...***.... */
	0xc3, 0x00,	/* **....**.... */
	0x00, 0x00,	/* ............ */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x1f, 0xc0,	/* ...*******.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x0A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0x63, 0x00,	/* .**...**.... */
	0x63, 0x00,	/* .**...**.... */
	0x36, 0x00,	/* ..**.**..... */
	0x36, 0x00,	/* ..**.**..... */
	0x1c, 0x00,	/* ...***...... */
	0x1c, 0x00,	/* ...***...... */
	0x08, 0x00,	/* ....*....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3f, 0xc0,	/* ..********.. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x0B */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0xfc, 0x00,	/* ******...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x0C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xfc, 0x00,	/* ******...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */

	/* 0x0D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0xf0,	/* .....******* */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */

	/* 0x0E */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x07, 0xf0,	/* .....******* */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x0F */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0xff, 0xf0,	/* ************ */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */

	/* 0x10 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x11 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x12 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x13 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x14 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0x00, 0x00,	/* ............ */

	/* 0x15 */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x07, 0xf0,	/* .....******* */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */

	/* 0x16 */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0xfc, 0x00,	/* ******...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */

	/* 0x17 */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0xff, 0xf0,	/* ************ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x18 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xf0,	/* ************ */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */

	/* 0x19 */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */

	/* 0x1A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x40,	/* .........*.. */
	0x00, 0xc0,	/* ........**.. */
	0x03, 0x80,	/* ......***... */
	0x0e, 0x00,	/* ....***..... */
	0x38, 0x00,	/* ..***....... */
	0xe0, 0x00,	/* ***......... */
	0x38, 0x00,	/* ..***....... */
	0x0e, 0x00,	/* ....***..... */
	0x03, 0x80,	/* ......***... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x40,	/* .........*.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x1B */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x80, 0x00,	/* *........... */
	0xc0, 0x00,	/* **.......... */
	0x70, 0x00,	/* .***........ */
	0x1c, 0x00,	/* ...***...... */
	0x07, 0x00,	/* .....***.... */
	0x01, 0xc0,	/* .......***.. */
	0x07, 0x00,	/* .....***.... */
	0x1c, 0x00,	/* ...***...... */
	0x70, 0x00,	/* .***........ */
	0xc0, 0x00,	/* **.......... */
	0x80, 0x00,	/* *........... */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x1C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x71, 0x80,	/* .***...**... */
	0x61, 0x80,	/* .**....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x1D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x00,	/* .......*.... */
	0x02, 0x00,	/* ......*..... */
	0xff, 0xc0,	/* **********.. */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x08, 0x00,	/* ....*....... */
	0xff, 0xc0,	/* **********.. */
	0x10, 0x00,	/* ...*........ */
	0x20, 0x00,	/* ..*......... */
	0x60, 0x00,	/* .**......... */
	0xc0, 0x00,	/* **.......... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x1E */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x03, 0x80,	/* ......***... */
	0x04, 0x40,	/* .....*...*.. */
	0x0c, 0x60,	/* ....**...**. */
	0x0c, 0x60,	/* ....**...**. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x4c, 0x00,	/* .*..**...... */
	0x7f, 0xc0,	/* .*********.. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x80,	/* ..*******... */
	0x6c, 0xe0,	/* .**.**..***. */
	0x6c, 0xe0,	/* .**.**..***. */
	0x38, 0x00,	/* ..***....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x1F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
#endif

	/* 0x20 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x21 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x22 */
	0x73, 0x80,	/* .***..***... */
	0x73, 0x80,	/* .***..***... */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x21, 0x00,	/* ..*....*.... */
	0x42, 0x00,	/* .*....*..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x23 */
	0x00, 0x00,	/* ............ */
	0x08, 0x80,	/* ....*...*... */
	0x08, 0x80,	/* ....*...*... */
	0x08, 0x80,	/* ....*...*... */
	0x08, 0x80,	/* ....*...*... */
	0x08, 0x80,	/* ....*...*... */
	0x08, 0x80,	/* ....*...*... */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x11, 0x00,	/* ...*...*.... */
	0x11, 0x00,	/* ...*...*.... */
	0x11, 0x00,	/* ...*...*.... */
	0x11, 0x00,	/* ...*...*.... */
	0x11, 0x00,	/* ...*...*.... */
	0x11, 0x00,	/* ...*...*.... */
	0xff, 0xc0,	/* **********.. */
	0xff, 0xc0,	/* **********.. */
	0x22, 0x00,	/* ..*...*..... */
	0x22, 0x00,	/* ..*...*..... */
	0x22, 0x00,	/* ..*...*..... */
	0x22, 0x00,	/* ..*...*..... */
	0x22, 0x00,	/* ..*...*..... */
	0x22, 0x00,	/* ..*...*..... */
	0x00, 0x00,	/* ............ */

	/* 0x24 */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x1f, 0x00,	/* ...*****.... */
	0x64, 0xc0,	/* .**..*..**.. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x00,	/* **...*...... */
	0xc4, 0x00,	/* **...*...... */
	0xe4, 0x00,	/* ***..*...... */
	0x7c, 0x00,	/* .*****...... */
	0x1f, 0x00,	/* ...*****.... */
	0x07, 0xc0,	/* .....*****.. */
	0x04, 0xe0,	/* .....*..***. */
	0x04, 0x60,	/* .....*...**. */
	0x04, 0x60,	/* .....*...**. */
	0x04, 0x60,	/* .....*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0x64, 0xc0,	/* .**..*..**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */

	/* 0x25 */
	0x00, 0x00,	/* ............ */
	0x78, 0x20,	/* .****.....*. */
	0xcc, 0x20,	/* **..**....*. */
	0xcc, 0x40,	/* **..**...*.. */
	0xcc, 0x40,	/* **..**...*.. */
	0xcc, 0x80,	/* **..**..*... */
	0xcc, 0x80,	/* **..**..*... */
	0x79, 0x00,	/* .****..*.... */
	0x01, 0x00,	/* .......*.... */
	0x02, 0x00,	/* ......*..... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x08, 0x00,	/* ....*....... */
	0x08, 0x00,	/* ....*....... */
	0x10, 0x00,	/* ...*........ */
	0x13, 0xc0,	/* ...*..****.. */
	0x26, 0x60,	/* ..*..**..**. */
	0x26, 0x60,	/* ..*..**..**. */
	0x46, 0x60,	/* .*...**..**. */
	0x46, 0x60,	/* .*...**..**. */
	0x86, 0x60,	/* *....**..**. */
	0x83, 0xc0,	/* *.....****.. */
	0x00, 0x00,	/* ............ */

	/* 0x26 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1e, 0x00,	/* ...****..... */
	0x21, 0x00,	/* ..*....*.... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x63, 0x00,	/* .**...**.... */
	0x66, 0x00,	/* .**..**..... */
	0x34, 0x00,	/* ..**.*...... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x2c, 0x00,	/* ..*.**...... */
	0x44, 0x00,	/* .*...*...... */
	0xc6, 0x60,	/* **...**..**. */
	0xc3, 0x20,	/* **....**..*. */
	0xc1, 0x60,	/* **.....*.**. */
	0xc1, 0xc0,	/* **.....***.. */
	0xc0, 0x80,	/* **......*... */
	0x61, 0xc0,	/* .**....***.. */
	0x3f, 0x60,	/* ..******.**. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x27 */
	0x1c, 0x00,	/* ...***...... */
	0x1c, 0x00,	/* ...***...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x08, 0x00,	/* ....*....... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x28 */
	0x00, 0x40,	/* .........*.. */
	0x00, 0x80,	/* ........*... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x00,	/* .......*.... */
	0x03, 0x00,	/* ......**.... */
	0x02, 0x00,	/* ......*..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x04, 0x00,	/* .....*...... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x02, 0x00,	/* ......*..... */
	0x03, 0x00,	/* ......**.... */
	0x01, 0x00,	/* .......*.... */
	0x01, 0x80,	/* .......**... */
	0x00, 0x80,	/* ........*... */
	0x00, 0x40,	/* .........*.. */

	/* 0x29 */
	0x40, 0x00,	/* .*.......... */
	0x20, 0x00,	/* ..*......... */
	0x30, 0x00,	/* ..**........ */
	0x10, 0x00,	/* ...*........ */
	0x18, 0x00,	/* ...**....... */
	0x08, 0x00,	/* ....*....... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x04, 0x00,	/* .....*...... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x08, 0x00,	/* ....*....... */
	0x18, 0x00,	/* ...**....... */
	0x10, 0x00,	/* ...*........ */
	0x30, 0x00,	/* ..**........ */
	0x20, 0x00,	/* ..*......... */
	0x40, 0x00,	/* .*.......... */

	/* 0x2A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0xcc, 0xc0,	/* **..**..**.. */
	0xed, 0xc0,	/* ***.**.***.. */
	0x3f, 0x00,	/* ..******.... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0xed, 0xc0,	/* ***.**.***.. */
	0xcc, 0xc0,	/* **..**..**.. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x2B */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x2C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x1c, 0x00,	/* ...***...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x08, 0x00,	/* ....*....... */
	0x10, 0x00,	/* ...*........ */

	/* 0x2D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x2E */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x1c, 0x00,	/* ...***...... */
	0x1c, 0x00,	/* ...***...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x2F */
	0x00, 0x00,	/* ............ */
	0x00, 0x20,	/* ..........*. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x40,	/* .........*.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x80,	/* ........*... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x00,	/* .......*.... */
	0x03, 0x00,	/* ......**.... */
	0x02, 0x00,	/* ......*..... */
	0x06, 0x00,	/* .....**..... */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x08, 0x00,	/* ....*....... */
	0x18, 0x00,	/* ...**....... */
	0x10, 0x00,	/* ...*........ */
	0x30, 0x00,	/* ..**........ */
	0x20, 0x00,	/* ..*......... */
	0x60, 0x00,	/* .**......... */
	0x40, 0x00,	/* .*.......... */
	0xc0, 0x00,	/* **.......... */
	0x80, 0x00,	/* *........... */
	0x80, 0x00,	/* *........... */
	0x00, 0x00,	/* ............ */

	/* 0x30 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x1b, 0x00,	/* ...**.**.... */
	0x31, 0x80,	/* ..**...**... */
	0x20, 0x80,	/* ..*.....*... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x20, 0x80,	/* ..*.....*... */
	0x31, 0x80,	/* ..**...**... */
	0x1b, 0x00,	/* ...**.**.... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x31 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x0e, 0x00,	/* ....***..... */
	0x1e, 0x00,	/* ...****..... */
	0x7e, 0x00,	/* .******..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x3f, 0xc0,	/* ..********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x32 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x80, 0x60,	/* *........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x08, 0x00,	/* ....*....... */
	0x10, 0x00,	/* ...*........ */
	0x20, 0x20,	/* ..*.......*. */
	0x40, 0x20,	/* .*........*. */
	0x40, 0x60,	/* .*.......**. */
	0xff, 0xe0,	/* ***********. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x33 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3e, 0x00,	/* ..*****..... */
	0x63, 0x80,	/* .**...***... */
	0x81, 0x80,	/* *......**... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x80,	/* ........*... */
	0x01, 0x00,	/* .......*.... */
	0x1e, 0x00,	/* ...****..... */
	0x3f, 0x80,	/* ..*******... */
	0x01, 0xc0,	/* .......***.. */
	0x00, 0xe0,	/* ........***. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x07, 0x00,	/* .....***.... */
	0xf8, 0x00,	/* *****....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x34 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x03, 0x80,	/* ......***... */
	0x03, 0x80,	/* ......***... */
	0x05, 0x80,	/* .....*.**... */
	0x05, 0x80,	/* .....*.**... */
	0x09, 0x80,	/* ....*..**... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x21, 0x80,	/* ..*....**... */
	0x21, 0x80,	/* ..*....**... */
	0x41, 0x80,	/* .*.....**... */
	0x41, 0x80,	/* .*.....**... */
	0xff, 0xe0,	/* ***********. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x07, 0xe0,	/* .....******. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x35 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xc0,	/* .*********.. */
	0x40, 0x00,	/* .*.......... */
	0x40, 0x00,	/* .*.......... */
	0x40, 0x00,	/* .*.......... */
	0x40, 0x00,	/* .*.......... */
	0x40, 0x00,	/* .*.......... */
	0x5f, 0x00,	/* .*.*****.... */
	0x71, 0x80,	/* .***...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x03, 0x80,	/* ......***... */
	0x7c, 0x00,	/* .*****...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x36 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x03, 0x80,	/* ......***... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x30, 0x00,	/* ..**........ */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xcf, 0x00,	/* **..****.... */
	0xf0, 0xc0,	/* ****....**.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x37 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0xff, 0xe0,	/* ***********. */
	0xc0, 0x20,	/* **........*. */
	0x80, 0x40,	/* *........*.. */
	0x80, 0x80,	/* *.......*... */
	0x00, 0x80,	/* ........*... */
	0x01, 0x00,	/* .......*.... */
	0x01, 0x00,	/* .......*.... */
	0x02, 0x00,	/* ......*..... */
	0x02, 0x00,	/* ......*..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x38 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x20, 0x80,	/* ..*.....*... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x30, 0x80,	/* ..**....*... */
	0x39, 0x00,	/* ..***..*.... */
	0x1e, 0x00,	/* ...****..... */
	0x1f, 0x00,	/* ...*****.... */
	0x23, 0xc0,	/* ..*...****.. */
	0x40, 0xc0,	/* .*......**.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x39 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x61, 0xe0,	/* .**....****. */
	0x1e, 0x60,	/* ...****..**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x00,	/* .......*.... */
	0x06, 0x00,	/* .....**..... */
	0x38, 0x00,	/* ..***....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x3A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x3B */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x04, 0x00,	/* .....*...... */
	0x08, 0x00,	/* ....*....... */

	/* 0x3C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x20,	/* ..........*. */
	0x00, 0x60,	/* .........**. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x00,	/* ..**........ */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x30, 0x00,	/* ..**........ */
	0x18, 0x00,	/* ...**....... */
	0x0c, 0x00,	/* ....**...... */
	0x06, 0x00,	/* .....**..... */
	0x03, 0x00,	/* ......**.... */
	0x01, 0x80,	/* .......**... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x20,	/* ..........*. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x3D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x3E */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x40, 0x00,	/* .*.......... */
	0x60, 0x00,	/* .**......... */
	0x30, 0x00,	/* ..**........ */
	0x18, 0x00,	/* ...**....... */
	0x0c, 0x00,	/* ....**...... */
	0x06, 0x00,	/* .....**..... */
	0x03, 0x00,	/* ......**.... */
	0x01, 0x80,	/* .......**... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x00,	/* ..**........ */
	0x60, 0x00,	/* .**......... */
	0x40, 0x00,	/* .*.......... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x3F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x70, 0x60,	/* .***.....**. */
	0x30, 0x60,	/* ..**.....**. */
	0x00, 0xe0,	/* ........***. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x40 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1f, 0x00,	/* ...*****.... */
	0x20, 0x80,	/* ..*.....*... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0x8d, 0x20,	/* *...**.*..*. */
	0x97, 0x20,	/* *..*.***..*. */
	0xb3, 0x20,	/* *.**..**..*. */
	0xb3, 0x20,	/* *.**..**..*. */
	0xb3, 0x20,	/* *.**..**..*. */
	0xb3, 0x20,	/* *.**..**..*. */
	0xb3, 0x20,	/* *.**..**..*. */
	0xb3, 0x20,	/* *.**..**..*. */
	0xb7, 0x60,	/* *.**.***.**. */
	0x9d, 0xc0,	/* *..***.***.. */
	0xc0, 0x00,	/* **.......... */
	0x40, 0x00,	/* .*.......... */
	0x60, 0x20,	/* .**.......*. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x41 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x42 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xfe, 0x00,	/* *******..... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x80,	/* .**.....*... */
	0x61, 0x00,	/* .**....*.... */
	0x7e, 0x00,	/* .******..... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x61, 0x80,	/* .**....**... */
	0xfe, 0x00,	/* *******..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x43 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x20,	/* .....***..*. */
	0x18, 0xe0,	/* ...**...***. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x20,	/* ..**......*. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x20,	/* ..**......*. */
	0x18, 0xc0,	/* ...**...**.. */
	0x07, 0x00,	/* .....***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x44 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xfc, 0x00,	/* ******...... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x61, 0x80,	/* .**....**... */
	0x63, 0x00,	/* .**...**.... */
	0xfc, 0x00,	/* ******...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x45 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x63, 0x00,	/* .**...**.... */
	0x7f, 0x00,	/* .*******.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x46 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x63, 0x00,	/* .**...**.... */
	0x7f, 0x00,	/* .*******.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0xf0, 0x00,	/* ****........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x47 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x40,	/* ....***..*.. */
	0x31, 0xc0,	/* ..**...***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x40,	/* .**......*.. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc3, 0xe0,	/* **....*****. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0xc0,	/* ..**...***.. */
	0x0e, 0x40,	/* ....***..*.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x48 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf1, 0xe0,	/* ****...****. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x7f, 0xc0,	/* .*********.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xf1, 0xe0,	/* ****...****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x49 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3f, 0x00,	/* ..******.... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x4A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0xe0,	/* .....******. */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x61, 0x80,	/* .**....**... */
	0xe1, 0x80,	/* ***....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0x63, 0x00,	/* .**...**.... */
	0x1c, 0x00,	/* ...***...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x4B */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf1, 0xe0,	/* ****...****. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x80,	/* .**.....*... */
	0x60, 0x80,	/* .**.....*... */
	0x61, 0x00,	/* .**....*.... */
	0x62, 0x00,	/* .**...*..... */
	0x62, 0x00,	/* .**...*..... */
	0x64, 0x00,	/* .**..*...... */
	0x68, 0x00,	/* .**.*....... */
	0x7c, 0x00,	/* .*****...... */
	0x7c, 0x00,	/* .*****...... */
	0x66, 0x00,	/* .**..**..... */
	0x66, 0x00,	/* .**..**..... */
	0x63, 0x00,	/* .**...**.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0xf1, 0xe0,	/* ****...****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x4C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0x00,	/* ****........ */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x4D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xe0, 0x70,	/* ***......*** */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xe0,	/* .**.....***. */
	0x70, 0xe0,	/* .***....***. */
	0x70, 0xe0,	/* .***....***. */
	0x71, 0x60,	/* .***...*.**. */
	0x59, 0x60,	/* .*.**..*.**. */
	0x59, 0x60,	/* .*.**..*.**. */
	0x5b, 0x60,	/* .*.**.**.**. */
	0x4e, 0x60,	/* .*..***..**. */
	0x4e, 0x60,	/* .*..***..**. */
	0x4e, 0x60,	/* .*..***..**. */
	0x44, 0x60,	/* .*...*...**. */
	0x44, 0x60,	/* .*...*...**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x4E */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xe0, 0xe0,	/* ***.....***. */
	0x60, 0x40,	/* .**......*.. */
	0x70, 0x40,	/* .***.....*.. */
	0x70, 0x40,	/* .***.....*.. */
	0x70, 0x40,	/* .***.....*.. */
	0x58, 0x40,	/* .*.**....*.. */
	0x58, 0x40,	/* .*.**....*.. */
	0x4c, 0x40,	/* .*..**...*.. */
	0x4c, 0x40,	/* .*..**...*.. */
	0x46, 0x40,	/* .*...**..*.. */
	0x46, 0x40,	/* .*...**..*.. */
	0x43, 0x40,	/* .*....**.*.. */
	0x43, 0x40,	/* .*....**.*.. */
	0x43, 0x40,	/* .*....**.*.. */
	0x41, 0xc0,	/* .*.....***.. */
	0x41, 0xc0,	/* .*.....***.. */
	0x40, 0xc0,	/* .*......**.. */
	0x40, 0xc0,	/* .*......**.. */
	0xe0, 0x40,	/* ***......*.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x4F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1f, 0x00,	/* ...*****.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x50 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xfe, 0x00,	/* *******..... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x61, 0x80,	/* .**....**... */
	0x7e, 0x00,	/* .******..... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0xf0, 0x00,	/* ****........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x51 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1e, 0x00,	/* ...****..... */
	0x61, 0x80,	/* .**....**... */
	0x40, 0x80,	/* .*......*... */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xcc, 0xc0,	/* **..**..**.. */
	0xd2, 0xc0,	/* **.*..*.**.. */
	0x62, 0x80,	/* .**...*.*... */
	0x63, 0x80,	/* .**...***... */
	0x1e, 0x00,	/* ...****..... */
	0x03, 0x20,	/* ......**..*. */
	0x01, 0xe0,	/* .......****. */
	0x00, 0xc0,	/* ........**.. */

	/* 0x52 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xfe, 0x00,	/* *******..... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0x80,	/* .**.....*... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x80,	/* .**.....*... */
	0x61, 0x80,	/* .**....**... */
	0x7e, 0x00,	/* .******..... */
	0x62, 0x00,	/* .**...*..... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0x80,	/* .**....**... */
	0x61, 0xa0,	/* .**....**.*. */
	0x61, 0xa0,	/* .**....**.*. */
	0xf0, 0xc0,	/* ****....**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x53 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1e, 0x40,	/* ...****..*.. */
	0x61, 0xc0,	/* .**....***.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0x40,	/* **.......*.. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xe0, 0x00,	/* ***......... */
	0x70, 0x00,	/* .***........ */
	0x3e, 0x00,	/* ..*****..... */
	0x0f, 0x80,	/* ....*****... */
	0x01, 0xc0,	/* .......***.. */
	0x00, 0xe0,	/* ........***. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x60,	/* .........**. */
	0x80, 0x60,	/* *........**. */
	0xc0, 0xc0,	/* **......**.. */
	0xe1, 0x80,	/* ***....**... */
	0x9e, 0x00,	/* *..****..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x54 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0xcc, 0xc0,	/* **..**..**.. */
	0x8c, 0x40,	/* *...**...*.. */
	0x8c, 0x40,	/* *...**...*.. */
	0x8c, 0x40,	/* *...**...*.. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x1e, 0x00,	/* ...****..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x55 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x56 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x1b, 0x00,	/* ...**.**.... */
	0x0a, 0x00,	/* ....*.*..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x57 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xe0, 0x60,	/* ***......**. */
	0xc0, 0x20,	/* **........*. */
	0xc0, 0x20,	/* **........*. */
	0xc0, 0x20,	/* **........*. */
	0xc0, 0x20,	/* **........*. */
	0xc0, 0x20,	/* **........*. */
	0xc6, 0x20,	/* **...**...*. */
	0xc6, 0x20,	/* **...**...*. */
	0xc6, 0x20,	/* **...**...*. */
	0xc6, 0x20,	/* **...**...*. */
	0xc6, 0x20,	/* **...**...*. */
	0xcf, 0x20,	/* **..****..*. */
	0xcb, 0x20,	/* **..*.**..*. */
	0x6b, 0x40,	/* .**.*.**.*.. */
	0x6b, 0x40,	/* .**.*.**.*.. */
	0x71, 0x40,	/* .***...*.*.. */
	0x71, 0xc0,	/* .***...***.. */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x58 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x0a, 0x00,	/* ....*.*..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x0a, 0x00,	/* ....*.*..... */
	0x13, 0x00,	/* ...*..**.... */
	0x13, 0x00,	/* ...*..**.... */
	0x21, 0x80,	/* ..*....**... */
	0x21, 0x80,	/* ..*....**... */
	0x40, 0xc0,	/* .*......**.. */
	0x40, 0xc0,	/* .*......**.. */
	0xe1, 0xe0,	/* ***....****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x59 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x0f, 0x00,	/* ....****.... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x5A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x40, 0xc0,	/* .*......**.. */
	0x40, 0xc0,	/* .*......**.. */
	0x81, 0x80,	/* *......**... */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x20,	/* ..**......*. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x5B */
	0x00, 0xc0,	/* ........**.. */
	0x03, 0x80,	/* ......***... */
	0x0e, 0x00,	/* ....***..... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0e, 0x00,	/* ....***..... */
	0x03, 0x80,	/* ......***... */
	0x00, 0xc0,	/* ........**.. */

	/* 0x5C */
	0x00, 0x00,	/* ............ */
	0x80, 0x00,	/* *........... */
	0xc0, 0x00,	/* **.......... */
	0x40, 0x00,	/* .*.......... */
	0x60, 0x00,	/* .**......... */
	0x20, 0x00,	/* ..*......... */
	0x30, 0x00,	/* ..**........ */
	0x10, 0x00,	/* ...*........ */
	0x18, 0x00,	/* ...**....... */
	0x08, 0x00,	/* ....*....... */
	0x0c, 0x00,	/* ....**...... */
	0x04, 0x00,	/* .....*...... */
	0x06, 0x00,	/* .....**..... */
	0x02, 0x00,	/* ......*..... */
	0x03, 0x00,	/* ......**.... */
	0x01, 0x00,	/* .......*.... */
	0x01, 0x80,	/* .......**... */
	0x00, 0x80,	/* ........*... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x40,	/* .........*.. */
	0x00, 0x60,	/* .........**. */
	0x00, 0x20,	/* ..........*. */
	0x00, 0x20,	/* ..........*. */
	0x00, 0x00,	/* ............ */

	/* 0x5D */
	0x60, 0x00,	/* .**......... */
	0x78, 0x00,	/* .****....... */
	0x1e, 0x00,	/* ...****..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1e, 0x00,	/* ...****..... */
	0x78, 0x00,	/* .****....... */
	0x60, 0x00,	/* .**......... */

	/* 0x5E */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x1f, 0x00,	/* ...*****.... */
	0x3b, 0x80,	/* ..***.***... */
	0x60, 0xc0,	/* .**.....**.. */
	0xc0, 0x60,	/* **.......**. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x5F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0xff, 0xe0,	/* ***********. */

	/* 0x60 */
	0x18, 0x00,	/* ...**....... */
	0x3c, 0x00,	/* ..****...... */
	0x1e, 0x00,	/* ...****..... */
	0x07, 0x00,	/* .....***.... */
	0x01, 0x80,	/* .......**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x61 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x73, 0x00,	/* .***..**.... */
	0x41, 0x80,	/* .*.....**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x1f, 0x80,	/* ...******... */
	0x61, 0x80,	/* .**....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0xa0,	/* **.....**.*. */
	0x63, 0xa0,	/* .**...***.*. */
	0x3c, 0xc0,	/* ..****..**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x62 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0x00,	/* .**......... */
	0xe0, 0x00,	/* ***......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x6e, 0x00,	/* .**.***..... */
	0x71, 0x80,	/* .***...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x71, 0x80,	/* .***...**... */
	0x4e, 0x00,	/* .*..***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x63 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x40,	/* .**......*.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x64 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0xc0,	/* ........**.. */
	0x03, 0xc0,	/* ......****.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x0e, 0xc0,	/* ....***.**.. */
	0x31, 0xc0,	/* ..**...***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0xc0,	/* ..**...***.. */
	0x0e, 0xe0,	/* ....***.***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x65 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xe0,	/* .**.....***. */
	0xc0, 0x60,	/* **.......**. */
	0xff, 0xe0,	/* ***********. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x66 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x01, 0xc0,	/* .......***.. */
	0x06, 0x60,	/* .....**..**. */
	0x04, 0x60,	/* .....*...**. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0xff, 0xc0,	/* **********.. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x67 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x60,	/* .........**. */
	0x0e, 0xe0,	/* ....***.***. */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x10, 0x00,	/* ...*........ */
	0x30, 0x00,	/* ..**........ */
	0x1f, 0x00,	/* ...*****.... */
	0x27, 0xc0,	/* ..*..*****.. */
	0x40, 0xe0,	/* .*......***. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */

	/* 0x68 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0x00,	/* .**......... */
	0xe0, 0x00,	/* ***......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x6f, 0x00,	/* .**.****.... */
	0x71, 0x80,	/* .***...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xf1, 0xe0,	/* ****...****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x69 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x1c, 0x00,	/* ...***...... */
	0x1c, 0x00,	/* ...***...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3c, 0x00,	/* ..****...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x6A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x07, 0x00,	/* .....***.... */
	0x07, 0x00,	/* .....***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0x03, 0x00,	/* ......**.... */
	0xc3, 0x00,	/* **....**.... */
	0xc6, 0x00,	/* **...**..... */
	0x7c, 0x00,	/* .*****...... */

	/* 0x6B */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0x00,	/* .**......... */
	0xe0, 0x00,	/* ***......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x61, 0xe0,	/* .**....****. */
	0x60, 0x80,	/* .**.....*... */
	0x61, 0x00,	/* .**....*.... */
	0x62, 0x00,	/* .**...*..... */
	0x64, 0x00,	/* .**..*...... */
	0x68, 0x00,	/* .**.*....... */
	0x78, 0x00,	/* .****....... */
	0x6c, 0x00,	/* .**.**...... */
	0x66, 0x00,	/* .**..**..... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0xf1, 0xe0,	/* ****...****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x6C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x3c, 0x00,	/* ..****...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x6D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x6d, 0xc0,	/* .**.**.***.. */
	0xf6, 0x60,	/* ****.**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0x66, 0x60,	/* .**..**..**. */
	0xef, 0x70,	/* ***.****.*** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x6E */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x66, 0x00,	/* .**..**..... */
	0xf9, 0x80,	/* *****..**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xf1, 0xe0,	/* ****...****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x6F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x70 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x6e, 0x00,	/* .**.***..... */
	0xf1, 0x80,	/* ****...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x71, 0x80,	/* .***...**... */
	0x6e, 0x00,	/* .**.***..... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0xf0, 0x00,	/* ****........ */

	/* 0x71 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x40,	/* ....***..*.. */
	0x31, 0xc0,	/* ..**...***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0xc0,	/* ..**...***.. */
	0x0e, 0xc0,	/* ....***.**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x01, 0xe0,	/* .......****. */

	/* 0x72 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x31, 0xc0,	/* ..**...***.. */
	0xf3, 0xe0,	/* ****..*****. */
	0x36, 0x60,	/* ..**.**..**. */
	0x38, 0x00,	/* ..***....... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0xfc, 0x00,	/* ******...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x73 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1e, 0x40,	/* ...****..*.. */
	0x61, 0xc0,	/* .**....***.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0x40,	/* **.......*.. */
	0xe0, 0x00,	/* ***......... */
	0x7c, 0x00,	/* .*****...... */
	0x1f, 0x80,	/* ...******... */
	0x03, 0xc0,	/* ......****.. */
	0x00, 0xe0,	/* ........***. */
	0x80, 0x60,	/* *........**. */
	0xc0, 0x60,	/* **.......**. */
	0xe0, 0xc0,	/* ***.....**.. */
	0x9f, 0x00,	/* *..*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x74 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0xff, 0x80,	/* *********... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x00,	/* ...**....... */
	0x18, 0x20,	/* ...**.....*. */
	0x18, 0x20,	/* ...**.....*. */
	0x0c, 0x40,	/* ....**...*.. */
	0x07, 0x80,	/* .....****... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x75 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0xc0,	/* .**.....**.. */
	0xe1, 0xc0,	/* ***....***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x33, 0xc0,	/* ..**..****.. */
	0x1c, 0xe0,	/* ...***..***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x76 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x1a, 0x00,	/* ...**.*..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x77 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xe0, 0x60,	/* ***......**. */
	0xc0, 0x20,	/* **........*. */
	0xc0, 0x20,	/* **........*. */
	0xc6, 0x20,	/* **...**...*. */
	0xc6, 0x20,	/* **...**...*. */
	0xc6, 0x20,	/* **...**...*. */
	0xce, 0x20,	/* **..***...*. */
	0xcb, 0x20,	/* **..*.**..*. */
	0xcb, 0x20,	/* **..*.**..*. */
	0x51, 0x60,	/* .*.*...*.**. */
	0x71, 0xc0,	/* .***...***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x20, 0x80,	/* ..*.....*... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x78 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x0e, 0x00,	/* ....***..... */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x13, 0x00,	/* ...*..**.... */
	0x13, 0x00,	/* ...*..**.... */
	0x21, 0x80,	/* ..*....**... */
	0x40, 0xc0,	/* .*......**.. */
	0xe1, 0xe0,	/* ***....****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x79 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x18, 0x80,	/* ...**...*... */
	0x19, 0x00,	/* ...**..*.... */
	0x0d, 0x00,	/* ....**.*.... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0xc8, 0x00,	/* **..*....... */
	0xc8, 0x00,	/* **..*....... */
	0x70, 0x00,	/* .***........ */

	/* 0x7A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x60, 0xc0,	/* .**.....**.. */
	0x41, 0x80,	/* .*.....**... */
	0x81, 0x80,	/* *......**... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x40,	/* ..**.....*.. */
	0x60, 0x40,	/* .**......*.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x7B */
	0x00, 0x40,	/* .........*.. */
	0x00, 0x80,	/* ........*... */
	0x00, 0x80,	/* ........*... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x00,	/* .......*.... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x02, 0x00,	/* ......*..... */
	0x01, 0x00,	/* .......*.... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x00, 0x80,	/* ........*... */
	0x00, 0x80,	/* ........*... */
	0x00, 0x40,	/* .........*.. */

	/* 0x7C */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */

	/* 0x7D */
	0x40, 0x00,	/* .*.......... */
	0x20, 0x00,	/* ..*......... */
	0x20, 0x00,	/* ..*......... */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x10, 0x00,	/* ...*........ */
	0x08, 0x00,	/* ....*....... */
	0x04, 0x00,	/* .....*...... */
	0x08, 0x00,	/* ....*....... */
	0x10, 0x00,	/* ...*........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x00,	/* ..**........ */
	0x20, 0x00,	/* ..*......... */
	0x20, 0x00,	/* ..*......... */
	0x40, 0x00,	/* .*.......... */

	/* 0x7E */
	0x38, 0x20,	/* ..***.....*. */
	0x7c, 0x60,	/* .*****...**. */
	0xc7, 0xc0,	/* **...*****.. */
	0x83, 0x80,	/* *.....***... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x7F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x80 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x81 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x82 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x83 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x84 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x85 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x86 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x87 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x88 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x89 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x8A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x8B */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x8C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x8D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x8E */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x8F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x90 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x91 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x92 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x93 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x94 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x95 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x96 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x97 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x98 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x99 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x9A */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x9B */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x9C */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x9D */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x9E */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0x9F */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA0 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA1 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA2 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x1f, 0x00,	/* ...*****.... */
	0x24, 0x80,	/* ..*..*..*... */
	0x64, 0x40,	/* .**..*...*.. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x00,	/* **...*...... */
	0xc4, 0x00,	/* **...*...... */
	0xc4, 0x00,	/* **...*...... */
	0xc4, 0x00,	/* **...*...... */
	0xc4, 0x00,	/* **...*...... */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0x64, 0x40,	/* .**..*...*.. */
	0x24, 0x80,	/* ..*..*..*... */
	0x1f, 0x00,	/* ...*****.... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA3 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x03, 0x80,	/* ......***... */
	0x04, 0x40,	/* .....*...*.. */
	0x0c, 0x60,	/* ....**...**. */
	0x0c, 0x60,	/* ....**...**. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x4c, 0x00,	/* .*..**...... */
	0x7f, 0xc0,	/* .*********.. */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x80,	/* ..*******... */
	0x6c, 0xe0,	/* .**.**..***. */
	0x6c, 0xe0,	/* .**.**..***. */
	0x38, 0x00,	/* ..***....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA4 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x80, 0x20,	/* *.........*. */
	0xce, 0x60,	/* **..***..**. */
	0x7f, 0xc0,	/* .*********.. */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x7f, 0xc0,	/* .*********.. */
	0xce, 0x60,	/* **..***..**. */
	0x80, 0x20,	/* *.........*. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA5 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x79, 0xe0,	/* .****..****. */
	0x30, 0xc0,	/* ..**....**.. */
	0x30, 0x80,	/* ..**....*... */
	0x18, 0x80,	/* ...**...*... */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x00,	/* ...**..*.... */
	0x0d, 0x00,	/* ....**.*.... */
	0x7d, 0xe0,	/* .*****.****. */
	0x0f, 0x00,	/* ....****.... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x7f, 0xe0,	/* .**********. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0f, 0x00,	/* ....****.... */
	0x3f, 0xc0,	/* ..********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA6 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA7 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x00,	/* .**......... */
	0x30, 0x00,	/* ..**........ */
	0x1f, 0x00,	/* ...*****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x80,	/* ....*****... */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x60,	/* .........**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA8 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xA9 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x60, 0x60,	/* .**......**. */
	0x40, 0x20,	/* .*........*. */
	0xcf, 0x30,	/* **..****..** */
	0x98, 0xd0,	/* *..**...**.* */
	0xb0, 0x70,	/* *.**.....*** */
	0xe0, 0x70,	/* ***......*** */
	0xe0, 0x10,	/* ***........* */
	0xe0, 0x10,	/* ***........* */
	0xe0, 0x10,	/* ***........* */
	0xe0, 0x10,	/* ***........* */
	0xb0, 0x30,	/* *.**......** */
	0x98, 0xd0,	/* *..**...**.* */
	0xcf, 0x30,	/* **..****..** */
	0x40, 0x20,	/* .*........*. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xAA */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x18, 0x80,	/* ...**...*... */
	0x18, 0xc0,	/* ...**...**.. */
	0x00, 0xc0,	/* ........**.. */
	0x07, 0xc0,	/* .....*****.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x07, 0x40,	/* .....***.*.. */
	0x00, 0x00,	/* ............ */
	0x1f, 0xc0,	/* ...*******.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xAB */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x02, 0x20,	/* ......*...*. */
	0x06, 0x60,	/* .....**..**. */
	0x04, 0x40,	/* .....*...*.. */
	0x0c, 0xc0,	/* ....**..**.. */
	0x08, 0x80,	/* ....*...*... */
	0x19, 0x80,	/* ...**..**... */
	0x11, 0x00,	/* ...*...*.... */
	0x33, 0x00,	/* ..**..**.... */
	0x22, 0x00,	/* ..*...*..... */
	0x66, 0x00,	/* .**..**..... */
	0x66, 0x00,	/* .**..**..... */
	0x22, 0x00,	/* ..*...*..... */
	0x33, 0x00,	/* ..**..**.... */
	0x11, 0x00,	/* ...*...*.... */
	0x19, 0x80,	/* ...**..**... */
	0x08, 0x80,	/* ....*...*... */
	0x0c, 0xc0,	/* ....**..**.. */
	0x04, 0x40,	/* .....*...*.. */
	0x06, 0x60,	/* .....**..**. */
	0x02, 0x20,	/* ......*...*. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xAC */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xAD */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xAE */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x30, 0xc0,	/* ..**....**.. */
	0x60, 0x60,	/* .**......**. */
	0x40, 0x20,	/* .*........*. */
	0xdf, 0x30,	/* **.*****..** */
	0xb0, 0x90,	/* *.**....*..* */
	0xb0, 0xd0,	/* *.**....**.* */
	0xb0, 0xd0,	/* *.**....**.* */
	0xb0, 0xd0,	/* *.**....**.* */
	0xbf, 0x90,	/* *.*******..* */
	0xb1, 0x10,	/* *.**...*...* */
	0xb0, 0x90,	/* *.**....*..* */
	0xb0, 0xd0,	/* *.**....**.* */
	0xb0, 0xd0,	/* *.**....**.* */
	0xf0, 0xf0,	/* ****....**** */
	0x40, 0x20,	/* .*........*. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xAF */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xe0,	/* ***********. */
	0xff, 0xe0,	/* ***********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB0 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x1b, 0x00,	/* ...**.**.... */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x1b, 0x00,	/* ...**.**.... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB1 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x00, 0x00,	/* ............ */
	0x7f, 0xe0,	/* .**********. */
	0x7f, 0xe0,	/* .**********. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB2 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x01, 0x80,	/* .......**... */
	0x03, 0x00,	/* ......**.... */
	0x04, 0x00,	/* .....*...... */
	0x08, 0x80,	/* ....*...*... */
	0x19, 0x80,	/* ...**..**... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB3 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0f, 0x00,	/* ....****.... */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x01, 0x80,	/* .......**... */
	0x07, 0x00,	/* .....***.... */
	0x01, 0x80,	/* .......**... */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB4 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x03, 0x80,	/* ......***... */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB5 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x60,	/* ....**...**. */
	0x0c, 0x60,	/* ....**...**. */
	0x08, 0x40,	/* ....*....*.. */
	0x08, 0xc0,	/* ....*...**.. */
	0x10, 0x80,	/* ...*....*... */
	0x10, 0x80,	/* ...*....*... */
	0x31, 0x80,	/* ..**...**... */
	0x2e, 0xa0,	/* ..*.***.*.*. */
	0x60, 0xe0,	/* .**.....***. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */

	/* 0xB6 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1f, 0xf0,	/* ...********* */
	0x3f, 0x40,	/* ..******.*.. */
	0x7f, 0x40,	/* .*******.*.. */
	0x7f, 0x40,	/* .*******.*.. */
	0xff, 0x40,	/* ********.*.. */
	0xff, 0x40,	/* ********.*.. */
	0xff, 0x40,	/* ********.*.. */
	0x7f, 0x40,	/* .*******.*.. */
	0x3f, 0x40,	/* ..******.*.. */
	0x0f, 0x40,	/* ....****.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x01, 0x40,	/* .......*.*.. */
	0x07, 0x70,	/* .....***.*** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB7 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xB8 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x03, 0x80,	/* ......***... */
	0x03, 0x00,	/* ......**.... */
	0x06, 0x00,	/* .....**..... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */

	/* 0xB9 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x0e, 0x00,	/* ....***..... */
	0x1e, 0x00,	/* ...****..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xBA */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x08, 0x80,	/* ....*...*... */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x18, 0xc0,	/* ...**...**.. */
	0x08, 0x80,	/* ....*...*... */
	0x07, 0x00,	/* .....***.... */
	0x00, 0x00,	/* ............ */
	0x1f, 0xc0,	/* ...*******.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xBB */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x44, 0x00,	/* .*...*...... */
	0x66, 0x00,	/* .**..**..... */
	0x22, 0x00,	/* ..*...*..... */
	0x33, 0x00,	/* ..**..**.... */
	0x11, 0x00,	/* ...*...*.... */
	0x19, 0x80,	/* ...**..**... */
	0x08, 0x80,	/* ....*...*... */
	0x0c, 0xc0,	/* ....**..**.. */
	0x04, 0x40,	/* .....*...*.. */
	0x06, 0x60,	/* .....**..**. */
	0x06, 0x60,	/* .....**..**. */
	0x04, 0x40,	/* .....*...*.. */
	0x0c, 0xc0,	/* ....**..**.. */
	0x08, 0x80,	/* ....*...*... */
	0x19, 0x80,	/* ...**..**... */
	0x11, 0x00,	/* ...*...*.... */
	0x33, 0x00,	/* ..**..**.... */
	0x22, 0x00,	/* ..*...*..... */
	0x66, 0x00,	/* .**..**..... */
	0x44, 0x00,	/* .*...*...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xBC */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x30, 0x00,	/* ..**........ */
	0x70, 0x00,	/* .***........ */
	0xb0, 0x00,	/* *.**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x10,	/* ..**.......* */
	0x30, 0x30,	/* ..**......** */
	0x30, 0x60,	/* ..**.....**. */
	0x31, 0xc0,	/* ..**...***.. */
	0x03, 0x00,	/* ......**.... */
	0x0e, 0x00,	/* ....***..... */
	0x18, 0x00,	/* ...**....... */
	0x70, 0xc0,	/* .***....**.. */
	0xc1, 0xc0,	/* **.....***.. */
	0x82, 0xc0,	/* *.....*.**.. */
	0x04, 0xc0,	/* .....*..**.. */
	0x0c, 0xc0,	/* ....**..**.. */
	0x0f, 0xf0,	/* ....******** */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xBD */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x30, 0x00,	/* ..**........ */
	0x70, 0x00,	/* .***........ */
	0xb0, 0x00,	/* *.**........ */
	0x30, 0x00,	/* ..**........ */
	0x30, 0x10,	/* ..**.......* */
	0x30, 0x30,	/* ..**......** */
	0x30, 0x60,	/* ..**.....**. */
	0x31, 0xc0,	/* ..**...***.. */
	0x03, 0x00,	/* ......**.... */
	0x0e, 0x00,	/* ....***..... */
	0x18, 0x00,	/* ...**....... */
	0x71, 0xe0,	/* .***...****. */
	0xc3, 0x30,	/* **....**..** */
	0x83, 0x30,	/* *.....**..** */
	0x00, 0x30,	/* ..........** */
	0x00, 0x60,	/* .........**. */
	0x01, 0x80,	/* .......**... */
	0x03, 0x10,	/* ......**...* */
	0x03, 0xf0,	/* ......****** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xBE */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x78, 0x00,	/* .****....... */
	0xcc, 0x00,	/* **..**...... */
	0x8c, 0x00,	/* *...**...... */
	0x0c, 0x00,	/* ....**...... */
	0x30, 0x10,	/* ..**.......* */
	0x0c, 0x30,	/* ....**....** */
	0xcc, 0x60,	/* **..**...**. */
	0xcd, 0xc0,	/* **..**.***.. */
	0x73, 0x00,	/* .***..**.... */
	0x0e, 0x00,	/* ....***..... */
	0x18, 0x00,	/* ...**....... */
	0x70, 0xc0,	/* .***....**.. */
	0xc1, 0xc0,	/* **.....***.. */
	0x82, 0xc0,	/* *.....*.**.. */
	0x04, 0xc0,	/* .....*..**.. */
	0x0c, 0xc0,	/* ....**..**.. */
	0x0f, 0xf0,	/* ....******** */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0xc0,	/* ........**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xBF */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x07, 0x00,	/* .....***.... */
	0x07, 0x00,	/* .....***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x02, 0x00,	/* ......*..... */
	0x02, 0x00,	/* ......*..... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x0c, 0x00,	/* ....**...... */
	0x18, 0x00,	/* ...**....... */
	0x30, 0x00,	/* ..**........ */
	0x70, 0x00,	/* .***........ */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xe0,	/* .**.....***. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC0 */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC1 */
	0x01, 0xc0,	/* .......***.. */
	0x03, 0x00,	/* ......**.... */
	0x04, 0x00,	/* .....*...... */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC2 */
	0x06, 0x00,	/* .....**..... */
	0x19, 0x80,	/* ...**..**... */
	0x20, 0x40,	/* ..*......*.. */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC3 */
	0x1c, 0xc0,	/* ...***..**.. */
	0x67, 0x00,	/* .**..***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC4 */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC5 */
	0x0f, 0x00,	/* ....****.... */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x0f, 0x00,	/* ....****.... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x09, 0x80,	/* ....*..**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x11, 0x80,	/* ...*...**... */
	0x20, 0xc0,	/* ..*.....**.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x3f, 0xc0,	/* ..********.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0x40, 0x60,	/* .*.......**. */
	0xe0, 0xf0,	/* ***.....**** */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC6 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0xf0,	/* .....******* */
	0x07, 0x30,	/* .....***..** */
	0x07, 0x10,	/* .....***...* */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x00,	/* ....*.**.... */
	0x0b, 0x20,	/* ....*.**..*. */
	0x13, 0x20,	/* ...*..**..*. */
	0x13, 0x60,	/* ...*..**.**. */
	0x13, 0xe0,	/* ...*..*****. */
	0x23, 0x60,	/* ..*...**.**. */
	0x23, 0x20,	/* ..*...**..*. */
	0x3f, 0x20,	/* ..******..*. */
	0x23, 0x00,	/* ..*...**.... */
	0x43, 0x00,	/* .*....**.... */
	0x43, 0x00,	/* .*....**.... */
	0x43, 0x10,	/* .*....**...* */
	0x43, 0x30,	/* .*....**..** */
	0xe7, 0xf0,	/* ***..******* */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC7 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x20,	/* .....***..*. */
	0x18, 0xe0,	/* ...**...***. */
	0x30, 0x60,	/* ..**.....**. */
	0x30, 0x20,	/* ..**......*. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x30, 0x20,	/* ..**......*. */
	0x30, 0x20,	/* ..**......*. */
	0x18, 0xc0,	/* ...**...**.. */
	0x07, 0x00,	/* .....***.... */
	0x02, 0x00,	/* ......*..... */
	0x01, 0x00,	/* .......*.... */
	0x01, 0x00,	/* .......*.... */
	0x06, 0x00,	/* .....**..... */

	/* 0xC8 */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x63, 0x00,	/* .**...**.... */
	0x7f, 0x00,	/* .*******.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xC9 */
	0x03, 0x80,	/* ......***... */
	0x06, 0x00,	/* .....**..... */
	0x08, 0x00,	/* ....*....... */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x63, 0x00,	/* .**...**.... */
	0x7f, 0x00,	/* .*******.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xCA */
	0x04, 0x00,	/* .....*...... */
	0x1b, 0x00,	/* ...**.**.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x63, 0x00,	/* .**...**.... */
	0x7f, 0x00,	/* .*******.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xCB */
	0x33, 0x00,	/* ..**..**.... */
	0x33, 0x00,	/* ..**..**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x63, 0x00,	/* .**...**.... */
	0x7f, 0x00,	/* .*******.... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x00,	/* .**....*.... */
	0x61, 0x00,	/* .**....*.... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xCC */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x3f, 0x00,	/* ..******.... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xCD */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x3f, 0x00,	/* ..******.... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xCE */
	0x0c, 0x00,	/* ....**...... */
	0x12, 0x00,	/* ...*..*..... */
	0x21, 0x00,	/* ..*....*.... */
	0x00, 0x00,	/* ............ */
	0x3f, 0x00,	/* ..******.... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xCF */
	0x33, 0x00,	/* ..**..**.... */
	0x33, 0x00,	/* ..**..**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3f, 0x00,	/* ..******.... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x3f, 0x00,	/* ..******.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD0 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xfc, 0x00,	/* ******...... */
	0x63, 0x00,	/* .**...**.... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0xfc, 0x60,	/* ******...**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x61, 0x80,	/* .**....**... */
	0x63, 0x00,	/* .**...**.... */
	0xfc, 0x00,	/* ******...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD1 */
	0x1c, 0xc0,	/* ...***..**.. */
	0x67, 0x00,	/* .**..***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xe0, 0xe0,	/* ***.....***. */
	0x60, 0x40,	/* .**......*.. */
	0x70, 0x40,	/* .***.....*.. */
	0x70, 0x40,	/* .***.....*.. */
	0x58, 0x40,	/* .*.**....*.. */
	0x58, 0x40,	/* .*.**....*.. */
	0x58, 0x40,	/* .*.**....*.. */
	0x4c, 0x40,	/* .*..**...*.. */
	0x4c, 0x40,	/* .*..**...*.. */
	0x46, 0x40,	/* .*...**..*.. */
	0x46, 0x40,	/* .*...**..*.. */
	0x43, 0x40,	/* .*....**.*.. */
	0x43, 0x40,	/* .*....**.*.. */
	0x41, 0xc0,	/* .*.....***.. */
	0x41, 0xc0,	/* .*.....***.. */
	0x40, 0xc0,	/* .*......**.. */
	0xe0, 0xc0,	/* ***.....**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD2 */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x1f, 0x00,	/* ...*****.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD3 */
	0x03, 0x80,	/* ......***... */
	0x06, 0x00,	/* .....**..... */
	0x08, 0x00,	/* ....*....... */
	0x00, 0x00,	/* ............ */
	0x1f, 0x00,	/* ...*****.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD4 */
	0x04, 0x00,	/* .....*...... */
	0x1b, 0x00,	/* ...**.**.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x00, 0x00,	/* ............ */
	0x1f, 0x00,	/* ...*****.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD5 */
	0x1c, 0xc0,	/* ...***..**.. */
	0x67, 0x00,	/* .**..***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1f, 0x00,	/* ...*****.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD6 */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1f, 0x00,	/* ...*****.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD7 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xc0, 0x60,	/* **.......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x1b, 0x00,	/* ...**.**.... */
	0x0e, 0x00,	/* ....***..... */
	0x0e, 0x00,	/* ....***..... */
	0x1b, 0x00,	/* ...**.**.... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0xc0, 0x60,	/* **.......**. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD8 */
	0x00, 0x00,	/* ............ */
	0x00, 0x40,	/* .........*.. */
	0x1f, 0x40,	/* ...*****.*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0xc0,	/* .*......**.. */
	0xc1, 0x60,	/* **.....*.**. */
	0xc1, 0x60,	/* **.....*.**. */
	0xc2, 0x60,	/* **....*..**. */
	0xc2, 0x60,	/* **....*..**. */
	0xc2, 0x60,	/* **....*..**. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0xc8, 0x60,	/* **..*....**. */
	0xc8, 0x60,	/* **..*....**. */
	0xc8, 0x60,	/* **..*....**. */
	0xd0, 0x60,	/* **.*.....**. */
	0xd0, 0x60,	/* **.*.....**. */
	0xe0, 0x60,	/* ***......**. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x5f, 0x00,	/* .*.*****.... */
	0x40, 0x00,	/* .*.......... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xD9 */
	0x1c, 0x00,	/* ...***...... */
	0x06, 0x00,	/* .....**..... */
	0x01, 0x00,	/* .......*.... */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xDA */
	0x03, 0x80,	/* ......***... */
	0x06, 0x00,	/* .....**..... */
	0x08, 0x00,	/* ....*....... */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xDB */
	0x04, 0x00,	/* .....*...... */
	0x1b, 0x00,	/* ...**.**.... */
	0x60, 0xc0,	/* .**.....**.. */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xDC */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xDD */
	0x03, 0x80,	/* ......***... */
	0x06, 0x00,	/* .....**..... */
	0x08, 0x00,	/* ....*....... */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x19, 0x00,	/* ...**..*.... */
	0x19, 0x00,	/* ...**..*.... */
	0x0f, 0x00,	/* ....****.... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x06, 0x00,	/* .....**..... */
	0x1f, 0x80,	/* ...******... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xDE */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0x00,	/* ****........ */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x7e, 0x00,	/* .******..... */
	0x61, 0x80,	/* .**....**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x61, 0x80,	/* .**....**... */
	0x7e, 0x00,	/* .******..... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0xf0, 0x00,	/* ****........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xDF */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3e, 0x00,	/* ..*****..... */
	0x41, 0x80,	/* .*.....**... */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0x80,	/* **......*... */
	0xc1, 0x00,	/* **.....*.... */
	0xce, 0x00,	/* **..***..... */
	0xc1, 0x80,	/* **.....**... */
	0xc0, 0xc0,	/* **......**.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0xc0,	/* **......**.. */
	0xc1, 0x80,	/* **.....**... */
	0xce, 0x00,	/* **..***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE0 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x73, 0x00,	/* .***..**.... */
	0x41, 0x80,	/* .*.....**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x1f, 0x80,	/* ...******... */
	0x61, 0x80,	/* .**....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0xa0,	/* **.....**.*. */
	0x63, 0xa0,	/* .**...***.*. */
	0x3c, 0xc0,	/* ..****..**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE1 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x73, 0x00,	/* .***..**.... */
	0x41, 0x80,	/* .*.....**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x1f, 0x80,	/* ...******... */
	0x61, 0x80,	/* .**....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0xa0,	/* **.....**.*. */
	0x63, 0xa0,	/* .**...***.*. */
	0x3c, 0xc0,	/* ..****..**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE2 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x12, 0x00,	/* ...*..*..... */
	0x33, 0x00,	/* ..**..**.... */
	0x61, 0x80,	/* .**....**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x73, 0x00,	/* .***..**.... */
	0x41, 0x80,	/* .*.....**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x1f, 0x80,	/* ...******... */
	0x71, 0x80,	/* .***...**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0xa0,	/* **.....**.*. */
	0x63, 0xa0,	/* .**...***.*. */
	0x3c, 0xc0,	/* ..****..**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE3 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x39, 0x80,	/* ..***..**... */
	0x67, 0x00,	/* .**..***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x73, 0x00,	/* .***..**.... */
	0x41, 0x80,	/* .*.....**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x1f, 0x80,	/* ...******... */
	0x61, 0x80,	/* .**....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0xa0,	/* **.....**.*. */
	0x63, 0xa0,	/* .**...***.*. */
	0x3c, 0xc0,	/* ..****..**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE4 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x33, 0x00,	/* ..**..**.... */
	0x33, 0x00,	/* ..**..**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x73, 0x00,	/* .***..**.... */
	0x41, 0x80,	/* .*.....**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x1f, 0x80,	/* ...******... */
	0x61, 0x80,	/* .**....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0xa0,	/* **.....**.*. */
	0x63, 0xa0,	/* .**...***.*. */
	0x3c, 0xc0,	/* ..****..**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE5 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1e, 0x00,	/* ...****..... */
	0x33, 0x00,	/* ..**..**.... */
	0x33, 0x00,	/* ..**..**.... */
	0x1e, 0x00,	/* ...****..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0x00,	/* ...***...... */
	0x73, 0x00,	/* .***..**.... */
	0x41, 0x80,	/* .*.....**... */
	0x01, 0x80,	/* .......**... */
	0x01, 0x80,	/* .......**... */
	0x1f, 0x80,	/* ...******... */
	0x61, 0x80,	/* .**....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0x80,	/* **.....**... */
	0xc1, 0xa0,	/* **.....**.*. */
	0x63, 0xa0,	/* .**...***.*. */
	0x3c, 0xc0,	/* ..****..**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE6 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x31, 0x80,	/* ..**...**... */
	0x4a, 0x40,	/* .*..*.*..*.. */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0x04, 0x60,	/* .....*...**. */
	0x1f, 0xe0,	/* ...********. */
	0x24, 0x00,	/* ..*..*...... */
	0x44, 0x00,	/* .*...*...... */
	0xc4, 0x00,	/* **...*...... */
	0xc4, 0x60,	/* **...*...**. */
	0xc4, 0x60,	/* **...*...**. */
	0xca, 0x60,	/* **..*.*..**. */
	0x71, 0xc0,	/* .***...***.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE7 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x20,	/* .....***..*. */
	0x18, 0xe0,	/* ...**...***. */
	0x30, 0x60,	/* ..**.....**. */
	0x60, 0x20,	/* .**.......*. */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x30, 0x20,	/* ..**......*. */
	0x18, 0xc0,	/* ...**...**.. */
	0x07, 0x00,	/* .....***.... */
	0x02, 0x00,	/* ......*..... */
	0x01, 0x00,	/* .......*.... */
	0x01, 0x00,	/* .......*.... */
	0x06, 0x00,	/* .....**..... */

	/* 0xE8 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xe0,	/* .**.....***. */
	0xc0, 0x60,	/* **.......**. */
	0xff, 0xe0,	/* ***********. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xE9 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xe0,	/* .**.....***. */
	0xc0, 0x60,	/* **.......**. */
	0xff, 0xe0,	/* ***********. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x38, 0xc0,	/* ..***...**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xEA */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x11, 0x00,	/* ...*...*.... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xe0,	/* .**.....***. */
	0xc0, 0x60,	/* **.......**. */
	0xff, 0xe0,	/* ***********. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xEB */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xe0,	/* .**.....***. */
	0xc0, 0x60,	/* **.......**. */
	0xff, 0xe0,	/* ***********. */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0xc0, 0x00,	/* **.......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x20,	/* .**.......*. */
	0x30, 0xc0,	/* ..**....**.. */
	0x0f, 0x00,	/* ....****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xEC */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3c, 0x00,	/* ..****...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xED */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3c, 0x00,	/* ..****...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xEE */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x12, 0x00,	/* ...*..*..... */
	0x33, 0x00,	/* ..**..**.... */
	0x61, 0x80,	/* .**....**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3c, 0x00,	/* ..****...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xEF */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x33, 0x00,	/* ..**..**.... */
	0x33, 0x00,	/* ..**..**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x3c, 0x00,	/* ..****...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF0 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x31, 0x80,	/* ..**...**... */
	0x3d, 0x80,	/* ..****.**... */
	0x07, 0x00,	/* .....***.... */
	0x07, 0x00,	/* .....***.... */
	0x0d, 0x80,	/* ....**.**... */
	0x30, 0x80,	/* ..**....*... */
	0x00, 0xc0,	/* ........**.. */
	0x0f, 0x40,	/* ....****.*.. */
	0x19, 0xc0,	/* ...**..***.. */
	0x30, 0x60,	/* ..**.....**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x30, 0xc0,	/* ..**....**.. */
	0x1f, 0x00,	/* ...*****.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF1 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x39, 0x80,	/* ..***..**... */
	0x67, 0x00,	/* .**..***.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x66, 0x00,	/* .**..**..... */
	0xf9, 0x80,	/* *****..**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0xf1, 0xe0,	/* ****...****. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF2 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF3 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF4 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x0a, 0x00,	/* ....*.*..... */
	0x1b, 0x00,	/* ...**.**.... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF5 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x1c, 0xc0,	/* ...***..**.. */
	0x33, 0x80,	/* ..**..***... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF6 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x31, 0x80,	/* ..**...**... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x00,	/* ....***..... */
	0x31, 0x80,	/* ..**...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x40, 0x40,	/* .*.......*.. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0xc0, 0x60,	/* **.......**. */
	0x40, 0x40,	/* .*.......*.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x31, 0x80,	/* ..**...**... */
	0x0e, 0x00,	/* ....***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF7 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xff, 0xc0,	/* **********.. */
	0xff, 0xc0,	/* **********.. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0c, 0x00,	/* ....**...... */
	0x0c, 0x00,	/* ....**...... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF8 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x0e, 0x60,	/* ....***..**. */
	0x31, 0xc0,	/* ..**...***.. */
	0x60, 0x80,	/* .**.....*... */
	0x41, 0xc0,	/* .*.....***.. */
	0xc3, 0x60,	/* **....**.**. */
	0xc6, 0x60,	/* **...**..**. */
	0xc4, 0x60,	/* **...*...**. */
	0xcc, 0x60,	/* **..**...**. */
	0xd8, 0x60,	/* **.**....**. */
	0x70, 0x40,	/* .***.....*.. */
	0x20, 0xc0,	/* ..*.....**.. */
	0x71, 0x80,	/* .***...**... */
	0xce, 0x00,	/* **..***..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xF9 */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x38, 0x00,	/* ..***....... */
	0x0c, 0x00,	/* ....**...... */
	0x02, 0x00,	/* ......*..... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0xc0,	/* .**.....**.. */
	0xe1, 0xc0,	/* ***....***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x33, 0xc0,	/* ..**..****.. */
	0x1c, 0xe0,	/* ...***..***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xFA */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0xc0,	/* .**.....**.. */
	0xe1, 0xc0,	/* ***....***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x33, 0xc0,	/* ..**..****.. */
	0x1c, 0xe0,	/* ...***..***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xFB */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x04, 0x00,	/* .....*...... */
	0x0a, 0x00,	/* ....*.*..... */
	0x1b, 0x00,	/* ...**.**.... */
	0x31, 0x80,	/* ..**...**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0xc0,	/* .**.....**.. */
	0xe1, 0xc0,	/* ***....***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x33, 0xc0,	/* ..**..****.. */
	0x1c, 0xe0,	/* ...***..***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xFC */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x33, 0x00,	/* ..**..**.... */
	0x33, 0x00,	/* ..**..**.... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x60, 0xc0,	/* .**.....**.. */
	0xe1, 0xc0,	/* ***....***.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0xc0,	/* .**.....**.. */
	0x33, 0xc0,	/* ..**..****.. */
	0x1c, 0xe0,	/* ...***..***. */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */

	/* 0xFD */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x07, 0x00,	/* .....***.... */
	0x0c, 0x00,	/* ....**...... */
	0x10, 0x00,	/* ...*........ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x18, 0x80,	/* ...**...*... */
	0x19, 0x00,	/* ...**..*.... */
	0x0d, 0x00,	/* ....**.*.... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0xc8, 0x00,	/* **..*....... */
	0xc8, 0x00,	/* **..*....... */
	0x70, 0x00,	/* .***........ */

	/* 0xFE */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xe0, 0x00,	/* ***......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x6e, 0x00,	/* .**.***..... */
	0x71, 0x80,	/* .***...**... */
	0x60, 0xc0,	/* .**.....**.. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0x60,	/* .**......**. */
	0x60, 0xc0,	/* .**.....**.. */
	0x71, 0x80,	/* .***...**... */
	0x6e, 0x00,	/* .**.***..... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0x60, 0x00,	/* .**......... */
	0xf0, 0x00,	/* ****........ */

	/* 0xFF */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0x19, 0x80,	/* ...**..**... */
	0x19, 0x80,	/* ...**..**... */
	0x00, 0x00,	/* ............ */
	0x00, 0x00,	/* ............ */
	0xf0, 0xe0,	/* ****....***. */
	0x60, 0x40,	/* .**......*.. */
	0x60, 0x40,	/* .**......*.. */
	0x30, 0x80,	/* ..**....*... */
	0x30, 0x80,	/* ..**....*... */
	0x18, 0x80,	/* ...**...*... */
	0x19, 0x00,	/* ...**..*.... */
	0x0d, 0x00,	/* ....**.*.... */
	0x0e, 0x00,	/* ....***..... */
	0x06, 0x00,	/* .....**..... */
	0x02, 0x00,	/* ......*..... */
	0x04, 0x00,	/* .....*...... */
	0x04, 0x00,	/* .....*...... */
	0xc8, 0x00,	/* **..*....... */
	0xc8, 0x00,	/* **..*....... */
	0x70, 0x00,	/* .***........ */
};
