/* $OpenBSD: wscons_gallant19.c,v 1.4 2003/06/02 23:28:04 millert Exp $ */
/* $NetBSD: wscons_rfont.h,v 1.1 1998/03/22 14:24:02 drochner Exp $ */

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to the Computer Systems
 * Engineering Group at Lawrence Berkeley Laboratory and to the University
 * of California at Berkeley by Jef Poskanzer.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)gallant19.h	8.1 (Berkeley) 6/11/93
 */

#include <sys/types.h>

#include <dev/rcons/raster.h>
#include "dev/wscons/wscons_raster.h"

static u_int32_t gallant19_32_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_32 = { 12, 22, 1, 1, gallant19_32_pixels, 0 };

static u_int32_t gallant19_33_pixels[] = {
    0x00000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x00000000,
    0x00000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_33 = { 12, 22, 1, 1, gallant19_33_pixels, 0 };

static u_int32_t gallant19_34_pixels[] = {
    0x00000000,
    0x19800000, 0x19800000, 0x19800000, 0x19800000, 0x19800000, 0x19800000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_34 = { 12, 22, 1, 1, gallant19_34_pixels, 0 };

static u_int32_t gallant19_35_pixels[] = {
    0x00000000,
    0x03300000, 0x03300000, 0x03300000, 0x06600000, 0x1ff00000, 0x1ff00000,
    0x0cc00000, 0x0cc00000, 0x19800000, 0x19800000, 0x7fc00000, 0x7fc00000,
    0x33000000, 0x66000000, 0x66000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_35 = { 12, 22, 1, 1, gallant19_35_pixels, 0 };

static u_int32_t gallant19_36_pixels[] = {
    0x00000000,
    0x06000000, 0x1f800000, 0x3fc00000, 0x66e00000, 0x66600000, 0x66000000,
    0x3e000000, 0x1f800000, 0x07c00000, 0x06600000, 0x06600000, 0x66600000,
    0x7fc00000, 0x3f800000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_36 = { 12, 22, 1, 1, gallant19_36_pixels, 0 };

static u_int32_t gallant19_37_pixels[] = {
    0x00000000,
    0x38600000, 0x44c00000, 0x44c00000, 0x45800000, 0x39800000, 0x03000000,
    0x03000000, 0x06000000, 0x0c000000, 0x0c000000, 0x19c00000, 0x1a200000,
    0x32200000, 0x32200000, 0x61c00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_37 = { 12, 22, 1, 1, gallant19_37_pixels, 0 };

static u_int32_t gallant19_38_pixels[] = {
    0x00000000,
    0x07000000, 0x0f800000, 0x18c00000, 0x18c00000, 0x18c00000, 0x0f800000,
    0x1e000000, 0x3e000000, 0x77000000, 0x63600000, 0x61e00000, 0x61c00000,
    0x61800000, 0x3fe00000, 0x1e600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_38 = { 12, 22, 1, 1, gallant19_38_pixels, 0 };

static u_int32_t gallant19_39_pixels[] = {
    0x00000000,
    0x0c000000, 0x1e000000, 0x1e000000, 0x06000000, 0x06000000, 0x0c000000,
    0x18000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_39 = { 12, 22, 1, 1, gallant19_39_pixels, 0 };

static u_int32_t gallant19_40_pixels[] = {
    0x00000000,
    0x00c00000, 0x01800000, 0x03800000, 0x03000000, 0x07000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x07000000, 0x03000000,
    0x03800000, 0x01800000, 0x00c00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_40 = { 12, 22, 1, 1, gallant19_40_pixels, 0 };

static u_int32_t gallant19_41_pixels[] = {
    0x00000000,
    0x30000000, 0x18000000, 0x1c000000, 0x0c000000, 0x0e000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x0e000000, 0x0c000000,
    0x1c000000, 0x18000000, 0x30000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_41 = { 12, 22, 1, 1, gallant19_41_pixels, 0 };

static u_int32_t gallant19_42_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0f000000, 0x06000000,
    0x66600000, 0x76e00000, 0x19800000, 0x00000000, 0x19800000, 0x76e00000,
    0x66600000, 0x06000000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_42 = { 12, 22, 1, 1, gallant19_42_pixels, 0 };

static u_int32_t gallant19_43_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x7fe00000, 0x7fe00000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_43 = { 12, 22, 1, 1, gallant19_43_pixels, 0 };

static u_int32_t gallant19_44_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x0c000000, 0x1e000000, 0x1e000000, 0x06000000, 0x06000000, 0x0c000000,
    0x18000000, 0x10000000, 0x00000000
};
static struct raster gallant19_44 = { 12, 22, 1, 1, gallant19_44_pixels, 0 };

static u_int32_t gallant19_45_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x7fe00000, 0x7fe00000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_45 = { 12, 22, 1, 1, gallant19_45_pixels, 0 };

static u_int32_t gallant19_46_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0c000000,
    0x1e000000, 0x1e000000, 0x0c000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_46 = { 12, 22, 1, 1, gallant19_46_pixels, 0 };

static u_int32_t gallant19_47_pixels[] = {
    0x00000000,
    0x00600000, 0x00c00000, 0x00c00000, 0x01800000, 0x01800000, 0x03000000,
    0x03000000, 0x06000000, 0x0c000000, 0x0c000000, 0x18000000, 0x18000000,
    0x30000000, 0x30000000, 0x60000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_47 = { 12, 22, 1, 1, gallant19_47_pixels, 0 };

static u_int32_t gallant19_48_pixels[] = {
    0x00000000,
    0x07000000, 0x0f800000, 0x11800000, 0x10c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30800000,
    0x18800000, 0x1f000000, 0x0e000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_48 = { 12, 22, 1, 1, gallant19_48_pixels, 0 };

static u_int32_t gallant19_49_pixels[] = {
    0x00000000,
    0x02000000, 0x06000000, 0x0e000000, 0x1e000000, 0x36000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x3fc00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_49 = { 12, 22, 1, 1, gallant19_49_pixels, 0 };

static u_int32_t gallant19_50_pixels[] = {
    0x00000000,
    0x1f000000, 0x3f800000, 0x61c00000, 0x40c00000, 0x00c00000, 0x00c00000,
    0x00c00000, 0x01800000, 0x03000000, 0x06000000, 0x0c000000, 0x18000000,
    0x30200000, 0x7fe00000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_50 = { 12, 22, 1, 1, gallant19_50_pixels, 0 };

static u_int32_t gallant19_51_pixels[] = {
    0x00000000,
    0x0f800000, 0x1fc00000, 0x20e00000, 0x40600000, 0x00600000, 0x00e00000,
    0x07c00000, 0x0fc00000, 0x00e00000, 0x00600000, 0x00600000, 0x40600000,
    0x60400000, 0x3f800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_51 = { 12, 22, 1, 1, gallant19_51_pixels, 0 };

static u_int32_t gallant19_52_pixels[] = {
    0x00000000,
    0x01800000, 0x03800000, 0x03800000, 0x05800000, 0x05800000, 0x09800000,
    0x09800000, 0x11800000, 0x11800000, 0x21800000, 0x3fe00000, 0x7fe00000,
    0x01800000, 0x01800000, 0x01800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_52 = { 12, 22, 1, 1, gallant19_52_pixels, 0 };

static u_int32_t gallant19_53_pixels[] = {
    0x00000000,
    0x0fc00000, 0x0fc00000, 0x10000000, 0x10000000, 0x20000000, 0x3f800000,
    0x31c00000, 0x00e00000, 0x00600000, 0x00600000, 0x00600000, 0x40600000,
    0x60600000, 0x30c00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_53 = { 12, 22, 1, 1, gallant19_53_pixels, 0 };

static u_int32_t gallant19_54_pixels[] = {
    0x00000000,
    0x07000000, 0x0c000000, 0x18000000, 0x30000000, 0x30000000, 0x60000000,
    0x67800000, 0x6fc00000, 0x70e00000, 0x60600000, 0x60600000, 0x60600000,
    0x70400000, 0x3f800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_54 = { 12, 22, 1, 1, gallant19_54_pixels, 0 };

static u_int32_t gallant19_55_pixels[] = {
    0x00000000,
    0x1fe00000, 0x3fe00000, 0x60400000, 0x00400000, 0x00c00000, 0x00800000,
    0x00800000, 0x01800000, 0x01000000, 0x01000000, 0x03000000, 0x02000000,
    0x02000000, 0x06000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_55 = { 12, 22, 1, 1, gallant19_55_pixels, 0 };

static u_int32_t gallant19_56_pixels[] = {
    0x00000000,
    0x0f000000, 0x11800000, 0x30c00000, 0x30c00000, 0x30c00000, 0x18800000,
    0x0d000000, 0x06000000, 0x0b000000, 0x11800000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x18800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_56 = { 12, 22, 1, 1, gallant19_56_pixels, 0 };

static u_int32_t gallant19_57_pixels[] = {
    0x00000000,
    0x0f800000, 0x11c00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000,
    0x70e00000, 0x3f600000, 0x1e600000, 0x00600000, 0x00c00000, 0x00c00000,
    0x01800000, 0x07000000, 0x3c000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_57 = { 12, 22, 1, 1, gallant19_57_pixels, 0 };

static u_int32_t gallant19_58_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0c000000,
    0x1e000000, 0x1e000000, 0x0c000000, 0x00000000, 0x00000000, 0x0c000000,
    0x1e000000, 0x1e000000, 0x0c000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_58 = { 12, 22, 1, 1, gallant19_58_pixels, 0 };

static u_int32_t gallant19_59_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x0c000000, 0x1e000000, 0x1e000000, 0x0c000000, 0x00000000, 0x00000000,
    0x0c000000, 0x1e000000, 0x1e000000, 0x06000000, 0x06000000, 0x0c000000,
    0x18000000, 0x10000000, 0x00000000
};
static struct raster gallant19_59 = { 12, 22, 1, 1, gallant19_59_pixels, 0 };

static u_int32_t gallant19_60_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00600000,
    0x01c00000, 0x07000000, 0x1e000000, 0x78000000, 0x78000000, 0x1e000000,
    0x07000000, 0x01c00000, 0x00600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_60 = { 12, 22, 1, 1, gallant19_60_pixels, 0 };

static u_int32_t gallant19_61_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x7fc00000, 0x7fc00000, 0x00000000, 0x00000000, 0x7fc00000,
    0x7fc00000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_61 = { 12, 22, 1, 1, gallant19_61_pixels, 0 };

static u_int32_t gallant19_62_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x60000000,
    0x38000000, 0x1e000000, 0x07800000, 0x01e00000, 0x01e00000, 0x07800000,
    0x1e000000, 0x38000000, 0x60000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_62 = { 12, 22, 1, 1, gallant19_62_pixels, 0 };

static u_int32_t gallant19_63_pixels[] = {
    0x00000000,
    0x0f000000, 0x1f800000, 0x39c00000, 0x20c00000, 0x00c00000, 0x00c00000,
    0x01800000, 0x03000000, 0x06000000, 0x0c000000, 0x0c000000, 0x00000000,
    0x00000000, 0x0c000000, 0x0c000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_63 = { 12, 22, 1, 1, gallant19_63_pixels, 0 };

static u_int32_t gallant19_64_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x0f800000, 0x3fc00000, 0x30600000,
    0x60600000, 0x67200000, 0x6fa00000, 0x6ca00000, 0x6ca00000, 0x67e00000,
    0x60000000, 0x30000000, 0x3fe00000, 0x0fe00000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_64 = { 12, 22, 1, 1, gallant19_64_pixels, 0 };

static u_int32_t gallant19_65_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x06000000, 0x0b000000, 0x0b000000, 0x09000000,
    0x11800000, 0x11800000, 0x10800000, 0x3fc00000, 0x20c00000, 0x20400000,
    0x40600000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_65 = { 12, 22, 1, 1, gallant19_65_pixels, 0 };

static u_int32_t gallant19_66_pixels[] = {
    0x00000000,
    0x00000000, 0xff000000, 0x60800000, 0x60c00000, 0x60c00000, 0x60c00000,
    0x61800000, 0x7f800000, 0x60c00000, 0x60600000, 0x60600000, 0x60600000,
    0x60600000, 0x60c00000, 0xff800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_66 = { 12, 22, 1, 1, gallant19_66_pixels, 0 };

static u_int32_t gallant19_67_pixels[] = {
    0x00000000,
    0x00000000, 0x0fc00000, 0x10600000, 0x20200000, 0x20000000, 0x60000000,
    0x60000000, 0x60000000, 0x60000000, 0x60000000, 0x60000000, 0x20000000,
    0x30200000, 0x18400000, 0x0f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_67 = { 12, 22, 1, 1, gallant19_67_pixels, 0 };

static u_int32_t gallant19_68_pixels[] = {
    0x00000000,
    0x00000000, 0xff000000, 0x61c00000, 0x60c00000, 0x60600000, 0x60600000,
    0x60600000, 0x60600000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x60400000, 0x61800000, 0xfe000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_68 = { 12, 22, 1, 1, gallant19_68_pixels, 0 };

static u_int32_t gallant19_69_pixels[] = {
    0x00000000,
    0x00000000, 0x7fc00000, 0x30400000, 0x30400000, 0x30000000, 0x30000000,
    0x30800000, 0x3f800000, 0x30800000, 0x30000000, 0x30000000, 0x30000000,
    0x30200000, 0x30200000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_69 = { 12, 22, 1, 1, gallant19_69_pixels, 0 };

static u_int32_t gallant19_70_pixels[] = {
    0x00000000,
    0x00000000, 0x7fc00000, 0x30400000, 0x30400000, 0x30000000, 0x30000000,
    0x30800000, 0x3f800000, 0x30800000, 0x30000000, 0x30000000, 0x30000000,
    0x30000000, 0x30000000, 0x78000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_70 = { 12, 22, 1, 1, gallant19_70_pixels, 0 };

static u_int32_t gallant19_71_pixels[] = {
    0x00000000,
    0x00000000, 0x0fc00000, 0x10600000, 0x20200000, 0x20000000, 0x60000000,
    0x60000000, 0x60000000, 0x60000000, 0x61f00000, 0x60600000, 0x20600000,
    0x30600000, 0x18600000, 0x0f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_71 = { 12, 22, 1, 1, gallant19_71_pixels, 0 };

static u_int32_t gallant19_72_pixels[] = {
    0x00000000,
    0x00000000, 0xf0f00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x60600000, 0x7fe00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x60600000, 0x60600000, 0xf0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_72 = { 12, 22, 1, 1, gallant19_72_pixels, 0 };

static u_int32_t gallant19_73_pixels[] = {
    0x00000000,
    0x00000000, 0x1f800000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_73 = { 12, 22, 1, 1, gallant19_73_pixels, 0 };

static u_int32_t gallant19_74_pixels[] = {
    0x00000000,
    0x00000000, 0x1f800000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x04000000,
    0x38000000, 0x30000000, 0x00000000
};
static struct raster gallant19_74 = { 12, 22, 1, 1, gallant19_74_pixels, 0 };

static u_int32_t gallant19_75_pixels[] = {
    0x00000000,
    0x00000000, 0xf0e00000, 0x61800000, 0x63000000, 0x66000000, 0x6c000000,
    0x78000000, 0x78000000, 0x7c000000, 0x6e000000, 0x67000000, 0x63800000,
    0x61c00000, 0x60e00000, 0xf0700000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_75 = { 12, 22, 1, 1, gallant19_75_pixels, 0 };

static u_int32_t gallant19_76_pixels[] = {
    0x00000000,
    0x00000000, 0x78000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000,
    0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000, 0x30000000,
    0x30200000, 0x30200000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_76 = { 12, 22, 1, 1, gallant19_76_pixels, 0 };

static u_int32_t gallant19_77_pixels[] = {
    0x00000000,
    0x00000000, 0xe0700000, 0x60e00000, 0x70e00000, 0x70e00000, 0x70e00000,
    0x59600000, 0x59600000, 0x59600000, 0x4d600000, 0x4e600000, 0x4e600000,
    0x44600000, 0x44600000, 0xe4f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_77 = { 12, 22, 1, 1, gallant19_77_pixels, 0 };

static u_int32_t gallant19_78_pixels[] = {
    0x00000000,
    0x00000000, 0xc0700000, 0x60200000, 0x70200000, 0x78200000, 0x58200000,
    0x4c200000, 0x46200000, 0x47200000, 0x43200000, 0x41a00000, 0x40e00000,
    0x40e00000, 0x40600000, 0xe0300000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_78 = { 12, 22, 1, 1, gallant19_78_pixels, 0 };

static u_int32_t gallant19_79_pixels[] = {
    0x00000000,
    0x00000000, 0x0f000000, 0x11c00000, 0x20c00000, 0x20600000, 0x60600000,
    0x60600000, 0x60600000, 0x60600000, 0x60600000, 0x60600000, 0x20400000,
    0x30400000, 0x18800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_79 = { 12, 22, 1, 1, gallant19_79_pixels, 0 };

static u_int32_t gallant19_80_pixels[] = {
    0x00000000,
    0x00000000, 0x7f800000, 0x30c00000, 0x30600000, 0x30600000, 0x30600000,
    0x30c00000, 0x37800000, 0x30000000, 0x30000000, 0x30000000, 0x30000000,
    0x30000000, 0x30000000, 0x78000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_80 = { 12, 22, 1, 1, gallant19_80_pixels, 0 };

static u_int32_t gallant19_81_pixels[] = {
    0x00000000,
    0x00000000, 0x0f000000, 0x11c00000, 0x20c00000, 0x20600000, 0x60600000,
    0x60600000, 0x60600000, 0x60600000, 0x60600000, 0x60600000, 0x30400000,
    0x38400000, 0x1f800000, 0x0e000000, 0x1f000000, 0x23900000, 0x01e00000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_81 = { 12, 22, 1, 1, gallant19_81_pixels, 0 };

static u_int32_t gallant19_82_pixels[] = {
    0x00000000,
    0x00000000, 0xff000000, 0x61800000, 0x60c00000, 0x60c00000, 0x60c00000,
    0x60800000, 0x7f000000, 0x7c000000, 0x6e000000, 0x67000000, 0x63800000,
    0x61c00000, 0x60e00000, 0xf0700000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_82 = { 12, 22, 1, 1, gallant19_82_pixels, 0 };

static u_int32_t gallant19_83_pixels[] = {
    0x00000000,
    0x00000000, 0x1fe00000, 0x30600000, 0x60200000, 0x60200000, 0x70000000,
    0x3c000000, 0x1e000000, 0x07800000, 0x01c00000, 0x00e00000, 0x40600000,
    0x40600000, 0x60c00000, 0x7f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_83 = { 12, 22, 1, 1, gallant19_83_pixels, 0 };

static u_int32_t gallant19_84_pixels[] = {
    0x00000000,
    0x00000000, 0x7fe00000, 0x46200000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_84 = { 12, 22, 1, 1, gallant19_84_pixels, 0 };

static u_int32_t gallant19_85_pixels[] = {
    0x00000000,
    0x00000000, 0xf0700000, 0x60200000, 0x60200000, 0x60200000, 0x60200000,
    0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000,
    0x70400000, 0x3fc00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_85 = { 12, 22, 1, 1, gallant19_85_pixels, 0 };

static u_int32_t gallant19_86_pixels[] = {
    0x00000000,
    0x00000000, 0xe0e00000, 0x60400000, 0x30800000, 0x30800000, 0x30800000,
    0x19000000, 0x19000000, 0x19000000, 0x0c000000, 0x0e000000, 0x0e000000,
    0x04000000, 0x04000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_86 = { 12, 22, 1, 1, gallant19_86_pixels, 0 };

static u_int32_t gallant19_87_pixels[] = {
    0x00000000,
    0x00000000, 0xfef00000, 0x66200000, 0x66200000, 0x66200000, 0x76200000,
    0x77400000, 0x33400000, 0x37400000, 0x3bc00000, 0x3b800000, 0x19800000,
    0x19800000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_87 = { 12, 22, 1, 1, gallant19_87_pixels, 0 };

static u_int32_t gallant19_88_pixels[] = {
    0x00000000,
    0x00000000, 0xf0700000, 0x60200000, 0x30400000, 0x38800000, 0x18800000,
    0x0d000000, 0x06000000, 0x06000000, 0x0b000000, 0x11800000, 0x11c00000,
    0x20c00000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_88 = { 12, 22, 1, 1, gallant19_88_pixels, 0 };

static u_int32_t gallant19_89_pixels[] = {
    0x00000000,
    0x00000000, 0xf0700000, 0x60200000, 0x30400000, 0x18800000, 0x18800000,
    0x0d000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_89 = { 12, 22, 1, 1, gallant19_89_pixels, 0 };

static u_int32_t gallant19_90_pixels[] = {
    0x00000000,
    0x00000000, 0x3fe00000, 0x20c00000, 0x00c00000, 0x01800000, 0x01800000,
    0x03000000, 0x03000000, 0x06000000, 0x06000000, 0x0c000000, 0x0c000000,
    0x18000000, 0x18200000, 0x3fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_90 = { 12, 22, 1, 1, gallant19_90_pixels, 0 };

static u_int32_t gallant19_91_pixels[] = {
    0x00000000,
    0x07c00000, 0x07c00000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x07c00000, 0x07c00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_91 = { 12, 22, 1, 1, gallant19_91_pixels, 0 };

static u_int32_t gallant19_92_pixels[] = {
    0x00000000,
    0x60000000, 0x60000000, 0x30000000, 0x30000000, 0x18000000, 0x18000000,
    0x0c000000, 0x0c000000, 0x06000000, 0x03000000, 0x03000000, 0x01800000,
    0x01800000, 0x00c00000, 0x00c00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_92 = { 12, 22, 1, 1, gallant19_92_pixels, 0 };

static u_int32_t gallant19_93_pixels[] = {
    0x00000000,
    0x7c000000, 0x7c000000, 0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000,
    0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000,
    0x0c000000, 0x7c000000, 0x7c000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_93 = { 12, 22, 1, 1, gallant19_93_pixels, 0 };

static u_int32_t gallant19_94_pixels[] = {
    0x00000000,
    0x04000000, 0x0e000000, 0x1b000000, 0x31800000, 0x60c00000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_94 = { 12, 22, 1, 1, gallant19_94_pixels, 0 };

static u_int32_t gallant19_95_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfff00000, 0xfff00000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_95 = { 12, 22, 1, 1, gallant19_95_pixels, 0 };

static u_int32_t gallant19_96_pixels[] = {
    0x00000000,
    0x01000000, 0x03000000, 0x06000000, 0x06000000, 0x07800000, 0x07800000,
    0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_96 = { 12, 22, 1, 1, gallant19_96_pixels, 0 };

static u_int32_t gallant19_97_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0f800000,
    0x18c00000, 0x10c00000, 0x03c00000, 0x1cc00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1ee00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_97 = { 12, 22, 1, 1, gallant19_97_pixels, 0 };

static u_int32_t gallant19_98_pixels[] = {
    0x00000000,
    0x20000000, 0x60000000, 0xe0000000, 0x60000000, 0x60000000, 0x67800000,
    0x6fc00000, 0x70e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70600000, 0x78c00000, 0x4f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_98 = { 12, 22, 1, 1, gallant19_98_pixels, 0 };

static u_int32_t gallant19_99_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1f800000,
    0x31c00000, 0x20c00000, 0x60000000, 0x60000000, 0x60000000, 0x60000000,
    0x70400000, 0x30c00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_99 = { 12, 22, 1, 1, gallant19_99_pixels, 0 };

static u_int32_t gallant19_100_pixels[] = {
    0x00000000,
    0x00600000, 0x00e00000, 0x00600000, 0x00600000, 0x00600000, 0x0f600000,
    0x31e00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70e00000, 0x39600000, 0x1e700000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_100 = { 12, 22, 1, 1, gallant19_100_pixels, 0 };

static u_int32_t gallant19_101_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0f000000,
    0x30c00000, 0x60600000, 0x60600000, 0x7fe00000, 0x60000000, 0x60000000,
    0x30000000, 0x18600000, 0x0f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_101 = { 12, 22, 1, 1, gallant19_101_pixels, 0 };

static u_int32_t gallant19_102_pixels[] = {
    0x00000000,
    0x03800000, 0x04c00000, 0x04c00000, 0x0c000000, 0x0c000000, 0x0c000000,
    0x0c000000, 0x1f800000, 0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000,
    0x0c000000, 0x0c000000, 0x1e000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_102 = { 12, 22, 1, 1, gallant19_102_pixels, 0 };

static u_int32_t gallant19_103_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1f200000,
    0x31e00000, 0x60c00000, 0x60c00000, 0x60c00000, 0x31800000, 0x3f000000,
    0x60000000, 0x7fc00000, 0x3fe00000, 0x20600000, 0x40200000, 0x40200000,
    0x7fc00000, 0x3f800000, 0x00000000
};
static struct raster gallant19_103 = { 12, 22, 1, 1, gallant19_103_pixels, 0 };

static u_int32_t gallant19_104_pixels[] = {
    0x00000000,
    0x10000000, 0x30000000, 0x70000000, 0x30000000, 0x30000000, 0x37800000,
    0x39c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x30c00000, 0x79e00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_104 = { 12, 22, 1, 1, gallant19_104_pixels, 0 };

static u_int32_t gallant19_105_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x1e000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_105 = { 12, 22, 1, 1, gallant19_105_pixels, 0 };

static u_int32_t gallant19_106_pixels[] = {
    0x00000000,
    0x00000000, 0x00c00000, 0x00c00000, 0x00000000, 0x00000000, 0x03c00000,
    0x00c00000, 0x00c00000, 0x00c00000, 0x00c00000, 0x00c00000, 0x00c00000,
    0x00c00000, 0x00c00000, 0x00c00000, 0x20c00000, 0x30c00000, 0x38800000,
    0x1f000000, 0x0e000000, 0x00000000
};
static struct raster gallant19_106 = { 12, 22, 1, 1, gallant19_106_pixels, 0 };

static u_int32_t gallant19_107_pixels[] = {
    0x00000000,
    0x60000000, 0xe0000000, 0x60000000, 0x60000000, 0x60000000, 0x61c00000,
    0x63000000, 0x66000000, 0x7c000000, 0x78000000, 0x7c000000, 0x6e000000,
    0x67000000, 0x63800000, 0xf1e00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_107 = { 12, 22, 1, 1, gallant19_107_pixels, 0 };

static u_int32_t gallant19_108_pixels[] = {
    0x00000000,
    0x1e000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_108 = { 12, 22, 1, 1, gallant19_108_pixels, 0 };

static u_int32_t gallant19_109_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xddc00000,
    0x6ee00000, 0x66600000, 0x66600000, 0x66600000, 0x66600000, 0x66600000,
    0x66600000, 0x66600000, 0xef700000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_109 = { 12, 22, 1, 1, gallant19_109_pixels, 0 };

static u_int32_t gallant19_110_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x27800000,
    0x79c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x30c00000, 0x79e00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_110 = { 12, 22, 1, 1, gallant19_110_pixels, 0 };

static u_int32_t gallant19_111_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0f800000,
    0x11c00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70400000, 0x38800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_111 = { 12, 22, 1, 1, gallant19_111_pixels, 0 };

static u_int32_t gallant19_112_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xef800000,
    0x71c00000, 0x60e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x60400000, 0x70800000, 0x7f000000, 0x60000000, 0x60000000, 0x60000000,
    0x60000000, 0xf0000000, 0x00000000
};
static struct raster gallant19_112 = { 12, 22, 1, 1, gallant19_112_pixels, 0 };

static u_int32_t gallant19_113_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0f200000,
    0x11e00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70600000, 0x38e00000, 0x1fe00000, 0x00600000, 0x00600000, 0x00600000,
    0x00600000, 0x00f00000, 0x00000000
};
static struct raster gallant19_113 = { 12, 22, 1, 1, gallant19_113_pixels, 0 };

static u_int32_t gallant19_114_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x73800000,
    0x34c00000, 0x38c00000, 0x30000000, 0x30000000, 0x30000000, 0x30000000,
    0x30000000, 0x30000000, 0x78000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_114 = { 12, 22, 1, 1, gallant19_114_pixels, 0 };

static u_int32_t gallant19_115_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1fc00000,
    0x30c00000, 0x30400000, 0x38000000, 0x1e000000, 0x07800000, 0x01c00000,
    0x20c00000, 0x30c00000, 0x3f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_115 = { 12, 22, 1, 1, gallant19_115_pixels, 0 };

static u_int32_t gallant19_116_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x04000000, 0x04000000, 0x0c000000, 0x7fc00000,
    0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000, 0x0c000000,
    0x0c200000, 0x0e400000, 0x07800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_116 = { 12, 22, 1, 1, gallant19_116_pixels, 0 };

static u_int32_t gallant19_117_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x79e00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1e600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_117 = { 12, 22, 1, 1, gallant19_117_pixels, 0 };

static u_int32_t gallant19_118_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xf0700000,
    0x60200000, 0x30400000, 0x30400000, 0x18800000, 0x18800000, 0x0d000000,
    0x0d000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_118 = { 12, 22, 1, 1, gallant19_118_pixels, 0 };

static u_int32_t gallant19_119_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff700000,
    0x66200000, 0x66200000, 0x66200000, 0x37400000, 0x3b400000, 0x3b400000,
    0x19800000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_119 = { 12, 22, 1, 1, gallant19_119_pixels, 0 };

static u_int32_t gallant19_120_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xf8f00000,
    0x70400000, 0x38800000, 0x1d000000, 0x0e000000, 0x07000000, 0x0b800000,
    0x11c00000, 0x20e00000, 0xf1f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_120 = { 12, 22, 1, 1, gallant19_120_pixels, 0 };

static u_int32_t gallant19_121_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xf0f00000,
    0x60200000, 0x30400000, 0x30400000, 0x18800000, 0x18800000, 0x0d000000,
    0x0d000000, 0x06000000, 0x06000000, 0x04000000, 0x0c000000, 0x08000000,
    0x78000000, 0x70000000, 0x00000000
};
static struct raster gallant19_121 = { 12, 22, 1, 1, gallant19_121_pixels, 0 };

static u_int32_t gallant19_122_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fe00000,
    0x60e00000, 0x41c00000, 0x03800000, 0x07000000, 0x0e000000, 0x1c000000,
    0x38200000, 0x70600000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_122 = { 12, 22, 1, 1, gallant19_122_pixels, 0 };

static u_int32_t gallant19_123_pixels[] = {
    0x00000000,
    0x01c00000, 0x03000000, 0x03000000, 0x01800000, 0x01800000, 0x01800000,
    0x03000000, 0x07000000, 0x03000000, 0x01800000, 0x01800000, 0x01800000,
    0x03000000, 0x03000000, 0x01c00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_123 = { 12, 22, 1, 1, gallant19_123_pixels, 0 };

static u_int32_t gallant19_124_pixels[] = {
    0x00000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x00000000
};
static struct raster gallant19_124 = { 12, 22, 1, 1, gallant19_124_pixels, 0 };

static u_int32_t gallant19_125_pixels[] = {
    0x00000000,
    0x38000000, 0x0c000000, 0x0c000000, 0x18000000, 0x18000000, 0x18000000,
    0x0c000000, 0x0e000000, 0x0c000000, 0x18000000, 0x18000000, 0x18000000,
    0x0c000000, 0x0c000000, 0x38000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_125 = { 12, 22, 1, 1, gallant19_125_pixels, 0 };

static u_int32_t gallant19_126_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x1c200000, 0x3e600000, 0x36c00000, 0x67c00000,
    0x43800000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_126 = { 12, 22, 1, 1, gallant19_126_pixels, 0 };

static u_int32_t gallant19_161_pixels[] = {
    0x00000000,
    0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_161 = { 12, 22, 1, 1, gallant19_161_pixels, 0 };

static u_int32_t gallant19_162_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x06000000, 0x06000000, 0x0f000000, 0x19800000,
    0x30c00000, 0x30000000, 0x30000000, 0x30c00000, 0x19800000, 0x0f000000,
    0x06000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_162 = { 12, 22, 1, 1, gallant19_162_pixels, 0 };

static u_int32_t gallant19_163_pixels[] = {
    0x00000000,
    0x00000000, 0x0f000000, 0x19800000, 0x19800000, 0x18000000, 0x18000000,
    0x18000000, 0x7e000000, 0x18000000, 0x18000000, 0x18000000, 0x18000000,
    0x7c000000, 0x56600000, 0x73c00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_163 = { 12, 22, 1, 1, gallant19_163_pixels, 0 };

static u_int32_t gallant19_164_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x40200000, 0x6f600000, 0x3fc00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x3fc00000, 0x6f600000,
    0x40200000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_164 = { 12, 22, 1, 1, gallant19_164_pixels, 0 };

static u_int32_t gallant19_165_pixels[] = {
    0x00000000,
    0x00000000, 0x60600000, 0x30c00000, 0x19800000, 0x0f000000, 0x06000000,
    0x1f800000, 0x06000000, 0x1f800000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_165 = { 12, 22, 1, 1, gallant19_165_pixels, 0 };

static u_int32_t gallant19_166_pixels[] = {
    0x00000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_166 = { 12, 22, 1, 1, gallant19_166_pixels, 0 };

static u_int32_t gallant19_167_pixels[] = {
    0x00000000,
    0x00000000, 0x1f800000, 0x30c00000, 0x60c00000, 0x30000000, 0x3f000000,
    0x61800000, 0x30c00000, 0x30c00000, 0x18600000, 0x0fc00000, 0x00c00000,
    0x30600000, 0x30c00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_167 = { 12, 22, 1, 1, gallant19_167_pixels, 0 };

static u_int32_t gallant19_168_pixels[] = {
    0x00000000,
    0x00000000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_168 = { 12, 22, 1, 1, gallant19_168_pixels, 0 };

static u_int32_t gallant19_169_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x0f000000, 0x19800000, 0x30c00000, 0x2f400000,
    0x29400000, 0x28400000, 0x28400000, 0x29400000, 0x2f400000, 0x30c00000,
    0x19800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_169 = { 12, 22, 1, 1, gallant19_169_pixels, 0 };

static u_int32_t gallant19_170_pixels[] = {
    0x00000000,
    0x00000000, 0x0fc00000, 0x10600000, 0x00600000, 0x1fe00000, 0x30600000,
    0x30600000, 0x1fa00000, 0x00000000, 0x3fe00000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_170 = { 12, 22, 1, 1, gallant19_170_pixels, 0 };

static u_int32_t gallant19_171_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x03600000, 0x06c00000, 0x0d800000, 0x1b000000,
    0x36000000, 0x6c000000, 0x6c000000, 0x36000000, 0x1b000000, 0x0d800000,
    0x06c00000, 0x03600000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_171 = { 12, 22, 1, 1, gallant19_171_pixels, 0 };

static u_int32_t gallant19_172_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x3fc00000, 0x3fc00000, 0x00c00000, 0x00c00000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_172 = { 12, 22, 1, 1, gallant19_172_pixels, 0 };

static u_int32_t gallant19_173_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_173 = { 12, 22, 1, 1, gallant19_173_pixels, 0 };

static u_int32_t gallant19_174_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x0f000000, 0x19800000, 0x30c00000, 0x2f400000,
    0x29400000, 0x2f400000, 0x2a400000, 0x2a400000, 0x2b400000, 0x30c00000,
    0x19800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_174 = { 12, 22, 1, 1, gallant19_174_pixels, 0 };

static u_int32_t gallant19_175_pixels[] = {
    0x00000000,
    0x7fe00000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_175 = { 12, 22, 1, 1, gallant19_175_pixels, 0 };

static u_int32_t gallant19_176_pixels[] = {
    0x00000000,
    0x00000000, 0x0c000000, 0x1e000000, 0x33000000, 0x33000000, 0x1e000000,
    0x0c000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_176 = { 12, 22, 1, 1, gallant19_176_pixels, 0 };

static u_int32_t gallant19_177_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x06000000,
    0x3fc00000, 0x3fc00000, 0x06000000, 0x06000000, 0x00000000, 0x3fc00000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_177 = { 12, 22, 1, 1, gallant19_177_pixels, 0 };

static u_int32_t gallant19_178_pixels[] = {
    0x00000000,
    0x00000000, 0x3c000000, 0x66000000, 0x06000000, 0x1c000000, 0x30000000,
    0x60000000, 0x7e000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_178 = { 12, 22, 1, 1, gallant19_178_pixels, 0 };

static u_int32_t gallant19_179_pixels[] = {
    0x00000000,
    0x00000000, 0x3c000000, 0x66000000, 0x06000000, 0x1c000000, 0x06000000,
    0x66000000, 0x3c000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_179 = { 12, 22, 1, 1, gallant19_179_pixels, 0 };

static u_int32_t gallant19_180_pixels[] = {
    0x00000000,
    0x00000000, 0x03000000, 0x06000000, 0x0c000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_180 = { 12, 22, 1, 1, gallant19_180_pixels, 0 };

static u_int32_t gallant19_181_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x79e00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x3e600000, 0x30000000, 0x30000000, 0x30000000,
    0x30000000, 0x78000000, 0x00000000
};
static struct raster gallant19_181 = { 12, 22, 1, 1, gallant19_181_pixels, 0 };

static u_int32_t gallant19_182_pixels[] = {
    0x00000000,
    0x00000000, 0x1fe00000, 0x3fe00000, 0x7f600000, 0x7f600000, 0x7f600000,
    0x3f600000, 0x1f600000, 0x03600000, 0x03600000, 0x03600000, 0x03600000,
    0x03600000, 0x03600000, 0x03600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_182 = { 12, 22, 1, 1, gallant19_182_pixels, 0 };

static u_int32_t gallant19_183_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x06000000, 0x0f000000, 0x0f000000, 0x06000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_183 = { 12, 22, 1, 1, gallant19_183_pixels, 0 };

static u_int32_t gallant19_184_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x01800000, 0x0d800000,
    0x07000000, 0x00000000, 0x00000000
};
static struct raster gallant19_184 = { 12, 22, 1, 1, gallant19_184_pixels, 0 };

static u_int32_t gallant19_185_pixels[] = {
    0x00000000,
    0x00000000, 0x18000000, 0x38000000, 0x18000000, 0x18000000, 0x18000000,
    0x18000000, 0x3c000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_185 = { 12, 22, 1, 1, gallant19_185_pixels, 0 };

static u_int32_t gallant19_186_pixels[] = {
    0x00000000,
    0x00000000, 0x0f800000, 0x18c00000, 0x30600000, 0x30600000, 0x30600000,
    0x18c00000, 0x0f800000, 0x00000000, 0x3fe00000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_186 = { 12, 22, 1, 1, gallant19_186_pixels, 0 };

static u_int32_t gallant19_187_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x6c000000, 0x36000000, 0x1b000000, 0x0d800000,
    0x06c00000, 0x03600000, 0x03600000, 0x06c00000, 0x0d800000, 0x1b000000,
    0x36000000, 0x6c000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_187 = { 12, 22, 1, 1, gallant19_187_pixels, 0 };

static u_int32_t gallant19_188_pixels[] = {
    0x00000000,
    0x00000000, 0x10000000, 0x30000000, 0x10000000, 0x10000000, 0x10000000,
    0x10000000, 0x38000000, 0x00400000, 0x00c00000, 0x01400000, 0x02400000, 
    0x03e00000, 0x00400000, 0x00e00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_188 = { 12, 22, 1, 1, gallant19_188_pixels, 0 };

static u_int32_t gallant19_189_pixels[] = {
    0x00000000,
    0x00000000, 0x10000000, 0x30000000, 0x10000000, 0x10000000, 0x10000000,
    0x10000000, 0x38000000, 0x01c00000, 0x02200000, 0x00200000, 0x00c00000, 
    0x01000000, 0x02000000, 0x03e00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_189 = { 12, 22, 1, 1, gallant19_189_pixels, 0 };

static u_int32_t gallant19_190_pixels[] = {
    0x00000000,
    0x00000000, 0x38000000, 0x44000000, 0x04000000, 0x38000000, 0x04000000,
    0x44000000, 0x38000000, 0x00400000, 0x00c00000, 0x01400000, 0x02400000, 
    0x03e00000, 0x00400000, 0x00e00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_190 = { 12, 22, 1, 1, gallant19_190_pixels, 0 };

static u_int32_t gallant19_191_pixels[] = {
    0x00000000,
    0x03000000, 0x03000000, 0x00000000, 0x00000000, 0x03000000, 0x03000000,
    0x06000000, 0x0c000000, 0x18000000, 0x30000000, 0x30000000, 0x30400000,
    0x39c00000, 0x1f800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_191 = { 12, 22, 1, 1, gallant19_191_pixels, 0 };

static u_int32_t gallant19_192_pixels[] = {
    0x00000000,
    0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x06000000, 0x06000000, 
    0x0b000000, 0x09000000, 0x11800000, 0x10800000, 0x3fc00000, 0x20c00000,
    0x20400000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_192 = { 12, 22, 1, 1, gallant19_192_pixels, 0 };

static u_int32_t gallant19_193_pixels[] = {
    0x00000000,
    0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x06000000, 0x06000000, 
    0x0b000000, 0x09000000, 0x11800000, 0x10800000, 0x3fc00000, 0x20c00000,
    0x20400000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_193 = { 12, 22, 1, 1, gallant19_193_pixels, 0 };

static u_int32_t gallant19_194_pixels[] = {
    0x00000000,
    0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x06000000, 0x06000000, 
    0x0b000000, 0x09000000, 0x11800000, 0x10800000, 0x3fc00000, 0x20c00000,
    0x20400000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_194 = { 12, 22, 1, 1, gallant19_194_pixels, 0 };

static u_int32_t gallant19_195_pixels[] = {
    0x00000000,
    0x0c800000, 0x1f800000, 0x13000000, 0x00000000, 0x06000000, 0x06000000, 
    0x0b000000, 0x09000000, 0x11800000, 0x10800000, 0x3fc00000, 0x20c00000,
    0x20400000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_195 = { 12, 22, 1, 1, gallant19_195_pixels, 0 };

static u_int32_t gallant19_196_pixels[] = {
    0x00000000,
    0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x06000000, 0x06000000, 
    0x0b000000, 0x09000000, 0x11800000, 0x10800000, 0x3fc00000, 0x20c00000,
    0x20400000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_196 = { 12, 22, 1, 1, gallant19_196_pixels, 0 };

static u_int32_t gallant19_197_pixels[] = {
    0x00000000,
    0x06000000, 0x19800000, 0x19800000, 0x06000000, 0x00000000, 0x06000000, 
    0x0b000000, 0x09000000, 0x11800000, 0x10800000, 0x3fc00000, 0x20c00000,
    0x20400000, 0x40600000, 0xe0f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_197 = { 12, 22, 1, 1, gallant19_197_pixels, 0 };

static u_int32_t gallant19_198_pixels[] = {
    0x00000000,
    0x00000000, 0x07f00000, 0x07100000, 0x0b100000, 0x0b000000, 0x13000000,
    0x13200000, 0x1fe00000, 0x23200000, 0x23000000, 0x23000000, 0x43000000,
    0x43100000, 0x43100000, 0xe7f00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_198 = { 12, 22, 1, 1, gallant19_198_pixels, 0 };

static u_int32_t gallant19_199_pixels[] = {
    0x00000000,
    0x00000000, 0x0fc00000, 0x10600000, 0x20200000, 0x20000000, 0x60000000,
    0x60000000, 0x60000000, 0x60000000, 0x60000000, 0x60000000, 0x20000000,
    0x30200000, 0x18400000, 0x0f800000, 0x07000000, 0x01800000, 0x0d800000,
    0x07000000, 0x00000000, 0x00000000
};
static struct raster gallant19_199 = { 12, 22, 1, 1, gallant19_199_pixels, 0 };

static u_int32_t gallant19_200_pixels[] = {
    0x00000000,
    0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x7fc00000, 0x30400000,
    0x30400000, 0x30000000, 0x30800000, 0x3f800000, 0x30800000, 0x30000000,
    0x30200000, 0x30200000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_200 = { 12, 22, 1, 1, gallant19_200_pixels, 0 };

static u_int32_t gallant19_201_pixels[] = {
    0x00000000,
    0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x7fc00000, 0x30400000,
    0x30400000, 0x30000000, 0x30800000, 0x3f800000, 0x30800000, 0x30000000,
    0x30200000, 0x30200000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_201 = { 12, 22, 1, 1, gallant19_201_pixels, 0 };

static u_int32_t gallant19_202_pixels[] = {
    0x00000000,
    0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x7fc00000, 0x30400000,
    0x30400000, 0x30000000, 0x30800000, 0x3f800000, 0x30800000, 0x30000000,
    0x30200000, 0x30200000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_202 = { 12, 22, 1, 1, gallant19_202_pixels, 0 };

static u_int32_t gallant19_203_pixels[] = {
    0x00000000,
    0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x7fc00000, 0x30400000,
    0x30400000, 0x30000000, 0x30800000, 0x3f800000, 0x30800000, 0x30000000,
    0x30200000, 0x30200000, 0x7fe00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_203 = { 12, 22, 1, 1, gallant19_203_pixels, 0 };

static u_int32_t gallant19_204_pixels[] = {
    0x00000000,
    0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x1f800000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_204 = { 12, 22, 1, 1, gallant19_204_pixels, 0 };

static u_int32_t gallant19_205_pixels[] = {
    0x00000000,
    0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x1f800000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_205 = { 12, 22, 1, 1, gallant19_205_pixels, 0 };

static u_int32_t gallant19_206_pixels[] = {
    0x00000000,
    0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x1f800000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_206 = { 12, 22, 1, 1, gallant19_206_pixels, 0 };

static u_int32_t gallant19_207_pixels[] = {
    0x00000000,
    0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x1f800000, 0x06000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_207 = { 12, 22, 1, 1, gallant19_207_pixels, 0 };

static u_int32_t gallant19_208_pixels[] = {
    0x00000000,
    0x00000000, 0xff000000, 0x31c00000, 0x30c00000, 0x30600000, 0x30600000,
    0x30600000, 0xfc600000, 0x30600000, 0x30600000, 0x30600000, 0x30600000,
    0x30400000, 0x31800000, 0xfe000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_208 = { 12, 22, 1, 1, gallant19_208_pixels, 0 };

static u_int32_t gallant19_209_pixels[] = {
    0x00000000,
    0x0c800000, 0x1f800000, 0x13000000, 0x00000000, 0xc0700000, 0x60200000,
    0x70200000, 0x58200000, 0x4c200000, 0x46200000, 0x43200000, 0x41a00000,
    0x40e00000, 0x40600000, 0xe0300000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_209 = { 12, 22, 1, 1, gallant19_209_pixels, 0 };

static u_int32_t gallant19_210_pixels[] = {
    0x00000000,
    0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x0f000000, 0x11c00000,
    0x20c00000, 0x20600000, 0x60600000, 0x60600000, 0x60600000, 0x20400000,
    0x30400000, 0x18800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_210 = { 12, 22, 1, 1, gallant19_210_pixels, 0 };

static u_int32_t gallant19_211_pixels[] = {
    0x00000000,
    0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x0f000000, 0x11c00000,
    0x20c00000, 0x20600000, 0x60600000, 0x60600000, 0x60600000, 0x20400000,
    0x30400000, 0x18800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_211 = { 12, 22, 1, 1, gallant19_211_pixels, 0 };

static u_int32_t gallant19_212_pixels[] = {
    0x00000000,
    0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x0f000000, 0x11c00000,
    0x20c00000, 0x20600000, 0x60600000, 0x60600000, 0x60600000, 0x20400000,
    0x30400000, 0x18800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_212 = { 12, 22, 1, 1, gallant19_212_pixels, 0 };

static u_int32_t gallant19_213_pixels[] = {
    0x00000000,
    0x0c800000, 0x1f800000, 0x13000000, 0x00000000, 0x0f000000, 0x11c00000,
    0x20c00000, 0x20600000, 0x60600000, 0x60600000, 0x60600000, 0x20400000,
    0x30400000, 0x18800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_213 = { 12, 22, 1, 1, gallant19_213_pixels, 0 };

static u_int32_t gallant19_214_pixels[] = {
    0x00000000,
    0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x0f000000, 0x11c00000,
    0x20c00000, 0x20600000, 0x60600000, 0x60600000, 0x60600000, 0x20400000,
    0x30400000, 0x18800000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_214 = { 12, 22, 1, 1, gallant19_214_pixels, 0 };

static u_int32_t gallant19_215_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x20200000, 0x30600000, 0x18c00000,
    0x0d800000, 0x07000000, 0x07000000, 0x0d800000, 0x18c00000, 0x30600000,
    0x20200000, 0x00000000, 0x000000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_215 = { 12, 22, 1, 1, gallant19_215_pixels, 0 };

static u_int32_t gallant19_216_pixels[] = {
    0x00000000,
    0x00600000, 0x0fc00000, 0x11c00000, 0x21c00000, 0x21e00000, 0x63600000,
    0x63600000, 0x66600000, 0x66600000, 0x6c600000, 0x6c600000, 0x38400000,
    0x38400000, 0x38800000, 0x6f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_216 = { 12, 22, 1, 1, gallant19_216_pixels, 0 };

static u_int32_t gallant19_217_pixels[] = {
    0x00000000,
    0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0xf0700000, 0x60200000,
    0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000,
    0x70400000, 0x3fc00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_217 = { 12, 22, 1, 1, gallant19_217_pixels, 0 };

static u_int32_t gallant19_218_pixels[] = {
    0x00000000,
    0x01800000, 0x03000000, 0x06000000, 0x00000000, 0xf0700000, 0x60200000,
    0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000,
    0x70400000, 0x3fc00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_218 = { 12, 22, 1, 1, gallant19_218_pixels, 0 };

static u_int32_t gallant19_219_pixels[] = {
    0x00000000,
    0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0xf0700000, 0x60200000,
    0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000,
    0x70400000, 0x3fc00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_219 = { 12, 22, 1, 1, gallant19_219_pixels, 0 };

static u_int32_t gallant19_220_pixels[] = {
    0x00000000,
    0x19800000, 0x19800000, 0x00000000, 0x00000000, 0xf0700000, 0x60200000,
    0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000, 0x60200000,
    0x70400000, 0x3fc00000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_220 = { 12, 22, 1, 1, gallant19_220_pixels, 0 };

static u_int32_t gallant19_221_pixels[] = {
    0x00000000,
    0x01800000, 0x03000000, 0x06000000, 0x00000000, 0xf0700000, 0x60200000,
    0x30400000, 0x18800000, 0x0d000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x0f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_221 = { 12, 22, 1, 1, gallant19_221_pixels, 0 };

static u_int32_t gallant19_222_pixels[] = {
    0x00000000,
    0x00000000, 0xf0000000, 0x60000000, 0x60000000, 0x7f800000, 0x60c00000,
    0x60c00000, 0x60c00000, 0x60c00000, 0x60c00000, 0x60c00000, 0x7f800000,
    0x60000000, 0x60000000, 0xf0000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_222 = { 12, 22, 1, 1, gallant19_222_pixels, 0 };

static u_int32_t gallant19_223_pixels[] = {
    0x00000000,
    0x00000000, 0x1f800000, 0x38c00000, 0x60600000, 0x60c00000, 0x61800000,
    0x63000000, 0x63000000, 0x60c00000, 0x60600000, 0x60600000, 0x60600000,
    0x60c00000, 0x61800000, 0x63000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_223 = { 12, 22, 1, 1, gallant19_223_pixels, 0 };

static u_int32_t gallant19_224_pixels[] = {
    0x00000000,
    0x00000000, 0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x0f800000,
    0x18c00000, 0x10c00000, 0x03c00000, 0x1cc00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1ee00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_224 = { 12, 22, 1, 1, gallant19_224_pixels, 0 };

static u_int32_t gallant19_225_pixels[] = {
    0x00000000,
    0x00000000, 0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x0f800000,
    0x18c00000, 0x10c00000, 0x03c00000, 0x1cc00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1ee00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_225 = { 12, 22, 1, 1, gallant19_225_pixels, 0 };

static u_int32_t gallant19_226_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x0f800000,
    0x18c00000, 0x10c00000, 0x03c00000, 0x1cc00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1ee00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_226 = { 12, 22, 1, 1, gallant19_226_pixels, 0 };

static u_int32_t gallant19_227_pixels[] = {
    0x00000000,
    0x00000000, 0x0c800000, 0x1f800000, 0x13000000, 0x00000000, 0x0f800000,
    0x18c00000, 0x10c00000, 0x03c00000, 0x1cc00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1ee00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_227 = { 12, 22, 1, 1, gallant19_227_pixels, 0 };

static u_int32_t gallant19_228_pixels[] = {
    0x00000000,
    0x00000000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x0f800000,
    0x18c00000, 0x10c00000, 0x03c00000, 0x1cc00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1ee00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_228 = { 12, 22, 1, 1, gallant19_228_pixels, 0 };

static u_int32_t gallant19_229_pixels[] = {
    0x00000000,
    0x06000000, 0x19800000, 0x19800000, 0x06000000, 0x00000000, 0x0f800000,
    0x18c00000, 0x10c00000, 0x03c00000, 0x1cc00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1ee00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_229 = { 12, 22, 1, 1, gallant19_229_pixels, 0 };

static u_int32_t gallant19_230_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1f800000,
    0x36400000, 0x26600000, 0x06600000, 0x3fe00000, 0x66000000, 0x66000000,
    0x66200000, 0x76400000, 0x3b800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_230 = { 12, 22, 1, 1, gallant19_230_pixels, 0 };

static u_int32_t gallant19_231_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1f800000,
    0x31c00000, 0x20c00000, 0x60000000, 0x60000000, 0x60000000, 0x60000000,
    0x70400000, 0x30c00000, 0x1f800000, 0x07000000, 0x01800000, 0x0d800000,
    0x07000000, 0x00000000, 0x00000000
};
static struct raster gallant19_231 = { 12, 22, 1, 1, gallant19_231_pixels, 0 };

static u_int32_t gallant19_232_pixels[] = {
    0x00000000,
    0x00000000, 0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x0f000000,
    0x30c00000, 0x60600000, 0x60600000, 0x7fe00000, 0x60000000, 0x60000000,
    0x30000000, 0x18600000, 0x0f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_232 = { 12, 22, 1, 1, gallant19_232_pixels, 0 };

static u_int32_t gallant19_233_pixels[] = {
    0x00000000,
    0x00000000, 0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x0f000000,
    0x30c00000, 0x60600000, 0x60600000, 0x7fe00000, 0x60000000, 0x60000000,
    0x30000000, 0x18600000, 0x0f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_233 = { 12, 22, 1, 1, gallant19_233_pixels, 0 };

static u_int32_t gallant19_234_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x0f000000,
    0x30c00000, 0x60600000, 0x60600000, 0x7fe00000, 0x60000000, 0x60000000,
    0x30000000, 0x18600000, 0x0f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_234 = { 12, 22, 1, 1, gallant19_234_pixels, 0 };

static u_int32_t gallant19_235_pixels[] = {
    0x00000000,
    0x00000000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x0f000000,
    0x30c00000, 0x60600000, 0x60600000, 0x7fe00000, 0x60000000, 0x60000000,
    0x30000000, 0x18600000, 0x0f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_235 = { 12, 22, 1, 1, gallant19_235_pixels, 0 };

static u_int32_t gallant19_236_pixels[] = {
    0x00000000,
    0x00000000, 0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x1e000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_236 = { 12, 22, 1, 1, gallant19_236_pixels, 0 };

static u_int32_t gallant19_237_pixels[] = {
    0x00000000,
    0x00000000, 0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x1e000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_237 = { 12, 22, 1, 1, gallant19_237_pixels, 0 };

static u_int32_t gallant19_238_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x1e000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_238 = { 12, 22, 1, 1, gallant19_238_pixels, 0 };

static u_int32_t gallant19_239_pixels[] = {
    0x00000000,
    0x00000000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x1e000000,
    0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000, 0x06000000,
    0x06000000, 0x06000000, 0x1f800000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_239 = { 12, 22, 1, 1, gallant19_239_pixels, 0 };

static u_int32_t gallant19_240_pixels[] = {
    0x00000000,
    0x44000000, 0x6c000000, 0x38000000, 0x38000000, 0x6c000000, 0x46000000,
    0x03000000, 0x0f800000, 0x11c00000, 0x20e00000, 0x60600000, 0x60600000,
    0x70400000, 0x38800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_240 = { 12, 22, 1, 1, gallant19_240_pixels, 0 };

static u_int32_t gallant19_241_pixels[] = {
    0x00000000,
    0x00000000, 0x0c800000, 0x1f800000, 0x13000000, 0x00000000, 0x27800000,
    0x79c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x30c00000, 0x79e00000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_241 = { 12, 22, 1, 1, gallant19_241_pixels, 0 };

static u_int32_t gallant19_242_pixels[] = {
    0x00000000,
    0x00000000, 0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x0f800000,
    0x11c00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70400000, 0x38800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_242 = { 12, 22, 1, 1, gallant19_242_pixels, 0 };

static u_int32_t gallant19_243_pixels[] = {
    0x00000000,
    0x00000000, 0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x0f800000,
    0x11c00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70400000, 0x38800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_243 = { 12, 22, 1, 1, gallant19_243_pixels, 0 };

static u_int32_t gallant19_244_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x0f800000,
    0x11c00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70400000, 0x38800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_244 = { 12, 22, 1, 1, gallant19_244_pixels, 0 };

static u_int32_t gallant19_245_pixels[] = {
    0x00000000,
    0x00000000, 0x0c800000, 0x1f800000, 0x13000000, 0x00000000, 0x0f800000,
    0x11c00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70400000, 0x38800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_245 = { 12, 22, 1, 1, gallant19_245_pixels, 0 };

static u_int32_t gallant19_246_pixels[] = {
    0x00000000,
    0x00000000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x0f800000,
    0x11c00000, 0x20e00000, 0x60600000, 0x60600000, 0x60600000, 0x60600000,
    0x70400000, 0x38800000, 0x1f000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_246 = { 12, 22, 1, 1, gallant19_246_pixels, 0 };

static u_int32_t gallant19_247_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x06000000, 0x00000000,
    0x00000000, 0x7fe00000, 0x7fe00000, 0x00000000, 0x00000000, 0x06000000,
    0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_247 = { 12, 22, 1, 1, gallant19_247_pixels, 0 };

static u_int32_t gallant19_248_pixels[] = {
    0x00000000,
    0x00000000, 0x00000000, 0x00600000, 0x00600000, 0x00c00000, 0x0fc00000,
    0x11c00000, 0x23e00000, 0x63600000, 0x66600000, 0x66600000, 0x6c600000,
    0x7c400000, 0x38800000, 0x3f000000, 0x60000000, 0x60000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_248 = { 12, 22, 1, 1, gallant19_248_pixels, 0 };

static u_int32_t gallant19_249_pixels[] = {
    0x00000000,
    0x00000000, 0x18000000, 0x0c000000, 0x06000000, 0x00000000, 0x79e00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1e600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_249 = { 12, 22, 1, 1, gallant19_249_pixels, 0 };

static u_int32_t gallant19_250_pixels[] = {
    0x00000000,
    0x00000000, 0x01800000, 0x03000000, 0x06000000, 0x00000000, 0x79e00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1e600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_250 = { 12, 22, 1, 1, gallant19_250_pixels, 0 };

static u_int32_t gallant19_251_pixels[] = {
    0x00000000,
    0x00000000, 0x06000000, 0x0f000000, 0x19800000, 0x00000000, 0x79e00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1e600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_251 = { 12, 22, 1, 1, gallant19_251_pixels, 0 };

static u_int32_t gallant19_252_pixels[] = {
    0x00000000,
    0x00000000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0x79e00000,
    0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000, 0x30c00000,
    0x30c00000, 0x39c00000, 0x1e600000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_252 = { 12, 22, 1, 1, gallant19_252_pixels, 0 };

static u_int32_t gallant19_253_pixels[] = {
    0x00000000,
    0x00000000, 0x01800000, 0x03000000, 0x06000000, 0x00000000, 0xf0f00000,
    0x60200000, 0x30400000, 0x30400000, 0x18800000, 0x18800000, 0x0d000000,
    0x0d000000, 0x06000000, 0x06000000, 0x04000000, 0x0c000000, 0x08000000,
    0x78000000, 0x70000000, 0x00000000
};
static struct raster gallant19_253 = { 12, 22, 1, 1, gallant19_253_pixels, 0 };

static u_int32_t gallant19_254_pixels[] = {
    0x00000000,
    0x00000000, 0xf0000000, 0x60000000, 0x60000000, 0x60000000, 0x60000000,
    0x7f000000, 0x61800000, 0x61800000, 0x61800000, 0x61800000, 0x61800000,
    0x7f000000, 0x60000000, 0xf0000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000
};
static struct raster gallant19_254 = { 12, 22, 1, 1, gallant19_254_pixels, 0 };

static u_int32_t gallant19_255_pixels[] = {
    0x00000000,
    0x00000000, 0x19800000, 0x19800000, 0x00000000, 0x00000000, 0xf0f00000,
    0x60200000, 0x30400000, 0x30400000, 0x18800000, 0x18800000, 0x0d000000,
    0x0d000000, 0x06000000, 0x06000000, 0x04000000, 0x0c000000, 0x08000000,
    0x78000000, 0x70000000, 0x00000000
};
static struct raster gallant19_255 = { 12, 22, 1, 1, gallant19_255_pixels, 0 };

#define	null2 {0}, {0}
#define	null4 null2, null2
#define	null8 null4, null4
#define	null16 null8, null8
#define	null32 null16, null16
#define	null64 null32, null32
#define	null128 null64, null64

struct raster_font gallant19 = {
    12, 22, 15, RASFONT_FIXEDWIDTH|RASFONT_NOVERTICALMOVEMENT,
    {
	null32,
	{ &gallant19_32, 0, -15, 12, 0 },
	{ &gallant19_33, 0, -15, 12, 0 },
	{ &gallant19_34, 0, -15, 12, 0 },
	{ &gallant19_35, 0, -15, 12, 0 },
	{ &gallant19_36, 0, -15, 12, 0 },
	{ &gallant19_37, 0, -15, 12, 0 },
	{ &gallant19_38, 0, -15, 12, 0 },
	{ &gallant19_39, 0, -15, 12, 0 },
	{ &gallant19_40, 0, -15, 12, 0 },
	{ &gallant19_41, 0, -15, 12, 0 },
	{ &gallant19_42, 0, -15, 12, 0 },
	{ &gallant19_43, 0, -15, 12, 0 },
	{ &gallant19_44, 0, -15, 12, 0 },
	{ &gallant19_45, 0, -15, 12, 0 },
	{ &gallant19_46, 0, -15, 12, 0 },
	{ &gallant19_47, 0, -15, 12, 0 },
	{ &gallant19_48, 0, -15, 12, 0 },
	{ &gallant19_49, 0, -15, 12, 0 },
	{ &gallant19_50, 0, -15, 12, 0 },
	{ &gallant19_51, 0, -15, 12, 0 },
	{ &gallant19_52, 0, -15, 12, 0 },
	{ &gallant19_53, 0, -15, 12, 0 },
	{ &gallant19_54, 0, -15, 12, 0 },
	{ &gallant19_55, 0, -15, 12, 0 },
	{ &gallant19_56, 0, -15, 12, 0 },
	{ &gallant19_57, 0, -15, 12, 0 },
	{ &gallant19_58, 0, -15, 12, 0 },
	{ &gallant19_59, 0, -15, 12, 0 },
	{ &gallant19_60, 0, -15, 12, 0 },
	{ &gallant19_61, 0, -15, 12, 0 },
	{ &gallant19_62, 0, -15, 12, 0 },
	{ &gallant19_63, 0, -15, 12, 0 },
	{ &gallant19_64, 0, -15, 12, 0 },
	{ &gallant19_65, 0, -15, 12, 0 },
	{ &gallant19_66, 0, -15, 12, 0 },
	{ &gallant19_67, 0, -15, 12, 0 },
	{ &gallant19_68, 0, -15, 12, 0 },
	{ &gallant19_69, 0, -15, 12, 0 },
	{ &gallant19_70, 0, -15, 12, 0 },
	{ &gallant19_71, 0, -15, 12, 0 },
	{ &gallant19_72, 0, -15, 12, 0 },
	{ &gallant19_73, 0, -15, 12, 0 },
	{ &gallant19_74, 0, -15, 12, 0 },
	{ &gallant19_75, 0, -15, 12, 0 },
	{ &gallant19_76, 0, -15, 12, 0 },
	{ &gallant19_77, 0, -15, 12, 0 },
	{ &gallant19_78, 0, -15, 12, 0 },
	{ &gallant19_79, 0, -15, 12, 0 },
	{ &gallant19_80, 0, -15, 12, 0 },
	{ &gallant19_81, 0, -15, 12, 0 },
	{ &gallant19_82, 0, -15, 12, 0 },
	{ &gallant19_83, 0, -15, 12, 0 },
	{ &gallant19_84, 0, -15, 12, 0 },
	{ &gallant19_85, 0, -15, 12, 0 },
	{ &gallant19_86, 0, -15, 12, 0 },
	{ &gallant19_87, 0, -15, 12, 0 },
	{ &gallant19_88, 0, -15, 12, 0 },
	{ &gallant19_89, 0, -15, 12, 0 },
	{ &gallant19_90, 0, -15, 12, 0 },
	{ &gallant19_91, 0, -15, 12, 0 },
	{ &gallant19_92, 0, -15, 12, 0 },
	{ &gallant19_93, 0, -15, 12, 0 },
	{ &gallant19_94, 0, -15, 12, 0 },
	{ &gallant19_95, 0, -15, 12, 0 },
	{ &gallant19_96, 0, -15, 12, 0 },
	{ &gallant19_97, 0, -15, 12, 0 },
	{ &gallant19_98, 0, -15, 12, 0 },
	{ &gallant19_99, 0, -15, 12, 0 },
	{ &gallant19_100, 0, -15, 12, 0 },
	{ &gallant19_101, 0, -15, 12, 0 },
	{ &gallant19_102, 0, -15, 12, 0 },
	{ &gallant19_103, 0, -15, 12, 0 },
	{ &gallant19_104, 0, -15, 12, 0 },
	{ &gallant19_105, 0, -15, 12, 0 },
	{ &gallant19_106, 0, -15, 12, 0 },
	{ &gallant19_107, 0, -15, 12, 0 },
	{ &gallant19_108, 0, -15, 12, 0 },
	{ &gallant19_109, 0, -15, 12, 0 },
	{ &gallant19_110, 0, -15, 12, 0 },
	{ &gallant19_111, 0, -15, 12, 0 },
	{ &gallant19_112, 0, -15, 12, 0 },
	{ &gallant19_113, 0, -15, 12, 0 },
	{ &gallant19_114, 0, -15, 12, 0 },
	{ &gallant19_115, 0, -15, 12, 0 },
	{ &gallant19_116, 0, -15, 12, 0 },
	{ &gallant19_117, 0, -15, 12, 0 },
	{ &gallant19_118, 0, -15, 12, 0 },
	{ &gallant19_119, 0, -15, 12, 0 },
	{ &gallant19_120, 0, -15, 12, 0 },
	{ &gallant19_121, 0, -15, 12, 0 },
	{ &gallant19_122, 0, -15, 12, 0 },
	{ &gallant19_123, 0, -15, 12, 0 },
	{ &gallant19_124, 0, -15, 12, 0 },
	{ &gallant19_125, 0, -15, 12, 0 },
	{ &gallant19_126, 0, -15, 12, 0 },
	{ 0 },
	null32,
	{ &gallant19_32, 0, -15, 12, 0 },
	{ &gallant19_161, 0, -15, 12, 0 },
	{ &gallant19_162, 0, -15, 12, 0 },
	{ &gallant19_163, 0, -15, 12, 0 },
	{ &gallant19_164, 0, -15, 12, 0 },
	{ &gallant19_165, 0, -15, 12, 0 },
	{ &gallant19_166, 0, -15, 12, 0 },
	{ &gallant19_167, 0, -15, 12, 0 },
	{ &gallant19_168, 0, -15, 12, 0 },
	{ &gallant19_169, 0, -15, 12, 0 },
	{ &gallant19_170, 0, -15, 12, 0 },
	{ &gallant19_171, 0, -15, 12, 0 },
	{ &gallant19_172, 0, -15, 12, 0 },
	{ &gallant19_173, 0, -15, 12, 0 },
	{ &gallant19_174, 0, -15, 12, 0 },
	{ &gallant19_175, 0, -15, 12, 0 },
	{ &gallant19_176, 0, -15, 12, 0 },
	{ &gallant19_177, 0, -15, 12, 0 },
	{ &gallant19_178, 0, -15, 12, 0 },
	{ &gallant19_179, 0, -15, 12, 0 },
	{ &gallant19_180, 0, -15, 12, 0 },
	{ &gallant19_181, 0, -15, 12, 0 },
	{ &gallant19_182, 0, -15, 12, 0 },
	{ &gallant19_183, 0, -15, 12, 0 },
	{ &gallant19_184, 0, -15, 12, 0 },
	{ &gallant19_185, 0, -15, 12, 0 },
	{ &gallant19_186, 0, -15, 12, 0 },
	{ &gallant19_187, 0, -15, 12, 0 },
	{ &gallant19_188, 0, -15, 12, 0 },
	{ &gallant19_189, 0, -15, 12, 0 },
	{ &gallant19_190, 0, -15, 12, 0 },
	{ &gallant19_191, 0, -15, 12, 0 },
	{ &gallant19_192, 0, -15, 12, 0 },
	{ &gallant19_193, 0, -15, 12, 0 },
	{ &gallant19_194, 0, -15, 12, 0 },
	{ &gallant19_195, 0, -15, 12, 0 },
	{ &gallant19_196, 0, -15, 12, 0 },
	{ &gallant19_197, 0, -15, 12, 0 },
	{ &gallant19_198, 0, -15, 12, 0 },
	{ &gallant19_199, 0, -15, 12, 0 },
	{ &gallant19_200, 0, -15, 12, 0 },
	{ &gallant19_201, 0, -15, 12, 0 },
	{ &gallant19_202, 0, -15, 12, 0 },
	{ &gallant19_203, 0, -15, 12, 0 },
	{ &gallant19_204, 0, -15, 12, 0 },
	{ &gallant19_205, 0, -15, 12, 0 },
	{ &gallant19_206, 0, -15, 12, 0 },
	{ &gallant19_207, 0, -15, 12, 0 },
	{ &gallant19_208, 0, -15, 12, 0 },
	{ &gallant19_209, 0, -15, 12, 0 },
	{ &gallant19_210, 0, -15, 12, 0 },
	{ &gallant19_211, 0, -15, 12, 0 },
	{ &gallant19_212, 0, -15, 12, 0 },
	{ &gallant19_213, 0, -15, 12, 0 },
	{ &gallant19_214, 0, -15, 12, 0 },
	{ &gallant19_215, 0, -15, 12, 0 },
	{ &gallant19_216, 0, -15, 12, 0 },
	{ &gallant19_217, 0, -15, 12, 0 },
	{ &gallant19_218, 0, -15, 12, 0 },
	{ &gallant19_219, 0, -15, 12, 0 },
	{ &gallant19_220, 0, -15, 12, 0 },
	{ &gallant19_221, 0, -15, 12, 0 },
	{ &gallant19_222, 0, -15, 12, 0 },
	{ &gallant19_223, 0, -15, 12, 0 },
	{ &gallant19_224, 0, -15, 12, 0 },
	{ &gallant19_225, 0, -15, 12, 0 },
	{ &gallant19_226, 0, -15, 12, 0 },
	{ &gallant19_227, 0, -15, 12, 0 },
	{ &gallant19_228, 0, -15, 12, 0 },
	{ &gallant19_229, 0, -15, 12, 0 },
	{ &gallant19_230, 0, -15, 12, 0 },
	{ &gallant19_231, 0, -15, 12, 0 },
	{ &gallant19_232, 0, -15, 12, 0 },
	{ &gallant19_233, 0, -15, 12, 0 },
	{ &gallant19_234, 0, -15, 12, 0 },
	{ &gallant19_235, 0, -15, 12, 0 },
	{ &gallant19_236, 0, -15, 12, 0 },
	{ &gallant19_237, 0, -15, 12, 0 },
	{ &gallant19_238, 0, -15, 12, 0 },
	{ &gallant19_239, 0, -15, 12, 0 },
	{ &gallant19_240, 0, -15, 12, 0 },
	{ &gallant19_241, 0, -15, 12, 0 },
	{ &gallant19_242, 0, -15, 12, 0 },
	{ &gallant19_243, 0, -15, 12, 0 },
	{ &gallant19_244, 0, -15, 12, 0 },
	{ &gallant19_245, 0, -15, 12, 0 },
	{ &gallant19_246, 0, -15, 12, 0 },
	{ &gallant19_247, 0, -15, 12, 0 },
	{ &gallant19_248, 0, -15, 12, 0 },
	{ &gallant19_249, 0, -15, 12, 0 },
	{ &gallant19_250, 0, -15, 12, 0 },
	{ &gallant19_251, 0, -15, 12, 0 },
	{ &gallant19_252, 0, -15, 12, 0 },
	{ &gallant19_253, 0, -15, 12, 0 },
	{ &gallant19_254, 0, -15, 12, 0 },
	{ &gallant19_255, 0, -15, 12, 0 },
    },
#ifdef COLORFONT_CACHE
    (struct raster_fontcache*) -1
#endif /*COLORFONT_CACHE*/
};
