/*	$NetBSD: tx3912videoreg.h,v 1.5 2001/06/14 11:09:55 uch Exp $ */

/*-
 * Copyright (c) 1999, 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by UCHIYAMA Yasushi.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/* 
 *  TOSHIBA TMPR3912/05, Philips PR31700 Video module register 
 */
#define TX3912_VIDEOCTRL1_REG		0x28
#define TX3912_VIDEOCTRL2_REG		0x2c
#define TX3912_VIDEOCTRL3_REG		0x30
#define TX3912_VIDEOCTRL4_REG		0x34
#define TX3912_VIDEOCTRL5_REG		0x38
#define TX3912_VIDEOCTRL6_REG		0x3c
#define TX3912_VIDEOCTRL7_REG		0x40
#define TX3912_VIDEOCTRL8_REG		0x44
#define TX3912_VIDEOCTRL9_REG		0x48
#define TX3912_VIDEOCTRL10_REG		0x4c
#define TX3912_VIDEOCTRL11_REG		0x50
#define TX3912_VIDEOCTRL12_REG		0x54
#define TX3912_VIDEOCTRL13_REG		0x58
#define TX3912_VIDEOCTRL14_REG		0x5c

#define TX3912_FRAMEBUFFER_ALIGNMENT	16
#define TX3912_FRAMEBUFFER_BOUNDARY	0x100000
#define TX3912_FRAMEBUFFER_MAX		(2048 * 1024 * 8)

/*
 *	Video Control 1 Register
 */
/* R */
#define TX3912_VIDEOCTRL1_LINECNT_SHIFT 22
#define TX3912_VIDEOCTRL1_LINECNT_MASK	0x3ff
#define TX3912_VIDEOCTRL1_LINECNT(cr)					\
	(((cr) >> TX3912_VIDEOCTRL1_LINECNT_SHIFT) &			\
	TX3912_VIDEOCTRL1_LINECNT_MASK)
/* R/W */
#define TX3912_VIDEOCTRL1_LOADDLY	0x00200000
/* R/W */
/*
 * CP Rate = 36.864MHz / (BAUDVAL * 2 + 2)
 */
#define TX3912_VIDEOCTRL1_BAUDVAL_SHIFT 16
#define TX3912_VIDEOCTRL1_BAUDVAL_MASK	0x1f
#define TX3912_VIDEOCTRL1_BAUDVAL(cr)					\
	(((cr) >> TX3912_VIDEOCTRL1_BAUDVAL_SHIFT) &			\
	TX3912_VIDEOCTRL1_BAUDVAL_MASK)
#define TX3912_VIDEOCTRL1_BAUDVAL_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL1_BAUDVAL_SHIFT) &		\
	(TX3912_VIDEOCTRL1_BAUDVAL_MASK << TX3912_VIDEOCTRL1_BAUDVAL_SHIFT)))

/* R/W */
#define TX3912_VIDEOCTRL1_VIDDONEVAL_SHIFT	9
#define TX3912_VIDEOCTRL1_VIDDONEVAL_MASK	0x7f
#define TX3912_VIDEOCTRL1_VIDDONEVAL(cr)				\
	(((cr) >> TX3912_VIDEOCTRL1_VIDDONEVAL_SHIFT) &			\
	TX3912_VIDEOCTRL1_VIDDONEVAL_MASK)
#define TX3912_VIDEOCTRL1_VIDDONEVAL_SET(cr, val)			\
	((cr) | (((val) << TX3912_VIDEOCTRL1_VIDDONEVAL_SHIFT) &	\
	(TX3912_VIDEOCTRL1_VIDDONEVAL_MASK << TX3912_VIDEOCTRL1_VIDDONEVAL_SHIFT)))
/* R/W */
#define TX3912_VIDEOCTRL1_ENFREEZEFRAME	0x00000100
/* R/W */
#define TX3912_VIDEOCTRL1_BITSEL_SHIFT	6
#define TX3912_VIDEOCTRL1_BITSEL_MASK	0x3
#define TX3912_VIDEOCTRL1_BITSEL(cr)					\
	(((cr) >> TX3912_VIDEOCTRL1_BITSEL_SHIFT) &			\
	TX3912_VIDEOCTRL1_BITSEL_MASK)
#define TX3912_VIDEOCTRL1_BITSEL_CLR(cr)				\
	((cr) &= ~(TX3912_VIDEOCTRL1_BITSEL_MASK <<			\
		   TX3912_VIDEOCTRL1_BITSEL_SHIFT))
#define TX3912_VIDEOCTRL1_BITSEL_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL1_BITSEL_SHIFT) &		\
	(TX3912_VIDEOCTRL1_BITSEL_MASK << TX3912_VIDEOCTRL1_BITSEL_SHIFT)))
#define TX3912_VIDEOCTRL1_BITSEL_8BITCOLOR	0x3
#define TX3912_VIDEOCTRL1_BITSEL_4BITGREYSCALE	0x2
#define TX3912_VIDEOCTRL1_BITSEL_2BITGREYSCALE	0x1
#define TX3912_VIDEOCTRL1_BITSEL_MONOCHROME	0x0
/* R/W */
#define TX3912_VIDEOCTRL1_DISPSPLIT	0x00000020
#define TX3912_VIDEOCTRL1_DISP8		0x00000010
#define TX3912_VIDEOCTRL1_DFMODE	0x00000008
#define TX3912_VIDEOCTRL1_INVVID	0x00000004
#define TX3912_VIDEOCTRL1_DISPON	0x00000002
#define TX3912_VIDEOCTRL1_ENVID		0x00000001

/*
 *	Video Control 2 Register
 */
/* W */
#define TX3912_VIDEOCTRL2_VIDRATE_SHIFT 22
#define TX3912_VIDEOCTRL2_VIDRATE_MASK	0x3ff
#define TX3912_VIDEOCTRL2_VIDRATE(cr)					\
	(((cr) >> TX3912_VIDEOCTRL2_VIDRATE_SHIFT) &			\
	TX3912_VIDEOCTRL2_VIDRATE_MASK)
#define TX3912_VIDEOCTRL2_VIDRATE_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL2_VIDRATE_SHIFT) &		\
	(TX3912_VIDEOCTRL2_VIDRATE_MASK << TX3912_VIDEOCTRL2_VIDRATE_SHIFT)))

/* W */
/*
 * HORZVAL = (HorzSize4 - 1) for 4bit split or non-split LCD
 * HORZVAL = (HorzSize8 - 1) for 8bit non-split LCD
 */
#define TX3912_VIDEOCTRL2_HORZVAL_SHIFT 12
#define TX3912_VIDEOCTRL2_HORZVAL_MASK	0x1ff
#define TX3912_VIDEOCTRL2_HORZVAL(cr)					\
	(((cr) >> TX3912_VIDEOCTRL2_HORZVAL_SHIFT) &			\
	TX3912_VIDEOCTRL2_HORZVAL_MASK)
#define TX3912_VIDEOCTRL2_HORZVAL_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL2_HORZVAL_SHIFT) &		\
	(TX3912_VIDEOCTRL2_HORZVAL_MASK << TX3912_VIDEOCTRL2_HORZVAL_SHIFT)))

/* W */
/*
 * LINEVAL = (# of Lines - 1) for a non-split LCD
 * LINEVAL = (# of Lins2 - 1) for a split LCD
 */
#define TX3912_VIDEOCTRL2_LINEVAL_SHIFT 0
#define TX3912_VIDEOCTRL2_LINEVAL_MASK	0x3ff
#define TX3912_VIDEOCTRL2_LINEVAL(cr)					\
	(((cr) >> TX3912_VIDEOCTRL2_LINEVAL_SHIFT) &			\
	TX3912_VIDEOCTRL2_LINEVAL_MASK)
#define TX3912_VIDEOCTRL2_LINEVAL_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL2_LINEVAL_SHIFT) &		\
	(TX3912_VIDEOCTRL2_LINEVAL_MASK << TX3912_VIDEOCTRL2_LINEVAL_SHIFT)))

/*
 *	Video Control 3 Register
 */
/* W */
#define TX3912_VIDEOCTRL3_VIDBANK_SHIFT		20
#define TX3912_VIDEOCTRL3_VIDBANK_MASK		0xfff
#define TX3912_VIDEOCTRL3_VIDBANK(cr)					\
	(((cr) >> TX3912_VIDEOCTRL3_VIDBANK_SHIFT) &			\
	TX3912_VIDEOCTRL3_VIDBANK_MASK)
#define TX3912_VIDEOCTRL3_VIDBANK_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL3_VIDBANK_SHIFT) &		\
	(TX3912_VIDEOCTRL3_VIDBANK_MASK << TX3912_VIDEOCTRL3_VIDBANK_SHIFT)))

/* W */
#define TX3912_VIDEOCTRL3_VIDBASEHI_SHIFT	4
#define TX3912_VIDEOCTRL3_VIDBASEHI_MASK	0xffff
#define TX3912_VIDEOCTRL3_VIDBASEHI(cr)					\
	(((cr) >> TX3912_VIDEOCTRL3_VIDBASEHI_SHIFT) &			\
	TX3912_VIDEOCTRL3_VIDBASEHI_MASK)
#define TX3912_VIDEOCTRL3_VIDBASEHI_SET(cr, val)			\
	((cr) | (((val) << TX3912_VIDEOCTRL3_VIDBASEHI_SHIFT) &		\
	(TX3912_VIDEOCTRL3_VIDBASEHI_MASK << TX3912_VIDEOCTRL3_VIDBASEHI_SHIFT)))


/*
 *	Video Control 4 Register
 */
/* W */
/*
 * DF Rate = LineRate / (DFVAL + 1)
 */
#define TX3912_VIDEOCTRL4_DFVAL_SHIFT	24
#define TX3912_VIDEOCTRL4_DFVAL_MASK	0xff
#define TX3912_VIDEOCTRL4_DFVAL(cr)					\
	(((cr) >> TX3912_VIDEOCTRL4_DFVAL_SHIFT) &			\
	TX3912_VIDEOCTRL4_DFVAL_MASK)
#define TX3912_VIDEOCTRL4_DFVAL_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL4_DFVAL_SHIFT) &		\
	(TX3912_VIDEOCTRL4_DFVAL_MASK << TX3912_VIDEOCTRL4_DFVAL_SHIFT)))

#define TX3912_VIDEOCTRL4_FRAMEMASKVAL_SHIFT	20
#define TX3912_VIDEOCTRL4_FRAMEMASKVAL_MASK	0xf
#define TX3912_VIDEOCTRL4_FRAMEMASKVAL(cr)				\
	(((cr) >> TX3912_VIDEOCTRL4_FRAMEMASKVAL_SHIFT) &		\
	TX3912_VIDEOCTRL4_FRAMEMASKVAL_MASK)
#define TX3912_VIDEOCTRL4_FRAMEMASKVAL_SET(cr, val)			\
	((cr) | (((val) << TX3912_VIDEOCTRL4_FRAMEMASKVAL_SHIFT) &	\
	(TX3912_VIDEOCTRL4_FRAMEMASKVAL_MASK << TX3912_VIDEOCTRL4_FRAMEMASKVAL_SHIFT)))

#define TX3912_VIDEOCTRL4_VIDBASELO_SHIFT	4
#define TX3912_VIDEOCTRL4_VIDBASELO_MASK	0xffff
#define TX3912_VIDEOCTRL4_VIDBASELO(cr)					\
	(((cr) >> TX3912_VIDEOCTRL4_VIDBASELO_SHIFT) &			\
	TX3912_VIDEOCTRL4_VIDBASELO_MASK)
#define TX3912_VIDEOCTRL4_VIDBASELO_SET(cr, val)			\
	((cr) | (((val) << TX3912_VIDEOCTRL4_VIDBASELO_SHIFT) &		\
	(TX3912_VIDEOCTRL4_VIDBASELO_MASK << TX3912_VIDEOCTRL4_VIDBASELO_SHIFT)))

/*
 *	Video Control 5 Register
 */
/* W */
/*
 * TX3912_VIDEOCTRL5_REDSEL (31:0) 
 */

/*
 *	Video Control 6 Register
 */
/* W */
/*
 * TX3912_VIDEOCTRL6_GREENSEL (31:0) 
 */

/*
 *	Video Control 7 Register
 */
/* W */
/*
 * TX3912_VIDEOCTRL6_BLUESEL (31:0) 
 */

/*
 *	Video Control 8 Register
 */
/* W */
/*
 * 2_3 means `2 out of 3'
 */
#define TX3912_VIDEOCTRL8_PAT2_3_SHIFT	0
#define TX3912_VIDEOCTRL8_PAT2_3_MASK	0xfff
#define TX3912_VIDEOCTRL8_PAT2_3(cr)					\
	(((cr) >> TX3912_VIDEOCTRL8_PAT2_3_SHIFT) &			\
	TX3912_VIDEOCTRL8_PAT2_3_MASK)
#define TX3912_VIDEOCTRL8_PAT2_3_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL8_PAT2_3_SHIFT) &		\
	(TX3912_VIDEOCTRL8_PAT2_3_MASK << TX3912_VIDEOCTRL8_PAT2_3_SHIFT)))

/*
 *	Video Control 9 Register
 */
/* W */
#define TX3912_VIDEOCTRL9_PAT3_4_SHIFT	16
#define TX3912_VIDEOCTRL9_PAT3_4_MASK	0xffff
#define TX3912_VIDEOCTRL9_PAT3_4(cr)					\
	(((cr) >> TX3912_VIDEOCTRL9_PAT3_4_SHIFT) &			\
	TX3912_VIDEOCTRL9_PAT3_4_MASK)
#define TX3912_VIDEOCTRL9_PAT3_4_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL9_PAT3_4_SHIFT) &		\
	(TX3912_VIDEOCTRL9_PAT3_4_MASK << TX3912_VIDEOCTRL9_PAT3_4_SHIFT)))
/* W */
#define TX3912_VIDEOCTRL9_PAT2_4_SHIFT	0
#define TX3912_VIDEOCTRL9_PAT2_4_MASK	0xffff
#define TX3912_VIDEOCTRL9_PAT2_4(cr)					\
	(((cr) >> TX3912_VIDEOCTRL9_PAT2_4_SHIFT) &			\
	TX3912_VIDEOCTRL9_PAT2_4_MASK)
#define TX3912_VIDEOCTRL9_PAT2_4_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL9_PAT2_4_SHIFT) &		\
	(TX3912_VIDEOCTRL9_PAT2_4_MASK << TX3912_VIDEOCTRL9_PAT2_4_SHIFT)))

/*
 *	Video Control 10 Register
 */
/* W */
#define TX3912_VIDEOCTRL10_PAT4_5_SHIFT	0
#define TX3912_VIDEOCTRL10_PAT4_5_MASK	0xfffff
#define TX3912_VIDEOCTRL10_PAT4_5(cr)					\
	(((cr) >> TX3912_VIDEOCTRL10_PAT4_5_SHIFT) &			\
	TX3912_VIDEOCTRL10_PAT4_5_MASK)
#define TX3912_VIDEOCTRL10_PAT4_5_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL10_PAT4_5_SHIFT) &		\
	(TX3912_VIDEOCTRL10_PAT4_5_MASK << TX3912_VIDEOCTRL10_PAT4_5_SHIFT)))

/*
 *	Video Control 11 Register
 */
/* W */
#define TX3912_VIDEOCTRL11_PAT3_5_SHIFT	0
#define TX3912_VIDEOCTRL11_PAT3_5_MASK	0xfffff
#define TX3912_VIDEOCTRL11_PAT3_5(cr)					\
	(((cr) >> TX3912_VIDEOCTRL11_PAT3_5_SHIFT) &			\
	TX3912_VIDEOCTRL11_PAT3_5_MASK)
#define TX3912_VIDEOCTRL11_PAT3_5_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL11_PAT3_5_SHIFT) &		\
	(TX3912_VIDEOCTRL11_PAT3_5_MASK << TX3912_VIDEOCTRL11_PAT3_5_SHIFT)))

/*
 *	Video Control 12 Register
 */
/* W */
#define TX3912_VIDEOCTRL12_PAT6_7_SHIFT	0
#define TX3912_VIDEOCTRL12_PAT6_7_MASK	0xfffffff
#define TX3912_VIDEOCTRL12_PAT6_7(cr)					\
	(((cr) >> TX3912_VIDEOCTRL12_PAT6_7_SHIFT) &			\
	TX3912_VIDEOCTRL12_PAT6_7_MASK)
#define TX3912_VIDEOCTRL12_PAT6_7_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL12_PAT6_7_SHIFT) &		\
	(TX3912_VIDEOCTRL12_PAT6_7_MASK << TX3912_VIDEOCTRL12_PAT6_7_SHIFT)))

/*
 *	Video Control 13 Register
 */
/* W */
#define TX3912_VIDEOCTRL13_PAT5_7_SHIFT	0
#define TX3912_VIDEOCTRL13_PAT5_7_MASK	0xfffffff
#define TX3912_VIDEOCTRL13_PAT5_7(cr)					\
	(((cr) >> TX3912_VIDEOCTRL13_PAT5_7_SHIFT) &			\
	TX3912_VIDEOCTRL13_PAT5_7_MASK)
#define TX3912_VIDEOCTRL13_PAT5_7_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL13_PAT5_7_SHIFT) &		\
	(TX3912_VIDEOCTRL13_PAT5_7_MASK << TX3912_VIDEOCTRL13_PAT5_7_SHIFT)))

/*
 *	Video Control 14 Register
 */
/* W */
#define TX3912_VIDEOCTRL14_PAT4_7_SHIFT	0
#define TX3912_VIDEOCTRL14_PAT4_7_MASK	0xfffffff
#define TX3912_VIDEOCTRL14_PAT4_7(cr)					\
	(((cr) >> TX3912_VIDEOCTRL14_PAT4_7_SHIFT) &			\
	TX3912_VIDEOCTRL14_PAT4_7_MASK)
#define TX3912_VIDEOCTRL14_PAT4_7_SET(cr, val)				\
	((cr) | (((val) << TX3912_VIDEOCTRL14_PAT4_7_SHIFT) &		\
	(TX3912_VIDEOCTRL14_PAT4_7_MASK << TX3912_VIDEOCTRL14_PAT4_7_SHIFT)))

/*
 *	Default dither pattern
 */
#define P0000	0x0
#define P0001	0x1
#define P0010	0x2
#define P0011	0x3
#define P0100	0x4
#define P0101	0x5
#define P0110	0x6
#define P0111	0x7
#define P1000	0x8
#define P1001	0x9
#define P1010	0xa
#define P1011	0xb
#define P1100	0xc
#define P1101	0xd
#define P1110	0xe
#define P1111	0xf

#define DITHER_PATTERN(p0, p1, p2, p3, p4, p5, p6)			\
	(((p0) << 24) | ((p1) << 20) | ((p2) << 16) | ((p3) << 12) |	\
	 ((p4) << 8) | ((p5) << 4) || (p6))

#define TX3912_VIDEOCTRL8_PAT2_3_DEFAULT				\
	DITHER_PATTERN(0, 0, 0, 0, P0111, P1101, P1010)
#define TX3912_VIDEOCTRL9_PAT3_4_DEFAULT				\
	DITHER_PATTERN(0, 0, 0, P0111, P1101, P1011, P1110)
#define TX3912_VIDEOCTRL9_PAT2_4_DEFAULT				\
	DITHER_PATTERN(0, 0, 0, P1010, P0101, P1010, P0101)
#define TX3912_VIDEOCTRL10_PAT4_5_DEFAULT				\
	DITHER_PATTERN(0, 0, P0111, P1101, P1111, P1011, P1110)
#define TX3912_VIDEOCTRL11_PAT3_5_DEFAULT				\
	DITHER_PATTERN(0, 0, P0111, P1010, P0101, P1010, P1101)
#define TX3912_VIDEOCTRL12_PAT6_7_DEFAULT				\
	DITHER_PATTERN(P1111, P1011, P1111, P1101, P1111, P1110, P0111)
#define TX3912_VIDEOCTRL13_PAT5_7_DEFAULT				\
	DITHER_PATTERN(P0111, P1011, P0101, P1010, P1101, P1110, P1111)
#define TX3912_VIDEOCTRL14_PAT4_7_DEFAULT				\
	DITHER_PATTERN(P1011, P1001, P1101, P1100, P0110, P0110, P0011)

/* dither duty cycle : pre-dithered data nible mapping */
#define TX3912_VIDEO_DITHER_DUTYCYCLE_1		15
#define TX3912_VIDEO_DITHER_DUTYCYCLE_6_7	14
#define TX3912_VIDEO_DITHER_DUTYCYCLE_4_5	13
#define TX3912_VIDEO_DITHER_DUTYCYCLE_3_4	12
#define TX3912_VIDEO_DITHER_DUTYCYCLE_5_7	11
#define TX3912_VIDEO_DITHER_DUTYCYCLE_2_3	10
#define TX3912_VIDEO_DITHER_DUTYCYCLE_3_5	9
#define TX3912_VIDEO_DITHER_DUTYCYCLE_4_7	8
#define TX3912_VIDEO_DITHER_DUTYCYCLE_2_4	7
#define TX3912_VIDEO_DITHER_DUTYCYCLE_3_7	6
#define TX3912_VIDEO_DITHER_DUTYCYCLE_2_5	5
#define TX3912_VIDEO_DITHER_DUTYCYCLE_1_3	4
#define TX3912_VIDEO_DITHER_DUTYCYCLE_2_7	3
#define TX3912_VIDEO_DITHER_DUTYCYCLE_1_5	2
#define TX3912_VIDEO_DITHER_DUTYCYCLE_1_7	1
#define TX3912_VIDEO_DITHER_DUTYCYCLE_0		0
