/*	$NetBSD: frame.h,v 1.6 2004/03/28 15:46:14 drochner Exp $	*/

/*-
 * Copyright (c) 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Charles M. Hannum.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)frame.h	5.2 (Berkeley) 1/18/91
 */

/*
 * Adapted for NetBSD/amd64 by fvdl@wasabisystems.com
 */

#ifndef _AMD64_FRAME_H_
#define _AMD64_FRAME_H_

#include <sys/signal.h>
#include <machine/fpu.h>

/*
 * System stack frames.
 */

/*
 * Exception/Trap Stack Frame
 */
struct trapframe {
	uint64_t	tf_rdi;
	uint64_t	tf_rsi;
	uint64_t	tf_rdx;
	uint64_t	tf_rcx;
	uint64_t	tf_r8;
	uint64_t 	tf_r9;
	uint64_t	tf_r10;
	uint64_t 	tf_r11;
	uint64_t 	tf_r12;
	uint64_t 	tf_r13;
	uint64_t 	tf_r14;
	uint64_t 	tf_r15;
	uint64_t	tf_rbp;
	uint64_t	tf_rbx;
	uint64_t	tf_rax;
	uint64_t	tf_gs;
	uint64_t	tf_fs;
	uint64_t	tf_es;
	uint64_t	tf_ds;
	uint64_t	tf_trapno;
	/* below portion defined in hardware */
	uint64_t	tf_err;
	uint64_t	tf_rip;
	uint64_t	tf_cs;
	uint64_t	tf_rflags;
	/* These are pushed unconditionally on the x86-64 */
	uint64_t	tf_rsp;
	uint64_t	tf_ss;
};

/*
 * Interrupt stack frame
 */
struct intrframe {
	uint64_t	if_ppl;
	uint64_t	if_rdi;
	uint64_t	if_rsi;
	uint64_t	if_rdx;
	uint64_t	if_rcx;
	uint64_t	if_r8;
	uint64_t	if_r9;
	uint64_t	if_r10;
	uint64_t	if_r11;
	uint64_t	if_r12;
	uint64_t	if_r13;
	uint64_t	if_r14;
	uint64_t	if_r15;
	uint64_t	if_rbp;
	uint64_t	if_rbx;
	uint64_t	if_rax;
	uint64_t	tf_gs;
	uint64_t	tf_fs;
	uint64_t	tf_es;
	uint64_t	tf_ds;
	u_int64_t __if_trapno; /* for compat with trap frame - trapno */
	u_int64_t __if_err;	/* for compat with trap frame - err */
	/* below portion defined in hardware */
	uint64_t	if_rip;
	uint64_t	if_cs;
	uint64_t	if_rflags;
	/* These are pushed unconditionally on the x86-64 */
	uint64_t	if_rsp;
	uint64_t	if_ss;
};

/*
 * Stack frame inside cpu_switch()
 */
struct switchframe {
	uint64_t	sf_r15;
	uint64_t	sf_r14;
	uint64_t	sf_r13;
	uint64_t	sf_r12;
	uint64_t	sf_rbp;
	uint64_t	sf_rbx;
	uint64_t	sf_rip;
};

/*
 * Signal frame
 */
struct sigframe_siginfo {
	uint64_t	sf_ra;		/* return address for handler */
	siginfo_t	sf_si;		/* actual saved siginfo */
	ucontext_t	sf_uc;		/* actual saved ucontext */
};

#ifdef _KERNEL
void buildcontext(struct lwp *, void *, void *);
#endif

#endif  /* _AMD64_FRAME_H_ */
