/* 	$NetBSD: qvss8x15.h,v 1.7 2003/08/07 16:31:31 agc Exp $ */

/*-
 * Copyright (c) 1982, 1986
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)qfont.c	7.2 (Berkeley) 1/21/94
 */

/*
 *	derived from:  "@(#)qfont.c	6.2	ULTRIX	2/4/88"
 */

/************************************************************************
 *									*
 *			Copyright (c) 1984, 1987 by			*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   This software is  derived  from  software  received  from  the	*
 *   University    of   California,   Berkeley,   and   from   Bell	*
 *   Laboratories.  Use, duplication, or disclosure is  subject  to	*
 *   restrictions  under  license  agreements  with  University  of	*
 *   California and with AT&T.						*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

extern u_char qvss8x15_data[];

struct wsdisplay_font qvss8x15 = { 
	"QVSS",				/* typeface name */
	' ',				/* firstchar */
	0377 - ' ' + 1,			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	8,				/* width */
	15,				/* height */
	1,				/* stride */
	WSDISPLAY_FONTORDER_R2L,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	qvss8x15_data			/* data */
};

static u_char qvss8x15_data[] = {
/*  */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
/* */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x00, /* 0x00000000	  ! */
	0x08, /* 0x00001000	  ! */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
/* */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x24, /* 0x00100100	  " */
	0x24, /* 0x00100100	  " */
	0x24, /* 0x00100100	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
/* */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x3f, /* 0x00111111	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x3f, /* 0x00111111	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
/* */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x08, /* 0x00001000	  $ */
	0x3e, /* 0x00111110	  $ */
	0x09, /* 0x00001001	  $ */
	0x09, /* 0x00001001	  $ */
	0x3e, /* 0x00111110	  $ */
	0x48, /* 0x01001000	  $ */
	0x48, /* 0x01001000	  $ */
	0x3e, /* 0x00111110	  $ */
	0x08, /* 0x00001000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
/* */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
	0x42, /* 0x01000010	  % */
	0x25, /* 0x00100101	  % */
	0x25, /* 0x00100101	  % */
	0x12, /* 0x00010010	  % */
	0x08, /* 0x00001000	  % */
	0x08, /* 0x00001000	  % */
	0x24, /* 0x00100100	  % */
	0x52, /* 0x01010010	  % */
	0x52, /* 0x01010010	  % */
	0x21, /* 0x00100001	  % */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
/* */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
	0x0e, /* 0x00001110	  & */
	0x11, /* 0x00010001	  & */
	0x11, /* 0x00010001	  & */
	0x11, /* 0x00010001	  & */
	0x0e, /* 0x00001110	  & */
	0x11, /* 0x00010001	  & */
	0x51, /* 0x01010001	  & */
	0x21, /* 0x00100001	  & */
	0x31, /* 0x00110001	  & */
	0x4e, /* 0x01001110	  & */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
/* */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x38, /* 0x00111000	  ' */
	0x18, /* 0x00011000	  ' */
	0x04, /* 0x00000100	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
/* */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
	0x10, /* 0x00010000	  ( */
	0x08, /* 0x00001000	  ( */
	0x08, /* 0x00001000	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x08, /* 0x00001000	  ( */
	0x08, /* 0x00001000	  ( */
	0x10, /* 0x00010000	  ( */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
/* */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
	0x04, /* 0x00000100	  ) */
	0x08, /* 0x00001000	  ) */
	0x08, /* 0x00001000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x08, /* 0x00001000	  ) */
	0x08, /* 0x00001000	  ) */
	0x04, /* 0x00000100	  ) */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
/* */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x22, /* 0x00100010	  * */
	0x14, /* 0x00010100	  * */
	0x7f, /* 0x01111111	  * */
	0x14, /* 0x00010100	  * */
	0x22, /* 0x00100010	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
/* */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x7f, /* 0x01111111	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
/* */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x1c, /* 0x00011100	  , */
	0x0c, /* 0x00001100	  , */
	0x02, /* 0x00000010	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
/* */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x7f, /* 0x01111111	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
/* */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x08, /* 0x00001000	  . */
	0x1c, /* 0x00011100	  . */
	0x08, /* 0x00001000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
/* */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
	0x40, /* 0x01000000	  / */
	0x40, /* 0x01000000	  / */
	0x20, /* 0x00100000	  / */
	0x10, /* 0x00010000	  / */
	0x08, /* 0x00001000	  / */
	0x04, /* 0x00000100	  / */
	0x02, /* 0x00000010	  / */
	0x01, /* 0x00000001	  / */
	0x01, /* 0x00000001	  / */
	0x01, /* 0x00000001	  / */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
/* */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
	0x0c, /* 0x00001100	  0 */
	0x12, /* 0x00010010	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x12, /* 0x00010010	  0 */
	0x0c, /* 0x00001100	  0 */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
/* */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
	0x08, /* 0x00001000	  1 */
	0x0c, /* 0x00001100	  1 */
	0x0a, /* 0x00001010	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x3e, /* 0x00111110	  1 */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
/* */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
	0x3e, /* 0x00111110	  2 */
	0x41, /* 0x01000001	  2 */
	0x41, /* 0x01000001	  2 */
	0x40, /* 0x01000000	  2 */
	0x20, /* 0x00100000	  2 */
	0x10, /* 0x00010000	  2 */
	0x0c, /* 0x00001100	  2 */
	0x02, /* 0x00000010	  2 */
	0x01, /* 0x00000001	  2 */
	0x7f, /* 0x01111111	  2 */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
/* */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
	0x7f, /* 0x01111111	  3 */
	0x40, /* 0x01000000	  3 */
	0x20, /* 0x00100000	  3 */
	0x10, /* 0x00010000	  3 */
	0x38, /* 0x00111000	  3 */
	0x40, /* 0x01000000	  3 */
	0x40, /* 0x01000000	  3 */
	0x40, /* 0x01000000	  3 */
	0x41, /* 0x01000001	  3 */
	0x3e, /* 0x00111110	  3 */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
/* */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
	0x20, /* 0x00100000	  4 */
	0x30, /* 0x00110000	  4 */
	0x28, /* 0x00101000	  4 */
	0x24, /* 0x00100100	  4 */
	0x22, /* 0x00100010	  4 */
	0x21, /* 0x00100001	  4 */
	0x7f, /* 0x01111111	  4 */
	0x20, /* 0x00100000	  4 */
	0x20, /* 0x00100000	  4 */
	0x20, /* 0x00100000	  4 */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
/* */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
	0x7f, /* 0x01111111	  5 */
	0x01, /* 0x00000001	  5 */
	0x01, /* 0x00000001	  5 */
	0x3d, /* 0x00111101	  5 */
	0x43, /* 0x01000011	  5 */
	0x40, /* 0x01000000	  5 */
	0x40, /* 0x01000000	  5 */
	0x40, /* 0x01000000	  5 */
	0x41, /* 0x01000001	  5 */
	0x3e, /* 0x00111110	  5 */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
/* */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
	0x3c, /* 0x00111100	  6 */
	0x02, /* 0x00000010	  6 */
	0x01, /* 0x00000001	  6 */
	0x01, /* 0x00000001	  6 */
	0x3d, /* 0x00111101	  6 */
	0x43, /* 0x01000011	  6 */
	0x41, /* 0x01000001	  6 */
	0x41, /* 0x01000001	  6 */
	0x41, /* 0x01000001	  6 */
	0x3e, /* 0x00111110	  6 */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
/* */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
	0x7f, /* 0x01111111	  7 */
	0x40, /* 0x01000000	  7 */
	0x40, /* 0x01000000	  7 */
	0x20, /* 0x00100000	  7 */
	0x10, /* 0x00010000	  7 */
	0x08, /* 0x00001000	  7 */
	0x04, /* 0x00000100	  7 */
	0x04, /* 0x00000100	  7 */
	0x02, /* 0x00000010	  7 */
	0x02, /* 0x00000010	  7 */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
/* */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
	0x3e, /* 0x00111110	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x3e, /* 0x00111110	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x3e, /* 0x00111110	  8 */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
/* */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
	0x3e, /* 0x00111110	  9 */
	0x41, /* 0x01000001	  9 */
	0x41, /* 0x01000001	  9 */
	0x41, /* 0x01000001	  9 */
	0x61, /* 0x01100001	  9 */
	0x5e, /* 0x01011110	  9 */
	0x40, /* 0x01000000	  9 */
	0x40, /* 0x01000000	  9 */
	0x20, /* 0x00100000	  9 */
	0x1e, /* 0x00011110	  9 */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
/* */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x08, /* 0x00001000	  : */
	0x1c, /* 0x00011100	  : */
	0x08, /* 0x00001000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x08, /* 0x00001000	  : */
	0x1c, /* 0x00011100	  : */
	0x08, /* 0x00001000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
/* */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x08, /* 0x00001000	  ; */
	0x1c, /* 0x00011100	  ; */
	0x08, /* 0x00001000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x1c, /* 0x00011100	  ; */
	0x0c, /* 0x00001100	  ; */
	0x02, /* 0x00000010	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
/* */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
	0x20, /* 0x00100000	  < */
	0x10, /* 0x00010000	  < */
	0x08, /* 0x00001000	  < */
	0x04, /* 0x00000100	  < */
	0x02, /* 0x00000010	  < */
	0x02, /* 0x00000010	  < */
	0x04, /* 0x00000100	  < */
	0x08, /* 0x00001000	  < */
	0x10, /* 0x00010000	  < */
	0x20, /* 0x00100000	  < */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
/* */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x7f, /* 0x01111111	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x7f, /* 0x01111111	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
/* */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
	0x02, /* 0x00000010	  > */
	0x04, /* 0x00000100	  > */
	0x08, /* 0x00001000	  > */
	0x10, /* 0x00010000	  > */
	0x20, /* 0x00100000	  > */
	0x20, /* 0x00100000	  > */
	0x10, /* 0x00010000	  > */
	0x08, /* 0x00001000	  > */
	0x04, /* 0x00000100	  > */
	0x02, /* 0x00000010	  > */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
/* */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
	0x3e, /* 0x00111110	  ? */
	0x41, /* 0x01000001	  ? */
	0x41, /* 0x01000001	  ? */
	0x40, /* 0x01000000	  ? */
	0x20, /* 0x00100000	  ? */
	0x10, /* 0x00010000	  ? */
	0x08, /* 0x00001000	  ? */
	0x08, /* 0x00001000	  ? */
	0x00, /* 0x00000000	  ? */
	0x08, /* 0x00001000	  ? */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
/* */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
	0x3e, /* 0x00111110	  @ */
	0x41, /* 0x01000001	  @ */
	0x41, /* 0x01000001	  @ */
	0x79, /* 0x01111001	  @ */
	0x45, /* 0x01000101	  @ */
	0x65, /* 0x01100101	  @ */
	0x59, /* 0x01011001	  @ */
	0x01, /* 0x00000001	  @ */
	0x01, /* 0x00000001	  @ */
	0x3e, /* 0x00111110	  @ */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
/* */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
	0x08, /* 0x00001000	  A */
	0x14, /* 0x00010100	  A */
	0x22, /* 0x00100010	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x7f, /* 0x01111111	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
/* */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
	0x3f, /* 0x00111111	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x3e, /* 0x00111110	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x3f, /* 0x00111111	  B */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
/* */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
	0x3e, /* 0x00111110	  C */
	0x41, /* 0x01000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x41, /* 0x01000001	  C */
	0x3e, /* 0x00111110	  C */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
/* */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
	0x3f, /* 0x00111111	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x3f, /* 0x00111111	  D */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
/* */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
	0x7e, /* 0x01111110	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x1e, /* 0x00011110	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x7e, /* 0x01111110	  E */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
/* */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
	0x7e, /* 0x01111110	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x1e, /* 0x00011110	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
/* */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
	0x3e, /* 0x00111110	  G */
	0x41, /* 0x01000001	  G */
	0x01, /* 0x00000001	  G */
	0x01, /* 0x00000001	  G */
	0x01, /* 0x00000001	  G */
	0x71, /* 0x01110001	  G */
	0x41, /* 0x01000001	  G */
	0x41, /* 0x01000001	  G */
	0x41, /* 0x01000001	  G */
	0x3e, /* 0x00111110	  G */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
/* */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x7f, /* 0x01111111	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
/* */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
	0x3e, /* 0x00111110	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x3e, /* 0x00111110	  I */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
/* */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
	0x78, /* 0x01111000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x21, /* 0x00100001	  J */
	0x1e, /* 0x00011110	  J */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
/* */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
	0x41, /* 0x01000001	  K */
	0x21, /* 0x00100001	  K */
	0x11, /* 0x00010001	  K */
	0x09, /* 0x00001001	  K */
	0x07, /* 0x00000111	  K */
	0x05, /* 0x00000101	  K */
	0x09, /* 0x00001001	  K */
	0x11, /* 0x00010001	  K */
	0x21, /* 0x00100001	  K */
	0x41, /* 0x01000001	  K */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
/* */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x7f, /* 0x01111111	  L */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
/* */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x63, /* 0x01100011	  M */
	0x55, /* 0x01010101	  M */
	0x55, /* 0x01010101	  M */
	0x49, /* 0x01001001	  M */
	0x49, /* 0x01001001	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
/* */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x43, /* 0x01000011	  N */
	0x45, /* 0x01000101	  N */
	0x49, /* 0x01001001	  N */
	0x51, /* 0x01010001	  N */
	0x61, /* 0x01100001	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
/* */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
	0x3e, /* 0x00111110	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x3e, /* 0x00111110	  O */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
/* */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
	0x3f, /* 0x00111111	  P */
	0x41, /* 0x01000001	  P */
	0x41, /* 0x01000001	  P */
	0x41, /* 0x01000001	  P */
	0x3f, /* 0x00111111	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
/* */
	0x00, /* 0x00000000	  Q */
	0x00, /* 0x00000000	  Q */
	0x3e, /* 0x00111110	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x49, /* 0x01001001	  Q */
	0x51, /* 0x01010001	  Q */
	0x3e, /* 0x00111110	  Q */
	0x40, /* 0x01000000	  Q */
	0x00, /* 0x00000000	  Q */
	0x00, /* 0x00000000	  Q */
/* */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
	0x3f, /* 0x00111111	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x3f, /* 0x00111111	  R */
	0x09, /* 0x00001001	  R */
	0x11, /* 0x00010001	  R */
	0x21, /* 0x00100001	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
/* */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
	0x3e, /* 0x00111110	  S */
	0x41, /* 0x01000001	  S */
	0x01, /* 0x00000001	  S */
	0x01, /* 0x00000001	  S */
	0x3e, /* 0x00111110	  S */
	0x40, /* 0x01000000	  S */
	0x40, /* 0x01000000	  S */
	0x40, /* 0x01000000	  S */
	0x41, /* 0x01000001	  S */
	0x3e, /* 0x00111110	  S */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
/* */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
	0x7f, /* 0x01111111	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
/* */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x3e, /* 0x00111110	  U */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
/* */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
	0x41, /* 0x01000001	  V */
	0x41, /* 0x01000001	  V */
	0x41, /* 0x01000001	  V */
	0x22, /* 0x00100010	  V */
	0x22, /* 0x00100010	  V */
	0x22, /* 0x00100010	  V */
	0x14, /* 0x00010100	  V */
	0x14, /* 0x00010100	  V */
	0x14, /* 0x00010100	  V */
	0x08, /* 0x00001000	  V */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
/* */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x55, /* 0x01010101	  W */
	0x22, /* 0x00100010	  W */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
/* */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
	0x41, /* 0x01000001	  X */
	0x41, /* 0x01000001	  X */
	0x22, /* 0x00100010	  X */
	0x14, /* 0x00010100	  X */
	0x08, /* 0x00001000	  X */
	0x08, /* 0x00001000	  X */
	0x14, /* 0x00010100	  X */
	0x22, /* 0x00100010	  X */
	0x41, /* 0x01000001	  X */
	0x41, /* 0x01000001	  X */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
/* */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
	0x41, /* 0x01000001	  Y */
	0x41, /* 0x01000001	  Y */
	0x22, /* 0x00100010	  Y */
	0x14, /* 0x00010100	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
/* */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
	0x7f, /* 0x01111111	  Z */
	0x40, /* 0x01000000	  Z */
	0x20, /* 0x00100000	  Z */
	0x10, /* 0x00010000	  Z */
	0x08, /* 0x00001000	  Z */
	0x04, /* 0x00000100	  Z */
	0x02, /* 0x00000010	  Z */
	0x01, /* 0x00000001	  Z */
	0x01, /* 0x00000001	  Z */
	0x7f, /* 0x01111111	  Z */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
/* */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
	0x3c, /* 0x00111100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x3c, /* 0x00111100	  [ */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
/* */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x01, /* 0x00000001	  \ */
	0x02, /* 0x00000010	  \ */
	0x02, /* 0x00000010	  \ */
	0x04, /* 0x00000100	  \ */
	0x08, /* 0x00001000	  \ */
	0x08, /* 0x00001000	  \ */
	0x10, /* 0x00010000	  \ */
	0x20, /* 0x00100000	  \ */
	0x20, /* 0x00100000	  \ */
	0x40, /* 0x01000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
/* */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
	0x1e, /* 0x00011110	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x1e, /* 0x00011110	  ] */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
/* */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x08, /* 0x00001000	  ^ */
	0x14, /* 0x00010100	  ^ */
	0x22, /* 0x00100010	  ^ */
	0x41, /* 0x01000001	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
/* */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x7f, /* 0x01111111	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
/* */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x0e, /* 0x00001110	  ` */
	0x0c, /* 0x00001100	  ` */
	0x10, /* 0x00010000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
/* */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x3e, /* 0x00111110	  a */
	0x40, /* 0x01000000	  a */
	0x40, /* 0x01000000	  a */
	0x7e, /* 0x01111110	  a */
	0x41, /* 0x01000001	  a */
	0x61, /* 0x01100001	  a */
	0x5e, /* 0x01011110	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
/* */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
	0x01, /* 0x00000001	  b */
	0x01, /* 0x00000001	  b */
	0x01, /* 0x00000001	  b */
	0x3d, /* 0x00111101	  b */
	0x43, /* 0x01000011	  b */
	0x41, /* 0x01000001	  b */
	0x41, /* 0x01000001	  b */
	0x41, /* 0x01000001	  b */
	0x43, /* 0x01000011	  b */
	0x3d, /* 0x00111101	  b */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
/* */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x3e, /* 0x00111110	  c */
	0x41, /* 0x01000001	  c */
	0x01, /* 0x00000001	  c */
	0x01, /* 0x00000001	  c */
	0x01, /* 0x00000001	  c */
	0x41, /* 0x01000001	  c */
	0x3e, /* 0x00111110	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
/* */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
	0x40, /* 0x01000000	  d */
	0x40, /* 0x01000000	  d */
	0x40, /* 0x01000000	  d */
	0x5e, /* 0x01011110	  d */
	0x61, /* 0x01100001	  d */
	0x41, /* 0x01000001	  d */
	0x41, /* 0x01000001	  d */
	0x41, /* 0x01000001	  d */
	0x61, /* 0x01100001	  d */
	0x5e, /* 0x01011110	  d */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
/* */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x3e, /* 0x00111110	  e */
	0x41, /* 0x01000001	  e */
	0x41, /* 0x01000001	  e */
	0x7f, /* 0x01111111	  e */
	0x01, /* 0x00000001	  e */
	0x01, /* 0x00000001	  e */
	0x3e, /* 0x00111110	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
/* */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
	0x38, /* 0x00111000	  f */
	0x44, /* 0x01000100	  f */
	0x44, /* 0x01000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x1f, /* 0x00011111	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
/* */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x5e, /* 0x01011110	  g */
	0x21, /* 0x00100001	  g */
	0x21, /* 0x00100001	  g */
	0x21, /* 0x00100001	  g */
	0x1e, /* 0x00011110	  g */
	0x01, /* 0x00000001	  g */
	0x3e, /* 0x00111110	  g */
	0x41, /* 0x01000001	  g */
	0x41, /* 0x01000001	  g */
	0x3e, /* 0x00111110	  g */
/* */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
	0x01, /* 0x00000001	  h */
	0x01, /* 0x00000001	  h */
	0x01, /* 0x00000001	  h */
	0x3d, /* 0x00111101	  h */
	0x43, /* 0x01000011	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
/* */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x08, /* 0x00001000	  i */
	0x00, /* 0x00000000	  i */
	0x0c, /* 0x00001100	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x3e, /* 0x00111110	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
/* */
	0x00, /* 0x00000000	  j */
	0x00, /* 0x00000000	  j */
	0x00, /* 0x00000000	  j */
	0x20, /* 0x00100000	  j */
	0x00, /* 0x00000000	  j */
	0x38, /* 0x00111000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x21, /* 0x00100001	  j */
	0x21, /* 0x00100001	  j */
	0x21, /* 0x00100001	  j */
	0x1e, /* 0x00011110	  j */
/* */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
	0x01, /* 0x00000001	  k */
	0x01, /* 0x00000001	  k */
	0x01, /* 0x00000001	  k */
	0x41, /* 0x01000001	  k */
	0x31, /* 0x00110001	  k */
	0x0d, /* 0x00001101	  k */
	0x03, /* 0x00000011	  k */
	0x0d, /* 0x00001101	  k */
	0x31, /* 0x00110001	  k */
	0x41, /* 0x01000001	  k */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
/* */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
	0x0c, /* 0x00001100	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x3e, /* 0x00111110	  l */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
/* */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x37, /* 0x00110111	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x41, /* 0x01000001	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
/* */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x3d, /* 0x00111101	  n */
	0x43, /* 0x01000011	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
/* */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x3e, /* 0x00111110	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x3e, /* 0x00111110	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
/* */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x3d, /* 0x00111101	  p */
	0x43, /* 0x01000011	  p */
	0x41, /* 0x01000001	  p */
	0x41, /* 0x01000001	  p */
	0x41, /* 0x01000001	  p */
	0x43, /* 0x01000011	  p */
	0x3d, /* 0x00111101	  p */
	0x01, /* 0x00000001	  p */
	0x01, /* 0x00000001	  p */
	0x01, /* 0x00000001	  p */
/* */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x5e, /* 0x01011110	  q */
	0x61, /* 0x01100001	  q */
	0x41, /* 0x01000001	  q */
	0x41, /* 0x01000001	  q */
	0x41, /* 0x01000001	  q */
	0x61, /* 0x01100001	  q */
	0x5e, /* 0x01011110	  q */
	0x40, /* 0x01000000	  q */
	0x40, /* 0x01000000	  q */
	0x40, /* 0x01000000	  q */
/* */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x39, /* 0x00111001	  r */
	0x46, /* 0x01000110	  r */
	0x42, /* 0x01000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
/* */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x3e, /* 0x00111110	  s */
	0x41, /* 0x01000001	  s */
	0x01, /* 0x00000001	  s */
	0x3e, /* 0x00111110	  s */
	0x40, /* 0x01000000	  s */
	0x41, /* 0x01000001	  s */
	0x3e, /* 0x00111110	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
/* */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x3f, /* 0x00111111	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x44, /* 0x01000100	  t */
	0x38, /* 0x00111000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
/* */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x5e, /* 0x01011110	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
/* */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x41, /* 0x01000001	  v */
	0x41, /* 0x01000001	  v */
	0x22, /* 0x00100010	  v */
	0x22, /* 0x00100010	  v */
	0x14, /* 0x00010100	  v */
	0x14, /* 0x00010100	  v */
	0x08, /* 0x00001000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
/* */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x41, /* 0x01000001	  w */
	0x41, /* 0x01000001	  w */
	0x49, /* 0x01001001	  w */
	0x49, /* 0x01001001	  w */
	0x49, /* 0x01001001	  w */
	0x55, /* 0x01010101	  w */
	0x22, /* 0x00100010	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
/* */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x41, /* 0x01000001	  x */
	0x22, /* 0x00100010	  x */
	0x14, /* 0x00010100	  x */
	0x08, /* 0x00001000	  x */
	0x14, /* 0x00010100	  x */
	0x22, /* 0x00100010	  x */
	0x41, /* 0x01000001	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
/* */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x31, /* 0x00110001	  y */
	0x2e, /* 0x00101110	  y */
	0x20, /* 0x00100000	  y */
	0x21, /* 0x00100001	  y */
	0x1e, /* 0x00011110	  y */
/* */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x7f, /* 0x01111111	  z */
	0x20, /* 0x00100000	  z */
	0x10, /* 0x00010000	  z */
	0x08, /* 0x00001000	  z */
	0x04, /* 0x00000100	  z */
	0x02, /* 0x00000010	  z */
	0x7f, /* 0x01111111	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
/* */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
	0x70, /* 0x01110000	  { */
	0x08, /* 0x00001000	  { */
	0x08, /* 0x00001000	  { */
	0x10, /* 0x00010000	  { */
	0x0c, /* 0x00001100	  { */
	0x0c, /* 0x00001100	  { */
	0x10, /* 0x00010000	  { */
	0x08, /* 0x00001000	  { */
	0x08, /* 0x00001000	  { */
	0x70, /* 0x01110000	  { */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
/* */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
/* */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
	0x07, /* 0x00000111	  } */
	0x08, /* 0x00001000	  } */
	0x08, /* 0x00001000	  } */
	0x04, /* 0x00000100	  } */
	0x18, /* 0x00011000	  } */
	0x18, /* 0x00011000	  } */
	0x04, /* 0x00000100	  } */
	0x08, /* 0x00001000	  } */
	0x08, /* 0x00001000	  } */
	0x07, /* 0x00000111	  } */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
/* */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x46, /* 0x01000110	  ~ */
	0x49, /* 0x01001001	  ~ */
	0x31, /* 0x00110001	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
/* */
/* ascii0241 */
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x10,
	0x10,
	0x10,
	0x10,
	0x10,
	0x10,
	0x10,
	0x10,
	0x00,
	0x00,
/* ascii0242 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x10,
	0x10,
	0x3c,
	0x42,
	0x02,
	0x02,
	0x42,
	0x3c,
	0x10,
	0x10,
	0x00,
/* ascii0243 */
	0x00,
	0x00,
	0x70,
	0x88,
	0x08,
	0x08,
	0x08,
	0x3e,
	0x08,
	0x08,
	0x08,
	0xdc,
	0x76,
	0x00,
	0x00,
/* ascii0244 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0245 */
	0x00,
	0x00,
	0x00,
	0x44,
	0x44,
	0x44,
	0x28,
	0x10,
	0x7c,
	0x10,
	0x7c,
	0x10,
	0x10,
	0x00,
	0x00,
/* ascii0246 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0247 */
	0x00,
	0x1c,
	0x22,
	0x02,
	0x04,
	0x1c,
	0x22,
	0x22,
	0x1c,
	0x10,
	0x20,
	0x22,
	0x1c,
	0x00,
	0x00,
/* ascii0250 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x82,
	0x44,
	0x38,
	0x44,
	0x44,
	0x44,
	0x38,
	0x44,
	0x82,
	0x00,
	0x00,
/* ascii0251 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x7c,
	0x82,
	0xb2,
	0x8a,
	0x8a,
	0xb2,
	0x82,
	0x7c,
	0x00,
	0x00,
/* ascii0252 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x40,
	0x7c,
	0x42,
	0x42,
	0x7c,
	0x00,
	0x7c,
	0x00,
	0x00,
	0x00,
	0x00,
/* ascii0253 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x48,
	0x24,
	0x12,
	0x09,
	0x12,
	0x24,
	0x48,
	0x00,
	0x00,
	0x00,
/* ascii0254 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0255 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0256 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0257 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0260 */
	0x00,
	0x18,
	0x24,
	0x24,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
/* ascii0261 */
	0x00,
	0x00,
	0x00,
	0x08,
	0x08,
	0x08,
	0x3e,
	0x08,
	0x08,
	0x08,
	0x00,
	0x3e,
	0x00,
	0x00,
	0x00,
/* ascii0262 */
	0x00,
	0x00,
	0x0c,
	0x12,
	0x08,
	0x04,
	0x02,
	0x1e,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
/* ascii0263 */
	0x00,
	0x00,
	0x1e,
	0x10,
	0x08,
	0x10,
	0x12,
	0x0c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
/* ascii0264 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0265 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x44,
	0x44,
	0x44,
	0x44,
	0x44,
	0x7c,
	0xc2,
	0x01,
/* ascii0266 */
	0x00,
	0x00,
	0x00,
	0x7c,
	0x4e,
	0x4e,
	0x4e,
	0x4e,
	0x7c,
	0x48,
	0x48,
	0x48,
	0x48,
	0x00,
	0x00,
/* ascii0267 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x18,
	0x18,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
/* ascii0270 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0271 */
	0x00,
	0x00,
	0x08,
	0x0c,
	0x08,
	0x08,
	0x08,
	0x1c,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
/* ascii0272 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x3c,
	0x00,
	0x00,
	0x00,
	0x00,
/* ascii0273 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x12,
	0x24,
	0x48,
	0x90,
	0x48,
	0x24,
	0x12,
	0x00,
	0x00,
/* ascii0274 */
	0x00,
	0x04,
	0x06,
	0x04,
	0x04,
	0x4e,
	0x20,
	0x10,
	0x48,
	0x64,
	0x52,
	0xf8,
	0x40,
	0x40,
	0x00,
/* ascii0275 */
	0x00,
	0x04,
	0x06,
	0x04,
	0x04,
	0x4e,
	0x20,
	0x10,
	0x08,
	0x74,
	0x82,
	0x60,
	0x10,
	0xf0,
	0x00,
/* ascii0276 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0277 */
	0x00,
	0x00,
	0x00,
	0x10,
	0x00,
	0x10,
	0x10,
	0x08,
	0x04,
	0x02,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0300 */
	0x00,
	0x08,
	0x10,
	0x20,
	0x18,
	0x24,
	0x42,
	0x42,
	0x42,
	0x7e,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0301 */
	0x00,
	0x10,
	0x08,
	0x04,
	0x18,
	0x24,
	0x42,
	0x42,
	0x42,
	0x7e,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0302 */
	0x00,
	0x18,
	0x24,
	0x42,
	0x18,
	0x24,
	0x42,
	0x42,
	0x42,
	0x7e,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0303 */
	0x00,
	0x4c,
	0x32,
	0x00,
	0x18,
	0x24,
	0x42,
	0x42,
	0x42,
	0x7e,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0304 */
	0x00,
	0x00,
	0x66,
	0x00,
	0x18,
	0x24,
	0x42,
	0x42,
	0x42,
	0x7e,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0305 */
	0x18,
	0x24,
	0x18,
	0x00,
	0x18,
	0x24,
	0x42,
	0x42,
	0x42,
	0x7e,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0306 */
	0x00,
	0x00,
	0x00,
	0x00,
	0xf8,
	0x14,
	0x12,
	0x12,
	0x7e,
	0x12,
	0x12,
	0x12,
	0xf2,
	0x00,
	0x00,
/* ascii0307 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x02,
	0x02,
	0x02,
	0x02,
	0x02,
	0x42,
	0x3c,
	0x10,
	0x0c,
/* ascii0310 */
	0x08,
	0x10,
	0x20,
	0x00,
	0x7e,
	0x02,
	0x02,
	0x02,
	0x1e,
	0x02,
	0x02,
	0x02,
	0x7e,
	0x00,
	0x00,
/* ascii0311 */
	0x10,
	0x08,
	0x04,
	0x00,
	0x7e,
	0x02,
	0x02,
	0x02,
	0x1e,
	0x02,
	0x02,
	0x02,
	0x7e,
	0x00,
	0x00,
/* ascii0312 */
	0x18,
	0x24,
	0x42,
	0x00,
	0x7e,
	0x02,
	0x02,
	0x02,
	0x1e,
	0x02,
	0x02,
	0x02,
	0x7e,
	0x00,
	0x00,
/* ascii0313 */
	0x00,
	0x66,
	0x00,
	0x00,
	0x7e,
	0x02,
	0x02,
	0x02,
	0x1e,
	0x02,
	0x02,
	0x02,
	0x7e,
	0x00,
	0x00,
/* ascii0314 */
	0x08,
	0x10,
	0x20,
	0x00,
	0x3c,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0315 */
	0x40,
	0x20,
	0x10,
	0x00,
	0x3c,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0316 */
	0x18,
	0x24,
	0x42,
	0x00,
	0x3c,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0317 */
	0x00,
	0x66,
	0x00,
	0x00,
	0x3c,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0320 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0321 */
	0x00,
	0x4c,
	0x32,
	0x00,
	0x42,
	0x42,
	0x46,
	0x4a,
	0x52,
	0x62,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0322 */
	0x08,
	0x10,
	0x20,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0323 */
	0x10,
	0x08,
	0x04,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0324 */
	0x18,
	0x24,
	0x42,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0325 */
	0x00,
	0x4c,
	0x32,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0326 */
	0x00,
	0x66,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0327 */
	0x00,
	0x00,
	0x00,
	0x00,
	0xfc,
	0x12,
	0x12,
	0x12,
	0x72,
	0x12,
	0x12,
	0x12,
	0xfc,
	0x00,
	0x00,
/* ascii0330 */
	0x00,
	0x00,
	0x00,
	0x00,
	0xbc,
	0x42,
	0x62,
	0x52,
	0x52,
	0x4a,
	0x46,
	0x42,
	0x3d,
	0x00,
	0x00,
/* ascii0331 */
	0x00,
	0x04,
	0x08,
	0x10,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0332 */
	0x00,
	0x20,
	0x10,
	0x08,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0333 */
	0x00,
	0x18,
	0x24,
	0x42,
	0x00,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0334 */
	0x00,
	0x66,
	0x00,
	0x00,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0335 */
	0x00,
	0xc6,
	0x00,
	0x00,
	0x82,
	0x82,
	0x44,
	0x28,
	0x10,
	0x10,
	0x10,
	0x10,
	0x10,
	0x00,
	0x00,
/* ascii0336 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0337 */
	0x00,
	0x00,
	0x70,
	0x88,
	0x84,
	0x84,
	0x44,
	0x74,
	0x84,
	0x84,
	0x84,
	0x94,
	0x74,
	0x04,
	0x02,
/* ascii0340 */
	0x00,
	0x00,
	0x00,
	0x08,
	0x10,
	0x20,
	0x00,
	0x3c,
	0x40,
	0x7c,
	0x42,
	0x42,
	0x7c,
	0x00,
	0x00,
/* ascii0341 */
	0x00,
	0x00,
	0x00,
	0x10,
	0x08,
	0x04,
	0x00,
	0x3c,
	0x40,
	0x7c,
	0x42,
	0x42,
	0x7c,
	0x00,
	0x00,
/* ascii0342 */
	0x00,
	0x00,
	0x00,
	0x18,
	0x24,
	0x42,
	0x00,
	0x3c,
	0x40,
	0x7c,
	0x42,
	0x42,
	0x7c,
	0x00,
	0x00,
/* ascii0343 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x4c,
	0x32,
	0x00,
	0x3c,
	0x40,
	0x7c,
	0x42,
	0x42,
	0x7c,
	0x00,
	0x00,
/* ascii0344 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x66,
	0x00,
	0x00,
	0x3c,
	0x40,
	0x7c,
	0x42,
	0x42,
	0x7c,
	0x00,
	0x00,
/* ascii0345 */
	0x00,
	0x00,
	0x00,
	0x18,
	0x24,
	0x18,
	0x00,
	0x3c,
	0x40,
	0x7c,
	0x42,
	0x42,
	0x7c,
	0x00,
	0x00,
/* ascii0346 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x6e,
	0x90,
	0xfc,
	0x12,
	0x12,
	0xec,
	0x00,
	0x00,
/* ascii0347 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x02,
	0x02,
	0x42,
	0x3c,
	0x10,
	0x0c,
/* ascii0350 */
	0x00,
	0x00,
	0x00,
	0x08,
	0x10,
	0x20,
	0x00,
	0x3c,
	0x42,
	0x7e,
	0x02,
	0x02,
	0x3c,
	0x00,
	0x00,
/* ascii0351 */
	0x00,
	0x00,
	0x00,
	0x10,
	0x08,
	0x04,
	0x00,
	0x3c,
	0x42,
	0x7e,
	0x02,
	0x02,
	0x3c,
	0x00,
	0x00,
/* ascii0352 */
	0x00,
	0x00,
	0x00,
	0x18,
	0x24,
	0x42,
	0x00,
	0x3c,
	0x42,
	0x7e,
	0x02,
	0x02,
	0x3c,
	0x00,
	0x00,
/* ascii0353 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x66,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x7e,
	0x02,
	0x02,
	0x3c,
	0x00,
	0x00,
/* ascii0354 */
	0x00,
	0x00,
	0x00,
	0x04,
	0x08,
	0x10,
	0x00,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0355 */
	0x00,
	0x00,
	0x00,
	0x10,
	0x08,
	0x04,
	0x00,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0356 */
	0x00,
	0x00,
	0x00,
	0x18,
	0x24,
	0x42,
	0x00,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0357 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x66,
	0x00,
	0x00,
	0x08,
	0x08,
	0x08,
	0x08,
	0x08,
	0x3c,
	0x00,
	0x00,
/* ascii0360 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0361 */
	0x00,
	0x00,
	0x00,
	0x4c,
	0x32,
	0x00,
	0x00,
	0x3e,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x00,
	0x00,
/* ascii0362 */
	0x00,
	0x00,
	0x00,
	0x08,
	0x10,
	0x20,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0363 */
	0x00,
	0x00,
	0x00,
	0x10,
	0x08,
	0x04,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0364 */
	0x00,
	0x00,
	0x00,
	0x18,
	0x24,
	0x42,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0365 */
	0x00,
	0x00,
	0x00,
	0x4c,
	0x32,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0366 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x66,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0367 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x6c,
	0x92,
	0xf2,
	0x12,
	0x12,
	0xec,
	0x00,
	0x00,
/* ascii0370 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0x00,
	0xbc,
	0x62,
	0x52,
	0x4a,
	0x46,
	0x3c,
	0x02,
	0x00,
/* ascii0371 */
	0x00,
	0x00,
	0x00,
	0x04,
	0x08,
	0x10,
	0x00,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0372 */
	0x00,
	0x00,
	0x00,
	0x20,
	0x10,
	0x08,
	0x00,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0373 */
	0x00,
	0x00,
	0x00,
	0x18,
	0x24,
	0x42,
	0x00,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0374 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x66,
	0x00,
	0x00,
	0x42,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x00,
	0x00,
/* ascii0375 */
	0x00,
	0x00,
	0x00,
	0x00,
	0x66,
	0x00,
	0x00,
	0x42,
	0x42,
	0x42,
	0x42,
	0x3c,
	0x40,
	0x40,
	0x3e,
/* ascii0376 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
/* ascii0377 */
	0x00,
	0x00,
	0x00,
	0x3c,
	0x42,
	0x42,
	0x02,
	0x04,
	0x08,
	0x10,
	0x10,
	0x00,
	0x10,
	0x00,
	0x00,
};
