/*	$NetBSD: superiovar.h,v 1.3 2002/08/30 10:57:06 scw Exp $	*/

/*
 * Copyright 2002 Wasabi Systems, Inc.
 * All rights reserved.
 *
 * Written by Steve C. Woodford for Wasabi Systems, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed for the NetBSD Project by
 *      Wasabi Systems, Inc.
 * 4. The name of Wasabi Systems, Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY WASABI SYSTEMS, INC. ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL WASABI SYSTEMS, INC
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _EVBSH5_SUPERIOVAR_H
#define _EVBSH5_SUPERIOVAR_H

/*
 * This is only compiled in when the com(4) is specified in the kernel
 * config file where there is a chance that com0 will be used as the
 * system console.
 *
 * It is passed a tag which can be used to access the Super IO's
 * registers at their standard system FPGA offset, the com port to be
 * used as console, and pointers to a tag and an offset suitable for
 * passing directly to comcnattach().
 */
extern int superio_console_tag(bus_space_tag_t, int,
	    bus_space_tag_t *, bus_addr_t *);

/*
 * The following is only used to enable the wm(4) driver to be attached.
 */
struct superio_attach_args {
	const char *saa_name;
	bus_space_tag_t saa_bust;
	bus_addr_t saa_offset;
	int saa_irq;

	bus_addr_t _saa_base;
};

#endif /* _EVBSH5_SUPERIOVAR_H */
