use utf8;
package Schema::TPathSync::Result::Comment;

=head1 NAME

Schema::TPathSync::Result::Comment

=cut

use Moose;
use MooseX::NonMoose;
use MooseX::MarkAsMethods autoclean => 1;
extends 'DBIx::Class::Core';


__PACKAGE__->load_components();
__PACKAGE__->table("comments");
__PACKAGE__->add_columns(
    "id",
    {
        data_type         => "INTEGER",
        is_nullable       => 0,
        size              => undef,
        is_auto_increment => 1
    },
    "page_id",
    { data_type => "INTEGER", is_nullable => 0, size => undef },
    "body",
    { data_type => "TEXT", is_nullable => 0, size => undef },
);

__PACKAGE__->set_primary_key("id");

__PACKAGE__->belongs_to(
    "page",
    "Schema::TPathSync::Result::Page",
    { id => "page_id" }
);


sub insert {
    my $self = shift;

    #print "Add a new comment\n";
    my $return = $self->next::method( @_ );

    my $tp = $self->result_source->schema->treepath;
    my $obj = $tp->_row_to_obj($self);
    $tp->add($obj);
    return $return;
}

sub update {
    my $self = shift;

    print "Update a comment\n";

    return $self->next::method( @_ );
}

sub delete {
    my $self = shift;

    print "Del a comment\n";

    return $self->next::method( @_ );
  }

=head1 NAME

Schema::TPathSync::Result::Comment - store comments

=head1 METHODS


=head1 AUTHOR

Daniel Brosseau <dab@catapulse.org>

=head1 LICENSE

This library is free software. You can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
