use Unicode::Collate::CJK::Zhuyin;
+{
   locale_version => 1.31,
   overrideCJK => \&Unicode::Collate::CJK::Zhuyin::weightZhuyin,
   entry => <<'ENTRY', # for DUCET v13.0.0
02C9      ; [.0000.0199.0002] # MODIFIER LETTER MACRON
02CA      ; [.019A.0020.0002] # MODIFIER LETTER ACUTE ACCENT
02C7      ; [.019B.0020.0002] # CARON
02CB      ; [.019C.0020.0002] # MODIFIER LETTER GRAVE ACCENT
02D9      ; [.019D.0020.0002] # DOT ABOVE
02EA      ; [.019E.0020.0002] # MODIFIER LETTER YIN DEPARTING TONE MARK
02EB      ; [.019F.0020.0002] # MODIFIER LETTER YANG DEPARTING TONE MARK
0101      ; [.1FA2.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.1FA2.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.1FA2.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.1FA2.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.1FA2.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.1FA2.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.1FA2.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.1FA2.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.1FA2.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.1FA2.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.1FA2.001E.0002] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.1FA2.001E.0002] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.1FA2.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.1FA2.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.1FA2.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.1FA2.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.1FA2.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.1FA2.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.1FA2.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.1FA2.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.2007.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.2007.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.2007.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.2007.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.2007.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.2007.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.2007.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.2007.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.2007.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.2007.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.2007.001E.0002] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.2007.001E.0002] # LATIN SMALL LETTER E WITH CARON
011A      ; [.2007.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.2007.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.2007.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.2007.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.2007.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.2007.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.2007.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.2007.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.2007.0021.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.2007.0021.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.2007.0021.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.2007.0021.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.2007.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.2007.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.2007.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.2007.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.2007.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.2007.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.2007.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.2007.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.2007.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.2007.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.2007.0023.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.2007.0023.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.2007.0023.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.2007.0023.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.2007.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.2007.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.2007.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.2007.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.2007.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.2007.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.2007.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.2007.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.2007.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.2007.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.2007.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.2007.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.2007.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.2007.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.2007.0025.0002][.0000.002D.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.2007.0025.0008][.0000.002D.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.2007.0025.0002][.0000.003B.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.2007.0025.0008][.0000.003B.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.2007.0025.0002][.0000.0042.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.2007.0025.0008][.0000.0042.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.2090.001C.0002] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.2090.001C.0002] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.2090.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.2090.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.2090.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.2090.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.2090.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.2090.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.2090.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.2090.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.2090.001E.0002] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.2090.001E.0002] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.2090.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.2090.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.2090.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.2090.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.2090.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.2090.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.2090.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.2090.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.2109.001C.0002] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.2109.001C.0008] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.2109.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.2109.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.2109.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.2109.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.2109.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.2109.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.2109.001E.0002] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.2109.001E.0008] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.2109.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.2109.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.2109.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.2109.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.2118.001C.0002] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.2118.001C.0008] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.2118.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.2118.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.2118.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.2118.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.2118.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.2118.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.2118.001E.0002] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.2118.001E.0002] # LATIN SMALL LETTER N WITH CARON
0147      ; [.2118.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.2118.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.2118.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.2118.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.2118.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.2118.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.2118.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.2118.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.213C.001C.0002] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.213C.001C.0002] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.213C.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.213C.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.213C.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.213C.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.213C.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.213C.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.213C.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.213C.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.213C.001E.0002] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.213C.001E.0002] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.213C.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.213C.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.213C.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.213C.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.213C.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.213C.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.213C.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.213C.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.2217.001C.0002] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.2217.001C.0002] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.2217.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.2217.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.2217.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.2217.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.2217.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.2217.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.2217.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.2217.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.2217.001E.0002] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.2217.001E.0002] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.2217.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.2217.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.2217.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.2217.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.2217.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.2217.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.2217.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.2217.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.2217.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.2217.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.2217.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.2217.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.2217.0021.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.2217.0021.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.2217.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.2217.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.2217.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.2217.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.2217.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.2217.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.2217.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.2217.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.2217.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.2217.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.2217.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.2217.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.2217.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.2217.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.2217.0023.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.2217.0023.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.2217.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.2217.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.2217.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.2217.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.2217.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.2217.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.2217.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.2217.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.2217.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.2217.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.2217.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.2217.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.2217.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.2217.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
FDD0 3105 ; [.8000.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER B>
2E8A      ; [.80B5.0020.0002] # CJK RADICAL DIVINATION
FDD0 3106 ; [.83B1.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER P>
FDD0 3107 ; [.8626.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER M>
FDD0 3108 ; [.897F.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER F>
2ECF      ; [.8BC0.0020.0002] # CJK RADICAL CITY
2ED6      ; [.8BC1.0020.0002] # CJK RADICAL MOUND TWO
FDD0 3109 ; [.8C0D.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER D>
2E88      ; [.8C86.0020.0002] # CJK RADICAL KNIFE ONE
FDD0 310A ; [.901F.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER T>
FDD0 310B ; [.93D9.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER N>
2EA7      ; [.9525.0020.0002] # CJK RADICAL COW
FDD0 310C ; [.95D9.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER L>
3007      ; [.9A41.0020.0002] # IDEOGRAPHIC NUMBER ZERO
FDD0 310D ; [.9C5F.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER G>
2EE3      ; [.9E0A.0020.0002] # CJK RADICAL BONE
FDD0 310E ; [.9FD2.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER K>
FDD0 310F ; [.A223.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER H>
FDD0 3110 ; [.A697.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER J>
2E95      ; [.A762.0020.0002] # CJK RADICAL SNOUT TWO
2E86      ; [.AD18.0020.0002] # CJK RADICAL BOX
FDD0 3111 ; [.AD38.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER Q>
FDD0 3112 ; [.B164.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER X>
2E8C      ; [.B383.0020.0002] # CJK RADICAL SMALL ONE
2E8D      ; [.B384.0020.0002] # CJK RADICAL SMALL TWO
FDD0 3113 ; [.B6E9.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER ZH>
2EA5      ; [.B8AC.0020.0002] # CJK RADICAL PAW TWO
FDD0 3114 ; [.BBAC.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER CH>
2ECC      ; [.BE9D.0020.0002] # CJK RADICAL SIMPLIFIED WALK
2ECD      ; [.BE9E.0020.0002] # CJK RADICAL WALK ONE
FDD0 3115 ; [.BF5A.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER SH>
2EAC      ; [.BFBC.0020.0002] # CJK RADICAL SPIRIT ONE
2EAE      ; [.BFC1.0020.0002] # CJK RADICAL BAMBOO
FDD0 3116 ; [.C2A2.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER R>
2E9C      ; [.C2A3.0020.0002] # CJK RADICAL SUN
2EBC      ; [.C2D3.0020.0002] # CJK RADICAL MEAT
2EB6      ; [.C311.0020.0002] # CJK RADICAL SHEEP
FDD0 3117 ; [.C402.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER Z>
FDD0 3118 ; [.C630.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER C>
2EBE      ; [.C6CA.0020.0002] # CJK RADICAL GRASS ONE
FDD0 3119 ; [.C7F6.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER S>
FDD0 311A ; [.CA13.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER A>
FDD0 311B ; [.CA19.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER O>
FDD0 311C ; [.CA1E.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER E>
FDD0 311E ; [.CAA0.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER AI>
FDD0 311F ; [.CAE8.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER EI>
FDD0 3120 ; [.CAEB.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER AU>
FDD0 3121 ; [.CB2E.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER OU>
FDD0 3122 ; [.CB51.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER AN>
FDD0 3123 ; [.CB8B.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER EN>
FDD0 3124 ; [.CB94.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER ANG>
FDD0 3125 ; [.CBA0.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER ENG>
FDD0 3126 ; [.CBA2.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER ER>
FDD0 3127 ; [.CBDB.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER I>
2E84      ; [.CDB5.0020.0002] # CJK RADICAL SECOND THREE
2E80      ; [.CEDF.0020.0002] # CJK RADICAL REPEAT
FDD0 3128 ; [.D16F.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER U>
FDD0 3129 ; [.D403.0020.0002] # <noncharacter-FDD0, BOPOMOFO LETTER IU>
2ED7      ; [.D47E.0020.0002] # CJK RADICAL RAIN
2E9D      ; [.D53B.0020.0002] # CJK RADICAL MOON
3220      ; [*0328.0020.0004][.CBDC.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH ONE
3226      ; [*0328.0020.0004][.AD39.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SEVEN
3222      ; [*0328.0020.0004][.C8DF.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH THREE
3228      ; [*0328.0020.0004][.A95D.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH NINE
3221      ; [*0328.0020.0004][.CBCD.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH TWO
3224      ; [*0328.0020.0004][.D1A9.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FIVE
3239      ; [*0328.0020.0004][.8C57.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH REPRESENT
323D      ; [*0328.0020.0004][.ADC1.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH ENTERPRISE
3241      ; [*0328.0020.0004][.B3A8.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH REST
3227      ; [*0328.0020.0004][.8001.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH EIGHT
3225      ; [*0328.0020.0004][.9953.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SIX
3238      ; [*0328.0020.0004][.969E.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH LABOR
3229      ; [*0328.0020.0004][.BF85.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH TEN
323F      ; [*0328.0020.0004][.B2BC.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH ALLIANCE
3234      ; [*0328.0020.0004][.892A.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH NAME
323A      ; [*0328.0020.0004][.A3B5.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH CALL
3223      ; [*0328.0020.0004][.C82E.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FOUR
322F      ; [*0328.0020.0004][.92EA.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH EARTH
323B      ; [*0328.0020.0004][.B5F0.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH STUDY
3230      ; [*0328.0020.0004][.C2A4.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SUN
322A      ; [*0328.0020.0004][.D53C.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH MOON
3232      ; [*0328.0020.0004][.CEC7.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH HAVE
322D      ; [*0328.0020.0004][.895F.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH WOOD
3231      ; [*0328.0020.0004][.BA36.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH STOCK
322C      ; [*0328.0020.0004][.C26E.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH WATER
322B      ; [*0328.0020.0004][.A48C.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FIRE
3235      ; [*0328.0020.0004][.9060.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SPECIAL
323C      ; [*0328.0020.0004][.A9B3.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SUPERVISE
3233      ; [*0328.0020.0004][.C05E.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SOCIETY
3237      ; [*0328.0020.0004][.BA90.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH CONGRATULATION
3240      ; [*0328.0020.0004][.A78C.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FESTIVAL
3242      ; [*0328.0020.0004][.C457.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH SELF
3243      ; [*0328.0020.0004][.B766.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH REACH
3236      ; [*0328.0020.0004][.C69F.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH FINANCIAL
323E      ; [*0328.0020.0004][.C421.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH RESOURCE
322E      ; [*0328.0020.0004][.AA72.0020.0004][*0329.0020.0004] # PARENTHESIZED IDEOGRAPH METAL
3358      ; [.1F98.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
33E9      ; [.1F99.0020.0004][.1F98.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
32C9      ; [.1F99.0020.0004][.1F98.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
3362      ; [.1F99.0020.0004][.1F98.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
33EA      ; [.1F99.0020.0004][.1F99.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
32CA      ; [.1F99.0020.0004][.1F99.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
3363      ; [.1F99.0020.0004][.1F99.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
33EB      ; [.1F99.0020.0004][.1F9A.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
32CB      ; [.1F99.0020.0004][.1F9A.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
3364      ; [.1F99.0020.0004][.1F9A.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
33EC      ; [.1F99.0020.0004][.1F9B.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
3365      ; [.1F99.0020.0004][.1F9B.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
33ED      ; [.1F99.0020.0004][.1F9C.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
3366      ; [.1F99.0020.0004][.1F9C.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
33EE      ; [.1F99.0020.0004][.1F9D.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
3367      ; [.1F99.0020.0004][.1F9D.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
33EF      ; [.1F99.0020.0004][.1F9E.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
3368      ; [.1F99.0020.0004][.1F9E.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
33F0      ; [.1F99.0020.0004][.1F9F.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
3369      ; [.1F99.0020.0004][.1F9F.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
33F1      ; [.1F99.0020.0004][.1FA0.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
336A      ; [.1F99.0020.0004][.1FA0.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
33F2      ; [.1F99.0020.0004][.1FA1.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
336B      ; [.1F99.0020.0004][.1FA1.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
33E0      ; [.1F99.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
32C0      ; [.1F99.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
3359      ; [.1F99.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
33F3      ; [.1F9A.0020.0004][.1F98.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
336C      ; [.1F9A.0020.0004][.1F98.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
33F4      ; [.1F9A.0020.0004][.1F99.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
336D      ; [.1F9A.0020.0004][.1F99.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
33F5      ; [.1F9A.0020.0004][.1F9A.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
336E      ; [.1F9A.0020.0004][.1F9A.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
33F6      ; [.1F9A.0020.0004][.1F9B.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
336F      ; [.1F9A.0020.0004][.1F9B.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
33F7      ; [.1F9A.0020.0004][.1F9C.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
3370      ; [.1F9A.0020.0004][.1F9C.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
33F8      ; [.1F9A.0020.0004][.1F9D.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
33F9      ; [.1F9A.0020.0004][.1F9E.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
33FA      ; [.1F9A.0020.0004][.1F9F.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
33FB      ; [.1F9A.0020.0004][.1FA0.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
33FC      ; [.1F9A.0020.0004][.1FA1.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
33E1      ; [.1F9A.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
32C1      ; [.1F9A.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
335A      ; [.1F9A.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
33FD      ; [.1F9B.0020.0004][.1F98.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
33FE      ; [.1F9B.0020.0004][.1F99.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
33E2      ; [.1F9B.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
32C2      ; [.1F9B.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
335B      ; [.1F9B.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
33E3      ; [.1F9C.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
32C3      ; [.1F9C.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
335C      ; [.1F9C.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
33E4      ; [.1F9D.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
32C4      ; [.1F9D.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
335D      ; [.1F9D.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
33E5      ; [.1F9E.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
32C5      ; [.1F9E.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
335E      ; [.1F9E.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
33E6      ; [.1F9F.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
32C6      ; [.1F9F.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
335F      ; [.1F9F.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
33E7      ; [.1FA0.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
32C7      ; [.1FA0.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
3360      ; [.1FA0.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
33E8      ; [.1FA1.0020.0004][.C2A4.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
32C8      ; [.1FA1.0020.0004][.D53C.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
3361      ; [.1FA1.0020.0004][.8E99.0020.0004] # IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
1F241     ; [*038A.0020.0004][.C8DF.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E09
1F242     ; [*038A.0020.0004][.CBCD.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-4E8C
1F247     ; [*038A.0020.0004][.C1CC.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-52DD
1F243     ; [*038A.0020.0004][.CB52.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-5B89
1F245     ; [*038A.0020.0004][.8C38.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6253
1F248     ; [*038A.0020.0004][.80CD.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
1F240     ; [*038A.0020.0004][.819A.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C
1F244     ; [*038A.0020.0004][.8E99.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-70B9
1F246     ; [*038A.0020.0004][.8CA9.0020.0004][*038B.0020.0004] # TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-76D7
2F00      ; [.CBDC.0020.0004] # KANGXI RADICAL ONE
3192      ; [.CBDC.0020.0014] # IDEOGRAPHIC ANNOTATION ONE MARK
3280      ; [.CBDC.0020.0006] # CIRCLED IDEOGRAPH ONE
1F229     ; [.CBDC.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E00
319C      ; [.8EC1.0020.0014] # IDEOGRAPHIC ANNOTATION FOURTH MARK
3286      ; [.AD39.0020.0006] # CIRCLED IDEOGRAPH SEVEN
3194      ; [.C8DF.0020.0014] # IDEOGRAPHIC ANNOTATION THREE MARK
3282      ; [.C8DF.0020.0006] # CIRCLED IDEOGRAPH THREE
1F22A     ; [.C8DF.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E09
3196      ; [.C19C.0020.0014] # IDEOGRAPHIC ANNOTATION TOP MARK
32A4      ; [.C19C.0020.0006] # CIRCLED IDEOGRAPH HIGH
3198      ; [.B2A0.0020.0014] # IDEOGRAPHIC ANNOTATION BOTTOM MARK
32A6      ; [.B2A0.0020.0006] # CIRCLED IDEOGRAPH LOW
319B      ; [.8355.0020.0014] # IDEOGRAPHIC ANNOTATION THIRD MARK
2F01      ; [.9F64.0020.0004] # KANGXI RADICAL LINE
3197      ; [.BB6D.0020.0014] # IDEOGRAPHIC ANNOTATION MIDDLE MARK
32A5      ; [.BB6D.0020.0006] # CIRCLED IDEOGRAPH CENTRE
1F22D     ; [.BB6D.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E2D
2F02      ; [.BA6A.0020.0004] # KANGXI RADICAL DOT
2F03      ; [.8558.0020.0004] # KANGXI RADICAL SLASH
2F04      ; [.CC59.0020.0004] # KANGXI RADICAL SECOND
319A      ; [.CC59.0020.0014] # IDEOGRAPHIC ANNOTATION SECOND MARK
3288      ; [.A95D.0020.0006] # CIRCLED IDEOGRAPH NINE
2F05      ; [.AC3C.0020.0004] # KANGXI RADICAL HOOK
2F06      ; [.CBCD.0020.0004] # KANGXI RADICAL TWO
3193      ; [.CBCD.0020.0014] # IDEOGRAPHIC ANNOTATION TWO MARK
3281      ; [.CBCD.0020.0006] # CIRCLED IDEOGRAPH TWO
1F214     ; [.CBCD.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4E8C
3284      ; [.D1A9.0020.0006] # CIRCLED IDEOGRAPH FIVE
2F07      ; [.90D4.0020.0004] # KANGXI RADICAL LID
1F218     ; [.A8BE.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-4EA4
2F08      ; [.C2EF.0020.0004] # KANGXI RADICAL MAN
319F      ; [.C2EF.0020.0014] # IDEOGRAPHIC ANNOTATION MAN MARK
32AD      ; [.ADC1.0020.0006] # CIRCLED IDEOGRAPH ENTERPRISE
32A1      ; [.B3A8.0020.0006] # CIRCLED IDEOGRAPH REST
329D      ; [.CE97.0020.0006] # CIRCLED IDEOGRAPH EXCELLENT
2F09      ; [.CBA3.0020.0004] # KANGXI RADICAL LEGS
2F0A      ; [.C376.0020.0004] # KANGXI RADICAL ENTER
2F0B      ; [.8001.0020.0004] # KANGXI RADICAL EIGHT
3287      ; [.8001.0020.0006] # CIRCLED IDEOGRAPH EIGHT
3285      ; [.9953.0020.0006] # CIRCLED IDEOGRAPH SIX
2F0C      ; [.AD19.0020.0004] # KANGXI RADICAL DOWN BOX
1F21E     ; [.C4C2.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-518D
2F0D      ; [.8867.0020.0004] # KANGXI RADICAL COVER
32A2      ; [.B2E9.0020.0006] # CIRCLED IDEOGRAPH COPY
2F0E      ; [.834E.0020.0004] # KANGXI RADICAL ICE
2F0F      ; [.A74C.0020.0004] # KANGXI RADICAL TABLE
2F10      ; [.AF59.0020.0004] # KANGXI RADICAL OPEN BOX
2F11      ; [.8C87.0020.0004] # KANGXI RADICAL KNIFE
1F220     ; [.BE3B.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-521D
1F21C     ; [.AF3B.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-524D
1F239     ; [.9C7B.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5272
2F12      ; [.9804.0020.0004] # KANGXI RADICAL POWER
3298      ; [.969E.0020.0006] # CIRCLED IDEOGRAPH LABOR
2F13      ; [.811A.0020.0004] # KANGXI RADICAL WRAP
2F14      ; [.81FC.0020.0004] # KANGXI RADICAL SPOON
2F15      ; [.8A9F.0020.0004] # KANGXI RADICAL RIGHT OPEN BOX
2F16      ; [.B224.0020.0004] # KANGXI RADICAL HIDING ENCLOSURE
32A9      ; [.CBE1.0020.0006] # CIRCLED IDEOGRAPH MEDICINE
2F17      ; [.BF85.0020.0004] # KANGXI RADICAL TEN
3038      ; [.BF85.0020.0004] # HANGZHOU NUMERAL TEN
3289      ; [.BF85.0020.0006] # CIRCLED IDEOGRAPH TEN
3039      ; [.954F.0020.0004] # HANGZHOU NUMERAL TWENTY
303A      ; [.C861.0020.0004] # HANGZHOU NUMERAL THIRTY
32AF      ; [.B2BC.0020.0006] # CIRCLED IDEOGRAPH ALLIANCE
2F18      ; [.80B6.0020.0004] # KANGXI RADICAL DIVINATION
2F19      ; [.A84F.0020.0004] # KANGXI RADICAL SEAL
329E      ; [.D06B.0020.0006] # CIRCLED IDEOGRAPH PRINT
2F1A      ; [.BDC0.0020.0004] # KANGXI RADICAL CLIFF
2F1B      ; [.C7F7.0020.0004] # KANGXI RADICAL PRIVATE
2F1C      ; [.CEE0.0020.0004] # KANGXI RADICAL AGAIN
1F212     ; [.C28A.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-53CC
2F1D      ; [.A070.0020.0004] # KANGXI RADICAL MOUTH
1F251     ; [.A007.0020.0006] # CIRCLED IDEOGRAPH ACCEPT
32A8      ; [.CEE1.0020.0006] # CIRCLED IDEOGRAPH RIGHT
1F22E     ; [.CEE1.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-53F3
1F234     ; [.A232.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5408
3294      ; [.892A.0020.0006] # CIRCLED IDEOGRAPH NAME
1F225     ; [.BEBE.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5439
3244      ; [.D3B7.0020.0006] # CIRCLED IDEOGRAPH QUESTION
1F23A     ; [.D120.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-55B6
2F1E      ; [.D27D.0020.0004] # KANGXI RADICAL ENCLOSURE
3195      ; [.C82E.0020.0014] # IDEOGRAPHIC ANNOTATION FOUR MARK
3283      ; [.C82E.0020.0006] # CIRCLED IDEOGRAPH FOUR
2F1F      ; [.92EA.0020.0004] # KANGXI RADICAL EARTH
328F      ; [.92EA.0020.0006] # CIRCLED IDEOGRAPH EARTH
319E      ; [.8C4B.0020.0014] # IDEOGRAPHIC ANNOTATION EARTH MARK
2F20      ; [.BFB5.0020.0004] # KANGXI RADICAL SCHOLAR
1F224     ; [.C1A8.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-58F0
2F21      ; [.B740.0020.0004] # KANGXI RADICAL GO
2F22      ; [.C986.0020.0004] # KANGXI RADICAL GO SLOWLY
2F23      ; [.B165.0020.0004] # KANGXI RADICAL EVENING
1F215     ; [.8F35.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-591A
32B0      ; [.CDD7.0020.0006] # CIRCLED IDEOGRAPH NIGHT
2F24      ; [.8C39.0020.0004] # KANGXI RADICAL BIG
337D      ; [.8C39.0020.001C][.BA1E.0020.001C] # SQUARE ERA NAME TAISYOU
319D      ; [.923B.0020.0014] # IDEOGRAPHIC ANNOTATION HEAVEN MARK
1F217     ; [.923B.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5929
2F25      ; [.95CC.0020.0004] # KANGXI RADICAL WOMAN
329B      ; [.95CC.0020.0006] # CIRCLED IDEOGRAPH FEMALE
2F26      ; [.C466.0020.0004] # KANGXI RADICAL CHILD
1F211     ; [.C456.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5B57
32AB      ; [.B5F0.0020.0006] # CIRCLED IDEOGRAPH STUDY
2F27      ; [.88BF.0020.0004] # KANGXI RADICAL ROOF
32AA      ; [.C5ED.0020.0006] # CIRCLED IDEOGRAPH RELIGION
2F28      ; [.C7B4.0020.0004] # KANGXI RADICAL INCH
2F29      ; [.B385.0020.0004] # KANGXI RADICAL SMALL
2F2A      ; [.CE9E.0020.0004] # KANGXI RADICAL LAME
2F2B      ; [.BF5B.0020.0004] # KANGXI RADICAL CORPSE
2F2C      ; [.BC63.0020.0004] # KANGXI RADICAL SPROUT
2F2D      ; [.C0C5.0020.0004] # KANGXI RADICAL MOUNTAIN
2F2E      ; [.BED1.0020.0004] # KANGXI RADICAL RIVER
2F2F      ; [.9F9E.0020.0004] # KANGXI RADICAL WORK
32A7      ; [.C593.0020.0006] # CIRCLED IDEOGRAPH LEFT
1F22C     ; [.C593.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5DE6
2F30      ; [.A74D.0020.0004] # KANGXI RADICAL ONESELF
2F31      ; [.AA6D.0020.0004] # KANGXI RADICAL TURBAN
2F32      ; [.9D7F.0020.0004] # KANGXI RADICAL DRY
337B      ; [.85BF.0020.001C][.BDFC.0020.001C] # SQUARE ERA NAME HEISEI
2F33      ; [.CE11.0020.0004] # KANGXI RADICAL SHORT THREAD
3245      ; [.CEE2.0020.0006] # CIRCLED IDEOGRAPH KINDERGARTEN
2F34      ; [.9F8F.0020.0004] # KANGXI RADICAL DOTTED CLIFF
2F35      ; [.D04E.0020.0004] # KANGXI RADICAL LONG STRIDE
2F36      ; [.9FBB.0020.0004] # KANGXI RADICAL TWO HANDS
2F37      ; [.CC86.0020.0004] # KANGXI RADICAL SHOOT
2F38      ; [.9F9F.0020.0004] # KANGXI RADICAL BOW
2F39      ; [.A763.0020.0004] # KANGXI RADICAL SNOUT
2F3A      ; [.C0C6.0020.0004] # KANGXI RADICAL BRISTLE
2F3B      ; [.BBF9.0020.0004] # KANGXI RADICAL STEP
1F21D     ; [.A30D.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-5F8C
1F250     ; [.8C4D.0020.0006] # CIRCLED IDEOGRAPH ADVANTAGE
2F3C      ; [.B4AB.0020.0004] # KANGXI RADICAL HEART
2F3D      ; [.9C6C.0020.0004] # KANGXI RADICAL HALBERD
2F3E      ; [.A40C.0020.0004] # KANGXI RADICAL DOOR
2F3F      ; [.C0AE.0020.0004] # KANGXI RADICAL HAND
1F210     ; [.C0AE.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-624B
1F231     ; [.8C38.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6253
1F227     ; [.90D6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6295
1F22F     ; [.B753.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6307
1F228     ; [.838E.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6355
2F40      ; [.B6EB.0020.0004] # KANGXI RADICAL BRANCH
2F41      ; [.85EC.0020.0004] # KANGXI RADICAL RAP
2F42      ; [.D38D.0020.0004] # KANGXI RADICAL SCRIPT
3246      ; [.D38D.0020.0006] # CIRCLED IDEOGRAPH SCHOOL
2F43      ; [.8CCF.0020.0004] # KANGXI RADICAL DIPPER
1F21B     ; [.9905.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6599
2F44      ; [.AA6F.0020.0004] # KANGXI RADICAL AXE
1F21F     ; [.B4BC.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-65B0
2F45      ; [.8AA0.0020.0004] # KANGXI RADICAL SQUARE
2F46      ; [.D18A.0020.0004] # KANGXI RADICAL NOT
2F47      ; [.C2A4.0020.0004] # KANGXI RADICAL SUN
3290      ; [.C2A4.0020.0006] # CIRCLED IDEOGRAPH SUN
337E      ; [.892B.0020.001C][.B773.0020.001C] # SQUARE ERA NAME MEIZI
1F219     ; [.D15D.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6620
337C      ; [.B884.0020.001C][.A237.0020.001C] # SQUARE ERA NAME SYOUWA
2F48      ; [.D533.0020.0004] # KANGXI RADICAL SAY
2F49      ; [.D53C.0020.0004] # KANGXI RADICAL MOON
328A      ; [.D53C.0020.0006] # CIRCLED IDEOGRAPH MOON
1F237     ; [.D53C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6708
3292      ; [.CEC7.0020.0006] # CIRCLED IDEOGRAPH HAVE
1F236     ; [.CEC7.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6709
2F4A      ; [.895F.0020.0004] # KANGXI RADICAL TREE
328D      ; [.895F.0020.0006] # CIRCLED IDEOGRAPH WOOD
3291      ; [.BA36.0020.0006] # CIRCLED IDEOGRAPH STOCK
337F      ; [.BA36.0020.001C][.BFBF.0020.001C][.A51A.0020.001C][.C05E.0020.001C] # SQUARE CORPORATION
2F4B      ; [.AF68.0020.0004] # KANGXI RADICAL LACK
2F4C      ; [.B741.0020.0004] # KANGXI RADICAL STOP
32A3      ; [.BA1E.0020.0006] # CIRCLED IDEOGRAPH CORRECT
2F4D      ; [.8C53.0020.0004] # KANGXI RADICAL DEATH
2F4E      ; [.C1D9.0020.0004] # KANGXI RADICAL WEAPON
2F4F      ; [.D18B.0020.0004] # KANGXI RADICAL DO NOT
2E9F      ; [.894D.0020.0004] # CJK RADICAL MOTHER
2F50      ; [.81FD.0020.0004] # KANGXI RADICAL COMPARE
2F51      ; [.8727.0020.0004] # KANGXI RADICAL FUR
2F52      ; [.BFB6.0020.0004] # KANGXI RADICAL CLAN
2F53      ; [.ADDA.0020.0004] # KANGXI RADICAL STEAM
2F54      ; [.C26E.0020.0004] # KANGXI RADICAL WATER
328C      ; [.C26E.0020.0006] # CIRCLED IDEOGRAPH WATER
329F      ; [.BA84.0020.0006] # CIRCLED IDEOGRAPH ATTENTION
1F235     ; [.8793.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6E80
1F226     ; [.CF75.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-6F14
2F55      ; [.A48C.0020.0004] # KANGXI RADICAL FIRE
328B      ; [.A48C.0020.0006] # CIRCLED IDEOGRAPH FIRE
1F21A     ; [.D19A.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7121
2F56      ; [.B88D.0020.0004] # KANGXI RADICAL CLAW
2F57      ; [.8BC3.0020.0004] # KANGXI RADICAL FATHER
2F58      ; [.CE21.0020.0004] # KANGXI RADICAL DOUBLE X
2F59      ; [.8453.0020.0004] # KANGXI RADICAL HALF TREE TRUNK
2F5A      ; [.8593.0020.0004] # KANGXI RADICAL SLICE
2F5B      ; [.CD78.0020.0004] # KANGXI RADICAL FANG
2F5C      ; [.9526.0020.0004] # KANGXI RADICAL COW
3295      ; [.9060.0020.0006] # CIRCLED IDEOGRAPH SPECIAL
2F5D      ; [.B123.0020.0004] # KANGXI RADICAL DOG
2F5E      ; [.B63A.0020.0004] # KANGXI RADICAL PROFOUND
2F5F      ; [.D4A7.0020.0004] # KANGXI RADICAL JADE
2F60      ; [.9E4D.0020.0004] # KANGXI RADICAL MELON
2F61      ; [.D216.0020.0004] # KANGXI RADICAL TILE
2F62      ; [.9D4E.0020.0004] # KANGXI RADICAL SWEET
2F63      ; [.C1A6.0020.0004] # KANGXI RADICAL LIFE
1F222     ; [.C1A6.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-751F
2F64      ; [.D68B.0020.0004] # KANGXI RADICAL USE
2F65      ; [.9245.0020.0004] # KANGXI RADICAL FIELD
3199      ; [.A814.0020.0014] # IDEOGRAPHIC ANNOTATION FIRST MARK
1F238     ; [.C125.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7533
329A      ; [.9459.0020.0006] # CIRCLED IDEOGRAPH MALE
2F66      ; [.852E.0020.0004] # KANGXI RADICAL BOLT OF CLOTH
2F67      ; [.93F9.0020.0004] # KANGXI RADICAL SICKNESS
2F68      ; [.8046.0020.0004] # KANGXI RADICAL DOTTED TENT
2F69      ; [.80BD.0020.0004] # KANGXI RADICAL WHITE
2F6A      ; [.8504.0020.0004] # KANGXI RADICAL SKIN
2F6B      ; [.890B.0020.0004] # KANGXI RADICAL DISH
32AC      ; [.A9B3.0020.0006] # CIRCLED IDEOGRAPH SUPERVISE
2F6C      ; [.8962.0020.0004] # KANGXI RADICAL EYE
2F6D      ; [.8728.0020.0004] # KANGXI RADICAL SPEAR
2F6E      ; [.BFA9.0020.0004] # KANGXI RADICAL ARROW
2F6F      ; [.BF87.0020.0004] # KANGXI RADICAL STONE
2F70      ; [.BFBD.0020.0004] # KANGXI RADICAL SPIRIT
3293      ; [.C05E.0020.0006] # CIRCLED IDEOGRAPH SOCIETY
3297      ; [.BA90.0020.0006] # CIRCLED IDEOGRAPH CONGRATULATION
1F232     ; [.AAB2.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7981
2F71      ; [.C2BD.0020.0004] # KANGXI RADICAL TRACK
2F72      ; [.A231.0020.0004] # KANGXI RADICAL GRAIN
3299      ; [.8871.0020.0006] # CIRCLED IDEOGRAPH SECRET
2F73      ; [.B5ED.0020.0004] # KANGXI RADICAL CAVE
1F233     ; [.A211.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7A7A
2F74      ; [.9808.0020.0004] # KANGXI RADICAL STAND
2F75      ; [.BA53.0020.0004] # KANGXI RADICAL BAMBOO
3247      ; [.BA0D.0020.0006] # CIRCLED IDEOGRAPH KOTO
2F76      ; [.8856.0020.0004] # KANGXI RADICAL RICE
2F77      ; [.8868.0020.0004] # KANGXI RADICAL SILK
1F221     ; [.BB7F.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-7D42
2F78      ; [.89F6.0020.0004] # KANGXI RADICAL JAR
2F79      ; [.D3D1.0020.0004] # KANGXI RADICAL NET
2F7A      ; [.D08F.0020.0004] # KANGXI RADICAL SHEEP
2F7B      ; [.D47D.0020.0004] # KANGXI RADICAL FEATHER
2F7C      ; [.96B7.0020.0004] # KANGXI RADICAL OLD
2F7D      ; [.CBA4.0020.0004] # KANGXI RADICAL AND
2F7E      ; [.966B.0020.0004] # KANGXI RADICAL PLOW
2F7F      ; [.CBBF.0020.0004] # KANGXI RADICAL EAR
2F80      ; [.D4AA.0020.0004] # KANGXI RADICAL BRUSH
2F81      ; [.C2D4.0020.0004] # KANGXI RADICAL MEAT
2F82      ; [.BD5B.0020.0004] # KANGXI RADICAL MINISTER
2F83      ; [.C457.0020.0004] # KANGXI RADICAL SELF
2F84      ; [.B766.0020.0004] # KANGXI RADICAL ARRIVE
2F85      ; [.A96D.0020.0004] # KANGXI RADICAL MORTAR
2F86      ; [.C053.0020.0004] # KANGXI RADICAL TONGUE
2F87      ; [.BEE4.0020.0004] # KANGXI RADICAL OPPOSE
2F88      ; [.B8B0.0020.0004] # KANGXI RADICAL BOAT
2F89      ; [.9D94.0020.0004] # KANGXI RADICAL STOPPING
2F8A      ; [.C870.0020.0004] # KANGXI RADICAL COLOR
2F8B      ; [.C6C2.0020.0004] # KANGXI RADICAL GRASS
2F8C      ; [.A3B4.0020.0004] # KANGXI RADICAL TIGER
2F8D      ; [.BF4A.0020.0004] # KANGXI RADICAL INSECT
2F8E      ; [.B604.0020.0004] # KANGXI RADICAL BLOOD
2F8F      ; [.B543.0020.0004] # KANGXI RADICAL WALK ENCLOSURE
2F90      ; [.CBE0.0020.0004] # KANGXI RADICAL CLOTHES
2F91      ; [.CD9C.0020.0004] # KANGXI RADICAL WEST
2F92      ; [.AA1C.0020.0004] # KANGXI RADICAL SEE
2F93      ; [.A8EB.0020.0004] # KANGXI RADICAL HORN
1F216     ; [.A898.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-89E3
2F94      ; [.CF21.0020.0004] # KANGXI RADICAL SPEECH
2F95      ; [.9E07.0020.0004] # KANGXI RADICAL VALLEY
2F96      ; [.8CD0.0020.0004] # KANGXI RADICAL BEAN
2F97      ; [.BFAB.0020.0004] # KANGXI RADICAL PIG
2F98      ; [.B76C.0020.0004] # KANGXI RADICAL BADGER
2F99      ; [.80EB.0020.0004] # KANGXI RADICAL SHELL
3296      ; [.C69F.0020.0006] # CIRCLED IDEOGRAPH FINANCIAL
1F223     ; [.8A4B.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-8CA9
32AE      ; [.C421.0020.0006] # CIRCLED IDEOGRAPH RESOURCE
2F9A      ; [.BBFE.0020.0004] # KANGXI RADICAL RED
2F9B      ; [.C50C.0020.0004] # KANGXI RADICAL RUN
1F230     ; [.C50C.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-8D70
2F9C      ; [.C571.0020.0004] # KANGXI RADICAL FOOT
2F9D      ; [.C129.0020.0004] # KANGXI RADICAL BODY
2F9E      ; [.BC58.0020.0004] # KANGXI RADICAL CART
2F9F      ; [.B4AE.0020.0004] # KANGXI RADICAL BITTER
2FA0      ; [.BD5F.0020.0004] # KANGXI RADICAL MORNING
2FA1      ; [.BEA0.0020.0004] # KANGXI RADICAL WALK
1F22B     ; [.CEBC.0020.001C] # SQUARED CJK UNIFIED IDEOGRAPH-904A
329C      ; [.BFFC.0020.0006] # CIRCLED IDEOGRAPH SUITABLE
2FA2      ; [.CC9C.0020.0004] # KANGXI RADICAL CITY
2FA3      ; [.CECA.0020.0004] # KANGXI RADICAL WINE
2FA4      ; [.8308.0020.0004] # KANGXI RADICAL DISTINGUISH
2FA5      ; [.97EB.0020.0004] # KANGXI RADICAL VILLAGE
2FA6      ; [.AA72.0020.0004] # KANGXI RADICAL GOLD
328E      ; [.AA72.0020.0006] # CIRCLED IDEOGRAPH METAL
2FA7      ; [.B9D1.0020.0004] # KANGXI RADICAL LONG
2FA8      ; [.87B7.0020.0004] # KANGXI RADICAL GATE
2FA9      ; [.8BCB.0020.0004] # KANGXI RADICAL MOUND
2FAA      ; [.9819.0020.0004] # KANGXI RADICAL SLAVE
2FAB      ; [.BAFD.0020.0004] # KANGXI RADICAL SHORT TAILED BIRD
2FAC      ; [.D47F.0020.0004] # KANGXI RADICAL RAIN
2FAD      ; [.B01B.0020.0004] # KANGXI RADICAL BLUE
2FAE      ; [.89A9.0020.0004] # KANGXI RADICAL WRONG
2FAF      ; [.88EB.0020.0004] # KANGXI RADICAL FACE
2FB0      ; [.9C8F.0020.0004] # KANGXI RADICAL LEATHER
2FB1      ; [.D288.0020.0004] # KANGXI RADICAL TANNED LEATHER
2FB2      ; [.A965.0020.0004] # KANGXI RADICAL LEEK
2FB3      ; [.CFF8.0020.0004] # KANGXI RADICAL SOUND
2FB4      ; [.CDDC.0020.0004] # KANGXI RADICAL LEAF
32A0      ; [.B520.0020.0006] # CIRCLED IDEOGRAPH ITEM
2FB5      ; [.8AD5.0020.0004] # KANGXI RADICAL WIND
2FB6      ; [.89AA.0020.0004] # KANGXI RADICAL FLY
2FB7      ; [.BF93.0020.0004] # KANGXI RADICAL EAT
2FB8      ; [.C0B1.0020.0004] # KANGXI RADICAL HEAD
2FB9      ; [.B4E1.0020.0004] # KANGXI RADICAL FRAGRANT
2FBA      ; [.8637.0020.0004] # KANGXI RADICAL HORSE
2FBB      ; [.9E10.0020.0004] # KANGXI RADICAL BONE
2FBC      ; [.9CEC.0020.0004] # KANGXI RADICAL TALL
2FBD      ; [.82AD.0020.0004] # KANGXI RADICAL HAIR
2FBE      ; [.8CD4.0020.0004] # KANGXI RADICAL FIGHT
2FBF      ; [.BDCE.0020.0004] # KANGXI RADICAL SACRIFICIAL WINE
2FC0      ; [.9C94.0020.0004] # KANGXI RADICAL CAULDRON
2FC1      ; [.9EF1.0020.0004] # KANGXI RADICAL GHOST
2FC2      ; [.D436.0020.0004] # KANGXI RADICAL FISH
2FC3      ; [.9519.0020.0004] # KANGXI RADICAL BIRD
2FC4      ; [.9AD5.0020.0004] # KANGXI RADICAL SALT
2FC5      ; [.9AFD.0020.0004] # KANGXI RADICAL DEER
2FC6      ; [.86CC.0020.0004] # KANGXI RADICAL WHEAT
2FC7      ; [.862D.0020.0004] # KANGXI RADICAL HEMP
2FC8      ; [.A607.0020.0004] # KANGXI RADICAL YELLOW
2FC9      ; [.C20C.0020.0004] # KANGXI RADICAL MILLET
2FCA      ; [.A2AD.0020.0004] # KANGXI RADICAL BLACK
2FCB      ; [.B762.0020.0004] # KANGXI RADICAL EMBROIDERY
2FCC      ; [.88E4.0020.0004] # KANGXI RADICAL FROG
2FCD      ; [.8ED2.0020.0004] # KANGXI RADICAL TRIPOD
2FCE      ; [.9E1D.0020.0004] # KANGXI RADICAL DRUM
2FCF      ; [.C210.0020.0004] # KANGXI RADICAL RAT
2FD0      ; [.81FB.0020.0004] # KANGXI RADICAL NOSE
2FD1      ; [.ADA1.0020.0004] # KANGXI RADICAL EVEN
2FD2      ; [.BBF7.0020.0004] # KANGXI RADICAL TOOTH
2FD3      ; [.9BE4.0020.0004] # KANGXI RADICAL DRAGON
2FD4      ; [.9ED7.0020.0004] # KANGXI RADICAL TURTLE
2EF3      ; [.9EB8.0020.0004] # CJK RADICAL C-SIMPLIFIED TURTLE
2FD5      ; [.D560.0020.0004] # KANGXI RADICAL FLUTE
F967      ; [.8392.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.836F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.BEEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.D334.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.8CEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
2F800     ; [.980B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F800
2F802     ; [.CC07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F802
F91B      ; [.9BA8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.9615.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.9A32.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.C151.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
2F819     ; [.834F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F819
F9A8      ; [.9A9B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
2F804     ; [.94AF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F804
FA73      ; [.B546.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA73
F92D      ; [.9619.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.9811.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.D1B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.D1B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.935A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.830C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.8373.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.9BB2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F808     ; [.C477.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F808
2F809     ; [.80FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.B522.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.98D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.C90E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.C90E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.D1CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.BF37.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.88D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.88D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.92F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80F
2F810     ; [.A627.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F810
2F814     ; [.9422.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.B0F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.9A28.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.9953.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.ABF3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.A7A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.C4C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.874F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.88DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.C3F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.D571.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.8FE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.A1F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.A1F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.9793.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.9A18.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.9A51.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.99F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.B1BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81D     ; [.AF59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.C305.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.AE24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.AE24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.98A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.980C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.C66A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.A014.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F821     ; [.9B64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F821
2F822     ; [.9C7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.BD2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.9926.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.9804.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.98A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
2F992     ; [.969D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F992
FA76      ; [.D671.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.D671.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.88D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.88D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.964C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.96A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.AFAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.AFAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.985C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.C096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.C096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.811B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.C7B7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.80E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.80E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.94CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.A518.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.80D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.80D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.807E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.A6FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.9BA5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.A70A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.B020.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.B020.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.B020.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.C6D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.A6FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.C8D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.ABEE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.A922.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.BBFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
2F83B     ; [.CE13.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83B
F9DE      ; [.9809.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.9A03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.B16A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.9C24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.BDFE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.B8B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F83C     ; [.B473.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83C
2F840     ; [.CA56.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.CF9A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F841     ; [.8891.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F841
2F842     ; [.9144.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.ADCE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
FA79      ; [.90B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA79
2F844     ; [.B415.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.C100.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.C100.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.95E6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.A52B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.A52B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.A22D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.A22D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.BBB6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
2F849     ; [.B7F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F849
FA0D      ; [.A422.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0D
2F84A     ; [.CE34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84A
FA7B      ; [.D21D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.912C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.912C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
2F84E     ; [.A2BD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84E
FA38      ; [.ADFD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.847B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.9A44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.92DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F84D     ; [.92DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84D
2F855     ; [.B548.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.BE03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.B720.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F854     ; [.92F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F854
2F857     ; [.8151.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
2F856     ; [.C642.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F856
FA39      ; [.85EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.BB92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.BB92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.C892.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.86A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
2F858     ; [.8E0D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F858
FA7D      ; [.8A7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.9679.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.9C0B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F851     ; [.BB63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85A     ; [.86C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85A
2F85B     ; [.A3DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85B
2F85C     ; [.8AFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.8F35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.882A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.CF5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.9410.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.ADE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.8193.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.C04A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.95CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F865     ; [.8598.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F865
2F862     ; [.A6AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.D42A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.935B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.8232.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.8BDA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.D15F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.C2B1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.C657.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.9741.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.9741.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.B874.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.D575.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.B7AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.9570.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.9570.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.9570.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.98DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F870     ; [.8143.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F870
2F872     ; [.C0B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.AAD5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.CE9E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.9522.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.92CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.9C34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.C71D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.9C36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.BC63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.BC63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F878
2F87A     ; [.AEFF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87A
2F879     ; [.B3C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.9BB6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
2F87C     ; [.CF66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87C
F921      ; [.970A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
2F87F     ; [.C416.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87F
2F87E     ; [.8E87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87E
2F880     ; [.BD30.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F880
2F9F4     ; [.B1BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F4
F9AB      ; [.9A9A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.B68C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.BC98.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.B6C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.C26F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.8758.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
2F887     ; [.8A7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F887
F98E      ; [.9537.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.8F28.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88B     ; [.8372.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88B
2F88C     ; [.8233.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.C22B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.996E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.9766.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.9766.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA82      ; [.CAF7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA82
FA0B      ; [.A11E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
FA83      ; [.CCFF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA83
F982      ; [.9AB9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
2F890     ; [.9FBB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.95C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.9097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.9097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F874     ; [.8D4C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.B544.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.C6A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.8E55.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.9C41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
2F89C     ; [.8FF3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89C
F966      ; [.8BDF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.CE36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.C2FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.B768.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.9551.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
2F89F     ; [.A1E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89F
F960      ; [.958F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.9965.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA6B      ; [.A524.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6B
2F8A0     ; [.D572.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.A510.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.A510.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.8FBB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.D3D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.CA70.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.D4DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.9846.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.C64C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.A5FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.A5FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.C178.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.C178.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA8A      ; [.CB23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.A03D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.96E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.C55C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.C55C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.C55C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.997C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.8A96.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.C6EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.B498.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.8803.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.BE2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.BE2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.BE2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.9742.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.9742.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.99C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.BDFC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.A802.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.9B16.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.8C7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B4     ; [.A0E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B4
2F8B5     ; [.814B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.95DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.93DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.9037.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.801D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
2F8BA     ; [.8599.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BA
F973      ; [.C00F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.D348.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.ACA2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.C05A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.9540.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.C8AF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.CA67.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.CF63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.D43E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
2F8C0     ; [.CF39.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C0
2F8BD     ; [.A70F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BD
FA8E      ; [.C8BD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.AAB0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
FA8F      ; [.8365.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8F
2F8C3     ; [.865D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
2F8C6     ; [.A904.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C6
2F8C4     ; [.AB0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C4
F991      ; [.9546.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.A4F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.9ADE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.8915.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.8915.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.CAF2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.AB74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.C23A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.9905.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.9C2B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.A775.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA42
2F8CB     ; [.A789.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.CCA3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.AAA5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.B034.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.B034.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.D5E6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.C20B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.C20B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
2F8D5     ; [.AAB8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D5
FA06      ; [.8156.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.9855.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.9DDE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.C1E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.C5BD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.9775.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.9775.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.9775.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.D3E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.D3E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
2F8DA     ; [.C5F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DA
F9E1      ; [.9897.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.82A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.B9DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.ADC7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.BCDE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
2F8E0     ; [.A6A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E0
F9F4      ; [.99CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.9944.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
2F8DF     ; [.9EAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DF
F9DA      ; [.9826.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
2F8E5     ; [.8196.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E5
2F8E1     ; [.C902.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E1
F97A      ; [.9A19.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.86DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.86DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
2F8E4     ; [.CAEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E4
F9E2      ; [.979F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E6     ; [.C417.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E6
2F8E8     ; [.B7F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8E9     ; [.CE3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E9
2F8EA     ; [.9CE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.9610.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.9610.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.9610.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.96E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
2F8EB     ; [.C052.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EB
F931      ; [.9AE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.B7D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.9726.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.C667.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.B58D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.C9AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.9856.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
FA95      ; [.8C53.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA95
2F8F4     ; [.D380.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F4
F9A5      ; [.99BD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.C025.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.C025.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.C025.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8F6     ; [.AE8A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F6
2F8FA     ; [.8A3E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
2F8FE     ; [.AF01.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FE
F972      ; [.BD5D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.CF25.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.886C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
2F8FD     ; [.8194.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FD
F9E3      ; [.9490.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
2F8FF     ; [.D193.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FF
F915      ; [.9B72.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.900E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F907     ; [.85C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F907
2F900     ; [.83F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.9912.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.9912.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.9912.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.A2D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.9781.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.A29A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.A29A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.AAA7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.94E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.99D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.9688.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.9BB8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.CF08.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.BA70.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.9DB6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.CF0D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.990C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.94CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
2F90C     ; [.8E88.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90C
FA99      ; [.C419.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.C419.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.A44F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
FA98      ; [.D03B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA98
F94E      ; [.96FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.A368.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.A368.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.9974.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.BCA0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.8A7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.9751.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.9C51.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.D142.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.AB83.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.AB83.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F913     ; [.D563.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F913
2F917     ; [.AF57.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F917
2F835     ; [.A4D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F919     ; [.BB35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F919
2F918     ; [.C4B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.B774.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.9126.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.98B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.96C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
2F91C     ; [.8FAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91C
F993      ; [.99B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.BA72.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.BA72.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
2F91E     ; [.C7CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91E
F9C0      ; [.98E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.99E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.9AC1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.9753.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.C7A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA49      ; [.B8AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA49
FA9E      ; [.AC81.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.AC81.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
2F922     ; [.B809.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F922
F946      ; [.969F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.B19A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
2F925     ; [.810B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F925
FA9F      ; [.8A3C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.BB66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.975E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.BA3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.BA3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.98C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.9034.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.9C43.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.9C43.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.D3CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
2F92B     ; [.D544.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92B
F9AD      ; [.9A4F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.9B76.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.97F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.9914.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.C58E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92E     ; [.8C72.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92E
2F92F     ; [.D44E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.D131.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.B9AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.B9AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
2F931     ; [.C979.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F931
F994      ; [.999F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.99E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.B15E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
FAA2      ; [.C64D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA2
2F934     ; [.C397.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F934
FAA3      ; [.A462.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA3
2F936     ; [.C4B7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F936
F9CD      ; [.9915.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.CA68.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.CCD0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.CCD0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.983F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.D494.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA4      ; [.9F2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA4
FAA5      ; [.D382.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.98E8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.9649.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.CCC7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.CCC7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.C1CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.9AB5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.B71A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.B71A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.C1C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.B959.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
2F946     ; [.B95A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.B95A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.B869.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
FAA9      ; [.ACC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA9
2F948     ; [.ACC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F948
2F94A     ; [.BD55.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
FA9D      ; [.AE77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9D
2F94E     ; [.B54F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94E
F9CE      ; [.9918.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.9B0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.9B0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.80DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.9673.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
FAAB      ; [.9259.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAB
2F950     ; [.9259.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F950
F964      ; [.845F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.9878.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA18      ; [.97EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.C05E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.AD73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.B757.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.CEF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.C583.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.C583.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.BA90.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.C153.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.B4FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.9B0B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.A4A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.B971.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.8B8D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.8B8D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.97FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.9538.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.C201.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.978F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.9E24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.9E24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
2F95A     ; [.A79C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95A
2F95B     ; [.D3B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95B
FA55      ; [.92B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
FAAC      ; [.9231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAC
F9F7      ; [.9808.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
2F95F     ; [.85BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95F
F9F8      ; [.9833.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.A87C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.A87C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.BB3E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.BA5F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.9992.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.9BF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
FAAE      ; [.9686.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAE
F9F9      ; [.9834.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.AB32.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
2F966     ; [.8114.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F966
FA03      ; [.915F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
2F969     ; [.C8EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F969
F97B      ; [.9A24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F968     ; [.AB10.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F968
2F96A     ; [.A778.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.952E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.C970.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.9689.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.90A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.81D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.9C4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.9A73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.C427.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.99BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.99BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.99BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
2F96F     ; [.C61F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96F
FA58      ; [.AAC3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.9C3C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.8A28.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.C8A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.85D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.C20E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.97C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
2F976     ; [.BCA2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F976
F90F      ; [.9B52.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
2F978     ; [.D0D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F978
F9AF      ; [.9A62.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.D47D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.CB06.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.96B7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.B856.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.B856.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.B856.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.9A64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
2F97D     ; [.85BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97D
F997      ; [.9989.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.C7D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.9BF9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.9600.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.93E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.D4B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F983     ; [.C780.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F983
2F985     ; [.851D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.95F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.99E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.BCE6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.D42F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.D42F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
2F98C     ; [.B23F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98C
FA6D      ; [.9F3F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6D
F97C      ; [.9A16.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
FA5D      ; [.C6CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5D
FA5E      ; [.C6CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5E
2F990     ; [.D4AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F98F     ; [.ADCA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98F
2F991     ; [.B6F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.A43F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.8AA5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.CD7E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.C386.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.C386.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.A0F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.BC82.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.D198.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.BC3C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.A5F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F9A0     ; [.85CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A0
2F99A     ; [.C3D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99A
2F99B     ; [.A86D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99B
2F99D     ; [.87E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.9B03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.ABC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.ACE3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.C6B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
2F99E     ; [.8DE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99E
FAB4      ; [.A44D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.9A69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.9B7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.CDE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.B86A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.B86A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.9980.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.85DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
2F9A9     ; [.AA97.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A9
F9C2      ; [.98FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AA     ; [.C74F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AA
2F9AC     ; [.C399.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.971B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.9A11.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.9AC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
FA20      ; [.AEF5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA20
F91F      ; [.9728.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.9B5D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.95D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.9AD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.9AD8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.A14D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B6     ; [.B256.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B6
2F9B8     ; [.AF15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B8
2F9B7     ; [.BBB2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BA     ; [.85D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BA
2F9B9     ; [.D57F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B9
2F9BC     ; [.8E3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
2F9BD     ; [.BA44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BD
FAB5      ; [.D5EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB5
2F9BB     ; [.D5EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BB
2F9BE     ; [.C674.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BE
F911      ; [.9B51.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
2F9C0     ; [.9EFE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C0
2F9C1     ; [.B510.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C1
F927      ; [.95F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.B543.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C3     ; [.BB4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C3
2F9C4     ; [.CBE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.98B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.97F6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
2F9C6     ; [.9919.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C6
2F9C7     ; [.C276.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C7
F9E8      ; [.989C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.9B67.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
2F9C9     ; [.CF76.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C9
FA60      ; [.A282.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.B011.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.9724.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.8BFE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.AA1C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.BFE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.BFE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.BE22.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.C24F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.C24F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.8E75.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.B047.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.9A3C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.9BCB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.D502.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.D502.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.BA48.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.BA48.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.95A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.95A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.CDF9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.CDF9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.AA9A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.AA9A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.C017.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.8F10.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.831E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.831E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.ADCC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.BFAB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.9F4B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.8245.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.9B0D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.A822.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.8331.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.C56B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.C56B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.9D8F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.ADCD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DB     ; [.A9FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DB
2F9DA     ; [.8024.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.9B0E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
2F9DC     ; [.8589.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DC
F902      ; [.BC58.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
2F9DE     ; [.C321.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DE
F998      ; [.9549.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.9BC2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.C1FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.C1FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.8B97.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.988A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
2F98D     ; [.C64B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.BD5F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
FA66      ; [.BE9F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA66
F99A      ; [.996B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.CCEA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.CCEA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.BBE0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.98E6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.9B5E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
2F9E2     ; [.ADC4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E2
F92C      ; [.975C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA2E      ; [.975F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
2F9E3     ; [.85CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E3
FA26      ; [.8CC2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
2F9E4     ; [.C423.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E4
2F9E6     ; [.BC9D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E6
F919      ; [.96C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
FAC4      ; [.C8CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC4
F9B7      ; [.97FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.97EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.9A3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.AA72.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.9A6E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.8086.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
FAC5      ; [.B553.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC5
2F9EA     ; [.8369.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.B62C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
2F9E9     ; [.A455.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E9
F93F      ; [.9B23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.99BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EB     ; [.B013.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EB
2F9EC     ; [.C516.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EC
2F9EE     ; [.A032.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.9C1F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
2F9F0     ; [.C083.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F0
F9C6      ; [.C3B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.96FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.AB03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.9A68.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.9AFC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.BA71.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.9BDC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.99DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.9859.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.985F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
2F9F3     ; [.AF18.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F3
F9EA      ; [.97D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.9467.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.9467.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.9A70.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.964D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.D625.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.9B37.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.9A8D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.AB77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.AB77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
FAC9      ; [.80D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC9
2F9FA     ; [.8286.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.B512.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.B512.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
FACB      ; [.CA47.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACB
2F9FE     ; [.CA47.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FE
2F9FF     ; [.CA47.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FF
F9B4      ; [.9A99.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
2FA00     ; [.85BD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA00
FA6A      ; [.85A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.85A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.9693.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.A6B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.8A4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.C84E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.9F41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
2FA04     ; [.CA8F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA04
2FA05     ; [.D5F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA05
2FA06     ; [.813C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA06
F91A      ; [.9B82.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
2FA07     ; [.9361.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA07
F987      ; [.97E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.B997.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.B997.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.9ADD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
2FA0B     ; [.A7C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0B
F9F2      ; [.99F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
2FA0C     ; [.A9BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0C
2FA0F     ; [.8528.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0F
FA2D      ; [.A28C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.9B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.9BA4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.9AFD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.9871.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.99F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.862D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.97C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.B762.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA18     ; [.88D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA18
2FA19     ; [.B715.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA19
2FA1A     ; [.8885.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1A
2FA1B     ; [.8A85.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1B
2FA1C     ; [.81FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
FAD8      ; [.CA9A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD8
F9C4      ; [.9BE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.8497.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.9ED7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.9ED7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.9ED7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
2F81F     ; [.8505.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81F
2F888     ; [.87AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F888
2F8D0     ; [.D37C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D0
2F8CE     ; [.D2E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CE
2F8DE     ; [.A447.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DE
2F8EE     ; [.CC56.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EE
2F90A     ; [.9C08.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90A
2F92C     ; [.85CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92C
2F92D     ; [.85CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92D
FAD4      ; [.A871.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD4
2F949     ; [.A871.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F949
2F960     ; [.85E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F960
2F96D     ; [.CE1D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96D
2F8D7     ; [.9118.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D7
2FA0E     ; [.A746.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0E
ENTRY
};
