/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.plantuml.hector.GrowingTree;
import net.sourceforge.plantuml.hector.PinLink;
import net.sourceforge.plantuml.hector.Skeleton;

public class PinLinksContinuousSet {
    private final Collection<PinLink> all = new ArrayList<PinLink>();

    public Skeleton createSkeleton() {
        GrowingTree growingTree = new GrowingTree();
        ArrayList<PinLink> arrayList = new ArrayList<PinLink>(this.all);
        while (arrayList.size() > 0) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                PinLink pinLink = (PinLink)iterator.next();
                if (!growingTree.canBeAdded(pinLink)) continue;
                growingTree.add(pinLink);
                iterator.remove();
            }
        }
        return growingTree.createSkeleton();
    }

    public void add(PinLink pinLink) {
        if (this.all.size() == 0) {
            this.all.add(pinLink);
            return;
        }
        if (this.all.contains(pinLink)) {
            throw new IllegalArgumentException("already");
        }
        for (PinLink pinLink2 : this.all) {
            if (!pinLink.doesTouch(pinLink2)) continue;
            this.all.add(pinLink);
            return;
        }
        throw new IllegalArgumentException("not connex");
    }

    public void addAll(PinLinksContinuousSet pinLinksContinuousSet) {
        if (!this.doesTouch(pinLinksContinuousSet)) {
            throw new IllegalArgumentException();
        }
        this.all.addAll(pinLinksContinuousSet.all);
    }

    public boolean doesTouch(PinLink pinLink) {
        for (PinLink pinLink2 : this.all) {
            if (!pinLink.doesTouch(pinLink2)) continue;
            return true;
        }
        return false;
    }

    public boolean doesTouch(PinLinksContinuousSet pinLinksContinuousSet) {
        for (PinLink pinLink : pinLinksContinuousSet.all) {
            if (!this.doesTouch(pinLink)) continue;
            return true;
        }
        return false;
    }
}

