#!/usr/bin/env perl
use strict;
use warnings;
use Data::Dumper;

BEGIN { unshift( @INC, './lib' ) }

BEGIN {
    use Test::Most;
    use_ok('Bio::AutomatedAnnotation::ParseGenesFromGFF');
}

my $obj;

ok(
    $obj = Bio::AutomatedAnnotation::ParseGenesFromGFF->new(
        gff_file     => 't/data/example_annotation.gff',
        search_query => 'yfnB'
    ),
    'initialise obj with all defaults'
);
is( @{ $obj->_matching_features }, 1, 'Should have one matching feature' );
is_deeply( $obj->_matching_features->[0]->get_tag_values('gene'), ('yfnB'),
    'Gene Name should match the input sequence' );
is($obj->_bio_seq_objects->[0]->display_id, 'abc|SC|contig000001_abc_00016', 'Name should be displayed with seq and ID');
is($obj->_bio_seq_objects->[0]->seq, 'TTGGGATATAAAAATATTTTGATAGACTTTGATGATACAATTGTTGATTTTTATGATGCAGAAGAATGGGCGTTTCACTATATGGCGAATGTTTTTAATCATAAAGCAACAAAGGATGATTTTTTAACATTTAAAAAAATCAATCACCAACATTGGGAAGCTTTTCAACAAAATAAATTAACGAAGTCTGAAGTATTATCAGAACGATTTGTGAATTACTTCAAACATCATCAAATGGAAGTTGATGGGCATCGTGCAGATGTGTTATTTAGAAATGGATTAGCAGAAGCTAAAGTTAAATACTTTGATCAAACATTAGAAACAATTGTCGAATTATCGAAAAGACATGATTTATATATTGTTACTAATGGTGTAACCGAAACGCAAAAGAGAAGGTTAAATCAGACGCCGTTGCATAAATATATTAAAAAGATATTTATATCTGAGGAAACAGGATATCAAAAACCTAATCCGGAATTTTTTAATTATGTTTTTAATGATATTGGTGAGGATGAAAGACAGCACTCGATTATAGTTGGAGATTCTTTAACATCTGACATTCTAGGTGGAATCAATGCGGGTATAGCTACTTGCTGGTTTAATTTTAGAGGATTTGATCATAATCCAGGAATTATACCTGATTATGAAATTAATTCATGGAAACAACTAAATGATATTGTACGTTAA', 'subsequence should be displayed');

ok(
    $obj = Bio::AutomatedAnnotation::ParseGenesFromGFF->new(
        gff_file     => 't/data/example_annotation.gff',
        search_query => '16S'
    ),
    'initialise obj with all defaults for 16S'
);
is_deeply( $obj->_matching_features->[0]->get_tag_values('product'),
    ('16S ribosomal RNA'), 'product should be searched as well' );
is($obj->_bio_seq_objects->[0]->display_id, 'abc|SC|contig000001_abc_01705', 'Name should be displayed with seq and ID');
is($obj->_bio_seq_objects->[0]->seq, 'GTGGAAAATACAATTAATGAAAGTGAAAAGAAAAAACGATTTAAATTAAAAATGCCAGGTGCATTTATGATTTTATTCATTTTAACGGTTGTTGCAGTTATAGCAACATGGGTTATTCCTGCTGGTGCATATTCTAAACTTTCTTACGAACCTTCATCCCAAGAACTAAAGATAGTTAACCCTCATAACCAAGTGAAAAAGGTTCCGGGTACGCAACAGGAACTAGACAAAATGGGGGTTAAAATTAAGATTGAACAATTTAAATCAGGTGCAATTAATAAGCCAGTATCAATTCCGAATACTTATGAAAGATTAAAGCAACATCCAGCTGGACCAGAACAAATAACAAGTAGCATGGTTGAAGGTACGATAGAAGCGGTCGATATCATGGTATTCATTCTTGTACTAGGGGGACTTATTGGCGTAGTTCAAGCCAGTGGTTCTTTTGAATCGGGATTGTTAGCTTTAACGAAGAAAACAAAAGGGCATGAATTTATGCTAATTGTGTTTGTATCAATACTAATGATTATCGGCGGGACGTTATGTGGTATTGAAGAAGAAGCTGTAGCATTCTATCCGATTTTAGTCCCTATATTTATAGCGTTAGGATACGATTCTATCGTTTCAGTTGGTGCCATATTCCTTGCCAGCTCTGTCGGTAGTACATTTTCAACTATTAACCCGTTCTCGGTTGTAATTGCCTCTAATGCCGCTGGTACAACTTTTACGGATGGCTTGTATTGGAGAATAGGTGCTTGTATTGTCGGTGCGATTTTTGTTATTAGTTATTTATATTGGTACTGTAAAAAAATTAAAAACGATCCTAAAGCGTCATATTCTTATGAAGACAAAGATGCTTTTGAACAGCAATGGTCTGTATTAAAAGATGACGATAGTGCCCATTTTACTTTGCGTAAGAAGATAATCCTTACATTATTTGTACTACCATTTCCAATTATGGTATGGGGAGTTATGACGCAAGGTTGGTGGTTCCCAGTTATGGCTTCAGCATTTTTAATATTTACAATTATAATAATGTTTATTGCTGGGACAGGTAAATCTGGATTGGGAGAAAAAGGAACTGTAGATGCATTTGTCAATGGTGCATCAAGTTTAGTAGGTGTATCTTTAATTATTGGTTTAGCTCGAGGTATTAATTTAGTGTTGAATGAAGGTATGATTTCAGATACAATCTTACACTTTTCATCATCTTTAGTTCAACATATGAGTGGACCATTATTTATCATCGTATTACTATTTATTTTCTTCTGTTTAGGTTTTATCGTGCCATCATCTTCTGGATTAGCGGTATTATCAATGCCTATCTTTGCACCACTAGCTGATACAGTAGGTATACCAAGATTCGTCATCGTTACGACATATCAATTTGGTCAATATGCGATGTTATTCTTAGCGCCGACTGGACTTGTTATGGCCACACTACAAATGTTAAACATGCGATATTCACATTGGTTCCGATTTGTATGGCCGGTAGTTGCTTTTGTATTGATTTTCGGTGGCGGAGTACTAATTACGCAAGTACTAATTTATTCATAA', 'subsequence should be displayed');



ok(
    $obj = Bio::AutomatedAnnotation::ParseGenesFromGFF->new(
        gff_file     => 't/data/example_annotation.gff',
        search_query => 'hly'
    ),
    'initialise obj with all defaults'
);
is_deeply( $obj->_matching_features->[0]->get_tag_values('gene'), ('hly'),
    'Gene Name should match the input sequence' );
is($obj->_bio_seq_objects->[0]->display_id, 'abc|SC|contig000001_abc_00001', 'Name should be displayed with seq and ID');
is($obj->_bio_seq_objects->[0]->seq, 'ATGAAAACACGTATAGTCAGCTCAGTAACAACAACACTATTGCTAGGTTCCATATTAATGAATCCTGTCGCTAATGCCGCAGATTCTGATATTAATATTAAAACCGGTACTACAGATATTGGAAGCAATACTACAGTAAAAACAGGTGATTTAGTCACTTATGATAAAGAAAATGGCATGCACAAAAAAGTATTTTATAGTTTTATCGATGATAAAAATCACAATAAAAAACTGCTAGTTATTAGAACGAAAGGTACCATTGCTGGTCAATATAGAGTTTATAGCGAAGAAGGTGCTAACAAAAGTGGTTTAGCCTGGCCTTCAGCCTTTAAGGTACAGTTGCAACTACCTGATAATGAAGTAGCTCAAATATCTGATTACTATCCAAGAAATTCGATTGATACAAAAGAGTATATGAGTACTTTAACTTATGGATTCAACGGTAATGTTACTGGTGATGATACAGGAAAAATTGGCGGCCTTATTGGTGCAAATGTTTCGATTGGTCATACACTGAAATATGTTCAACCTGATTTCAAAACAATTTTAGAGAGCCCAACTGATAAAAAAGTAGGCTGGAAAGTGATATTTAACAATATGGTGAATCAAAATTGGGGACCATATGATAGAGATTCTTGGAACCCGGTATATGGCAATCAACTTTTCATGAAAACTAGAAATGGTTCTATGAAAGCAGCAGAGAACTTCCTTGATCCTAACAAAGCAAGTTCTCTATTATCTTCAGGGTTTTCACCAGACTTCGCTACAGTTATTACTATGGATAGAAAAGCATCCAAACAACAAACAAATATAGATGTAATATACGAACGAGTTCGTGATGACTACCAATTGCATTGGACTTCAACAAATTGGAAAGGTACCAATACTAAAGATAAATGGACAGATCGTTCTTCAGAAAGATATAAAATCGATTGGGAAAAAGAAGAAATGACAAATTAA', 'subsequence should be reverse complemented');



ok(
    $obj = Bio::AutomatedAnnotation::ParseGenesFromGFF->new(
        gff_file     => 't/data/example_annotation.gff',
        search_query => 'hypothetical'
    ),
    'initialise obj with all defaults hypothetical'
);
is( @{ $obj->_matching_features }, 5, 'Should have lots of hypothetical proteins ' );



ok(
    $obj = Bio::AutomatedAnnotation::ParseGenesFromGFF->new(
        gff_file     => 't/data/example_annotation.gff',
        search_query => 'nonexistantgenename'
    ),
    'initialise obj with a non existant gene name'
);

is_deeply($obj->_bio_seq_objects, [], 'Nothing should be found');



done_testing();
