use utf8;
package Test2::Harness::UI::Schema::Result::Sweep;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY THE FIRST PART OF THIS FILE

use strict;
use warnings;

use base 'DBIx::Class::Core';
__PACKAGE__->load_components(
  "InflateColumn::DateTime",
  "InflateColumn::Serializer",
  "InflateColumn::Serializer::JSON",
  "Tree::AdjacencyList",
  "UUIDColumns",
);
__PACKAGE__->table("sweeps");
__PACKAGE__->add_columns(
  "sweep_id",
  { data_type => "uuid", is_nullable => 0, size => 16 },
  "run_id",
  { data_type => "uuid", is_foreign_key => 1, is_nullable => 0, size => 16 },
  "name",
  { data_type => "varchar", is_nullable => 0, size => 255 },
);
__PACKAGE__->set_primary_key("sweep_id");
__PACKAGE__->add_unique_constraint("sweeps_name_run_id_key", ["name", "run_id"]);
__PACKAGE__->belongs_to(
  "run",
  "Test2::Harness::UI::Schema::Result::Run",
  { run_id => "run_id" },
  { is_deferrable => 0, on_delete => "NO ACTION", on_update => "NO ACTION" },
);


# Created by DBIx::Class::Schema::Loader v0.07049 @ 2023-02-15 17:15:56
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:EOaaWk5g68oev4/djRgACA


# You can replace this text with custom code or comments, and it will be preserved on regeneration
1;
