use utf8;
use strict;

use open qw(:std :utf8);
use Test::More 'no_plan';
use lib 't/lib';

use TreePath;

#       /
#       |
#       A
#      / \
#     B   F
#    /   / \
#   C   G   E
#  / \
# D   E
#
# nodes type1 : /, A, B, C, D, E
# nodes type2 : F, G, E (second E)
#

my $simpletree = {
                  '1' => {
                          type => 'type1',
                          parent => '0',
                          name => '/'},
                  '2' => {
                          type => 'type1',
                          parent => '1',
                          name => 'A'},
                  '3' => {
                          type => 'type1',
                          parent => '2',
                          name => 'B'},
                  '4' => {
                          type => 'type1',
                          parent => '3',
                          name => 'C'},
                  '5' => {
                          type => 'type1',
                          parent => '4',
                          name => 'D',
                          position => 1},
                  '6' => {
                          type => 'type1',
                          parent => '4',
                          name => 'E'},
                  '7' => {
                          type => 'type2',
                          parent => '2',
                          name => 'F'},
                  '8' => {
                          type => 'type2',
                          parent => '7',
                          name => 'G',
                         },
                  '9' => {
                          type => 'type2',
                          parent => '7',
                          name => 'H'},
                 };


ok( my $tp = TreePath->new(  conf  => $simpletree  ),
    "New TreePath ( conf => $simpletree)");

my $tree = $tp->tree;
isa_ok($tree, 'HASH');

my $root = $tp->root;
is($root,$tree->{1}, 'retrieve root');
isa_ok($root, 'HASH', "root" );

# search --------------------------
ok( my $A = $tp->search( { name => 'A' } ), 'A found');
is($A->{type}, 'type1', 'type of A is type1');

is(@{$A->{children}}, 1, 'A has only one child with same type as him');

is(@{$A->{children_type2}}, 1, 'but  has also a son with type2');

ok( my $F = $tp->search( { name => 'F' } ), 'F found');
is(@{$F->{children}}, 2, 'F has two children');
is(@{$F->{children}}[0]->{type}, 'type2', 'first child has type type2');
