######################################################################
#
# 5102_jef_by_letsj_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x20\x20",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],
        ["\xA1\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x20\x20"],

        ["\xA1\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],
        ["\xA1\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],

        ["\xA1\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],
        ["\xA1\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],

        ["\xA1\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],
        ["\xA1\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],

        ["\xA1\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],
        ["\xA1\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],

        ["\xA1\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],
        ["\xA1\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],

        ["\xA1\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],
        ["\xA1\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],

        ["\xA1\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],
        ["\xA1\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],

        ["\xA1\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],
        ["\xA1\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],

        ["\xA1\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],
        ["\xA1\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],

        ["\xA1\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],
        ["\xA1\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],

        ["\xA1\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],
        ["\xA1\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],

        ["\xA1\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],
        ["\xA1\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],

        ["\xA1\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],
        ["\xA1\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],

        ["\xA1\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],
        ["\xA1\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],

        ["\xA1\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],
        ["\xA1\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],

        ["\xA1\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],
        ["\xA1\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],

        ["\xA1\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],
        ["\xA1\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],

        ["\xA1\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],
        ["\xA1\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],

        ["\xA1\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],
        ["\xA1\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],

        ["\xA1\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],
        ["\xA1\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],

        ["\xA1\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],
        ["\xA1\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],

        ["\xA1\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],
        ["\xA1\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],

        ["\xA1\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],
        ["\xA1\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],

        ["\xA1\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],
        ["\xA1\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],

        ["\xA1\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],
        ["\xA1\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],

        ["\xA1\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],
        ["\xA1\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],

        ["\xA1\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],
        ["\xA1\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],

        ["\xA1\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],
        ["\xA1\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],

        ["\xA1\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],
        ["\xA1\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],

        ["\xA1\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],
        ["\xA1\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],

        ["\x31\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],
        ["\xA1\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA1"],

        ["\xA1\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],
        ["\xA1\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],

        ["\x31\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],
        ["\xA1\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA2"],

        ["\xA1\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],
        ["\xA1\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],

        ["\xA1\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],
        ["\xA1\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],

        ["\xA1\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],
        ["\xA1\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],

        ["\xA1\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],
        ["\xA1\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],

        ["\xA1\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],
        ["\xA1\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],

        ["\xA1\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],
        ["\xA1\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],

        ["\xA1\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],
        ["\xA1\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],

        ["\xA1\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],
        ["\xA1\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],

        ["\xA1\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],
        ["\xA1\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],

        ["\xA1\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],
        ["\xA1\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],

        ["\xA1\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],
        ["\xA1\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],

        ["\xA1\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],
        ["\xA1\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],

        ["\xA1\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],
        ["\xA1\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],

        ["\xA1\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],
        ["\xA1\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],

        ["\xA1\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],
        ["\xA1\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],

        ["\xA1\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],
        ["\xA1\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],

        ["\xA1\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],
        ["\xA1\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],

        ["\xA1\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],
        ["\xA1\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],

        ["\xA1\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],
        ["\xA1\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],

        ["\xA1\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],
        ["\xA1\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],

        ["\xA1\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],
        ["\xA1\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],

        ["\xA1\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],
        ["\xA1\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],

        ["\xA1\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],
        ["\xA1\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],

        ["\xA1\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],
        ["\xA1\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],

        ["\xA1\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],
        ["\xA1\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],

        ["\xA1\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],
        ["\xA1\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],

        ["\x31\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],
        ["\xA1\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA3"],

        ["\xA1\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],
        ["\xA1\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],

        ["\xA1\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],
        ["\xA1\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],

        ["\xA1\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],
        ["\xA1\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],

        ["\xA1\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],
        ["\xA1\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],

        ["\xA1\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],
        ["\xA1\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],

        ["\xA1\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],
        ["\xA1\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],

        ["\xA1\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],
        ["\xA1\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],

        ["\xA1\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],
        ["\xA1\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],

        ["\xA1\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],
        ["\xA1\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],

        ["\xA1\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],
        ["\xA1\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],

        ["\xA1\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],
        ["\xA1\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],

        ["\xA1\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],
        ["\xA1\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],

        ["\xA1\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],
        ["\xA1\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],

        ["\xA1\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],
        ["\xA1\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],

        ["\xA1\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],
        ["\xA1\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],

        ["\xA1\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],
        ["\xA1\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],

        ["\xA1\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],
        ["\xA1\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],

        ["\xA1\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],
        ["\xA1\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],

        ["\xA1\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],
        ["\xA1\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],

        ["\x31\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],
        ["\xA1\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA4"],

        ["\x31\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],
        ["\xA1\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA5"],

        ["\xA1\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],
        ["\xA1\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],

        ["\xA1\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],
        ["\xA1\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],

        ["\xA1\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],
        ["\xA1\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],

        ["\xA1\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],
        ["\xA1\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],

        ["\xA1\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],
        ["\xA1\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],

        ["\xA1\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],
        ["\xA1\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],

        ["\xA1\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],
        ["\xA1\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],

        ["\xA1\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],
        ["\xA1\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],

        ["\xA1\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],
        ["\xA1\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],

        ["\xA1\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],
        ["\xA1\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],

        ["\xA1\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],
        ["\xA1\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],

        ["\xA1\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],
        ["\xA1\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],

        ["\xA2\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],
        ["\xA2\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],

        ["\xA2\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\xA2\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],

        ["\xA2\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\xA2\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],

        ["\xA2\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],
        ["\xA2\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],

        ["\xA2\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],
        ["\xA2\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],

        ["\xA2\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],
        ["\xA2\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],

        ["\xA2\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\xA2\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],

        ["\xA2\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\xA2\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],

        ["\xA2\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\xA2\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],

        ["\xA2\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\xA2\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],

        ["\xA2\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],
        ["\xA2\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],

        ["\xA2\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\xA2\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],

        ["\xA2\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],
        ["\xA2\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],

        ["\xA2\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xA2\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],

        ["\xA2\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD0"],
        ["\x7F\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],

        ["\xA2\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD1"],
        ["\x7F\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],

        ["\xA2\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD2"],
        ["\x7F\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],

        ["\xA2\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD3"],
        ["\x7F\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],

        ["\xA2\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD4"],
        ["\x7F\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],

        ["\xA2\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD5"],
        ["\x7F\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],

        ["\xA2\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD6"],
        ["\x7F\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],

        ["\xA2\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD7"],
        ["\x7F\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],

        ["\xA2\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD8"],
        ["\x7F\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],

        ["\xA2\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xD9"],
        ["\x7F\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],

        ["\x31\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA7"],
        ["\x76\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA6"],

        ["\xA2\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xDA"],
        ["\x7F\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],

        ["\xA2\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xDB"],
        ["\x7F\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],

        ["\xA2\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xDC"],
        ["\x7F\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],

        ["\xA2\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xDD"],
        ["\x7F\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],

        ["\xA2\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xDE"],
        ["\x7F\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],

        ["\xA2\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xDF"],
        ["\x7F\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],

        ["\xA2\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE0"],
        ["\x7F\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],

        ["\xA2\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE1"],
        ["\x7F\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],

        ["\xA2\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE2"],
        ["\x7F\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],

        ["\xA2\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xAA"],
        ["\x76\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],

        ["\xA2\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA9"],
        ["\x76\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],

        ["\xA2\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE3"],
        ["\x7F\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],

        ["\xA2\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE4"],
        ["\x7F\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],

        ["\xA2\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE5"],
        ["\x7F\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],

        ["\xA2\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE6"],
        ["\x7F\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],

        ["\xA2\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE7"],
        ["\x7F\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],

        ["\xA2\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA8"],
        ["\x76\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],

        ["\xA2\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE8"],
        ["\x7F\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],

        ["\xA2\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xE9"],
        ["\x7F\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],

        ["\xA2\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD1"],
        ["\x76\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],

        ["\xA2\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD3"],
        ["\x76\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],

        ["\xA2\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xEA"],
        ["\x7F\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],

        ["\xA2\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xEB"],
        ["\x7F\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],

        ["\xA2\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xEC"],
        ["\x7F\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],

        ["\xA2\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xED"],
        ["\x7F\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],

        ["\xA2\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xEE"],
        ["\x7F\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],

        ["\xA2\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xEF"],
        ["\x7F\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],

        ["\xA2\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xF0"],
        ["\x7F\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],

        ["\xA3\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],
        ["\xA3\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],

        ["\xA3\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],
        ["\xA3\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],

        ["\xA3\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],
        ["\xA3\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],

        ["\xA3\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],
        ["\xA3\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],

        ["\xA3\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\xA3\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],

        ["\xA3\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\xA3\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],

        ["\xA3\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\xA3\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],

        ["\xA3\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],
        ["\xA3\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],

        ["\xA3\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],
        ["\xA3\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],

        ["\xA3\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],
        ["\xA3\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],

        ["\xA3\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],
        ["\xA3\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],

        ["\xA3\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],
        ["\xA3\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],

        ["\xA3\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],
        ["\xA3\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],

        ["\xA3\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],
        ["\xA3\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],

        ["\xA3\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],
        ["\xA3\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],

        ["\xA3\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],
        ["\xA3\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],

        ["\xA3\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],
        ["\xA3\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],

        ["\xA3\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],
        ["\xA3\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],

        ["\xA3\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],
        ["\xA3\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],

        ["\xA3\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],
        ["\xA3\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],

        ["\xA3\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],
        ["\xA3\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],

        ["\xA3\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\xA3\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],

        ["\xA3\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\xA3\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],

        ["\xA3\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\xA3\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],

        ["\xA3\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\xA3\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],

        ["\xA3\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],
        ["\xA3\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],

        ["\xA3\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],
        ["\xA3\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],

        ["\xA3\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],
        ["\xA3\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],

        ["\xA3\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],
        ["\xA3\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],

        ["\xA3\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],
        ["\xA3\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],

        ["\xA3\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],
        ["\xA3\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],

        ["\xA3\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],
        ["\xA3\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],

        ["\xA3\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],
        ["\xA3\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],

        ["\xA3\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],
        ["\xA3\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],

        ["\xA3\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],
        ["\xA3\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],

        ["\xA3\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],
        ["\xA3\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],

        ["\xA3\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],
        ["\xA3\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],

        ["\xA3\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],
        ["\xA3\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],

        ["\xA3\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],
        ["\xA3\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],

        ["\xA3\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],
        ["\xA3\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],

        ["\xA3\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],
        ["\xA3\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],

        ["\xA3\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],
        ["\xA3\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],

        ["\xA3\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],
        ["\xA3\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],

        ["\xA3\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],
        ["\xA3\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],

        ["\xA3\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],
        ["\xA3\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],

        ["\xA3\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],
        ["\xA3\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],

        ["\xA3\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\xA3\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],

        ["\xA3\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\xA3\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],

        ["\xA3\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\xA3\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],

        ["\xA3\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\xA3\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],

        ["\xA3\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],
        ["\xA3\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],

        ["\xA3\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],
        ["\xA3\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],

        ["\xA3\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],
        ["\xA3\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],

        ["\xA3\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],
        ["\xA3\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],

        ["\xA3\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],
        ["\xA3\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],

        ["\xA3\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],
        ["\xA3\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],

        ["\xA3\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],
        ["\xA3\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],

        ["\xA3\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],
        ["\xA3\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],

        ["\xA3\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],
        ["\xA3\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],

        ["\xA3\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],
        ["\xA3\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],

        ["\xA3\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\xA3\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],

        ["\xA3\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xA3\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],

        ["\xA4\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],
        ["\xA4\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],

        ["\xA4\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],
        ["\xA4\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],

        ["\xA4\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],
        ["\xA4\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],

        ["\xA4\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],
        ["\xA4\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],

        ["\xA4\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\xA4\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],

        ["\xA4\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\xA4\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],

        ["\xA4\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\xA4\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],

        ["\xA4\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],
        ["\xA4\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],

        ["\xA4\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],
        ["\xA4\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],

        ["\xA4\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],
        ["\xA4\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],

        ["\xA4\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],
        ["\xA4\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],

        ["\xA4\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\xA4\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],

        ["\xA4\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],
        ["\xA4\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],

        ["\xA4\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],
        ["\xA4\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],

        ["\xA4\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],
        ["\xA4\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],

        ["\xA4\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],
        ["\xA4\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],

        ["\xA4\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],
        ["\xA4\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],

        ["\xA4\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],
        ["\xA4\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],

        ["\xA4\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],
        ["\xA4\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],

        ["\xA4\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],
        ["\xA4\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],

        ["\xA4\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\xA4\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],

        ["\xA4\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],
        ["\xA4\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],

        ["\xA4\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],
        ["\xA4\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],

        ["\xA4\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\xA4\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],

        ["\xA4\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],
        ["\xA4\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],

        ["\xA4\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],
        ["\xA4\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],

        ["\xA4\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xA4\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],

        ["\xA4\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],
        ["\xA4\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],

        ["\xA4\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],
        ["\xA4\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],

        ["\xA4\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xA4\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],

        ["\xA4\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],
        ["\xA4\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],

        ["\xA4\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],
        ["\xA4\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],

        ["\xA4\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],
        ["\xA4\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],

        ["\xA4\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],
        ["\xA4\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],

        ["\xA4\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],
        ["\xA4\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],

        ["\xA4\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],
        ["\xA4\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],

        ["\xA4\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],
        ["\xA4\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],

        ["\xA4\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],
        ["\xA4\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],

        ["\xA4\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],
        ["\xA4\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],

        ["\xA4\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],
        ["\xA4\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],

        ["\xA4\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],
        ["\xA4\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],

        ["\xA4\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\xA4\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],

        ["\xA4\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],
        ["\xA4\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],

        ["\xA4\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],
        ["\xA4\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],

        ["\xA4\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],
        ["\xA4\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],

        ["\xA4\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\xA4\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],

        ["\xA4\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],
        ["\xA4\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],

        ["\xA4\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],
        ["\xA4\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],

        ["\xA4\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],
        ["\xA4\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],

        ["\xA4\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],
        ["\xA4\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],

        ["\xA4\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],
        ["\xA4\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],

        ["\xA4\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],
        ["\xA4\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],

        ["\xA4\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],
        ["\xA4\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],

        ["\xA4\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],
        ["\xA4\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],

        ["\xA4\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],
        ["\xA4\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],

        ["\xA4\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],
        ["\xA4\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],

        ["\xA4\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],
        ["\xA4\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],

        ["\xA4\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],
        ["\xA4\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],

        ["\xA4\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],
        ["\xA4\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],

        ["\xA4\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],
        ["\xA4\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],

        ["\xA4\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\xA4\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],

        ["\xA4\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],
        ["\xA4\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],

        ["\xA4\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xA4\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],

        ["\xA4\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],
        ["\xA4\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],

        ["\xA4\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],
        ["\xA4\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],

        ["\xA4\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],
        ["\xA4\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],

        ["\xA4\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],
        ["\xA4\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],

        ["\xA4\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],
        ["\xA4\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],

        ["\xA4\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],
        ["\xA4\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],

        ["\xA4\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],
        ["\xA4\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],

        ["\xA4\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],
        ["\xA4\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],

        ["\xA4\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],
        ["\xA4\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],

        ["\xA4\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],
        ["\xA4\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],

        ["\xA4\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],
        ["\xA4\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],

        ["\xA4\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],
        ["\xA4\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],

        ["\xA4\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],
        ["\xA4\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],

        ["\xA4\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],
        ["\xA4\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],

        ["\xA4\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],
        ["\xA4\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],

        ["\xA4\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],
        ["\xA4\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],

        ["\xA4\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],
        ["\xA4\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],

        ["\xA4\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],
        ["\xA4\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],

        ["\xA4\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],
        ["\xA4\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],

        ["\xA4\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],
        ["\xA4\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],

        ["\xA5\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],
        ["\xA5\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],

        ["\xA5\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\xA5\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],

        ["\xA5\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],
        ["\xA5\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],

        ["\xA5\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],
        ["\xA5\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],

        ["\xA5\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],
        ["\xA5\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],

        ["\xA5\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],
        ["\xA5\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],

        ["\xA5\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],
        ["\xA5\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],

        ["\xA5\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],
        ["\xA5\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],

        ["\xA5\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\xA5\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],

        ["\xA5\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],
        ["\xA5\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],

        ["\xA5\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],
        ["\xA5\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],

        ["\xA5\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],
        ["\xA5\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],

        ["\xA5\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],
        ["\xA5\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],

        ["\xA5\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\xA5\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],

        ["\xA5\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],
        ["\xA5\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],

        ["\xA5\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],
        ["\xA5\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],

        ["\xA5\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],
        ["\xA5\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],

        ["\xA5\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],
        ["\xA5\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],

        ["\xA5\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],
        ["\xA5\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],

        ["\xA5\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\xA5\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],

        ["\xA5\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],
        ["\xA5\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],

        ["\xA5\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],
        ["\xA5\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],

        ["\xA5\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],
        ["\xA5\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],

        ["\xA5\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],
        ["\xA5\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],

        ["\xA5\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],
        ["\xA5\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],

        ["\xA5\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],
        ["\xA5\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],

        ["\xA5\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],
        ["\xA5\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],

        ["\xA5\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],
        ["\xA5\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],

        ["\xA5\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],
        ["\xA5\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],

        ["\xA5\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],
        ["\xA5\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],

        ["\xA5\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],
        ["\xA5\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],

        ["\xA5\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],
        ["\xA5\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],

        ["\xA5\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],
        ["\xA5\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],

        ["\xA5\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],
        ["\xA5\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],

        ["\xA5\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],
        ["\xA5\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],

        ["\xA5\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],
        ["\xA5\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],

        ["\xA5\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],
        ["\xA5\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],

        ["\xA5\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],
        ["\xA5\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],

        ["\xA5\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],
        ["\xA5\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],

        ["\xA5\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],
        ["\xA5\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],

        ["\xA5\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],
        ["\xA5\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],

        ["\xA5\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xA5\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],

        ["\xA5\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\xA5\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],

        ["\xA5\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\xA5\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],

        ["\xA5\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],
        ["\xA5\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],

        ["\xA5\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\xA5\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],

        ["\xA5\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\xA5\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],

        ["\xA5\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\xA5\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],

        ["\xA5\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\xA5\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],

        ["\xA5\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\xA5\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],

        ["\xA5\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\xA5\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],

        ["\xA5\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\xA5\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],

        ["\xA5\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\xA5\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],

        ["\xA5\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],
        ["\xA5\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],

        ["\xA5\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],
        ["\xA5\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],

        ["\xA5\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],
        ["\xA5\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],

        ["\xA5\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],
        ["\xA5\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],

        ["\xA5\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],
        ["\xA5\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],

        ["\xA5\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\xA5\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],

        ["\xA5\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xA5\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],

        ["\xA5\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\xA5\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],

        ["\xA5\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\xA5\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],

        ["\xA5\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\xA5\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],

        ["\xA5\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],
        ["\xA5\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],

        ["\xA5\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\xA5\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],

        ["\xA5\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\xA5\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],

        ["\xA5\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],
        ["\xA5\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],

        ["\xA5\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],
        ["\xA5\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],

        ["\xA5\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],
        ["\xA5\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],

        ["\xA5\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],
        ["\xA5\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],

        ["\xA5\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\xA5\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],

        ["\xA5\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\xA5\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],

        ["\xA5\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],
        ["\xA5\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],

        ["\xA5\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\xA5\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],

        ["\xA5\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],
        ["\xA5\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],

        ["\xA5\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],
        ["\xA5\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],

        ["\xA5\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],
        ["\xA5\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],

        ["\xA5\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xA5\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],

        ["\xA5\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xA5\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],

        ["\xA5\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\xA5\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],

        ["\xA5\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],
        ["\xA5\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],

        ["\xA5\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],
        ["\xA5\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],

        ["\xA5\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],
        ["\xA5\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],

        ["\xA5\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],
        ["\xA5\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],

        ["\xA5\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],
        ["\xA5\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],

        ["\xA5\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],
        ["\xA5\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],

        ["\xA6\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],
        ["\xA6\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],

        ["\xA6\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],
        ["\xA6\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],

        ["\xA6\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],
        ["\xA6\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],

        ["\xA6\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],
        ["\xA6\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],

        ["\xA6\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],
        ["\xA6\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],

        ["\xA6\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\xA6\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],

        ["\xA6\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\xA6\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],

        ["\xA6\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\xA6\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],

        ["\xA6\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\xA6\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],

        ["\xA6\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\xA6\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],

        ["\xA6\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],
        ["\xA6\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],

        ["\xA6\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\xA6\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],

        ["\xA6\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],
        ["\xA6\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],

        ["\xA6\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],
        ["\xA6\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],

        ["\xA6\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\xA6\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],

        ["\xA6\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],
        ["\xA6\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],

        ["\xA6\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],
        ["\xA6\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],

        ["\xA6\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],
        ["\xA6\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],

        ["\xA6\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],
        ["\xA6\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],

        ["\xA6\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\xA6\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],

        ["\xA6\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],
        ["\xA6\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],

        ["\xA6\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\xA6\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],

        ["\xA6\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],
        ["\xA6\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],

        ["\xA6\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\xA6\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],

        ["\xA6\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],
        ["\xA6\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],

        ["\xA6\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],
        ["\xA6\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],

        ["\xA6\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],
        ["\xA6\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],

        ["\xA6\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],
        ["\xA6\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],

        ["\xA6\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],
        ["\xA6\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],

        ["\xA6\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],
        ["\xA6\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],

        ["\xA6\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],
        ["\xA6\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],

        ["\xA6\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],
        ["\xA6\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],

        ["\xA6\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],
        ["\xA6\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],

        ["\xA6\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],
        ["\xA6\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],

        ["\xA6\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],
        ["\xA6\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],

        ["\xA6\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],
        ["\xA6\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],

        ["\xA6\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\xA6\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],

        ["\xA6\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],
        ["\xA6\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],

        ["\xA6\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\xA6\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],

        ["\xA6\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],
        ["\xA6\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],

        ["\xA6\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],
        ["\xA6\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],

        ["\xA6\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],
        ["\xA6\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],

        ["\xA6\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],
        ["\xA6\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],

        ["\xA6\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],
        ["\xA6\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],

        ["\xA6\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],
        ["\xA6\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],

        ["\xA6\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],
        ["\xA6\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],

        ["\xA6\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],
        ["\xA6\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],

        ["\xA6\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],
        ["\xA6\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],

        ["\xA7\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],
        ["\xA7\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],

        ["\xA7\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],
        ["\xA7\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],

        ["\xA7\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],
        ["\xA7\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],

        ["\xA7\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],
        ["\xA7\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],

        ["\xA7\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],
        ["\xA7\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],

        ["\xA7\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\xA7\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],

        ["\xA7\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],
        ["\xA7\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],

        ["\xA7\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\xA7\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],

        ["\xA7\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],
        ["\xA7\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],

        ["\xA7\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],
        ["\xA7\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],

        ["\xA7\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],
        ["\xA7\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],

        ["\xA7\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],
        ["\xA7\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],

        ["\xA7\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],
        ["\xA7\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],

        ["\xA7\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\xA7\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],

        ["\xA7\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],
        ["\xA7\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],

        ["\xA7\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],
        ["\xA7\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],

        ["\xA7\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],
        ["\xA7\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],

        ["\xA7\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],
        ["\xA7\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],

        ["\xA7\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],
        ["\xA7\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],

        ["\xA7\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],
        ["\xA7\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],

        ["\xA7\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],
        ["\xA7\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],

        ["\xA7\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],
        ["\xA7\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],

        ["\xA7\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],
        ["\xA7\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],

        ["\xA7\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],
        ["\xA7\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],

        ["\xA7\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\xA7\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],

        ["\xA7\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\xA7\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],

        ["\xA7\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],
        ["\xA7\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],

        ["\xA7\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],
        ["\xA7\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],

        ["\xA7\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],
        ["\xA7\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],

        ["\xA7\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],
        ["\xA7\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],

        ["\xA7\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\xA7\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],

        ["\xA7\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],
        ["\xA7\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],

        ["\xA7\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],
        ["\xA7\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],

        ["\xA7\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],
        ["\xA7\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],

        ["\xA7\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],
        ["\xA7\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],

        ["\xA7\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],
        ["\xA7\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],

        ["\xA7\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],
        ["\xA7\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],

        ["\xA7\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],
        ["\xA7\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],

        ["\xA7\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],
        ["\xA7\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],

        ["\xA7\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],
        ["\xA7\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],

        ["\xA7\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],
        ["\xA7\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],

        ["\xA7\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],
        ["\xA7\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],

        ["\xA7\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\xA7\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],

        ["\xA7\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],
        ["\xA7\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],

        ["\xA7\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],
        ["\xA7\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],

        ["\xA7\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],
        ["\xA7\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],

        ["\xA7\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\xA7\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],

        ["\xA7\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\xA7\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],

        ["\xA7\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],
        ["\xA7\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],

        ["\xA7\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],
        ["\xA7\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],

        ["\xA7\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],
        ["\xA7\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],

        ["\xA7\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],
        ["\xA7\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],

        ["\xA7\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],
        ["\xA7\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],

        ["\xA7\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],
        ["\xA7\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],

        ["\xA7\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],
        ["\xA7\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],

        ["\xA7\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],
        ["\xA7\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],

        ["\xA7\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],
        ["\xA7\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],

        ["\xA7\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],
        ["\xA7\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],

        ["\xA7\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\xA7\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],

        ["\xA7\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],
        ["\xA7\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],

        ["\xA7\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],
        ["\xA7\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],

        ["\xA7\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\xA7\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],

        ["\xA7\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\xA7\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],

        ["\xA7\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],
        ["\xA7\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],

        ["\xA7\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],
        ["\xA7\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],

        ["\xA7\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],
        ["\xA7\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],

        ["\xA8\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD1"],
        ["\x7C\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"],

        ["\xA8\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xD2"],
        ["\x7C\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],

        ["\xA8\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC1"],
        ["\x7C\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"],

        ["\xA8\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC2"],
        ["\x7C\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"],

        ["\xA8\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC3"],
        ["\x7C\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"],

        ["\xA8\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC4"],
        ["\x7C\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"],

        ["\xA8\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC7"],
        ["\x7C\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"],

        ["\xA8\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC5"],
        ["\x7C\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"],

        ["\xA8\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC8"],
        ["\x7C\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],

        ["\xA8\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC6"],
        ["\x7C\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],

        ["\xA8\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC9"],
        ["\x7C\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"],

        ["\xA8\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF6"],
        ["\x7C\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"],

        ["\xA8\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF7"],
        ["\x7C\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],

        ["\xA8\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE6"],
        ["\x7C\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],

        ["\xA8\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE7"],
        ["\x7C\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],

        ["\xA8\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE8"],
        ["\x7C\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"],

        ["\xA8\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xE9"],
        ["\x7C\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"],

        ["\xA8\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF3"],
        ["\x7C\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"],

        ["\xA8\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF1"],
        ["\x7C\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],

        ["\xA8\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF4"],
        ["\x7C\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],

        ["\xA8\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF2"],
        ["\x7C\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],

        ["\xA8\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xF5"],
        ["\x7C\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"],

        ["\xA8\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xCA"],
        ["\x7C\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],

        ["\xA8\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xCB"],
        ["\x7C\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],

        ["\xA8\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xCC"],
        ["\x7C\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],

        ["\xA8\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xC0"],
        ["\x7C\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],

        ["\xA8\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xCE"],
        ["\x7C\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],

        ["\xA8\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xA2"],
        ["\x7F\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],

        ["\xA8\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xA3"],
        ["\x7F\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],

        ["\xA8\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xA4"],
        ["\x7F\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],

        ["\xA8\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7F\xA1"],
        ["\x7F\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],

        ["\xA8\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x7C\xCD"],
        ["\x7C\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],

        ["\x31\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xC9"],
        ["\x77\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA7"],

        ["\x31\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xCA"],
        ["\x77\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA8"],

        ["\x31\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xCB"],
        ["\x77\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xA9"],

        ["\x31\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xCC"],
        ["\x77\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xAA"],

        ["\x31\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xCD"],
        ["\x77\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xAB"],

        ["\x31\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xCE"],
        ["\x77\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xAC"],

        ["\x31\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xCF"],
        ["\x77\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xAD"],

        ["\x31\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD0"],
        ["\x77\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xAE"],

        ["\x31\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD1"],
        ["\x77\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xAF"],

        ["\x31\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD2"],
        ["\x77\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB0"],

        ["\x31\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD3"],
        ["\x77\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB1"],

        ["\x31\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"],
        ["\x77\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB2"],

        ["\x31\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD5"],
        ["\x77\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB3"],

        ["\x31\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD6"],
        ["\x77\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB4"],

        ["\x31\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD7"],
        ["\x77\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB5"],

        ["\x31\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD8"],
        ["\x77\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB6"],

        ["\x31\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xD9"],
        ["\x77\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB7"],

        ["\x31\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xDA"],
        ["\x77\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB8"],

        ["\x31\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xDB"],
        ["\x77\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xB9"],

        ["\x31\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xDC"],
        ["\x77\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xBA"],

        ["\x31\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xDE"],
        ["\x77\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xBB"],

        ["\x31\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xDF"],
        ["\x77\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xBC"],

        ["\x31\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE0"],
        ["\x77\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xBD"],

        ["\x31\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE1"],
        ["\x77\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xBE"],

        ["\x31\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE2"],
        ["\x77\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xBF"],

        ["\x31\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE3"],
        ["\x77\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC0"],

        ["\x31\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE4"],
        ["\x77\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC1"],

        ["\x31\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE5"],
        ["\x77\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC2"],

        ["\x31\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE6"],
        ["\x77\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC3"],

        ["\x31\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xE7"],
        ["\x77\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC4"],

        ["\x31\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xDA"],
        ["\x76\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC5"],

        ["\x31\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xDC"],
        ["\x76\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC6"],

        ["\x31\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xDB"],
        ["\x76\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC7"],

        ["\x31\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xD9"],
        ["\x76\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC8"],

        ["\x31\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xDE"],
        ["\x76\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xC9"],

        ["\x31\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE0"],
        ["\x76\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xCA"],

        ["\x31\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE1"],
        ["\x76\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xCB"],

        ["\x31\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],
        ["\x76\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xCC"],

        ["\x31\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA1"],
        ["\x80\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xCD"],

        ["\x31\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],
        ["\x76\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xCE"],

        ["\x31\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],
        ["\x76\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xCF"],

        ["\x31\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],
        ["\x76\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD0"],

        ["\x31\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],
        ["\x76\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD1"],

        ["\x31\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],
        ["\x76\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD2"],

        ["\x31\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],
        ["\x76\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD3"],

        ["\x31\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xEB"],
        ["\x76\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD4"],

        ["\x31\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xBC"],
        ["\x76\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD5"],

        ["\x31\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xBD"],
        ["\x76\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD6"],

        ["\x31\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xBE"],
        ["\x76\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD7"],

        ["\x31\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC4"],
        ["\x76\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD8"],

        ["\x31\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC5"],
        ["\x76\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xD9"],

        ["\x31\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC6"],
        ["\x76\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xDA"],

        ["\x31\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xC0"],
        ["\x76\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xDB"],

        ["\x31\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA2"],
        ["\x80\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xDC"],

        ["\x31\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA3"],
        ["\x80\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xDD"],

        ["\x31\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA4"],
        ["\x80\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xDE"],

        ["\xA2\x71",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xFA"],
        ["\x76\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xA2\x71"],

        ["\x31\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],
        ["\x76\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xDF"],

        ["\x31\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],
        ["\x76\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE0"],

        ["\x31\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA5"],
        ["\x80\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE1"],

        ["\x31\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA6"],
        ["\x80\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE2"],

        ["\x31\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA7"],
        ["\x80\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE3"],

        ["\x31\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA8"],
        ["\x80\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE4"],

        ["\x31\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xA9"],
        ["\x80\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE5"],

        ["\x31\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xD5"],
        ["\x78\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE6"],

        ["\x31\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xCF"],
        ["\x78\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE7"],

        ["\x31\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x78\xCB"],
        ["\x78\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE8"],

        ["\x31\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xAA"],
        ["\x80\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xE9"],

        ["\x31\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xAB"],
        ["\x80\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xEA"],

        ["\x31\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xAC"],
        ["\x80\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xEB"],

        ["\x31\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xAD"],
        ["\x80\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xEC"],

        ["\x31\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xAE"],
        ["\x80\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xED"],

        ["\x31\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xAF"],
        ["\x80\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xEE"],

        ["\x31\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x80\xB0"],
        ["\x80\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xEF"],

        ["\xB0\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],
        ["\xB0\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],

        ["\xB0\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],
        ["\xB0\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],

        ["\xB0\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],
        ["\xB0\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],

        ["\xB0\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],
        ["\xB0\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],

        ["\xB0\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],
        ["\xB0\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],

        ["\xB0\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],
        ["\xB0\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],

        ["\xB0\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],
        ["\xB0\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],

        ["\xB0\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],
        ["\xB0\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],

        ["\xB0\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],
        ["\xB0\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],

        ["\xB0\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],
        ["\xB0\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],

        ["\xB0\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],
        ["\xB0\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],

        ["\xB0\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],
        ["\xB0\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],

        ["\xB0\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],
        ["\xB0\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],

        ["\xB0\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],
        ["\xB0\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],

        ["\xB0\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],
        ["\xB0\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],

        ["\xB0\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],
        ["\xB0\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],

        ["\xB0\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],
        ["\xB0\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],

        ["\xB0\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],
        ["\xB0\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],

        ["\xB0\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\xF2\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],

        ["\xB0\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],
        ["\xB0\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],

        ["\xB0\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],
        ["\xB0\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],

        ["\xB0\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],
        ["\xB0\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],

        ["\xB0\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],
        ["\xB0\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],

        ["\xB0\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],
        ["\xB0\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],

        ["\xB0\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],
        ["\xB0\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],

        ["\xB0\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],
        ["\xB0\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],

        ["\xB0\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],
        ["\xB0\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],

        ["\xB0\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],
        ["\xB0\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],

        ["\xB0\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],
        ["\xB0\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],

        ["\xB0\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],
        ["\xB0\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],

        ["\xB0\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],
        ["\xB0\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],

        ["\xB0\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],
        ["\xB0\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],

        ["\xB0\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],
        ["\xB0\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],

        ["\xB0\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],
        ["\xB0\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],

        ["\xB0\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],
        ["\xB0\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],

        ["\xB0\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],
        ["\xB0\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],

        ["\xB0\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],
        ["\xB0\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],

        ["\xB0\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],
        ["\xB0\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],

        ["\xB0\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],
        ["\xB0\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],

        ["\xB0\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],
        ["\xB0\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],

        ["\xB0\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],
        ["\xB0\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],

        ["\xB0\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],
        ["\xB0\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],

        ["\xB0\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],
        ["\xB0\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],

        ["\xB0\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],
        ["\xB0\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],

        ["\xB0\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],
        ["\xB0\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],

        ["\xB0\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],
        ["\xB0\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],

        ["\xB0\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],
        ["\xB0\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],

        ["\xB0\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],
        ["\xB0\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],

        ["\xB0\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],
        ["\xB0\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],

        ["\xB0\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],
        ["\xB0\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],

        ["\xB0\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],
        ["\xB0\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],

        ["\xB0\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],
        ["\xB0\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],

        ["\xB0\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],
        ["\xB0\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],

        ["\xB0\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],
        ["\xB0\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],

        ["\xB0\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],
        ["\xB0\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],

        ["\xB0\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],
        ["\xB0\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],

        ["\xB0\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],
        ["\xB0\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],

        ["\xB0\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],
        ["\xB0\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],

        ["\xB0\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],
        ["\xB0\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],

        ["\xB0\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],
        ["\xB0\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],

        ["\xB0\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],
        ["\xB0\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],

        ["\xB0\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],
        ["\xB0\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],

        ["\xB0\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],
        ["\xB0\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],

        ["\xB0\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],
        ["\xB0\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],

        ["\xB0\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],
        ["\xB0\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],

        ["\xB0\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],
        ["\xB0\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],

        ["\xB0\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],
        ["\xB0\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],

        ["\xB0\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],
        ["\xB0\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],

        ["\xB0\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],
        ["\xB0\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],

        ["\xB0\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],
        ["\xB0\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],

        ["\xB0\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],
        ["\xB0\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],

        ["\xB0\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],
        ["\xB0\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],

        ["\xB0\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],
        ["\xB0\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],

        ["\xB0\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],
        ["\xB0\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],

        ["\xB0\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],
        ["\xB0\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],

        ["\xB0\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],
        ["\xB0\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],

        ["\xB0\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],
        ["\xB0\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],

        ["\xB0\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],
        ["\xB0\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],

        ["\xB0\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],
        ["\xB0\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],

        ["\xB0\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],
        ["\xB0\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],

        ["\xB0\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],
        ["\xB0\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],

        ["\xB0\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],
        ["\xB0\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],

        ["\xB0\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],
        ["\xB0\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],

        ["\xB0\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],
        ["\xB0\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],

        ["\xB0\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],
        ["\xB0\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],

        ["\xB0\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],
        ["\xB0\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],

        ["\xB0\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],
        ["\xB0\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],

        ["\xB0\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],
        ["\xB0\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],

        ["\xB0\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],
        ["\xB0\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],

        ["\xB0\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],
        ["\xB0\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],

        ["\xB0\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],
        ["\xB0\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],

        ["\xB0\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],
        ["\xB0\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],

        ["\xB0\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],
        ["\xB0\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],

        ["\xB0\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],
        ["\xB0\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],

        ["\xB1\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],
        ["\xB1\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],

        ["\xB1\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],
        ["\xB1\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],

        ["\xB1\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],
        ["\xB1\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],

        ["\xB1\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],
        ["\xB1\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],

        ["\xB1\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],
        ["\xB1\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],

        ["\xB1\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],
        ["\xB1\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],

        ["\xB1\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],
        ["\xB1\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],

        ["\xB1\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],
        ["\xB1\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],

        ["\xB1\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],
        ["\xB1\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],

        ["\xB1\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],
        ["\xB1\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],

        ["\xB1\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],
        ["\xB1\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],

        ["\xB1\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],
        ["\xB1\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],

        ["\xB1\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],
        ["\xB1\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],

        ["\xB1\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],
        ["\xB1\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],

        ["\xB1\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],
        ["\xB1\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],

        ["\xB1\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],
        ["\xB1\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],

        ["\xB1\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],
        ["\xB1\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],

        ["\xB1\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],
        ["\xB1\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],

        ["\xB1\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],
        ["\xB1\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],

        ["\xB1\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],
        ["\xB1\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],

        ["\xB1\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],
        ["\xB1\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],

        ["\xB1\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],
        ["\xB1\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],

        ["\xB1\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],
        ["\xB1\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],

        ["\xB1\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],
        ["\xB1\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],

        ["\xB1\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],
        ["\xB1\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],

        ["\xB1\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],
        ["\xB1\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],

        ["\xB1\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],
        ["\xB1\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],

        ["\xB1\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],
        ["\xB1\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],

        ["\xB1\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],
        ["\xB1\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],

        ["\xB1\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],
        ["\xB1\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],

        ["\xB1\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],
        ["\xB1\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],

        ["\xB1\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],
        ["\xB1\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],

        ["\xB1\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],
        ["\xB1\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],

        ["\xB1\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],
        ["\xB1\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],

        ["\xB1\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],
        ["\xB1\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],

        ["\xB1\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],
        ["\xB1\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],

        ["\xB1\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],
        ["\xB1\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],

        ["\xB1\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],
        ["\xB1\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],

        ["\xB1\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],
        ["\xB1\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],

        ["\xB1\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],
        ["\xB1\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],

        ["\xB1\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],
        ["\xB1\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],

        ["\xB1\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],
        ["\xB1\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],

        ["\xB1\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],
        ["\xB1\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],

        ["\xB1\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],
        ["\xB1\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],

        ["\xB1\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],
        ["\xB1\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],

        ["\xB1\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],
        ["\xB1\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],

        ["\xB1\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],
        ["\xB1\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],

        ["\xB1\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],
        ["\xB1\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],

        ["\xB1\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],
        ["\xB1\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],

        ["\xB1\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],
        ["\xB1\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],

        ["\xB1\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],
        ["\xB1\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],

        ["\xB1\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],
        ["\xB1\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],

        ["\xB1\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],
        ["\xB1\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],

        ["\xB1\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],
        ["\xB1\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],

        ["\xB1\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],
        ["\xB1\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],

        ["\xB1\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],
        ["\xB1\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],

        ["\xB1\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],
        ["\xB1\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],

        ["\xB1\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],
        ["\xB1\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],

        ["\xB1\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],
        ["\xB1\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],

        ["\xB1\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],
        ["\xB1\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],

        ["\xB1\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],
        ["\xB1\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],

        ["\xB1\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],
        ["\xB1\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],

        ["\xB1\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],
        ["\xB1\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],

        ["\xB1\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],
        ["\xB1\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],

        ["\xB1\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],
        ["\xB1\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],

        ["\xB1\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],
        ["\xB1\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],

        ["\xB1\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],
        ["\xB1\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],

        ["\xB1\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],
        ["\xB1\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],

        ["\xB1\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],
        ["\xB1\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],

        ["\xB1\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],
        ["\xB1\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],

        ["\xB1\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],
        ["\xB1\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],

        ["\xB1\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],
        ["\xB1\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],

        ["\xB1\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],
        ["\xB1\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],

        ["\xB1\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],
        ["\xB1\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],

        ["\xB1\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],
        ["\xB1\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],

        ["\xB1\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],
        ["\xB1\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],

        ["\xB1\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],
        ["\xB1\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],

        ["\xB1\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],
        ["\xB1\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],

        ["\xB1\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],
        ["\xB1\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],

        ["\xB1\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],
        ["\xB1\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],

        ["\xB1\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],
        ["\xB1\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],

        ["\xB1\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],
        ["\xB1\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],

        ["\xB1\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],
        ["\xB1\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],

        ["\xB1\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],
        ["\xB1\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],

        ["\xB1\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],
        ["\xB1\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],

        ["\xB1\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],
        ["\xB1\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],

        ["\xB1\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],
        ["\xB1\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],

        ["\xB1\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],
        ["\xB1\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],

        ["\xB1\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],
        ["\xB1\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],

        ["\xB1\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],
        ["\xB1\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],

        ["\xB1\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],
        ["\xB1\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],

        ["\xB1\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],
        ["\xB1\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],

        ["\xB1\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],
        ["\xB1\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],

        ["\xB1\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],
        ["\xB1\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],

        ["\xB2\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],
        ["\xB2\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],

        ["\xB2\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],
        ["\xB2\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],

        ["\xB2\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],
        ["\xB2\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],

        ["\xB2\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],
        ["\xB2\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],

        ["\xB2\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],
        ["\xB2\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],

        ["\xB2\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],
        ["\xB2\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],

        ["\xB2\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],
        ["\xB2\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],

        ["\xB2\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],
        ["\xB2\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],

        ["\xB2\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xF2\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],

        ["\xB2\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],
        ["\xB2\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],

        ["\xB2\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xB2\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],

        ["\xB2\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],
        ["\xB2\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],

        ["\xB2\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],
        ["\xB2\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],

        ["\xB2\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],
        ["\xB2\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],

        ["\xB2\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],
        ["\xB2\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],

        ["\xB2\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],
        ["\xB2\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],

        ["\xB2\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],
        ["\xB2\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],

        ["\xB2\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],
        ["\xB2\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],

        ["\xB2\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],
        ["\xB2\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],

        ["\xB2\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],
        ["\xB2\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],

        ["\xB2\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],
        ["\xB2\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],

        ["\xB2\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],
        ["\xB2\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],

        ["\xB2\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],
        ["\xB2\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],

        ["\xB2\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],
        ["\xB2\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],

        ["\xB2\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],
        ["\xB2\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],

        ["\xB2\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],
        ["\xB2\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],

        ["\xB2\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],
        ["\xB2\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],

        ["\xB2\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],
        ["\xB2\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],

        ["\xB2\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],
        ["\xB2\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],

        ["\xB2\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],
        ["\xB2\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],

        ["\xB2\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],
        ["\xB2\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],

        ["\xB2\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],
        ["\xB2\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],

        ["\xB2\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],
        ["\xB2\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],

        ["\xB2\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xB2\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],

        ["\xB2\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],
        ["\xB2\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],

        ["\xB2\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],
        ["\xB2\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],

        ["\xB2\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],
        ["\xB2\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],

        ["\xB2\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],
        ["\xB2\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],

        ["\xB2\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],
        ["\xB2\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],

        ["\xB2\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],
        ["\xB2\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],

        ["\xB2\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],
        ["\xB2\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],

        ["\xB2\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],
        ["\xB2\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],

        ["\xB2\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],
        ["\xB2\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],

        ["\xB2\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],
        ["\xB2\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],

        ["\xB2\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xB2\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],

        ["\xB2\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xB2\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],

        ["\xB2\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],
        ["\xB2\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],

        ["\xB2\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],
        ["\xB2\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],

        ["\xB2\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],
        ["\xB2\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],

        ["\xB2\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],
        ["\xB2\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],

        ["\xB2\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xB2\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],

        ["\xB2\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],
        ["\xB2\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],

        ["\xB2\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],
        ["\xB2\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],

        ["\xB2\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xB2\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],

        ["\xB2\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],
        ["\xB2\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],

        ["\xB2\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],
        ["\xB2\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],

        ["\xB2\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],
        ["\xB2\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],

        ["\xB2\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],
        ["\xB2\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],

        ["\xB2\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xB2\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],

        ["\xB2\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],
        ["\xB2\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],

        ["\xB2\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],
        ["\xB2\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],

        ["\xB2\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],
        ["\xB2\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],

        ["\xB2\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],
        ["\xB2\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],

        ["\xB2\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],
        ["\xB2\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],

        ["\xB2\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xB2\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],

        ["\xB2\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],
        ["\xB2\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],

        ["\xB2\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],
        ["\xB2\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],

        ["\xB2\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],
        ["\xB2\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],

        ["\xB2\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],
        ["\xB2\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],

        ["\xB2\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],
        ["\xB2\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],

        ["\xB2\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xB2\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],

        ["\xB2\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],
        ["\xB2\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],

        ["\xB2\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],
        ["\xB2\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],

        ["\xB2\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xB2\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],

        ["\xB2\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],
        ["\xB2\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],

        ["\xB2\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],
        ["\xB2\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],

        ["\xB2\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],
        ["\xB2\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],

        ["\xB2\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],
        ["\xB2\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],

        ["\xB2\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],
        ["\xB2\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],

        ["\xB2\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],
        ["\xB2\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],

        ["\xB2\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],
        ["\xB2\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],

        ["\xB2\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],
        ["\xB2\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],

        ["\xB2\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],
        ["\xB2\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],

        ["\xB2\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],
        ["\xB2\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],

        ["\xB2\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xB2\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],

        ["\xB2\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xB2\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],

        ["\xB2\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],
        ["\xB2\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],

        ["\xB2\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],
        ["\xB2\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],

        ["\xB2\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],
        ["\xB2\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],

        ["\xB2\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],
        ["\xB2\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],

        ["\xB2\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],
        ["\xB2\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],

        ["\xB2\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],
        ["\xB2\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],

        ["\xB2\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],
        ["\xB2\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],

        ["\xB2\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],
        ["\xB2\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],

        ["\xB3\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xB3\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],

        ["\xB3\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xB3\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],

        ["\xB3\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xB3\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],

        ["\xB3\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xB3\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],

        ["\xB3\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\xB3\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],

        ["\xB3\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xB3\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],

        ["\xB3\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xB3\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],

        ["\xB3\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xB3\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],

        ["\xB3\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xB3\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],

        ["\xB3\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xB3\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],

        ["\xB3\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xB3\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],

        ["\xB3\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\xB3\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],

        ["\xB3\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\xB3\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],

        ["\xB3\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xB3\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],

        ["\xB3\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xB3\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],

        ["\xB3\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xB3\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],

        ["\xB3\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\xB3\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],

        ["\xB3\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xB3\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],

        ["\xB3\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xB3\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],

        ["\xB3\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xB3\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],

        ["\xB3\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xB3\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],

        ["\xB3\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xB3\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],

        ["\xB3\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xB3\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],

        ["\xB3\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xB3\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],

        ["\xB3\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xB3\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],

        ["\xB3\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\xB3\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],

        ["\xB3\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xB3\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],

        ["\xB3\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xB3\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],

        ["\xB3\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xB3\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],

        ["\xB3\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xB3\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],

        ["\xB3\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\xB3\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],

        ["\xB3\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xB3\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],

        ["\xB3\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\xB3\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],

        ["\xB3\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xE9\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],

        ["\xB3\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xB3\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],

        ["\xB3\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xB3\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],

        ["\xB3\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xB3\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],

        ["\xB3\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\xB3\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],

        ["\xB3\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\xB3\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],

        ["\xB3\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xB3\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],

        ["\xB3\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xD9\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],

        ["\xB3\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xB3\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],

        ["\xB3\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xB3\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],

        ["\xB3\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xB3\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],

        ["\xB3\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xB3\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],

        ["\xB3\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xB3\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],

        ["\xB3\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xB3\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],

        ["\xB3\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xB3\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],

        ["\xB3\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\xB3\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],

        ["\xB3\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xB3\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],

        ["\xB3\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xB3\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],

        ["\xB3\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xB3\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],

        ["\xB3\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xB3\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],

        ["\xB3\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xB3\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],

        ["\xB3\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\xB3\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],

        ["\xB3\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xB3\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],

        ["\xB3\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\xB3\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],

        ["\xB3\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xB3\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],

        ["\xB3\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xB3\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],

        ["\xB3\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xB3\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],

        ["\xB3\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xB3\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],

        ["\xB3\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xB3\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],

        ["\xB3\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xB3\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],

        ["\xB3\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xB3\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],

        ["\xB3\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xB3\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],

        ["\xB3\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\xB3\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],

        ["\xB3\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\xB3\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],

        ["\xB3\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xB3\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],

        ["\xB3\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xB3\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],

        ["\xB3\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xB3\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],

        ["\xB3\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\xB3\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],

        ["\xB3\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\xB3\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],

        ["\xB3\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xB3\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],

        ["\xB3\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xB3\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],

        ["\xB3\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xB3\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],

        ["\xB3\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xB3\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],

        ["\xB3\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xB3\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],

        ["\xB3\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xB3\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],

        ["\xB3\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xB3\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],

        ["\xB3\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xB3\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],

        ["\xB3\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xB3\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],

        ["\xB3\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xB3\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],

        ["\xB3\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\xB3\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],

        ["\xB3\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xB3\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],

        ["\xB3\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\xB3\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],

        ["\xB3\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE3\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],

        ["\xB3\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xB3\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],

        ["\xB3\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xB3\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],

        ["\xB3\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xB3\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],

        ["\xB3\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\xB3\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],

        ["\xB3\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\xB3\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],

        ["\xB3\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\xB3\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],

        ["\xB3\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xB3\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],

        ["\xB3\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xB3\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],

        ["\xB4\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xB4\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],

        ["\xB4\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xB4\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],

        ["\xB4\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xB4\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],

        ["\xB4\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xB4\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],

        ["\xB4\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xB4\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],

        ["\xB4\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xB4\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],

        ["\xB4\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xB4\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],

        ["\xB4\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xB4\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],

        ["\xB4\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xB4\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],

        ["\xB4\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xB4\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],

        ["\xB4\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xB4\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],

        ["\xB4\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xB4\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],

        ["\xB4\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xB4\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],

        ["\xB4\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xB4\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],

        ["\xB4\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xB4\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],

        ["\xB4\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xB4\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],

        ["\xB4\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xB4\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],

        ["\xB4\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xB4\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],

        ["\xB4\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xB4\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],

        ["\xB4\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xB4\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],

        ["\xB4\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xB4\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],

        ["\xB4\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xB4\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],

        ["\xB4\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xB4\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],

        ["\xB4\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xB4\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],

        ["\xB4\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xB4\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],

        ["\xB4\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xB4\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],

        ["\xB4\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xB4\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],

        ["\xB4\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xB4\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],

        ["\xB4\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xB4\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],

        ["\xB4\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xB4\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],

        ["\xB4\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xB4\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],

        ["\xB4\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xB4\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],

        ["\xB4\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xB4\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],

        ["\xB4\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\xB4\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],

        ["\xB4\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\xDE\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],

        ["\xB4\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xB4\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],

        ["\xB4\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xB4\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],

        ["\xB4\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xB4\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],

        ["\xB4\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xB4\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],

        ["\xB4\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xB4\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],

        ["\xB4\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xB4\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],

        ["\xB4\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xB4\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],

        ["\xB4\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xB4\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],

        ["\xB4\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xB4\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],

        ["\xB4\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xB4\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],

        ["\xB4\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xB4\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],

        ["\xB4\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xB4\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],

        ["\xB4\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xB4\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],

        ["\xB4\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xB4\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],

        ["\xB4\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\xEB\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],

        ["\xB4\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xB4\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],

        ["\xB4\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xB4\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],

        ["\xB4\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xB4\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],

        ["\xB4\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xB4\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],

        ["\xB4\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xB4\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],

        ["\xB4\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xB4\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],

        ["\xB4\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xB4\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],

        ["\xB4\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xB4\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],

        ["\xB4\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xB4\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],

        ["\xB4\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xB4\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],

        ["\xB4\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xB4\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],

        ["\xB4\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xB4\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],

        ["\xB4\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xB4\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],

        ["\xB4\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xB4\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],

        ["\xB4\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xB4\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],

        ["\xB4\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xB4\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],

        ["\xB4\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xB4\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],

        ["\xB4\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xB4\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],

        ["\xB4\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xB4\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],

        ["\xB4\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xB4\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],

        ["\xB4\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xB4\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],

        ["\xB4\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xB4\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],

        ["\xB4\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xB4\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],

        ["\xB4\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xB4\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],

        ["\xB4\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xB4\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],

        ["\xB4\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xB4\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],

        ["\xB4\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xB4\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],

        ["\xB4\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xB4\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],

        ["\xB4\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xB4\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],

        ["\xB4\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xB4\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],

        ["\xB4\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xB4\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],

        ["\xB4\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xB4\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],

        ["\xB4\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xB4\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],

        ["\xB4\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xB4\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],

        ["\xB4\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xB4\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],

        ["\xB4\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xB4\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],

        ["\xB4\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xB4\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],

        ["\xB4\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xB4\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],

        ["\xB4\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xB4\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],

        ["\xB4\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xB4\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],

        ["\xB4\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xB4\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],

        ["\xB4\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xB4\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],

        ["\xB4\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xB4\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],

        ["\xB4\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xB4\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],

        ["\xB5\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xB5\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],

        ["\xB5\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xB5\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],

        ["\xB5\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xB5\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],

        ["\xB5\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xB5\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],

        ["\xB5\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xB5\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],

        ["\xB5\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xB5\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],

        ["\xB5\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xB5\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],

        ["\xB5\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xB5\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],

        ["\xB5\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xB5\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],

        ["\xB5\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xB5\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],

        ["\xB5\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xB5\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],

        ["\xB5\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xB5\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],

        ["\xB5\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xB5\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],

        ["\xB5\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xB5\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],

        ["\xB5\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xB5\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],

        ["\xB5\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xB5\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],

        ["\xB5\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xB5\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],

        ["\xB5\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xB5\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],

        ["\xB5\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xB5\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],

        ["\xB5\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xB5\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],

        ["\xB5\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xB5\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],

        ["\xB5\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xB5\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],

        ["\xB5\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xB5\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],

        ["\xB5\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xB5\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],

        ["\xB5\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xB5\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],

        ["\xB5\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xB5\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],

        ["\xB5\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xB5\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],

        ["\xB5\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xB5\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],

        ["\xB5\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xB5\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],

        ["\xB5\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xB5\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],

        ["\xB5\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xB5\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],

        ["\xB5\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xB5\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],

        ["\xB5\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xB5\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],

        ["\xB5\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xB5\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],

        ["\xB5\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xB5\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],

        ["\xB5\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xB5\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],

        ["\xB5\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xB5\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],

        ["\xB5\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xB5\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],

        ["\xB5\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xB5\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],

        ["\xB5\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xB5\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],

        ["\xB5\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xB5\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],

        ["\xB5\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xB5\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],

        ["\xB5\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xB5\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],

        ["\xB5\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xB5\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],

        ["\xB5\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xB5\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],

        ["\xB5\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xB5\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],

        ["\xB5\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xB5\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],

        ["\xB5\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xB5\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],

        ["\xB5\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xB5\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],

        ["\xB5\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xB5\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],

        ["\xB5\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xB5\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],

        ["\xB5\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xB5\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],

        ["\xB5\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xB5\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],

        ["\xB5\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xB5\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],

        ["\xB5\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xB5\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],

        ["\xB5\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xB5\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],

        ["\xB5\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xB5\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],

        ["\xB5\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xB5\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],

        ["\xB5\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xB5\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],

        ["\xB5\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xB5\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],

        ["\xB5\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xB5\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],

        ["\xB5\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xB5\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],

        ["\xB5\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xB5\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],

        ["\xB5\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xB5\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],

        ["\xB5\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xB5\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],

        ["\xB5\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xB5\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],

        ["\xB5\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xB5\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],

        ["\xB5\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xB5\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],

        ["\xB5\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xB5\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],

        ["\xB5\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xB5\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],

        ["\xB5\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xB5\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],

        ["\xB5\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xB5\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],

        ["\xB5\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xB5\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],

        ["\xB5\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xB5\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],

        ["\xB5\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xB5\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],

        ["\xB5\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xB5\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],

        ["\xB5\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xB5\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],

        ["\xB5\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xB5\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],

        ["\xB5\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xB5\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],

        ["\xB5\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xB5\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],

        ["\xB5\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xB5\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],

        ["\xB5\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xB5\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],

        ["\xB5\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xB5\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],

        ["\xB5\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xB5\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],

        ["\xB5\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xB5\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],

        ["\xB5\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xB5\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],

        ["\xB5\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xB5\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],

        ["\xB5\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xB5\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],

        ["\xB5\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xB5\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],

        ["\xB5\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xB5\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],

        ["\xB5\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xB5\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],

        ["\xB5\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xB5\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],

        ["\xB5\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xB5\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],

        ["\xB5\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xB5\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],

        ["\xB6\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xB6\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],

        ["\xB6\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xB6\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],

        ["\xB6\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xB6\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],

        ["\xB6\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xB6\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],

        ["\xB6\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xB6\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],

        ["\xB6\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xB6\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],

        ["\xB6\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xB6\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],

        ["\xB6\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xB6\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],

        ["\xB6\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xB6\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],

        ["\xB6\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xB6\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],

        ["\xB6\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xB6\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],

        ["\xB6\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xB6\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],

        ["\xB6\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xB6\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],

        ["\xB6\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xB6\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],

        ["\xB6\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xB6\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],

        ["\xB6\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xB6\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],

        ["\xB6\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xB6\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],

        ["\xB6\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xB6\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],

        ["\xB6\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xB6\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],

        ["\xB6\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xB6\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],

        ["\xB6\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xB6\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],

        ["\xB6\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xB6\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],

        ["\xB6\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xB6\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],

        ["\xB6\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xB6\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],

        ["\xB6\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xB6\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],

        ["\xB6\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xB6\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],

        ["\xB6\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xB6\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],

        ["\xB6\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xB6\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],

        ["\xB6\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xB6\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],

        ["\xB6\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xB6\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],

        ["\xB6\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xB6\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],

        ["\xB6\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xB6\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],

        ["\xB6\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xB6\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],

        ["\xB6\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xB6\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],

        ["\xB6\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xB6\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],

        ["\xB6\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xB6\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],

        ["\xB6\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xB6\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],

        ["\xB6\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],
        ["\x47\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],

        ["\xB6\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xB6\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],

        ["\xB6\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xB6\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],

        ["\xB6\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xB6\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],

        ["\xB6\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xB6\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],

        ["\xB6\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xB6\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],

        ["\xB6\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xB6\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],

        ["\xB6\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xB6\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],

        ["\xB6\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xB6\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],

        ["\xB6\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xB6\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],

        ["\xB6\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xB6\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],

        ["\xB6\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xB6\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],

        ["\xB6\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xB6\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],

        ["\xB6\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xB6\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],

        ["\xB6\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xB6\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],

        ["\xB6\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xB6\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],

        ["\xB6\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xB6\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],

        ["\xB6\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xB6\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],

        ["\xB6\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xB6\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],

        ["\xB6\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xB6\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],

        ["\xB6\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xB6\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],

        ["\xB6\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xB6\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],

        ["\xB6\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xB6\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],

        ["\xB6\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xB6\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],

        ["\xB6\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xB6\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],

        ["\xB6\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xB6\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],

        ["\xB6\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xB6\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],

        ["\xB6\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xB6\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],

        ["\xB6\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xB6\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],

        ["\xB6\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xB6\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],

        ["\xB6\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xB6\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],

        ["\xB6\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xB6\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],

        ["\xB6\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xB6\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],

        ["\xB6\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xB6\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],

        ["\xB6\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xB6\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],

        ["\xB6\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xB6\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],

        ["\xB6\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xB6\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],

        ["\xB6\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xB6\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],

        ["\xB6\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xB6\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],

        ["\xB6\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xB6\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],

        ["\xB6\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xB6\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],

        ["\xB6\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xB6\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],

        ["\xB6\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xB6\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],

        ["\xB6\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],
        ["\xB6\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],

        ["\xB6\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],
        ["\xB6\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],

        ["\xB6\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xB6\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],

        ["\xB6\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xB6\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],

        ["\xB6\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xB6\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],

        ["\xB6\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xB6\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],

        ["\xB6\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xB6\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],

        ["\xB6\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xB6\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],

        ["\xB6\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xB6\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],

        ["\xB6\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],
        ["\xB6\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],

        ["\xB6\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xB6\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],

        ["\xB6\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],
        ["\xB6\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],

        ["\xB6\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],
        ["\xB6\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],

        ["\xB6\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xB6\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],

        ["\xB7\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xB7\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],

        ["\xB7\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xB7\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],

        ["\xB7\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xB7\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],

        ["\xB7\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xB7\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],

        ["\xB7\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xB7\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],

        ["\xB7\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xB7\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],

        ["\xB7\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],
        ["\xB7\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],

        ["\xB7\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xB7\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],

        ["\xB7\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xB7\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],

        ["\xB7\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xB7\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],

        ["\xB7\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xB7\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],

        ["\xB7\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xB7\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],

        ["\xB7\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xB7\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],

        ["\xB7\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xB7\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],

        ["\xB7\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xB7\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],

        ["\xB7\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xB7\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],

        ["\xB7\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xB7\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],

        ["\xB7\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xB7\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],

        ["\xB7\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xB7\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],

        ["\xB7\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xB7\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],

        ["\xB7\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xB7\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],

        ["\xB7\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xB7\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],

        ["\xB7\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xB7\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],

        ["\xB7\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xB7\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],

        ["\xB7\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xB7\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],

        ["\xB7\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xB7\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],

        ["\xB7\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xB7\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],

        ["\xB7\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xB7\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],

        ["\xB7\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xB7\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],

        ["\xB7\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xB7\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],

        ["\xB7\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xB7\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],

        ["\xB7\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xB7\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],

        ["\xB7\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xB7\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],

        ["\xB7\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xB7\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],

        ["\xB7\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xB7\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],

        ["\xB7\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xB7\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],

        ["\xB7\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xB7\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],

        ["\xB7\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xB7\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],

        ["\xB7\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xB7\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],

        ["\xB7\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xB7\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],

        ["\xB7\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xB7\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],

        ["\xB7\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xB7\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],

        ["\xB7\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xB7\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],

        ["\xB7\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xB7\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],

        ["\xB7\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xB7\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],

        ["\xB7\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xB7\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],

        ["\xB7\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xB7\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],

        ["\xB7\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xB7\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],

        ["\xB7\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
        ["\xB7\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],

        ["\xB7\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],
        ["\xB7\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],

        ["\xB7\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],
        ["\xB7\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],

        ["\xB7\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],
        ["\xB7\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],

        ["\xB7\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],
        ["\xB7\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],

        ["\xB7\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],
        ["\xB7\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],

        ["\xB7\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],
        ["\xB7\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],

        ["\xB7\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],
        ["\xB7\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],

        ["\xB7\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],
        ["\xB7\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],

        ["\xB7\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],
        ["\xB7\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],

        ["\xB7\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xF0\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],

        ["\xB7\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],
        ["\xB7\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],

        ["\xB7\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],
        ["\xB7\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],

        ["\xB7\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],
        ["\xB7\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],

        ["\xB7\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],
        ["\xB7\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],

        ["\xB7\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],
        ["\xB7\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],

        ["\xB7\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],
        ["\xB7\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],

        ["\xB7\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],
        ["\xB7\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],

        ["\xB7\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],
        ["\xB7\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],

        ["\xB7\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],
        ["\xB7\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],

        ["\xB7\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],
        ["\xB7\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],

        ["\xB7\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],
        ["\xB7\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],

        ["\xB7\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],
        ["\xB7\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],

        ["\xB7\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],
        ["\xB7\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],

        ["\xB7\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],
        ["\xB7\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],

        ["\xB7\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],
        ["\xB7\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],

        ["\xB7\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],
        ["\xB7\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],

        ["\xB7\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],
        ["\xB7\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],

        ["\xB7\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],
        ["\xB7\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],

        ["\xB7\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],
        ["\xB7\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],

        ["\xB7\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],
        ["\xB7\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],

        ["\xB7\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],
        ["\xB7\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],

        ["\xB7\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],
        ["\xB7\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],

        ["\xB7\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],
        ["\xB7\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],

        ["\xB7\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],
        ["\xB7\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],

        ["\xB7\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],
        ["\xB7\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],

        ["\xB7\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],
        ["\xB7\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],

        ["\xB7\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],
        ["\xB7\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],

        ["\xB7\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],
        ["\xB7\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],

        ["\xB7\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],
        ["\xB7\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],

        ["\xB7\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],
        ["\xB7\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],

        ["\xB7\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],
        ["\xB7\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],

        ["\xB7\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],
        ["\xB7\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],

        ["\xB7\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],
        ["\xB7\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],

        ["\xB7\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],
        ["\xB7\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],

        ["\xB7\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],
        ["\xB7\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],

        ["\xB8\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],
        ["\xB8\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],

        ["\xB8\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],
        ["\xB8\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],

        ["\xB8\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xB8\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],

        ["\xB8\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],
        ["\xB8\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],

        ["\xB8\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],
        ["\xB8\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],

        ["\xB8\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],
        ["\xB8\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],

        ["\xB8\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],
        ["\xB8\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],

        ["\xB8\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],
        ["\xB8\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],

        ["\xB8\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xB8\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],

        ["\xB8\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],
        ["\xB8\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],

        ["\xB8\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],
        ["\xB8\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],

        ["\xB8\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xB8\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],

        ["\xB8\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],
        ["\xB8\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],

        ["\xB8\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],
        ["\xB8\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],

        ["\xB8\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xB8\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],

        ["\xB8\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],
        ["\xB8\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],

        ["\xB8\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xB8\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],

        ["\xB8\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xB8\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],

        ["\xB8\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],
        ["\xB8\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],

        ["\xB8\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\xB8\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],

        ["\xB8\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],
        ["\xB8\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],

        ["\xB8\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],
        ["\xB8\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],

        ["\xB8\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xB8\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],

        ["\xB8\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],
        ["\xB8\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],

        ["\xB8\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],
        ["\xB8\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],

        ["\xB8\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xB8\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],

        ["\xB8\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\xB8\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],

        ["\xB8\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],
        ["\xB8\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],

        ["\xB8\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],
        ["\xB8\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],

        ["\xB8\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],
        ["\xB8\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],

        ["\xB8\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],
        ["\xB8\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],

        ["\xB8\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\xB8\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],

        ["\xB8\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xB8\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],

        ["\xB8\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xB8\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],

        ["\xB8\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],
        ["\xB8\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],

        ["\xB8\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\xB8\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],

        ["\xB8\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],
        ["\xB8\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],

        ["\xB8\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xB8\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],

        ["\xB8\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],
        ["\xB8\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],

        ["\xB8\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\xB8\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],

        ["\xB8\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\xB8\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],

        ["\xB8\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],
        ["\xB8\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],

        ["\xB8\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],
        ["\xB8\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],

        ["\xB8\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],
        ["\xB8\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],

        ["\xB8\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],
        ["\xB8\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],

        ["\xB8\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\xB8\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],

        ["\xB8\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\xB8\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],

        ["\xB8\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],
        ["\xB8\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],

        ["\xB8\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],
        ["\xB8\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],

        ["\xB8\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],
        ["\xB8\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],

        ["\xB8\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xB8\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],

        ["\xB8\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],
        ["\xB8\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],

        ["\xB8\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],
        ["\xB8\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],

        ["\xB8\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xB8\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],

        ["\xB8\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xB8\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],

        ["\xB8\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],
        ["\xB8\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],

        ["\xB8\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],
        ["\xB8\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],

        ["\xB8\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],
        ["\xB8\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],

        ["\xB8\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],
        ["\xB8\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],

        ["\xB8\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xB8\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],

        ["\xB8\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xB8\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],

        ["\xB8\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],
        ["\xB8\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],

        ["\xB8\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xB8\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],

        ["\xB8\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],
        ["\xB8\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],

        ["\xB8\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],
        ["\xB8\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],

        ["\xB8\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],
        ["\xB8\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],

        ["\xB8\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],
        ["\xB8\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],

        ["\xB8\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],
        ["\xB8\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],

        ["\xB8\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],
        ["\xB8\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],

        ["\xB8\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],
        ["\xB8\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],

        ["\xB8\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],
        ["\xB8\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],

        ["\xB8\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],
        ["\xB8\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],

        ["\xB8\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],
        ["\xB8\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],

        ["\xB8\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xB8\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],

        ["\xB8\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xB8\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],

        ["\xB8\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xB8\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],

        ["\xB8\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],
        ["\xB8\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],

        ["\xB8\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xB8\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],

        ["\xB8\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],
        ["\xB8\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],

        ["\xB8\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],
        ["\xB8\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],

        ["\xB8\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],
        ["\xB8\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],

        ["\xB8\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],
        ["\xB8\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],

        ["\xB8\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],
        ["\xB8\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],

        ["\xB8\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xB8\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],

        ["\xB8\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],
        ["\xB8\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],

        ["\xB8\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],
        ["\xB8\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],

        ["\xB8\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],
        ["\xB8\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],

        ["\xB8\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xB8\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],

        ["\xB8\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],
        ["\xB8\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],

        ["\xB8\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],
        ["\xB8\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],

        ["\xB8\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],
        ["\xB8\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],

        ["\xB8\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xB8\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],

        ["\xB8\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xB8\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],

        ["\xB8\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\xB8\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],

        ["\xB9\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\xB9\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],

        ["\xB9\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xB9\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],

        ["\xB9\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\xB9\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],

        ["\xB9\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],
        ["\xB9\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],

        ["\xB9\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],
        ["\xB9\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],

        ["\xB9\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xB9\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],

        ["\xB9\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],
        ["\xB9\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],

        ["\xB9\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],
        ["\xB9\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],

        ["\xB9\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\xB9\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],

        ["\xB9\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],
        ["\xB9\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],

        ["\xB9\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],
        ["\xB9\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],

        ["\xB9\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xB9\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],

        ["\xB9\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],
        ["\xB9\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],

        ["\xB9\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],
        ["\xB9\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],

        ["\xB9\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],
        ["\xB9\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],

        ["\xB9\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xB9\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],

        ["\xB9\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],
        ["\xB9\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],

        ["\xB9\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],
        ["\xB9\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],

        ["\xB9\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],
        ["\xB9\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],

        ["\xB9\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\xB9\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],

        ["\xB9\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],
        ["\xB9\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],

        ["\xB9\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],
        ["\xB9\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],

        ["\xB9\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],
        ["\x50\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],

        ["\xB9\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xB9\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],

        ["\xB9\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],
        ["\xB9\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],

        ["\xB9\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xB9\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],

        ["\xB9\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],
        ["\xB9\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],

        ["\xB9\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],
        ["\xB9\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],

        ["\xB9\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],
        ["\xB9\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],

        ["\xB9\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],
        ["\xB9\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],

        ["\xB9\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],
        ["\xB9\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],

        ["\xB9\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],
        ["\xB9\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],

        ["\xB9\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xB9\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],

        ["\xB9\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xB9\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],

        ["\xB9\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],
        ["\xB9\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],

        ["\xB9\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],
        ["\xB9\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],

        ["\xB9\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],
        ["\xB9\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],

        ["\xB9\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\xB9\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],

        ["\xB9\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\xB9\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],

        ["\xB9\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],
        ["\xB9\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],

        ["\xB9\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xB9\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],

        ["\xB9\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],
        ["\xB9\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],

        ["\xB9\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\xB9\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],

        ["\xB9\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],
        ["\xB9\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],

        ["\xB9\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],
        ["\xB9\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],

        ["\xB9\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],
        ["\xB9\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],

        ["\xB9\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],
        ["\xB9\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],

        ["\xB9\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],
        ["\xB9\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],

        ["\xB9\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],
        ["\xB9\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],

        ["\xB9\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],
        ["\xB9\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],

        ["\xB9\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\xB9\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],

        ["\xB9\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],
        ["\xB9\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],

        ["\xB9\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],
        ["\xB9\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],

        ["\xB9\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],
        ["\xB9\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],

        ["\xB9\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xB9\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],

        ["\xB9\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],
        ["\xB9\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],

        ["\xB9\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xB9\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],

        ["\xB9\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xB9\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],

        ["\xB9\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],
        ["\xB9\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],

        ["\xB9\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],

        ["\xB9\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],
        ["\xB9\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],

        ["\xB9\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],
        ["\xB9\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],

        ["\xB9\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],
        ["\xB9\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],

        ["\xB9\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\xB9\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],

        ["\xB9\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],
        ["\xB9\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],

        ["\xB9\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],
        ["\xB9\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],

        ["\xB9\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],
        ["\xB9\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],

        ["\xB9\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],
        ["\xB9\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],

        ["\xB9\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],
        ["\xB9\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],

        ["\xB9\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],
        ["\xB9\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],

        ["\xB9\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],
        ["\xB9\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],

        ["\xB9\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],
        ["\xB9\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],

        ["\xB9\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],
        ["\xB9\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],

        ["\xB9\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],
        ["\xB9\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],

        ["\xB9\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],
        ["\xB9\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],

        ["\xB9\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xB9\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],

        ["\xB9\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC3"],
        ["\x6F\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],

        ["\xB9\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],
        ["\xB9\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],

        ["\xB9\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xB9\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],

        ["\xB9\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xB9\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],

        ["\xB9\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],
        ["\xB9\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],

        ["\xB9\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],
        ["\xB9\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],

        ["\xB9\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],
        ["\xB9\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],

        ["\xB9\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],
        ["\xB9\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],

        ["\xB9\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\xB9\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],

        ["\xB9\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\xB9\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],

        ["\xB9\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],
        ["\xB9\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],

        ["\xB9\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xB9\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],

        ["\xB9\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],
        ["\xB9\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],

        ["\xB9\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],
        ["\xB9\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],

        ["\xB9\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],
        ["\xB9\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],

        ["\xB9\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],
        ["\xB9\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],

        ["\xB9\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],
        ["\xB9\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],

        ["\xB9\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],
        ["\xB9\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],

        ["\xBA\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],
        ["\xBA\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],

        ["\xBA\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\xBA\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],

        ["\xBA\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],
        ["\xBA\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],

        ["\xBA\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\xBA\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],

        ["\xBA\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],
        ["\xBA\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],

        ["\xBA\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],
        ["\xBA\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],

        ["\xBA\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xBA\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],

        ["\xBA\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],
        ["\xBA\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],

        ["\xBA\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\xBA\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],

        ["\xBA\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xBA\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],

        ["\xBA\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],
        ["\xBA\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],

        ["\xBA\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\xBA\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],

        ["\xBA\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],
        ["\xBA\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],

        ["\xBA\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\xBA\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],

        ["\xBA\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],
        ["\xBA\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],

        ["\xBA\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],
        ["\xBA\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],

        ["\xBA\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],
        ["\xBA\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],

        ["\xBA\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],
        ["\xBA\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],

        ["\xBA\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\xBA\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],

        ["\xBA\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\xBA\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],

        ["\xBA\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\xBA\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],

        ["\xBA\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\xBA\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],

        ["\xBA\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],
        ["\xBA\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],

        ["\xBA\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],
        ["\xBA\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],

        ["\xBA\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\xBA\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],

        ["\xBA\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xBA\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],

        ["\xBA\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xBA\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],

        ["\xBA\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\xBA\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],

        ["\xBA\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],
        ["\xBA\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],

        ["\xBA\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xBA\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],

        ["\xBA\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],
        ["\xBA\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],

        ["\xBA\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],
        ["\xBA\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],

        ["\xBA\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],
        ["\xBA\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],

        ["\xBA\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],
        ["\xBA\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],

        ["\xBA\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],
        ["\xBA\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],

        ["\xBA\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],
        ["\xBA\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],

        ["\xBA\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\xBA\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],

        ["\xBA\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],
        ["\xBA\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],

        ["\xBA\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xBA\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],

        ["\xBA\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],
        ["\xBA\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],

        ["\xBA\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],
        ["\xBA\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],

        ["\xBA\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],
        ["\xBA\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],

        ["\xBA\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\xBA\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],

        ["\xBA\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],
        ["\xBA\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],

        ["\xBA\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xBA\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],

        ["\xBA\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\xBA\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],

        ["\xBA\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\xBA\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],

        ["\xBA\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\xBA\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],

        ["\xBA\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],
        ["\xBA\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],

        ["\xBA\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],
        ["\xBA\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],

        ["\xBA\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],
        ["\xBA\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],

        ["\xBA\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],
        ["\xBA\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],

        ["\xBA\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],
        ["\xBA\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],

        ["\xBA\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\xBA\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],

        ["\xBA\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\xBA\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],

        ["\xBA\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],
        ["\xBA\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],

        ["\xBA\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],
        ["\xBA\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],

        ["\xBA\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\xBA\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],

        ["\xBA\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\xBA\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],

        ["\xBA\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],
        ["\xBA\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],

        ["\xBA\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],
        ["\xBA\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],

        ["\xBA\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\xBA\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],

        ["\xBA\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],
        ["\xBA\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],

        ["\xBA\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\xBA\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],

        ["\xBA\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],
        ["\xBA\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],

        ["\xBA\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],
        ["\xBA\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],

        ["\xBA\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],
        ["\xBA\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],

        ["\xBA\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],
        ["\xBA\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],

        ["\xBA\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\xBA\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],

        ["\xBA\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],
        ["\xBA\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],

        ["\xBA\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],
        ["\xBA\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],

        ["\xBA\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xBA\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],

        ["\xBA\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],
        ["\xBA\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],

        ["\xBA\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\xBA\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],

        ["\xBA\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],
        ["\xBA\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],

        ["\xBA\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xBA\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],

        ["\xBA\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\xBA\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],

        ["\xBA\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xBA\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],

        ["\xBA\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],
        ["\xBA\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],

        ["\xBA\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],
        ["\xBA\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],

        ["\xBA\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],
        ["\xBA\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],

        ["\xBA\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],
        ["\xBA\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],

        ["\xBA\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\xBA\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],

        ["\xBA\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],
        ["\xBA\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],

        ["\xBA\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],
        ["\xBA\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],

        ["\xBA\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],
        ["\xBA\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],

        ["\xBA\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],
        ["\xBA\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],

        ["\xBA\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xBA\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],

        ["\xBA\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\xBA\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],

        ["\xBA\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],
        ["\xBA\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],

        ["\xBA\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],
        ["\xBA\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],

        ["\xBA\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],
        ["\xBA\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],

        ["\xBA\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\xBA\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],

        ["\xBA\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],
        ["\xBA\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],

        ["\xBB\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\xBB\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],

        ["\xBB\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],
        ["\xBB\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],

        ["\xBB\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],
        ["\xBB\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],

        ["\xBB\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],
        ["\xBB\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],

        ["\xBB\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],
        ["\xBB\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],

        ["\xBB\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],
        ["\xBB\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],

        ["\xBB\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],
        ["\xBB\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],

        ["\xBB\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],
        ["\xBB\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],

        ["\xBB\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],
        ["\xBB\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],

        ["\xBB\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xBB\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],

        ["\xBB\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\xBB\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],

        ["\xBB\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\xBB\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],

        ["\xBB\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\xBB\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],

        ["\xBB\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],
        ["\xBB\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],

        ["\xBB\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],
        ["\xBB\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],

        ["\xBB\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],
        ["\xBB\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],

        ["\xBB\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xBB\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],

        ["\xBB\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],
        ["\xBB\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],

        ["\xBB\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\xBB\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],

        ["\xBB\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],
        ["\xBB\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],

        ["\xBB\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\xBB\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],

        ["\xBB\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\xBB\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],

        ["\xBB\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],
        ["\xBB\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],

        ["\xBB\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],
        ["\xBB\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],

        ["\xBB\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\xBB\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],

        ["\xBB\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],
        ["\xBB\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],

        ["\xBB\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\xBB\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],

        ["\xBB\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\xBB\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],

        ["\xBB\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],
        ["\xBB\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],

        ["\xBB\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],
        ["\xBB\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],

        ["\xBB\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\xBB\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],

        ["\xBB\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\xBB\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],

        ["\xBB\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\xBB\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],

        ["\xBB\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\xBB\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],

        ["\xBB\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\xBB\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],

        ["\xBB\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xBB\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],

        ["\xBB\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],
        ["\xBB\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],

        ["\xBB\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\xBB\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],

        ["\xBB\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],
        ["\xBB\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],

        ["\xBB\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\xBB\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],

        ["\xBB\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],
        ["\xBB\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],

        ["\xBB\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\xBB\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],

        ["\xBB\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],
        ["\xBB\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],

        ["\xBB\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],
        ["\xBB\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],

        ["\xBB\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],
        ["\xBB\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],

        ["\xBB\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xBB\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],

        ["\xBB\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],
        ["\xBB\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],

        ["\xBB\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\xBB\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],

        ["\xBB\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],
        ["\xBB\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],

        ["\xBB\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\xBB\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],

        ["\xBB\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],
        ["\xBB\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],

        ["\xBB\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xBB\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],

        ["\xBB\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\xBB\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],

        ["\xBB\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],
        ["\xBB\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],

        ["\xBB\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\xBB\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],

        ["\xBB\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xBB\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],

        ["\xBB\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],
        ["\xBB\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],

        ["\xBB\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],
        ["\xBB\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],

        ["\xBB\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],
        ["\xBB\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],

        ["\xBB\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],
        ["\xBB\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],

        ["\xBB\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],
        ["\xBB\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],

        ["\xBB\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\xBB\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],

        ["\xBB\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\xBB\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],

        ["\xBB\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\xBB\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],

        ["\xBB\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],
        ["\xBB\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],

        ["\xBB\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],
        ["\xBB\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],

        ["\xBB\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\xBB\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],

        ["\xBB\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],
        ["\xBB\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],

        ["\xBB\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],
        ["\xBB\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],

        ["\xBB\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],
        ["\xBB\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],

        ["\xBB\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],
        ["\xBB\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],

        ["\xBB\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],
        ["\xBB\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],

        ["\xBB\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\xBB\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],

        ["\xBB\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xBB\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],

        ["\xBB\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],
        ["\xBB\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],

        ["\xBB\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\xBB\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],

        ["\xBB\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\xBB\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],

        ["\xBB\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xBB\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],

        ["\xBB\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\xBB\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],

        ["\xBB\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],
        ["\xBB\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],

        ["\xBB\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xBB\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],

        ["\xBB\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],
        ["\xBB\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],

        ["\xBB\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],
        ["\xBB\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],

        ["\xBB\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],
        ["\xBB\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],

        ["\xBB\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],
        ["\xBB\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],

        ["\xBB\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\xBB\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],

        ["\xBB\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\xBB\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],

        ["\xBB\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],
        ["\xBB\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],

        ["\xBB\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],
        ["\xBB\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],

        ["\xBB\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],
        ["\xBB\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],

        ["\xBB\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],
        ["\xBB\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],

        ["\xBB\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\xBB\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],

        ["\xBB\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\xBB\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],

        ["\xBB\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],
        ["\xBB\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],

        ["\xBC\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],
        ["\xBC\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],

        ["\xBC\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\xBC\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],

        ["\xBC\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],
        ["\xBC\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],

        ["\xBC\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],
        ["\xBC\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],

        ["\xBC\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xBC\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],

        ["\xBC\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\xBC\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],

        ["\xBC\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\xBC\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],

        ["\xBC\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\xBC\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],

        ["\xBC\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\xBC\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],

        ["\xBC\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],
        ["\xBC\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],

        ["\xBC\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\xBC\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],

        ["\xBC\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xBC\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],

        ["\xBC\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],
        ["\xBC\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],

        ["\xBC\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],
        ["\xBC\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],

        ["\xBC\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],
        ["\xBC\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],

        ["\xBC\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],
        ["\xBC\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],

        ["\xBC\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xBC\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],

        ["\xBC\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\xBC\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],

        ["\xBC\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\xBC\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],

        ["\xBC\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xBC\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],

        ["\xBC\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\xBC\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],

        ["\xBC\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\xBC\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],

        ["\xBC\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],
        ["\xBC\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],

        ["\xBC\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xBC\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],

        ["\xBC\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],
        ["\xBC\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],

        ["\xBC\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xBC\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],

        ["\xBC\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\xBC\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],

        ["\xBC\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],
        ["\xBC\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],

        ["\xBC\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xBC\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],

        ["\xBC\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],
        ["\xBC\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],

        ["\xBC\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\xBC\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],

        ["\xBC\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\xBC\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],

        ["\xBC\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],
        ["\xBC\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],

        ["\xBC\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],
        ["\xBC\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],

        ["\xBC\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],
        ["\xBC\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],

        ["\xBC\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xBC\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],

        ["\xBC\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\xBC\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],

        ["\xBC\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\xBC\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],

        ["\xBC\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\xBC\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],

        ["\xBC\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],
        ["\xBC\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],

        ["\xBC\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE9\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],

        ["\xBC\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\xBC\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],

        ["\xBC\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],
        ["\xBC\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],

        ["\xBC\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],
        ["\xBC\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],

        ["\xBC\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\xBC\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],

        ["\xBC\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],
        ["\xBC\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],

        ["\xBC\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\xBC\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],

        ["\xBC\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\xBC\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],

        ["\xBC\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\xBC\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],

        ["\xBC\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],
        ["\xBC\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],

        ["\xBC\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],
        ["\xBC\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],

        ["\xBC\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],
        ["\xBC\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],

        ["\xBC\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\xBC\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],

        ["\xBC\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\xBC\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],

        ["\xBC\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\xBC\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],

        ["\xBC\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],
        ["\xBC\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],

        ["\xBC\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\xBC\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],

        ["\xBC\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],
        ["\xBC\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],

        ["\xBC\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xBC\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],

        ["\xBC\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xBC\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],

        ["\xBC\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],
        ["\xBC\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],

        ["\xBC\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xBC\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],

        ["\xBC\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],
        ["\xBC\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],

        ["\xBC\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xBC\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],

        ["\xBC\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xBC\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],

        ["\xBC\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\xBC\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],

        ["\xBC\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],
        ["\xBC\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],

        ["\xBC\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\xBC\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],

        ["\xBC\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\xBC\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],

        ["\xBC\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\xBC\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],

        ["\xBC\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],
        ["\xBC\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],

        ["\xBC\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],
        ["\xBC\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],

        ["\xBC\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],
        ["\xBC\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],

        ["\xBC\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],
        ["\xBC\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],

        ["\xBC\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],
        ["\xBC\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],

        ["\xBC\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\xBC\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],

        ["\xBC\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],
        ["\xBC\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],

        ["\xBC\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\xBC\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],

        ["\xBC\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],
        ["\xBC\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],

        ["\xBC\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],
        ["\xBC\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],

        ["\xBC\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\xBC\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],

        ["\xBC\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],
        ["\xBC\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],

        ["\xBC\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],
        ["\xBC\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],

        ["\xBC\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],
        ["\xBC\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],

        ["\xBC\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],
        ["\xBC\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],

        ["\xBC\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],
        ["\xBC\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],

        ["\xBC\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],
        ["\xBC\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],

        ["\xBC\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],
        ["\xBC\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],

        ["\xBC\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],
        ["\xBC\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],

        ["\xBC\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],
        ["\xBC\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],

        ["\xBC\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],
        ["\xBC\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],

        ["\xBC\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\xBC\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],

        ["\xBC\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],
        ["\xBC\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],

        ["\xBC\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],
        ["\xBC\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],

        ["\xBD\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],
        ["\xBD\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],

        ["\xBD\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\xBD\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],

        ["\xBD\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],
        ["\xBD\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],

        ["\xBD\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],
        ["\xBD\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],

        ["\xBD\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\xBD\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],

        ["\xBD\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\xBD\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],

        ["\xBD\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],
        ["\xBD\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],

        ["\xBD\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\xBD\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],

        ["\xBD\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\xBD\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],

        ["\xBD\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xBD\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],

        ["\xBD\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],
        ["\xBD\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],

        ["\xBD\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],
        ["\xBD\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],

        ["\xBD\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\xBD\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],

        ["\xBD\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],
        ["\xBD\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],

        ["\xBD\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\xBD\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],

        ["\xBD\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],
        ["\xBD\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],

        ["\xBD\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\xBD\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],

        ["\xBD\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\xBD\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],

        ["\xBD\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xBD\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],

        ["\xBD\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],
        ["\xBD\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],

        ["\xBD\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],
        ["\xBD\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],

        ["\xBD\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xBD\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],

        ["\xBD\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],
        ["\xBD\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],

        ["\xBD\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],
        ["\xBD\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],

        ["\xBD\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xBD\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],

        ["\xBD\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\xBD\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],

        ["\xBD\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xBD\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],

        ["\xBD\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\xBD\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],

        ["\xBD\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xBD\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],

        ["\xBD\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],
        ["\xBD\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],

        ["\xBD\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\xBD\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],

        ["\xBD\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xBD\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],

        ["\xBD\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],
        ["\xBD\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],

        ["\xBD\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],
        ["\xBD\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],

        ["\xBD\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xBD\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],

        ["\xBD\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xBD\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],

        ["\xBD\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],
        ["\xBD\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],

        ["\xBD\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],
        ["\xBD\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],

        ["\xBD\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],
        ["\xBD\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],

        ["\xBD\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xBD\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],

        ["\xBD\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xBD\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],

        ["\xBD\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],
        ["\xBD\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],

        ["\xBD\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],
        ["\xBD\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],

        ["\xBD\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\xBD\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],

        ["\xBD\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],
        ["\xBD\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],

        ["\xBD\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],
        ["\xBD\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],

        ["\xBD\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\xBD\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],

        ["\xBD\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\xBD\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],

        ["\xBD\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xBD\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],

        ["\xBD\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\xBD\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],

        ["\xBD\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],
        ["\xBD\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],

        ["\xBD\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],
        ["\xBD\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],

        ["\xBD\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\xBD\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],

        ["\xBD\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],
        ["\xBD\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],

        ["\xBD\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],
        ["\xBD\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],

        ["\xBD\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],
        ["\xBD\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],

        ["\xBD\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xBD\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],

        ["\xBD\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],
        ["\xBD\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],

        ["\xBD\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\xBD\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],

        ["\xBD\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\xBD\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],

        ["\xBD\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],
        ["\xBD\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],

        ["\xBD\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],
        ["\xBD\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],

        ["\xBD\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],
        ["\xBD\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],

        ["\xBD\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xBD\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],

        ["\xBD\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\xBD\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],

        ["\xBD\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\xBD\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],

        ["\xBD\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xBD\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],

        ["\xBD\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],
        ["\xBD\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],

        ["\xBD\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],
        ["\xBD\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],

        ["\xBD\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],
        ["\xBD\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],

        ["\xBD\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\xBD\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],

        ["\xBD\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],
        ["\xBD\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],

        ["\xBD\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],
        ["\xBD\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],

        ["\xBD\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],
        ["\xBD\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],

        ["\xBD\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],
        ["\xBD\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],

        ["\xBD\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],
        ["\xBD\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],

        ["\xBD\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],
        ["\xBD\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],

        ["\xBD\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\xBD\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],

        ["\xBD\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],
        ["\xBD\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],

        ["\xBD\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\xBD\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],

        ["\xBD\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xBD\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],

        ["\xBD\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xBD\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],

        ["\xBD\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],
        ["\xBD\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],

        ["\xBD\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\xBD\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],

        ["\xBD\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\xBD\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],

        ["\xBD\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],
        ["\xBD\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],

        ["\xBD\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xBD\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],

        ["\xBD\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],
        ["\xBD\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],

        ["\xBD\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],
        ["\xBD\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],

        ["\xBD\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],
        ["\xBD\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],

        ["\xBD\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],
        ["\xBD\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],

        ["\xBD\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],
        ["\xBD\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],

        ["\xBD\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],
        ["\xBD\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],

        ["\xBD\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xBD\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],

        ["\xBE\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\xBE\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],

        ["\xBE\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\xBE\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],

        ["\xBE\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],
        ["\xBE\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],

        ["\xBE\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],
        ["\xBE\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],

        ["\xBE\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],
        ["\xBE\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],

        ["\xBE\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\xBE\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],

        ["\xBE\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\xBE\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],

        ["\xBE\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\xBE\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],

        ["\xBE\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],
        ["\xBE\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],

        ["\xBE\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],
        ["\xBE\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],

        ["\xBE\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xBE\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],

        ["\xBE\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],
        ["\xBE\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],

        ["\xBE\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],
        ["\xBE\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],

        ["\xBE\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\xBE\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],

        ["\xBE\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],
        ["\xBE\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],

        ["\xBE\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],
        ["\xBE\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],

        ["\xBE\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\xBE\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],

        ["\xBE\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],
        ["\xBE\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],

        ["\xBE\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],
        ["\xBE\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],

        ["\xBE\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\xBE\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],

        ["\xBE\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\xBE\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],

        ["\xBE\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\xBE\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],

        ["\xBE\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xBE\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],

        ["\xBE\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],
        ["\xBE\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],

        ["\xBE\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],
        ["\xBE\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],

        ["\xBE\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\xBE\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],

        ["\xBE\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\xBE\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],

        ["\xBE\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],
        ["\xBE\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],

        ["\xBE\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],
        ["\xBE\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],

        ["\xBE\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],
        ["\xBE\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],

        ["\xBE\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],
        ["\xBE\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],

        ["\xBE\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],
        ["\xBE\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],

        ["\xBE\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],
        ["\xBE\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],

        ["\xBE\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xBE\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],

        ["\xBE\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xBE\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],

        ["\xBE\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\xBE\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],

        ["\xBE\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],
        ["\xBE\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],

        ["\xBE\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],
        ["\xBE\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],

        ["\xBE\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],
        ["\xBE\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],

        ["\xBE\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xBE\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],

        ["\xBE\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\xBE\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],

        ["\xBE\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\xBE\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],

        ["\xBE\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],
        ["\xBE\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],

        ["\xBE\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],
        ["\xBE\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],

        ["\xBE\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xBE\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],

        ["\xBE\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],
        ["\xBE\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],

        ["\xBE\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],
        ["\xBE\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],

        ["\xBE\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],
        ["\xBE\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],

        ["\xBE\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],
        ["\xBE\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],

        ["\xBE\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\xBE\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],

        ["\xBE\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],
        ["\xBE\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],

        ["\xBE\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xBE\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],

        ["\xBE\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],
        ["\xBE\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],

        ["\xBE\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],
        ["\xBE\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],

        ["\xBE\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xBE\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],

        ["\xBE\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],
        ["\xBE\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],

        ["\xBE\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],
        ["\xBE\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],

        ["\xBE\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],
        ["\xBE\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],

        ["\xBE\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],
        ["\xBE\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],

        ["\xBE\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\xBE\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],

        ["\xBE\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],
        ["\xBE\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],

        ["\xBE\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],
        ["\xBE\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],

        ["\xBE\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],
        ["\xBE\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],

        ["\xBE\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],
        ["\xBE\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],

        ["\xBE\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],
        ["\xBE\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],

        ["\xBE\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],
        ["\xBE\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],

        ["\xBE\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\xBE\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],

        ["\xBE\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\xBE\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],

        ["\xBE\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xBE\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],

        ["\xBE\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\xBE\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],

        ["\xBE\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],
        ["\xBE\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],

        ["\xBE\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],
        ["\xBE\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],

        ["\xBE\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],
        ["\xBE\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],

        ["\xBE\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],
        ["\xBE\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],

        ["\xBE\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xBE\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],

        ["\xBE\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\xBE\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],

        ["\xBE\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],
        ["\xBE\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],

        ["\xBE\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\xBE\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],

        ["\xBE\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],
        ["\xBE\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],

        ["\xBE\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xBE\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],

        ["\xBE\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xBE\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],

        ["\xBE\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],
        ["\xBE\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],

        ["\xBE\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],
        ["\xBE\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],

        ["\xBE\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],
        ["\xBE\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],

        ["\xBE\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],
        ["\xBE\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],

        ["\xBE\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],
        ["\xBE\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],

        ["\xBE\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\xBE\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],

        ["\xBE\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],
        ["\xBE\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],

        ["\xBE\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xBE\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],

        ["\xBE\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],
        ["\xBE\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],

        ["\xBE\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xBE\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],

        ["\xBE\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],
        ["\xBE\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],

        ["\xBE\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],
        ["\xBE\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],

        ["\xBE\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],
        ["\xBE\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],

        ["\xBF\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],
        ["\xBF\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],

        ["\xBF\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],
        ["\xBF\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],

        ["\xBF\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],
        ["\xBF\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],

        ["\xBF\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\xBF\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],

        ["\xBF\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],
        ["\xBF\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],

        ["\xBF\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],
        ["\xBF\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],

        ["\xBF\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],
        ["\xBF\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],

        ["\xBF\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\xBF\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],

        ["\xBF\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],
        ["\xBF\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],

        ["\xBF\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xBF\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],

        ["\xBF\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],
        ["\xBF\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],

        ["\xBF\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],
        ["\xBF\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],

        ["\xBF\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],
        ["\xBF\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],

        ["\xBF\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],
        ["\xBF\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],

        ["\xBF\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],
        ["\xBF\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],

        ["\xBF\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],
        ["\xBF\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],

        ["\xBF\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],
        ["\xBF\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],

        ["\xBF\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\xBF\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],

        ["\xBF\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],
        ["\xBF\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],

        ["\xBF\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],
        ["\xBF\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],

        ["\xBF\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],
        ["\xBF\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],

        ["\xBF\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],
        ["\xBF\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],

        ["\xBF\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\xBF\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],

        ["\xBF\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],
        ["\xBF\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],

        ["\xBF\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\xBF\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],

        ["\xBF\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xBF\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],

        ["\xBF\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xBF\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],

        ["\xBF\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xBF\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],

        ["\xBF\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\xBF\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],

        ["\xBF\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],
        ["\xBF\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],

        ["\xBF\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xBF\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],

        ["\xBF\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xBF\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],

        ["\xBF\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],
        ["\xBF\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],

        ["\xBF\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],
        ["\xBF\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],

        ["\xBF\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],
        ["\xBF\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],

        ["\xBF\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xBF\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],

        ["\xBF\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],
        ["\xBF\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],

        ["\xBF\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\xBF\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],

        ["\xBF\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],
        ["\xBF\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],

        ["\xBF\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\xBF\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],

        ["\xBF\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],
        ["\xBF\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],

        ["\xBF\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xBF\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],

        ["\xBF\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],
        ["\xBF\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],

        ["\xBF\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xBF\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],

        ["\xBF\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],
        ["\xBF\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],

        ["\xBF\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xBF\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],

        ["\xBF\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\xBF\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],

        ["\xBF\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],
        ["\xBF\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],

        ["\xBF\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\xBF\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],

        ["\xBF\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],
        ["\xBF\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],

        ["\xBF\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],
        ["\xBF\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],

        ["\xBF\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],
        ["\xBF\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],

        ["\xBF\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],
        ["\xBF\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],

        ["\xBF\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],
        ["\xBF\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],

        ["\xBF\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],
        ["\xBF\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],

        ["\xBF\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\xBF\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],

        ["\xBF\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xF0\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],

        ["\xBF\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],
        ["\xBF\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],

        ["\xBF\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],
        ["\xBF\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],

        ["\xBF\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\xBF\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],

        ["\xBF\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\xBF\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],

        ["\xBF\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],
        ["\xBF\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],

        ["\xBF\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xBF\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],

        ["\xBF\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],
        ["\xBF\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],

        ["\xBF\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],
        ["\xBF\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],

        ["\xBF\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],
        ["\xBF\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],

        ["\xBF\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\xBF\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],

        ["\xBF\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xBF\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],

        ["\xBF\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],
        ["\xBF\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],

        ["\xBF\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],
        ["\xBF\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],

        ["\xBF\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xBF\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],

        ["\xBF\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],
        ["\xBF\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],

        ["\xBF\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xBF\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],

        ["\xBF\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],
        ["\xBF\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],

        ["\xBF\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],
        ["\xBF\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],

        ["\xBF\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xBF\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],

        ["\xBF\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],
        ["\xBF\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],

        ["\xBF\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],
        ["\xBF\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],

        ["\xBF\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],
        ["\xBF\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],

        ["\xBF\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xBF\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],

        ["\xBF\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],
        ["\xBF\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],

        ["\xBF\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],
        ["\xBF\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],

        ["\xBF\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],
        ["\xBF\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],

        ["\xBF\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],
        ["\xBF\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],

        ["\xBF\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],
        ["\xBF\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],

        ["\xBF\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],
        ["\xBF\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],

        ["\xBF\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],
        ["\xBF\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],

        ["\xBF\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xBF\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],

        ["\xBF\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\xBF\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],

        ["\xBF\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xBF\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],

        ["\xBF\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],
        ["\xBF\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],

        ["\xBF\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\xBF\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],

        ["\xBF\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\xBF\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],

        ["\xBF\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\xBF\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],

        ["\xC0\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],
        ["\xC0\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],

        ["\xC0\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],
        ["\xC0\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],

        ["\xC0\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\xC0\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],

        ["\xC0\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],
        ["\xC0\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],

        ["\xC0\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],
        ["\xC0\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],

        ["\xC0\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\xC0\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],

        ["\xC0\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xC0\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],

        ["\xC0\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xC0\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],

        ["\xC0\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],
        ["\xC0\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],

        ["\xC0\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xC0\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],

        ["\xC0\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],
        ["\xC0\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],

        ["\xC0\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],
        ["\xC0\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],

        ["\xC0\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\xC0\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],

        ["\xC0\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\xC0\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],

        ["\xC0\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\xC0\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],

        ["\xC0\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\xC0\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],

        ["\xC0\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],
        ["\xC0\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],

        ["\xC0\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xC0\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],

        ["\xC0\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xC0\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],

        ["\xC0\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],
        ["\xC0\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],

        ["\xC0\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xC0\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],

        ["\xC0\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],
        ["\xC0\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],

        ["\xC0\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],
        ["\xC0\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],

        ["\xC0\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],
        ["\xC0\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],

        ["\xC0\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\xC0\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],

        ["\xC0\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],
        ["\xC0\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],

        ["\xC0\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],
        ["\xC0\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],

        ["\xC0\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\xC0\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],

        ["\xC0\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\xC0\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],

        ["\xC0\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xC0\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],

        ["\xC0\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],
        ["\xC0\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],

        ["\xC0\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],
        ["\xC0\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],

        ["\xC0\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],
        ["\xC0\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],

        ["\xC0\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],
        ["\xC0\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],

        ["\xC0\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],
        ["\xC0\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],

        ["\xC0\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\xC0\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],

        ["\xC0\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\xC0\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],

        ["\xC0\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xC0\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],

        ["\xC0\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\xC0\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],

        ["\xC0\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],
        ["\xC0\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],

        ["\xC0\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],
        ["\xC0\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],

        ["\xC0\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],
        ["\xC0\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],

        ["\xC0\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\xC0\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],

        ["\xC0\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],
        ["\xC0\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],

        ["\xC0\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],
        ["\xC0\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],

        ["\xC0\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],
        ["\xC0\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],

        ["\xC0\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],
        ["\xC0\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],

        ["\xC0\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\xC0\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],

        ["\xC0\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],
        ["\xC0\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],

        ["\xC0\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xC0\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],

        ["\xC0\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],
        ["\xC0\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],

        ["\xC0\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xC0\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],

        ["\xC0\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],
        ["\xC0\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],

        ["\xC0\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xC0\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],

        ["\xC0\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],
        ["\xC0\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],

        ["\xC0\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\xC0\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],

        ["\xC0\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xC0\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],

        ["\xC0\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],
        ["\xC0\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],

        ["\xC0\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],
        ["\xC0\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],

        ["\xC0\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],
        ["\xC0\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],

        ["\xC0\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xC0\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],

        ["\xC0\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],
        ["\xC0\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],

        ["\xC0\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],
        ["\xC0\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],

        ["\xC0\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\xC0\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],

        ["\xC0\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\xC0\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],

        ["\xC0\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\xC0\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],

        ["\xC0\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\xC0\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],

        ["\xC0\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],
        ["\xC0\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],

        ["\xC0\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xC0\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],

        ["\xC0\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],
        ["\xC0\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],

        ["\xC0\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],
        ["\xC0\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],

        ["\xC0\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\xC0\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],

        ["\xC0\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\xC0\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],

        ["\xC0\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xC0\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],

        ["\xC0\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xC0\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],

        ["\xC0\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],
        ["\xC0\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],

        ["\xC0\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],
        ["\xC0\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],

        ["\xC0\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],
        ["\xC0\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],

        ["\xC0\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],
        ["\xC0\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],

        ["\xC0\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xC0\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],

        ["\xC0\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],
        ["\xC0\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],

        ["\xC0\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xC0\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],

        ["\xC0\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],
        ["\xC0\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],

        ["\xC0\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xC0\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],

        ["\xC0\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\xC0\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],

        ["\xC0\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],
        ["\xC0\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],

        ["\xC0\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xC0\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],

        ["\xC0\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],
        ["\xC0\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],

        ["\xC0\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],
        ["\xC0\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],

        ["\xC0\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],
        ["\xC0\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],

        ["\xC0\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],
        ["\xC0\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],

        ["\xC0\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\xC0\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],

        ["\xC0\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],
        ["\xC0\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],

        ["\xC0\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xC0\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],

        ["\xC1\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xC1\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],

        ["\xC1\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xC1\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],

        ["\xC1\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],
        ["\xC1\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],

        ["\xC1\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xC1\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],

        ["\xC1\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],
        ["\xC1\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],

        ["\xC1\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xC1\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],

        ["\xC1\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xC1\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],

        ["\xC1\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\xEC\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],

        ["\xC1\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],
        ["\xC1\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],

        ["\xC1\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xC1\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],

        ["\xC1\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xC1\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],

        ["\xC1\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],
        ["\xC1\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],

        ["\xC1\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],
        ["\xC1\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],

        ["\xC1\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xC1\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],

        ["\xC1\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xC1\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],

        ["\xC1\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xC1\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],

        ["\xC1\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xC1\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],

        ["\xC1\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xC1\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],

        ["\xC1\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],
        ["\xC1\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],

        ["\xC1\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xC1\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],

        ["\xC1\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xC1\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],

        ["\xC1\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],
        ["\xC1\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],

        ["\xC1\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xC1\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],

        ["\xC1\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xC1\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],

        ["\xC1\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],
        ["\xC1\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],

        ["\xC1\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],
        ["\xC1\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],

        ["\xC1\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xC1\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],

        ["\xC1\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],
        ["\xC1\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],

        ["\xC1\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xC1\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],

        ["\xC1\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],
        ["\xC1\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],

        ["\xC1\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xC1\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],

        ["\xC1\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xC1\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],

        ["\xC1\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xC1\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],

        ["\xC1\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xC1\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],

        ["\xC1\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xC1\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],

        ["\xC1\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xC1\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],

        ["\xC1\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xC1\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],

        ["\xC1\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xC1\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],

        ["\xC1\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xC1\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],

        ["\xC1\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xC1\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],

        ["\xC1\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xC1\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],

        ["\xC1\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xC1\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],

        ["\xC1\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xC1\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],

        ["\xC1\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xC1\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],

        ["\xC1\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],
        ["\xC1\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],

        ["\xC1\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],
        ["\xC1\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],

        ["\xC1\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],
        ["\xC1\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],

        ["\xC1\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xC1\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],

        ["\xC1\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xC1\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],

        ["\xC1\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xC1\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],

        ["\xC1\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xC1\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],

        ["\xC1\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xC1\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],

        ["\xC1\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xC1\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],

        ["\xC1\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xC1\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],

        ["\xC1\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xC1\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],

        ["\xC1\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xC1\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],

        ["\xC1\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xC1\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],

        ["\xC1\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],
        ["\xC1\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],

        ["\xC1\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xC1\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],

        ["\xC1\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xC1\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],

        ["\xC1\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xC1\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],

        ["\xC1\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xC1\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],

        ["\xC1\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xC1\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],

        ["\xC1\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xC1\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],

        ["\xC1\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xC1\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],

        ["\xC1\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xC1\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],

        ["\xC1\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xC1\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],

        ["\xC1\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xC1\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],

        ["\xC1\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xC1\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],

        ["\xC1\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xC1\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],

        ["\xC1\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xC1\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],

        ["\xC1\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xC1\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],

        ["\xC1\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xC1\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],

        ["\xC1\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],
        ["\xC1\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],

        ["\xC1\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],
        ["\xC1\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],

        ["\xC1\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],
        ["\xC1\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],

        ["\xC1\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xC1\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],

        ["\xC1\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],
        ["\xC1\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],

        ["\xC1\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],
        ["\xC1\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],

        ["\xC1\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xC1\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],

        ["\xC1\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xC1\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],

        ["\xC1\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xC1\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],

        ["\xC1\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xC1\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],

        ["\xC1\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xC1\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],

        ["\xC1\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xC1\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],

        ["\xC1\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xC1\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],

        ["\xC1\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xC1\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],

        ["\xC1\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xC1\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],

        ["\xC1\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xC1\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],

        ["\xC1\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],
        ["\xC1\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],

        ["\xC1\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],
        ["\xC1\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],

        ["\xC1\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],
        ["\xC1\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],

        ["\xC1\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xC1\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],

        ["\xC1\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],
        ["\xC1\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],

        ["\xC2\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xC2\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],

        ["\xC2\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],
        ["\xC2\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],

        ["\xC2\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],
        ["\xC2\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],

        ["\xC2\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],
        ["\xC2\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],

        ["\xC2\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xC2\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],

        ["\xC2\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xC2\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],

        ["\xC2\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xC2\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],

        ["\xC2\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xC2\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],

        ["\xC2\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],
        ["\xC2\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],

        ["\xC2\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],
        ["\xC2\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],

        ["\xC2\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xC2\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],

        ["\xC2\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xC2\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],

        ["\xC2\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],
        ["\xC2\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],

        ["\xC2\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],
        ["\xC2\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],

        ["\xC2\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],
        ["\xC2\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],

        ["\xC2\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xC2\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xC2\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xC2\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],

        ["\xC2\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xC2\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],

        ["\xC2\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],
        ["\xC2\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],

        ["\xC2\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xC2\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],

        ["\xC2\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xC2\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],

        ["\xC2\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xC2\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],

        ["\xC2\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],
        ["\xC2\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],

        ["\xC2\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],
        ["\xC2\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],

        ["\xC2\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],
        ["\xC2\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],

        ["\xC2\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xC2\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],

        ["\xC2\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],
        ["\xC2\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],

        ["\xC2\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xC2\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],

        ["\xC2\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xC2\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],

        ["\xC2\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xC2\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],

        ["\xC2\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xC2\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],

        ["\xC2\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xC2\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],

        ["\xC2\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xC2\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],

        ["\xC2\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xC2\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],

        ["\xC2\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xC2\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],

        ["\xC2\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xC2\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],

        ["\xC2\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xC2\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],

        ["\xC2\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xC2\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],

        ["\xC2\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xC2\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],

        ["\xC2\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xC2\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],

        ["\xC2\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xC2\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],

        ["\xC2\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xC2\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],

        ["\xC2\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],
        ["\xC2\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],

        ["\xC2\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],
        ["\xC2\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],

        ["\xC2\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xC2\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],

        ["\xC2\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xC2\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],

        ["\xC2\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xC2\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],

        ["\xC2\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xC2\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],

        ["\xC2\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xC2\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],

        ["\xC2\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xC2\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],

        ["\xC2\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xC2\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],

        ["\xC2\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xC2\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],

        ["\xC2\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xC2\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],

        ["\xC2\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xC2\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],

        ["\xC2\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xC2\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],

        ["\xC2\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xC2\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],

        ["\xC2\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xC2\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],

        ["\xC2\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xC2\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],

        ["\xC2\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],
        ["\xC2\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],

        ["\xC2\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],
        ["\xC2\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],

        ["\xC2\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],
        ["\xC2\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],

        ["\xC2\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],
        ["\xC2\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],

        ["\xC2\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xC2\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],

        ["\xC2\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xC2\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],

        ["\xC2\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],
        ["\xC2\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],

        ["\xC2\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xC2\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],

        ["\xC2\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xC2\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],

        ["\xC2\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xC2\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],

        ["\xC2\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xC2\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],

        ["\xC2\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xC2\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],

        ["\xC2\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xC2\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],

        ["\xC2\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xC2\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],

        ["\xC2\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xC2\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],

        ["\xC2\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],
        ["\xC2\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],

        ["\xC2\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],
        ["\xC2\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],

        ["\xC2\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xC2\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],

        ["\xC2\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],
        ["\xC2\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],

        ["\xC2\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xC2\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],

        ["\xC2\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],
        ["\xC2\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],

        ["\xC2\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xC2\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],

        ["\xC2\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xC2\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],

        ["\xC2\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xC2\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],

        ["\xC2\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xC2\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],

        ["\xC2\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xC2\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],

        ["\xC2\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xC2\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],

        ["\xC2\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xC2\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],

        ["\xC2\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xC2\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],

        ["\xC2\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xC2\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],

        ["\xC2\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xC2\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],

        ["\xC2\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],
        ["\xC2\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],

        ["\xC2\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xC2\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],

        ["\xC2\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xC2\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],

        ["\xC2\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xC2\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],

        ["\xC2\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xC2\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],

        ["\xC3\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xC3\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],

        ["\xC3\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xC3\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],

        ["\xC3\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],
        ["\xC3\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],

        ["\xC3\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\xC3\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],

        ["\xC3\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],
        ["\xC3\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],

        ["\xC3\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xC3\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],

        ["\xC3\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xC3\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],

        ["\xC3\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xC3\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],

        ["\xC3\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\xC3\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],

        ["\xC3\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\xC3\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],

        ["\xC3\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xC3\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],

        ["\xC3\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xC3\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],

        ["\xC3\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\xC3\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],

        ["\xC3\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xC3\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],

        ["\xC3\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xC3\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],

        ["\xC3\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xC3\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],

        ["\xC3\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\xC3\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],

        ["\xC3\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xC3\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],

        ["\xC3\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\xC3\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],

        ["\xC3\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\xC3\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],

        ["\xC3\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xC3\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],

        ["\xC3\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\xC3\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],

        ["\xC3\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xC3\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],

        ["\xC3\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xC3\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],

        ["\xC3\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\xC3\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],

        ["\xC3\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xC3\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],

        ["\xC3\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xC3\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],

        ["\xC3\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xC3\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],

        ["\xC3\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xC3\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],

        ["\xC3\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xC3\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],

        ["\xC3\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\xC3\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],

        ["\xC3\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xC3\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],

        ["\xC3\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xC3\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],

        ["\xC3\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xC3\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],

        ["\xC3\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xC3\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],

        ["\xC3\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xC3\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],

        ["\xC3\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xC3\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],

        ["\xC3\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xC3\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],

        ["\xC3\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xC3\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],

        ["\xC3\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xC3\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],

        ["\xC3\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xC3\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],

        ["\xC3\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xC3\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],

        ["\xC3\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],
        ["\xC3\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],

        ["\xC3\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],
        ["\xC3\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],

        ["\xC3\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],
        ["\xC3\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],

        ["\xC3\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xC3\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],

        ["\xC3\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xC3\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],

        ["\xC3\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xC3\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],

        ["\xC3\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xC3\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],

        ["\xC3\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xC3\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],

        ["\xC3\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xC3\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],

        ["\xC3\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xC3\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],

        ["\xC3\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xC3\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],

        ["\xC3\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xC3\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],

        ["\xC3\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xC3\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],

        ["\xC3\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xC3\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],

        ["\xC3\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xC3\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],

        ["\xC3\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xC3\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],

        ["\xC3\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xC3\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],

        ["\xC3\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xC3\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],

        ["\xC3\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xC3\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],

        ["\xC3\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xC3\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],

        ["\xC3\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xC3\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],

        ["\xC3\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xC3\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],

        ["\xC3\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xC3\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],

        ["\xC3\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xC3\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],

        ["\xC3\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xC3\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],

        ["\xC3\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xC3\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],

        ["\xC3\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xC3\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],

        ["\xC3\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xC3\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],

        ["\xC3\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xC3\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],

        ["\xC3\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xC3\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],

        ["\xC3\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xC3\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],

        ["\xC3\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xC3\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],

        ["\xC3\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],
        ["\xC3\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],

        ["\xC3\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xC3\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],

        ["\xC3\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],
        ["\xC3\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],

        ["\xC3\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xC3\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],

        ["\xC3\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xC3\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],

        ["\xC3\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xC3\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],

        ["\xC3\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xC3\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],

        ["\xC3\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xC3\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],

        ["\xC3\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xC3\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],

        ["\xC3\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xC3\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],

        ["\xC3\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xC3\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],

        ["\xC3\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xC3\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],

        ["\xC3\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xC3\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],

        ["\xC3\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xC3\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],

        ["\xC3\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xC3\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],

        ["\xC3\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],
        ["\xC3\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],

        ["\xC3\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xC3\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],

        ["\xC3\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xC3\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],

        ["\xC3\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],
        ["\xC3\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],

        ["\xC3\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xC3\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],

        ["\xC4\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xC4\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],

        ["\xC4\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],
        ["\xC4\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],

        ["\xC4\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xC4\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],

        ["\xC4\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],
        ["\xC4\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],

        ["\xC4\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],
        ["\xC4\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],

        ["\xC4\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],
        ["\xC4\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],

        ["\xC4\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],
        ["\xC4\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],

        ["\xC4\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],
        ["\xC4\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],

        ["\xC4\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xC4\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],

        ["\xC4\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],
        ["\xC4\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],

        ["\xC4\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xC4\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],

        ["\xC4\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xC4\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],

        ["\xC4\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],
        ["\xC4\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],

        ["\xC4\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],
        ["\xC4\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],

        ["\xC4\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],
        ["\xC4\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],

        ["\xC4\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xC4\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],

        ["\xC4\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xC4\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],

        ["\xC4\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],
        ["\xC4\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],

        ["\xC4\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],
        ["\xC4\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],

        ["\xC4\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xC4\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],

        ["\xC4\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],
        ["\xC4\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],

        ["\xC4\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xC4\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],

        ["\xC4\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xC4\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],

        ["\xC4\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],
        ["\xC4\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],

        ["\xC4\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],
        ["\xC4\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],

        ["\xC4\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xC4\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],

        ["\xC4\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xC4\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],

        ["\xC4\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xC4\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],

        ["\xC4\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xC4\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],

        ["\xC4\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],
        ["\xC4\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],

        ["\xC4\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],
        ["\xC4\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],

        ["\xC4\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xC4\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],

        ["\xC4\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xC4\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],

        ["\xC4\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xC4\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],

        ["\xC4\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xC4\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],

        ["\xC4\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xC4\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],

        ["\xC4\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xC4\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],

        ["\xC4\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xC4\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],

        ["\xC4\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xC4\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],

        ["\xC4\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xC4\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],

        ["\xC4\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xC4\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],

        ["\xC4\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],
        ["\xC4\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],

        ["\xC4\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],
        ["\xC4\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],

        ["\xC4\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],
        ["\xC4\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],

        ["\xC4\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],
        ["\x47\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],

        ["\xC4\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],
        ["\xC4\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],

        ["\xC4\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],
        ["\xC4\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],

        ["\xC4\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xC4\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],

        ["\xC4\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xC4\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],

        ["\xC4\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xC4\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],

        ["\xC4\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xC4\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],

        ["\xC4\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xC4\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],

        ["\xC4\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xC4\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],

        ["\xC4\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xC4\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],

        ["\xC4\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xC4\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],

        ["\xC4\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xC4\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],

        ["\xC4\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xC4\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],

        ["\xC4\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xC4\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],

        ["\xC4\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xD4\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],

        ["\xC4\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],
        ["\xC4\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],

        ["\xC4\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],
        ["\xC4\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],

        ["\xC4\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],
        ["\xC4\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],

        ["\xC4\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xC4\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],

        ["\xC4\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xC4\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],

        ["\xC4\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xC4\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],

        ["\xC4\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xC4\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],

        ["\xC4\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xC4\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],

        ["\xC4\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xC4\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],

        ["\xC4\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xC4\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],

        ["\xC4\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xC4\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],

        ["\xC4\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xC4\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],

        ["\xC4\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xC4\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],

        ["\xC4\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xC4\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],

        ["\xC4\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xC4\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],

        ["\xC4\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],
        ["\xC4\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],

        ["\xC4\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xC4\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],

        ["\xC4\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xC4\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],

        ["\xC4\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xC4\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],

        ["\xC4\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xC4\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],

        ["\xC4\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xC4\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],

        ["\xC4\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xC4\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],

        ["\xC4\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xC4\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],

        ["\xC4\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xC4\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],

        ["\xC4\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xC4\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],

        ["\xC4\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xC4\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],

        ["\xC4\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xC4\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],

        ["\xC4\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xC4\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],

        ["\xC4\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xC4\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],

        ["\xC4\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xC4\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],

        ["\xC4\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],
        ["\xC4\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],

        ["\xC4\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xC4\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],

        ["\xC4\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xC4\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],

        ["\xC4\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],
        ["\xC4\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],

        ["\xC4\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],
        ["\xC4\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],

        ["\xC5\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xC5\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],

        ["\xC5\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],
        ["\xC5\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],

        ["\xC5\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xC5\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],

        ["\xC5\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],
        ["\xC5\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],

        ["\xC5\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],
        ["\xC5\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],

        ["\xC5\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xC5\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],

        ["\xC5\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xC5\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],

        ["\xC5\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],
        ["\xC5\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],

        ["\xC5\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xC5\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],

        ["\xC5\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],
        ["\xC5\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],

        ["\xC5\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xC5\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],

        ["\xC5\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xC5\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],

        ["\xC5\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xC5\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],

        ["\xC5\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xC5\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],

        ["\xC5\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xC5\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],

        ["\xC5\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xC5\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],

        ["\xC5\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],
        ["\xC5\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],

        ["\xC5\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],
        ["\xC5\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],

        ["\xC5\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],
        ["\xC5\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],

        ["\xC5\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xC5\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],

        ["\xC5\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xC5\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],

        ["\xC5\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],
        ["\x47\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],

        ["\xC5\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],
        ["\xC5\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],

        ["\xC5\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],
        ["\xC5\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],

        ["\xC5\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xC5\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],

        ["\xC5\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xC5\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],

        ["\xC5\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xC5\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],

        ["\xC5\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],
        ["\xC5\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],

        ["\xC5\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],
        ["\xC5\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],

        ["\xC5\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xC5\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],

        ["\xC5\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\xFC"],
        ["\x6C\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],

        ["\xC5\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xC5\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],

        ["\xC5\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xC5\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],

        ["\xC5\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xC5\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],

        ["\xC5\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xC5\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],

        ["\xC5\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xC5\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],

        ["\xC5\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xC5\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],

        ["\xC5\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xC5\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],

        ["\xC5\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xC5\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],

        ["\xC5\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xC5\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],

        ["\xC5\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xC5\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],

        ["\xC5\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],
        ["\xC5\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],

        ["\xC5\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xC5\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],

        ["\xC5\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],
        ["\xC5\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],

        ["\xC5\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xC5\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],

        ["\xC5\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xC5\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],

        ["\xC5\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],
        ["\xC5\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],

        ["\xC5\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xC5\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],

        ["\xC5\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xC5\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],

        ["\xC5\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xC5\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],

        ["\xC5\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xC5\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],

        ["\xC5\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xC5\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],

        ["\xC5\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xC5\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],

        ["\xC5\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xC5\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],

        ["\xC5\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE2\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],

        ["\xC5\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xC5\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],

        ["\xC5\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xC5\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],

        ["\xC5\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xC5\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],

        ["\xC5\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xC5\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],

        ["\xC5\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xC5\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],

        ["\xC5\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xC5\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],

        ["\xC5\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],
        ["\xC5\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],

        ["\xC5\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xC5\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],

        ["\xC5\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xC5\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],

        ["\xC5\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],
        ["\xC5\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],

        ["\xC5\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xC5\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],

        ["\xC5\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xC5\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],

        ["\xC5\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xC5\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],

        ["\xC5\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xC5\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],

        ["\xC5\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xC5\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],

        ["\xC5\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xC5\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],

        ["\xC5\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xC5\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],

        ["\xC5\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xC5\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],

        ["\xC5\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xC5\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],

        ["\xC5\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],
        ["\xC5\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],

        ["\xC5\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xC5\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],

        ["\xC5\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],
        ["\xC5\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],

        ["\xC5\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],
        ["\xDB\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],

        ["\xC5\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xC5\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],

        ["\xC5\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xC5\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],

        ["\xC5\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xC5\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],

        ["\xC5\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xC5\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],

        ["\xC5\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\xDE\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],

        ["\xC5\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xC5\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],

        ["\xC5\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xC5\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],

        ["\xC5\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xC5\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],

        ["\xC5\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xC5\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],

        ["\xC5\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xC5\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],

        ["\xC5\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xC5\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],

        ["\xC5\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xC5\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],

        ["\xC5\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xC5\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],

        ["\xC5\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],
        ["\xC5\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],

        ["\xC5\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],
        ["\xC5\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],

        ["\xC5\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xC5\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],

        ["\xC6\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xC6\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],

        ["\xC6\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],
        ["\xC6\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],

        ["\xC6\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],
        ["\xC6\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],

        ["\xC6\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xC6\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],

        ["\xC6\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xC6\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],

        ["\xC6\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xC6\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],

        ["\xC6\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],
        ["\xC6\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],

        ["\xC6\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xC6\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],

        ["\xC6\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],
        ["\xC6\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],

        ["\xC6\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],
        ["\xC6\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],

        ["\xC6\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xC6\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],

        ["\xC6\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],
        ["\xC6\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],

        ["\xC6\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],
        ["\xC6\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],

        ["\xC6\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],
        ["\xC6\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],

        ["\xC6\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],
        ["\xC6\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],

        ["\xC6\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xC6\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],

        ["\xC6\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],
        ["\xC6\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],

        ["\xC6\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],
        ["\xC6\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],

        ["\xC6\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],
        ["\xC6\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],

        ["\xC6\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xC6\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],

        ["\xC6\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xC6\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],

        ["\xC6\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xC6\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],

        ["\xC6\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xC6\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],

        ["\xC6\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xC6\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],

        ["\xC6\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xC6\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],

        ["\xC6\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xC6\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],

        ["\xC6\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xC6\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],

        ["\xC6\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],
        ["\xC6\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],

        ["\xC6\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xC6\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],

        ["\xC6\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],
        ["\xC6\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],

        ["\xC6\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xC6\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],

        ["\xC6\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xC6\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],

        ["\xC6\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xC6\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],

        ["\xC6\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xC6\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],

        ["\xC6\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xC6\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],

        ["\xC6\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xC6\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],

        ["\xC6\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xC6\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],

        ["\xC6\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xC6\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],

        ["\xC6\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xC6\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],

        ["\xC6\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xC6\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],

        ["\xC6\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xC6\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],

        ["\xC6\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],
        ["\xC6\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],

        ["\xC6\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],
        ["\xC6\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],

        ["\xC6\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],
        ["\xC6\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],

        ["\xC6\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],
        ["\xC6\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],

        ["\xC6\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xC6\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],

        ["\xC6\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],
        ["\xC6\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],

        ["\xC6\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xC6\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],

        ["\xC6\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xC6\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],

        ["\xC6\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xC6\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],

        ["\xC6\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xC6\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],

        ["\xC6\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xC6\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],

        ["\xC6\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xC6\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],

        ["\xC6\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xC6\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],

        ["\xC6\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xC6\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],

        ["\xC6\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xC6\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],

        ["\xC6\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xC6\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],

        ["\xC6\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xC6\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],

        ["\xC6\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xC6\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],

        ["\xC6\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],
        ["\xC6\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],

        ["\xC6\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xC6\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],

        ["\xC6\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],
        ["\xC6\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],

        ["\xC6\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xC6\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],

        ["\xC6\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xC6\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],

        ["\xC6\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xC6\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],

        ["\xC6\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xC6\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],

        ["\xC6\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xC6\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],

        ["\xC6\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xC6\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],

        ["\xC6\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xC6\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],

        ["\xC6\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xC6\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],

        ["\xC6\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xC6\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],

        ["\xC6\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xC6\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],

        ["\xC6\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xC6\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],

        ["\xC6\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],
        ["\xC6\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],

        ["\xC6\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],
        ["\xC6\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],

        ["\xC6\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],
        ["\xC6\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],

        ["\xC6\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xC6\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],

        ["\xC6\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],
        ["\xC6\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],

        ["\xC6\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],
        ["\xC6\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],

        ["\xC6\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xC6\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],

        ["\xC6\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xC6\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],

        ["\xC6\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xC6\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],

        ["\xC6\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xC6\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],

        ["\xC6\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xC6\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],

        ["\xC6\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\xC6\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],

        ["\xC6\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\xED\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],

        ["\xC6\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xC6\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],

        ["\xC6\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xC6\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],

        ["\xC6\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xC6\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],

        ["\xC6\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],
        ["\xC6\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],

        ["\xC6\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xC6\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],

        ["\xC6\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xC6\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],

        ["\xC6\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xC6\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],

        ["\xC6\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xC6\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],

        ["\xC7\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xC7\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],

        ["\xC7\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],
        ["\xC7\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],

        ["\xC7\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],
        ["\xC7\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],

        ["\xC7\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],
        ["\xC7\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],

        ["\xC7\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],
        ["\xC7\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],

        ["\xC7\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xC7\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],

        ["\xC7\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xC7\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],

        ["\xC7\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],
        ["\xC7\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],

        ["\xC7\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],
        ["\xC7\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],

        ["\xC7\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],
        ["\xC7\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],

        ["\xC7\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xC7\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],

        ["\xC7\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],
        ["\xC7\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],

        ["\xC7\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xC7\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],

        ["\xC7\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],
        ["\xC7\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],

        ["\xC7\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xC7\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],

        ["\xC7\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xC7\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],

        ["\xC7\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xC7\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],

        ["\xC7\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xC7\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],

        ["\xC7\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xC7\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],

        ["\xC7\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xC7\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],

        ["\xC7\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],
        ["\xC7\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],

        ["\xC7\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xC7\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],

        ["\xC7\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xC7\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],

        ["\xC7\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xC7\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],

        ["\xC7\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xC7\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],

        ["\xC7\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xC7\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],

        ["\xC7\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],
        ["\xC7\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],

        ["\xC7\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],
        ["\xC7\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],

        ["\xC7\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xC7\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],

        ["\xC7\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xC7\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],

        ["\xC7\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],
        ["\xC7\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],

        ["\xC7\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xC7\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],

        ["\xC7\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xC7\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],

        ["\xC7\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xC7\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],

        ["\xC7\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xC7\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],

        ["\xC7\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xC7\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],

        ["\xC7\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xC7\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],

        ["\xC7\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xC7\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],

        ["\xC7\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xC7\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],

        ["\xC7\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xC7\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],

        ["\xC7\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xC7\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],

        ["\xC7\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],
        ["\xC7\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],

        ["\xC7\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xC7\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],

        ["\xC7\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xC7\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],

        ["\xC7\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xC7\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],

        ["\xC7\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],
        ["\xC7\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],

        ["\xC7\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],
        ["\xC7\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],

        ["\xC7\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xC7\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],

        ["\xC7\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xC7\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],

        ["\xC7\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xC7\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],

        ["\xC7\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xC7\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],

        ["\xC7\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xC7\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],

        ["\xC7\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xC7\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],

        ["\xC7\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xC7\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],

        ["\xC7\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xC7\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],

        ["\xC7\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xC7\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],

        ["\xC7\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xC7\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],

        ["\xC7\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],
        ["\xC7\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],

        ["\xC7\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xC7\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],

        ["\xC7\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],
        ["\xC7\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],

        ["\xC7\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],
        ["\xC7\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],

        ["\xC7\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],
        ["\xC7\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],

        ["\xC7\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xC7\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],

        ["\xC7\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xC7\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],

        ["\xC7\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xC7\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],

        ["\xC7\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xC7\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],

        ["\xC7\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xC7\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],

        ["\xC7\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xC7\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],

        ["\xC7\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xC7\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],

        ["\xC7\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xC7\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],

        ["\xC7\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xC7\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],

        ["\xC7\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xEA\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],

        ["\xC7\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xC7\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],

        ["\xC7\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],
        ["\xC7\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],

        ["\xC7\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],
        ["\xC7\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],

        ["\xC7\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xC7\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],

        ["\xC7\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xC7\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],

        ["\xC7\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xC7\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],

        ["\xC7\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xC7\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],

        ["\xC7\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xC7\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],

        ["\xC7\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xC7\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],

        ["\xC7\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xC7\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],

        ["\xC7\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xC7\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],

        ["\xC7\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xC7\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],

        ["\xC7\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xC7\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],

        ["\xC7\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xC7\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],

        ["\xC7\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xC7\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],

        ["\xC7\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xC7\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],

        ["\xC7\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xC7\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],

        ["\xC7\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],
        ["\xC7\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],

        ["\xC7\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],
        ["\xC7\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],

        ["\xC7\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],
        ["\xC7\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],

        ["\xC7\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xC7\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],

        ["\xC7\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xC7\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],

        ["\xC8\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xC8\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],

        ["\xC8\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],
        ["\xC8\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],

        ["\xC8\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xC8\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],

        ["\xC8\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],
        ["\xC8\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],

        ["\xC8\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],
        ["\xC8\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],

        ["\xC8\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],
        ["\xC8\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],

        ["\xC8\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xC8\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],

        ["\xC8\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xC8\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],

        ["\xC8\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xC8\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],

        ["\xC8\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],
        ["\xC8\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],

        ["\xC8\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xC8\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],

        ["\xC8\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xC8\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],

        ["\xC8\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],
        ["\xC8\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],

        ["\xC8\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xC8\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],

        ["\xC8\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xC8\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],

        ["\xC8\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xC8\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],

        ["\xC8\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xC8\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],

        ["\xC8\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xC8\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],

        ["\xC8\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xC8\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],

        ["\xC8\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],
        ["\xC8\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],

        ["\xC8\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],
        ["\xC8\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],

        ["\xC8\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xC8\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],

        ["\xC8\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xC8\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],

        ["\xC8\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],
        ["\xC8\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],

        ["\xC8\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xC8\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],

        ["\xC8\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xC8\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],

        ["\xC8\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xC8\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],

        ["\xC8\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],
        ["\xC8\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],

        ["\xC8\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],
        ["\xC8\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],

        ["\xC8\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],
        ["\xC8\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],

        ["\xC8\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xC8\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],

        ["\xC8\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xC8\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],

        ["\xC8\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xC8\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],

        ["\xC8\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xC8\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],

        ["\xC8\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xC8\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],

        ["\xC8\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xC8\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],

        ["\xC8\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xC8\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],

        ["\xC8\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xC8\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],

        ["\xC8\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xC8\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],

        ["\xC8\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xC8\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],

        ["\xC8\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xC8\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],

        ["\xC8\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xC8\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],

        ["\xC8\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xC8\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],

        ["\xC8\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],
        ["\xC8\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],

        ["\xC8\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],
        ["\xC8\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],

        ["\xC8\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],
        ["\xC8\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],

        ["\xC8\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xC8\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],

        ["\xC8\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xC8\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],

        ["\xC8\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xC8\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],

        ["\xC8\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xC8\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],

        ["\xC8\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xC8\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],

        ["\xC8\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xC8\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],

        ["\xC8\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xC8\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],

        ["\xC8\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xC8\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],

        ["\xC8\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xC8\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],

        ["\xC8\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xC8\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],

        ["\xC8\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xC8\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],

        ["\xC8\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xC8\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],

        ["\xC8\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xC8\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],

        ["\xC8\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xC8\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],

        ["\xC8\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],
        ["\xC8\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],

        ["\xC8\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],
        ["\xC8\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],

        ["\xC8\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],
        ["\xC8\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],

        ["\xC8\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xC8\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],

        ["\xC8\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xC8\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],

        ["\xC8\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xC8\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],

        ["\xC8\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xC8\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],

        ["\xC8\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xC8\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],

        ["\xC8\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xC8\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],

        ["\xC8\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xC8\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],

        ["\xC8\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xC8\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],

        ["\xC8\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xC8\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],

        ["\xC8\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xC8\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],

        ["\xC8\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],
        ["\xC8\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],

        ["\xC8\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],
        ["\xC8\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],

        ["\xC8\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],
        ["\xC8\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],

        ["\xC8\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],
        ["\xC8\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],

        ["\xC8\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xC8\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],

        ["\xC8\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],
        ["\xC8\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],

        ["\xC8\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xC8\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],

        ["\xC8\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xC8\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],

        ["\xC8\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xC8\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],

        ["\xC8\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xC8\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],

        ["\xC8\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xC8\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],

        ["\xC8\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xC8\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],

        ["\xC8\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xC8\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],

        ["\xC8\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xC8\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],

        ["\xC8\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xC8\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],

        ["\xC8\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xC8\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],

        ["\xC8\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],
        ["\xC8\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],

        ["\xC8\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],
        ["\xC8\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],

        ["\xC8\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xC8\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],

        ["\xC8\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],
        ["\xC8\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],

        ["\xC8\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],
        ["\xC8\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],

        ["\xC9\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xC9\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],

        ["\xC9\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],
        ["\xC9\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],

        ["\xC9\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],
        ["\xC9\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],

        ["\xC9\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],
        ["\xC9\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],

        ["\xC9\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xC9\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],

        ["\xC9\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xC9\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],

        ["\xC9\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],
        ["\xC9\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],

        ["\xC9\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xC9\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],

        ["\xC9\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],
        ["\xC9\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],

        ["\xC9\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xC9\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],

        ["\xC9\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xC9\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],

        ["\xC9\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xC9\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],

        ["\xC9\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xC9\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],

        ["\xC9\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],
        ["\xC9\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],

        ["\xC9\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],
        ["\xC9\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],

        ["\xC9\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],
        ["\xDB\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],

        ["\xC9\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],
        ["\xC9\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],

        ["\xC9\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xC9\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],

        ["\xC9\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xC9\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],

        ["\xC9\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xC9\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],

        ["\xC9\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],
        ["\xC9\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],

        ["\xC9\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xC9\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],

        ["\xC9\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],
        ["\xC9\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],

        ["\xC9\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xC9\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],

        ["\xC9\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xC9\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],

        ["\xC9\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],
        ["\xC9\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],

        ["\xC9\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],
        ["\xC9\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],

        ["\xC9\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xC9\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],

        ["\xC9\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],
        ["\xC9\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],

        ["\xC9\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],
        ["\xC9\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],

        ["\xC9\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],
        ["\xC9\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],

        ["\xC9\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xC9\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],

        ["\xC9\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xC9\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],

        ["\xC9\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xC9\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],

        ["\xC9\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xC9\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],

        ["\xC9\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xC9\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],

        ["\xC9\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xC9\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],

        ["\xC9\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xC9\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],

        ["\xC9\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xC9\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],

        ["\xC9\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xC9\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],

        ["\xC9\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xC9\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],

        ["\xC9\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],
        ["\xC9\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],

        ["\xC9\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],
        ["\xC9\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],

        ["\xC9\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xC9\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],

        ["\xC9\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],
        ["\xC9\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],

        ["\xC9\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xC9\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],

        ["\xC9\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],
        ["\xC9\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],

        ["\xC9\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xC9\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],

        ["\xC9\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xC9\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],

        ["\xC9\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xC9\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],

        ["\xC9\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xC9\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],

        ["\xC9\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xC9\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],

        ["\xC9\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xC9\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],

        ["\xC9\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xC9\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],

        ["\xC9\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xC9\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],

        ["\xC9\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xC9\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],

        ["\xC9\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xC9\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],

        ["\xC9\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],
        ["\xC9\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],

        ["\xC9\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],
        ["\xC9\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],

        ["\xC9\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],
        ["\xC9\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],

        ["\xC9\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xC9\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],

        ["\xC9\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],
        ["\xC9\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],

        ["\xC9\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],
        ["\xC9\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],

        ["\xC9\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xC9\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],

        ["\xC9\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],
        ["\xC9\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],

        ["\xC9\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xC9\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],

        ["\xC9\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xC9\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],

        ["\xC9\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xC9\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],

        ["\xC9\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xC9\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],

        ["\xC9\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xC9\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],

        ["\xC9\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xC9\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],

        ["\xC9\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xC9\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],

        ["\xC9\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xC9\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],

        ["\xC9\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xC9\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],

        ["\xC9\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xC9\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],

        ["\xC9\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xC9\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],

        ["\xC9\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],
        ["\xC9\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],

        ["\xC9\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xC9\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],

        ["\xC9\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],
        ["\xC9\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],

        ["\xC9\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xC9\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],

        ["\xC9\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xC9\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],

        ["\xC9\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xC9\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],

        ["\xC9\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xC9\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],

        ["\xC9\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xC9\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],

        ["\xC9\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xC9\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],

        ["\xC9\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xC9\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],

        ["\xC9\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xC9\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],

        ["\xC9\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xC9\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],

        ["\xC9\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xC9\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],

        ["\xC9\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xC9\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],

        ["\xC9\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xC9\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],

        ["\xC9\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xC9\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],

        ["\xC9\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],
        ["\xC9\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],

        ["\xC9\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],
        ["\xC9\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],

        ["\xCA\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xCA\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],

        ["\xCA\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xCA\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],

        ["\xCA\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xCA\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],

        ["\xCA\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xCA\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],

        ["\xCA\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xCA\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],

        ["\xCA\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xCA\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],

        ["\xCA\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xCA\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],

        ["\xCA\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xCA\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],

        ["\xCA\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],
        ["\xCA\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],

        ["\xCA\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xCA\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],

        ["\xCA\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],
        ["\xCA\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],

        ["\xCA\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],
        ["\xCA\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],

        ["\xCA\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xCA\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],

        ["\xCA\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],
        ["\xCA\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],

        ["\xCA\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xCA\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],

        ["\xCA\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],
        ["\xCA\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],

        ["\xCA\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],
        ["\xCA\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],

        ["\xCA\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],
        ["\xCA\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],

        ["\xCA\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],
        ["\xCA\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],

        ["\xCA\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xCA\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],

        ["\xCA\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xCA\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],

        ["\xCA\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xCA\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],

        ["\xCA\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xCA\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],

        ["\xCA\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xCA\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],

        ["\xCA\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xCA\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],

        ["\xCA\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],
        ["\xCA\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],

        ["\xCA\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],
        ["\xCA\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],

        ["\xCA\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xCA\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],

        ["\xCA\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xCA\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],

        ["\xCA\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],
        ["\xCA\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],

        ["\xCA\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],
        ["\xCA\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],

        ["\xCA\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],
        ["\xCA\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],

        ["\xCA\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xCA\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],

        ["\xCA\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],
        ["\xCA\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],

        ["\xCA\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xCA\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],

        ["\xCA\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],
        ["\xCA\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],

        ["\xCA\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xCA\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],

        ["\xCA\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],
        ["\xCA\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],

        ["\xCA\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],
        ["\xCA\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],

        ["\xCA\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xCA\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],

        ["\xCA\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xCA\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],

        ["\xCA\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],
        ["\xCA\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],

        ["\xCA\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],
        ["\xCA\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],

        ["\xCA\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xCA\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],

        ["\xCA\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xCA\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],

        ["\xCA\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xCA\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],

        ["\xCA\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],
        ["\xCA\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],

        ["\xCA\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],
        ["\xCA\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],

        ["\xCA\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xCA\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],

        ["\xCA\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],
        ["\xCA\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],

        ["\xCA\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xCA\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],

        ["\xCA\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xCA\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],

        ["\xCA\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],
        ["\xCA\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],

        ["\xCA\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xCA\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],

        ["\xCA\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],
        ["\xCA\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],

        ["\xCA\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],
        ["\xCA\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],

        ["\xCA\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xCA\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],

        ["\xCA\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],
        ["\xCA\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],

        ["\xCA\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],
        ["\xCA\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],

        ["\xCA\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],
        ["\xCA\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],

        ["\xCA\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xCA\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],

        ["\xCA\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xCA\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],

        ["\xCA\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xCA\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],

        ["\xCA\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xCA\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],

        ["\xCA\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xCA\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],

        ["\xCA\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xCA\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],

        ["\xCA\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],
        ["\xCA\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],

        ["\xCA\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xCA\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],

        ["\xCA\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],
        ["\xCA\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],

        ["\xCA\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xCA\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],

        ["\xCA\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],
        ["\xCA\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],

        ["\xCA\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xCA\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],

        ["\xCA\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xCA\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],

        ["\xCA\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],
        ["\xCA\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],

        ["\xCA\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],
        ["\xCA\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],

        ["\xCA\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],
        ["\xCA\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],

        ["\xCA\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xCA\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],

        ["\xCA\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xCA\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],

        ["\xCA\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xCA\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],

        ["\xCA\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xCA\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],

        ["\xCA\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xCA\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],

        ["\xCA\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xCA\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],

        ["\xCA\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xCA\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],

        ["\xCA\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xCA\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],

        ["\xCA\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],
        ["\xCA\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],

        ["\xCA\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xCA\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],

        ["\xCA\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],
        ["\xCA\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],

        ["\xCA\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xCA\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],

        ["\xCA\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],
        ["\xCA\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],

        ["\xCA\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xCA\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],

        ["\xCA\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xCA\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],

        ["\xCA\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xCA\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],

        ["\xCA\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xCA\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],

        ["\xCA\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xCA\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],

        ["\xCB\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],
        ["\xCB\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],

        ["\xCB\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xCB\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],

        ["\xCB\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xCB\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],

        ["\xCB\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xCB\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],

        ["\xCB\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xCB\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],

        ["\xCB\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xCB\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],

        ["\xCB\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],
        ["\xCB\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],

        ["\xCB\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xCB\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],

        ["\xCB\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],
        ["\xCB\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],

        ["\xCB\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],
        ["\xCB\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],

        ["\xCB\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xCB\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],

        ["\xCB\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xCB\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],

        ["\xCB\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xCB\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],

        ["\xCB\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],
        ["\xCB\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],

        ["\xCB\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xCB\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],

        ["\xCB\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xCB\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],

        ["\xCB\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],
        ["\xCB\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],

        ["\xCB\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xCB\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],

        ["\xCB\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],
        ["\xCB\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],

        ["\xCB\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],
        ["\xCB\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],

        ["\xCB\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xCB\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],

        ["\xCB\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],
        ["\xCB\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],

        ["\xCB\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],
        ["\xCB\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],

        ["\xCB\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xCB\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],

        ["\xCB\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],
        ["\xCB\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],

        ["\xCB\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xCB\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],

        ["\xCB\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],
        ["\xCB\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],

        ["\xCB\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],
        ["\xCB\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],

        ["\xCB\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],
        ["\xCB\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],

        ["\xCB\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],
        ["\xCB\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],

        ["\xCB\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xCB\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],

        ["\xCB\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xCB\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],

        ["\xCB\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xCB\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],

        ["\xCB\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xCB\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],

        ["\xCB\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xCB\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],

        ["\xCB\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],
        ["\xCB\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],

        ["\xCB\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xCB\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],

        ["\xCB\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],
        ["\xCB\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],

        ["\xCB\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xCB\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],

        ["\xCB\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],
        ["\xCB\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],

        ["\xCB\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xCB\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],

        ["\xCB\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],
        ["\xCB\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],

        ["\xCB\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xCB\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],

        ["\xCB\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],
        ["\xCB\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],

        ["\xCB\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xCB\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],

        ["\xCB\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xCB\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],

        ["\xCB\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xCB\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],

        ["\xCB\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xCB\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],

        ["\xCB\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],
        ["\xCB\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],

        ["\xCB\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],
        ["\xCB\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],

        ["\xCB\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xCB\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],

        ["\xCB\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xCB\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],

        ["\xCB\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xCB\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],

        ["\xCB\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xCB\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],

        ["\xCB\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],
        ["\xCB\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],

        ["\xCB\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],
        ["\xCB\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],

        ["\xCB\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xCB\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],

        ["\xCB\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xCB\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],

        ["\xCB\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xCB\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],

        ["\xCB\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xCB\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],

        ["\xCB\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],
        ["\xCB\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],

        ["\xCB\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xCB\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],

        ["\xCB\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],
        ["\xCB\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],

        ["\xCB\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xCB\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],

        ["\xCB\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],
        ["\xCB\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],

        ["\xCB\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xCB\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],

        ["\xCB\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\xCB\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],

        ["\xCB\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],
        ["\xCB\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],

        ["\xCB\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],
        ["\xCB\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],

        ["\xCB\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],
        ["\xCB\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],

        ["\xCB\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xCB\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],

        ["\xCB\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xCB\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],

        ["\xCB\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xCB\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],

        ["\xCB\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],
        ["\x54\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],

        ["\xCB\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],
        ["\xCB\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],

        ["\xCB\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],
        ["\xCB\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],

        ["\xCB\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],
        ["\xCB\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],

        ["\xCB\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],
        ["\xCB\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],

        ["\xCB\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xCB\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],

        ["\xCB\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],
        ["\xCB\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],

        ["\xCB\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],
        ["\xCB\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],

        ["\xCB\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],
        ["\xCB\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],

        ["\xCB\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xCB\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],

        ["\xCB\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xCB\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],

        ["\xCB\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xCB\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],

        ["\xCB\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],
        ["\xCB\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],

        ["\xCB\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xCB\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],

        ["\xCB\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xCB\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],

        ["\xCB\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],
        ["\xD0\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],

        ["\xCB\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xCB\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],

        ["\xCB\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xCB\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],

        ["\xCB\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],
        ["\xCB\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],

        ["\xCB\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xCB\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],

        ["\xCB\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],
        ["\xCB\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],

        ["\xCC\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],
        ["\xCC\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],

        ["\xCC\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],
        ["\xCC\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],

        ["\xCC\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xCC\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],

        ["\xCC\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],
        ["\xCC\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],

        ["\xCC\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xCC\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],

        ["\xCC\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],
        ["\xCC\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],

        ["\xCC\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],
        ["\xCC\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],

        ["\xCC\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],
        ["\xCC\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],

        ["\xCC\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xCC\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],

        ["\xCC\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],
        ["\xCC\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],

        ["\xCC\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xCC\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],

        ["\xCC\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],
        ["\xCC\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],

        ["\xCC\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xCC\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],

        ["\xCC\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xCC\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],

        ["\xCC\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xCC\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],

        ["\xCC\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],
        ["\xCC\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],

        ["\xCC\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],
        ["\xCC\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],

        ["\xCC\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],
        ["\xCC\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],

        ["\xCC\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],
        ["\xCC\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],

        ["\xCC\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],
        ["\xCC\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],

        ["\xCC\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xCC\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],

        ["\xCC\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xCC\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],

        ["\xCC\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xCC\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],

        ["\xCC\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],
        ["\xCC\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],

        ["\xCC\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xCC\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],

        ["\xCC\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xCC\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],

        ["\xCC\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xCC\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],

        ["\xCC\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],
        ["\xCC\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],

        ["\xCC\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xCC\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],

        ["\xCC\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xCC\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],

        ["\xCC\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],
        ["\xCC\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],

        ["\xCC\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],
        ["\xCC\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],

        ["\xCC\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],
        ["\xCC\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],

        ["\xCC\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],
        ["\xCC\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],

        ["\xCC\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],
        ["\xCC\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],

        ["\xCC\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],
        ["\xCC\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],

        ["\xCC\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xCC\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],

        ["\xCC\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xCC\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],

        ["\xCC\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],
        ["\xCC\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],

        ["\xCC\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xCC\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],

        ["\xCC\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],
        ["\xCC\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],

        ["\xCC\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xCC\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],

        ["\xCC\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],
        ["\xCC\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],

        ["\xCC\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],
        ["\xCC\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],

        ["\xCC\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\xC4"],
        ["\x6F\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],

        ["\xCC\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],
        ["\xCC\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],

        ["\xCC\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],
        ["\xCC\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],

        ["\xCC\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],
        ["\xCC\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],

        ["\xCC\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],
        ["\xCC\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],

        ["\xCC\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],
        ["\xCC\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],

        ["\xCC\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xCC\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],

        ["\xCC\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],
        ["\xCC\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],

        ["\xCC\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],
        ["\xCC\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],

        ["\xCC\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],
        ["\xCC\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],

        ["\xCC\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],
        ["\xCC\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],

        ["\xCC\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],
        ["\xCC\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],

        ["\xCC\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xCC\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],

        ["\xCC\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],
        ["\xCC\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],

        ["\xCC\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],
        ["\xCC\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],

        ["\xCC\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xCC\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],

        ["\xCC\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],
        ["\xCC\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],

        ["\xCC\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xCC\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],

        ["\xCC\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xCC\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],

        ["\xCC\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],
        ["\xCC\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],

        ["\xCC\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],
        ["\xCC\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],

        ["\xCC\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],
        ["\xCC\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],

        ["\xCC\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],
        ["\xCC\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],

        ["\xCC\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xCC\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],

        ["\xCC\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],
        ["\xCC\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],

        ["\xCC\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],
        ["\xCC\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],

        ["\xCC\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],
        ["\xCC\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],

        ["\xCC\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],
        ["\xCC\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],

        ["\xCC\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xCC\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],

        ["\xCC\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],
        ["\xCC\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],

        ["\xCC\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xCC\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],

        ["\xCC\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],
        ["\xCC\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],

        ["\xCC\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xCC\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],

        ["\xCC\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xCC\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],

        ["\xCC\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xCC\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],

        ["\xCC\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xCC\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],

        ["\xCC\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],
        ["\xCC\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],

        ["\xCC\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],
        ["\xCC\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],

        ["\xCC\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],
        ["\xCC\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],

        ["\xCC\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xCC\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],

        ["\xCC\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xCC\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],

        ["\xCC\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xCC\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],

        ["\xCC\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xCC\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],

        ["\xCC\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\xCC\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],

        ["\xCC\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],

        ["\xCC\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],
        ["\xCC\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],

        ["\xCC\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],
        ["\xCC\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],

        ["\xCC\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xCC\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],

        ["\xCC\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xCC\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],

        ["\xCC\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],
        ["\xCC\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],

        ["\xCD\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xCD\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],

        ["\xCD\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],
        ["\xCD\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],

        ["\xCD\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xCD\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],

        ["\xCD\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xCD\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],

        ["\xCD\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],
        ["\xCD\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],

        ["\xCD\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],
        ["\xCD\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],

        ["\xCD\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],
        ["\xCD\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],

        ["\xCD\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xCD\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],

        ["\xCD\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],
        ["\xCD\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],

        ["\xCD\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xCD\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],

        ["\xCD\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xCD\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],

        ["\xCD\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],
        ["\xCD\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],

        ["\xCD\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],
        ["\xCD\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],

        ["\xCD\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xCD\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],

        ["\xCD\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],
        ["\xCD\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],

        ["\xCD\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],
        ["\xCD\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],

        ["\xCD\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],
        ["\xCD\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],

        ["\xCD\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],
        ["\xCD\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],

        ["\xCD\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],
        ["\xCD\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],

        ["\xCD\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],
        ["\xCD\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],

        ["\xCD\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],
        ["\xCD\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],

        ["\xCD\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],
        ["\xCD\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],

        ["\xCD\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],
        ["\xCD\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],

        ["\xCD\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],
        ["\xCD\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],

        ["\xCD\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],
        ["\xCD\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],

        ["\xCD\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xCD\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],

        ["\xCD\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],
        ["\xCD\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],

        ["\xCD\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],
        ["\xCD\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],

        ["\xCD\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],
        ["\xCD\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],

        ["\xCD\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],
        ["\xCD\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],

        ["\xCD\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],
        ["\xCD\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],

        ["\xCD\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],
        ["\xCD\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],

        ["\xCD\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xCD\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],

        ["\xCD\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],
        ["\xCD\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],

        ["\xCD\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],
        ["\xCD\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],

        ["\xCD\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],
        ["\xCD\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],

        ["\xCD\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xCD\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],

        ["\xCD\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],
        ["\xCD\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],

        ["\xCD\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],
        ["\xCD\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],

        ["\xCD\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],
        ["\xCD\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],

        ["\xCD\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],
        ["\xCD\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],

        ["\xCD\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],
        ["\xCD\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],

        ["\xCD\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],
        ["\xCD\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],

        ["\xCD\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],
        ["\xCD\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],

        ["\xCD\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],
        ["\xCD\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],

        ["\xCD\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],
        ["\xCD\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],

        ["\xCD\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],
        ["\xCD\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],

        ["\xCD\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xCD\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],

        ["\xCD\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],
        ["\xCD\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],

        ["\xCD\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],
        ["\xCD\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],

        ["\xCD\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],
        ["\xCD\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],

        ["\xCD\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xCD\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],

        ["\xCD\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],
        ["\xCD\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],

        ["\xCD\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xCD\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],

        ["\xCD\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],
        ["\xCD\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],

        ["\xCD\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xCD\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],

        ["\xCD\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],
        ["\xCD\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],

        ["\xCD\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xEB"],
        ["\x70\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],

        ["\xCD\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],
        ["\xCD\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],

        ["\xCD\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],
        ["\xCD\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],

        ["\xCD\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xCD\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],

        ["\xCD\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],
        ["\xCD\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],

        ["\xCD\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xCD\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],

        ["\xCD\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xCD\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],

        ["\xCD\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],
        ["\xCD\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],

        ["\xCD\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],
        ["\xCD\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],

        ["\xCD\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],
        ["\xCD\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],

        ["\xCD\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],
        ["\xCD\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],

        ["\xCD\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xCD\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],

        ["\xCD\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],
        ["\xCD\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],

        ["\xCD\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],
        ["\xCD\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],

        ["\xCD\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xCD\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],

        ["\xCD\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],
        ["\xCD\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],

        ["\xCD\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],
        ["\xCD\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],

        ["\xCD\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],
        ["\xCD\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],

        ["\xCD\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xCD\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],

        ["\xCD\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xCD\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],

        ["\xCD\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xCD\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],

        ["\xCD\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],
        ["\xCD\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],

        ["\xCD\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],
        ["\xCD\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],

        ["\xCD\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xCD\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],

        ["\xCD\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],
        ["\xCD\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],

        ["\xCD\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],
        ["\xCD\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],

        ["\xCD\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],
        ["\xCD\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],

        ["\xCD\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],
        ["\xCD\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],

        ["\xCD\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xCD\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],

        ["\xCD\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],
        ["\xCD\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],

        ["\xCD\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],
        ["\xCD\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],

        ["\xCD\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xCD\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],

        ["\xCD\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],
        ["\xCD\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],

        ["\xCD\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],
        ["\xCD\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],

        ["\xCD\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xCD\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],

        ["\xCD\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xCD\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],

        ["\xCD\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xCD\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],

        ["\xCE\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xCE\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],

        ["\xCE\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xCE\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],

        ["\xCE\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xCE\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],

        ["\xCE\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xCE\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],

        ["\xCE\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xCE\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],

        ["\xCE\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xCE\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],

        ["\xCE\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xCE\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],

        ["\xCE\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xCE\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],

        ["\xCE\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xCE\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],

        ["\xCE\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],
        ["\xCE\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],

        ["\xCE\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],
        ["\xCE\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],

        ["\xCE\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],
        ["\xCE\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],

        ["\xCE\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],
        ["\xCE\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],

        ["\xCE\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],
        ["\xCE\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],

        ["\xCE\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],
        ["\xCE\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],

        ["\xCE\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xCE\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],

        ["\xCE\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xCE\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],

        ["\xCE\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xCE\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],

        ["\xCE\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xCE\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],

        ["\xCE\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xCE\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],

        ["\xCE\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xCE\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],

        ["\xCE\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xCE\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],

        ["\xCE\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xCE\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],

        ["\xCE\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xCE\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],

        ["\xCE\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xCE\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],

        ["\xCE\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xCE\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],

        ["\xCE\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xCE\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],

        ["\xCE\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xCE\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],

        ["\xCE\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xCE\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],

        ["\xCE\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xCE\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],

        ["\xCE\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xCE\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],

        ["\xCE\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],
        ["\xCE\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],

        ["\xCE\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],
        ["\xCE\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],

        ["\xCE\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],
        ["\xCE\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],

        ["\xCE\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],
        ["\xCE\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],

        ["\xCE\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],
        ["\xCE\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],

        ["\xCE\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xCE\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],

        ["\xCE\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],
        ["\xCE\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],

        ["\xCE\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],
        ["\xCE\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],

        ["\xCE\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],
        ["\xCE\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],

        ["\xCE\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],
        ["\xCE\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],

        ["\xCE\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],
        ["\xCE\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],

        ["\xCE\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],
        ["\xCE\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],

        ["\xCE\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],
        ["\xCE\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],

        ["\xCE\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],
        ["\xCE\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],

        ["\xCE\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],
        ["\xCE\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],

        ["\xCE\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],
        ["\xCE\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],

        ["\xCE\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],
        ["\xCE\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],

        ["\xCE\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],
        ["\xCE\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],

        ["\xCE\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],
        ["\xCE\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],

        ["\xCE\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],
        ["\xCE\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],

        ["\xCE\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],
        ["\xCE\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],

        ["\xCE\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],
        ["\xCE\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],

        ["\xCE\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],
        ["\xCE\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],

        ["\xCE\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xCE\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],

        ["\xCE\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],
        ["\xCE\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],

        ["\xCE\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],
        ["\xCE\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],

        ["\xCE\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],
        ["\xCE\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],

        ["\xCE\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xCE\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],

        ["\xCE\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],
        ["\xCE\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],

        ["\xCE\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],
        ["\xCE\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],

        ["\xCE\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],
        ["\xCE\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],

        ["\xCE\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],
        ["\xCE\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],

        ["\xCE\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],
        ["\xCE\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],

        ["\xCE\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],
        ["\xCE\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],

        ["\xCE\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],
        ["\xCE\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],

        ["\xCE\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],
        ["\xCE\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],

        ["\xCE\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],
        ["\xCE\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],

        ["\xCE\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],
        ["\xCE\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],

        ["\xCE\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],
        ["\xCE\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],

        ["\xCE\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],
        ["\xCE\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],

        ["\xCE\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],
        ["\xCE\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],

        ["\xCE\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],
        ["\xCE\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],

        ["\xCE\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],
        ["\xCE\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],

        ["\xCE\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],
        ["\xCE\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],

        ["\xCE\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],
        ["\xCE\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],

        ["\xCE\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],
        ["\xCE\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],

        ["\xCE\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],
        ["\xCE\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],

        ["\xCE\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xCE\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],

        ["\xCE\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],
        ["\xCE\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],

        ["\xCE\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],
        ["\xCE\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],

        ["\xCE\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],
        ["\xCE\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],

        ["\xCE\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],
        ["\xCE\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],

        ["\xCE\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],
        ["\xCE\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],

        ["\xCE\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],
        ["\xCE\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],

        ["\xCE\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],
        ["\xCE\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],

        ["\xCE\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],
        ["\xCE\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],

        ["\xCE\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],
        ["\xCE\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],

        ["\xCE\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],
        ["\xCE\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],

        ["\xCE\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],
        ["\xCE\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],

        ["\xCE\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],
        ["\xCE\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],

        ["\xCE\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],
        ["\xCE\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],

        ["\xCE\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],
        ["\xCE\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],

        ["\xCE\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xCE\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],

        ["\xCF\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xCF\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],

        ["\xCF\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],
        ["\xCF\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],

        ["\xCF\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],
        ["\xCF\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],

        ["\xCF\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],
        ["\xCF\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],

        ["\xCF\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],
        ["\xCF\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],

        ["\xCF\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xCF\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],

        ["\xCF\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xCF\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],

        ["\xCF\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],
        ["\xCF\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],

        ["\xCF\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xCF\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],

        ["\xCF\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xCF\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],

        ["\xCF\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],
        ["\xCF\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],

        ["\xCF\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],
        ["\xCF\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],

        ["\xCF\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xCF\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],

        ["\xCF\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],
        ["\xCF\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],

        ["\xCF\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],
        ["\xCF\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],

        ["\xCF\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],
        ["\xCF\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],

        ["\xCF\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xCF\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],

        ["\xCF\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],
        ["\xCF\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],

        ["\xCF\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],
        ["\xCF\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],

        ["\xCF\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],
        ["\xCF\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],

        ["\xCF\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xCF\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],

        ["\xCF\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE4\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],

        ["\xCF\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xCF\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],

        ["\xCF\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xCF\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],

        ["\xCF\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xCF\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],

        ["\xCF\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],
        ["\xCF\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],

        ["\xCF\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],
        ["\xCF\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],

        ["\xCF\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],
        ["\xCF\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],

        ["\xCF\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],
        ["\xCF\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],

        ["\xCF\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xCF\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],

        ["\xCF\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],
        ["\xCF\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],

        ["\xCF\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],
        ["\xCF\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],

        ["\xCF\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],
        ["\xCF\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],

        ["\xCF\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xCF\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],

        ["\xCF\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],
        ["\xCF\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],

        ["\xCF\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],
        ["\xCF\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],

        ["\xCF\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xCF\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],

        ["\xCF\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xCF\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],

        ["\xCF\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],
        ["\xCF\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],

        ["\xCF\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xCF\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],

        ["\xCF\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],
        ["\xCF\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],

        ["\xCF\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],
        ["\xCF\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],

        ["\xCF\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],
        ["\xCF\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],

        ["\xCF\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],
        ["\xCF\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],

        ["\xCF\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],
        ["\xCF\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],

        ["\xCF\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],
        ["\xCF\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],

        ["\xCF\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],
        ["\xCF\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],

        ["\xCF\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],
        ["\xCF\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],

        ["\xCF\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],
        ["\xCF\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],

        ["\xCF\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],
        ["\xCF\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],

        ["\xCF\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xCF\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],

        ["\xD0\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xD0\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],

        ["\xD0\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xD0\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],

        ["\xD0\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xD0\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],

        ["\xD0\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xD0\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],

        ["\xD0\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xD0\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],

        ["\xD0\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xD0\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],

        ["\xD0\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xD0\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],

        ["\xD0\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xD0\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],

        ["\xD0\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xD0\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],

        ["\xD0\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xD0\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],

        ["\xD0\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xD0\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],

        ["\xD0\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xD0\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],

        ["\xD0\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xD0\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],

        ["\xD0\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xD0\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],

        ["\xD0\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xD0\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],

        ["\xD0\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xD0\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],

        ["\xD0\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xD0\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],

        ["\xD0\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xD0\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],

        ["\xD0\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xD0\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],

        ["\xD0\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xD0\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],

        ["\xD0\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xD0\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],

        ["\xD0\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xD0\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],

        ["\xD0\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xD0\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],

        ["\xD0\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xD0\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],

        ["\xD0\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xD0\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],

        ["\xD0\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xD0\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],

        ["\xD0\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xD0\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],

        ["\xD0\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xD0\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],

        ["\xD0\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xD0\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],

        ["\xD0\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xD0\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],

        ["\xD0\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xD0\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],

        ["\xD0\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],
        ["\xD0\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],

        ["\xD0\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],
        ["\xD0\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],

        ["\xD0\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],
        ["\xD0\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],

        ["\xD0\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],
        ["\xD0\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],

        ["\xD0\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xD0\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],

        ["\xD0\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],
        ["\xD0\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],

        ["\xD0\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],
        ["\xD0\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],

        ["\xD0\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],
        ["\xD0\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],

        ["\xD0\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],
        ["\xD0\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],

        ["\xD0\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],
        ["\xD0\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],

        ["\xD0\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],
        ["\xD0\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],

        ["\xD0\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],
        ["\xD0\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],

        ["\xD0\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],
        ["\xD0\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],

        ["\xD0\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],
        ["\xD0\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],

        ["\xD0\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xD0\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],

        ["\xD0\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],
        ["\xD0\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],

        ["\xD0\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],
        ["\xD0\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],

        ["\xD0\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],
        ["\xD0\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],

        ["\xD0\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],
        ["\xD0\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],

        ["\xD0\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],
        ["\xD0\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],

        ["\xD0\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],
        ["\xD0\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],

        ["\xD0\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],
        ["\xD0\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],

        ["\xD0\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],
        ["\xCB\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],

        ["\xD0\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],
        ["\xD0\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],

        ["\xD0\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xD0\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],

        ["\xD0\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],
        ["\xD0\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],

        ["\xD0\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],
        ["\xD0\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],

        ["\xD0\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],
        ["\xD0\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],

        ["\xD0\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],
        ["\xD0\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],

        ["\xD0\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],
        ["\xD0\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],

        ["\xD0\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],
        ["\xD0\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],

        ["\xD0\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],
        ["\xD0\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],

        ["\xD0\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xD0\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],

        ["\xD0\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xD0\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],

        ["\xD0\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],
        ["\xD0\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],

        ["\xD0\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],
        ["\xD0\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],

        ["\xD0\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xD0\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],

        ["\xD0\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],
        ["\xD0\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],

        ["\xD0\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],
        ["\xD0\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],

        ["\xD0\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],
        ["\xD0\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],

        ["\xD0\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],
        ["\xD0\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],

        ["\xD0\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],
        ["\xD0\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],

        ["\xD0\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],
        ["\xD0\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],

        ["\xD0\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],
        ["\xD0\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],

        ["\xD0\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],
        ["\xD0\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],

        ["\xD0\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],
        ["\xD0\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],

        ["\xD0\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],
        ["\xD0\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],

        ["\xD0\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],
        ["\xD0\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],

        ["\xD0\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],
        ["\xD0\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],

        ["\xD0\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],
        ["\xD0\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],

        ["\xD0\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],
        ["\xD0\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],

        ["\xD0\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xD0\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],

        ["\xD0\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],
        ["\xD0\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],

        ["\xD0\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],
        ["\xD0\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],

        ["\xD0\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],
        ["\xD0\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],

        ["\xD0\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],
        ["\xD0\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],

        ["\xD0\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],
        ["\xD0\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],

        ["\xD0\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xD0\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],

        ["\xD0\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],
        ["\xD0\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],

        ["\xD0\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],
        ["\xD0\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],

        ["\xD0\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xD0\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],

        ["\xD0\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],
        ["\xD0\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],

        ["\xD0\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],
        ["\xD0\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],

        ["\xD1\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xD1\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],

        ["\xD1\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xD1\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],

        ["\xD1\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],
        ["\xD1\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],

        ["\xD1\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],
        ["\xD1\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],

        ["\xD1\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],
        ["\xD1\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],

        ["\xD1\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],
        ["\xD1\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],

        ["\xD1\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],
        ["\xD1\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],

        ["\xD1\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],
        ["\xD1\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],

        ["\xD1\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],
        ["\xD1\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],

        ["\xD1\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],
        ["\xD1\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],

        ["\xD1\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xD1\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],

        ["\xD1\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],
        ["\xD1\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],

        ["\xD1\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xD1\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],

        ["\xD1\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],
        ["\xD1\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],

        ["\xD1\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xD1\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],

        ["\xD1\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xD1\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],

        ["\xD1\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],
        ["\xD1\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],

        ["\xD1\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],
        ["\xD1\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],

        ["\xD1\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],
        ["\xD1\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],

        ["\xD1\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xD1\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],

        ["\xD1\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],
        ["\xD1\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],

        ["\xD1\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],
        ["\xD1\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],

        ["\xD1\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],
        ["\xD1\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],

        ["\xD1\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],
        ["\xD1\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],

        ["\xD1\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],
        ["\xD1\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],

        ["\xD1\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],
        ["\xD1\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],

        ["\xD1\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xD1\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],

        ["\xD1\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],
        ["\xD1\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],

        ["\xD1\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],
        ["\xD1\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],

        ["\xD1\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],
        ["\xD1\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],

        ["\xD1\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],
        ["\xD1\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],

        ["\xD1\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xD1\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],

        ["\xD1\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xD1\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],

        ["\xD1\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xD1\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],

        ["\xD1\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xD1\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],

        ["\xD1\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xD1\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],

        ["\xD1\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xD1\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],

        ["\xD1\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xD1\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],

        ["\xD1\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xD1\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],

        ["\xD1\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xD1\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],

        ["\xD1\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xD1\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],

        ["\xD1\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],
        ["\xD1\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],

        ["\xD1\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],
        ["\xD1\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],

        ["\xD1\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xD1\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],

        ["\xD1\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xD1\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],

        ["\xD1\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],
        ["\xD1\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],

        ["\xD1\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],
        ["\xD1\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],

        ["\xD1\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xD1\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],

        ["\xD1\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xD1\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],

        ["\xD1\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xD1\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],

        ["\xD1\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xD1\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],

        ["\xD1\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xD1\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],

        ["\xD1\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xD1\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],

        ["\xD1\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xD1\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],

        ["\xD1\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xD1\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],

        ["\xD1\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xD1\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],

        ["\xD1\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xD1\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],

        ["\xD1\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xD1\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],

        ["\xD1\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xD1\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],

        ["\xD1\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],
        ["\xD1\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],

        ["\xD1\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],
        ["\xD1\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],

        ["\xD1\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],
        ["\xD1\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],

        ["\xD1\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],
        ["\xD1\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],

        ["\xD1\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xD1\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],

        ["\xD1\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],
        ["\xD1\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],

        ["\xD1\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xD1\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],

        ["\xD1\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xD1\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],

        ["\xD1\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xD1\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],

        ["\xD1\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xD1\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],

        ["\xD1\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xD1\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],

        ["\xD1\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xD1\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],

        ["\xD1\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xD1\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],

        ["\xD1\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xD1\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],

        ["\xD1\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],
        ["\xD1\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],

        ["\xD1\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],
        ["\xD1\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],

        ["\xD1\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xD1\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],

        ["\xD1\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xD1\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],

        ["\xD1\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],
        ["\xD1\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],

        ["\xD1\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xD1\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],

        ["\xD1\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xD1\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],

        ["\xD1\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xD1\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],

        ["\xD1\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xD1\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],

        ["\xD1\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xD1\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],

        ["\xD1\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xD1\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],

        ["\xD1\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xD1\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],

        ["\xD1\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xD1\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],

        ["\xD1\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xD1\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],

        ["\xD1\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xD1\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],

        ["\xD1\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xD1\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],

        ["\xD1\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],
        ["\xD1\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],

        ["\xD1\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],
        ["\xD1\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],

        ["\xD1\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],
        ["\xD1\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],

        ["\xD1\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],
        ["\xD1\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],

        ["\xD1\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xD1\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],

        ["\xD2\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xD2\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],

        ["\xD2\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],
        ["\xD2\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],

        ["\xD2\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],
        ["\xD2\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],

        ["\xD2\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xD2\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],

        ["\xD2\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],
        ["\xD2\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],

        ["\xD2\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],
        ["\xD2\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],

        ["\xD2\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],
        ["\xD2\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],

        ["\xD2\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],
        ["\xD2\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],

        ["\xD2\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],
        ["\xD2\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],

        ["\xD2\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],
        ["\xD2\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],

        ["\xD2\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xD2\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],

        ["\xD2\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],
        ["\xD2\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],

        ["\xD2\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],
        ["\xD2\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],

        ["\xD2\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],
        ["\xD2\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],

        ["\xD2\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],
        ["\xD2\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],

        ["\xD2\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xD2\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],

        ["\xD2\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xD2\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],

        ["\xD2\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],
        ["\xD2\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],

        ["\xD2\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],
        ["\xD2\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],

        ["\xD2\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],
        ["\xD2\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],

        ["\xD2\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],
        ["\xD2\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],

        ["\xD2\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xD2\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],

        ["\xD2\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],
        ["\xD2\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],

        ["\xD2\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],
        ["\xD2\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],

        ["\xD2\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xD2\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],

        ["\xD2\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],
        ["\xD2\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],

        ["\xD2\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],
        ["\xD2\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],

        ["\xD2\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],
        ["\xD2\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],

        ["\xD2\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],
        ["\xD2\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],

        ["\xD2\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],
        ["\xD2\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],

        ["\xD2\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],
        ["\xD2\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],

        ["\xD2\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xD2\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],

        ["\xD2\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xD2\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],

        ["\xD2\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xD2\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],

        ["\xD2\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xD2\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],

        ["\xD2\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xD2\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],

        ["\xD2\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xD2\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],

        ["\xD2\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xD2\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],

        ["\xD2\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xD2\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],

        ["\xD2\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xD2\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],

        ["\xD2\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xD2\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],

        ["\xD2\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],
        ["\xD2\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],

        ["\xD2\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],
        ["\xD2\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],

        ["\xD2\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],
        ["\xD2\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],

        ["\xD2\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xD2\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],

        ["\xD2\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],
        ["\xD2\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],

        ["\xD2\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],
        ["\xD2\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],

        ["\xD2\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xD2\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],

        ["\xD2\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xD2\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],

        ["\xD2\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xD2\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],

        ["\xD2\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xD2\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],

        ["\xD2\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xD2\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],

        ["\xD2\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xD2\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],

        ["\xD2\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xD2\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],

        ["\xD2\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xD2\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],

        ["\xD2\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xD2\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],

        ["\xD2\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xD2\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],

        ["\xD2\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],
        ["\xD2\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],

        ["\xD2\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],
        ["\xD2\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],

        ["\xD2\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],
        ["\xD2\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],

        ["\xD2\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],
        ["\xD2\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],

        ["\xD2\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],
        ["\xD2\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],

        ["\xD2\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],
        ["\xD2\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],

        ["\xD2\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xD2\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],

        ["\xD2\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],
        ["\xD2\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],

        ["\xD2\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xD2\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],

        ["\xD2\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xD2\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],

        ["\xD2\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xD2\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],

        ["\xD2\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xD2\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],

        ["\xD2\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xD2\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],

        ["\xD2\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xD2\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],

        ["\xD2\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xD2\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],

        ["\xD2\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xD2\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],

        ["\xD2\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],
        ["\xD2\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],

        ["\xD2\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],
        ["\xD2\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],

        ["\xD2\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xD2\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],

        ["\xD2\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xD2\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],

        ["\xD2\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],
        ["\xD2\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],

        ["\xD2\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],
        ["\xD2\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],

        ["\xD2\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xD2\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],

        ["\xD2\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xD2\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],

        ["\xD2\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xD2\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],

        ["\xD2\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xD2\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],

        ["\xD2\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xD2\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],

        ["\xD2\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xD2\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],

        ["\xD2\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xD2\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],

        ["\xD2\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xD2\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],

        ["\xD2\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xD2\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],

        ["\xD2\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xD2\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],

        ["\xD2\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xD2\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],

        ["\xD2\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xD2\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],

        ["\xD2\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],
        ["\xD2\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],

        ["\xD2\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],
        ["\xD2\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],

        ["\xD2\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xD2\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],

        ["\xD3\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xD3\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],

        ["\xD3\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xD3\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],

        ["\xD3\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],
        ["\xD3\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],

        ["\xD3\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],
        ["\xD3\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],

        ["\xD3\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xD3\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],

        ["\xD3\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],
        ["\xD3\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],

        ["\xD3\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],
        ["\xD3\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],

        ["\xD3\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],
        ["\xD3\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],

        ["\xD3\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],
        ["\xD3\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],

        ["\xD3\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xD3\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],

        ["\xD3\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xD3\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],

        ["\xD3\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],
        ["\xD3\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],

        ["\xD3\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],
        ["\xD3\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],

        ["\xD3\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],
        ["\xD3\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],

        ["\xD3\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],
        ["\xD3\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],

        ["\xD3\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xD3\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],

        ["\xD3\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xD3\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],

        ["\xD3\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xD3\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],

        ["\xD3\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xD3\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],

        ["\xD3\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],
        ["\xD3\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],

        ["\xD3\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xD3\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],

        ["\xD3\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],
        ["\xD3\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],

        ["\xD3\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xD3\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],

        ["\xD3\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],
        ["\xD3\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],

        ["\xD3\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xD3\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],

        ["\xD3\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],
        ["\xD3\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],

        ["\xD3\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xD3\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],

        ["\xD3\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],
        ["\xD3\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],

        ["\xD3\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xD3\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],

        ["\xD3\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xD3\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],

        ["\xD3\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],
        ["\xD3\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],

        ["\xD3\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xD3\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],

        ["\xD3\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xD3\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],

        ["\xD3\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xD3\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],

        ["\xD3\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xD3\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],

        ["\xD3\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xD3\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],

        ["\xD3\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xD3\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],

        ["\xD3\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xD3\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],

        ["\xD3\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xD3\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],

        ["\xD3\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xD3\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],

        ["\xD3\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xD3\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],

        ["\xD3\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xD3\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],

        ["\xD3\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xD3\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],

        ["\xD3\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xD3\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],

        ["\xD3\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xD3\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],

        ["\xD3\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],
        ["\xD3\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],

        ["\xD3\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xD3\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],

        ["\xD3\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xD3\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],

        ["\xD3\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xD3\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],

        ["\xD3\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xD3\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],

        ["\xD3\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xD3\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],

        ["\xD3\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xD3\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],

        ["\xD3\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xD3\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],

        ["\xD3\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xD3\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],

        ["\xD3\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xD3\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],

        ["\xD3\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xD3\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],

        ["\xD3\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xD3\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],

        ["\xD3\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],
        ["\xD3\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],

        ["\xD3\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],
        ["\xD3\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],

        ["\xD3\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xD3\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],

        ["\xD3\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xD3\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],

        ["\xD3\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],
        ["\xD3\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],

        ["\xD3\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xD3\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],

        ["\xD3\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xD3\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],

        ["\xD3\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xD3\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],

        ["\xD3\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xD3\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],

        ["\xD3\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xD3\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],

        ["\xD3\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xD3\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],

        ["\xD3\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xD3\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],

        ["\xD3\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xD3\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],

        ["\xD3\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xD3\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],

        ["\xD3\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xD3\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],

        ["\xD3\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xD3\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],

        ["\xD3\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],
        ["\xD3\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],

        ["\xD3\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xD3\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],

        ["\xD3\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xD3\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],

        ["\xD3\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xD3\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],

        ["\xD3\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],
        ["\xD3\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],

        ["\xD3\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xD3\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],

        ["\xD3\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xD3\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],

        ["\xD3\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xD3\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],

        ["\xD3\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xD3\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],

        ["\xD3\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xD3\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],

        ["\xD3\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xD3\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],

        ["\xD3\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xD3\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],

        ["\xD3\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xD3\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],

        ["\xD3\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xD3\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],

        ["\xD3\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xD3\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],

        ["\xD3\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xD3\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],

        ["\xD3\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xD3\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],

        ["\xD3\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],
        ["\xD3\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],

        ["\xD3\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xD3\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],

        ["\xD3\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xD3\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],

        ["\xD3\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xD3\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],

        ["\xD4\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xD4\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],

        ["\xD4\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],
        ["\xD4\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],

        ["\xD4\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xD4\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],

        ["\xD4\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xD4\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],

        ["\xD4\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xD4\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],

        ["\xD4\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],
        ["\xD4\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],

        ["\xD4\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],
        ["\xD4\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],

        ["\xD4\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],
        ["\xD4\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],

        ["\xD4\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xD4\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],

        ["\xD4\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],
        ["\xD4\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],

        ["\xD4\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xD4\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],

        ["\xD4\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],
        ["\xD4\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],

        ["\xD4\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],
        ["\xD4\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],

        ["\xD4\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],
        ["\xD4\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],

        ["\xD4\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xD4\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],

        ["\xD4\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xD4\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],

        ["\xD4\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xD4\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],

        ["\xD4\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xD4\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],

        ["\xD4\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xD4\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],

        ["\xD4\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],
        ["\xD4\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],

        ["\xD4\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xD4\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],

        ["\xD4\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],
        ["\xD4\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],

        ["\xD4\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],
        ["\xD4\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],

        ["\xD4\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xD4\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],

        ["\xD4\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xD4\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],

        ["\xD4\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],
        ["\xD4\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],

        ["\xD4\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],
        ["\xD4\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],

        ["\xD4\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],
        ["\xD4\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],

        ["\xD4\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],
        ["\xD4\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],

        ["\xD4\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xD4\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],

        ["\xD4\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],
        ["\xD4\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],

        ["\xD4\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xD4\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],

        ["\xD4\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xD4\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],

        ["\xD4\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xD4\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],

        ["\xD4\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xD4\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],

        ["\xD4\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xD4\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],

        ["\xD4\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xD4\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],

        ["\xD4\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xD4\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],

        ["\xD4\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xD4\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],

        ["\xD4\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xD4\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],

        ["\xD4\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xD4\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],

        ["\xD4\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xD4\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],

        ["\xD4\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xD4\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],

        ["\xD4\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],
        ["\xD4\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],

        ["\xD4\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],
        ["\xD4\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],

        ["\xD4\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xD4\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],

        ["\xD4\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],
        ["\xD4\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],

        ["\xD4\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xD4\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],

        ["\xD4\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xD4\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],

        ["\xD4\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xD4\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],

        ["\xD4\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xD4\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],

        ["\xD4\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xD4\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],

        ["\xD4\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xD4\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],

        ["\xD4\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xD4\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],

        ["\xD4\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xD4\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],

        ["\xD4\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xD4\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],

        ["\xD4\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xD4\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],

        ["\xD4\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],
        ["\xD4\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],

        ["\xD4\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],
        ["\xD4\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],

        ["\xD4\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xD4\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],

        ["\xD4\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],
        ["\xD4\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],

        ["\xD4\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],
        ["\xD4\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],

        ["\xD4\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],
        ["\xD4\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],

        ["\xD4\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xD4\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],

        ["\xD4\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xD4\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],

        ["\xD4\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xD4\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],

        ["\xD4\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xD4\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],

        ["\xD4\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],
        ["\xC4\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],

        ["\xD4\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xD4\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],

        ["\xD4\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xD4\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],

        ["\xD4\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xD4\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],

        ["\xD4\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xD4\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],

        ["\xD4\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xD4\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],

        ["\xD4\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xD4\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],

        ["\xD4\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],
        ["\xD4\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],

        ["\xD4\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xD4\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],

        ["\xD4\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xD4\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],

        ["\xD4\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],
        ["\xD4\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],

        ["\xD4\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xD4\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],

        ["\xD4\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xD4\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],

        ["\xD4\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xD4\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],

        ["\xD4\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xD4\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],

        ["\xD4\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xD4\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],

        ["\xD4\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xD4\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],

        ["\xD4\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xD4\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],

        ["\xD4\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xD4\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],

        ["\xD4\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xD4\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],

        ["\xD4\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xD4\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],

        ["\xD4\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xD4\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],

        ["\xD4\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],
        ["\xD4\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],

        ["\xD4\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],
        ["\xD4\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],

        ["\xD4\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xD4\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],

        ["\xD4\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],
        ["\xD4\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],

        ["\xD4\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],
        ["\xD4\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],

        ["\xD5\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xD5\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],

        ["\xD5\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],
        ["\xD5\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],

        ["\xD5\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],
        ["\xD5\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],

        ["\xD5\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],
        ["\xD5\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],

        ["\xD5\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],
        ["\xD5\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],

        ["\xD5\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],
        ["\xD5\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],

        ["\xD5\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],
        ["\xD5\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],

        ["\xD5\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],
        ["\xD5\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],

        ["\xD5\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],
        ["\xD5\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],

        ["\xD5\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],
        ["\xD5\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],

        ["\xD5\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xD5\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],

        ["\xD5\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],
        ["\xD5\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],

        ["\xD5\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],
        ["\xD5\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],

        ["\xD5\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],
        ["\xD5\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],

        ["\xD5\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],
        ["\xD5\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],

        ["\xD5\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xD5\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],

        ["\xD5\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],
        ["\xD5\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],

        ["\xD5\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],
        ["\xD5\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],

        ["\xD5\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],
        ["\xD5\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],

        ["\xD5\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],
        ["\xD5\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],

        ["\xD5\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],
        ["\xD5\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],

        ["\xD5\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],
        ["\xD5\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],

        ["\xD5\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],
        ["\xD5\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],

        ["\xD5\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],
        ["\xD5\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],

        ["\xD5\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],
        ["\xD5\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],

        ["\xD5\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],
        ["\xD5\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],

        ["\xD5\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],
        ["\xD5\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],

        ["\xD5\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],
        ["\xD5\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],

        ["\xD5\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],
        ["\xD5\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],

        ["\xD5\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],
        ["\xD5\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],

        ["\xD5\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],
        ["\xD5\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],

        ["\xD5\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xD5\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],

        ["\xD5\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xD5\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],

        ["\xD5\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xD5\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],

        ["\xD5\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xD5\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],

        ["\xD5\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xD5\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],

        ["\xD5\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xD5\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],

        ["\xD5\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xD5\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],

        ["\xD5\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xD5\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],

        ["\xD5\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xD5\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],

        ["\xD5\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xD5\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],

        ["\xD5\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],
        ["\xD5\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],

        ["\xD5\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],
        ["\xD5\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],

        ["\xD5\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],
        ["\xD5\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],

        ["\xD5\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],
        ["\xD5\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],

        ["\xD5\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],
        ["\xD5\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],

        ["\xD5\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],
        ["\xD5\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],

        ["\xD5\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xD5\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],

        ["\xD5\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xD5\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],

        ["\xD5\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xD5\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],

        ["\xD5\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xD5\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],

        ["\xD5\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xD5\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],

        ["\xD5\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xD5\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],

        ["\xD5\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xD5\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],

        ["\xD5\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xD5\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],

        ["\xD5\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xD5\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],

        ["\xD5\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xD5\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],

        ["\xD5\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],
        ["\xD5\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],

        ["\xD5\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],
        ["\xD5\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],

        ["\xD5\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],
        ["\xD5\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],

        ["\xD5\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],
        ["\xD5\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],

        ["\xD5\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],
        ["\xD5\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],

        ["\xD5\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],
        ["\xD5\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],

        ["\xD5\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xD5\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],

        ["\xD5\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],
        ["\xD5\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],

        ["\xD5\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xD5\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],

        ["\xD5\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xD5\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],

        ["\xD5\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xD5\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],

        ["\xD5\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xD5\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],

        ["\xD5\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xD5\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],

        ["\xD5\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xD5\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],

        ["\xD5\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xD5\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],

        ["\xD5\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xD5\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],

        ["\xD5\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],
        ["\xD5\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],

        ["\xD5\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],
        ["\xD5\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],

        ["\xD5\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],
        ["\xD5\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],

        ["\xD5\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],
        ["\xD5\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],

        ["\xD5\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],
        ["\xD5\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],

        ["\xD5\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],
        ["\xD5\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],

        ["\xD5\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xD5\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],

        ["\xD5\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xD5\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],

        ["\xD5\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xD5\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],

        ["\xD5\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xD5\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],

        ["\xD5\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xD5\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],

        ["\xD5\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xD5\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],

        ["\xD5\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xD5\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],

        ["\xD5\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xD5\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],

        ["\xD5\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xD5\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],

        ["\xD5\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xD5\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],

        ["\xD5\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],
        ["\xD5\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],

        ["\xD5\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],
        ["\xD5\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],

        ["\xD5\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],
        ["\xD5\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],

        ["\xD5\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],
        ["\xD5\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],

        ["\xD5\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],
        ["\xD5\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],

        ["\xD6\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],
        ["\xD6\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],

        ["\xD6\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],
        ["\xD6\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],

        ["\xD6\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],
        ["\xD6\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],

        ["\xD6\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],
        ["\xD6\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],

        ["\xD6\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],
        ["\xD6\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],

        ["\xD6\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],
        ["\xD6\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],

        ["\xD6\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],
        ["\xD6\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],

        ["\xD6\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],
        ["\xD6\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],

        ["\xD6\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],
        ["\xD6\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],

        ["\xD6\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],
        ["\xD6\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],

        ["\xD6\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],
        ["\xD6\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],

        ["\xD6\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],
        ["\xD6\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],

        ["\xD6\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],
        ["\xD6\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],

        ["\xD6\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],
        ["\xD6\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],

        ["\xD6\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],
        ["\xD6\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],

        ["\xD6\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],
        ["\xD6\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],

        ["\xD6\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],
        ["\xD6\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],

        ["\xD6\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],
        ["\xD6\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],

        ["\xD6\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],
        ["\xD6\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],

        ["\xD6\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],
        ["\xD6\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],

        ["\xD6\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],
        ["\xD6\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],

        ["\xD6\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],
        ["\xD6\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],

        ["\xD6\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],
        ["\xD6\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],

        ["\xD6\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\xD6\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],

        ["\xD6\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\xD6\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],

        ["\xD6\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\xD6\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],

        ["\xD6\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xD6\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],

        ["\xD6\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\xD6\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],

        ["\xD6\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\xD6\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],

        ["\xD6\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\xD6\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],

        ["\xD6\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\xD6\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],

        ["\xD6\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\xD6\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],

        ["\xD6\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xD6\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],

        ["\xD6\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xD6\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],

        ["\xD6\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xD6\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],

        ["\xD6\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xD6\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],

        ["\xD6\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xD6\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],

        ["\xD6\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xD6\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],

        ["\xD6\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xD6\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],

        ["\xD6\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xD6\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],

        ["\xD6\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xD6\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],

        ["\xD6\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\xD6\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],

        ["\xD6\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\xD6\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],

        ["\xD6\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],
        ["\xD6\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],

        ["\xD6\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],
        ["\xD6\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],

        ["\xD6\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],
        ["\xD6\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],

        ["\xD6\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],
        ["\xD6\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],

        ["\xD6\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\xD6\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],

        ["\xD6\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xD6\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],

        ["\xD6\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xD6\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],

        ["\xD6\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xD6\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],

        ["\xD6\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xD6\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],

        ["\xD6\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xD6\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],

        ["\xD6\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xD6\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],

        ["\xD6\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xD6\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],

        ["\xD6\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xD6\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],

        ["\xD6\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xD6\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],

        ["\xD6\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],
        ["\xD6\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],

        ["\xD6\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],
        ["\xD6\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],

        ["\xD6\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\xD6\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],

        ["\xD6\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\xD6\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],

        ["\xD6\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],
        ["\xD6\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],

        ["\xD6\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\xD6\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],

        ["\xD6\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xD6\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],

        ["\xD6\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],
        ["\xD6\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],

        ["\xD6\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xD6\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],

        ["\xD6\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\xD6\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],

        ["\xD6\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],
        ["\xD6\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],

        ["\xD6\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],
        ["\xD6\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],

        ["\xD6\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xD6\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],

        ["\xD6\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],
        ["\xD6\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],

        ["\xD6\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],
        ["\xD6\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],

        ["\xD6\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],
        ["\xD6\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],

        ["\xD6\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],
        ["\xD6\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],

        ["\xD6\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],
        ["\xD6\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],

        ["\xD6\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\xD6\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],

        ["\xD6\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\xD6\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],

        ["\xD6\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],
        ["\xD6\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],

        ["\xD6\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],
        ["\xD6\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],

        ["\xD6\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xD6\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],

        ["\xD6\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xD6\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],

        ["\xD6\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xD6\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],

        ["\xD6\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xD6\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],

        ["\xD6\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xD6\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],

        ["\xD6\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xD6\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],

        ["\xD6\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xD6\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],

        ["\xD6\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xD6\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],

        ["\xD6\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xD6\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],

        ["\xD6\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xD6\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],

        ["\xD6\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\xD6\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],

        ["\xD6\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\xD6\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],

        ["\xD6\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\xD6\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],

        ["\xD6\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],
        ["\xD6\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],

        ["\xD6\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],
        ["\xD6\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],

        ["\xD7\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xD7\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],

        ["\xD7\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],
        ["\xD7\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],

        ["\xD7\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],
        ["\xD7\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],

        ["\xD7\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],
        ["\xD7\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],

        ["\xD7\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],
        ["\xD7\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],

        ["\xD7\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],
        ["\xD7\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],

        ["\xD7\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],
        ["\xD7\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],

        ["\xD7\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],
        ["\xD7\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],

        ["\xD7\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],
        ["\xD7\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],

        ["\xD7\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],
        ["\xD7\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],

        ["\xD7\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xD7\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],

        ["\xD7\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],
        ["\xD7\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],

        ["\xD7\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],
        ["\xD7\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],

        ["\xD7\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],
        ["\xD7\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],

        ["\xD7\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],
        ["\xD7\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],

        ["\xD7\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xD7\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],

        ["\xD7\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],
        ["\xD7\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],

        ["\xD7\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],
        ["\xD7\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],

        ["\xD7\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],
        ["\xD7\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],

        ["\xD7\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],
        ["\xD7\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],

        ["\xD7\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],
        ["\xD7\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],

        ["\xD7\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],
        ["\xD7\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],

        ["\xD7\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],
        ["\xD7\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],

        ["\xD7\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],
        ["\xD7\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],

        ["\xD7\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],
        ["\xD7\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],

        ["\xD7\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],
        ["\xD7\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],

        ["\xD7\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],
        ["\xD7\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],

        ["\xD7\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],
        ["\xD7\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],

        ["\xD7\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],
        ["\xD7\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],

        ["\xD7\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],
        ["\xD7\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],

        ["\xD7\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xD7\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],

        ["\xD7\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xD7\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],

        ["\xD7\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xD7\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],

        ["\xD7\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xD7\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],

        ["\xD7\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xD7\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],

        ["\xD7\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xD7\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],

        ["\xD7\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xD7\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],

        ["\xD7\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xD7\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],

        ["\xD7\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xD7\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],

        ["\xD7\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xD7\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],

        ["\xD7\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],
        ["\xD7\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],

        ["\xD7\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],
        ["\xD7\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],

        ["\xD7\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],
        ["\xD7\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],

        ["\xD7\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],
        ["\xD7\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],

        ["\xD7\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],
        ["\xD7\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],

        ["\xD7\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],
        ["\xD7\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],

        ["\xD7\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xD7\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],

        ["\xD7\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xD7\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],

        ["\xD7\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xD7\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],

        ["\xD7\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xD7\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],

        ["\xD7\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xD7\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],

        ["\xD7\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xD7\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],

        ["\xD7\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xD7\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],

        ["\xD7\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xD7\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],

        ["\xD7\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xD7\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],

        ["\xD7\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xD7\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],

        ["\xD7\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],
        ["\xD7\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],

        ["\xD7\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],
        ["\xD7\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],

        ["\xD7\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],
        ["\xD7\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],

        ["\xD7\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],
        ["\xD7\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],

        ["\xD7\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],
        ["\xD7\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],

        ["\xD7\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],
        ["\xD7\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],

        ["\xD7\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xD7\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],

        ["\xD7\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],
        ["\xD7\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],

        ["\xD7\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xD7\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],

        ["\xD7\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xD7\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],

        ["\xD7\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xD7\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],

        ["\xD7\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xD7\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],

        ["\xD7\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xD7\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],

        ["\xD7\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xD7\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],

        ["\xD7\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xD7\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],

        ["\xD7\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xD7\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],

        ["\xD7\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],
        ["\xD7\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],

        ["\xD7\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],
        ["\xD7\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],

        ["\xD7\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],
        ["\xD7\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],

        ["\xD7\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],
        ["\xD7\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],

        ["\xD7\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],
        ["\xD7\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],

        ["\xD7\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],
        ["\xD7\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],

        ["\xD7\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xD7\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],

        ["\xD7\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xD7\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],

        ["\xD7\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xD7\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],

        ["\xD7\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xD7\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],

        ["\xD7\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xD7\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],

        ["\xD7\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xD7\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],

        ["\xD7\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xD7\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],

        ["\xD7\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xD7\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],

        ["\xD7\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xD7\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],

        ["\xD7\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xD7\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],

        ["\xD7\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],
        ["\xD7\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],

        ["\xD7\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],
        ["\xD7\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],

        ["\xD7\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],
        ["\xD7\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],

        ["\xD7\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],
        ["\xD7\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],

        ["\xD7\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],
        ["\xD7\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],

        ["\xD8\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xD8\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],

        ["\xD8\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\xD8\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],

        ["\xD8\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\xD8\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],

        ["\xD8\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\xD8\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],

        ["\xD8\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],
        ["\xD8\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],

        ["\xD8\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],
        ["\xD8\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],

        ["\xD8\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],
        ["\xD8\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],

        ["\xD8\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\xD8\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],

        ["\xD8\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\xD8\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],

        ["\xD8\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\xD8\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],

        ["\xD8\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xD8\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],

        ["\xD8\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\xD8\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],

        ["\xD8\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\xD8\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],

        ["\xD8\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\xD8\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],

        ["\xD8\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\xD8\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],

        ["\xD8\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xD8\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],

        ["\xD8\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\xD8\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],

        ["\xD8\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],
        ["\xD8\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],

        ["\xD8\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],
        ["\xD8\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],

        ["\xD8\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],
        ["\xD8\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],

        ["\xD8\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\xD8\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],

        ["\xD8\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\xD8\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],

        ["\xD8\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\xD8\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],

        ["\xD8\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],
        ["\xD8\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],

        ["\xD8\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\xD8\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],

        ["\xD8\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\xD8\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],

        ["\xD8\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],
        ["\xD8\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],

        ["\xD8\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],
        ["\xD8\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],

        ["\xD8\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\xD8\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],

        ["\xD8\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\xD8\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],

        ["\xD8\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\xD8\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],

        ["\xD8\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xD8\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],

        ["\xD8\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xD8\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],

        ["\xD8\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xD8\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],

        ["\xD8\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xD8\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],

        ["\xD8\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xD8\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],

        ["\xD8\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xD8\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],

        ["\xD8\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xD8\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],

        ["\xD8\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xD8\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],

        ["\xD8\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xD8\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],

        ["\xD8\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xD8\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],

        ["\xD8\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\xD8\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],

        ["\xD8\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],
        ["\xD8\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],

        ["\xD8\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\xD8\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],

        ["\xD8\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\xD8\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],

        ["\xD8\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\xD8\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],

        ["\xD8\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],
        ["\xD8\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],

        ["\xD8\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xD8\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],

        ["\xD8\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xD8\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],

        ["\xD8\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xD8\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],

        ["\xD8\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xD8\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],

        ["\xD8\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xD8\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],

        ["\xD8\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xD8\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],

        ["\xD8\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xD8\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],

        ["\xD8\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xD8\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],

        ["\xD8\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xD8\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],

        ["\xD8\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xD8\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],

        ["\xD8\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],
        ["\xD8\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],

        ["\xD8\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],
        ["\xD8\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],

        ["\xD8\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],
        ["\xD8\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],

        ["\xD8\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\xD8\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],

        ["\xD8\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\xD8\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],

        ["\xD8\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],
        ["\xD8\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],

        ["\xD8\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xD8\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],

        ["\xD8\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],
        ["\xD8\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],

        ["\xD8\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xD8\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],

        ["\xD8\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xD8\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],

        ["\xD8\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xD8\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],

        ["\xD8\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xD8\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],

        ["\xD8\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xD8\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],

        ["\xD8\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xD8\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],

        ["\xD8\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xD8\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],

        ["\xD8\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xD8\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],

        ["\xD8\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],
        ["\xD8\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],

        ["\xD8\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],
        ["\xD8\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],

        ["\xD8\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],
        ["\xD8\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],

        ["\xD8\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\xD8\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],

        ["\xD8\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\xD8\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],

        ["\xD8\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],
        ["\xD8\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],

        ["\xD8\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xD8\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],

        ["\xD8\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xD8\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],

        ["\xD8\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xD8\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],

        ["\xD8\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xD8\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],

        ["\xD8\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xD8\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],

        ["\xD8\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xD8\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],

        ["\xD8\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xD8\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],

        ["\xD8\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xD8\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],

        ["\xD8\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xD8\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],

        ["\xD8\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xD8\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],

        ["\xD8\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\xD8\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],

        ["\xD8\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],
        ["\xD8\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],

        ["\xD8\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\xD8\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],

        ["\xD8\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],
        ["\xD8\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],

        ["\xD8\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\xD8\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],

        ["\xD9\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xD9\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],

        ["\xD9\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],
        ["\xD9\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],

        ["\xD9\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],
        ["\xD9\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],

        ["\xD9\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],
        ["\xD9\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],

        ["\xD9\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],
        ["\xD9\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],

        ["\xD9\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],
        ["\xD9\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],

        ["\xD9\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],
        ["\xD9\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],

        ["\xD9\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],
        ["\xD9\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],

        ["\xD9\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],
        ["\xD9\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],

        ["\xD9\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],
        ["\xD9\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],

        ["\xD9\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xD9\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],

        ["\xD9\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],
        ["\xD9\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],

        ["\xD9\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],
        ["\xD9\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],

        ["\xD9\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],
        ["\xD9\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],

        ["\xD9\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],
        ["\xD9\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],

        ["\xD9\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xD9\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],

        ["\xD9\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],
        ["\xD9\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],

        ["\xD9\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],
        ["\xD9\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],

        ["\xD9\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],
        ["\xD9\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],

        ["\xD9\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],
        ["\xD9\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],

        ["\xD9\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],
        ["\xD9\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],

        ["\xD9\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],
        ["\xD9\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],

        ["\xD9\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],
        ["\xD9\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],

        ["\xD9\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],
        ["\xD9\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],

        ["\xD9\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],
        ["\xD9\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],

        ["\xD9\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],
        ["\xD9\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],

        ["\xD9\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],
        ["\xD9\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],

        ["\xD9\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],
        ["\xD9\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],

        ["\xD9\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],
        ["\xD9\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],

        ["\xD9\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],
        ["\xD9\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],

        ["\xD9\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],
        ["\xD9\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],

        ["\xD9\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xD9\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],

        ["\xD9\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xD9\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],

        ["\xD9\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xD9\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],

        ["\xD9\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xD9\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],

        ["\xD9\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xD9\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],

        ["\xD9\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xD9\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],

        ["\xD9\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xD9\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],

        ["\xD9\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xD9\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],

        ["\xD9\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xD9\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],

        ["\xD9\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xD9\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],

        ["\xD9\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],
        ["\xD9\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],

        ["\xD9\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],
        ["\xD9\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],

        ["\xD9\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],
        ["\xD9\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],

        ["\xD9\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],
        ["\xD9\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],

        ["\xD9\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],
        ["\xD9\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],

        ["\xD9\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],
        ["\xD9\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],

        ["\xD9\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xD9\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],

        ["\xD9\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xD9\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],

        ["\xD9\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xD9\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],

        ["\xD9\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xD9\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],

        ["\xD9\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xD9\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],

        ["\xD9\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xD9\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],

        ["\xD9\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xD9\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],

        ["\xD9\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xD9\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],

        ["\xD9\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xD9\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],

        ["\xD9\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xD9\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],

        ["\xD9\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],
        ["\xD9\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],

        ["\xD9\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],
        ["\xD9\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],

        ["\xD9\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],
        ["\xD9\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],

        ["\xD9\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],
        ["\xD9\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],

        ["\xD9\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],
        ["\xD9\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],

        ["\xD9\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],
        ["\xD9\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],

        ["\xD9\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xD9\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],

        ["\xD9\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],
        ["\xD9\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],

        ["\xD9\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xD9\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],

        ["\xD9\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xD9\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],

        ["\xD9\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xD9\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],

        ["\xD9\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xD9\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],

        ["\xD9\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xD9\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],

        ["\xD9\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xD9\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],

        ["\xD9\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xD9\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],

        ["\xD9\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xD9\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],

        ["\xD9\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],
        ["\xD9\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],

        ["\xD9\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],
        ["\xD9\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],

        ["\xD9\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],
        ["\xD9\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],

        ["\xD9\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],
        ["\xD9\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],

        ["\xD9\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],
        ["\xD9\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],

        ["\xD9\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],
        ["\xD9\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],

        ["\xD9\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xD9\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],

        ["\xD9\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xD9\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],

        ["\xD9\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xD9\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],

        ["\xD9\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xD9\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],

        ["\xD9\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xD9\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],

        ["\xD9\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xD9\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],

        ["\xD9\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xD9\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],

        ["\xD9\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xD9\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],

        ["\xD9\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xB3\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],

        ["\xD9\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xD9\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],

        ["\xD9\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],
        ["\xD9\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],

        ["\xD9\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],
        ["\xD9\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],

        ["\xD9\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],
        ["\xD9\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],

        ["\xD9\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],
        ["\xD9\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],

        ["\xD9\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],
        ["\xD9\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],

        ["\xDA\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],
        ["\xDA\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],

        ["\xDA\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],
        ["\xDA\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],

        ["\xDA\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],
        ["\xDA\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],

        ["\xDA\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],
        ["\xDA\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],

        ["\xDA\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],
        ["\xDA\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],

        ["\xDA\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],
        ["\xDA\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],

        ["\xDA\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],
        ["\xDA\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],

        ["\xDA\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],
        ["\xDA\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],

        ["\xDA\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],
        ["\xDA\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],

        ["\xDA\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],
        ["\xDA\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],

        ["\xDA\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],
        ["\xDA\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],

        ["\xDA\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],
        ["\xDA\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],

        ["\xDA\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],
        ["\xDA\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],

        ["\xDA\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],
        ["\xDA\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],

        ["\xDA\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],
        ["\xDA\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],

        ["\xDA\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],
        ["\xDA\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],

        ["\xDA\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],
        ["\xDA\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],

        ["\xDA\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],
        ["\xDA\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],

        ["\xDA\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],
        ["\xDA\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],

        ["\xDA\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],
        ["\xDA\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],

        ["\xDA\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],
        ["\xDA\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],

        ["\xDA\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],
        ["\xDA\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],

        ["\xDA\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],
        ["\xDA\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],

        ["\xDA\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],
        ["\xDA\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],

        ["\xDA\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],
        ["\xDA\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],

        ["\xDA\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],
        ["\xDA\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],

        ["\xDA\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],
        ["\xDA\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],

        ["\xDA\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],
        ["\xDA\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],

        ["\xDA\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],
        ["\xDA\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],

        ["\xDA\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],
        ["\xDA\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],

        ["\xDA\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],
        ["\xDA\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],

        ["\xDA\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],
        ["\xDA\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],

        ["\xDA\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],
        ["\xDA\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],

        ["\xDA\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],
        ["\xDA\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],

        ["\xDA\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],
        ["\xDA\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],

        ["\xDA\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],
        ["\xDA\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],

        ["\xDA\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],
        ["\xDA\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],

        ["\xDA\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],
        ["\xDA\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],

        ["\xDA\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],
        ["\xDA\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],

        ["\xDA\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],
        ["\xDA\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],

        ["\xDA\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],
        ["\xDA\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],

        ["\xDA\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],
        ["\xDA\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],

        ["\xDA\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],
        ["\xDA\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],

        ["\xDA\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],
        ["\xDA\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],

        ["\xDA\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],
        ["\xDA\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],

        ["\xDA\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],
        ["\xDA\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],

        ["\xDA\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],
        ["\xDA\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],

        ["\xDA\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],
        ["\xDA\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],

        ["\xDA\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],
        ["\xDA\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],

        ["\xDA\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],
        ["\xDA\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],

        ["\xDA\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],
        ["\xDA\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],

        ["\xDA\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],
        ["\xDA\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],

        ["\xDA\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],
        ["\xDA\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],

        ["\xDA\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],
        ["\xDA\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],

        ["\xDA\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],
        ["\xDA\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],

        ["\xDA\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],
        ["\xDA\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],

        ["\xDA\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],
        ["\xDA\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],

        ["\xDA\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],
        ["\xDA\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],

        ["\xDA\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],
        ["\xDA\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],

        ["\xDA\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],
        ["\xDA\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],

        ["\xDA\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],
        ["\xDA\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],

        ["\xDA\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\xDA\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],

        ["\xDA\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\xDA\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],

        ["\xDA\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],
        ["\xDA\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],

        ["\xDA\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],
        ["\xDA\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],

        ["\xDA\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],
        ["\xDA\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],

        ["\xDA\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],
        ["\xDA\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],

        ["\xDA\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],
        ["\xDA\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],

        ["\xDA\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],
        ["\xDA\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],

        ["\xDA\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],
        ["\xDA\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],

        ["\xDA\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],
        ["\xDA\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],

        ["\xDA\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],
        ["\xDA\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],

        ["\xDA\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],
        ["\xDA\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],

        ["\xDA\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],
        ["\xDA\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],

        ["\xDA\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],
        ["\xDA\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],

        ["\xDA\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],
        ["\xDA\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],

        ["\xDA\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],
        ["\xDA\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],

        ["\xDA\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],
        ["\xDA\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],

        ["\xDA\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],
        ["\xDA\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],

        ["\xDA\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],
        ["\xDA\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],

        ["\xDA\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],
        ["\xDA\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],

        ["\xDA\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],
        ["\xDA\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],

        ["\xDA\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],
        ["\xDA\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],

        ["\xDA\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],
        ["\xDA\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],

        ["\xDA\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],
        ["\xDA\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],

        ["\xDA\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],
        ["\xDA\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],

        ["\xDA\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],
        ["\xDA\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],

        ["\xDA\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],
        ["\xDA\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],

        ["\xDA\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],
        ["\xDA\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],

        ["\xDA\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],
        ["\xDA\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],

        ["\xDA\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],
        ["\xDA\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],

        ["\xDA\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],
        ["\xDA\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],

        ["\xDA\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],
        ["\xDA\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],

        ["\xDA\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],
        ["\xDA\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],

        ["\xDB\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],
        ["\xDB\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],

        ["\xDB\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],
        ["\xDB\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],

        ["\xDB\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],
        ["\xDB\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],

        ["\xDB\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],
        ["\xDB\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],

        ["\xDB\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],
        ["\xDB\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],

        ["\xDB\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],
        ["\xDB\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],

        ["\xDB\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],
        ["\xDB\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],

        ["\xDB\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],
        ["\xDB\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],

        ["\xDB\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],
        ["\xDB\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],

        ["\xDB\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],
        ["\xDB\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],

        ["\xDB\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],
        ["\xDB\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],

        ["\xDB\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],
        ["\xDB\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],

        ["\xDB\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],
        ["\xDB\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],

        ["\xDB\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],
        ["\xDB\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],

        ["\xDB\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],
        ["\xDB\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],

        ["\xDB\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],
        ["\xDB\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],

        ["\xDB\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],
        ["\xDB\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],

        ["\xDB\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],
        ["\xDB\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],

        ["\xDB\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],
        ["\xDB\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],

        ["\xDB\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],
        ["\xDB\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],

        ["\xDB\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],
        ["\xDB\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],

        ["\xDB\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],
        ["\xDB\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],

        ["\xDB\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],
        ["\xDB\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],

        ["\xDB\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],
        ["\xDB\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],

        ["\xDB\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],
        ["\xDB\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],

        ["\xDB\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],
        ["\xDB\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],

        ["\xDB\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],
        ["\xDB\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],

        ["\xDB\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],
        ["\xDB\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],

        ["\xDB\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],
        ["\xDB\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],

        ["\xDB\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],
        ["\xDB\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],

        ["\xDB\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],
        ["\xDB\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],

        ["\xDB\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],
        ["\xDB\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],

        ["\xDB\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],
        ["\xDB\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],

        ["\xDB\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],
        ["\xDB\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],

        ["\xDB\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],
        ["\xDB\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],

        ["\xDB\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],
        ["\xDB\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],

        ["\xDB\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],
        ["\xDB\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],

        ["\xDB\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],
        ["\xDB\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],

        ["\xDB\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],
        ["\xDB\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],

        ["\xDB\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],
        ["\xDB\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],

        ["\xDB\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],
        ["\xDB\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],

        ["\xDB\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],
        ["\xDB\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],

        ["\xDB\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],
        ["\xDB\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],

        ["\xDB\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],
        ["\xDB\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],

        ["\xDB\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],
        ["\xDB\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],

        ["\xDB\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],
        ["\xDB\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],

        ["\xDB\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],
        ["\xDB\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],

        ["\xDB\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],
        ["\xDB\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],

        ["\xDB\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],
        ["\xDB\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],

        ["\xDB\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],
        ["\xDB\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],

        ["\xDB\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],
        ["\xDB\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],

        ["\xDB\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],
        ["\xDB\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],

        ["\xDB\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],
        ["\xDB\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],

        ["\xDB\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],
        ["\xDB\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],

        ["\xDB\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],
        ["\xDB\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],

        ["\xDB\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xC9\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],

        ["\xDB\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],
        ["\xDB\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],

        ["\xDB\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],
        ["\xDB\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],

        ["\xDB\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],
        ["\xDB\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],

        ["\xDB\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],
        ["\xDB\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],

        ["\xDB\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],
        ["\xDB\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],

        ["\xDB\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],
        ["\xDB\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],

        ["\xDB\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],
        ["\xDB\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],

        ["\xDB\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],
        ["\xDB\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],

        ["\xDB\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],
        ["\xDB\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],

        ["\xDB\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],
        ["\xDB\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],

        ["\xDB\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],
        ["\xDB\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],

        ["\xDB\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],
        ["\xDB\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],

        ["\xDB\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],
        ["\xDB\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],

        ["\xDB\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],
        ["\xDB\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],

        ["\xDB\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],
        ["\xDB\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],

        ["\xDB\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],
        ["\xDB\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],

        ["\xDB\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],
        ["\xDB\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],

        ["\xDB\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],
        ["\xDB\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],

        ["\xDB\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],
        ["\xDB\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],

        ["\xDB\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],
        ["\xDB\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],

        ["\xDB\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xC5\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],

        ["\xDB\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],
        ["\xDB\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],

        ["\xDB\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],
        ["\xDB\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],

        ["\xDB\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],
        ["\xDB\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],

        ["\xDB\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],
        ["\xDB\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],

        ["\xDB\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],
        ["\xDB\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],

        ["\xDB\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],
        ["\xDB\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],

        ["\xDB\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],
        ["\xDB\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],

        ["\xDB\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],
        ["\xDB\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],

        ["\xDB\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],
        ["\xDB\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],

        ["\xDB\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],
        ["\xDB\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],

        ["\xDB\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],
        ["\xDB\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],

        ["\xDB\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],
        ["\xDB\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],

        ["\xDB\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],
        ["\xDB\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],

        ["\xDB\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],
        ["\xDB\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],

        ["\xDB\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],
        ["\xDB\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],

        ["\xDB\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],
        ["\xDB\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],

        ["\xDB\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],
        ["\xDB\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],

        ["\xDC\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],
        ["\xDC\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],

        ["\xDC\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],
        ["\xDC\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],

        ["\xDC\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],
        ["\xDC\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],

        ["\xDC\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],
        ["\xDC\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],

        ["\xDC\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],
        ["\xDC\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],

        ["\xDC\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],
        ["\xDC\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],

        ["\xDC\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],
        ["\xDC\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],

        ["\xDC\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],
        ["\xDC\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],

        ["\xDC\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],
        ["\xDC\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],

        ["\xDC\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],
        ["\xDC\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],

        ["\xDC\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],
        ["\xDC\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],

        ["\xDC\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],
        ["\xDC\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],

        ["\xDC\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],
        ["\xDC\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],

        ["\xDC\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],
        ["\xDC\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],

        ["\xDC\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],
        ["\xDC\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],

        ["\xDC\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],
        ["\xDC\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],

        ["\xDC\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],
        ["\xDC\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],

        ["\xDC\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],
        ["\xDC\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],

        ["\xDC\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],
        ["\xDC\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],

        ["\xDC\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],
        ["\xDC\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],

        ["\xDC\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],
        ["\xDC\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],

        ["\xDC\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],
        ["\xDC\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],

        ["\xDC\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],
        ["\xDC\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],

        ["\xDC\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],
        ["\xDC\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],

        ["\xDC\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],
        ["\xDC\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],

        ["\xDC\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],
        ["\xDC\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],

        ["\xDC\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],
        ["\xDC\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],

        ["\xDC\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],
        ["\xDC\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],

        ["\xDC\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],
        ["\xDC\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],

        ["\xDC\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],
        ["\xDC\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],

        ["\xDC\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],
        ["\xDC\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],

        ["\xDC\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],
        ["\xDC\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],

        ["\xDC\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],
        ["\xDC\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],

        ["\xDC\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],
        ["\xDC\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],

        ["\xDC\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],
        ["\xDC\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],

        ["\xDC\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],
        ["\xDC\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],

        ["\xDC\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],
        ["\xDC\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],

        ["\xDC\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],
        ["\xDC\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],

        ["\xDC\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],
        ["\xDC\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],

        ["\xDC\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],
        ["\xDC\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],

        ["\xDC\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],
        ["\xDC\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],

        ["\xDC\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],
        ["\xDC\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],

        ["\xDC\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],
        ["\xDC\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],

        ["\xDC\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],
        ["\xDC\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],

        ["\xDC\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],
        ["\xDC\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],

        ["\xDC\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],
        ["\xDC\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],

        ["\xDC\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],
        ["\xDC\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],

        ["\xDC\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],
        ["\xDC\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],

        ["\xDC\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],
        ["\xDC\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],

        ["\xDC\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],
        ["\xDC\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],

        ["\xDC\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],
        ["\xDC\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],

        ["\xDC\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],
        ["\xDC\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],

        ["\xDC\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],
        ["\xDC\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],

        ["\xDC\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],
        ["\xDC\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],

        ["\xDC\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],
        ["\xDC\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],

        ["\xDC\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],
        ["\xDC\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],

        ["\xDC\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],
        ["\xDC\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],

        ["\xDC\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],
        ["\xDC\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],

        ["\xDC\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],
        ["\xDC\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],

        ["\xDC\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],
        ["\xDC\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],

        ["\xDC\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],
        ["\xDC\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],

        ["\xDC\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],
        ["\xDC\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],

        ["\xDC\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],
        ["\xDC\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],

        ["\xDC\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],
        ["\xDC\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],

        ["\xDC\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],
        ["\xDC\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],

        ["\xDC\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],
        ["\xDC\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],

        ["\xDC\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],
        ["\xDC\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],

        ["\xDC\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],
        ["\xDC\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],

        ["\xDC\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],
        ["\xDC\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],

        ["\xDC\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],
        ["\xDC\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],

        ["\xDC\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],
        ["\xDC\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],

        ["\xDC\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],
        ["\xDC\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],

        ["\xDC\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],
        ["\xDC\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],

        ["\xDC\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],
        ["\xDC\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],

        ["\xDC\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],
        ["\xDC\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],

        ["\xDC\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],
        ["\xDC\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],

        ["\xDC\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],
        ["\xDC\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],

        ["\xDC\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],
        ["\xDC\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],

        ["\xDC\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],
        ["\xDC\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],

        ["\xDC\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],
        ["\xDC\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],

        ["\xDC\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],
        ["\xDC\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],

        ["\xDC\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],
        ["\xDC\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],

        ["\xDC\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],
        ["\xDC\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],

        ["\xDC\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],
        ["\xDC\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],

        ["\xDC\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],
        ["\xDC\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],

        ["\xDC\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],
        ["\xDC\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],

        ["\xDC\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],
        ["\xDC\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],

        ["\xDC\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],
        ["\xDC\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],

        ["\xDC\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],
        ["\xDC\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],

        ["\xDC\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],
        ["\xDC\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],

        ["\xDC\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],
        ["\xDC\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],

        ["\xDC\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],
        ["\xDC\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],

        ["\xDC\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],
        ["\xDC\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],

        ["\xDC\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],
        ["\xDC\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],

        ["\xDD\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],
        ["\xDD\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],

        ["\xDD\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],
        ["\xDD\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],

        ["\xDD\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],
        ["\xDD\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],

        ["\xDD\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],
        ["\xDD\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],

        ["\xDD\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],
        ["\xDD\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],

        ["\xDD\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],
        ["\xDD\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],

        ["\xDD\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],
        ["\xDD\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],

        ["\xDD\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],
        ["\xDD\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],

        ["\xDD\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],
        ["\xDD\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],

        ["\xDD\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],
        ["\xDD\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],

        ["\xDD\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],
        ["\xDD\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],

        ["\xDD\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],
        ["\xDD\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],

        ["\xDD\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],
        ["\xDD\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],

        ["\xDD\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],
        ["\xDD\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],

        ["\xDD\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],
        ["\xDD\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],

        ["\xDD\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],
        ["\xDD\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],

        ["\xDD\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],
        ["\xDD\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],

        ["\xDD\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],
        ["\xDD\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],

        ["\xDD\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],
        ["\xDD\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],

        ["\xDD\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],
        ["\xDD\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],

        ["\xDD\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],
        ["\xDD\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],

        ["\xDD\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\xDD\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],

        ["\xDD\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],
        ["\xDD\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],

        ["\xDD\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],
        ["\xDD\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],

        ["\xDD\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],
        ["\xDD\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],

        ["\xDD\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],
        ["\xDD\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],

        ["\xDD\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],
        ["\xDD\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],

        ["\xDD\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],
        ["\xDD\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],

        ["\xDD\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\xDD\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],

        ["\xDD\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],
        ["\xDD\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],

        ["\xDD\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],
        ["\xDD\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],

        ["\xDD\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],
        ["\xDD\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],

        ["\xDD\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],
        ["\xDD\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],

        ["\xDD\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],
        ["\xDD\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],

        ["\xDD\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],
        ["\xDD\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],

        ["\xDD\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],
        ["\xDD\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],

        ["\xDD\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],
        ["\xDD\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],

        ["\xDD\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],
        ["\xDD\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],

        ["\xDD\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],
        ["\xDD\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],

        ["\xDD\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],
        ["\xDD\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],

        ["\xDD\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],
        ["\xDD\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],

        ["\xDD\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],
        ["\xDD\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],

        ["\xDD\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],
        ["\xDD\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],

        ["\xDD\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],
        ["\xDD\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],

        ["\xDD\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],
        ["\xDD\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],

        ["\xDD\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],
        ["\xDD\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],

        ["\xDD\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],
        ["\xDD\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],

        ["\xDD\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\xDD\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],

        ["\xDD\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],
        ["\xDD\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],

        ["\xDD\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\xDD\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],

        ["\xDD\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],
        ["\xDD\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],

        ["\xDD\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],
        ["\xDD\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],

        ["\xDD\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\xDD\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],

        ["\xDD\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],
        ["\xDD\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],

        ["\xDD\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],
        ["\xDD\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],

        ["\xDD\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],
        ["\xDD\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],

        ["\xDD\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],
        ["\xDD\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],

        ["\xDD\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\xDD\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],

        ["\xDD\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\xDD\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],

        ["\xDD\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\xDD\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],

        ["\xDD\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\xDD\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],

        ["\xDD\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],
        ["\xDD\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],

        ["\xDD\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],
        ["\xDD\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],

        ["\xDD\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],
        ["\xDD\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],

        ["\xDD\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],
        ["\xDD\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],

        ["\xDD\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],
        ["\xDD\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],

        ["\xDD\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],
        ["\xDD\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],

        ["\xDD\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],
        ["\xDD\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],

        ["\xDD\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],
        ["\xDD\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],

        ["\xDD\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],
        ["\xDD\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],

        ["\xDD\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],
        ["\xDD\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],

        ["\xDD\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],
        ["\xDD\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],

        ["\xDD\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],
        ["\xDD\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],

        ["\xDD\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],
        ["\xDD\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],

        ["\xDD\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],
        ["\xDD\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],

        ["\xDD\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],
        ["\xDD\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],

        ["\xDD\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],
        ["\xDD\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],

        ["\xDD\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],
        ["\xDD\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],

        ["\xDD\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],
        ["\xDD\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],

        ["\xDD\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],
        ["\xDD\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],

        ["\xDD\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],
        ["\xDD\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],

        ["\xDD\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],
        ["\xDD\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],

        ["\xDD\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],
        ["\xDD\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],

        ["\xDD\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],
        ["\xDD\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],

        ["\xDD\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],
        ["\xDD\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],

        ["\xDD\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],
        ["\xDD\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],

        ["\xDD\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],
        ["\xDD\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],

        ["\xDD\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],
        ["\xDD\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],

        ["\xDD\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],
        ["\xDD\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],

        ["\xDD\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],
        ["\xDD\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],

        ["\xDD\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],
        ["\xDD\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],

        ["\xDD\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],
        ["\xDD\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],

        ["\xDD\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],
        ["\xDD\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],

        ["\xDD\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],
        ["\xDD\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],

        ["\xDE\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],
        ["\xDE\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],

        ["\xDE\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],
        ["\xDE\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],

        ["\xDE\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],
        ["\xDE\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],

        ["\xDE\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],
        ["\xDE\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],

        ["\xDE\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],
        ["\xDE\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],

        ["\xDE\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],
        ["\xDE\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],

        ["\xDE\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],
        ["\xDE\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],

        ["\xDE\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],
        ["\xDE\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],

        ["\xDE\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],
        ["\xDE\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],

        ["\xDE\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],
        ["\xDE\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],

        ["\xDE\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],
        ["\xDE\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],

        ["\xDE\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],
        ["\xDE\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],

        ["\xDE\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],
        ["\xDE\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],

        ["\xDE\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],
        ["\xDE\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],

        ["\xDE\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],
        ["\xDE\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],

        ["\xDE\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],
        ["\xDE\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],

        ["\xDE\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],
        ["\xDE\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],

        ["\xDE\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],
        ["\xDE\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],

        ["\xDE\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],
        ["\xDE\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],

        ["\xDE\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],
        ["\xDE\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],

        ["\xDE\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\xDE\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],

        ["\xDE\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],
        ["\xDE\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],

        ["\xDE\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],
        ["\xDE\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],

        ["\xDE\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],
        ["\xDE\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],

        ["\xDE\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xC5\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],

        ["\xDE\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],
        ["\xDE\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],

        ["\xDE\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],
        ["\xDE\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],

        ["\xDE\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],
        ["\xDE\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],

        ["\xDE\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],
        ["\xDE\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],

        ["\xDE\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],
        ["\xDE\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],

        ["\xDE\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],
        ["\xDE\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],

        ["\xDE\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],
        ["\xDE\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],

        ["\xDE\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],
        ["\xDE\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],

        ["\xDE\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],
        ["\xDE\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],

        ["\xDE\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],
        ["\xDE\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],

        ["\xDE\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],
        ["\xDE\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],

        ["\xDE\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],
        ["\xDE\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],

        ["\xDE\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],
        ["\xDE\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],

        ["\xDE\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],
        ["\xDE\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],

        ["\xDE\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],
        ["\xDE\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],

        ["\xDE\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],
        ["\xDE\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],

        ["\xDE\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],
        ["\xDE\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],

        ["\xDE\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\xDE\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],

        ["\xDE\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],
        ["\xDE\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],

        ["\xDE\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],
        ["\xDE\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],

        ["\xDE\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],
        ["\xDE\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],

        ["\xDE\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],
        ["\xDE\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],

        ["\xDE\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],
        ["\xDE\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],

        ["\xDE\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],
        ["\xDE\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],

        ["\xDE\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],
        ["\xDE\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],

        ["\xDE\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],
        ["\xDE\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],

        ["\xDE\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],
        ["\xDE\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],

        ["\xDE\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],
        ["\xDE\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],

        ["\xDE\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],
        ["\xDE\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],

        ["\xDE\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],
        ["\xDE\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],

        ["\xDE\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\xDE\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],

        ["\xDE\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],
        ["\xDE\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],

        ["\xDE\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],
        ["\xDE\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],

        ["\xDE\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],
        ["\xDE\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],

        ["\xDE\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],
        ["\xDE\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],

        ["\xDE\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],
        ["\xDE\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],

        ["\xDE\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],
        ["\xDE\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],

        ["\xDE\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],
        ["\xDE\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],

        ["\xDE\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],
        ["\xDE\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],

        ["\xDE\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],
        ["\xDE\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],

        ["\xDE\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],
        ["\xDE\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],

        ["\xDE\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],
        ["\xDE\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],

        ["\xDE\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],
        ["\xDE\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],

        ["\xDE\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],
        ["\xDE\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],

        ["\xDE\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],
        ["\xDE\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],

        ["\xDE\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],
        ["\xDE\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],

        ["\xDE\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],
        ["\xDE\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],

        ["\xDE\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],
        ["\xDE\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],

        ["\xDE\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],
        ["\xDE\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],

        ["\xDE\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],
        ["\xDE\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],

        ["\xDE\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],
        ["\xDE\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],

        ["\xDE\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],
        ["\xDE\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],

        ["\xDE\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],
        ["\xDE\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],

        ["\xDE\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],
        ["\xDE\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],

        ["\xDE\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],
        ["\xDE\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],

        ["\xDE\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],
        ["\xDE\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],

        ["\xDE\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],
        ["\xDE\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],

        ["\xDE\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\xDE\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],

        ["\xDE\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\xDE\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],

        ["\xDE\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xB4\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],

        ["\xDE\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],
        ["\xDE\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],

        ["\xDE\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],
        ["\xDE\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],

        ["\xDE\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],
        ["\xDE\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],

        ["\xDE\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],
        ["\xDE\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],

        ["\xDE\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],
        ["\xDE\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],

        ["\xDE\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],
        ["\xDE\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],

        ["\xDE\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],
        ["\xDE\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],

        ["\xDE\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],
        ["\xDE\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],

        ["\xDE\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],
        ["\xDE\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],

        ["\xDF\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],
        ["\xDF\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],

        ["\xDF\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],
        ["\xDF\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],

        ["\xDF\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],
        ["\xDF\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],

        ["\xDF\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],
        ["\xDF\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],

        ["\xDF\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],
        ["\xDF\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],

        ["\xDF\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],
        ["\xDF\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],

        ["\xDF\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],
        ["\xDF\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],

        ["\xDF\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],
        ["\xDF\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],

        ["\xDF\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],
        ["\xDF\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],

        ["\xDF\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],
        ["\xDF\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],

        ["\xDF\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],
        ["\xDF\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],

        ["\xDF\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],
        ["\xDF\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],

        ["\xDF\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],
        ["\xDF\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],

        ["\xDF\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],
        ["\xDF\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],

        ["\xDF\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],
        ["\xDF\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],

        ["\xDF\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],
        ["\xDF\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],

        ["\xDF\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\xDF\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],

        ["\xDF\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\xDF\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],

        ["\xDF\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\xDF\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],

        ["\xDF\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\xDF\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],

        ["\xDF\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],
        ["\xDF\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],

        ["\xDF\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],
        ["\xDF\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],

        ["\xDF\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],
        ["\xDF\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],

        ["\xDF\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],
        ["\xDF\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],

        ["\xDF\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],
        ["\xDF\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],

        ["\xDF\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],
        ["\xDF\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],

        ["\xDF\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],
        ["\xDF\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],

        ["\xDF\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],
        ["\xDF\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],

        ["\xDF\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],
        ["\xDF\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],

        ["\xDF\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],
        ["\xDF\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],

        ["\xDF\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],
        ["\xDF\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],

        ["\xDF\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],
        ["\xDF\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],

        ["\xDF\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],
        ["\xDF\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],

        ["\xDF\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],
        ["\xDF\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],

        ["\xDF\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],
        ["\xDF\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],

        ["\xDF\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],
        ["\xDF\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],

        ["\xDF\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],
        ["\xDF\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],

        ["\xDF\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],
        ["\xDF\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],

        ["\xDF\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],
        ["\xDF\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],

        ["\xDF\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],
        ["\xDF\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],

        ["\xDF\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],
        ["\xDF\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],

        ["\xDF\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],
        ["\xDF\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],

        ["\xDF\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],
        ["\xDF\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],

        ["\xDF\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],
        ["\xDF\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],

        ["\xDF\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\xDF\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],

        ["\xDF\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],
        ["\xDF\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],

        ["\xDF\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\xDF\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],

        ["\xDF\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],
        ["\xDF\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],

        ["\xDF\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],
        ["\xDF\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],

        ["\xDF\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],
        ["\xDF\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],

        ["\xDF\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],
        ["\xDF\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],

        ["\xDF\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],
        ["\xDF\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],

        ["\xDF\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],
        ["\xDF\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],

        ["\xDF\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],
        ["\xDF\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],

        ["\xDF\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\xDF\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],

        ["\xDF\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],
        ["\xDF\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],

        ["\xDF\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],
        ["\xDF\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],

        ["\xDF\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],
        ["\xDF\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],

        ["\xDF\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],
        ["\xDF\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],

        ["\xDF\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],
        ["\xDF\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],

        ["\xDF\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],
        ["\xDF\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],

        ["\xDF\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],
        ["\xDF\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],

        ["\xDF\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],
        ["\xDF\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],

        ["\xDF\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\xDF\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],

        ["\xDF\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],
        ["\xDF\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],

        ["\xDF\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],
        ["\xDF\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],

        ["\xDF\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],
        ["\xDF\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],

        ["\xDF\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],
        ["\xDF\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],

        ["\xDF\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\xDF\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],

        ["\xDF\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\xDF\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],

        ["\xDF\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],
        ["\xDF\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],

        ["\xDF\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\xDF\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],

        ["\xDF\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],
        ["\xDF\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],

        ["\xDF\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],
        ["\xDF\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],

        ["\xDF\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],
        ["\xDF\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],

        ["\xDF\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],
        ["\xDF\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],

        ["\xDF\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],
        ["\xDF\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],

        ["\xDF\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],
        ["\xDF\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],

        ["\xDF\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],
        ["\xDF\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],

        ["\xDF\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],
        ["\xDF\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],

        ["\xDF\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],
        ["\xDF\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],

        ["\xDF\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],
        ["\xDF\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],

        ["\xDF\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],
        ["\xDF\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],

        ["\xDF\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],
        ["\xDF\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],

        ["\xDF\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],
        ["\xDF\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],

        ["\xDF\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],
        ["\xDF\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],

        ["\xDF\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],
        ["\xDF\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],

        ["\xDF\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],
        ["\xDF\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],

        ["\xDF\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],
        ["\xDF\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],

        ["\xDF\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\xDF\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],

        ["\xDF\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],
        ["\xDF\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],

        ["\xDF\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\xDF\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],

        ["\xDF\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],
        ["\xDF\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],

        ["\xDF\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],
        ["\xDF\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],

        ["\xE0\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE0\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],

        ["\xE0\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE0\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],

        ["\xE0\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE0\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],

        ["\xE0\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE0\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],

        ["\xE0\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE0\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],

        ["\xE0\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE0\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],

        ["\xE0\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE0\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],

        ["\xE0\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE0\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],

        ["\xE0\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE0\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],

        ["\xE0\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE0\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],

        ["\xE0\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE0\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],

        ["\xE0\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],

        ["\xE0\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE0\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],

        ["\xE0\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE0\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],

        ["\xE0\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE0\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],

        ["\xE0\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE0\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],

        ["\xE0\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE0\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],

        ["\xE0\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE0\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],

        ["\xE0\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE0\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],

        ["\xE0\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE0\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],

        ["\xE0\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE0\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],

        ["\xE0\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE0\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],

        ["\xE0\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE0\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],

        ["\xE0\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE0\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],

        ["\xE0\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE0\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],

        ["\xE0\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE0\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],

        ["\xE0\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE0\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],

        ["\xE0\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE0\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],

        ["\xE0\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE0\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],

        ["\xE0\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE0\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],

        ["\xE0\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE0\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],

        ["\xE0\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE0\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],

        ["\xE0\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],

        ["\xE0\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],

        ["\xE0\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],

        ["\xE0\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],

        ["\xE0\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],

        ["\xE0\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],

        ["\xE0\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],

        ["\xE0\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],

        ["\xE0\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],

        ["\xE0\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE0\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],

        ["\xE0\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE0\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],

        ["\xE0\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE0\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],

        ["\xE0\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE0\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],

        ["\xE0\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE0\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],

        ["\xE0\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE0\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],

        ["\xE0\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE0\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],

        ["\xE0\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],

        ["\xE0\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],

        ["\xE0\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],

        ["\xE0\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],

        ["\xE0\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],

        ["\xE0\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],

        ["\xE0\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],

        ["\xE0\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],

        ["\xE0\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],

        ["\xE0\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE0\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],

        ["\xE0\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE0\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],

        ["\xE0\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE0\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],

        ["\xE0\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE0\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],

        ["\xE0\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE0\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],

        ["\xE0\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE0\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],

        ["\xE0\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],

        ["\xE0\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE0\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],

        ["\xE0\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],

        ["\xE0\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],

        ["\xE0\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],

        ["\xE0\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],

        ["\xE0\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],

        ["\xE0\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],

        ["\xE0\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],

        ["\xE0\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],

        ["\xE0\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE0\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],

        ["\xE0\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE0\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],

        ["\xE0\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE0\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],

        ["\xE0\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE0\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],

        ["\xE0\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE0\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],

        ["\xE0\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE0\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],

        ["\xE0\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],

        ["\xE0\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],

        ["\xE0\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],

        ["\xE0\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE0\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],

        ["\xE0\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],

        ["\xE0\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],

        ["\xE0\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],
        ["\x59\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],

        ["\xE0\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],

        ["\xE0\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],

        ["\xE0\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],

        ["\xE0\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE0\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],

        ["\xE0\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE0\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],

        ["\xE0\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE0\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],

        ["\xE0\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\xE0\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],

        ["\xE0\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\xE0\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],

        ["\xE1\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE1\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],

        ["\xE1\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE1\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],

        ["\xE1\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE1\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],

        ["\xE1\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE1\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],

        ["\xE1\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE1\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],

        ["\xE1\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE1\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],

        ["\xE1\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE1\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],

        ["\xE1\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE1\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],

        ["\xE1\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE1\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],

        ["\xE1\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE1\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],

        ["\xE1\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE1\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],

        ["\xE1\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE1\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],

        ["\xE1\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE1\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],

        ["\xE1\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE1\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],

        ["\xE1\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE1\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],

        ["\xE1\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE1\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],

        ["\xE1\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE1\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],

        ["\xE1\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE1\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],

        ["\xE1\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE1\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],

        ["\xE1\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE1\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],

        ["\xE1\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE1\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],

        ["\xE1\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE1\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],

        ["\xE1\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE1\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],

        ["\xE1\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE1\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],

        ["\xE1\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE1\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],

        ["\xE1\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE1\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],

        ["\xE1\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE1\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],

        ["\xE1\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE1\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],

        ["\xE1\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE1\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],

        ["\xE1\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE1\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],

        ["\xE1\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE1\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],

        ["\xE1\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE1\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],

        ["\xE1\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE1\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],

        ["\xE1\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE1\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],

        ["\xE1\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE1\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],

        ["\xE1\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE1\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],

        ["\xE1\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE1\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],

        ["\xE1\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE1\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],

        ["\xE1\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE1\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],

        ["\xE1\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE1\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],

        ["\xE1\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE1\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],

        ["\xE1\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE1\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],

        ["\xE1\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE1\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],

        ["\xE1\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE1\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],

        ["\xE1\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE1\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],

        ["\xE1\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE1\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],

        ["\xE1\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE1\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],

        ["\xE1\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE1\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],

        ["\xE1\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE1\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],

        ["\xE1\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE1\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],

        ["\xE1\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE1\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],

        ["\xE1\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE1\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],

        ["\xE1\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE1\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],

        ["\xE1\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE1\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],

        ["\xE1\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE1\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],

        ["\xE1\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE1\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],

        ["\xE1\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE1\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],

        ["\xE1\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE1\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],

        ["\xE1\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE1\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],

        ["\xE1\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE1\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],

        ["\xE1\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE1\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],

        ["\xE1\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE1\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],

        ["\xE1\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE1\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],

        ["\xE1\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE1\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],

        ["\xE1\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE1\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],

        ["\xE1\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE1\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],

        ["\xE1\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE1\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],

        ["\xE1\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE1\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],

        ["\xE1\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE1\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],

        ["\xE1\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE1\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],

        ["\xE1\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE1\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],

        ["\xE1\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE1\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],

        ["\xE1\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE1\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],

        ["\xE1\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE1\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],

        ["\xE1\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE1\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],

        ["\xE1\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE1\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],

        ["\xE1\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE1\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],

        ["\xE1\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE1\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],

        ["\xE1\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE1\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],

        ["\xE1\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE1\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],

        ["\xE1\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE1\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],

        ["\xE1\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE1\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],

        ["\xE1\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE1\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],

        ["\xE1\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE1\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],

        ["\xE1\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE1\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],

        ["\xE1\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE1\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],

        ["\xE1\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE1\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],

        ["\xE1\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE1\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],

        ["\xE1\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE1\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],

        ["\xE1\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE1\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],

        ["\xE1\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE1\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],

        ["\xE1\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE1\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],

        ["\xE1\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],
        ["\xE1\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],

        ["\xE1\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],
        ["\xE1\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],

        ["\xE2\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE2\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],

        ["\xE2\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE2\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],

        ["\xE2\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE2\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],

        ["\xE2\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE2\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],

        ["\xE2\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE2\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],

        ["\xE2\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE2\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],

        ["\xE2\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE2\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],

        ["\xE2\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE2\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],

        ["\xE2\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE2\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],

        ["\xE2\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE2\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],

        ["\xE2\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE2\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],

        ["\xE2\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE2\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],

        ["\xE2\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE2\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],

        ["\xE2\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE2\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],

        ["\xE2\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE2\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],

        ["\xE2\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE2\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],

        ["\xE2\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE2\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],

        ["\xE2\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE2\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],

        ["\xE2\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE2\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],

        ["\xE2\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE2\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],

        ["\xE2\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE2\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],

        ["\xE2\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE2\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],

        ["\xE2\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE2\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],

        ["\xE2\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE2\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],

        ["\xE2\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE2\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],

        ["\xE2\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE2\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],

        ["\xE2\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE2\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],

        ["\xE2\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE2\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],

        ["\xE2\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE2\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],

        ["\xE2\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE2\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],

        ["\xE2\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE2\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],

        ["\xE2\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE2\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],

        ["\xE2\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE2\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],

        ["\xE2\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE2\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],

        ["\xE2\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE2\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],

        ["\xE2\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE2\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],

        ["\xE2\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE2\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],

        ["\xE2\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE2\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],

        ["\xE2\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE2\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],

        ["\xE2\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE2\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],

        ["\xE2\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE2\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],

        ["\xE2\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE2\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],

        ["\xE2\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE2\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],

        ["\xE2\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE2\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],

        ["\xE2\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE2\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],

        ["\xE2\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE2\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],

        ["\xE2\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE2\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],

        ["\xE2\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE2\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],

        ["\xE2\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE2\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],

        ["\xE2\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE2\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],

        ["\xE2\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE2\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],

        ["\xE2\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE2\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],

        ["\xE2\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE2\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],

        ["\xE2\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE2\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],

        ["\xE2\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE2\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],

        ["\xE2\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE2\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],

        ["\xE2\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE2\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],

        ["\xE2\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE2\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],

        ["\xE2\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE2\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],

        ["\xE2\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE2\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],

        ["\xE2\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE2\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],

        ["\xE2\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE2\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],

        ["\xE2\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE2\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],

        ["\xE2\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],

        ["\xE2\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE2\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],

        ["\xE2\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],

        ["\xE2\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],

        ["\xE2\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],

        ["\xE2\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],

        ["\xE2\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],

        ["\xE2\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],

        ["\xE2\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],
        ["\xB9\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],

        ["\xE2\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],

        ["\xE2\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xC5\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],

        ["\xE2\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE2\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],

        ["\xE2\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE2\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],

        ["\xE2\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE2\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],

        ["\xE2\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE2\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],

        ["\xE2\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE2\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],

        ["\xE2\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],

        ["\xE2\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],

        ["\xE2\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],

        ["\xE2\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],

        ["\xE2\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],

        ["\xE2\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],

        ["\xE2\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],

        ["\xE2\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],

        ["\xE2\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],

        ["\xE2\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE2\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],

        ["\xE2\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE2\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],

        ["\xE2\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE2\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],

        ["\xE2\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE2\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],

        ["\xE2\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\xE2\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],

        ["\xE2\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\xE2\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],

        ["\xE3\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE3\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],

        ["\xE3\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE3\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],

        ["\xE3\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE3\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],

        ["\xE3\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE3\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],

        ["\xE3\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE3\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],

        ["\xE3\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE3\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],

        ["\xE3\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE3\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],

        ["\xE3\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE3\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],

        ["\xE3\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE3\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],

        ["\xE3\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE3\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],

        ["\xE3\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE3\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],

        ["\xE3\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE3\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],

        ["\xE3\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE3\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],

        ["\xE3\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE3\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],

        ["\xE3\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE3\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],

        ["\xE3\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE3\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],

        ["\xE3\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE3\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],

        ["\xE3\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE3\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],

        ["\xE3\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE3\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],

        ["\xE3\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE3\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],

        ["\xE3\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE3\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],

        ["\xE3\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE3\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],

        ["\xE3\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE3\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],

        ["\xE3\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE3\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],

        ["\xE3\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE3\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],

        ["\xE3\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE3\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],

        ["\xE3\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE3\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],

        ["\xE3\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE3\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],

        ["\xE3\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE3\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],

        ["\xE3\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE3\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],

        ["\xE3\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE3\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],

        ["\xE3\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE3\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],

        ["\xE3\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE3\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],

        ["\xE3\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE3\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],

        ["\xE3\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE3\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],

        ["\xE3\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE3\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],

        ["\xE3\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE3\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],

        ["\xE3\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE3\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],

        ["\xE3\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE3\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],

        ["\xE3\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE3\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],

        ["\xE3\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE3\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],

        ["\xE3\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE3\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],

        ["\xE3\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE3\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],

        ["\xE3\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE3\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],

        ["\xE3\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE3\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],

        ["\xE3\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE3\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],

        ["\xE3\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE3\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],

        ["\xE3\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE3\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],

        ["\xE3\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE3\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],

        ["\xE3\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE3\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],

        ["\xE3\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE3\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],

        ["\xE3\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE3\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],

        ["\xE3\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE3\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],

        ["\xE3\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE3\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],

        ["\xE3\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE3\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],

        ["\xE3\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE3\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],

        ["\xE3\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE3\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],

        ["\xE3\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE3\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],

        ["\xE3\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE3\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],

        ["\xE3\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE3\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],

        ["\xE3\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE3\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],

        ["\xE3\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xB3\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],

        ["\xE3\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE3\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],

        ["\xE3\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE3\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],

        ["\xE3\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE3\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],

        ["\xE3\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE3\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],

        ["\xE3\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE3\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],

        ["\xE3\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE3\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],

        ["\xE3\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE3\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],

        ["\xE3\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE3\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],

        ["\xE3\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE3\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],

        ["\xE3\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE3\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],

        ["\xE3\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE3\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],

        ["\xE3\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE3\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],

        ["\xE3\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE3\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],

        ["\xE3\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE3\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],

        ["\xE3\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE3\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],

        ["\xE3\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE3\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],

        ["\xE3\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE3\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],

        ["\xE3\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE3\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],

        ["\xE3\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE3\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],

        ["\xE3\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE3\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],

        ["\xE3\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],

        ["\xE3\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE3\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],

        ["\xE3\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE3\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],

        ["\xE3\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE3\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],

        ["\xE3\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE3\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],

        ["\xE3\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE3\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],

        ["\xE3\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE3\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],

        ["\xE3\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE3\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],

        ["\xE3\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE3\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],

        ["\xE3\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE3\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],

        ["\xE3\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],
        ["\xE3\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],

        ["\xE3\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],
        ["\xE3\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],

        ["\xE4\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE4\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],

        ["\xE4\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE4\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],

        ["\xE4\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE4\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],

        ["\xE4\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE4\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],

        ["\xE4\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE4\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],

        ["\xE4\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE4\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],

        ["\xE4\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE4\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],

        ["\xE4\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE4\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],

        ["\xE4\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE4\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],

        ["\xE4\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE4\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],

        ["\xE4\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE4\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],

        ["\xE4\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE4\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],

        ["\xE4\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE4\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],

        ["\xE4\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE4\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],

        ["\xE4\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE4\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],

        ["\xE4\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE4\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],

        ["\xE4\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE4\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],

        ["\xE4\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE4\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],

        ["\xE4\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE4\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],

        ["\xE4\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE4\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],

        ["\xE4\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE4\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],

        ["\xE4\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE4\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],

        ["\xE4\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE4\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],

        ["\xE4\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE4\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],

        ["\xE4\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE4\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],

        ["\xE4\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE4\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],

        ["\xE4\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE4\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],

        ["\xE4\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE4\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],

        ["\xE4\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE4\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],

        ["\xE4\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE4\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],

        ["\xE4\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE4\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],

        ["\xE4\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE4\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],

        ["\xE4\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE4\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],

        ["\xE4\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE4\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],

        ["\xE4\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE4\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],

        ["\xE4\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE4\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],

        ["\xE4\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE4\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],

        ["\xE4\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],
        ["\xCF\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],

        ["\xE4\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE4\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],

        ["\xE4\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE4\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],

        ["\xE4\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE4\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],

        ["\xE4\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE4\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],

        ["\xE4\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE4\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],

        ["\xE4\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE4\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],

        ["\xE4\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE4\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],

        ["\xE4\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE4\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],

        ["\xE4\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE4\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],

        ["\xE4\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE4\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],

        ["\xE4\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE4\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],

        ["\xE4\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE4\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],

        ["\xE4\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE4\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],

        ["\xE4\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE4\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],

        ["\xE4\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE4\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],

        ["\xE4\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE4\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],

        ["\xE4\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE4\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],

        ["\xE4\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE4\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],

        ["\xE4\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE4\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],

        ["\xE4\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE4\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],

        ["\xE4\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE4\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],

        ["\xE4\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE4\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],

        ["\xE4\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE4\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],

        ["\xE4\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE4\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],

        ["\xE4\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE4\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],

        ["\xE4\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE4\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],

        ["\xE4\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE4\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],

        ["\xE4\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE4\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],

        ["\xE4\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE4\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],

        ["\xE4\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE4\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],

        ["\xE4\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE4\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],

        ["\xE4\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE4\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],

        ["\xE4\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE4\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],

        ["\xE4\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE4\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],

        ["\xE4\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE4\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],

        ["\xE4\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE4\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],

        ["\xE4\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE4\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],

        ["\xE4\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE4\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],

        ["\xE4\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE4\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],

        ["\xE4\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE4\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],

        ["\xE4\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE4\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],

        ["\xE4\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE4\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],

        ["\xE4\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE4\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],

        ["\xE4\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE4\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],

        ["\xE4\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE4\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],

        ["\xE4\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE4\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],

        ["\xE4\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE4\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],

        ["\xE4\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE4\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],

        ["\xE4\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE4\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],

        ["\xE4\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE4\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],

        ["\xE4\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE4\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],

        ["\xE4\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE4\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],

        ["\xE4\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE4\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],

        ["\xE4\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE4\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],

        ["\xE4\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],
        ["\xE4\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],

        ["\xE4\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],
        ["\xE4\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],

        ["\xE5\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE5\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],

        ["\xE5\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE5\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],

        ["\xE5\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE5\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],

        ["\xE5\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE5\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],

        ["\xE5\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE5\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],

        ["\xE5\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE5\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],

        ["\xE5\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE5\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],

        ["\xE5\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE5\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],

        ["\xE5\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE5\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],

        ["\xE5\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE5\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],

        ["\xE5\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE5\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],

        ["\xE5\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE5\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],

        ["\xE5\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE5\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],

        ["\xE5\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE5\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],

        ["\xE5\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE5\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],

        ["\xE5\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE5\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],

        ["\xE5\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE5\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],

        ["\xE5\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE5\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],

        ["\xE5\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE5\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],

        ["\xE5\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE5\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],

        ["\xE5\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE5\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],

        ["\xE5\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE5\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],

        ["\xE5\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE5\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],

        ["\xE5\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE5\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],

        ["\xE5\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE5\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],

        ["\xE5\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE5\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],

        ["\xE5\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE5\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],

        ["\xE5\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE5\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],

        ["\xE5\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE5\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],

        ["\xE5\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE5\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],

        ["\xE5\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE5\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],

        ["\xE5\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE5\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],

        ["\xE5\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE5\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],

        ["\xE5\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE5\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],

        ["\xE5\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE5\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],

        ["\xE5\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE5\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],

        ["\xE5\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE5\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],

        ["\xE5\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE5\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],

        ["\xE5\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE5\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],

        ["\xE5\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE5\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],

        ["\xE5\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE5\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],

        ["\xE5\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE5\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],

        ["\xE5\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE5\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],

        ["\xE5\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE5\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],

        ["\xE5\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE5\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],

        ["\xE5\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE5\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],

        ["\xE5\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE5\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],

        ["\xE5\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE5\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],

        ["\xE5\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE5\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],

        ["\xE5\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE5\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],

        ["\xE5\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE5\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],

        ["\xE5\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE5\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],

        ["\xE5\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE5\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],

        ["\xE5\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE5\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],

        ["\xE5\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE5\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],

        ["\xE5\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE5\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],

        ["\xE5\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE5\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],

        ["\xE5\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE5\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],

        ["\xE5\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE5\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],

        ["\xE5\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE5\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],

        ["\xE5\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE5\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],

        ["\xE5\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE5\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],

        ["\xE5\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE5\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],

        ["\xE5\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE5\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],

        ["\xE5\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE5\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],

        ["\xE5\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE5\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],

        ["\xE5\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE5\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],

        ["\xE5\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE5\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],

        ["\xE5\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE5\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],

        ["\xE5\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE5\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],

        ["\xE5\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE5\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],

        ["\xE5\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE5\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],

        ["\xE5\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE5\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],

        ["\xE5\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE5\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],

        ["\xE5\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE5\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],

        ["\xE5\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE5\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],

        ["\xE5\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE5\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],

        ["\xE5\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE5\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],

        ["\xE5\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE5\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],

        ["\xE5\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE5\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],

        ["\xE5\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE5\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],

        ["\xE5\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE5\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],

        ["\xE5\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE5\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],

        ["\xE5\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE5\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],

        ["\xE5\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE5\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],

        ["\xE5\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE5\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],

        ["\xE5\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE5\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],

        ["\xE5\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE5\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],

        ["\xE5\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE5\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],

        ["\xE5\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE5\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],

        ["\xE5\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE5\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],

        ["\xE5\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE5\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],

        ["\xE5\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],
        ["\xE5\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],

        ["\xE5\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\xE5\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],

        ["\xE6\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE6\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],

        ["\xE6\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE6\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],

        ["\xE6\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE6\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],

        ["\xE6\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE6\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],

        ["\xE6\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE6\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],

        ["\xE6\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE6\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],

        ["\xE6\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE6\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],

        ["\xE6\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE6\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],

        ["\xE6\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE6\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],

        ["\xE6\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE6\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],

        ["\xE6\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE6\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],

        ["\xE6\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE6\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],

        ["\xE6\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE6\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],

        ["\xE6\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE6\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],

        ["\xE6\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE6\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],

        ["\xE6\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE6\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],

        ["\xE6\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE6\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],

        ["\xE6\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE6\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],

        ["\xE6\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE6\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],

        ["\xE6\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE6\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],

        ["\xE6\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE6\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],

        ["\xE6\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE6\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],

        ["\xE6\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE6\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],

        ["\xE6\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE6\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],

        ["\xE6\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE6\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],

        ["\xE6\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE6\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],

        ["\xE6\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE6\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],

        ["\xE6\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE6\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],

        ["\xE6\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE6\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],

        ["\xE6\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE6\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],

        ["\xE6\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE6\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],

        ["\xE6\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],

        ["\xE6\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE6\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],

        ["\xE6\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE6\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],

        ["\xE6\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE6\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],

        ["\xE6\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE6\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],

        ["\xE6\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE6\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],

        ["\xE6\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE6\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],

        ["\xE6\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE6\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],

        ["\xE6\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE6\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],

        ["\xE6\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE6\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],

        ["\xE6\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE6\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],

        ["\xE6\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE6\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],

        ["\xE6\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE6\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],

        ["\xE6\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE6\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],

        ["\xE6\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE6\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],

        ["\xE6\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE6\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],

        ["\xE6\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE6\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],

        ["\xE6\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE6\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],

        ["\xE6\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE6\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],

        ["\xE6\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE6\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],

        ["\xE6\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE6\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],

        ["\xE6\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE6\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],

        ["\xE6\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE6\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],

        ["\xE6\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE6\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],

        ["\xE6\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE6\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],

        ["\xE6\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE6\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],

        ["\xE6\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE6\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],

        ["\xE6\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE6\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],

        ["\xE6\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE6\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],

        ["\xE6\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE6\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],

        ["\xE6\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE6\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],

        ["\xE6\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE6\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],

        ["\xE6\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE6\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],

        ["\xE6\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE6\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],

        ["\xE6\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE6\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],

        ["\xE6\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE6\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],

        ["\xE6\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE6\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],

        ["\xE6\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE6\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],

        ["\xE6\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE6\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],

        ["\xE6\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE6\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],

        ["\xE6\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE6\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],

        ["\xE6\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE6\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],

        ["\xE6\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE6\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],

        ["\xE6\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE6\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],

        ["\xE6\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE6\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],

        ["\xE6\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE6\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],

        ["\xE6\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE6\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],

        ["\xE6\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE6\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],

        ["\xE6\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE6\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],

        ["\xE6\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE6\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],

        ["\xE6\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE6\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],

        ["\xE6\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE6\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],

        ["\xE6\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE6\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],

        ["\xE6\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE6\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],

        ["\xE6\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],

        ["\xE6\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE6\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],

        ["\xE6\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE6\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],

        ["\xE6\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE6\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],

        ["\xE6\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE6\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],

        ["\xE6\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE6\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],

        ["\xE6\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE6\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],

        ["\xE6\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],
        ["\xE6\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],

        ["\xE6\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],
        ["\xE6\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],

        ["\xE7\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE7\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],

        ["\xE7\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE7\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],

        ["\xE7\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE7\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],

        ["\xE7\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE7\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],

        ["\xE7\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE7\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],

        ["\xE7\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE7\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],

        ["\xE7\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE7\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],

        ["\xE7\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE7\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],

        ["\xE7\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE7\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],

        ["\xE7\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE7\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],

        ["\xE7\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE7\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],

        ["\xE7\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE7\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],

        ["\xE7\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE7\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],

        ["\xE7\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE7\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],

        ["\xE7\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE7\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],

        ["\xE7\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE7\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],

        ["\xE7\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE7\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],

        ["\xE7\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE7\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],

        ["\xE7\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE7\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],

        ["\xE7\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE7\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],

        ["\xE7\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE7\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],

        ["\xE7\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE7\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],

        ["\xE7\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE7\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],

        ["\xE7\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE7\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],

        ["\xE7\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE7\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],

        ["\xE7\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE7\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],

        ["\xE7\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE7\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],

        ["\xE7\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE7\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],

        ["\xE7\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE7\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],

        ["\xE7\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE7\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],

        ["\xE7\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE7\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],

        ["\xE7\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE7\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],

        ["\xE7\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE7\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],

        ["\xE7\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE7\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],

        ["\xE7\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE7\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],

        ["\xE7\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE7\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],

        ["\xE7\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE7\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],

        ["\xE7\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE7\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],

        ["\xE7\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE7\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],

        ["\xE7\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE7\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],

        ["\xE7\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE7\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],

        ["\xE7\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE7\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],

        ["\xE7\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE7\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],

        ["\xE7\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE7\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],

        ["\xE7\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE7\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],

        ["\xE7\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE7\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],

        ["\xE7\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE7\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],

        ["\xE7\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE7\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],

        ["\xE7\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE7\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],

        ["\xE7\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE7\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],

        ["\xE7\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE7\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],

        ["\xE7\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE7\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],

        ["\xE7\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE7\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],

        ["\xE7\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE7\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],

        ["\xE7\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE7\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],

        ["\xE7\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE7\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],

        ["\xE7\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE7\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],

        ["\xE7\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE7\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],

        ["\xE7\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE7\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],

        ["\xE7\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE7\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],

        ["\xE7\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE7\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],

        ["\xE7\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE7\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],

        ["\xE7\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE7\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],

        ["\xE7\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE7\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],

        ["\xE7\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE7\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],

        ["\xE7\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE7\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],

        ["\xE7\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE7\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],

        ["\xE7\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE7\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],

        ["\xE7\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE7\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],

        ["\xE7\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE7\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],

        ["\xE7\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE7\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],

        ["\xE7\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE7\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],

        ["\xE7\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE7\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],

        ["\xE7\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE7\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],

        ["\xE7\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE7\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],

        ["\xE7\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE7\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],

        ["\xE7\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE7\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],

        ["\xE7\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE7\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],

        ["\xE7\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE7\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],

        ["\xE7\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE7\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],

        ["\xE7\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE7\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],

        ["\xE7\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE7\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],

        ["\xE7\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE7\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],

        ["\xE7\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE7\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],

        ["\xE7\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE7\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],

        ["\xE7\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE7\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],

        ["\xE7\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE7\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],

        ["\xE7\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE7\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],

        ["\xE7\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE7\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],

        ["\xE7\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE7\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],

        ["\xE7\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE7\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],

        ["\xE7\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE7\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],

        ["\xE7\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],
        ["\xE7\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],

        ["\xE7\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],
        ["\xE7\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],

        ["\xE8\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE8\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],

        ["\xE8\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE8\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],

        ["\xE8\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE8\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],

        ["\xE8\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE8\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],

        ["\xE8\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE8\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],

        ["\xE8\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE8\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],

        ["\xE8\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE8\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],

        ["\xE8\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE8\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],

        ["\xE8\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE8\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],

        ["\xE8\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],

        ["\xE8\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],

        ["\xE8\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE8\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],

        ["\xE8\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE8\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],

        ["\xE8\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],

        ["\xE8\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE8\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],

        ["\xE8\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE8\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],

        ["\xE8\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE8\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],

        ["\xE8\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],

        ["\xE8\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE8\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],

        ["\xE8\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],

        ["\xE8\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE8\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],

        ["\xE8\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE8\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],

        ["\xE8\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE8\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],

        ["\xE8\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],

        ["\xE8\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE8\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],

        ["\xE8\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE8\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],

        ["\xE8\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE8\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],

        ["\xE8\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE8\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],

        ["\xE8\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE8\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],

        ["\xE8\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE8\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],

        ["\xE8\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE8\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],

        ["\xE8\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE8\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],

        ["\xE8\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE8\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],

        ["\xE8\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE8\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],

        ["\xE8\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE8\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],

        ["\xE8\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE8\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],

        ["\xE8\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE8\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],

        ["\xE8\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE8\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],

        ["\xE8\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE8\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],

        ["\xE8\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE8\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],

        ["\xE8\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE8\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],

        ["\xE8\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE8\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],

        ["\xE8\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE8\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],

        ["\xE8\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE8\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],

        ["\xE8\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE8\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],

        ["\xE8\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE8\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],

        ["\xE8\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE8\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],

        ["\xE8\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE8\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],

        ["\xE8\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE8\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],

        ["\xE8\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE8\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],

        ["\xE8\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE8\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],

        ["\xE8\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE8\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],

        ["\xE8\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE8\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],

        ["\xE8\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE8\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],

        ["\xE8\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE8\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],

        ["\xE8\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],

        ["\xE8\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],

        ["\xE8\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],

        ["\xE8\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],

        ["\xE8\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE8\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],

        ["\xE8\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE8\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],

        ["\xE8\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE8\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],

        ["\xE8\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE8\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],

        ["\xE8\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE8\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],

        ["\xE8\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE8\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],

        ["\xE8\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE8\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],

        ["\xE8\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE8\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],

        ["\xE8\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE8\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],

        ["\xE8\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE8\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],

        ["\xE8\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE8\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],

        ["\xE8\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE8\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],

        ["\xE8\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE8\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],

        ["\xE8\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE8\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],

        ["\xE8\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE8\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],

        ["\xE8\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],

        ["\xE8\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],

        ["\xE8\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE8\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],

        ["\xE8\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE8\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],

        ["\xE8\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE8\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],

        ["\xE8\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE8\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],

        ["\xE8\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE8\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],

        ["\xE8\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE8\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],

        ["\xE8\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE8\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],

        ["\xE8\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE8\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],

        ["\xE8\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE8\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],

        ["\xE8\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE8\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],

        ["\xE8\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE8\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],

        ["\xE8\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE8\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],

        ["\xE8\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],

        ["\xE8\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],

        ["\xE8\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],

        ["\xE8\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE8\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],

        ["\xE8\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],
        ["\xE8\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],

        ["\xE8\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\xE8\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],

        ["\xE9\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],

        ["\xE9\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xBC\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],

        ["\xE9\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE9\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],

        ["\xE9\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE9\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],

        ["\xE9\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE9\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],

        ["\xE9\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE9\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],

        ["\xE9\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE9\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],

        ["\xE9\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE9\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],

        ["\xE9\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE9\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],

        ["\xE9\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE9\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],

        ["\xE9\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],

        ["\xE9\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE9\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],

        ["\xE9\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE9\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],

        ["\xE9\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],
        ["\xCC\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],

        ["\xE9\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE9\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],

        ["\xE9\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],

        ["\xE9\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE9\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],

        ["\xE9\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE9\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],

        ["\xE9\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE9\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],

        ["\xE9\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE9\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],

        ["\xE9\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE9\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],

        ["\xE9\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE9\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],

        ["\xE9\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE9\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],

        ["\xE9\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE9\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],

        ["\xE9\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE9\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],

        ["\xE9\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE9\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],

        ["\xE9\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE9\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],

        ["\xE9\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE9\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],

        ["\xE9\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE9\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],

        ["\xE9\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE9\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],

        ["\xE9\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE9\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],

        ["\xE9\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],

        ["\xE9\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],

        ["\xE9\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],

        ["\xE9\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],

        ["\xE9\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],

        ["\xE9\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],

        ["\xE9\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],

        ["\xE9\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],

        ["\xE9\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],

        ["\xE9\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE9\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],

        ["\xE9\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xE9\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],

        ["\xE9\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xE9\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],

        ["\xE9\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xE9\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],

        ["\xE9\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xE9\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],

        ["\xE9\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xE9\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],

        ["\xE9\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xE9\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],

        ["\xE9\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE9\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],

        ["\xE9\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE9\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],

        ["\xE9\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE9\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],

        ["\xE9\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE9\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],

        ["\xE9\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE9\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],

        ["\xE9\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE9\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],

        ["\xE9\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE9\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],

        ["\xE9\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE9\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],

        ["\xE9\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE9\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],

        ["\xE9\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE9\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],

        ["\xE9\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\xB3\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],

        ["\xE9\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xE9\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],

        ["\xE9\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xE9\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],

        ["\xE9\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xE9\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],

        ["\xE9\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xE9\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],

        ["\xE9\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xE9\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],

        ["\xE9\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE9\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],

        ["\xE9\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xE9\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],

        ["\xE9\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE9\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],

        ["\xE9\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE9\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],

        ["\xE9\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE9\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],

        ["\xE9\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE9\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],

        ["\xE9\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE9\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],

        ["\xE9\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE9\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],

        ["\xE9\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE9\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],

        ["\xE9\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE9\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],

        ["\xE9\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xE9\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],

        ["\xE9\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xE9\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],

        ["\xE9\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xE9\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],

        ["\xE9\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xE9\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],

        ["\xE9\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xE9\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],

        ["\xE9\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xE9\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],

        ["\xE9\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE9\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],

        ["\xE9\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE9\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],

        ["\xE9\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE9\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],

        ["\xE9\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],

        ["\xE9\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE9\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],

        ["\xE9\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE9\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],

        ["\xE9\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE9\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],

        ["\xE9\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE9\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],

        ["\xE9\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE9\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],

        ["\xE9\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE9\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],

        ["\xE9\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xE9\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],

        ["\xE9\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xE9\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],

        ["\xE9\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xE9\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],

        ["\xE9\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],
        ["\xE9\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],

        ["\xE9\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],
        ["\xE9\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],

        ["\xEA\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xEA\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],

        ["\xEA\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xEA\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],

        ["\xEA\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xEA\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],

        ["\xEA\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xC7\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],

        ["\xEA\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\xEA\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],

        ["\xEA\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\xEA\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],

        ["\xEA\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\xEA\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],

        ["\xEA\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\xEA\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],

        ["\xEA\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\xEA\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],

        ["\xEA\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\xEA\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],

        ["\xEA\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\xEA\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],

        ["\xEA\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\xEA\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],

        ["\xEA\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\xEA\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],

        ["\xEA\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\xEA\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],

        ["\xEA\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\xEA\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],

        ["\xEA\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\xEA\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],

        ["\xEA\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\xEA\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],

        ["\xEA\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xEA\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],

        ["\xEA\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\xEA\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],

        ["\xEA\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\xEA\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],

        ["\xEA\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\xEA\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],

        ["\xEA\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\xEA\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],

        ["\xEA\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\xEA\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],

        ["\xEA\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\xEA\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],

        ["\xEA\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\xEA\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],

        ["\xEA\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\xEA\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],

        ["\xEA\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\xEA\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],

        ["\xEA\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\xEA\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],

        ["\xEA\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\xEA\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],

        ["\xEA\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\xEA\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],

        ["\xEA\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\xEA\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],

        ["\xEA\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\xEA\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],

        ["\xEA\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\xEA\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],

        ["\xEA\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\xEA\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],

        ["\xEA\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\xEA\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],

        ["\xEA\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\xEA\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],

        ["\xEA\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\xEA\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],

        ["\xEA\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\xEA\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],

        ["\xEA\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\xEA\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],

        ["\xEA\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\xEA\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],

        ["\xEA\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\xEA\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],

        ["\xEA\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\xEA\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],

        ["\xEA\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\xEA\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],

        ["\xEA\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\xEA\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],

        ["\xEA\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\xEA\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],

        ["\xEA\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\xEA\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],

        ["\xEA\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\xEA\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],

        ["\xEA\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\xEA\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],

        ["\xEA\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\xEA\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],

        ["\xEA\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\xEA\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],

        ["\xEA\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\xEA\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],

        ["\xEA\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\xEA\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],

        ["\xEA\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\xEA\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],

        ["\xEA\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\xEA\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],

        ["\xEA\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\xEA\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],

        ["\xEA\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\xEA\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],

        ["\xEA\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\xEA\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],

        ["\xEA\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\xEA\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],

        ["\xEA\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\xEA\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],

        ["\xEA\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\xEA\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],

        ["\xEA\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\xEA\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],

        ["\xEA\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\xEA\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],

        ["\xEA\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\xEA\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],

        ["\xEA\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\xEA\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],

        ["\xEA\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\xEA\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],

        ["\xEA\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\xEA\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],

        ["\xEA\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\xEA\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],

        ["\xEA\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xEA\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],

        ["\xEA\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\xEA\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],

        ["\xEA\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\xEA\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],

        ["\xEA\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\xEA\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],

        ["\xEA\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\xEA\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],

        ["\xEA\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\xEA\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],

        ["\xEA\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\xEA\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],

        ["\xEA\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\xEA\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],

        ["\xEA\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\xEA\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],

        ["\xEA\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\xEA\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],

        ["\xEA\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\xEA\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],

        ["\xEA\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\xEA\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],

        ["\xEA\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\xEA\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],

        ["\xEA\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\xEA\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],

        ["\xEA\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\xEA\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],

        ["\xEA\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\xEA\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],

        ["\xEA\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\xEA\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],

        ["\xEA\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\xEA\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],

        ["\xEA\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\xEA\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],

        ["\xEA\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\xEA\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],

        ["\xEA\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\xEA\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],

        ["\xEA\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\xEA\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],

        ["\xEA\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\xEA\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],

        ["\xEA\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\xEA\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],

        ["\xEA\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\xEA\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],

        ["\xEA\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],
        ["\xEA\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],

        ["\xEA\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],
        ["\xEA\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],

        ["\xEB\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\xEB\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],

        ["\xEB\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\xEB\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],

        ["\xEB\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\xEB\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],

        ["\xEB\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\xEB\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],

        ["\xEB\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\xEB\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],

        ["\xEB\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\xEB\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],

        ["\xEB\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\xEB\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],

        ["\xEB\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\xEB\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],

        ["\xEB\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\xEB\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],

        ["\xEB\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\xEB\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],

        ["\xEB\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\xEB\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],

        ["\xEB\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\xEB\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],

        ["\xEB\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\xEB\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],

        ["\xEB\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\xEB\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],

        ["\xEB\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\xEB\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],

        ["\xEB\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\xEB\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],

        ["\xEB\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\xEB\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],

        ["\xEB\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\xEB\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],

        ["\xEB\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\xEB\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],

        ["\xEB\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\xEB\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],

        ["\xEB\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\xEB\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],

        ["\xEB\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\xEB\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],

        ["\xEB\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\xEB\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],

        ["\xEB\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\xEB\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],

        ["\xEB\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\xEB\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],

        ["\xEB\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\xEB\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],

        ["\xEB\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\xEB\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],

        ["\xEB\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\xEB\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],

        ["\xEB\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\xEB\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],

        ["\xEB\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\xEB\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],

        ["\xEB\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\xEB\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],

        ["\xEB\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\xEB\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],

        ["\xEB\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\xEB\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],

        ["\xEB\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\xEB\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],

        ["\xEB\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\xEB\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],

        ["\xEB\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\xEB\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],

        ["\xEB\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\xEB\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],

        ["\xEB\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\xEB\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],

        ["\xEB\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\xEB\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],

        ["\xEB\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\xEB\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],

        ["\xEB\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\xEB\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],

        ["\xEB\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\xEB\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],

        ["\xEB\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\xEB\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],

        ["\xEB\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\xEB\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],

        ["\xEB\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\xEB\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],

        ["\xEB\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\xEB\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],

        ["\xEB\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\xEB\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],

        ["\xEB\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\xEB\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],

        ["\xEB\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\xEB\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],

        ["\xEB\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\xEB\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],

        ["\xEB\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\xEB\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],

        ["\xEB\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\xEB\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],

        ["\xEB\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\xEB\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],

        ["\xEB\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\xEB\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],

        ["\xEB\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\xEB\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],

        ["\xEB\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\xEB\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],

        ["\xEB\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\xEB\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],

        ["\xEB\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\xEB\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],

        ["\xEB\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\xEB\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],

        ["\xEB\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xEB\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],

        ["\xEB\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xB4\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],

        ["\xEB\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\xEB\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],

        ["\xEB\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\xEB\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],

        ["\xEB\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\xEB\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],

        ["\xEB\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\xEB\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],

        ["\xEB\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\xEB\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],

        ["\xEB\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\xEB\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],

        ["\xEB\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\xEB\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],

        ["\xEB\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\xEB\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],

        ["\xEB\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\xEB\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],

        ["\xEB\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\xEB\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],

        ["\xEB\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\xEB\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],

        ["\xEB\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\xEB\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],

        ["\xEB\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\xEB\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],

        ["\xEB\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\xEB\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],

        ["\xEB\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\xEB\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],

        ["\xEB\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\xEB\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],

        ["\xEB\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\xEB\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],

        ["\xEB\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\xEB\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],

        ["\xEB\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\xEB\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],

        ["\xEB\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\xEB\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],

        ["\xEB\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\xEB\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],

        ["\xEB\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\xEB\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],

        ["\xEB\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\xEB\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],

        ["\xEB\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\xEB\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],

        ["\xEB\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\xEB\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],

        ["\xEB\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\xEB\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],

        ["\xEB\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\xEB\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],

        ["\xEB\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\xEB\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],

        ["\xEB\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\xEB\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],

        ["\xEB\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\xEB\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],

        ["\xEB\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\xEB\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],

        ["\xEB\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],
        ["\xEB\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],

        ["\xEB\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],
        ["\xEB\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],

        ["\xEC\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\xEC\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],

        ["\xEC\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\xEC\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],

        ["\xEC\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\xEC\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],

        ["\xEC\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\xEC\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],

        ["\xEC\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\xEC\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],

        ["\xEC\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\xEC\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],

        ["\xEC\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\xEC\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],

        ["\xEC\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\xEC\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],

        ["\xEC\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\xEC\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],

        ["\xEC\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xEC\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],

        ["\xEC\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xEC\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],

        ["\xEC\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\xEC\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],

        ["\xEC\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\xEC\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],

        ["\xEC\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\xEC\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],

        ["\xEC\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\xEC\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],

        ["\xEC\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\xEC\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],

        ["\xEC\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\xEC\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],

        ["\xEC\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\xEC\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],

        ["\xEC\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\xEC\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],

        ["\xEC\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\xEC\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],

        ["\xEC\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\xEC\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],

        ["\xEC\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\xEC\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],

        ["\xEC\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\xEC\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],

        ["\xEC\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\xEC\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],

        ["\xEC\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\xEC\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],

        ["\xEC\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\xEC\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],

        ["\xEC\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\xEC\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],

        ["\xEC\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\xEC\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],

        ["\xEC\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\xEC\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],

        ["\xEC\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\xEC\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],

        ["\xEC\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\xEC\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],

        ["\xEC\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\xEC\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],

        ["\xEC\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\xEC\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],

        ["\xEC\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\xEC\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],

        ["\xEC\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\xEC\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],

        ["\xEC\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\xEC\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],

        ["\xEC\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\xEC\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],

        ["\xEC\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\xEC\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],

        ["\xEC\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\xEC\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],

        ["\xEC\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\xEC\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],

        ["\xEC\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\xEC\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],

        ["\xEC\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\xEC\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],

        ["\xEC\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\xEC\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],

        ["\xEC\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xEC\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],

        ["\xEC\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],
        ["\xC1\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],

        ["\xEC\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\xEC\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],

        ["\xEC\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\xEC\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],

        ["\xEC\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\xEC\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],

        ["\xEC\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\xEC\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],

        ["\xEC\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\xEC\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],

        ["\xEC\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\xEC\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],

        ["\xEC\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\xEC\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],

        ["\xEC\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\xEC\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],

        ["\xEC\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\xEC\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],

        ["\xEC\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\xEC\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],

        ["\xEC\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\xEC\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],

        ["\xEC\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\xEC\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],

        ["\xEC\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\xEC\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],

        ["\xEC\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\xEC\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],

        ["\xEC\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\xEC\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],

        ["\xEC\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\xEC\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],

        ["\xEC\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\xEC\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],

        ["\xEC\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\xEC\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],

        ["\xEC\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\xEC\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],

        ["\xEC\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\xEC\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],

        ["\xEC\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\xEC\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],

        ["\xEC\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\xEC\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],

        ["\xEC\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\xEC\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],

        ["\xEC\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\xEC\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],

        ["\xEC\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\xEC\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],

        ["\xEC\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\xEC\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],

        ["\xEC\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\xEC\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],

        ["\xEC\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\xEC\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],

        ["\xEC\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\xEC\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],

        ["\xEC\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\xEC\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],

        ["\xEC\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\xEC\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],

        ["\xEC\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\xEC\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],

        ["\xEC\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\xEC\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],

        ["\xEC\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\xEC\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],

        ["\xEC\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\xEC\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],

        ["\xEC\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\xEC\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],

        ["\xEC\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\xEC\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],

        ["\xEC\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\xEC\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],

        ["\xEC\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\xEC\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],

        ["\xEC\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\xEC\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],

        ["\xEC\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\xEC\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],

        ["\xEC\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\xEC\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],

        ["\xEC\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\xEC\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],

        ["\xEC\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\xEC\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],

        ["\xEC\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\xEC\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],

        ["\xEC\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\xEC\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],

        ["\xEC\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\xEC\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],

        ["\xEC\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],
        ["\xEC\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],

        ["\xEC\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],
        ["\xEC\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],

        ["\xED\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\xED\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],

        ["\xED\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\xED\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],

        ["\xED\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\xED\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],

        ["\xED\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\xED\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],

        ["\xED\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\xED\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],

        ["\xED\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\xED\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],

        ["\xED\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\xED\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],

        ["\xED\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\xED\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],

        ["\xED\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\xED\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],

        ["\xED\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\xED\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],

        ["\xED\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\xED\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],

        ["\xED\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\xED\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],

        ["\xED\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\xED\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],

        ["\xED\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\xED\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],

        ["\xED\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\xED\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],

        ["\xED\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\xED\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],

        ["\xED\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\xED\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],

        ["\xED\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\xED\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],

        ["\xED\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\xED\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],

        ["\xED\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\xED\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],

        ["\xED\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\xED\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],

        ["\xED\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\xED\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],

        ["\xED\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\xED\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],

        ["\xED\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\xED\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],

        ["\xED\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\xED\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],

        ["\xED\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\xED\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],

        ["\xED\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\xED\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],

        ["\xED\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\xED\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],

        ["\xED\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\xED\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],

        ["\xED\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\xED\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],

        ["\xED\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\xED\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],

        ["\xED\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\xED\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],

        ["\xED\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\xED\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],

        ["\xED\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\xED\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],

        ["\xED\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\xED\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],

        ["\xED\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\xED\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],

        ["\xED\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\xED\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],

        ["\xED\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\xED\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],

        ["\xED\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\xED\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],

        ["\xED\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\xED\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],

        ["\xED\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\xED\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],

        ["\xED\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\xED\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],

        ["\xED\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\xED\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],

        ["\xED\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\xED\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],

        ["\xED\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\xED\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],

        ["\xED\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\xED\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],

        ["\xED\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\xED\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],

        ["\xED\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\xED\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],

        ["\xED\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\xED\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],

        ["\xED\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\xED\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],

        ["\xED\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\xED\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],

        ["\xED\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\xED\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],

        ["\xED\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\xED\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],

        ["\xED\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\xED\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],

        ["\xED\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\xED\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],

        ["\xED\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\xED\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],

        ["\xED\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\xED\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],

        ["\xED\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\xED\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],

        ["\xED\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\xED\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],

        ["\xED\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\xED\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],

        ["\xED\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\xED\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],

        ["\xED\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\xED\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],

        ["\xED\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\xED\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],

        ["\xED\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\xED\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],

        ["\xED\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\xED\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],

        ["\xED\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\xED\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],

        ["\xED\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\xED\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],

        ["\xED\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\xED\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],

        ["\xED\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\xED\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],

        ["\xED\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\xED\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],

        ["\xED\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\xED\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],

        ["\xED\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\xED\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],

        ["\xED\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\xED\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],

        ["\xED\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\xED\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],

        ["\xED\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\xED\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],

        ["\xED\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\xED\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],

        ["\xED\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xED\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],

        ["\xED\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xC6\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],

        ["\xED\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\xED\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],

        ["\xED\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\xED\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],

        ["\xED\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\xED\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],

        ["\xED\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\xED\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],

        ["\xED\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\xED\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],

        ["\xED\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\xED\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],

        ["\xED\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\xED\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],

        ["\xED\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\xED\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],

        ["\xED\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\xED\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],

        ["\xED\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\xED\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],

        ["\xED\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\xED\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],

        ["\xED\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\xED\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],

        ["\xED\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\xED\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],

        ["\xED\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\xED\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],

        ["\xED\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],
        ["\xED\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],

        ["\xED\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],
        ["\xED\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],

        ["\xEE\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\xEE\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],

        ["\xEE\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\xEE\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],

        ["\xEE\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\xEE\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],

        ["\xEE\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\xEE\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],

        ["\xEE\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\xEE\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],

        ["\xEE\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\xEE\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],

        ["\xEE\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\xEE\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],

        ["\xEE\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\xEE\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],

        ["\xEE\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\xEE\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],

        ["\xEE\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\xEE\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],

        ["\xEE\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\xEE\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],

        ["\xEE\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\xEE\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],

        ["\xEE\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\xEE\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],

        ["\xEE\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\xEE\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],

        ["\xEE\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\xEE\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],

        ["\xEE\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\xEE\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],

        ["\xEE\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\xEE\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],

        ["\xEE\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\xEE\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],

        ["\xEE\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\xEE\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],

        ["\xEE\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\xEE\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],

        ["\xEE\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\xEE\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],

        ["\xEE\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\xEE\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],

        ["\xEE\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\xEE\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],

        ["\xEE\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\xEE\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],

        ["\xEE\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\xEE\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],

        ["\xEE\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\xEE\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],

        ["\xEE\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\xEE\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],

        ["\xEE\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\xEE\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],

        ["\xEE\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\xEE\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],

        ["\xEE\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\xEE\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],

        ["\xEE\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\xEE\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],

        ["\xEE\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\xEE\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],

        ["\xEE\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\xEE\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],

        ["\xEE\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\xEE\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],

        ["\xEE\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\xEE\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],

        ["\xEE\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\xEE\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],

        ["\xEE\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\xEE\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],

        ["\xEE\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\xEE\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],

        ["\xEE\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\xEE\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],

        ["\xEE\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\xEE\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],

        ["\xEE\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\xEE\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],

        ["\xEE\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\xEE\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],

        ["\xEE\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\xEE\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],

        ["\xEE\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\xEE\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],

        ["\xEE\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\xEE\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],

        ["\xEE\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\xEE\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],

        ["\xEE\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\xEE\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],

        ["\xEE\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\xEE\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],

        ["\xEE\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\xEE\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],

        ["\xEE\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\xEE\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],

        ["\xEE\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\xEE\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],

        ["\xEE\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\xEE\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],

        ["\xEE\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\xEE\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],

        ["\xEE\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\xEE\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],

        ["\xEE\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\xEE\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],

        ["\xEE\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\xEE\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],

        ["\xEE\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\xEE\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],

        ["\xEE\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\xEE\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],

        ["\xEE\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\xEE\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],

        ["\xEE\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\xEE\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],

        ["\xEE\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\xEE\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],

        ["\xEE\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\xEE\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],

        ["\xEE\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\xEE\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],

        ["\xEE\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\xEE\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],

        ["\xEE\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\xEE\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],

        ["\xEE\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\xEE\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],

        ["\xEE\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\xEE\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],

        ["\xEE\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\xEE\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],

        ["\xEE\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\xEE\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],

        ["\xEE\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\xEE\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],

        ["\xEE\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\xEE\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],

        ["\xEE\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\xEE\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],

        ["\xEE\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\xEE\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],

        ["\xEE\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\xEE\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],

        ["\xEE\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\xEE\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],

        ["\xEE\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\xEE\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],

        ["\xEE\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\xEE\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],

        ["\xEE\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\xEE\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],

        ["\xEE\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\xEE\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],

        ["\xEE\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\xEE\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],

        ["\xEE\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\xEE\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],

        ["\xEE\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\xEE\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],

        ["\xEE\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\xEE\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],

        ["\xEE\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\xEE\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],

        ["\xEE\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\xEE\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],

        ["\xEE\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\xEE\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],

        ["\xEE\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\xEE\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],

        ["\xEE\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\xEE\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],

        ["\xEE\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\xEE\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],

        ["\xEE\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\xEE\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],

        ["\xEE\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\xEE\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],

        ["\xEE\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\xEE\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],

        ["\xEE\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],
        ["\xEE\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],

        ["\xEE\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],
        ["\xEE\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],

        ["\xEF\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\xEF\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],

        ["\xEF\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\xEF\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],

        ["\xEF\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\xEF\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],

        ["\xEF\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\xEF\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],

        ["\xEF\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\xEF\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],

        ["\xEF\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\xEF\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],

        ["\xEF\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\xEF\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],

        ["\xEF\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\xEF\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],

        ["\xEF\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\xEF\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],

        ["\xEF\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\xEF\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],

        ["\xEF\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\xEF\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],

        ["\xEF\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\xEF\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],

        ["\xEF\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\xEF\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],

        ["\xEF\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\xEF\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],

        ["\xEF\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\xEF\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],

        ["\xEF\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\xEF\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],

        ["\xEF\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\xEF\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],

        ["\xEF\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\xEF\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],

        ["\xEF\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\xEF\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],

        ["\xEF\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\xEF\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],

        ["\xEF\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\xEF\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],

        ["\xEF\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\xEF\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],

        ["\xEF\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\xEF\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],

        ["\xEF\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\xEF\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],

        ["\xEF\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\xEF\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],

        ["\xEF\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\xEF\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],

        ["\xEF\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\xEF\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],

        ["\xEF\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\xEF\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],

        ["\xEF\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\xEF\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],

        ["\xEF\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\xEF\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],

        ["\xEF\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\xEF\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],

        ["\xEF\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\xEF\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],

        ["\xEF\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\xEF\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],

        ["\xEF\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\xEF\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],

        ["\xEF\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\xEF\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],

        ["\xEF\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\xEF\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],

        ["\xEF\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\xEF\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],

        ["\xEF\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\xEF\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],

        ["\xEF\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\xEF\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],

        ["\xEF\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\xEF\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],

        ["\xEF\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\xEF\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],

        ["\xEF\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\xEF\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],

        ["\xEF\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\xEF\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],

        ["\xEF\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\xEF\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],

        ["\xEF\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\xEF\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],

        ["\xEF\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\xEF\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],

        ["\xEF\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\xEF\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],

        ["\xEF\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\xEF\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],

        ["\xEF\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\xEF\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],

        ["\xEF\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\xEF\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],

        ["\xEF\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\xEF\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],

        ["\xEF\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\xEF\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],

        ["\xEF\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\xEF\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],

        ["\xEF\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\xEF\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],

        ["\xEF\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\xEF\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],

        ["\xEF\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\xEF\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],

        ["\xEF\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\xEF\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],

        ["\xEF\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\xEF\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],

        ["\xEF\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\xEF\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],

        ["\xEF\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\xEF\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],

        ["\xEF\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\xEF\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],

        ["\xEF\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\xEF\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],

        ["\xEF\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\xEF\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],

        ["\xEF\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\xEF\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],

        ["\xEF\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\xEF\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],

        ["\xEF\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\xEF\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],

        ["\xEF\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\xEF\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],

        ["\xEF\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\xEF\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],

        ["\xEF\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\xEF\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],

        ["\xEF\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\xEF\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],

        ["\xEF\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\xEF\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],

        ["\xEF\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\xEF\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],

        ["\xEF\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\xEF\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],

        ["\xEF\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\xEF\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],

        ["\xEF\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\xEF\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],

        ["\xEF\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\xEF\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],

        ["\xEF\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\xEF\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],

        ["\xEF\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\xEF\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],

        ["\xEF\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\xEF\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],

        ["\xEF\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\xEF\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],

        ["\xEF\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\xEF\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],

        ["\xEF\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\xEF\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],

        ["\xEF\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\xEF\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],

        ["\xEF\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\xEF\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],

        ["\xEF\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\xEF\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],

        ["\xEF\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\xEF\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],

        ["\xEF\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\xEF\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],

        ["\xEF\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\xEF\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],

        ["\xEF\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\xEF\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],

        ["\xEF\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\xEF\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],

        ["\xEF\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\xEF\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],

        ["\xEF\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\xEF\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],

        ["\xEF\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],
        ["\xEF\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],

        ["\xEF\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],
        ["\xEF\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],

        ["\xF0\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xF0\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],

        ["\xF0\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\xF0\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],

        ["\xF0\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\xF0\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],

        ["\xF0\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\xF0\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],

        ["\xF0\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\xF0\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],

        ["\xF0\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\xF0\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],

        ["\xF0\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\xF0\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],

        ["\xF0\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\xF0\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],

        ["\xF0\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\xF0\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],

        ["\xF0\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\xF0\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],

        ["\xF0\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xF0\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],

        ["\xF0\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\xF0\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],

        ["\xF0\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\xF0\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],

        ["\xF0\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\xF0\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],

        ["\xF0\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\xF0\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],

        ["\xF0\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xF0\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],

        ["\xF0\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\xF0\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],

        ["\xF0\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\xF0\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],

        ["\xF0\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\xF0\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],

        ["\xF0\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\xF0\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],

        ["\xF0\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\xF0\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],

        ["\xF0\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\xF0\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],

        ["\xF0\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\xF0\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],

        ["\xF0\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\xF0\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],

        ["\xF0\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\xF0\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],

        ["\xF0\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\xF0\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],

        ["\xF0\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\xF0\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],

        ["\xF0\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\xF0\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],

        ["\xF0\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\xF0\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],

        ["\xF0\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\xF0\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],

        ["\xF0\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\xF0\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],

        ["\xF0\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xF0\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],

        ["\xF0\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xF0\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],

        ["\xF0\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xF0\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],

        ["\xF0\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xF0\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],

        ["\xF0\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xF0\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],

        ["\xF0\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xF0\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],

        ["\xF0\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xF0\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],

        ["\xF0\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xF0\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],

        ["\xF0\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xF0\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],

        ["\xF0\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xF0\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],

        ["\xF0\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\xF0\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],

        ["\xF0\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\xF0\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],

        ["\xF0\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\xF0\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],

        ["\xF0\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\xF0\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],

        ["\xF0\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\xF0\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],

        ["\xF0\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\xF0\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],

        ["\xF0\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xF0\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],

        ["\xF0\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xF0\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],

        ["\xF0\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xF0\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],

        ["\xF0\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xF0\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],

        ["\xF0\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xF0\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],

        ["\xF0\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xF0\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],

        ["\xF0\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xF0\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],

        ["\xF0\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],
        ["\xBF\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],

        ["\xF0\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xF0\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],

        ["\xF0\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xF0\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],

        ["\xF0\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\xF0\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],

        ["\xF0\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\xF0\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],

        ["\xF0\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\xF0\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],

        ["\xF0\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\xF0\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],

        ["\xF0\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\xF0\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],

        ["\xF0\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\xF0\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],

        ["\xF0\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xF0\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],

        ["\xF0\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\xF0\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],

        ["\xF0\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xF0\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],

        ["\xF0\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xF0\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],

        ["\xF0\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xF0\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],

        ["\xF0\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xF0\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],

        ["\xF0\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xF0\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],

        ["\xF0\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xF0\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],

        ["\xF0\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xF0\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],

        ["\xF0\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xF0\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],

        ["\xF0\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\xF0\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],

        ["\xF0\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\xF0\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],

        ["\xF0\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\xF0\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],

        ["\xF0\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\xF0\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],

        ["\xF0\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\xF0\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],

        ["\xF0\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\xF0\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],

        ["\xF0\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xF0\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],

        ["\xF0\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xF0\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],

        ["\xF0\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xF0\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],

        ["\xF0\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xF0\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],

        ["\xF0\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],
        ["\xB7\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],

        ["\xF0\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xF0\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],

        ["\xF0\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xF0\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],

        ["\xF0\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xF0\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],

        ["\xF0\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xF0\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],

        ["\xF0\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xF0\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],

        ["\xF0\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\xF0\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],

        ["\xF0\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\xF0\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],

        ["\xF0\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\xF0\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],

        ["\xF0\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],
        ["\xF0\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],

        ["\xF0\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],
        ["\xF0\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],

        ["\xF1\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xF1\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],

        ["\xF1\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\xF1\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],

        ["\xF1\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\xF1\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],

        ["\xF1\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\xF1\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],

        ["\xF1\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\xF1\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],

        ["\xF1\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\xF1\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],

        ["\xF1\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\xF1\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],

        ["\xF1\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\xF1\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],

        ["\xF1\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\xF1\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],

        ["\xF1\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\xF1\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],

        ["\xF1\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xF1\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],

        ["\xF1\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\xF1\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],

        ["\xF1\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\xF1\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],

        ["\xF1\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\xF1\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],

        ["\xF1\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\xF1\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],

        ["\xF1\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xF1\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],

        ["\xF1\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\xF1\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],

        ["\xF1\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\xF1\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],

        ["\xF1\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\xF1\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],

        ["\xF1\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\xF1\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],

        ["\xF1\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\xF1\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],

        ["\xF1\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\xF1\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],

        ["\xF1\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\xF1\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],

        ["\xF1\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\xF1\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],

        ["\xF1\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\xF1\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],

        ["\xF1\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\xF1\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],

        ["\xF1\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\xF1\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],

        ["\xF1\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\xF1\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],

        ["\xF1\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\xF1\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],

        ["\xF1\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\xF1\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],

        ["\xF1\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\xF1\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],

        ["\xF1\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xF1\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],

        ["\xF1\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xF1\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],

        ["\xF1\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xF1\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],

        ["\xF1\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xF1\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],

        ["\xF1\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xF1\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],

        ["\xF1\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xF1\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],

        ["\xF1\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xF1\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],

        ["\xF1\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xF1\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],

        ["\xF1\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xF1\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],

        ["\xF1\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xF1\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],

        ["\xF1\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\xF1\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],

        ["\xF1\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\xF1\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],

        ["\xF1\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\xF1\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],

        ["\xF1\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\xF1\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],

        ["\xF1\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\xF1\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],

        ["\xF1\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\xF1\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],

        ["\xF1\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xF1\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],

        ["\xF1\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xF1\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],

        ["\xF1\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xF1\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],

        ["\xF1\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xF1\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],

        ["\xF1\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xF1\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],

        ["\xF1\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xF1\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],

        ["\xF1\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xF1\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],

        ["\xF1\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xF1\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],

        ["\xF1\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xF1\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],

        ["\xF1\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xF1\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],

        ["\xF1\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\xF1\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],

        ["\xF1\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\xF1\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],

        ["\xF1\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\xF1\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],

        ["\xF1\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\xF1\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],

        ["\xF1\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\xF1\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],

        ["\xF1\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\xF1\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],

        ["\xF1\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xF1\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],

        ["\xF1\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\xF1\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],

        ["\xF1\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xF1\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],

        ["\xF1\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xF1\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],

        ["\xF1\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xF1\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],

        ["\xF1\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xF1\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],

        ["\xF1\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xF1\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],

        ["\xF1\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xF1\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],

        ["\xF1\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xF1\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],

        ["\xF1\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xF1\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],

        ["\xF1\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\xF1\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],

        ["\xF1\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\xF1\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],

        ["\xF1\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\xF1\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],

        ["\xF1\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\xF1\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],

        ["\xF1\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\xF1\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],

        ["\xF1\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\xF1\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],

        ["\xF1\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xF1\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],

        ["\xF1\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xF1\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],

        ["\xF1\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xF1\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],

        ["\xF1\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xF1\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],

        ["\xF1\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xF1\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],

        ["\xF1\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xF1\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],

        ["\xF1\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xF1\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],

        ["\xF1\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xF1\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],

        ["\xF1\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xF1\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],

        ["\xF1\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xF1\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],

        ["\xF1\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\xF1\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],

        ["\xF1\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\xF1\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],

        ["\xF1\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\xF1\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],

        ["\xF1\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],
        ["\xF1\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],

        ["\xF1\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],
        ["\xF1\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],

        ["\xF2\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xF2\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],

        ["\xF2\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\xF2\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],

        ["\xF2\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\xF2\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],

        ["\xF2\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\xF2\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],

        ["\xF2\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\xF2\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],

        ["\xF2\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\xF2\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],

        ["\xF2\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\xF2\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],

        ["\xF2\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\xF2\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],

        ["\xF2\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\xF2\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],

        ["\xF2\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\xF2\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],

        ["\xF2\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xF2\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],

        ["\xF2\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\xF2\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],

        ["\xF2\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\xF2\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],

        ["\xF2\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\xF2\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],

        ["\xF2\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\xF2\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],

        ["\xF2\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xF2\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],

        ["\xF2\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\xF2\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],

        ["\xF2\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\xF2\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],

        ["\xF2\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\xF2\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],

        ["\xF2\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\xF2\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],

        ["\xF2\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\xF2\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],

        ["\xF2\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\xF2\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],

        ["\xF2\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\xF2\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],

        ["\xF2\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\xF2\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],

        ["\xF2\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\xF2\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],

        ["\xF2\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\xF2\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],

        ["\xF2\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\xF2\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],

        ["\xF2\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\xF2\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],

        ["\xF2\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\xF2\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],

        ["\xF2\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\xF2\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],

        ["\xF2\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\xF2\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],

        ["\xF2\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xF2\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],

        ["\xF2\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xF2\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],

        ["\xF2\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xF2\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],

        ["\xF2\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xF2\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],

        ["\xF2\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xF2\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],

        ["\xF2\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xF2\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],

        ["\xF2\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xF2\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],

        ["\xF2\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xF2\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],

        ["\xF2\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xF2\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],

        ["\xF2\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xF2\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],

        ["\xF2\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\xF2\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],

        ["\xF2\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\xF2\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],

        ["\xF2\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\xF2\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],

        ["\xF2\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],
        ["\xB0\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],

        ["\xF2\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\xF2\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],

        ["\xF2\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\xF2\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],

        ["\xF2\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xF2\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],

        ["\xF2\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xF2\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],

        ["\xF2\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xF2\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],

        ["\xF2\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xF2\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],

        ["\xF2\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xF2\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],

        ["\xF2\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xF2\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],

        ["\xF2\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xF2\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],

        ["\xF2\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xF2\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],

        ["\xF2\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xF2\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],

        ["\xF2\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xF2\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],

        ["\xF2\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\xF2\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],

        ["\xF2\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\xF2\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],

        ["\xF2\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\xF2\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],

        ["\xF2\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\xF2\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],

        ["\xF2\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\xF2\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],

        ["\xF2\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\xF2\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],

        ["\xF2\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xF2\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],

        ["\xF2\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\xF2\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],

        ["\xF2\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xF2\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],

        ["\xF2\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xF2\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],

        ["\xF2\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xF2\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],

        ["\xF2\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xF2\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],

        ["\xF2\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xF2\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],

        ["\xF2\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xF2\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],

        ["\xF2\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xF2\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],

        ["\xF2\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xF2\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],

        ["\xF2\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\xF2\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],

        ["\xF2\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\xF2\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],

        ["\xF2\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\xF2\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],

        ["\xF2\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\xF2\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],

        ["\xF2\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\xF2\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],

        ["\xF2\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\xF2\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],

        ["\xF2\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xF2\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],

        ["\xF2\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xF2\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],

        ["\xF2\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xF2\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],

        ["\xF2\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xF2\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],

        ["\xF2\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],
        ["\xB2\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],

        ["\xF2\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xF2\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],

        ["\xF2\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xF2\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],

        ["\xF2\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xF2\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],

        ["\xF2\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xF2\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],

        ["\xF2\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xF2\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],

        ["\xF2\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\xF2\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],

        ["\xF2\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\xF2\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],

        ["\xF2\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\xF2\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],

        ["\xF2\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],
        ["\xF2\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],

        ["\xF2\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],
        ["\xF2\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],

        ["\xF3\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xF3\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],

        ["\xF3\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\xF3\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],

        ["\xF3\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\xF3\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],

        ["\xF3\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\xF3\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],

        ["\xF3\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\xF3\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],

        ["\xF3\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\xF3\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],

        ["\xF3\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\xF3\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],

        ["\xF3\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\xF3\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],

        ["\xF3\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\xF3\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],

        ["\xF3\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\xF3\xAA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],

        ["\xF3\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xF3\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],

        ["\xF3\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\xF3\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],

        ["\xF3\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\xF3\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],

        ["\xF3\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\xF3\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],

        ["\xF3\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\xF3\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],

        ["\xF3\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xF3\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],

        ["\xF3\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\xF3\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],

        ["\xF3\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\xF3\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],

        ["\xF3\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\xF3\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],

        ["\xF3\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\xF3\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],

        ["\xF3\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\xF3\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],

        ["\xF3\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\xF3\xB6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],

        ["\xF3\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\xF3\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],

        ["\xF3\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\xF3\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],

        ["\xF3\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\xF3\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],

        ["\xF3\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\xF3\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],

        ["\xF3\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\xF3\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],

        ["\xF3\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\xF3\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],

        ["\xF3\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\xF3\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],

        ["\xF3\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\xF3\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],

        ["\xF3\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\xF3\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],

        ["\xF3\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xF3\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],

        ["\xF3\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xF3\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],

        ["\xF3\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xF3\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],

        ["\xF3\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xF3\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],

        ["\xF3\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xF3\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],

        ["\xF3\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xF3\xC5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],

        ["\xF3\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xF3\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],

        ["\xF3\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xF3\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],

        ["\xF3\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xF3\xC8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],

        ["\xF3\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xF3\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],

        ["\xF3\xCA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\xF3\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],

        ["\xF3\xCB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\xF3\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],

        ["\xF3\xCC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\xF3\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],

        ["\xF3\xCD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\xF3\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],

        ["\xF3\xCE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\xF3\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],

        ["\xF3\xCF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\xF3\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],

        ["\xF3\xD0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xF3\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],

        ["\xF3\xD1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xF3\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],

        ["\xF3\xD2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xF3\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],

        ["\xF3\xD3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xF3\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],

        ["\xF3\xD4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xF3\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],

        ["\xF3\xD5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xF3\xD5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],

        ["\xF3\xD6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xF3\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],

        ["\xF3\xD7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xF3\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],

        ["\xF3\xD8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xF3\xD8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],

        ["\xF3\xD9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xF3\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],

        ["\xF3\xDA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\xF3\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],

        ["\xF3\xDB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\xF3\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],

        ["\xF3\xDC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\xF3\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],

        ["\xF3\xDD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\xF3\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],

        ["\xF3\xDE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\xF3\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],

        ["\xF3\xDF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\xF3\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],

        ["\xF3\xE0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xF3\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],

        ["\xF3\xE1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\xF3\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],

        ["\xF3\xE2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xF3\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],

        ["\xF3\xE3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xF3\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],

        ["\xF3\xE4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xF3\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],

        ["\xF3\xE5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xF3\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],

        ["\xF3\xE6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xF3\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],

        ["\xF3\xE7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xF3\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],

        ["\xF3\xE8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xF3\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],

        ["\xF3\xE9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xF3\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],

        ["\xF3\xEA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\xF3\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],

        ["\xF3\xEB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\xF3\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],

        ["\xF3\xEC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\xF3\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],

        ["\xF3\xED",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\xF3\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],

        ["\xF3\xEE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\xF3\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],

        ["\xF3\xEF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\xF3\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],

        ["\xF3\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xF3\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],

        ["\xF3\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xF3\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],

        ["\xF3\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xF3\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],

        ["\xF3\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xF3\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],

        ["\xF3\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xF3\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],

        ["\xF3\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xF3\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],

        ["\xF3\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xF3\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],

        ["\xF3\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xF3\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],

        ["\xF3\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xF3\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],

        ["\xF3\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xF3\xF9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],

        ["\xF3\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\xF3\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],

        ["\xF3\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\xF3\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],

        ["\xF3\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\xF3\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],

        ["\xF3\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],
        ["\xF3\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],

        ["\xF3\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],
        ["\xF3\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],

        ["\xF4\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xB6\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],

        ["\xF4\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],
        ["\xCB\xEA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"],

        ["\xF4\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xCD\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"],

        ["\xF4\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE0\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"],

        ["\xF4\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xA4"],
        ["\x44\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF4\xA5"],

        ["\xF4\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xA8"],
        ["\x58\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xF4\xA6"],

        ["\x31\xF0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xEB"],
        ["\x77\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF0"],

        ["\x31\xF1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xEC"],
        ["\x77\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF1"],

        ["\x31\xF2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xED"],
        ["\x77\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF2"],

        ["\x31\xF3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xEE"],
        ["\x77\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF3"],

        ["\x31\xF4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xEF"],
        ["\x77\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF4"],

        ["\x31\xF5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF0"],
        ["\x77\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF5"],

        ["\x31\xF6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF1"],
        ["\x77\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF6"],

        ["\x31\xF7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF2"],
        ["\x77\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF7"],

        ["\x31\xF8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF3"],
        ["\x77\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF8"],

        ["\x31\xF9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x77\xF4"],
        ["\x77\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xF9"],

        ["\x31\xFA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA1"],
        ["\x76\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xFA"],

        ["\x31\xFB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA2"],
        ["\x76\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xFB"],

        ["\x31\xFC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x76\xA3"],
        ["\x76\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xFC"],

        ["\xD4\x63",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\xDC"],
        ["\x5F\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],

        ["\xDC\x5F",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\x64\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xDC\x5F"],

        ["\xE4\x69",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xD9"],
        ["\x6A\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],

        ["\xE3\x78",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\xFE"],
        ["\x69\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],

        ["\xD9\x21",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\x62\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD9\x21"],

        ["\xB1\x3B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xC7"],
        ["\x42\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x3B"],

        ["\x31\xFD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE1"],
        ["\x70\xE1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xFD"],

        ["\xC2\x2D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xA3"],
        ["\x51\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x2D"],

        ["\xC3\x7C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xCD"],
        ["\x70\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x7C"],

        ["\xE4\x50",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\xC9"],
        ["\x6A\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],

        ["\xC2\x3F",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xFC"],
        ["\x51\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x3F"],

        ["\xBC\x74",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\x4C\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\x74"],

        ["\xB0\x29",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\xAC"],
        ["\x41\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\x29"],

        ["\xB0\x48",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\xE8"],
        ["\x41\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\x48"],

        ["\x31\xFE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"],
        ["\x43\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x31\xFE"],

        ["\xB0\x52",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\xEF"],
        ["\x41\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\x52"],

        ["\xB0\x54",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\xF0"],
        ["\x41\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\x54"],

        ["\xB0\x63",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\xFB"],
        ["\x41\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\x63"],

        ["\xB0\x6E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xA8"],
        ["\x42\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB0\x6E"],

        ["\xB1\x27",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xB5"],
        ["\x42\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x27"],

        ["\xB1\x23",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xB3"],
        ["\x42\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x23"],

        ["\xB1\x2C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xB9"],
        ["\x42\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x2C"],

        ["\xB1\x29",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xB7"],
        ["\x42\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x29"],

        ["\xB1\x3E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xCA"],
        ["\x42\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x3E"],

        ["\xB1\x5F",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xE7"],
        ["\x42\xE7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x5F"],

        ["\xB1\x58",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xDF"],
        ["\x42\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x58"],

        ["\xB1\x48",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xD0"],
        ["\x43\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x48"],

        ["\xB1\x57",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xDE"],
        ["\x42\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x57"],

        ["\xB1\x63",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xE9"],
        ["\x42\xE9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x63"],

        ["\xB1\x74",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xF5"],
        ["\x42\xF5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x74"],

        ["\xB1\x61",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xE8"],
        ["\x42\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB1\x61"],

        ["\xB2\x23",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\xFC"],
        ["\x42\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\x23"],

        ["\x32\xA1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xB9"],
        ["\x43\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA1"],

        ["\xB2\x3B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xB2"],
        ["\x43\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\x3B"],

        ["\xB2\x66",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xD3"],
        ["\x43\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\x66"],

        ["\xB2\x6D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xD9"],
        ["\x43\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\x6D"],

        ["\xB2\x75",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xF2"],
        ["\x43\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\x75"],

        ["\xB2\x7C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\xF7"],
        ["\x43\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB2\x7C"],

        ["\x32\xA2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xAC"],
        ["\x44\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA2"],

        ["\xB3\x35",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xB4"],
        ["\x44\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\x35"],

        ["\xB3\x58",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xF7"],
        ["\x44\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\x58"],

        ["\xB3\x5B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xD2"],
        ["\x44\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\x5B"],

        ["\xB3\x65",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xFA"],
        ["\x44\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\x65"],

        ["\xB3\x6E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xED"],
        ["\x44\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\x6E"],

        ["\xB3\x7B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xA3"],
        ["\x45\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\x7B"],

        ["\x32\xA3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\x45\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA3"],

        ["\x32\xA4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\x45\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA4"],

        ["\xB4\x40",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xD2"],
        ["\x45\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\x40"],

        ["\xB4\x47",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\x45\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\x47"],

        ["\xB4\x50",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xE2"],
        ["\x45\xE2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\x50"],

        ["\xB4\x5E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xF3"],
        ["\x45\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB4\x5E"],

        ["\x32\xA5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xF2"],
        ["\x45\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA5"],

        ["\xB5\x2A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xC4"],
        ["\x46\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\x2A"],

        ["\x32\xA6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xC1"],
        ["\x46\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA6"],

        ["\xB5\x2F",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\xC9"],
        ["\x46\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\x2F"],

        ["\xB5\x44",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xFA"],
        ["\x45\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\x44"],

        ["\xB5\x68",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\xF6"],
        ["\x45\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB5\x68"],

        ["\x32\xA7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xC9"],
        ["\x48\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA7"],

        ["\xB7\x42",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xCA"],
        ["\x48\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\x42"],

        ["\xB7\x64",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xCB"],
        ["\x48\xCB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\x64"],

        ["\xB7\x68",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\xF7"],
        ["\x47\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\x68"],

        ["\xB7\x67",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\xF6"],
        ["\x47\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB7\x67"],

        ["\x32\xA8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xCC"],
        ["\x48\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA8"],

        ["\x32\xA9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xC4\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xA9"],

        ["\x32\xAA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xBB"],
        ["\x48\xBB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xAA"],

        ["\xB8\x4E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xCD"],
        ["\x48\xCD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\x4E"],

        ["\xB8\x61",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xD0"],
        ["\x48\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\x61"],

        ["\xB8\x75",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xE3"],
        ["\x48\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\x75"],

        ["\xB8\x77",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xE4"],
        ["\x48\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\x77"],

        ["\xB8\x78",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xE5"],
        ["\x48\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\x78"],

        ["\xB8\x7C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\xEB"],
        ["\x48\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB8\x7C"],

        ["\xB9\x2F",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\xA3"],
        ["\x49\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\x2F"],

        ["\xB9\x37",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\xF0"],
        ["\x49\xF0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB9\x37"],

        ["\xBA\x3E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\xF2"],
        ["\x49\xF2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\x3E"],

        ["\xBA\x5B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\x4A\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\x5B"],

        ["\xCD\x2A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xBD"],
        ["\x4A\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\x2A"],

        ["\xBA\x61",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\x4A\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\x61"],

        ["\x32\xAB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\x4A\xC6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xAB"],

        ["\xBA\x6B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\x4A\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBA\x6B"],

        ["\xBB\x33",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\x4A\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x33"],

        ["\xBB\x38",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\x4A\xF3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x38"],

        ["\x32\xAC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xE4"],
        ["\x4B\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xAC"],

        ["\xBB\x4A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\xFB"],
        ["\x4A\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x4A"],

        ["\x32\xAD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xA3"],
        ["\x4B\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xAD"],

        ["\x32\xAE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xD0"],
        ["\x4B\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xAE"],

        ["\xBB\x50",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xA2"],
        ["\x4B\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x50"],

        ["\xBB\x5E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xD3"],
        ["\x4B\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x5E"],

        ["\xBB\x74",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xDF"],
        ["\x4B\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x74"],

        ["\xBB\x75",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xE0"],
        ["\x4B\xE0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x75"],

        ["\xBB\x79",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\xE5"],
        ["\x4B\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBB\x79"],

        ["\xBC\x64",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xEB"],
        ["\x4C\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\x64"],

        ["\xBC\x6D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\xEE"],
        ["\x4C\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\x6D"],

        ["\xBC\x7E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\xA2"],
        ["\x4D\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBC\x7E"],

        ["\x32\xAF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\xC0"],
        ["\x4D\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xAF"],

        ["\xBD\x42",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\xC7"],
        ["\x4D\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\x42"],

        ["\xBD\x67",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\xCC"],
        ["\x4D\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\x67"],

        ["\x32\xB0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xA8"],
        ["\x4E\xA8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB0"],

        ["\xBD\x70",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\xD0"],
        ["\x4D\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBD\x70"],

        ["\xBE\x30",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xC1"],
        ["\x4E\xC1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\x30"],

        ["\xBE\x2C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xBD"],
        ["\x4E\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\x2C"],

        ["\x32\xB1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xED"],
        ["\x4E\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB1"],

        ["\xBE\x33",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xC2"],
        ["\x4E\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\x33"],

        ["\xBE\x3D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xEE"],
        ["\x4E\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\x3D"],

        ["\xBE\x4D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xD0"],
        ["\x4E\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\x4D"],

        ["\xBE\x49",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xCE"],
        ["\x4E\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\x49"],

        ["\xBE\x64",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xDB"],
        ["\x4E\xDB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBE\x64"],

        ["\xBF\x28",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\xF7"],
        ["\x4E\xF7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\x28"],

        ["\xBF\x49",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xB5"],
        ["\x4F\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xBF\x49"],

        ["\xC0\x44",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xED"],
        ["\x4F\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\x44"],

        ["\xC0\x64",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xFA"],
        ["\x4F\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\x64"],

        ["\xC0\x74",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xA2"],
        ["\x50\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC0\x74"],

        ["\xC1\x26",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\xA7"],
        ["\x4F\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\x26"],

        ["\x32\xB2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\x50\xC9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB2"],

        ["\xC1\x75",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xBD"],
        ["\x51\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\x75"],

        ["\xC1\x7C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xC4"],
        ["\x51\xC4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\x7C"],

        ["\x32\xB3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],
        ["\xB9\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB3"],

        ["\xC1\x78",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xC0"],
        ["\x51\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC1\x78"],

        ["\xC2\x2B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xA1"],
        ["\x51\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x2B"],

        ["\xC2\x21",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xC7"],
        ["\x51\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x21"],

        ["\xC2\x25",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xCA"],
        ["\x51\xCA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x25"],

        ["\x32\xB4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xD9"],
        ["\x51\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB4"],

        ["\xC2\x38",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\xA1"],
        ["\x52\xA1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x38"],

        ["\xC2\x3A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xD4"],
        ["\x51\xD4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x3A"],

        ["\x32\xB5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xDE"],
        ["\x51\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB5"],

        ["\xC2\x44",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xB3"],
        ["\x51\xB3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x44"],

        ["\xC2\x52",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xE5"],
        ["\x51\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x52"],

        ["\xC2\x57",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xAB"],
        ["\x51\xAB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x57"],

        ["\xC2\x5B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xEB"],
        ["\x51\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x5B"],

        ["\xC2\x5E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\xF1"],
        ["\x51\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x5E"],

        ["\xC2\x6D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\xA2"],
        ["\x52\xA2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x6D"],

        ["\xC2\x70",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\xBC"],
        ["\x52\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\x70"],

        ["\x32\xB6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\xAD"],
        ["\x52\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB6"],

        ["\xC3\x21",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xCE"],
        ["\x70\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x21"],

        ["\xC3\x35",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\xB2"],
        ["\x53\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x35"],

        ["\xC3\x49",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\xEE"],
        ["\x52\xEE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x49"],

        ["\xC3\x39",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\xB4"],
        ["\x53\xB4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x39"],

        ["\x32\xB7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\xC0"],
        ["\x53\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB7"],

        ["\xC3\x58",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\xC7"],
        ["\x53\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x58"],

        ["\xC3\x7E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xCF"],
        ["\x70\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x7E"],

        ["\x32\xB8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],
        ["\x70\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB8"],

        ["\xC4\x4C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\xED"],
        ["\x53\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\x4C"],

        ["\x32\xB9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],
        ["\x70\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xB9"],

        ["\xC4\x59",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\xF4"],
        ["\x52\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\x59"],

        ["\xC4\x6A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD2"],
        ["\x70\xD2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\x6A"],

        ["\xC4\x7D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],
        ["\x70\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC4\x7D"],

        ["\x32\xBA",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\xAD"],
        ["\x54\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xBA"],

        ["\xC5\x27",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\xE8"],
        ["\x52\xE8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\x27"],

        ["\xC5\x35",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\xAF"],
        ["\x54\xAF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\x35"],

        ["\xC5\x36",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\xB0"],
        ["\x54\xB0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\x36"],

        ["\x32\xBB",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\xBC"],
        ["\x54\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xBB"],

        ["\xC5\x55",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\xBD"],
        ["\x54\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC5\x55"],

        ["\xC6\x38",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\xF8"],
        ["\x54\xF8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\x38"],

        ["\xC6\x57",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\xB5"],
        ["\x55\xB5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\x57"],

        ["\xC6\x60",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\xBD"],
        ["\x55\xBD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\x60"],

        ["\xC6\x6A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\xC3"],
        ["\x55\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\x6A"],

        ["\xC6\x63",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\xBF"],
        ["\x55\xBF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC6\x63"],

        ["\xC7\x21",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\xD3"],
        ["\x55\xD3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x21"],

        ["\xC7\x2B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\xDE"],
        ["\x55\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x2B"],

        ["\xC7\x47",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xA3"],
        ["\x56\xA3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x47"],

        ["\xC7\x43",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xDE"],
        ["\x70\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x43"],

        ["\xC7\x4B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xA7"],
        ["\x56\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x4B"],

        ["\xC7\x4F",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xAD"],
        ["\x56\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x4F"],

        ["\xC7\x59",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xB2"],
        ["\x56\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x59"],

        ["\x32\xBC",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xB8"],
        ["\x56\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xBC"],

        ["\x32\xBD",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xDF"],
        ["\x70\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xBD"],

        ["\xC7\x66",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\xB1"],
        ["\x55\xB1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x66"],

        ["\xC7\x6E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xC2"],
        ["\x56\xC2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x6E"],

        ["\xC7\x7C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xCF"],
        ["\x56\xCF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x7C"],

        ["\xC7\x6B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xBE"],
        ["\x56\xBE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x6B"],

        ["\xC7\x70",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xC3"],
        ["\x56\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC7\x70"],

        ["\xC8\x31",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xDF"],
        ["\x56\xDF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\x31"],

        ["\xC8\x65",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\xFE"],
        ["\x56\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\x65"],

        ["\xC8\x78",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xAE"],
        ["\x57\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC8\x78"],

        ["\xC9\x26",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xB8"],
        ["\x57\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x26"],

        ["\xC9\x2B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xB9"],
        ["\x57\xB9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x2B"],

        ["\xC9\x2D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xBA"],
        ["\x57\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x2D"],

        ["\x32\xBE",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xBC"],
        ["\x57\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xBE"],

        ["\xC9\x4A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\x57\xD1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x4A"],

        ["\xC9\x53",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xDE"],
        ["\x57\xDE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x53"],

        ["\xC9\x69",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xA6"],
        ["\x58\xA6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x69"],

        ["\xC9\x63",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xA5"],
        ["\x58\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x63"],

        ["\xC9\x7C",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\x57\xF1",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x7C"],

        ["\xC9\x74",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xEB"],
        ["\x57\xEB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x74"],

        ["\xC9\x75",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xEC"],
        ["\x57\xEC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xC9\x75"],

        ["\x32\xBF",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE3"],
        ["\x70\xE3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xBF"],

        ["\xCA\x33",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\x57\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\x33"],

        ["\xCA\x3D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xA9"],
        ["\x58\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\x3D"],

        ["\xCA\x6F",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xFA"],
        ["\x58\xFA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\x6F"],

        ["\xCA\x71",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xD6"],
        ["\x58\xD6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCA\x71"],

        ["\xCB\x2E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xED"],
        ["\x58\xED",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x2E"],

        ["\x32\xC0",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xEF"],
        ["\x58\xEF",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC0"],

        ["\xCB\x4A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\xF6"],
        ["\x58\xF6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x4A"],

        ["\xCB\x66",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xBA"],
        ["\x59\xBA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x66"],

        ["\xCB\x6A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xBC"],
        ["\x59\xBC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x6A"],

        ["\xCB\x70",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\x59\xC0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x70"],

        ["\xCB\x74",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\x59\xC3",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x74"],

        ["\xCB\x6E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\x5A\xAC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x6E"],

        ["\xCC\x25",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\x59\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x25"],

        ["\xCB\x79",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],
        ["\x59\xC7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCB\x79"],

        ["\xCC\x2B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\x59\xD7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x2B"],

        ["\xCC\x2E",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\x59\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x2E"],

        ["\xCC\x2D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\x59\xD9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x2D"],

        ["\xCC\x32",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xDD"],
        ["\x59\xDD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x32"],

        ["\xCC\x42",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xAD"],
        ["\x5A\xAD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x42"],

        ["\xCC\x50",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\x59\xF4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x50"],

        ["\xCC\x59",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\xFB"],
        ["\x59\xFB",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCC\x59"],

        ["\x32\xC1",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xB8"],
        ["\x5A\xB8",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC1"],

        ["\xCD\x3B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\x5A\xD0",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCD\x3B"],

        ["\x32\xC2",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"],
        ["\x5A\xFE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC2"],

        ["\xCE\x3B",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA4"],
        ["\x5B\xA4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x3B"],

        ["\x32\xC3",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA5"],
        ["\x5B\xA5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC3"],

        ["\xCE\x3A",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\xFD"],
        ["\x5A\xFD",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x3A"],

        ["\xCE\x43",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\x5B\xA9",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x43"],

        ["\x32\xC4",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\x5B\xB7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC4"],

        ["\xCE\x72",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xCC"],
        ["\x5B\xCC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x72"],

        ["\xB3\x5D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\xDC"],
        ["\x44\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xB3\x5D"],

        ["\xCF\x55",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\xFC"],
        ["\x5B\xFC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x55"],

        ["\xCF\x62",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xA7"],
        ["\x5C\xA7",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x62"],

        ["\xCF\x69",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"],
        ["\x5C\xAE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x69"],

        ["\xCF\x6D",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\x5C\xB2",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x6D"],

        ["\x32\xC5",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\x5C\xCE",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC5"],

        ["\x32\xC6",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\xE5"],
        ["\x70\xE5",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC6"],

        ["\x32\xC7",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xDA"],
        ["\x5C\xDA",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC7"],

        ["\x32\xC8",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\x5C\xDC",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC8"],

        ["\xD0\x65",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\x5C\xE6",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x65"],

        ["\x32\xC9",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\x5C\xE4",'letsj','jef',{'INPUT_LAYOUT'=>'D'},"\x32\xC9"],

        ["\xD0\x69",'jef','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\x5C\xE8",'letsj','jef',{