# Generated by default/object.tt
package Paws::SageMaker::ProcessingS3Input;
  use Moose;
  has LocalPath => (is => 'ro', isa => 'Str');
  has S3CompressionType => (is => 'ro', isa => 'Str');
  has S3DataDistributionType => (is => 'ro', isa => 'Str');
  has S3DataType => (is => 'ro', isa => 'Str', required => 1);
  has S3InputMode => (is => 'ro', isa => 'Str');
  has S3Uri => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ProcessingS3Input

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ProcessingS3Input object:

  $service_obj->Method(Att1 => { LocalPath => $value, ..., S3Uri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ProcessingS3Input object:

  $result = $service_obj->Method(...);
  $result->Att1->LocalPath

=head1 DESCRIPTION

Configuration for downloading input data from Amazon S3 into the
processing container.

=head1 ATTRIBUTES


=head2 LocalPath => Str

The local path in your container where you want Amazon SageMaker to
write input data to. C<LocalPath> is an absolute path to the input data
and must begin with C</opt/ml/processing/>. C<LocalPath> is a required
parameter when C<AppManaged> is C<False> (default).


=head2 S3CompressionType => Str

Whether to GZIP-decompress the data in Amazon S3 as it is streamed into
the processing container. C<Gzip> can only be used when C<Pipe> mode is
specified as the C<S3InputMode>. In C<Pipe> mode, Amazon SageMaker
streams input data from the source directly to your container without
using the EBS volume.


=head2 S3DataDistributionType => Str

Whether to distribute the data from Amazon S3 to all processing
instances with C<FullyReplicated>, or whether the data from Amazon S3
is shared by Amazon S3 key, downloading one shard of data to each
processing instance.


=head2 B<REQUIRED> S3DataType => Str

Whether you use an C<S3Prefix> or a C<ManifestFile> for the data type.
If you choose C<S3Prefix>, C<S3Uri> identifies a key name prefix.
Amazon SageMaker uses all objects with the specified key name prefix
for the processing job. If you choose C<ManifestFile>, C<S3Uri>
identifies an object that is a manifest file containing a list of
object keys that you want Amazon SageMaker to use for the processing
job.


=head2 S3InputMode => Str

Whether to use C<File> or C<Pipe> input mode. In File mode, Amazon
SageMaker copies the data from the input source onto the local ML
storage volume before starting your processing container. This is the
most commonly used input mode. In C<Pipe> mode, Amazon SageMaker
streams input data from the source directly to your processing
container into named pipes without using the ML storage volume.


=head2 B<REQUIRED> S3Uri => Str

The URI of the Amazon S3 prefix Amazon SageMaker downloads data
required to run a processing job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

