use strict;
use warnings;
use Test::More tests => 68;
use Digest::Hamsi qw(hamsi_224 hamsi_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Hamsi->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            hamsi_224_hex($data), $digest,
            "hamsi_224_hex: $len bits of $msg"
        );
        ok(
            hamsi_224($data) eq pack('H*', $digest),
            "hamsi_224: $len bits of $msg"
        );
    }

    my $md = Digest::Hamsi->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|B9F6EB1A9B990373F9D2CB125584333C69A3D41AE291845F05DA221F
00|77257A52BB1B3F4ED8C2E3EF8D9D30D159E166F6E59BA721A18AE991
C0|15F44CBA8184009AE863062A4A4AD1284096BBA5B03B1336EEA36135
C0|DC55B674E8BFA13EAEEB9E646C6FACD5659C546DD743E5BFAA660ABA
80|7612D68A8FCE0CE2C231FE09A0349E4404023B88088267F797A54C3B
48|4F9AEEDE4EA3A39F2C43B836023D2BE89548BA7CC4B0EBECC4665183
50|82ECBCE8FCDF7C4F2A0A8E12AB00DC84566F5A67FDD7FA650EB8447E
98|3F675BD9586C3CA81DA7B49C84B194A332D5EF40CCB48470E2E03362
CC|8BFA48CF172314D558417877CDA9BE97825128C531165407FC241040
9800|357B1936111065952C1D2EA0D2031E3F6A0F3B4EF4072ED70F9D5DB2
9D40|5D5F5506F5F0100A47A2EC029FD93486C0FDE9D12EBD4DE926B896F5
AA80|FFF6FBA2CF5DE8C369295FEB968B6BCC0DB7F457E315AAE3BD9ECC72
9830|A980EA50B5EE7CEC37D9A8B7A3EA71F4DE7DC9FA35E84CB89A64E59E
5030|BBF47748EA83E39D8AA2D343BF6A43FDEFC7CE7F52B7E5B5AB71249C
4D24|A8DEA04A4B321416D2E4BC047904ADDE48760A3BE28683755C4B8FE7
CBDE|3DCF846E69CFF82F67822F31AFB639F99D48E27C4F637B2ACF7E9C76
41FB|5EABC4770AD6AB30335CA58DE088AA234DB09258933BA833113A5FA1
4FF400|9A95F65D3485C7741624A0ACE20C6F6E7FCC99DD21FF19D85F551079
FD0440|85781E6F5E71AA153F6338BADEDB931E76FEDDC898CAD166754FB6A3
424D00|ABFAFB44666495E8C1080BE5004D199BF684A0E2751D17F5BBC9BF46
3FDEE0|C776FDC067CD98AD598753C563340F57870BBF0E0A54FD4334852AF9
335768|1EC6B6D8EAE3AD547A29DE1D02F06811A03477E70194D2ED5F9D50AD
051E7C|86D45A7CFBF5ADE001A3488D9F283E64150A644C3D4037E1D3BA7FFE
717F8C|6FA6713FF388D1741A86A4CA6E6D67EC295A5D9E6CFD5F02727EB75C
1F877C|15A0B54528FE0F765B50BD340BFB36AE32F106E305AEC3B2F42CBEC5
EB35CF80|B3A5A707208EFC3B6EABD45C13BC6A790C4EAA18EE3F8EC75C55BA4E
B406C480|3F1A286BEDCF8920A96E1DC674C316E762A5655683796F96B80CF201
CEE88040|B4B0EBF0C83B3D0E9D4F7CCFCB53D75D41CC61C94E3CB0DCE24AE569
C584DB70|FC4AF72A9BD51010BD8C87EC9333593398BBCFCB8558B655CEFB0093
53587BC8|5DF479DA370567B4E72A75F6F672F97B621C21BD9788F8429F49343F
69A305B0|A2BBC8F22701DFDD0816CEF1A95914ECB3A71E43956A991A93F00C54
C9375ECE|2CE9BD9D11E3616770ABA337473DA71D6A7C1EF3632A5E6D65E91C56
C1ECFDFC|0A3A2BF457FDC3FBEB78DFD423AFC35D772AB22BDBE2AEB5AF481FA1
8D73E8A280|2BC132E5CBC752BAE6B08910F69DDBFEED4B609B27DEB71EEB856E14
06F2522080|5ED2BE120DC061F7237119D55D40E5978B337D0AD8B892BD61FB4306
3EF6C36F20|1D09784E8D03F2609C52325BDF1EAE4E361A7CCD86CD4999DE37E473
0127A1D340|CBFB434F02BA6E47E4DD38D74CBC4B46912CCDF2991B9D3F7712A54F
6A6AB6C210|49DF571CA1195D64206E86E286F5E5004568B5640588DC04A2A05001
AF3175E160|568E58BFBEB78FDEA7BE16B21A0CB479C224DA33D6A7A08C90BB0154
B66609ED86|6DD1B1AD1CF0B875CE16C099135C6998F4B699692B0586565457C132
21F134AC57|1734CA61A3787FEDF82FAB047784C49E77E8CBFC411BA1836742F15B
3DC2AADFFC80|C5F29AC7010BA97519B58941476B1233AE0BA6F9B53164E2E61156D8
9202736D2240|901DC8F576208950D59B8B57795A02E50F6B32DFF5DAE2014C16D702
F219BD629820|789AA4C21922CC99E80B4EC51943C21ECCE0B515AD25971A4353DE28
F3511EE2C4B0|F03E758A334616C2575C385D07BB8680F1E6E4B6C2F1C39E982FC2BC
3ECAB6BF7720|0B8D6FF24A2EE600ADE3C517E7C74157C48F48FB4CD9DD071C99D3D7
CD62F688F498|2BCBA37F8BA35BA961A3B468FA01405BF9F9F1C35DC98A3F90330E99
C2CBAA33A9F8|F3FE80C5FB40163341349986536B424F4E0453BE8F194471E6FBC0A5
C6F50BB74E29|83AC176096FA997BFAF7F053E5050EBE64AA17DB1BBD0743B119B250
79F1B4CCC62A00|0EF803E8064FB8ECE49385D1E248DB8B9FDD039D54183EEF1207395E
