/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.projection;

import com.ctreber.acearth.util.Coordinate;
import com.ctreber.acearth.util.Point2D;
import com.ctreber.acearth.util.Point3D;
import com.ctreber.acearth.util.Toolkit;

public abstract class Projection {
    int fImageHeight;
    int fImageWidth;
    private double fXOffset;
    private double fYOffset;
    private int fShiftX;
    private int fShiftY;
    double fScale;
    private Coordinate fViewPos;
    private double fViewRotation;
    double fViewMagnification;
    private double fCosLat;
    private double fSinLat;
    private double fCosLon;
    private double fSinLon;
    private double fCosRot;
    private double fSinRot;

    public void initTransformTable() {
        this.fCosLat = Math.cos(Toolkit.degsToRads(this.fViewPos.getLat()));
        this.fSinLat = Math.sin(Toolkit.degsToRads(this.fViewPos.getLat()));
        this.fCosLon = Math.cos(Toolkit.degsToRads(this.fViewPos.getLong()));
        this.fSinLon = Math.sin(Toolkit.degsToRads(this.fViewPos.getLong()));
        this.fCosRot = Math.cos(Toolkit.degsToRads(this.fViewRotation));
        this.fSinRot = Math.sin(Toolkit.degsToRads(this.fViewRotation));
        this.fXOffset = (double)this.fImageWidth / 2.0 + (double)this.fShiftX;
        this.fYOffset = (double)this.fImageHeight / 2.0 + (double)this.fShiftY;
        this.setScale();
    }

    protected abstract void setScale();

    public abstract double projectY(double var1);

    public abstract double inverseProjectY(double var1);

    protected abstract double projectX(double var1, double var3);

    public abstract double inverseProjectX(double var1);

    public abstract boolean isVisible(Point3D var1);

    public boolean isWithinImage(Point2D point2D) {
        return point2D.getX() >= 0.0 && point2D.getX() < (double)this.fImageWidth && point2D.getY() >= 0.0 && point2D.getY() < (double)this.fImageHeight;
    }

    public abstract Coordinate getLocation(int var1, int var2);

    public Point2D project2D(Point3D point3D) {
        return new Point2D(this.projectX(point3D.getX(), point3D.getZ()), this.projectY(point3D.getY()));
    }

    public Point2D finalize(Point2D point2D) {
        return new Point2D(this.finalizeX(point2D.getX()), this.finalizeY(point2D.getY()));
    }

    public double finalizeX(double d) {
        return this.fXOffset + this.fScale * d;
    }

    public double finalizeY(double d) {
        return this.fYOffset - this.fScale * d;
    }

    public double inverseFinalizeX(double d) {
        return (d - this.fXOffset) / this.fScale;
    }

    public double inverseFinalizeY(double d) {
        return (this.fYOffset - d) / this.fScale;
    }

    public Point3D rotate(Point3D point3D) {
        double d = point3D.getX();
        double d2 = point3D.getY();
        double d3 = point3D.getZ();
        double d4 = this.fCosLon;
        double d5 = this.fSinLon;
        double d6 = d4 * d - d5 * d3;
        d3 = d5 * d + d4 * d3;
        d = d6;
        d4 = this.fCosLat;
        d5 = this.fSinLat;
        d6 = d4 * d2 - d5 * d3;
        d3 = d5 * d2 + d4 * d3;
        d2 = d6;
        d4 = this.fCosRot;
        d5 = this.fSinRot;
        d6 = d4 * d - d5 * d2;
        d2 = d5 * d + d4 * d2;
        d = d6;
        return new Point3D(d, d2, d3);
    }

    public Point3D rotateReverse(Point3D point3D) {
        double d = Math.cos(Toolkit.degsToRads(-this.fViewPos.getLat()));
        double d2 = Math.sin(Toolkit.degsToRads(-this.fViewPos.getLat()));
        double d3 = Math.cos(Toolkit.degsToRads(-this.fViewPos.getLong()));
        double d4 = Math.sin(Toolkit.degsToRads(-this.fViewPos.getLong()));
        double d5 = Math.cos(Toolkit.degsToRads(-this.fViewRotation));
        double d6 = Math.sin(Toolkit.degsToRads(-this.fViewRotation));
        double d7 = point3D.getX();
        double d8 = point3D.getY();
        double d9 = point3D.getZ();
        double d10 = d5;
        double d11 = d6;
        double d12 = d10 * d7 - d11 * d8;
        d8 = d11 * d7 + d10 * d8;
        d7 = d12;
        d10 = d;
        d11 = d2;
        d12 = d10 * d8 - d11 * d9;
        d9 = d11 * d8 + d10 * d9;
        d8 = d12;
        d10 = d3;
        d11 = d4;
        d12 = d10 * d7 - d11 * d9;
        d9 = d11 * d7 + d10 * d9;
        d7 = d12;
        return new Point3D(d7, d8, d9);
    }

    public double getScale() {
        return this.fScale;
    }

    public Coordinate getViewPos() {
        return this.fViewPos;
    }

    public void setViewMagnification(double d) {
        this.fViewMagnification = d;
        this.setScale();
    }

    public void setViewPos(Coordinate coordinate) {
        this.fViewPos = coordinate;
    }

    public void setShiftX(int n) {
        this.fShiftX = n;
    }

    public void setShiftY(int n) {
        this.fShiftY = n;
    }

    public void setViewRotation(double d) {
        this.fViewRotation = d;
    }

    public void setImageWidth(int n) {
        this.fImageWidth = n;
    }

    public void setImageHeight(int n) {
        this.fImageHeight = n;
    }
}

