#!perl
use 5.006;
use strict;
use warnings;
use String::Any::Extensions qw/exclude extension include/;
use Test::More tests => 6;

is( include( 'some/strin/to.test', [ '.testo', '.test2', '.test' ] ), 1, 'simple include test' );

is( include( 'some/strin/to.test', [ '.testo', '.test2', ] ), 0, 'negative include test' );

is( exclude( 'some/strin/to.test', [ '.testo', '.test2', '.test' ] ), 0, 'simple exclude test' );

is( exclude( 'some/strin/to.test', [ '.testo', '.test2' ] ), 1, 'negative exclude test' );

is( extension('some/strin/to.test'), '.test', 'simple extension test' );

isnt( extension('some/strin/to.test'), 'test', 'negative extension test' );

