package Term::Colormap::Brewer;

use strict;
use warnings FATAL => 'all';

use Term::Colormap qw( add_mapping );

our $VERSION = '0.19';

### Generated by running create_brewer_mapping ../ColorBrewer_all_schemes_RGBonly3.csv
# SchemeType = Qualitative, ColorName = Accent, NumOfColors = 3
add_mapping('accent-3', [ 114, 146, 216, ]);

# SchemeType = Qualitative, ColorName = Accent, NumOfColors = 4
add_mapping('accent-4', [ 114, 146, 216, 228, ]);

# SchemeType = Qualitative, ColorName = Accent, NumOfColors = 5
add_mapping('accent-5', [ 114, 146, 216, 228, 61, ]);

# SchemeType = Qualitative, ColorName = Accent, NumOfColors = 6
add_mapping('accent-6', [ 114, 146, 216, 228, 61, 198, ]);

# SchemeType = Qualitative, ColorName = Accent, NumOfColors = 7
add_mapping('accent-7', [ 114, 146, 216, 228, 61, 198, 130, ]);

# SchemeType = Qualitative, ColorName = Accent, NumOfColors = 8
add_mapping('accent-8', [ 114, 146, 216, 228, 61, 198, 130, 242, ]);

# SchemeType = Sequential, ColorName = Blues, NumOfColors = 3
add_mapping('blues-3', [ 255, 152, 67, ]);

# SchemeType = Sequential, ColorName = Blues, NumOfColors = 4
add_mapping('blues-4', [ 255, 152, 74, 25, ]);

# SchemeType = Sequential, ColorName = Blues, NumOfColors = 5
add_mapping('blues-5', [ 255, 152, 74, 67, 25, ]);

# SchemeType = Sequential, ColorName = Blues, NumOfColors = 6
add_mapping('blues-6', [ 255, 189, 152, 74, 67, 25, ]);

# SchemeType = Sequential, ColorName = Blues, NumOfColors = 7
add_mapping('blues-7', [ 255, 189, 152, 74, 68, 25, 24, ]);

# SchemeType = Sequential, ColorName = Blues, NumOfColors = 8
add_mapping('blues-8', [ 231, 255, 189, 152, 74, 68, 25, 24, ]);

# SchemeType = Sequential, ColorName = Blues, NumOfColors = 9
add_mapping('blues-9', [ 231, 255, 189, 152, 74, 68, 25, 25, 23, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 3
add_mapping('brbg-3', [ 179, 255, 73, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 4
add_mapping('brbg-4', [ 130, 180, 115, 6, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 5
add_mapping('brbg-5', [ 130, 180, 255, 115, 6, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 6
add_mapping('brbg-6', [ 94, 179, 223, 254, 73, 23, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 7
add_mapping('brbg-7', [ 94, 179, 223, 255, 254, 73, 23, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 8
add_mapping('brbg-8', [ 94, 136, 180, 223, 254, 115, 66, 23, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 9
add_mapping('brbg-9', [ 94, 136, 180, 223, 255, 254, 115, 66, 23, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 10
add_mapping('brbg-10', [ 58, 94, 136, 180, 223, 254, 115, 66, 23, 236, ]);

# SchemeType = Diverging, ColorName = BrBG, NumOfColors = 11
add_mapping('brbg-11', [ 58, 94, 136, 180, 223, 255, 254, 115, 66, 23, 236, ]);

# SchemeType = Sequential, ColorName = BuGn, NumOfColors = 3
add_mapping('bugn-3', [ 255, 116, 35, ]);

# SchemeType = Sequential, ColorName = BuGn, NumOfColors = 4
add_mapping('bugn-4', [ 255, 152, 73, 29, ]);

# SchemeType = Sequential, ColorName = BuGn, NumOfColors = 5
add_mapping('bugn-5', [ 255, 152, 73, 35, 22, ]);

# SchemeType = Sequential, ColorName = BuGn, NumOfColors = 6
add_mapping('bugn-6', [ 255, 254, 116, 73, 35, 22, ]);

# SchemeType = Sequential, ColorName = BuGn, NumOfColors = 7
add_mapping('bugn-7', [ 255, 254, 116, 73, 72, 29, 22, ]);

# SchemeType = Sequential, ColorName = BuGn, NumOfColors = 8
add_mapping('bugn-8', [ 231, 255, 254, 116, 73, 72, 29, 22, ]);

# SchemeType = Sequential, ColorName = BuGn, NumOfColors = 9
add_mapping('bugn-9', [ 231, 255, 254, 116, 73, 72, 29, 22, 22, ]);

# SchemeType = Sequential, ColorName = BuPu, NumOfColors = 3
add_mapping('bupu-3', [ 255, 146, 97, ]);

# SchemeType = Sequential, ColorName = BuPu, NumOfColors = 4
add_mapping('bupu-4', [ 255, 152, 104, 97, ]);

# SchemeType = Sequential, ColorName = BuPu, NumOfColors = 5
add_mapping('bupu-5', [ 255, 152, 104, 97, 5, ]);

# SchemeType = Sequential, ColorName = BuPu, NumOfColors = 6
add_mapping('bupu-6', [ 255, 152, 146, 104, 97, 5, ]);

# SchemeType = Sequential, ColorName = BuPu, NumOfColors = 7
add_mapping('bupu-7', [ 255, 152, 146, 104, 97, 97, 53, ]);

# SchemeType = Sequential, ColorName = BuPu, NumOfColors = 8
add_mapping('bupu-8', [ 231, 255, 152, 146, 104, 97, 97, 53, ]);

# SchemeType = Sequential, ColorName = BuPu, NumOfColors = 9
add_mapping('bupu-9', [ 231, 255, 152, 146, 104, 97, 97, 5, 53, ]);

# SchemeType = Qualitative, ColorName = Dark2, NumOfColors = 3
add_mapping('dark2-3', [ 36, 166, 97, ]);

# SchemeType = Qualitative, ColorName = Dark2, NumOfColors = 4
add_mapping('dark2-4', [ 36, 166, 97, 162, ]);

# SchemeType = Qualitative, ColorName = Dark2, NumOfColors = 5
add_mapping('dark2-5', [ 36, 166, 97, 162, 70, ]);

# SchemeType = Qualitative, ColorName = Dark2, NumOfColors = 6
add_mapping('dark2-6', [ 36, 166, 97, 162, 70, 178, ]);

# SchemeType = Qualitative, ColorName = Dark2, NumOfColors = 7
add_mapping('dark2-7', [ 36, 166, 97, 162, 70, 178, 136, ]);

# SchemeType = Qualitative, ColorName = Dark2, NumOfColors = 8
add_mapping('dark2-8', [ 36, 166, 97, 162, 70, 178, 136, 242, ]);

# SchemeType = Sequential, ColorName = GnBu, NumOfColors = 3
add_mapping('gnbu-3', [ 194, 151, 74, ]);

# SchemeType = Sequential, ColorName = GnBu, NumOfColors = 4
add_mapping('gnbu-4', [ 255, 151, 116, 31, ]);

# SchemeType = Sequential, ColorName = GnBu, NumOfColors = 5
add_mapping('gnbu-5', [ 255, 151, 116, 74, 25, ]);

# SchemeType = Sequential, ColorName = GnBu, NumOfColors = 6
add_mapping('gnbu-6', [ 255, 252, 151, 116, 74, 25, ]);

# SchemeType = Sequential, ColorName = GnBu, NumOfColors = 7
add_mapping('gnbu-7', [ 255, 252, 151, 116, 74, 31, 25, ]);

# SchemeType = Sequential, ColorName = GnBu, NumOfColors = 8
add_mapping('gnbu-8', [ 255, 194, 252, 151, 116, 74, 31, 25, ]);

# SchemeType = Sequential, ColorName = GnBu, NumOfColors = 9
add_mapping('gnbu-9', [ 255, 194, 252, 151, 116, 74, 31, 25, 24, ]);

# SchemeType = Sequential, ColorName = Greens, NumOfColors = 3
add_mapping('greens-3', [ 254, 150, 71, ]);

# SchemeType = Sequential, ColorName = Greens, NumOfColors = 4
add_mapping('greens-4', [ 255, 151, 114, 29, ]);

# SchemeType = Sequential, ColorName = Greens, NumOfColors = 5
add_mapping('greens-5', [ 255, 151, 114, 71, 22, ]);

# SchemeType = Sequential, ColorName = Greens, NumOfColors = 6
add_mapping('greens-6', [ 255, 251, 150, 114, 71, 22, ]);

# SchemeType = Sequential, ColorName = Greens, NumOfColors = 7
add_mapping('greens-7', [ 255, 251, 150, 114, 71, 29, 23, ]);

# SchemeType = Sequential, ColorName = Greens, NumOfColors = 8
add_mapping('greens-8', [ 231, 254, 251, 150, 114, 71, 29, 23, ]);

# SchemeType = Sequential, ColorName = Greens, NumOfColors = 9
add_mapping('greens-9', [ 231, 254, 251, 150, 114, 71, 29, 22, 22, ]);

# SchemeType = Sequential, ColorName = Greys, NumOfColors = 3
add_mapping('greys-3', [ 255, 250, 242, ]);

# SchemeType = Sequential, ColorName = Greys, NumOfColors = 4
add_mapping('greys-4', [ 231, 252, 246, 239, ]);

# SchemeType = Sequential, ColorName = Greys, NumOfColors = 5
add_mapping('greys-5', [ 231, 252, 246, 242, 235, ]);

# SchemeType = Sequential, ColorName = Greys, NumOfColors = 6
add_mapping('greys-6', [ 231, 253, 250, 246, 242, 235, ]);

# SchemeType = Sequential, ColorName = Greys, NumOfColors = 7
add_mapping('greys-7', [ 231, 253, 250, 246, 243, 239, 235, ]);

# SchemeType = Sequential, ColorName = Greys, NumOfColors = 8
add_mapping('greys-8', [ 231, 255, 253, 250, 246, 243, 239, 235, ]);

# SchemeType = Sequential, ColorName = Greys, NumOfColors = 9
add_mapping('greys-9', [ 231, 255, 253, 250, 246, 243, 239, 235, 16, ]);

# SchemeType = Sequential, ColorName = Oranges, NumOfColors = 3
add_mapping('oranges-3', [ 224, 215, 166, ]);

# SchemeType = Sequential, ColorName = Oranges, NumOfColors = 4
add_mapping('oranges-4', [ 230, 216, 209, 166, ]);

# SchemeType = Sequential, ColorName = Oranges, NumOfColors = 5
add_mapping('oranges-5', [ 230, 216, 209, 166, 130, ]);

# SchemeType = Sequential, ColorName = Oranges, NumOfColors = 6
add_mapping('oranges-6', [ 230, 223, 215, 209, 166, 130, ]);

# SchemeType = Sequential, ColorName = Oranges, NumOfColors = 7
add_mapping('oranges-7', [ 230, 223, 215, 209, 202, 166, 88, ]);

# SchemeType = Sequential, ColorName = Oranges, NumOfColors = 8
add_mapping('oranges-8', [ 255, 224, 223, 215, 209, 202, 166, 88, ]);

# SchemeType = Sequential, ColorName = Oranges, NumOfColors = 9
add_mapping('oranges-9', [ 255, 224, 223, 215, 209, 202, 166, 130, 1, ]);

# SchemeType = Sequential, ColorName = OrRd, NumOfColors = 3
add_mapping('orrd-3', [ 224, 216, 167, ]);

# SchemeType = Sequential, ColorName = OrRd, NumOfColors = 4
add_mapping('orrd-4', [ 230, 222, 209, 166, ]);

# SchemeType = Sequential, ColorName = OrRd, NumOfColors = 5
add_mapping('orrd-5', [ 230, 222, 209, 167, 124, ]);

# SchemeType = Sequential, ColorName = OrRd, NumOfColors = 6
add_mapping('orrd-6', [ 230, 223, 216, 209, 167, 124, ]);

# SchemeType = Sequential, ColorName = OrRd, NumOfColors = 7
add_mapping('orrd-7', [ 230, 223, 216, 209, 203, 166, 88, ]);

# SchemeType = Sequential, ColorName = OrRd, NumOfColors = 8
add_mapping('orrd-8', [ 231, 224, 223, 216, 209, 203, 166, 88, ]);

# SchemeType = Sequential, ColorName = OrRd, NumOfColors = 9
add_mapping('orrd-9', [ 231, 224, 223, 216, 209, 203, 166, 124, 1, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 3
add_mapping('paired-3', [ 152, 31, 150, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 4
add_mapping('paired-4', [ 152, 31, 150, 70, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 5
add_mapping('paired-5', [ 152, 31, 150, 70, 210, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 6
add_mapping('paired-6', [ 152, 31, 150, 70, 210, 160, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 7
add_mapping('paired-7', [ 152, 31, 150, 70, 210, 160, 215, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 8
add_mapping('paired-8', [ 152, 31, 150, 70, 210, 160, 215, 208, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 9
add_mapping('paired-9', [ 152, 31, 150, 70, 210, 160, 215, 208, 182, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 10
add_mapping('paired-10', [ 152, 31, 150, 70, 210, 160, 215, 208, 182, 60, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 11
add_mapping('paired-11', [ 152, 31, 150, 70, 210, 160, 215, 208, 182, 60, 228, ]);

# SchemeType = Qualitative, ColorName = Paired, NumOfColors = 12
add_mapping('paired-12', [ 152, 31, 150, 70, 210, 160, 215, 208, 182, 60, 228, 130, ]);

# SchemeType = Qualitative, ColorName = Pastel1, NumOfColors = 3
add_mapping('pastel1-3', [ 217, 152, 252, ]);

# SchemeType = Qualitative, ColorName = Pastel1, NumOfColors = 4
add_mapping('pastel1-4', [ 217, 152, 252, 253, ]);

# SchemeType = Qualitative, ColorName = Pastel1, NumOfColors = 5
add_mapping('pastel1-5', [ 217, 152, 252, 253, 223, ]);

# SchemeType = Qualitative, ColorName = Pastel1, NumOfColors = 6
add_mapping('pastel1-6', [ 217, 152, 252, 253, 223, 230, ]);

# SchemeType = Qualitative, ColorName = Pastel1, NumOfColors = 7
add_mapping('pastel1-7', [ 217, 152, 252, 253, 223, 230, 187, ]);

# SchemeType = Qualitative, ColorName = Pastel1, NumOfColors = 8
add_mapping('pastel1-8', [ 217, 152, 252, 253, 223, 230, 187, 225, ]);

# SchemeType = Qualitative, ColorName = Pastel1, NumOfColors = 9
add_mapping('pastel1-9', [ 217, 152, 252, 253, 223, 230, 187, 225, 255, ]);

# SchemeType = Qualitative, ColorName = Pastel2, NumOfColors = 3
add_mapping('pastel2-3', [ 152, 223, 188, ]);

# SchemeType = Qualitative, ColorName = Pastel2, NumOfColors = 4
add_mapping('pastel2-4', [ 152, 223, 188, 224, ]);

# SchemeType = Qualitative, ColorName = Pastel2, NumOfColors = 5
add_mapping('pastel2-5', [ 152, 223, 188, 224, 194, ]);

# SchemeType = Qualitative, ColorName = Pastel2, NumOfColors = 6
add_mapping('pastel2-6', [ 152, 223, 188, 224, 194, 229, ]);

# SchemeType = Qualitative, ColorName = Pastel2, NumOfColors = 7
add_mapping('pastel2-7', [ 152, 223, 188, 224, 194, 229, 224, ]);

# SchemeType = Qualitative, ColorName = Pastel2, NumOfColors = 8
add_mapping('pastel2-8', [ 152, 223, 188, 224, 194, 229, 224, 252, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 3
add_mapping('piyg-3', [ 182, 231, 149, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 4
add_mapping('piyg-4', [ 162, 218, 150, 70, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 5
add_mapping('piyg-5', [ 162, 218, 231, 150, 70, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 6
add_mapping('piyg-6', [ 162, 182, 225, 194, 149, 64, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 7
add_mapping('piyg-7', [ 162, 182, 225, 231, 194, 149, 64, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 8
add_mapping('piyg-8', [ 162, 175, 218, 225, 194, 150, 107, 64, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 9
add_mapping('piyg-9', [ 162, 175, 218, 225, 231, 194, 150, 107, 64, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 10
add_mapping('piyg-10', [ 89, 162, 175, 218, 225, 194, 150, 107, 64, 22, ]);

# SchemeType = Diverging, ColorName = PiYG, NumOfColors = 11
add_mapping('piyg-11', [ 89, 162, 175, 218, 225, 231, 194, 150, 107, 64, 22, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 3
add_mapping('prgn-3', [ 139, 231, 108, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 4
add_mapping('prgn-4', [ 96, 146, 151, 29, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 5
add_mapping('prgn-5', [ 96, 146, 231, 151, 29, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 6
add_mapping('prgn-6', [ 5, 139, 254, 194, 108, 29, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 7
add_mapping('prgn-7', [ 5, 139, 254, 231, 194, 108, 29, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 8
add_mapping('prgn-8', [ 5, 97, 146, 254, 194, 151, 71, 29, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 9
add_mapping('prgn-9', [ 5, 97, 146, 254, 231, 194, 151, 71, 29, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 10
add_mapping('prgn-10', [ 53, 5, 97, 146, 254, 194, 151, 71, 29, 22, ]);

# SchemeType = Diverging, ColorName = PRGn, NumOfColors = 11
add_mapping('prgn-11', [ 53, 5, 97, 146, 254, 231, 194, 151, 71, 29, 22, ]);

# SchemeType = Sequential, ColorName = PuBu, NumOfColors = 3
add_mapping('pubu-3', [ 255, 146, 31, ]);

# SchemeType = Sequential, ColorName = PuBu, NumOfColors = 4
add_mapping('pubu-4', [ 255, 152, 110, 25, ]);

# SchemeType = Sequential, ColorName = PuBu, NumOfColors = 5
add_mapping('pubu-5', [ 255, 152, 110, 31, 24, ]);

# SchemeType = Sequential, ColorName = PuBu, NumOfColors = 6
add_mapping('pubu-6', [ 255, 252, 146, 110, 31, 24, ]);

# SchemeType = Sequential, ColorName = PuBu, NumOfColors = 7
add_mapping('pubu-7', [ 255, 252, 146, 110, 67, 25, 24, ]);

# SchemeType = Sequential, ColorName = PuBu, NumOfColors = 8
add_mapping('pubu-8', [ 231, 255, 252, 146, 110, 67, 25, 24, ]);

# SchemeType = Sequential, ColorName = PuBu, NumOfColors = 9
add_mapping('pubu-9', [ 231, 255, 252, 146, 110, 67, 25, 24, 23, ]);

# SchemeType = Sequential, ColorName = PuBuGn, NumOfColors = 3
add_mapping('pubugn-3', [ 255, 146, 30, ]);

# SchemeType = Sequential, ColorName = PuBuGn, NumOfColors = 4
add_mapping('pubugn-4', [ 255, 152, 74, 30, ]);

# SchemeType = Sequential, ColorName = PuBuGn, NumOfColors = 5
add_mapping('pubugn-5', [ 255, 152, 74, 30, 23, ]);

# SchemeType = Sequential, ColorName = PuBuGn, NumOfColors = 6
add_mapping('pubugn-6', [ 255, 252, 146, 74, 30, 23, ]);

# SchemeType = Sequential, ColorName = PuBuGn, NumOfColors = 7
add_mapping('pubugn-7', [ 255, 252, 146, 74, 67, 30, 23, ]);

# SchemeType = Sequential, ColorName = PuBuGn, NumOfColors = 8
add_mapping('pubugn-8', [ 231, 255, 252, 146, 74, 67, 30, 23, ]);

# SchemeType = Sequential, ColorName = PuBuGn, NumOfColors = 9
add_mapping('pubugn-9', [ 231, 255, 252, 146, 74, 67, 30, 23, 23, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 3
add_mapping('puor-3', [ 215, 231, 103, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 4
add_mapping('puor-4', [ 166, 215, 146, 60, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 5
add_mapping('puor-5', [ 166, 215, 231, 146, 60, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 6
add_mapping('puor-6', [ 130, 215, 223, 253, 103, 54, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 7
add_mapping('puor-7', [ 130, 215, 223, 231, 253, 103, 54, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 8
add_mapping('puor-8', [ 130, 172, 215, 223, 253, 146, 97, 54, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 9
add_mapping('puor-9', [ 130, 172, 215, 223, 231, 253, 146, 97, 54, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 10
add_mapping('puor-10', [ 94, 130, 172, 215, 223, 253, 146, 97, 54, 17, ]);

# SchemeType = Diverging, ColorName = PuOr, NumOfColors = 11
add_mapping('puor-11', [ 94, 130, 172, 215, 223, 231, 253, 146, 97, 54, 17, ]);

# SchemeType = Sequential, ColorName = PuRd, NumOfColors = 3
add_mapping('purd-3', [ 254, 176, 162, ]);

# SchemeType = Sequential, ColorName = PuRd, NumOfColors = 4
add_mapping('purd-4', [ 255, 182, 169, 161, ]);

# SchemeType = Sequential, ColorName = PuRd, NumOfColors = 5
add_mapping('purd-5', [ 255, 182, 169, 162, 89, ]);

# SchemeType = Sequential, ColorName = PuRd, NumOfColors = 6
add_mapping('purd-6', [ 255, 182, 176, 169, 162, 89, ]);

# SchemeType = Sequential, ColorName = PuRd, NumOfColors = 7
add_mapping('purd-7', [ 255, 182, 176, 169, 162, 161, 89, ]);

# SchemeType = Sequential, ColorName = PuRd, NumOfColors = 8
add_mapping('purd-8', [ 231, 254, 182, 176, 169, 162, 161, 89, ]);

# SchemeType = Sequential, ColorName = PuRd, NumOfColors = 9
add_mapping('purd-9', [ 231, 254, 182, 176, 169, 162, 161, 89, 52, ]);

# SchemeType = Sequential, ColorName = Purples, NumOfColors = 3
add_mapping('purples-3', [ 255, 146, 97, ]);

# SchemeType = Sequential, ColorName = Purples, NumOfColors = 4
add_mapping('purples-4', [ 255, 252, 247, 61, ]);

# SchemeType = Sequential, ColorName = Purples, NumOfColors = 5
add_mapping('purples-5', [ 255, 252, 247, 97, 54, ]);

# SchemeType = Sequential, ColorName = Purples, NumOfColors = 6
add_mapping('purples-6', [ 255, 253, 146, 247, 97, 54, ]);

# SchemeType = Sequential, ColorName = Purples, NumOfColors = 7
add_mapping('purples-7', [ 255, 253, 146, 247, 103, 61, 54, ]);

# SchemeType = Sequential, ColorName = Purples, NumOfColors = 8
add_mapping('purples-8', [ 231, 255, 253, 146, 247, 103, 61, 54, ]);

# SchemeType = Sequential, ColorName = Purples, NumOfColors = 9
add_mapping('purples-9', [ 231, 255, 253, 146, 247, 103, 61, 54, 54, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 3
add_mapping('rdbu-3', [ 209, 231, 74, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 4
add_mapping('rdbu-4', [ 160, 216, 116, 25, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 5
add_mapping('rdbu-5', [ 160, 216, 231, 116, 25, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 6
add_mapping('rdbu-6', [ 124, 209, 224, 254, 74, 25, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 7
add_mapping('rdbu-7', [ 124, 209, 224, 231, 254, 74, 25, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 8
add_mapping('rdbu-8', [ 124, 167, 216, 224, 254, 116, 67, 25, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 9
add_mapping('rdbu-9', [ 124, 167, 216, 224, 231, 254, 116, 67, 25, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 10
add_mapping('rdbu-10', [ 52, 124, 167, 216, 224, 254, 116, 67, 25, 23, ]);

# SchemeType = Diverging, ColorName = RdBu, NumOfColors = 11
add_mapping('rdbu-11', [ 52, 124, 167, 216, 224, 231, 254, 116, 67, 25, 23, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 3
add_mapping('rdgy-3', [ 209, 231, 246, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 4
add_mapping('rdgy-4', [ 160, 216, 250, 238, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 5
add_mapping('rdgy-5', [ 160, 216, 231, 250, 238, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 6
add_mapping('rdgy-6', [ 124, 209, 224, 254, 246, 239, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 7
add_mapping('rdgy-7', [ 124, 209, 224, 231, 254, 246, 239, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 8
add_mapping('rdgy-8', [ 124, 167, 216, 224, 254, 250, 102, 239, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 9
add_mapping('rdgy-9', [ 124, 167, 216, 224, 231, 254, 250, 102, 239, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 10
add_mapping('rdgy-10', [ 52, 124, 167, 216, 224, 254, 250, 102, 239, 234, ]);

# SchemeType = Diverging, ColorName = RdGy, NumOfColors = 11
add_mapping('rdgy-11', [ 52, 124, 167, 216, 224, 231, 254, 250, 102, 239, 234, ]);

# SchemeType = Sequential, ColorName = RdPu, NumOfColors = 3
add_mapping('rdpu-3', [ 224, 217, 162, ]);

# SchemeType = Sequential, ColorName = RdPu, NumOfColors = 4
add_mapping('rdpu-4', [ 255, 217, 205, 126, ]);

# SchemeType = Sequential, ColorName = RdPu, NumOfColors = 5
add_mapping('rdpu-5', [ 255, 217, 205, 162, 5, ]);

# SchemeType = Sequential, ColorName = RdPu, NumOfColors = 6
add_mapping('rdpu-6', [ 255, 223, 217, 205, 162, 5, ]);

# SchemeType = Sequential, ColorName = RdPu, NumOfColors = 7
add_mapping('rdpu-7', [ 255, 223, 217, 205, 168, 126, 5, ]);

# SchemeType = Sequential, ColorName = RdPu, NumOfColors = 8
add_mapping('rdpu-8', [ 231, 224, 223, 217, 205, 168, 126, 5, ]);

# SchemeType = Sequential, ColorName = RdPu, NumOfColors = 9
add_mapping('rdpu-9', [ 231, 224, 223, 217, 205, 168, 126, 5, 53, ]);

# SchemeType = Sequential, ColorName = Reds, NumOfColors = 3
add_mapping('reds-3', [ 224, 209, 160, ]);

# SchemeType = Sequential, ColorName = Reds, NumOfColors = 4
add_mapping('reds-4', [ 224, 216, 203, 160, ]);

# SchemeType = Sequential, ColorName = Reds, NumOfColors = 5
add_mapping('reds-5', [ 224, 216, 203, 160, 124, ]);

# SchemeType = Sequential, ColorName = Reds, NumOfColors = 6
add_mapping('reds-6', [ 224, 217, 209, 203, 160, 124, ]);

# SchemeType = Sequential, ColorName = Reds, NumOfColors = 7
add_mapping('reds-7', [ 224, 217, 209, 203, 202, 160, 88, ]);

# SchemeType = Sequential, ColorName = Reds, NumOfColors = 8
add_mapping('reds-8', [ 231, 224, 217, 209, 203, 202, 160, 88, ]);

# SchemeType = Sequential, ColorName = Reds, NumOfColors = 9
add_mapping('reds-9', [ 231, 224, 217, 209, 203, 202, 160, 124, 52, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 3
add_mapping('rdylbu-3', [ 209, 229, 110, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 4
add_mapping('rdylbu-4', [ 160, 215, 152, 31, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 5
add_mapping('rdylbu-5', [ 160, 215, 229, 152, 31, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 6
add_mapping('rdylbu-6', [ 166, 209, 222, 195, 110, 67, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 7
add_mapping('rdylbu-7', [ 166, 209, 222, 229, 195, 110, 67, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 8
add_mapping('rdylbu-8', [ 166, 203, 215, 222, 195, 152, 110, 67, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 9
add_mapping('rdylbu-9', [ 166, 203, 215, 222, 229, 195, 152, 110, 67, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 10
add_mapping('rdylbu-10', [ 124, 166, 203, 215, 222, 195, 152, 110, 67, 60, ]);

# SchemeType = Diverging, ColorName = RdYlBu, NumOfColors = 11
add_mapping('rdylbu-11', [ 124, 166, 203, 215, 222, 229, 195, 152, 110, 67, 60, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 3
add_mapping('rdylgn-3', [ 209, 229, 113, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 4
add_mapping('rdylgn-4', [ 160, 215, 149, 29, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 5
add_mapping('rdylgn-5', [ 160, 215, 229, 149, 29, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 6
add_mapping('rdylgn-6', [ 166, 209, 222, 192, 113, 29, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 7
add_mapping('rdylgn-7', [ 166, 209, 222, 229, 192, 113, 29, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 8
add_mapping('rdylgn-8', [ 166, 203, 215, 222, 192, 149, 71, 29, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 9
add_mapping('rdylgn-9', [ 166, 203, 215, 222, 229, 192, 149, 71, 29, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 10
add_mapping('rdylgn-10', [ 124, 166, 203, 215, 222, 192, 149, 71, 29, 23, ]);

# SchemeType = Diverging, ColorName = RdYlGn, NumOfColors = 11
add_mapping('rdylgn-11', [ 124, 166, 203, 215, 222, 229, 192, 149, 71, 29, 23, ]);

# SchemeType = Qualitative, ColorName = Set1, NumOfColors = 3
add_mapping('set1-3', [ 160, 67, 71, ]);

# SchemeType = Qualitative, ColorName = Set1, NumOfColors = 4
add_mapping('set1-4', [ 160, 67, 71, 97, ]);

# SchemeType = Qualitative, ColorName = Set1, NumOfColors = 5
add_mapping('set1-5', [ 160, 67, 71, 97, 208, ]);

# SchemeType = Qualitative, ColorName = Set1, NumOfColors = 6
add_mapping('set1-6', [ 160, 67, 71, 97, 208, 227, ]);

# SchemeType = Qualitative, ColorName = Set1, NumOfColors = 7
add_mapping('set1-7', [ 160, 67, 71, 97, 208, 227, 130, ]);

# SchemeType = Qualitative, ColorName = Set1, NumOfColors = 8
add_mapping('set1-8', [ 160, 67, 71, 97, 208, 227, 130, 211, ]);

# SchemeType = Qualitative, ColorName = Set1, NumOfColors = 9
add_mapping('set1-9', [ 160, 67, 71, 97, 208, 227, 130, 211, 246, ]);

# SchemeType = Qualitative, ColorName = Set2, NumOfColors = 3
add_mapping('set2-3', [ 73, 209, 110, ]);

# SchemeType = Qualitative, ColorName = Set2, NumOfColors = 4
add_mapping('set2-4', [ 73, 209, 110, 175, ]);

# SchemeType = Qualitative, ColorName = Set2, NumOfColors = 5
add_mapping('set2-5', [ 73, 209, 110, 175, 149, ]);

# SchemeType = Qualitative, ColorName = Set2, NumOfColors = 6
add_mapping('set2-6', [ 73, 209, 110, 175, 149, 220, ]);

# SchemeType = Qualitative, ColorName = Set2, NumOfColors = 7
add_mapping('set2-7', [ 73, 209, 110, 175, 149, 220, 186, ]);

# SchemeType = Qualitative, ColorName = Set2, NumOfColors = 8
add_mapping('set2-8', [ 73, 209, 110, 175, 149, 220, 186, 249, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 3
add_mapping('set3-3', [ 116, 229, 146, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 4
add_mapping('set3-4', [ 116, 229, 146, 209, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 5
add_mapping('set3-5', [ 116, 229, 146, 209, 110, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 6
add_mapping('set3-6', [ 116, 229, 146, 209, 110, 215, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 7
add_mapping('set3-7', [ 116, 229, 146, 209, 110, 215, 149, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 8
add_mapping('set3-8', [ 116, 229, 146, 209, 110, 215, 149, 224, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 9
add_mapping('set3-9', [ 116, 229, 146, 209, 110, 215, 149, 224, 253, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 10
add_mapping('set3-10', [ 116, 229, 146, 209, 110, 215, 149, 224, 253, 139, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 11
add_mapping('set3-11', [ 116, 229, 146, 209, 110, 215, 149, 224, 253, 139, 252, ]);

# SchemeType = Qualitative, ColorName = Set3, NumOfColors = 12
add_mapping('set3-12', [ 116, 229, 146, 209, 110, 215, 149, 224, 253, 139, 252, 227, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 3
add_mapping('spectral-3', [ 209, 229, 114, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 4
add_mapping('spectral-4', [ 160, 215, 151, 31, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 5
add_mapping('spectral-5', [ 160, 215, 229, 151, 31, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 6
add_mapping('spectral-6', [ 167, 209, 222, 192, 114, 67, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 7
add_mapping('spectral-7', [ 167, 209, 222, 229, 192, 114, 67, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 8
add_mapping('spectral-8', [ 167, 203, 215, 222, 192, 151, 73, 67, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 9
add_mapping('spectral-9', [ 167, 203, 215, 222, 229, 192, 151, 73, 67, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 10
add_mapping('spectral-10', [ 125, 167, 203, 215, 222, 192, 151, 73, 67, 61, ]);

# SchemeType = Diverging, ColorName = Spectral, NumOfColors = 11
add_mapping('spectral-11', [ 125, 167, 203, 215, 222, 229, 192, 151, 73, 67, 61, ]);

# SchemeType = Sequential, ColorName = YlGn, NumOfColors = 3
add_mapping('ylgn-3', [ 229, 150, 71, ]);

# SchemeType = Sequential, ColorName = YlGn, NumOfColors = 4
add_mapping('ylgn-4', [ 230, 150, 114, 29, ]);

# SchemeType = Sequential, ColorName = YlGn, NumOfColors = 5
add_mapping('ylgn-5', [ 230, 150, 114, 71, 23, ]);

# SchemeType = Sequential, ColorName = YlGn, NumOfColors = 6
add_mapping('ylgn-6', [ 230, 193, 150, 114, 71, 23, ]);

# SchemeType = Sequential, ColorName = YlGn, NumOfColors = 7
add_mapping('ylgn-7', [ 230, 193, 150, 114, 71, 29, 23, ]);

# SchemeType = Sequential, ColorName = YlGn, NumOfColors = 8
add_mapping('ylgn-8', [ 230, 229, 193, 150, 114, 71, 29, 23, ]);

# SchemeType = Sequential, ColorName = YlGn, NumOfColors = 9
add_mapping('ylgn-9', [ 230, 229, 193, 150, 114, 71, 29, 23, 22, ]);

# SchemeType = Sequential, ColorName = YlGnBu, NumOfColors = 3
add_mapping('ylgnbu-3', [ 229, 115, 31, ]);

# SchemeType = Sequential, ColorName = YlGnBu, NumOfColors = 4
add_mapping('ylgnbu-4', [ 230, 151, 74, 25, ]);

# SchemeType = Sequential, ColorName = YlGnBu, NumOfColors = 5
add_mapping('ylgnbu-5', [ 230, 151, 74, 31, 24, ]);

# SchemeType = Sequential, ColorName = YlGnBu, NumOfColors = 6
add_mapping('ylgnbu-6', [ 230, 187, 115, 74, 31, 24, ]);

# SchemeType = Sequential, ColorName = YlGnBu, NumOfColors = 7
add_mapping('ylgnbu-7', [ 230, 187, 115, 74, 31, 25, 18, ]);

# SchemeType = Sequential, ColorName = YlGnBu, NumOfColors = 8
add_mapping('ylgnbu-8', [ 230, 229, 187, 115, 74, 31, 25, 18, ]);

# SchemeType = Sequential, ColorName = YlGnBu, NumOfColors = 9
add_mapping('ylgnbu-9', [ 230, 229, 187, 115, 74, 31, 25, 24, 17, ]);

# SchemeType = Sequential, ColorName = YlOrBr, NumOfColors = 3
add_mapping('ylorbr-3', [ 229, 221, 166, ]);

# SchemeType = Sequential, ColorName = YlOrBr, NumOfColors = 4
add_mapping('ylorbr-4', [ 230, 222, 208, 166, ]);

# SchemeType = Sequential, ColorName = YlOrBr, NumOfColors = 5
add_mapping('ylorbr-5', [ 230, 222, 208, 166, 94, ]);

# SchemeType = Sequential, ColorName = YlOrBr, NumOfColors = 6
add_mapping('ylorbr-6', [ 230, 222, 221, 208, 166, 94, ]);

# SchemeType = Sequential, ColorName = YlOrBr, NumOfColors = 7
add_mapping('ylorbr-7', [ 230, 222, 221, 208, 202, 166, 88, ]);

# SchemeType = Sequential, ColorName = YlOrBr, NumOfColors = 8
add_mapping('ylorbr-8', [ 230, 229, 222, 221, 208, 202, 166, 88, ]);

# SchemeType = Sequential, ColorName = YlOrBr, NumOfColors = 9
add_mapping('ylorbr-9', [ 230, 229, 222, 221, 208, 202, 166, 94, 52, ]);

# SchemeType = Sequential, ColorName = YlOrRd, NumOfColors = 3
add_mapping('ylorrd-3', [ 229, 215, 202, ]);

# SchemeType = Sequential, ColorName = YlOrRd, NumOfColors = 4
add_mapping('ylorrd-4', [ 229, 221, 209, 160, ]);

# SchemeType = Sequential, ColorName = YlOrRd, NumOfColors = 5
add_mapping('ylorrd-5', [ 229, 221, 209, 202, 124, ]);

# SchemeType = Sequential, ColorName = YlOrRd, NumOfColors = 6
add_mapping('ylorrd-6', [ 229, 222, 215, 209, 202, 124, ]);

# SchemeType = Sequential, ColorName = YlOrRd, NumOfColors = 7
add_mapping('ylorrd-7', [ 229, 222, 215, 209, 202, 160, 124, ]);

# SchemeType = Sequential, ColorName = YlOrRd, NumOfColors = 8
add_mapping('ylorrd-8', [ 230, 229, 222, 215, 209, 202, 160, 124, ]);

# SchemeType = Sequential, ColorName = YlOrRd, NumOfColors = 9
add_mapping('ylorrd-9', [ 230, 229, 222, 215, 209, 202, 160, 124, 1, ]);

### Generated by running create_brewer_mapping ../ColorBrewer_all_schemes_RGBonly3.csv

=head1 NAME Term::Colormap::Brewer

=head1 VERSION

Version 0.19

=head1 SYNOPSIS

Provide the Brewer colormaps.

    use Term::Colormap qw( colormap colorbar print_colored );
    use Term::Colormap::Brewer;

    my $accent = colormap('accent-3');

    colorbar($accent);

    print_colored( $accent->[3], "some color" )';

=head1 CITATION

Colors from www.ColorBrewer.org by Cynthia A. Brewer, Geography, Pennsylvania State University.

=head1 AVAILABLE COLORMAPS

    accent-3     - Qualitative, Accent, 3 colors
    accent-4     - Qualitative, Accent, 4 colors
    accent-5     - Qualitative, Accent, 5 colors
    accent-6     - Qualitative, Accent, 6 colors
    accent-7     - Qualitative, Accent, 7 colors
    accent-8     - Qualitative, Accent, 8 colors
    blues-3      - Sequential, Blues, 3 colors
    blues-4      - Sequential, Blues, 4 colors
    blues-5      - Sequential, Blues, 5 colors
    blues-6      - Sequential, Blues, 6 colors
    blues-7      - Sequential, Blues, 7 colors
    blues-8      - Sequential, Blues, 8 colors
    blues-9      - Sequential, Blues, 9 colors
    brbg-3       - Diverging, BrBG, 3 colors
    brbg-4       - Diverging, BrBG, 4 colors
    brbg-5       - Diverging, BrBG, 5 colors
    brbg-6       - Diverging, BrBG, 6 colors
    brbg-7       - Diverging, BrBG, 7 colors
    brbg-8       - Diverging, BrBG, 8 colors
    brbg-9       - Diverging, BrBG, 9 colors
    brbg-10      - Diverging, BrBG, 10 colors
    brbg-11      - Diverging, BrBG, 11 colors
    bugn-3       - Sequential, BuGn, 3 colors
    bugn-4       - Sequential, BuGn, 4 colors
    bugn-5       - Sequential, BuGn, 5 colors
    bugn-6       - Sequential, BuGn, 6 colors
    bugn-7       - Sequential, BuGn, 7 colors
    bugn-8       - Sequential, BuGn, 8 colors
    bugn-9       - Sequential, BuGn, 9 colors
    bupu-3       - Sequential, BuPu, 3 colors
    bupu-4       - Sequential, BuPu, 4 colors
    bupu-5       - Sequential, BuPu, 5 colors
    bupu-6       - Sequential, BuPu, 6 colors
    bupu-7       - Sequential, BuPu, 7 colors
    bupu-8       - Sequential, BuPu, 8 colors
    bupu-9       - Sequential, BuPu, 9 colors
    dark2-3      - Qualitative, Dark2, 3 colors
    dark2-4      - Qualitative, Dark2, 4 colors
    dark2-5      - Qualitative, Dark2, 5 colors
    dark2-6      - Qualitative, Dark2, 6 colors
    dark2-7      - Qualitative, Dark2, 7 colors
    dark2-8      - Qualitative, Dark2, 8 colors
    gnbu-3       - Sequential, GnBu, 3 colors
    gnbu-4       - Sequential, GnBu, 4 colors
    gnbu-5       - Sequential, GnBu, 5 colors
    gnbu-6       - Sequential, GnBu, 6 colors
    gnbu-7       - Sequential, GnBu, 7 colors
    gnbu-8       - Sequential, GnBu, 8 colors
    gnbu-9       - Sequential, GnBu, 9 colors
    greens-3     - Sequential, Greens, 3 colors
    greens-4     - Sequential, Greens, 4 colors
    greens-5     - Sequential, Greens, 5 colors
    greens-6     - Sequential, Greens, 6 colors
    greens-7     - Sequential, Greens, 7 colors
    greens-8     - Sequential, Greens, 8 colors
    greens-9     - Sequential, Greens, 9 colors
    greys-3      - Sequential, Greys, 3 colors
    greys-4      - Sequential, Greys, 4 colors
    greys-5      - Sequential, Greys, 5 colors
    greys-6      - Sequential, Greys, 6 colors
    greys-7      - Sequential, Greys, 7 colors
    greys-8      - Sequential, Greys, 8 colors
    greys-9      - Sequential, Greys, 9 colors
    oranges-3    - Sequential, Oranges, 3 colors
    oranges-4    - Sequential, Oranges, 4 colors
    oranges-5    - Sequential, Oranges, 5 colors
    oranges-6    - Sequential, Oranges, 6 colors
    oranges-7    - Sequential, Oranges, 7 colors
    oranges-8    - Sequential, Oranges, 8 colors
    oranges-9    - Sequential, Oranges, 9 colors
    orrd-3       - Sequential, OrRd, 3 colors
    orrd-4       - Sequential, OrRd, 4 colors
    orrd-5       - Sequential, OrRd, 5 colors
    orrd-6       - Sequential, OrRd, 6 colors
    orrd-7       - Sequential, OrRd, 7 colors
    orrd-8       - Sequential, OrRd, 8 colors
    orrd-9       - Sequential, OrRd, 9 colors
    paired-3     - Qualitative, Paired, 3 colors
    paired-4     - Qualitative, Paired, 4 colors
    paired-5     - Qualitative, Paired, 5 colors
    paired-6     - Qualitative, Paired, 6 colors
    paired-7     - Qualitative, Paired, 7 colors
    paired-8     - Qualitative, Paired, 8 colors
    paired-9     - Qualitative, Paired, 9 colors
    paired-10    - Qualitative, Paired, 10 colors
    paired-11    - Qualitative, Paired, 11 colors
    paired-12    - Qualitative, Paired, 12 colors
    pastel1-3    - Qualitative, Pastel1, 3 colors
    pastel1-4    - Qualitative, Pastel1, 4 colors
    pastel1-5    - Qualitative, Pastel1, 5 colors
    pastel1-6    - Qualitative, Pastel1, 6 colors
    pastel1-7    - Qualitative, Pastel1, 7 colors
    pastel1-8    - Qualitative, Pastel1, 8 colors
    pastel1-9    - Qualitative, Pastel1, 9 colors
    pastel2-3    - Qualitative, Pastel2, 3 colors
    pastel2-4    - Qualitative, Pastel2, 4 colors
    pastel2-5    - Qualitative, Pastel2, 5 colors
    pastel2-6    - Qualitative, Pastel2, 6 colors
    pastel2-7    - Qualitative, Pastel2, 7 colors
    pastel2-8    - Qualitative, Pastel2, 8 colors
    piyg-3       - Diverging, PiYG, 3 colors
    piyg-4       - Diverging, PiYG, 4 colors
    piyg-5       - Diverging, PiYG, 5 colors
    piyg-6       - Diverging, PiYG, 6 colors
    piyg-7       - Diverging, PiYG, 7 colors
    piyg-8       - Diverging, PiYG, 8 colors
    piyg-9       - Diverging, PiYG, 9 colors
    piyg-10      - Diverging, PiYG, 10 colors
    piyg-11      - Diverging, PiYG, 11 colors
    prgn-3       - Diverging, PRGn, 3 colors
    prgn-4       - Diverging, PRGn, 4 colors
    prgn-5       - Diverging, PRGn, 5 colors
    prgn-6       - Diverging, PRGn, 6 colors
    prgn-7       - Diverging, PRGn, 7 colors
    prgn-8       - Diverging, PRGn, 8 colors
    prgn-9       - Diverging, PRGn, 9 colors
    prgn-10      - Diverging, PRGn, 10 colors
    prgn-11      - Diverging, PRGn, 11 colors
    pubu-3       - Sequential, PuBu, 3 colors
    pubu-4       - Sequential, PuBu, 4 colors
    pubu-5       - Sequential, PuBu, 5 colors
    pubu-6       - Sequential, PuBu, 6 colors
    pubu-7       - Sequential, PuBu, 7 colors
    pubu-8       - Sequential, PuBu, 8 colors
    pubu-9       - Sequential, PuBu, 9 colors
    pubugn-3     - Sequential, PuBuGn, 3 colors
    pubugn-4     - Sequential, PuBuGn, 4 colors
    pubugn-5     - Sequential, PuBuGn, 5 colors
    pubugn-6     - Sequential, PuBuGn, 6 colors
    pubugn-7     - Sequential, PuBuGn, 7 colors
    pubugn-8     - Sequential, PuBuGn, 8 colors
    pubugn-9     - Sequential, PuBuGn, 9 colors
    puor-3       - Diverging, PuOr, 3 colors
    puor-4       - Diverging, PuOr, 4 colors
    puor-5       - Diverging, PuOr, 5 colors
    puor-6       - Diverging, PuOr, 6 colors
    puor-7       - Diverging, PuOr, 7 colors
    puor-8       - Diverging, PuOr, 8 colors
    puor-9       - Diverging, PuOr, 9 colors
    puor-10      - Diverging, PuOr, 10 colors
    puor-11      - Diverging, PuOr, 11 colors
    purd-3       - Sequential, PuRd, 3 colors
    purd-4       - Sequential, PuRd, 4 colors
    purd-5       - Sequential, PuRd, 5 colors
    purd-6       - Sequential, PuRd, 6 colors
    purd-7       - Sequential, PuRd, 7 colors
    purd-8       - Sequential, PuRd, 8 colors
    purd-9       - Sequential, PuRd, 9 colors
    purples-3    - Sequential, Purples, 3 colors
    purples-4    - Sequential, Purples, 4 colors
    purples-5    - Sequential, Purples, 5 colors
    purples-6    - Sequential, Purples, 6 colors
    purples-7    - Sequential, Purples, 7 colors
    purples-8    - Sequential, Purples, 8 colors
    purples-9    - Sequential, Purples, 9 colors
    rdbu-3       - Diverging, RdBu, 3 colors
    rdbu-4       - Diverging, RdBu, 4 colors
    rdbu-5       - Diverging, RdBu, 5 colors
    rdbu-6       - Diverging, RdBu, 6 colors
    rdbu-7       - Diverging, RdBu, 7 colors
    rdbu-8       - Diverging, RdBu, 8 colors
    rdbu-9       - Diverging, RdBu, 9 colors
    rdbu-10      - Diverging, RdBu, 10 colors
    rdbu-11      - Diverging, RdBu, 11 colors
    rdgy-3       - Diverging, RdGy, 3 colors
    rdgy-4       - Diverging, RdGy, 4 colors
    rdgy-5       - Diverging, RdGy, 5 colors
    rdgy-6       - Diverging, RdGy, 6 colors
    rdgy-7       - Diverging, RdGy, 7 colors
    rdgy-8       - Diverging, RdGy, 8 colors
    rdgy-9       - Diverging, RdGy, 9 colors
    rdgy-10      - Diverging, RdGy, 10 colors
    rdgy-11      - Diverging, RdGy, 11 colors
    rdpu-3       - Sequential, RdPu, 3 colors
    rdpu-4       - Sequential, RdPu, 4 colors
    rdpu-5       - Sequential, RdPu, 5 colors
    rdpu-6       - Sequential, RdPu, 6 colors
    rdpu-7       - Sequential, RdPu, 7 colors
    rdpu-8       - Sequential, RdPu, 8 colors
    rdpu-9       - Sequential, RdPu, 9 colors
    reds-3       - Sequential, Reds, 3 colors
    reds-4       - Sequential, Reds, 4 colors
    reds-5       - Sequential, Reds, 5 colors
    reds-6       - Sequential, Reds, 6 colors
    reds-7       - Sequential, Reds, 7 colors
    reds-8       - Sequential, Reds, 8 colors
    reds-9       - Sequential, Reds, 9 colors
    rdylbu-3     - Diverging, RdYlBu, 3 colors
    rdylbu-4     - Diverging, RdYlBu, 4 colors
    rdylbu-5     - Diverging, RdYlBu, 5 colors
    rdylbu-6     - Diverging, RdYlBu, 6 colors
    rdylbu-7     - Diverging, RdYlBu, 7 colors
    rdylbu-8     - Diverging, RdYlBu, 8 colors
    rdylbu-9     - Diverging, RdYlBu, 9 colors
    rdylbu-10    - Diverging, RdYlBu, 10 colors
    rdylbu-11    - Diverging, RdYlBu, 11 colors
    rdylgn-3     - Diverging, RdYlGn, 3 colors
    rdylgn-4     - Diverging, RdYlGn, 4 colors
    rdylgn-5     - Diverging, RdYlGn, 5 colors
    rdylgn-6     - Diverging, RdYlGn, 6 colors
    rdylgn-7     - Diverging, RdYlGn, 7 colors
    rdylgn-8     - Diverging, RdYlGn, 8 colors
    rdylgn-9     - Diverging, RdYlGn, 9 colors
    rdylgn-10    - Diverging, RdYlGn, 10 colors
    rdylgn-11    - Diverging, RdYlGn, 11 colors
    set1-3       - Qualitative, Set1, 3 colors
    set1-4       - Qualitative, Set1, 4 colors
    set1-5       - Qualitative, Set1, 5 colors
    set1-6       - Qualitative, Set1, 6 colors
    set1-7       - Qualitative, Set1, 7 colors
    set1-8       - Qualitative, Set1, 8 colors
    set1-9       - Qualitative, Set1, 9 colors
    set2-3       - Qualitative, Set2, 3 colors
    set2-4       - Qualitative, Set2, 4 colors
    set2-5       - Qualitative, Set2, 5 colors
    set2-6       - Qualitative, Set2, 6 colors
    set2-7       - Qualitative, Set2, 7 colors
    set2-8       - Qualitative, Set2, 8 colors
    set3-3       - Qualitative, Set3, 3 colors
    set3-4       - Qualitative, Set3, 4 colors
    set3-5       - Qualitative, Set3, 5 colors
    set3-6       - Qualitative, Set3, 6 colors
    set3-7       - Qualitative, Set3, 7 colors
    set3-8       - Qualitative, Set3, 8 colors
    set3-9       - Qualitative, Set3, 9 colors
    set3-10      - Qualitative, Set3, 10 colors
    set3-11      - Qualitative, Set3, 11 colors
    set3-12      - Qualitative, Set3, 12 colors
    spectral-3   - Diverging, Spectral, 3 colors
    spectral-4   - Diverging, Spectral, 4 colors
    spectral-5   - Diverging, Spectral, 5 colors
    spectral-6   - Diverging, Spectral, 6 colors
    spectral-7   - Diverging, Spectral, 7 colors
    spectral-8   - Diverging, Spectral, 8 colors
    spectral-9   - Diverging, Spectral, 9 colors
    spectral-10  - Diverging, Spectral, 10 colors
    spectral-11  - Diverging, Spectral, 11 colors
    ylgn-3       - Sequential, YlGn, 3 colors
    ylgn-4       - Sequential, YlGn, 4 colors
    ylgn-5       - Sequential, YlGn, 5 colors
    ylgn-6       - Sequential, YlGn, 6 colors
    ylgn-7       - Sequential, YlGn, 7 colors
    ylgn-8       - Sequential, YlGn, 8 colors
    ylgn-9       - Sequential, YlGn, 9 colors
    ylgnbu-3     - Sequential, YlGnBu, 3 colors
    ylgnbu-4     - Sequential, YlGnBu, 4 colors
    ylgnbu-5     - Sequential, YlGnBu, 5 colors
    ylgnbu-6     - Sequential, YlGnBu, 6 colors
    ylgnbu-7     - Sequential, YlGnBu, 7 colors
    ylgnbu-8     - Sequential, YlGnBu, 8 colors
    ylgnbu-9     - Sequential, YlGnBu, 9 colors
    ylorbr-3     - Sequential, YlOrBr, 3 colors
    ylorbr-4     - Sequential, YlOrBr, 4 colors
    ylorbr-5     - Sequential, YlOrBr, 5 colors
    ylorbr-6     - Sequential, YlOrBr, 6 colors
    ylorbr-7     - Sequential, YlOrBr, 7 colors
    ylorbr-8     - Sequential, YlOrBr, 8 colors
    ylorbr-9     - Sequential, YlOrBr, 9 colors
    ylorrd-3     - Sequential, YlOrRd, 3 colors
    ylorrd-4     - Sequential, YlOrRd, 4 colors
    ylorrd-5     - Sequential, YlOrRd, 5 colors
    ylorrd-6     - Sequential, YlOrRd, 6 colors
    ylorrd-7     - Sequential, YlOrRd, 7 colors
    ylorrd-8     - Sequential, YlOrRd, 8 colors
    ylorrd-9     - Sequential, YlOrRd, 9 colors

=head1 AUTHOR

=head1 What do they look like?

    Run the show_brewer_colormap script to display them in your terminal.

Felix Tubiana, C<< <felixtubiana at gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-term-colormap at rt.cpan.org>,
or through the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Term-Colormap>.
I will be notified, and then you'll automatically be notified of progress on your bug
as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Term::Colormap::Brewer

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Term-Colormap>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Term-Colormap>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Term-Colormap>

=item * Search CPAN

L<http://search.cpan.org/dist/Term-Colormap/>

=back


=head1 ACKNOWLEDGEMENTS

Inspired by Term::ANSIColor


=head1 LICENSE AND COPYRIGHT

Copyright 2017 Felix Tubiana.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=cut

