use strict;
use warnings;
use Test::More;

use Git::Version::Compare qw( cmp_git );

plan tests => 2;

is_deeply(
    [
        sort cmp_git qw(
          1.7.4.rc1 1.9.3 1.7.0.rc0 2.0.0.rc2 1.2.3 1.8.3.4 1.7.1.3 1.8.2.1
          2.3.0.rc1 2.0.0.rc1 1.7.12.rc0 1.6.3.rc1 1.4.3.3 2.0.3
          )
    ],
    [
        qw(
          1.2.3 1.4.3.3 1.6.3.rc1 1.7.0.rc0 1.7.1.3 1.7.4.rc1 1.7.12.rc0
          1.8.2.1 1.8.3.4 1.9.3 2.0.0.rc1 2.0.0.rc2 2.0.3 2.3.0.rc1
          )
    ],
    'cmp_git'
);

# the 0.99 series
is_deeply(
    [
        sort cmp_git qw(
          1.0.rc2 0.99.7a 0.99.8d 0.99.7c 0.99.4  0.99.9c 0.99.9g 0.99.8c
          0.99.9  1.0.rc3 0.99.9i 0.99.9d 0.99.9b 0.99.9l 1.0.rc1 0.99.1
          1.0.rc4 0.99.5  0.99.8e 0.99.3  0.99    0.99.9k 0.99.8f 1.0.rc5
          0.99.9n 0.99.7d 0.99.9h 0.99.8  1.0.rc6 0.99.7  0.99.9m 0.99.9a
          0.99.8b 0.99.8a 0.99.9e 0.99.9j 0.99.7b 1.0.0   0.99.8g 0.99.9f
          0.99.2 0.99.6
          0.99.9.GIT
          )
    ],
    [    # sort is stable, so identical items stay in the same order
        qw(
          0.99    0.99.1  0.99.2  0.99.3  0.99.4  0.99.5  0.99.6
          0.99.7  0.99.7a 0.99.7b 0.99.7c 0.99.7d 0.99.8  0.99.8a
          0.99.8b 0.99.8c 0.99.8d 0.99.8e 0.99.8f 0.99.8g 0.99.9
          0.99.9.GIT
          0.99.9a 0.99.9b 0.99.9c 0.99.9d 0.99.9e 0.99.9f 0.99.9g
          1.0.rc1 0.99.9h 1.0.rc2 0.99.9i 1.0.rc3 0.99.9j 0.99.9k
          0.99.9l 1.0.rc4 1.0.rc5 0.99.9m 0.99.9n 1.0.rc6 1.0.0
          )

    ],
    'cmp_git (0.99 series)'
);
