/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.DataInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type2CharStringParser {
    private DataInput input = null;
    private int hstemCount = 0;
    private int vstemCount = 0;
    private List<Object> sequence = null;

    public List<Object> parse(byte[] bytes) throws IOException {
        this.input = new DataInput(bytes);
        this.hstemCount = 0;
        this.vstemCount = 0;
        this.sequence = new ArrayList<Object>();
        while (this.input.hasRemaining()) {
            int b0 = this.input.readUnsignedByte();
            if (b0 >= 0 && b0 <= 27) {
                this.sequence.add(this.readCommand(b0));
                continue;
            }
            if (b0 == 28) {
                this.sequence.add(this.readNumber(b0));
                continue;
            }
            if (b0 >= 29 && b0 <= 31) {
                this.sequence.add(this.readCommand(b0));
                continue;
            }
            if (b0 >= 32 && b0 <= 255) {
                this.sequence.add(this.readNumber(b0));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this.sequence;
    }

    private CharStringCommand readCommand(int b0) throws IOException {
        if (b0 == 1 || b0 == 18) {
            this.hstemCount += this.peekNumbers().size() / 2;
        } else if (b0 == 3 || b0 == 19 || b0 == 20 || b0 == 23) {
            this.vstemCount += this.peekNumbers().size() / 2;
        }
        if (b0 == 12) {
            int b1 = this.input.readUnsignedByte();
            return new CharStringCommand(b0, b1);
        }
        if (b0 == 19 || b0 == 20) {
            int[] value = new int[1 + this.getMaskLength()];
            value[0] = b0;
            for (int i = 1; i < value.length; ++i) {
                value[i] = this.input.readUnsignedByte();
            }
            return new CharStringCommand(value);
        }
        return new CharStringCommand(b0);
    }

    private Integer readNumber(int b0) throws IOException {
        if (b0 == 28) {
            int b1 = this.input.readUnsignedByte();
            int b2 = this.input.readUnsignedByte();
            return (short)(b1 << 8 | b2);
        }
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = this.input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = this.input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        if (b0 == 255) {
            int b1 = this.input.readUnsignedByte();
            int b2 = this.input.readUnsignedByte();
            int b3 = this.input.readUnsignedByte();
            int b4 = this.input.readUnsignedByte();
            return (short)(b1 << 8 | b2);
        }
        throw new IllegalArgumentException();
    }

    private int getMaskLength() {
        int length = 1;
        int hintCount = this.hstemCount + this.vstemCount;
        while ((hintCount -= 8) > 0) {
            ++length;
        }
        return length;
    }

    private List<Number> peekNumbers() {
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (int i = this.sequence.size() - 1; i > -1; --i) {
            Object object = this.sequence.get(i);
            if (!(object instanceof Number)) {
                return numbers;
            }
            Number number = (Number)object;
            numbers.add(0, number);
        }
        return numbers;
    }
}

