/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.widget;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;

public class DisplayJAI
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected RenderedImage source = null;
    protected int originX = 0;
    protected int originY = 0;

    public DisplayJAI() {
        this.setLayout(null);
    }

    public DisplayJAI(RenderedImage renderedImage) {
        this.setLayout(null);
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        this.source = renderedImage;
        int n = this.source.getWidth();
        int n2 = this.source.getHeight();
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        this.setPreferredSize(dimension);
    }

    public void setOrigin(int n, int n2) {
        this.originX = n;
        this.originY = n2;
        this.repaint();
    }

    public Point getOrigin() {
        return new Point(this.originX, this.originY);
    }

    public void set(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null!");
        }
        this.source = renderedImage;
        int n = this.source.getWidth();
        int n2 = this.source.getHeight();
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        this.setPreferredSize(dimension);
        this.revalidate();
        this.repaint();
    }

    public void set(RenderedImage renderedImage, int n, int n2) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null!");
        }
        this.source = renderedImage;
        int n3 = this.source.getWidth();
        int n4 = this.source.getHeight();
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(n3 + insets.left + insets.right, n4 + insets.top + insets.bottom);
        this.setPreferredSize(dimension);
        this.originX = n;
        this.originY = n2;
        this.revalidate();
        this.repaint();
    }

    public RenderedImage getSource() {
        return this.source;
    }

    public synchronized void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.source == null) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = this.getInsets();
        int n = insets.left + this.originX;
        int n2 = insets.top + this.originY;
        try {
            graphics2D.drawRenderedImage(this.source, AffineTransform.getTranslateInstance(n, n2));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

