drop table messages;
create table messages (
thread varchar( 250 ),
entrytime timestamp,
fromuser varchar( 257 ),
server varchar( 342 ),
resource varchar( 250 ),
type varchar( 20 ),
subject varchar( 500 ),
body text,
errorcode int,
errordescription varchar( 500 )
);
create index threads on messages ( thread );


drop table senders;
create table senders (
JID varchar( 600 ) not null check ( JID <> '' ),
alias_in_statistics varchar( 20 ) check ( alias_in_statistics <> '' ),
update_call varchar( 100 ) check ( update_call <> '' ),
primary key ( JID )
);

drop table receivers;
create table receivers (
JID varchar( 600 ) not null check ( JID <> '' ),
alias_in_statistics char( 20) check ( alias_in_statistics <> '' ),
update_call varchar( 100 ) check ( update_call <> '' ),
primary key ( JID )
);

insert into senders ( JID, alias_in_statistics, update_call )
 values ( 's.sandy@xdash', 'sender1', 'add_to_stat_sender1_with' );

create or replace function 
 add_to_stat_sender1_with( varchar ) returns integer as '
  ----
  declare 
    v_message_thread alias for $1;
    v_query_result varchar;
  ----
  begin
    --
    -- Checking the contract with the table statistics...
    if char_length( v_message_thread ) > 250 then
	-- C error code covention 0 -> Ok, else -> something wrong.
	return 1;
    end if;
    --
    -- Checking, if this thread already exists and acting accordingly...
    select thread into v_query_result from statistics 
     where thread=v_message_thread;
    if not found then
	insert into statistics 
	 ( thread, lastupdate, starttime, sender1_occurence ) 
	 values ( v_message_thread, now(), now(), 1 );
    else
	update statistics set 
         sender1_occurence=sender1_occurence+1,
	 lastupdate=now(), 
         deltatime=age( now(), starttime ) 
         where thread=v_message_thread;
    end if;
    return 0; 
  end;        
  ----
' language 'plpgsql';

insert into receivers ( JID, alias_in_statistics, update_call )
 values ( 'r.rachel@xdash', 'receiver1', 'add_to_stat_receiver1_with' );

create or replace function 
 add_to_stat_receiver1_with( varchar, integer ) returns integer as '
  ----
  declare 
    v_message_thread alias for $1;
    v_job_result alias for $2;
    v_query_result varchar;
  ----
  begin
    --
    -- Checking the contract with the table statistics...
    if char_length( v_message_thread ) > 250 then
	-- C error code covention 0 -> Ok, else -> something wrong.
	return 1;
    end if;
    --
    -- Checking, if this thread already exists, and acting accordingly...
    select thread into v_query_result from statistics
     where thread=v_message_thread;
    if not found then
	if v_job_result = 0 then
	    insert into statistics 
	     ( thread, lastupdate, starttime, receiver1_occurence ) 
	     values ( v_message_thread, now(), now(), 1 );
	else
	    insert into statistics 
	     ( thread, lastupdate, starttime, 
	     receiver1_occurence, receiver1_result, error_counter ) 
	     values ( v_message_thread, now(), now(), 1, v_job_result, 1);
	end if;	     
    else
	if v_job_result = 0 then
	    update statistics set
	     receiver1_occurence=receiver1_occurence+1, 
	     lastupdate=now(), 
	     deltatime=age( now(), starttime ) 
	     where thread=v_message_thread;
        else
	    update statistics set 
    	     receiver1_occurence=receiver1_occurence+1,
    	     receiver1_result=v_job_result, 
    	     error_counter=error_counter+1,
    	     lastupdate=now(), 
    	     deltatime=age( now(), starttime ) 
    	     where thread=v_message_thread;	    
     	end if;	     
    end if;
    return 0; 
   end;        
   ----
' language 'plpgsql';


drop table statistics;
create table statistics ( 
thread varchar( 250 ) not null,
lastupdate timestamp,
starttime timestamp,
deltatime interval default '0 second',
sender1_occurence int not null default '0',
receiver1_occurence  int not null default '0',
receiver1_result int not null default '0',
error_counter int not null default '0',
primary key ( thread )
);