#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerDashboard::GetSellerDashboardResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerDashboardResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerDashboard::GetSellerDashboardResponseType

=head1 DESCRIPTION

Returns a brief summary of the requester's status as an eBay seller. 
This status information can help an eBay seller monitor their selling performance and
keep their account in good standing.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerDashboard::GetSellerDashboardResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::BuyerSatisfactionDashboardType;
use eBay::API::XML::DataType::PolicyComplianceDashboardType;
use eBay::API::XML::DataType::PowerSellerDashboardType;
use eBay::API::XML::DataType::SearchStandingDashboardType;
use eBay::API::XML::DataType::SellerAccountDashboardType;
use eBay::API::XML::DataType::SellerFeeDiscountDashboardType;


my @gaProperties = ( [ 'BuyerSatisfaction', 'ns:BuyerSatisfactionDashboardType', ''
	     ,'eBay::API::XML::DataType::BuyerSatisfactionDashboardType', '1' ]
	, [ 'PolicyCompliance', 'ns:PolicyComplianceDashboardType', ''
	     ,'eBay::API::XML::DataType::PolicyComplianceDashboardType', '1' ]
	, [ 'PowerSellerStatus', 'ns:PowerSellerDashboardType', ''
	     ,'eBay::API::XML::DataType::PowerSellerDashboardType', '1' ]
	, [ 'SearchStanding', 'ns:SearchStandingDashboardType', ''
	     ,'eBay::API::XML::DataType::SearchStandingDashboardType', '1' ]
	, [ 'SellerAccount', 'ns:SellerAccountDashboardType', ''
	     ,'eBay::API::XML::DataType::SellerAccountDashboardType', '1' ]
	, [ 'SellerFeeDiscount', 'ns:SellerFeeDiscountDashboardType', ''
	     ,'eBay::API::XML::DataType::SellerFeeDiscountDashboardType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBuyerSatisfaction()

Rates your level of customer service. This information helps you to keep track of 
how well you are providing members with positive buying experiences.

SeeLink: URL: http://pages.ebay.com/help/myebay/seller-dashboard.html#buyer
Title: About Your Seller Dashboard: Buyer Satisfaction
, URL: http://pages.ebay.de/help/myebay/seller-dashboard.html#buyer
Title: Zum Thema Verkufer-Cockpit: Kuferzufriedenheit


#    Argument: 'ns:BuyerSatisfactionDashboardType'

=cut

sub setBuyerSatisfaction {
  my $self = shift;
  $self->{'BuyerSatisfaction'} = shift
}

=head2 getBuyerSatisfaction()

  Returned: Conditionally
#    Returns: 'ns:BuyerSatisfactionDashboardType'

=cut

sub getBuyerSatisfaction {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyerSatisfaction'
		,'eBay::API::XML::DataType::BuyerSatisfactionDashboardType');
}


=head2 setPolicyCompliance()

Rates how well you are following eBay rules and policies in your selling,
and alerts you to any account or listing policy violations.
eBay's policies are rules and guidelines that help 
to create a safe, fair, and enjoyable trading environment for all eBay members. 
If you violate certain policies, your account may be restricted
without notice. This is true even if your status shows a good level of 
policy compliance. 
Therefore, understanding and following eBay's policies can help you to avoid 
restrictions on your account. 
Your policy compliance status directly affects your PowerSeller status.

SeeLink: URL: http://pages.ebay.com/help/myebay/seller-dashboard.html#compliance
Title: About Your Seller Dashboard: Policy Compliance
, URL: http://pages.ebay.com/help/policies/seller-rules-overview.html
Title: Rules for Sellers
, URL: http://pages.ebay.de/help/myebay/seller-dashboard.html#compliance
Title: Zum Thema Verkufer-Cockpit: Einhaltung der Grundstze


#    Argument: 'ns:PolicyComplianceDashboardType'

=cut

sub setPolicyCompliance {
  my $self = shift;
  $self->{'PolicyCompliance'} = shift
}

=head2 getPolicyCompliance()

  Returned: Conditionally
#    Returns: 'ns:PolicyComplianceDashboardType'

=cut

sub getPolicyCompliance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PolicyCompliance'
		,'eBay::API::XML::DataType::PolicyComplianceDashboardType');
}


=head2 setPowerSellerStatus()

Provides information about your PowerSeller status, such as whether you meet 
PowerSeller requirements. Your PowerSeller status directly affects your discount
(SellerFeeDiscount). (For eBay Germany and France, you must be a registered 
business seller to see your PowerSeller status.)

SeeLink: URL: http://pages.ebay.com/help/myebay/seller-dashboard.html#status
Title: About Your Seller Dashboard: PowerSeller Status
, URL: http://pages.ebay.com/services/buyandsell/welcome.html
Title: PowerSeller Benefits and Requirements
, URL: http://pages.ebay.de/help/myebay/seller-dashboard.html#status
Title: Zum Thema Verkufer-Cockpit: PowerSeller-Status


#    Argument: 'ns:PowerSellerDashboardType'

=cut

sub setPowerSellerStatus {
  my $self = shift;
  $self->{'PowerSellerStatus'} = shift
}

=head2 getPowerSellerStatus()

  Returned: Conditionally
#    Returns: 'ns:PowerSellerDashboardType'

=cut

sub getPowerSellerStatus {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PowerSellerStatus'
		,'eBay::API::XML::DataType::PowerSellerDashboardType');
}


=head2 setSearchStanding()

Provides information about the visibility level you've earned for your listings. 
When you have a better search standing, your listings may receive higher 
placement in search results that are sorted by Best Match.
Because it is directly tied to your customer service, search standing 
is an important way for eBay to reward you as a good seller, 
and to encourage you to give buyers the best possible shopping experience.

SeeLink: URL: http://pages.ebay.com/help/myebay/seller-dashboard.html#standing
Title: About Your Seller Dashboard: Search Standing
, URL: http://pages.ebay.de/help/myebay/seller-dashboard.html#standing
Title: Zum Thema Verkufer-Cockpit: Platzierung in der Suche


#    Argument: 'ns:SearchStandingDashboardType'

=cut

sub setSearchStanding {
  my $self = shift;
  $self->{'SearchStanding'} = shift
}

=head2 getSearchStanding()

  Returned: Conditionally
#    Returns: 'ns:SearchStandingDashboardType'

=cut

sub getSearchStanding {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SearchStanding'
		,'eBay::API::XML::DataType::SearchStandingDashboardType');
}


=head2 setSellerAccount()

Reminds you of the status of your latest invoice, including alerts to help 
you identify any problems with your account.

SeeLink: URL: http://pages.ebay.com/help/myebay/seller-dashboard.html#account
Title: About Your Seller Dashboard: Account Status
, URL: http://pages.ebay.de/help/myebay/seller-dashboard.html#account
Title: Zum Thema Verkufer-Cockpit: Kontostand


#    Argument: 'ns:SellerAccountDashboardType'

=cut

sub setSellerAccount {
  my $self = shift;
  $self->{'SellerAccount'} = shift
}

=head2 getSellerAccount()

  Returned: Conditionally
#    Returns: 'ns:SellerAccountDashboardType'

=cut

sub getSellerAccount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerAccount'
		,'eBay::API::XML::DataType::SellerAccountDashboardType');
}


=head2 setSellerFeeDiscount()

Provides information about the PowerSeller discount level you've earned, if any.
As a PowerSeller, you can earn discounts on your monthly invoice Final Value Fees 
based on how well you're rated as a seller. Only returned for members of the eBay US or Canada
PowerSeller program.

SeeLink: URL: http://pages.ebay.com/help/myebay/seller-dashboard.html#discount
Title: About Your Seller Dashboard: PowerSeller Discount
, URL: http://pages.ebay.de/help/myebay/seller-dashboard.html#discount
Title: Zum Thema Verkufer-Cockpit: PowerSeller-Rabatt


#    Argument: 'ns:SellerFeeDiscountDashboardType'

=cut

sub setSellerFeeDiscount {
  my $self = shift;
  $self->{'SellerFeeDiscount'} = shift
}

=head2 getSellerFeeDiscount()

  Returned: Conditionally
#    Returns: 'ns:SellerFeeDiscountDashboardType'

=cut

sub getSellerFeeDiscount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerFeeDiscount'
		,'eBay::API::XML::DataType::SellerFeeDiscountDashboardType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
