# FILE: install.tcl
#
# A script to complete the installation of a Tcl/Tk binary
# distribution on Windows NT

set rootdir [file dirname [file join [pwd] [info script]]]
regsub {\.} [info tclversion] {} suffix
set wish [file join $rootdir bin wish$suffix.exe]

# Add file associations as the Windows/Intel installer does
# NOTE: This might not be the best command line!
exec $env(COMSPEC) /c assoc .tcl=TclScript
set batchfile [open tmp.bat w]
puts $batchfile "ftype TclScript=\"$wish\" \"%%1\""
close $batchfile
exec tmp.bat
file delete tmp.bat

# Tcl/Tk no longer needs any entries in the registry

if 0 {
# Add keys to the Windows registry recording
# where Tcl/Tk is installed
if {![catch {package require registry}]} {
    set key HKEY_LOCAL_MACHINE
    foreach el [list SOFTWARE Scriptics Tcl [info tclversion]] {
        if {![llength [registry keys $key $el]]} {
            registry set [join [list $key \\ $el] ""]
        }
        append key "\\$el"
    }
    registry set $key Root $rootdir
} else {
    error "Install error: Can't access Windows registry."
}
}

