# FILE: uninstall.tcl
#
# A script to start the uninstallation of a Tcl/Tk binary
# distribution on Windows NT

# Remove file associations 
exec $env(COMSPEC) /c assoc .tcl=
exec $env(COMSPEC) /c ftype TclScript=

# Tcl/Tk no longer places any entries in the registry
if 0 {
# Remove keys from the Windows registry
if {![catch {package require registry}]} {
    set prefix HKEY_LOCAL_MACHINE\\SOFTWARE\\
    set elemlist [list Scriptics Tcl [info tclversion]]
    set key $prefix[join $elemlist \\]
    if {[catch {registry get $key Root}]} {
        exit
    }
    registry delete $key Root
    while {[llength $elemlist]} {
        set key $prefix[join $elemlist \\]
        set nval [llength [registry values $key]]
        set nkey [llength [registry keys $key]]
        if {$nval + $nkey} {
            break
        }
        registry delete $key
        set elemlist [lreplace $elemlist end end]
    }
} else {
    error "Uninstall error: Can't access Windows registry."
}
}

